/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file.util2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import projectkyoto.mmd.file.PMDMaterial;
import projectkyoto.mmd.file.PMDModel;
import projectkyoto.mmd.file.PMDSkinData;
import projectkyoto.mmd.file.PMDVertex;
import projectkyoto.mmd.file.util2.MeshData;
import projectkyoto.mmd.file.util2.SkinMeshData;
import projectkyoto.mmd.file.util2.VertIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeshConverter {
    PMDModel model;
    int maxBoneSize = 20;
    List<MeshData> meshDataList = new ArrayList<MeshData>();
    SkinMeshData skinMeshData;
    HashMap<PMDVertex, Integer> meshTmpVertMap = new HashMap();
    HashMap<PMDVertex, Integer> skinTmpVertMap = new HashMap();
    VertIndex tmpvi = new VertIndex(0);
    Set<VertIndex> skinVertSet = new HashSet<VertIndex>();

    public MeshConverter(PMDModel model) {
        this.model = model;
        this.skinMeshData = new SkinMeshData(this, model);
        this.initSkinVertSet();
    }

    private final void initSkinVertSet() {
        for (int skinCount = 0; skinCount < this.model.getSkinCount(); ++skinCount) {
            PMDSkinData skinData = this.model.getSkinData()[skinCount];
            if (skinData.getSkinType() != 0) continue;
            for (int skinVertCount = 0; skinVertCount < skinData.getSkinVertCount(); ++skinVertCount) {
                VertIndex vi = new VertIndex(skinData.getSkinVertData()[skinVertCount].getSkinVertIndex());
                this.skinVertSet.add(vi);
            }
        }
    }

    public void checkDupMaterial() {
        for (int i1 = 0; i1 < this.model.getMaterialCount(); ++i1) {
            for (int i2 = i1 + 1; i2 < this.model.getMaterialCount() && !this.model.getMaterial()[i1].equals(this.model.getMaterial()[i2]); ++i2) {
            }
        }
    }

    void printFaceVertSize() {
        for (int skinCount = 0; skinCount < this.model.getSkinCount(); ++skinCount) {
            PMDSkinData pMDSkinData = this.model.getSkinData()[skinCount];
        }
    }

    public void convertMesh() {
        int faceVertNo = 0;
        for (int materialNo = 0; materialNo < this.model.getMaterialCount(); ++materialNo) {
            PMDMaterial material = this.model.getMaterial()[materialNo];
            if (material.getFaceVertCount() == 0) continue;
            MeshData meshData = new MeshData(this.model, this.maxBoneSize, material);
            this.meshDataList.add(meshData);
            for (int materialFaceVertNo = 0; materialFaceVertNo < material.getFaceVertCount(); materialFaceVertNo += 3) {
                int i3;
                int i1 = this.model.getFaceVertIndex()[faceVertNo++];
                int i2 = this.model.getFaceVertIndex()[faceVertNo++];
                if (this.containsSkin(i1, i2, i3 = this.model.getFaceVertIndex()[faceVertNo++])) {
                    this.addSkinTriangle(material, i1, i2, i3);
                    continue;
                }
                if (meshData.addTriangle(this, i1, i2, i3)) continue;
                meshData = new MeshData(this.model, this.maxBoneSize, material);
                this.meshTmpVertMap.clear();
                this.meshDataList.add(meshData);
                meshData.addTriangle(this, i1, i2, i3);
            }
            if (meshData.getVertexList().size() != 0) continue;
            this.meshDataList.remove(this.meshDataList.size() - 1);
        }
        int vertSizeSum = 0;
        int boneSizeSum = 0;
        int indexSizeSum = 0;
        for (MeshData meshData : this.meshDataList) {
            vertSizeSum += meshData.getVertexList().size();
            boneSizeSum += meshData.getBoneList().size();
            indexSizeSum += meshData.getIndexList().size();
        }
        for (MeshData meshData : this.meshDataList) {
        }
    }

    void printMeshData(MeshData meshData) {
        System.out.println("vertSize = " + meshData.getVertexList().size() + " indexSize = " + meshData.getIndexList().size() + " boneSize = " + meshData.getBoneList().size());
    }

    boolean containsSkin(int i1, int i2, int i3) {
        return this.containsSkin(i1) || this.containsSkin(i2) || this.containsSkin(i3);
    }

    boolean containsSkin(int i) {
        this.tmpvi.index = i;
        return this.skinVertSet.contains(this.tmpvi);
    }

    boolean _containsSkin(int i) {
        for (int skinCount = 0; skinCount < this.model.getSkinCount(); ++skinCount) {
            PMDSkinData skinData = this.model.getSkinData()[skinCount];
            if (skinData.getSkinType() != 0) continue;
            for (int skinVertCount = 0; skinVertCount < skinData.getSkinVertCount(); ++skinVertCount) {
                if (i != skinData.getSkinVertData()[skinVertCount].getSkinVertIndex()) continue;
                return true;
            }
        }
        return false;
    }

    void addSkinTriangle(PMDMaterial material, int i1, int i2, int i3) {
        this.skinMeshData.addTriangle(this, material, i1, i2, i3);
    }

    public int getMaxBoneSize() {
        return this.maxBoneSize;
    }

    public void setMaxBoneSize(int maxBoneSize) {
        this.maxBoneSize = maxBoneSize;
    }

    public List<MeshData> getMeshDataList() {
        return this.meshDataList;
    }

    public void setMeshDataList(List<MeshData> meshDataList) {
        this.meshDataList = meshDataList;
    }

    public PMDModel getModel() {
        return this.model;
    }

    public void setModel(PMDModel model) {
        this.model = model;
    }

    public SkinMeshData getSkinMeshData() {
        return this.skinMeshData;
    }

    public void setSkinMeshData(SkinMeshData skinMeshData) {
        this.skinMeshData = skinMeshData;
    }
}

