/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file;

import java.io.IOException;
import projectkyoto.mmd.file.DataInputStreamLittleEndian;
import projectkyoto.mmd.file.PMDBone;

public class PMDBoneList {
    private int boneCount;
    private PMDBone[] bones;

    public PMDBoneList(DataInputStreamLittleEndian is) throws IOException {
        this.boneCount = is.readUnsignedShort();
        this.bones = new PMDBone[this.boneCount];
        for (int i = 0; i < this.boneCount; ++i) {
            this.bones[i] = new PMDBone(is);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{bouneCount = " + this.boneCount);
        sb.append(" bones = {\n");
        if (this.bones == null) {
            sb.append("null");
        } else {
            int i = 0;
            for (PMDBone bone : this.bones) {
                sb.append("boneIndex = " + i++ + " ");
                sb.append(bone);
            }
        }
        sb.append("}\n");
        return sb.toString();
    }

    public int getBoneCount() {
        return this.boneCount;
    }

    public void setBoneCount(int boneCount) {
        this.boneCount = boneCount;
    }

    public PMDBone[] getBones() {
        return this.bones;
    }

    public void setBones(PMDBone[] bones) {
        this.bones = bones;
    }
}

