/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.jme3.mmd;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Sphere;
import projectkyoto.mmd.file.PMDBone;
import projectkyoto.mmd.file.PMDModel;
import projectkyoto.mmd.file.PMDRigidBody;

public class RigidBodyConverter {
    PMDModel model;
    Node node;
    AssetManager assetManager;

    public RigidBodyConverter(PMDModel model, AssetManager assetManager) {
        this.model = model;
        this.assetManager = assetManager;
    }

    public Node convert(String nodeName) {
        this.node = new Node(nodeName);
        for (PMDRigidBody rigidBody : this.model.getRigidBodyList().getRigidBodyArray()) {
            this.createRigidBodyGeom(rigidBody);
        }
        return this.node;
    }

    public void createRigidBodyGeom(PMDRigidBody rigidBody) {
        Mesh mesh;
        Geometry geom = new Geometry(rigidBody.getRigidBodyName());
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        switch (rigidBody.getShapeType()) {
            case 0: {
                mesh = new Sphere(10, 10, rigidBody.getShapeW());
                break;
            }
            case 1: {
                mesh = new Box(rigidBody.getShapeW(), rigidBody.getShapeH(), rigidBody.getShapeD());
                break;
            }
            case 2: {
                mesh = new Sphere(10, 10, 0.5f);
                geom.scale(rigidBody.getShapeW() * 2.0f, rigidBody.getShapeH() + rigidBody.getShapeW() * 2.0f, rigidBody.getShapeW() * 2.0f);
                break;
            }
            default: {
                return;
            }
        }
        switch (rigidBody.getRigidBodyType()) {
            case 0: {
                mat.setColor("Color", ColorRGBA.Blue);
                break;
            }
            case 1: {
                mat.setColor("Color", ColorRGBA.Red);
                break;
            }
            case 2: {
                mat.setColor("Color", ColorRGBA.Green);
            }
        }
        geom.setMesh(mesh);
        geom.setMaterial(mat);
        mat.getAdditionalRenderState().setWireframe(true);
        mat.getAdditionalRenderState().setDepthTest(false);
        Vector3f v = new Vector3f(rigidBody.getPos().x, rigidBody.getPos().y, rigidBody.getPos().z);
        if (rigidBody.getRelBoneIndex() != 65535) {
            PMDBone bone = this.model.getBoneList().getBones()[rigidBody.getRelBoneIndex()];
            v.addLocal(bone.getBoneHeadPos().x, bone.getBoneHeadPos().y, bone.getBoneHeadPos().z);
        }
        geom.setQueueBucket(RenderQueue.Bucket.Transparent);
        if (rigidBody.getRigidBodyName().contains("\u3082\u3082") || !rigidBody.getRigidBodyName().contains("\uff7d\uff76\uff70\uff84")) {
            // empty if block
        }
        this.node.attachChild(geom);
    }
}

