/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.jme3.mmd;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.shape.Line;
import projectkyoto.mmd.file.PMDJoint;
import projectkyoto.mmd.file.PMDModel;

public class JointConverter {
    PMDModel model;
    Node node;
    AssetManager assetManager;

    public JointConverter(PMDModel model, AssetManager assetManager) {
        this.model = model;
        this.assetManager = assetManager;
    }

    public Node convert(String nodeName) {
        this.node = new Node(nodeName);
        for (PMDJoint joint : this.model.getJointList().getJointArray()) {
            this.createJointGeom(joint);
        }
        return this.node;
    }

    public void createJointGeom(PMDJoint joint) {
        Geometry geom = new Geometry(joint.getJointName());
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        Line mesh = new Line(Vector3f.ZERO, Vector3f.ZERO);
        mat.setColor("Color", ColorRGBA.White);
        geom.setMesh(mesh);
        geom.setMaterial(mat);
        mat.getAdditionalRenderState().setDepthTest(false);
        geom.setQueueBucket(RenderQueue.Bucket.Transparent);
        this.node.attachChild(geom);
    }
}

