/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.geomipmap;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingVolume;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResults;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.material.Material;
import com.jme3.math.FastMath;
import com.jme3.math.Ray;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.WireBox;
import com.jme3.terrain.ProgressMonitor;
import com.jme3.terrain.Terrain;
import com.jme3.terrain.geomipmap.NormalRecalcControl;
import com.jme3.terrain.geomipmap.TerrainLodControl;
import com.jme3.terrain.geomipmap.TerrainPatch;
import com.jme3.terrain.geomipmap.UpdatedTerrainPatch;
import com.jme3.terrain.geomipmap.lodcalc.LodCalculatorFactory;
import com.jme3.terrain.geomipmap.lodcalc.LodDistanceCalculatorFactory;
import com.jme3.terrain.geomipmap.picking.BresenhamTerrainPicker;
import com.jme3.terrain.geomipmap.picking.TerrainPickData;
import com.jme3.terrain.geomipmap.picking.TerrainPicker;
import com.jme3.util.BufferUtils;
import com.jme3.util.TangentBinormalGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerrainQuad
extends Node
implements Terrain {
    protected Vector2f offset;
    protected int totalSize;
    protected int size;
    protected int patchSize;
    protected Vector3f stepScale;
    protected float offsetAmount;
    protected int quadrant = 1;
    protected LodCalculatorFactory lodCalculatorFactory;
    protected List<Vector3f> lastCameraLocations;
    private boolean lodCalcRunning = false;
    private int maxLod = -1;
    private HashMap<String, UpdatedTerrainPatch> updatedPatches;
    private final Object updatePatchesLock = new Object();
    private BoundingBox affectedAreaBBox;
    private TerrainPicker picker;
    protected ExecutorService executor;

    protected ExecutorService createExecutorService() {
        return Executors.newSingleThreadExecutor(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread th = new Thread(r);
                th.setName("jME Terrain Thread");
                th.setDaemon(true);
                return th;
            }
        });
    }

    public TerrainQuad() {
        super("Terrain");
    }

    public TerrainQuad(String name, int patchSize, int totalSize, float[] heightMap) {
        this(name, patchSize, totalSize, heightMap, null);
    }

    public TerrainQuad(String name, int patchSize, int totalSize, float[] heightMap, LodCalculatorFactory lodCalculatorFactory) {
        this(name, patchSize, totalSize, Vector3f.UNIT_XYZ, heightMap, lodCalculatorFactory);
    }

    public TerrainQuad(String name, int patchSize, int size, int totalSize, float[] heightMap, LodCalculatorFactory lodCalculatorFactory) {
        this(name, patchSize, size, Vector3f.UNIT_XYZ, heightMap, totalSize, new Vector2f(), 0.0f, lodCalculatorFactory);
        this.affectedAreaBBox = new BoundingBox(new Vector3f(0.0f, 0.0f, 0.0f), size, Float.MAX_VALUE, size);
        this.fixNormalEdges(this.affectedAreaBBox);
        this.addControl(new NormalRecalcControl(this));
    }

    public TerrainQuad(String name, int patchSize, int size, Vector3f scale, float[] heightMap, LodCalculatorFactory lodCalculatorFactory) {
        this(name, patchSize, size, scale, heightMap, size, new Vector2f(), 0.0f, lodCalculatorFactory);
        this.affectedAreaBBox = new BoundingBox(new Vector3f(0.0f, 0.0f, 0.0f), size, Float.MAX_VALUE, size);
        this.fixNormalEdges(this.affectedAreaBBox);
        this.addControl(new NormalRecalcControl(this));
    }

    protected TerrainQuad(String name, int patchSize, int size, Vector3f scale, float[] heightMap, int totalSize, Vector2f offset, float offsetAmount, LodCalculatorFactory lodCalculatorFactory) {
        super(name);
        if (!FastMath.isPowerOfTwo(size - 1)) {
            throw new RuntimeException("size given: " + size + "  Terrain quad sizes may only be (2^N + 1)");
        }
        if (heightMap == null) {
            heightMap = this.generateDefaultHeightMap(size);
        }
        this.offset = offset;
        this.offsetAmount = offsetAmount;
        this.totalSize = totalSize;
        this.size = size;
        this.patchSize = patchSize;
        this.stepScale = scale;
        this.lodCalculatorFactory = lodCalculatorFactory;
        this.split(patchSize, heightMap);
    }

    public void setLodCalculatorFactory(LodCalculatorFactory lodCalculatorFactory) {
        if (this.children != null) {
            int i = this.children.size();
            while (--i >= 0) {
                Spatial child = (Spatial)this.children.get(i);
                if (child instanceof TerrainQuad) {
                    ((TerrainQuad)child).setLodCalculatorFactory(lodCalculatorFactory);
                    continue;
                }
                if (!(child instanceof TerrainPatch)) continue;
                ((TerrainPatch)child).setLodCalculator(lodCalculatorFactory.createCalculator((TerrainPatch)child));
            }
        }
    }

    private float[] generateDefaultHeightMap(int size) {
        float[] heightMap = new float[size * size];
        return heightMap;
    }

    @Override
    public void update(List<Vector3f> locations) {
        this.updateLOD(locations);
    }

    protected void updateNormals() {
        if (this.needToRecalculateNormals()) {
            this.fixNormals(this.affectedAreaBBox);
            this.fixNormalEdges(this.affectedAreaBBox);
            this.setNormalRecalcNeeded(null);
        }
    }

    protected void updateLOD(List<Vector3f> locations) {
        this.updateQuadLODs();
        if (this.lastCameraLocations != null) {
            if (this.lastCameraLocationsTheSame(locations)) {
                return;
            }
        } else {
            this.lastCameraLocations = this.cloneVectorList(locations);
            return;
        }
        this.lastCameraLocations = this.cloneVectorList(locations);
        if (this.isLodCalcRunning()) {
            return;
        }
        if (this.getParent() instanceof TerrainQuad) {
            return;
        }
        if (this.executor == null) {
            this.executor = this.createExecutorService();
        }
        UpdateLOD updateLodThread = new UpdateLOD(locations);
        this.executor.execute(updateLodThread);
    }

    private synchronized boolean isLodCalcRunning() {
        return this.lodCalcRunning;
    }

    private synchronized void setLodCalcRunning(boolean running) {
        this.lodCalcRunning = running;
    }

    private List<Vector3f> cloneVectorList(List<Vector3f> locations) {
        ArrayList<Vector3f> cloned = new ArrayList<Vector3f>();
        for (Vector3f l : locations) {
            cloned.add(l.clone());
        }
        return cloned;
    }

    private boolean lastCameraLocationsTheSame(List<Vector3f> locations) {
        boolean theSame = true;
        for (Vector3f l : locations) {
            for (Vector3f v : this.lastCameraLocations) {
                if (v.equals(l)) continue;
                theSame = false;
                return false;
            }
        }
        return theSame;
    }

    private int collideWithRay(Ray ray, CollisionResults results) {
        Vector3f intersection;
        if (this.picker == null) {
            this.picker = new BresenhamTerrainPicker(this);
        }
        if ((intersection = this.picker.getTerrainIntersection(ray, results)) != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public void generateEntropy(ProgressMonitor progressMonitor) {
        if (this.isRootQuad() && progressMonitor != null) {
            int numCalc = (this.totalSize - 1) / (this.patchSize - 1);
            progressMonitor.setMonitorMax(numCalc * numCalc);
        }
        if (this.children != null) {
            int i = this.children.size();
            while (--i >= 0) {
                Spatial child = (Spatial)this.children.get(i);
                if (child instanceof TerrainQuad) {
                    ((TerrainQuad)child).generateEntropy(progressMonitor);
                    continue;
                }
                if (!(child instanceof TerrainPatch)) continue;
                ((TerrainPatch)child).generateLodEntropies();
                if (progressMonitor == null) continue;
                progressMonitor.incrementProgress(1.0f);
            }
        }
        if (this.isRootQuad() && progressMonitor != null) {
            progressMonitor.progressComplete();
        }
    }

    protected boolean isRootQuad() {
        return this.getParent() != null && !(this.getParent() instanceof TerrainQuad);
    }

    @Override
    public Material getMaterial() {
        if (this.children != null) {
            int i = this.children.size();
            while (--i >= 0) {
                Spatial child = (Spatial)this.children.get(i);
                if (child instanceof TerrainQuad) {
                    return ((TerrainQuad)child).getMaterial();
                }
                if (!(child instanceof TerrainPatch)) continue;
                return ((TerrainPatch)child).getMaterial();
            }
        }
        return null;
    }

    @Override
    public float getTextureCoordinateScale() {
        return 1.0f / (float)this.totalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpdateQuadLODs(HashMap<String, UpdatedTerrainPatch> updated) {
        Object object = this.updatePatchesLock;
        synchronized (object) {
            this.updatedPatches = updated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateQuadLODs() {
        Object object = this.updatePatchesLock;
        synchronized (object) {
            if (this.updatedPatches == null || this.updatedPatches.isEmpty()) {
                return;
            }
            for (UpdatedTerrainPatch utp : this.updatedPatches.values()) {
                utp.updateAll();
            }
            this.updatedPatches.clear();
        }
    }

    protected boolean calculateLod(List<Vector3f> location, HashMap<String, UpdatedTerrainPatch> updates) {
        boolean lodChanged = false;
        if (this.children != null) {
            int i = this.children.size();
            while (--i >= 0) {
                boolean b;
                Spatial child = (Spatial)this.children.get(i);
                if (child instanceof TerrainQuad) {
                    b = ((TerrainQuad)child).calculateLod(location, updates);
                    if (!b) continue;
                    lodChanged = true;
                    continue;
                }
                if (!(child instanceof TerrainPatch) || !(b = ((TerrainPatch)child).calculateLod(location, updates))) continue;
                lodChanged = true;
            }
        }
        return lodChanged;
    }

    protected synchronized void findNeighboursLod(HashMap<String, UpdatedTerrainPatch> updated) {
        if (this.children != null) {
            int x = this.children.size();
            while (--x >= 0) {
                Spatial child = (Spatial)this.children.get(x);
                if (child instanceof TerrainQuad) {
                    ((TerrainQuad)child).findNeighboursLod(updated);
                    continue;
                }
                if (!(child instanceof TerrainPatch)) continue;
                TerrainPatch patch = (TerrainPatch)child;
                if (!patch.searchedForNeighboursAlready) {
                    patch.rightNeighbour = this.findRightPatch(patch);
                    patch.bottomNeighbour = this.findDownPatch(patch);
                    patch.leftNeighbour = this.findLeftPatch(patch);
                    patch.topNeighbour = this.findTopPatch(patch);
                    patch.searchedForNeighboursAlready = true;
                }
                TerrainPatch right = patch.rightNeighbour;
                TerrainPatch down = patch.bottomNeighbour;
                UpdatedTerrainPatch utp = updated.get(patch.getName());
                if (utp == null) {
                    utp = new UpdatedTerrainPatch(patch, patch.lod);
                    updated.put(utp.getName(), utp);
                }
                if (right != null) {
                    UpdatedTerrainPatch utpR = updated.get(right.getName());
                    if (utpR == null) {
                        utpR = new UpdatedTerrainPatch(right, right.lod);
                        updated.put(utpR.getName(), utpR);
                    }
                    utp.setRightLod(utpR.getNewLod());
                    utpR.setLeftLod(utp.getNewLod());
                }
                if (down == null) continue;
                UpdatedTerrainPatch utpD = updated.get(down.getName());
                if (utpD == null) {
                    utpD = new UpdatedTerrainPatch(down, down.lod);
                    updated.put(utpD.getName(), utpD);
                }
                utp.setBottomLod(utpD.getNewLod());
                utpD.setTopLod(utp.getNewLod());
            }
        }
    }

    protected synchronized void fixEdges(HashMap<String, UpdatedTerrainPatch> updated) {
        if (this.children != null) {
            int x = this.children.size();
            while (--x >= 0) {
                TerrainPatch patch;
                UpdatedTerrainPatch utp;
                Spatial child = (Spatial)this.children.get(x);
                if (child instanceof TerrainQuad) {
                    ((TerrainQuad)child).fixEdges(updated);
                    continue;
                }
                if (!(child instanceof TerrainPatch) || !(utp = updated.get((patch = (TerrainPatch)child).getName())).lodChanged()) continue;
                if (!patch.searchedForNeighboursAlready) {
                    patch.rightNeighbour = this.findRightPatch(patch);
                    patch.bottomNeighbour = this.findDownPatch(patch);
                    patch.leftNeighbour = this.findLeftPatch(patch);
                    patch.topNeighbour = this.findTopPatch(patch);
                    patch.searchedForNeighboursAlready = true;
                }
                TerrainPatch right = patch.rightNeighbour;
                TerrainPatch down = patch.bottomNeighbour;
                TerrainPatch top = patch.topNeighbour;
                TerrainPatch left = patch.leftNeighbour;
                if (right != null) {
                    UpdatedTerrainPatch utpR = updated.get(right.getName());
                    if (utpR == null) {
                        utpR = new UpdatedTerrainPatch(right, right.lod);
                        updated.put(utpR.getName(), utpR);
                    }
                    utpR.setFixEdges(true);
                }
                if (down != null) {
                    UpdatedTerrainPatch utpD = updated.get(down.getName());
                    if (utpD == null) {
                        utpD = new UpdatedTerrainPatch(down, down.lod);
                        updated.put(utpD.getName(), utpD);
                    }
                    utpD.setFixEdges(true);
                }
                if (top != null) {
                    UpdatedTerrainPatch utpT = updated.get(top.getName());
                    if (utpT == null) {
                        utpT = new UpdatedTerrainPatch(top, top.lod);
                        updated.put(utpT.getName(), utpT);
                    }
                    utpT.setFixEdges(true);
                }
                if (left == null) continue;
                UpdatedTerrainPatch utpL = updated.get(left.getName());
                if (utpL == null) {
                    utpL = new UpdatedTerrainPatch(left, left.lod);
                    updated.put(utpL.getName(), utpL);
                }
                utpL.setFixEdges(true);
            }
        }
    }

    protected synchronized void reIndexPages(HashMap<String, UpdatedTerrainPatch> updated) {
        if (this.children != null) {
            int i = this.children.size();
            while (--i >= 0) {
                Spatial child = (Spatial)this.children.get(i);
                if (child instanceof TerrainQuad) {
                    ((TerrainQuad)child).reIndexPages(updated);
                    continue;
                }
                if (!(child instanceof TerrainPatch)) continue;
                ((TerrainPatch)child).reIndexGeometry(updated);
            }
        }
    }

    protected void split(int blockSize, float[] heightMap) {
        if ((this.size >> 1) + 1 <= blockSize) {
            this.createQuadPatch(heightMap);
        } else {
            this.createQuad(blockSize, heightMap);
        }
    }

    protected void createQuad(int blockSize, float[] heightMap) {
        int quarterSize = this.size >> 2;
        int split = this.size + 1 >> 1;
        Vector2f tempOffset = new Vector2f();
        this.offsetAmount += (float)quarterSize;
        if (this.lodCalculatorFactory == null) {
            this.lodCalculatorFactory = new LodDistanceCalculatorFactory();
        }
        float[] heightBlock1 = this.createHeightSubBlock(heightMap, 0, 0, split);
        Vector3f origin1 = new Vector3f((float)(-quarterSize) * this.stepScale.x, 0.0f, (float)(-quarterSize) * this.stepScale.z);
        tempOffset.x = this.offset.x;
        tempOffset.y = this.offset.y;
        tempOffset.x += origin1.x;
        tempOffset.y += origin1.z;
        TerrainQuad quad1 = new TerrainQuad(this.getName() + "Quad1", blockSize, split, this.stepScale, heightBlock1, this.totalSize, tempOffset, this.offsetAmount, this.lodCalculatorFactory);
        quad1.setLocalTranslation(origin1);
        quad1.quadrant = 1;
        this.attachChild(quad1);
        float[] heightBlock2 = this.createHeightSubBlock(heightMap, 0, split - 1, split);
        Vector3f origin2 = new Vector3f((float)(-quarterSize) * this.stepScale.x, 0.0f, (float)quarterSize * this.stepScale.z);
        tempOffset = new Vector2f();
        tempOffset.x = this.offset.x;
        tempOffset.y = this.offset.y;
        tempOffset.x += origin2.x;
        tempOffset.y += origin2.z;
        TerrainQuad quad2 = new TerrainQuad(this.getName() + "Quad2", blockSize, split, this.stepScale, heightBlock2, this.totalSize, tempOffset, this.offsetAmount, this.lodCalculatorFactory);
        quad2.setLocalTranslation(origin2);
        quad2.quadrant = 2;
        this.attachChild(quad2);
        float[] heightBlock3 = this.createHeightSubBlock(heightMap, split - 1, 0, split);
        Vector3f origin3 = new Vector3f((float)quarterSize * this.stepScale.x, 0.0f, (float)(-quarterSize) * this.stepScale.z);
        tempOffset = new Vector2f();
        tempOffset.x = this.offset.x;
        tempOffset.y = this.offset.y;
        tempOffset.x += origin3.x;
        tempOffset.y += origin3.z;
        TerrainQuad quad3 = new TerrainQuad(this.getName() + "Quad3", blockSize, split, this.stepScale, heightBlock3, this.totalSize, tempOffset, this.offsetAmount, this.lodCalculatorFactory);
        quad3.setLocalTranslation(origin3);
        quad3.quadrant = 3;
        this.attachChild(quad3);
        float[] heightBlock4 = this.createHeightSubBlock(heightMap, split - 1, split - 1, split);
        Vector3f origin4 = new Vector3f((float)quarterSize * this.stepScale.x, 0.0f, (float)quarterSize * this.stepScale.z);
        tempOffset = new Vector2f();
        tempOffset.x = this.offset.x;
        tempOffset.y = this.offset.y;
        tempOffset.x += origin4.x;
        tempOffset.y += origin4.z;
        TerrainQuad quad4 = new TerrainQuad(this.getName() + "Quad4", blockSize, split, this.stepScale, heightBlock4, this.totalSize, tempOffset, this.offsetAmount, this.lodCalculatorFactory);
        quad4.setLocalTranslation(origin4);
        quad4.quadrant = 4;
        this.attachChild(quad4);
    }

    public void generateDebugTangents(Material mat) {
        int x = this.children.size();
        while (--x >= 0) {
            Spatial child = (Spatial)this.children.get(x);
            if (child instanceof TerrainQuad) {
                ((TerrainQuad)child).generateDebugTangents(mat);
                continue;
            }
            if (!(child instanceof TerrainPatch)) continue;
            Geometry debug = new Geometry("Debug " + this.name, TangentBinormalGenerator.genTbnLines(((TerrainPatch)child).getMesh(), 0.1f));
            this.attachChild(debug);
            debug.setLocalTranslation(child.getLocalTranslation());
            debug.setCullHint(Spatial.CullHint.Never);
            debug.setMaterial(mat);
        }
    }

    protected void createQuadPatch(float[] heightMap) {
        int quarterSize = this.size >> 2;
        int halfSize = this.size >> 1;
        int split = this.size + 1 >> 1;
        if (this.lodCalculatorFactory == null) {
            this.lodCalculatorFactory = new LodDistanceCalculatorFactory();
        }
        this.offsetAmount += (float)quarterSize;
        float[] heightBlock1 = this.createHeightSubBlock(heightMap, 0, 0, split);
        Vector3f origin1 = new Vector3f((float)(-halfSize) * this.stepScale.x, 0.0f, (float)(-halfSize) * this.stepScale.z);
        Vector2f tempOffset1 = new Vector2f();
        tempOffset1.x = this.offset.x;
        tempOffset1.y = this.offset.y;
        tempOffset1.x += origin1.x / 2.0f;
        tempOffset1.y += origin1.z / 2.0f;
        TerrainPatch patch1 = new TerrainPatch(this.getName() + "Patch1", split, this.stepScale, heightBlock1, origin1, this.totalSize, tempOffset1, this.offsetAmount);
        patch1.setQuadrant((short)1);
        this.attachChild(patch1);
        patch1.setModelBound(new BoundingBox());
        patch1.updateModelBound();
        patch1.setLodCalculator(this.lodCalculatorFactory);
        TangentBinormalGenerator.generate(patch1);
        float[] heightBlock2 = this.createHeightSubBlock(heightMap, 0, split - 1, split);
        Vector3f origin2 = new Vector3f((float)(-halfSize) * this.stepScale.x, 0.0f, 0.0f);
        Vector2f tempOffset2 = new Vector2f();
        tempOffset2.x = this.offset.x;
        tempOffset2.y = this.offset.y;
        tempOffset2.x += origin1.x / 2.0f;
        tempOffset2.y += (float)quarterSize * this.stepScale.z;
        TerrainPatch patch2 = new TerrainPatch(this.getName() + "Patch2", split, this.stepScale, heightBlock2, origin2, this.totalSize, tempOffset2, this.offsetAmount);
        patch2.setQuadrant((short)2);
        this.attachChild(patch2);
        patch2.setModelBound(new BoundingBox());
        patch2.updateModelBound();
        patch2.setLodCalculator(this.lodCalculatorFactory);
        TangentBinormalGenerator.generate(patch2);
        float[] heightBlock3 = this.createHeightSubBlock(heightMap, split - 1, 0, split);
        Vector3f origin3 = new Vector3f(0.0f, 0.0f, (float)(-halfSize) * this.stepScale.z);
        Vector2f tempOffset3 = new Vector2f();
        tempOffset3.x = this.offset.x;
        tempOffset3.y = this.offset.y;
        tempOffset3.x += (float)quarterSize * this.stepScale.x;
        tempOffset3.y += origin3.z / 2.0f;
        TerrainPatch patch3 = new TerrainPatch(this.getName() + "Patch3", split, this.stepScale, heightBlock3, origin3, this.totalSize, tempOffset3, this.offsetAmount);
        patch3.setQuadrant((short)3);
        this.attachChild(patch3);
        patch3.setModelBound(new BoundingBox());
        patch3.updateModelBound();
        patch3.setLodCalculator(this.lodCalculatorFactory);
        TangentBinormalGenerator.generate(patch3);
        float[] heightBlock4 = this.createHeightSubBlock(heightMap, split - 1, split - 1, split);
        Vector3f origin4 = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector2f tempOffset4 = new Vector2f();
        tempOffset4.x = this.offset.x;
        tempOffset4.y = this.offset.y;
        tempOffset4.x += (float)quarterSize * this.stepScale.x;
        tempOffset4.y += (float)quarterSize * this.stepScale.z;
        TerrainPatch patch4 = new TerrainPatch(this.getName() + "Patch4", split, this.stepScale, heightBlock4, origin4, this.totalSize, tempOffset4, this.offsetAmount);
        patch4.setQuadrant((short)4);
        this.attachChild(patch4);
        patch4.setModelBound(new BoundingBox());
        patch4.updateModelBound();
        patch4.setLodCalculator(this.lodCalculatorFactory);
        TangentBinormalGenerator.generate(patch4);
    }

    public float[] createHeightSubBlock(float[] heightMap, int x, int y, int side) {
        float[] rVal = new float[side * side];
        int bsize = (int)FastMath.sqrt(heightMap.length);
        int count = 0;
        for (int i = y; i < side + y; ++i) {
            for (int j = x; j < side + x; ++j) {
                if (j < bsize && i < bsize) {
                    rVal[count] = heightMap[j + i * bsize];
                }
                ++count;
            }
        }
        return rVal;
    }

    public void attachBoundChildren(Node parent) {
        for (int i = 0; i < this.getQuantity(); ++i) {
            BoundingVolume bv;
            if (this.getChild(i) instanceof TerrainQuad) {
                ((TerrainQuad)this.getChild(i)).attachBoundChildren(parent);
                continue;
            }
            if (!(this.getChild(i) instanceof TerrainPatch) || !((bv = this.getChild(i).getWorldBound()) instanceof BoundingBox)) continue;
            this.attachBoundingBox((BoundingBox)bv, parent);
        }
        BoundingVolume bv = this.getWorldBound();
        if (bv instanceof BoundingBox) {
            this.attachBoundingBox((BoundingBox)bv, parent);
        }
    }

    private void attachBoundingBox(BoundingBox bb, Node parent) {
        WireBox wb = new WireBox(bb.getXExtent(), bb.getYExtent(), bb.getZExtent());
        Geometry g = new Geometry();
        g.setMesh(wb);
        g.setLocalTranslation(bb.getCenter());
        parent.attachChild(g);
    }

    protected void setNormalRecalcNeeded(Vector2f changedPoint) {
        if (changedPoint == null) {
            this.affectedAreaBBox = null;
            return;
        }
        if (this.affectedAreaBBox == null) {
            this.affectedAreaBBox = new BoundingBox(new Vector3f(changedPoint.x, 0.0f, changedPoint.y), 0.5f, Float.MAX_VALUE, 0.5f);
        } else {
            this.affectedAreaBBox.mergeLocal(new BoundingBox(new Vector3f(changedPoint.x, 0.0f, changedPoint.y), 0.5f, Float.MAX_VALUE, 0.5f));
        }
    }

    protected boolean needToRecalculateNormals() {
        return this.affectedAreaBBox != null;
    }

    @Override
    public float getHeightmapHeight(Vector2f xz) {
        int halfSize = this.totalSize / 2;
        int x = Math.round(xz.x / this.getLocalScale().x + (float)halfSize);
        int z = Math.round(xz.y / this.getLocalScale().z + (float)halfSize);
        return this.getHeightmapHeight(x, z);
    }

    protected float getHeightmapHeight(int x, int z) {
        int quad = this.findQuadrant(x, z);
        int split = this.size + 1 >> 1;
        if (this.children != null) {
            int i = this.children.size();
            while (--i >= 0) {
                Spatial spat = (Spatial)this.children.get(i);
                int col = x;
                int row = z;
                boolean match = false;
                int childQuadrant = 0;
                if (spat instanceof TerrainQuad) {
                    childQuadrant = ((TerrainQuad)spat).getQuadrant();
                } else if (spat instanceof TerrainPatch) {
                    childQuadrant = ((TerrainPatch)spat).getQuadrant();
                }
                if (childQuadrant == 1 && (quad & 1) != 0) {
                    match = true;
                } else if (childQuadrant == 2 && (quad & 2) != 0) {
                    row = z - split + 1;
                    match = true;
                } else if (childQuadrant == 3 && (quad & 4) != 0) {
                    col = x - split + 1;
                    match = true;
                } else if (childQuadrant == 4 && (quad & 8) != 0) {
                    col = x - split + 1;
                    row = z - split + 1;
                    match = true;
                }
                if (!match) continue;
                if (spat instanceof TerrainQuad) {
                    return ((TerrainQuad)spat).getHeightmapHeight(col, row);
                }
                if (!(spat instanceof TerrainPatch)) continue;
                return ((TerrainPatch)spat).getHeightmapHeight(col, row);
            }
        }
        return Float.NaN;
    }

    @Override
    public float getHeight(Vector2f xz) {
        float x = (xz.x - this.getLocalTranslation().x) / this.getLocalScale().x + (float)this.totalSize / 2.0f;
        float z = (xz.y - this.getLocalTranslation().z) / this.getLocalScale().z + (float)this.totalSize / 2.0f;
        return this.getHeight(x, z, xz);
    }

    protected float getHeight(float x, float z, Vector2f xz) {
        CollisionResults cr;
        float topLeft = this.getHeightmapHeight((int)FastMath.floor(x), (int)FastMath.ceil(z));
        float topRight = this.getHeightmapHeight((int)FastMath.ceil(x), (int)FastMath.ceil(z));
        float bottomLeft = this.getHeightmapHeight((int)FastMath.floor(x), (int)FastMath.floor(z));
        float bottomRight = this.getHeightmapHeight((int)FastMath.ceil(x), (int)FastMath.floor(z));
        float max = Math.max(Math.max(Math.max(topLeft, topRight), bottomRight), bottomLeft);
        Ray ray = new Ray(new Vector3f(xz.x, (max *= this.getWorldScale().y) + 10.0f, xz.y), new Vector3f(0.0f, -1.0f, 0.0f).normalizeLocal());
        int num = this.collideWith(ray, cr = new CollisionResults());
        if (num > 0) {
            return cr.getClosestCollision().getContactPoint().y;
        }
        return 0.0f;
    }

    @Override
    public void setHeight(Vector2f xz, float height) {
        ArrayList<Vector2f> coord = new ArrayList<Vector2f>();
        coord.add(xz);
        ArrayList<Float> h = new ArrayList<Float>();
        h.add(Float.valueOf(height));
        this.setHeight(coord, h);
    }

    @Override
    public void adjustHeight(Vector2f xz, float delta) {
        ArrayList<Vector2f> coord = new ArrayList<Vector2f>();
        coord.add(xz);
        ArrayList<Float> h = new ArrayList<Float>();
        h.add(Float.valueOf(delta));
        this.adjustHeight(coord, h);
    }

    @Override
    public void setHeight(List<Vector2f> xz, List<Float> height) {
        this.setHeight(xz, height, true);
    }

    @Override
    public void adjustHeight(List<Vector2f> xz, List<Float> height) {
        this.setHeight(xz, height, false);
    }

    protected void setHeight(List<Vector2f> xz, List<Float> height, boolean overrideHeight) {
        int i;
        if (xz.size() != height.size()) {
            throw new IllegalArgumentException("Both lists must be the same length!");
        }
        int halfSize = this.totalSize / 2;
        ArrayList<LocationHeight> locations = new ArrayList<LocationHeight>();
        for (i = 0; i < xz.size(); ++i) {
            int x = Math.round(xz.get((int)i).x / this.getLocalScale().x + (float)halfSize);
            int z = Math.round(xz.get((int)i).y / this.getLocalScale().z + (float)halfSize);
            locations.add(new LocationHeight(x, z, height.get(i).floatValue()));
        }
        this.setHeight(locations, overrideHeight);
        for (i = 0; i < xz.size(); ++i) {
            this.setNormalRecalcNeeded(xz.get(i));
        }
    }

    protected void setHeight(List<LocationHeight> locations, boolean overrideHeight) {
        if (this.children == null) {
            return;
        }
        ArrayList<LocationHeight> quadLH1 = new ArrayList<LocationHeight>();
        ArrayList<LocationHeight> quadLH2 = new ArrayList<LocationHeight>();
        ArrayList<LocationHeight> quadLH3 = new ArrayList<LocationHeight>();
        ArrayList<LocationHeight> quadLH4 = new ArrayList<LocationHeight>();
        Spatial quad1 = null;
        Spatial quad2 = null;
        Spatial quad3 = null;
        Spatial quad4 = null;
        int i = this.children.size();
        while (--i >= 0) {
            Spatial spat = (Spatial)this.children.get(i);
            int childQuadrant = 0;
            if (spat instanceof TerrainQuad) {
                childQuadrant = ((TerrainQuad)spat).getQuadrant();
            } else if (spat instanceof TerrainPatch) {
                childQuadrant = ((TerrainPatch)spat).getQuadrant();
            }
            if (childQuadrant == 1) {
                quad1 = spat;
                continue;
            }
            if (childQuadrant == 2) {
                quad2 = spat;
                continue;
            }
            if (childQuadrant == 3) {
                quad3 = spat;
                continue;
            }
            if (childQuadrant != 4) continue;
            quad4 = spat;
        }
        int split = this.size + 1 >> 1;
        for (LocationHeight lh : locations) {
            int quad = this.findQuadrant(lh.x, lh.z);
            int col = lh.x;
            int row = lh.z;
            if ((quad & 1) != 0) {
                quadLH1.add(lh);
            }
            if ((quad & 2) != 0) {
                row = lh.z - split + 1;
                quadLH2.add(new LocationHeight(lh.x, row, lh.h));
            }
            if ((quad & 4) != 0) {
                col = lh.x - split + 1;
                quadLH3.add(new LocationHeight(col, lh.z, lh.h));
            }
            if ((quad & 8) == 0) continue;
            col = lh.x - split + 1;
            row = lh.z - split + 1;
            quadLH4.add(new LocationHeight(col, row, lh.h));
        }
        if (!quadLH1.isEmpty()) {
            if (quad1 instanceof TerrainQuad) {
                ((TerrainQuad)quad1).setHeight(quadLH1, overrideHeight);
            } else if (quad1 instanceof TerrainPatch) {
                ((TerrainPatch)quad1).setHeight(quadLH1, overrideHeight);
            }
        }
        if (!quadLH2.isEmpty()) {
            if (quad2 instanceof TerrainQuad) {
                ((TerrainQuad)quad2).setHeight(quadLH2, overrideHeight);
            } else if (quad2 instanceof TerrainPatch) {
                ((TerrainPatch)quad2).setHeight(quadLH2, overrideHeight);
            }
        }
        if (!quadLH3.isEmpty()) {
            if (quad3 instanceof TerrainQuad) {
                ((TerrainQuad)quad3).setHeight(quadLH3, overrideHeight);
            } else if (quad3 instanceof TerrainPatch) {
                ((TerrainPatch)quad3).setHeight(quadLH3, overrideHeight);
            }
        }
        if (!quadLH4.isEmpty()) {
            if (quad4 instanceof TerrainQuad) {
                ((TerrainQuad)quad4).setHeight(quadLH4, overrideHeight);
            } else if (quad4 instanceof TerrainPatch) {
                ((TerrainPatch)quad4).setHeight(quadLH4, overrideHeight);
            }
        }
    }

    protected boolean isPointOnTerrain(int x, int z) {
        return x >= 0 && x <= this.totalSize && z >= 0 && z <= this.totalSize;
    }

    @Override
    public int getTerrainSize() {
        return this.totalSize;
    }

    private int findQuadrant(int x, int y) {
        int split = this.size + 1 >> 1;
        int quads = 0;
        if (x < split && y < split) {
            quads |= 1;
        }
        if (x < split && y >= split - 1) {
            quads |= 2;
        }
        if (x >= split - 1 && y < split) {
            quads |= 4;
        }
        if (x >= split - 1 && y >= split - 1) {
            quads |= 8;
        }
        return quads;
    }

    @Override
    public void setLocked(boolean locked) {
        for (int i = 0; i < this.getQuantity(); ++i) {
            if (this.getChild(i) instanceof TerrainQuad) {
                ((TerrainQuad)this.getChild(i)).setLocked(locked);
                continue;
            }
            if (!(this.getChild(i) instanceof TerrainPatch)) continue;
            if (locked) {
                ((TerrainPatch)this.getChild(i)).lockMesh();
                continue;
            }
            ((TerrainPatch)this.getChild(i)).unlockMesh();
        }
    }

    public int getQuadrant() {
        return this.quadrant;
    }

    public void setQuadrant(short quadrant) {
        this.quadrant = quadrant;
    }

    protected TerrainPatch getPatch(int quad) {
        if (this.children != null) {
            int x = this.children.size();
            while (--x >= 0) {
                TerrainPatch tb;
                Spatial child = (Spatial)this.children.get(x);
                if (!(child instanceof TerrainPatch) || (tb = (TerrainPatch)child).getQuadrant() != quad) continue;
                return tb;
            }
        }
        return null;
    }

    protected TerrainQuad getQuad(int quad) {
        if (this.children != null) {
            int x = this.children.size();
            while (--x >= 0) {
                TerrainQuad tq;
                Spatial child = (Spatial)this.children.get(x);
                if (!(child instanceof TerrainQuad) || (tq = (TerrainQuad)child).getQuadrant() != quad) continue;
                return tq;
            }
        }
        return null;
    }

    protected TerrainPatch findRightPatch(TerrainPatch tp) {
        TerrainQuad quad;
        if (tp.getQuadrant() == 1) {
            return this.getPatch(3);
        }
        if (tp.getQuadrant() == 2) {
            return this.getPatch(4);
        }
        if (tp.getQuadrant() == 3) {
            TerrainQuad quad2 = this.findRightQuad();
            if (quad2 != null) {
                return quad2.getPatch(1);
            }
        } else if (tp.getQuadrant() == 4 && (quad = this.findRightQuad()) != null) {
            return quad.getPatch(2);
        }
        return null;
    }

    protected TerrainPatch findDownPatch(TerrainPatch tp) {
        TerrainQuad quad;
        if (tp.getQuadrant() == 1) {
            return this.getPatch(2);
        }
        if (tp.getQuadrant() == 3) {
            return this.getPatch(4);
        }
        if (tp.getQuadrant() == 2) {
            TerrainQuad quad2 = this.findDownQuad();
            if (quad2 != null) {
                return quad2.getPatch(1);
            }
        } else if (tp.getQuadrant() == 4 && (quad = this.findDownQuad()) != null) {
            return quad.getPatch(3);
        }
        return null;
    }

    protected TerrainPatch findTopPatch(TerrainPatch tp) {
        TerrainQuad quad;
        if (tp.getQuadrant() == 2) {
            return this.getPatch(1);
        }
        if (tp.getQuadrant() == 4) {
            return this.getPatch(3);
        }
        if (tp.getQuadrant() == 1) {
            TerrainQuad quad2 = this.findTopQuad();
            if (quad2 != null) {
                return quad2.getPatch(2);
            }
        } else if (tp.getQuadrant() == 3 && (quad = this.findTopQuad()) != null) {
            return quad.getPatch(4);
        }
        return null;
    }

    protected TerrainPatch findLeftPatch(TerrainPatch tp) {
        TerrainQuad quad;
        if (tp.getQuadrant() == 3) {
            return this.getPatch(1);
        }
        if (tp.getQuadrant() == 4) {
            return this.getPatch(2);
        }
        if (tp.getQuadrant() == 1) {
            TerrainQuad quad2 = this.findLeftQuad();
            if (quad2 != null) {
                return quad2.getPatch(3);
            }
        } else if (tp.getQuadrant() == 2 && (quad = this.findLeftQuad()) != null) {
            return quad.getPatch(4);
        }
        return null;
    }

    protected TerrainQuad findRightQuad() {
        TerrainQuad quad;
        if (this.getParent() == null || !(this.getParent() instanceof TerrainQuad)) {
            return null;
        }
        TerrainQuad pQuad = (TerrainQuad)this.getParent();
        if (this.quadrant == 1) {
            return pQuad.getQuad(3);
        }
        if (this.quadrant == 2) {
            return pQuad.getQuad(4);
        }
        if (this.quadrant == 3) {
            TerrainQuad quad2 = pQuad.findRightQuad();
            if (quad2 != null) {
                return quad2.getQuad(1);
            }
        } else if (this.quadrant == 4 && (quad = pQuad.findRightQuad()) != null) {
            return quad.getQuad(2);
        }
        return null;
    }

    protected TerrainQuad findDownQuad() {
        TerrainQuad quad;
        if (this.getParent() == null || !(this.getParent() instanceof TerrainQuad)) {
            return null;
        }
        TerrainQuad pQuad = (TerrainQuad)this.getParent();
        if (this.quadrant == 1) {
            return pQuad.getQuad(2);
        }
        if (this.quadrant == 3) {
            return pQuad.getQuad(4);
        }
        if (this.quadrant == 2) {
            TerrainQuad quad2 = pQuad.findDownQuad();
            if (quad2 != null) {
                return quad2.getQuad(1);
            }
        } else if (this.quadrant == 4 && (quad = pQuad.findDownQuad()) != null) {
            return quad.getQuad(3);
        }
        return null;
    }

    protected TerrainQuad findTopQuad() {
        TerrainQuad quad;
        if (this.getParent() == null || !(this.getParent() instanceof TerrainQuad)) {
            return null;
        }
        TerrainQuad pQuad = (TerrainQuad)this.getParent();
        if (this.quadrant == 2) {
            return pQuad.getQuad(1);
        }
        if (this.quadrant == 4) {
            return pQuad.getQuad(3);
        }
        if (this.quadrant == 1) {
            TerrainQuad quad2 = pQuad.findTopQuad();
            if (quad2 != null) {
                return quad2.getQuad(2);
            }
        } else if (this.quadrant == 3 && (quad = pQuad.findTopQuad()) != null) {
            return quad.getQuad(4);
        }
        return null;
    }

    protected TerrainQuad findLeftQuad() {
        TerrainQuad quad;
        if (this.getParent() == null || !(this.getParent() instanceof TerrainQuad)) {
            return null;
        }
        TerrainQuad pQuad = (TerrainQuad)this.getParent();
        if (this.quadrant == 3) {
            return pQuad.getQuad(1);
        }
        if (this.quadrant == 4) {
            return pQuad.getQuad(2);
        }
        if (this.quadrant == 1) {
            TerrainQuad quad2 = pQuad.findLeftQuad();
            if (quad2 != null) {
                return quad2.getQuad(3);
            }
        } else if (this.quadrant == 2 && (quad = pQuad.findLeftQuad()) != null) {
            return quad.getQuad(4);
        }
        return null;
    }

    protected void fixNormals(BoundingBox affectedArea) {
        if (this.children == null) {
            return;
        }
        int x = this.children.size();
        while (--x >= 0) {
            Spatial child = (Spatial)this.children.get(x);
            if (child instanceof TerrainQuad) {
                if (affectedArea == null || !affectedArea.intersects(((TerrainQuad)child).getWorldBound())) continue;
                ((TerrainQuad)child).fixNormals(affectedArea);
                continue;
            }
            if (!(child instanceof TerrainPatch) || affectedArea == null || !affectedArea.intersects(((TerrainPatch)child).getWorldBound())) continue;
            ((TerrainPatch)child).updateNormals();
        }
    }

    protected void fixNormalEdges(BoundingBox affectedArea) {
        if (this.children == null) {
            return;
        }
        int x = this.children.size();
        while (--x >= 0) {
            Spatial child = (Spatial)this.children.get(x);
            if (child instanceof TerrainQuad) {
                if (affectedArea == null || !affectedArea.intersects(((TerrainQuad)child).getWorldBound())) continue;
                ((TerrainQuad)child).fixNormalEdges(affectedArea);
                continue;
            }
            if (!(child instanceof TerrainPatch) || affectedArea != null && !affectedArea.intersects(((TerrainPatch)child).getWorldBound())) continue;
            TerrainPatch tp = (TerrainPatch)child;
            TerrainPatch right = this.findRightPatch(tp);
            TerrainPatch bottom = this.findDownPatch(tp);
            TerrainPatch top = this.findTopPatch(tp);
            TerrainPatch left = this.findLeftPatch(tp);
            TerrainPatch topLeft = null;
            if (top != null) {
                topLeft = this.findLeftPatch(top);
            }
            TerrainPatch bottomRight = null;
            if (right != null) {
                bottomRight = this.findDownPatch(right);
            }
            TerrainPatch topRight = null;
            if (top != null) {
                topRight = this.findRightPatch(top);
            }
            TerrainPatch bottomLeft = null;
            if (left != null) {
                bottomLeft = this.findDownPatch(left);
            }
            tp.fixNormalEdges(right, bottom, top, left, bottomRight, bottomLeft, topRight, topLeft);
        }
    }

    @Override
    public int collideWith(Collidable other, CollisionResults results) {
        int total = 0;
        if (other instanceof Ray) {
            return this.collideWithRay((Ray)other, results);
        }
        if (other instanceof BoundingVolume && !this.getWorldBound().intersects((BoundingVolume)other)) {
            return total;
        }
        for (Spatial child : this.children) {
            total += child.collideWith(other, results);
        }
        return total;
    }

    public void findPick(Ray toTest, List<TerrainPickData> results) {
        if (this.getWorldBound() != null && this.getWorldBound().intersects(toTest)) {
            for (int i = 0; i < this.getQuantity(); ++i) {
                if (this.children.get(i) instanceof TerrainPatch) {
                    TerrainPatch tp = (TerrainPatch)this.children.get(i);
                    if (!tp.getWorldBound().intersects(toTest)) continue;
                    CollisionResults cr = new CollisionResults();
                    toTest.collideWith(tp.getWorldBound(), cr);
                    if (cr == null || cr.getClosestCollision() == null) continue;
                    cr.getClosestCollision().getDistance();
                    results.add(new TerrainPickData(tp, cr.getClosestCollision()));
                    continue;
                }
                ((TerrainQuad)this.children.get(i)).findPick(toTest, results);
            }
        }
    }

    public void getAllTerrainPatches(List<TerrainPatch> holder) {
        if (this.children != null) {
            int i = this.children.size();
            while (--i >= 0) {
                Spatial child = (Spatial)this.children.get(i);
                if (child instanceof TerrainQuad) {
                    ((TerrainQuad)child).getAllTerrainPatches(holder);
                    continue;
                }
                if (!(child instanceof TerrainPatch)) continue;
                holder.add((TerrainPatch)child);
            }
        }
    }

    public void getAllTerrainPatchesWithTranslation(Map<TerrainPatch, Vector3f> holder, Vector3f translation) {
        if (this.children != null) {
            int i = this.children.size();
            while (--i >= 0) {
                Spatial child = (Spatial)this.children.get(i);
                if (child instanceof TerrainQuad) {
                    ((TerrainQuad)child).getAllTerrainPatchesWithTranslation(holder, translation.clone().add(child.getLocalTranslation()));
                    continue;
                }
                if (!(child instanceof TerrainPatch)) continue;
                holder.put((TerrainPatch)child, translation.clone().add(child.getLocalTranslation()));
            }
        }
    }

    @Override
    public void read(JmeImporter e) throws IOException {
        super.read(e);
        InputCapsule c = e.getCapsule(this);
        this.size = c.readInt("size", 0);
        this.stepScale = (Vector3f)c.readSavable("stepScale", null);
        this.offset = (Vector2f)c.readSavable("offset", new Vector2f(0.0f, 0.0f));
        this.offsetAmount = c.readFloat("offsetAmount", 0.0f);
        this.quadrant = c.readInt("quadrant", 0);
        this.totalSize = c.readInt("totalSize", 0);
        this.lodCalculatorFactory = (LodCalculatorFactory)c.readSavable("lodCalculatorFactory", null);
        if (!(this.getParent() instanceof TerrainQuad)) {
            BoundingBox all;
            this.affectedAreaBBox = all = new BoundingBox(this.getWorldTranslation(), this.totalSize, this.totalSize, this.totalSize);
            this.updateNormals();
        }
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        super.write(e);
        OutputCapsule c = e.getCapsule(this);
        c.write(this.size, "size", 0);
        c.write(this.totalSize, "totalSize", 0);
        c.write(this.stepScale, "stepScale", null);
        c.write(this.offset, "offset", new Vector2f(0.0f, 0.0f));
        c.write(this.offsetAmount, "offsetAmount", 0.0f);
        c.write(this.quadrant, "quadrant", 0);
        c.write(this.lodCalculatorFactory, "lodCalculatorFactory", null);
    }

    @Override
    public TerrainQuad clone() {
        return this.clone(true);
    }

    @Override
    public TerrainQuad clone(boolean cloneMaterials) {
        NormalRecalcControl normalControl;
        TerrainQuad quadClone = (TerrainQuad)super.clone(cloneMaterials);
        quadClone.name = this.name.toString();
        quadClone.size = this.size;
        quadClone.totalSize = this.totalSize;
        quadClone.stepScale = this.stepScale.clone();
        quadClone.offset = this.offset.clone();
        quadClone.offsetAmount = this.offsetAmount;
        quadClone.quadrant = this.quadrant;
        quadClone.lodCalculatorFactory = this.lodCalculatorFactory.clone();
        TerrainLodControl lodControl = quadClone.getControl(TerrainLodControl.class);
        if (lodControl != null && !(this.getParent() instanceof TerrainQuad)) {
            lodControl.setTerrain(quadClone);
        }
        if ((normalControl = this.getControl(NormalRecalcControl.class)) != null) {
            normalControl.setTerrain(this);
        }
        return quadClone;
    }

    @Override
    public int getMaxLod() {
        if (this.maxLod < 0) {
            this.maxLod = Math.max(1, (int)(FastMath.log(this.size - 1) / FastMath.log(2.0f)) - 1);
        }
        return this.maxLod;
    }

    public int getPatchSize() {
        return this.patchSize;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    @Override
    public float[] getHeightMap() {
        float[] hm = null;
        int length = (this.size - 1) / 2 + 1;
        int area = this.size * this.size;
        hm = new float[area];
        if (this.getChildren() != null && !this.getChildren().isEmpty()) {
            float[] ul = null;
            float[] ur = null;
            float[] bl = null;
            float[] br = null;
            if (this.getChild(0) instanceof TerrainPatch) {
                for (Spatial s : this.getChildren()) {
                    if (((TerrainPatch)s).getQuadrant() == 1) {
                        ul = BufferUtils.getFloatArray(((TerrainPatch)s).getHeightmap());
                        continue;
                    }
                    if (((TerrainPatch)s).getQuadrant() == 2) {
                        bl = BufferUtils.getFloatArray(((TerrainPatch)s).getHeightmap());
                        continue;
                    }
                    if (((TerrainPatch)s).getQuadrant() == 3) {
                        ur = BufferUtils.getFloatArray(((TerrainPatch)s).getHeightmap());
                        continue;
                    }
                    if (((TerrainPatch)s).getQuadrant() != 4) continue;
                    br = BufferUtils.getFloatArray(((TerrainPatch)s).getHeightmap());
                }
            } else {
                ul = this.getQuad(1).getHeightMap();
                bl = this.getQuad(2).getHeightMap();
                ur = this.getQuad(3).getHeightMap();
                br = this.getQuad(4).getHeightMap();
            }
            for (int y = 0; y < length; ++y) {
                int row;
                for (int x1 = 0; x1 < length; ++x1) {
                    row = y * this.size;
                    hm[row + x1] = ul[y * length + x1];
                }
                for (int x2 = 1; x2 < length; ++x2) {
                    row = y * this.size + length;
                    hm[row + x2 - 1] = ur[y * length + x2];
                }
            }
            int rowOffset = this.size * length;
            for (int y = 1; y < length; ++y) {
                int row;
                for (int x1 = 0; x1 < length; ++x1) {
                    row = (y - 1) * this.size;
                    hm[rowOffset + row + x1] = bl[y * length + x1];
                }
                for (int x2 = 1; x2 < length; ++x2) {
                    row = (y - 1) * this.size + length;
                    hm[rowOffset + row + x2 - 1] = br[y * length + x2];
                }
            }
        }
        return hm;
    }

    protected class LocationHeight {
        int x;
        int z;
        float h;

        LocationHeight() {
        }

        LocationHeight(int x, int z, float h) {
            this.x = x;
            this.z = z;
            this.h = h;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UpdateLOD
    implements Runnable {
        private List<Vector3f> camLocations;

        UpdateLOD(List<Vector3f> location) {
            this.camLocations = location;
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            if (TerrainQuad.this.isLodCalcRunning()) {
                return;
            }
            TerrainQuad.this.setLodCalcRunning(true);
            HashMap<String, UpdatedTerrainPatch> updated = new HashMap<String, UpdatedTerrainPatch>();
            boolean lodChanged = TerrainQuad.this.calculateLod(this.camLocations, updated);
            if (!lodChanged) {
                TerrainQuad.this.setLodCalcRunning(false);
                return;
            }
            TerrainQuad.this.findNeighboursLod(updated);
            TerrainQuad.this.fixEdges(updated);
            TerrainQuad.this.reIndexPages(updated);
            TerrainQuad.this.setUpdateQuadLODs(updated);
            TerrainQuad.this.setLodCalcRunning(false);
        }
    }
}

