/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system.lwjgl;

import com.jme3.system.AppSettings;
import com.jme3.system.JmeCanvasContext;
import com.jme3.system.JmeContext;
import com.jme3.system.JmeSystem;
import com.jme3.system.lwjgl.LwjglAbstractDisplay;
import com.jme3.system.lwjgl.LwjglDisplay;
import java.awt.Canvas;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.Pbuffer;
import org.lwjgl.opengl.PixelFormat;

public class LwjglCanvas
extends LwjglAbstractDisplay
implements JmeCanvasContext {
    private static final Logger logger = Logger.getLogger(LwjglDisplay.class.getName());
    private Canvas canvas;
    private int width;
    private int height;
    private final AtomicBoolean needRestoreCanvas = new AtomicBoolean(false);
    private final AtomicBoolean needDestroyCanvas = new AtomicBoolean(false);
    private final CyclicBarrier actionRequiredBarrier = new CyclicBarrier(2);
    private Thread renderThread;
    private boolean runningFirstTime = true;
    private boolean mouseWasGrabbed = false;
    private Pbuffer pbuffer;
    private PixelFormat pixelFormat;

    public LwjglCanvas() {
        this.canvas = new GLCanvas();
    }

    public JmeContext.Type getType() {
        return JmeContext.Type.Canvas;
    }

    public void create(boolean waitFor) {
        if (this.renderThread == null) {
            logger.log(Level.INFO, "MAIN: Creating OGL thread.");
            this.renderThread = new Thread((Runnable)this, "LWJGL Renderer Thread");
            this.renderThread.start();
        }
        if (waitFor) {
            this.waitFor(true);
        }
    }

    public void setTitle(String title) {
    }

    public void restart() {
        this.frameRate = this.settings.getFrameRate();
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runLoop() {
        if (this.needDestroyCanvas.getAndSet(false)) {
            logger.log(Level.INFO, "OGL: Received destroy request! Complying..");
            try {
                this.listener.loseFocus();
                this.pauseCanvas();
            }
            finally {
                try {
                    this.actionRequiredBarrier.await();
                }
                catch (InterruptedException ex) {
                    logger.log(Level.SEVERE, "OGL: Interrupted! ", ex);
                }
                catch (BrokenBarrierException ex) {
                    logger.log(Level.SEVERE, "OGL: Broken barrier! ", ex);
                }
            }
        }
        if (this.needRestoreCanvas.getAndSet(false)) {
            logger.log(Level.INFO, "OGL: Canvas is now visible! Re-initializing..");
            this.restoreCanvas();
            this.listener.gainFocus();
        }
        if (this.width != this.canvas.getWidth() || this.height != this.canvas.getHeight()) {
            this.width = this.canvas.getWidth();
            this.height = this.canvas.getHeight();
            if (this.listener != null) {
                this.listener.reshape(this.width, this.height);
            }
        }
        super.runLoop();
    }

    private void pauseCanvas() {
        if (Mouse.isCreated() && Mouse.isGrabbed()) {
            Mouse.setGrabbed((boolean)false);
            this.mouseWasGrabbed = true;
        }
        logger.log(Level.INFO, "OGL: Canvas will become invisible! Destroying ..");
        this.renderable.set(false);
        this.destroyContext();
    }

    private void restoreCanvas() {
        logger.log(Level.INFO, "OGL: Waiting for canvas to become displayable..");
        while (!this.canvas.isDisplayable()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                logger.log(Level.SEVERE, "OGL: Interrupted! ", ex);
            }
        }
        logger.log(Level.INFO, "OGL: Creating display..");
        this.renderable.set(true);
        while (!this.needClose.get()) {
            try {
                this.createContext(this.settings);
                break;
            }
            catch (RuntimeException ex) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        logger.log(Level.INFO, "OGL: Display is active!");
        if (Mouse.isCreated() && this.mouseWasGrabbed) {
            Mouse.setGrabbed((boolean)true);
            this.mouseWasGrabbed = false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LwjglCanvas.this.canvas.requestFocus();
            }
        });
    }

    protected PixelFormat acquirePixelFormat() {
        if (this.pixelFormat == null) {
            this.pixelFormat = new PixelFormat(this.settings.getBitsPerPixel(), 0, this.settings.getDepthBits(), this.settings.getStencilBits(), this.settings.getSamples());
        }
        return this.pixelFormat;
    }

    protected void makePbufferAvailable() throws LWJGLException {
        if (this.pbuffer == null || this.pbuffer.isBufferLost()) {
            if (this.pbuffer != null && this.pbuffer.isBufferLost()) {
                logger.log(Level.WARNING, "PBuffer was lost!");
                this.pbuffer.destroy();
            }
            this.pbuffer = new Pbuffer(1, 1, new PixelFormat(0, 0, 0, 0, 0), null);
            logger.log(Level.INFO, "OGL: Pbuffer has been created");
        }
    }

    protected void destroyContext() {
        if (Display.isCreated()) {
            try {
                if (JmeSystem.getPlatform() == JmeSystem.Platform.Windows32 || JmeSystem.getPlatform() == JmeSystem.Platform.Windows64 || JmeSystem.getPlatform() == JmeSystem.Platform.Linux32 || JmeSystem.getPlatform() == JmeSystem.Platform.Linux64 || JmeSystem.getPlatform() == JmeSystem.Platform.SolarisX86 || JmeSystem.getPlatform() == JmeSystem.Platform.SolarisAMD64) {
                    Display.setParent(null);
                }
            }
            catch (LWJGLException ex) {
                logger.log(Level.SEVERE, "Encountered exception when setting parent to null", ex);
            }
            Display.destroy();
        }
        try {
            if (!this.needClose.get()) {
                this.makePbufferAvailable();
                this.pbuffer.makeCurrent();
                this.renderer.invalidateState();
            } else if (this.pbuffer != null) {
                this.pbuffer.destroy();
            }
        }
        catch (LWJGLException ex) {
            this.listener.handleError("Failed make pbuffer available", ex);
        }
    }

    protected void createContext(AppSettings settings) {
        this.frameRate = settings.getFrameRate();
        try {
            this.makePbufferAvailable();
            if (this.renderable.get()) {
                if (this.pbuffer.isCurrent()) {
                    this.pbuffer.releaseContext();
                }
                Display.setVSyncEnabled((boolean)settings.isVSync());
                Display.setParent((Canvas)this.canvas);
                Display.create((PixelFormat)this.acquirePixelFormat(), (Drawable)this.pbuffer);
                this.renderer.invalidateState();
            } else {
                this.pbuffer.makeCurrent();
            }
            if (this.runningFirstTime) {
                this.initContextFirstTime();
                this.runningFirstTime = false;
            }
        }
        catch (LWJGLException ex) {
            throw new RuntimeException("createContext failed.", ex);
        }
    }

    private class GLCanvas
    extends Canvas {
        private GLCanvas() {
        }

        public void addNotify() {
            super.addNotify();
            if (LwjglCanvas.this.renderThread != null && LwjglCanvas.this.renderThread.getState() == Thread.State.TERMINATED) {
                return;
            }
            if (LwjglCanvas.this.renderThread == null) {
                logger.log(Level.INFO, "EDT: Creating OGL thread.");
                LwjglCanvas.this.canvas.setFocusable(true);
                LwjglCanvas.this.canvas.setIgnoreRepaint(true);
                LwjglCanvas.this.renderThread = new Thread((Runnable)LwjglCanvas.this, "LWJGL Renderer Thread");
                LwjglCanvas.this.renderThread.start();
            } else if (LwjglCanvas.this.needClose.get()) {
                return;
            }
            logger.log(Level.INFO, "EDT: Notifying OGL that canvas is visible..");
            LwjglCanvas.this.needRestoreCanvas.set(true);
        }

        public void removeNotify() {
            if (LwjglCanvas.this.needClose.get()) {
                logger.log(Level.INFO, "EDT: Application is stopped. Not restoring canvas.");
                super.removeNotify();
                return;
            }
            logger.log(Level.INFO, "EDT: Notifying OGL that canvas is about to become invisible..");
            LwjglCanvas.this.needDestroyCanvas.set(true);
            try {
                LwjglCanvas.this.actionRequiredBarrier.await();
            }
            catch (InterruptedException ex) {
                logger.log(Level.SEVERE, "EDT: Interrupted! ", ex);
            }
            catch (BrokenBarrierException ex) {
                logger.log(Level.SEVERE, "EDT: Broken barrier! ", ex);
            }
            LwjglCanvas.this.actionRequiredBarrier.reset();
            logger.log(Level.INFO, "EDT: Acknowledged receipt of canvas death");
            super.removeNotify();
        }
    }
}

