/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.shape;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.util.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;

public class Cylinder
extends Mesh {
    private int axisSamples;
    private int radialSamples;
    private float radius;
    private float radius2;
    private float height;
    private boolean closed;
    private boolean inverted;

    public Cylinder() {
    }

    public Cylinder(int axisSamples, int radialSamples, float radius, float height) {
        this(axisSamples, radialSamples, radius, height, false);
    }

    public Cylinder(int axisSamples, int radialSamples, float radius, float height, boolean closed) {
        this(axisSamples, radialSamples, radius, height, closed, false);
    }

    public Cylinder(int axisSamples, int radialSamples, float radius, float height, boolean closed, boolean inverted) {
        this(axisSamples, radialSamples, radius, radius, height, closed, inverted);
    }

    public Cylinder(int axisSamples, int radialSamples, float radius, float radius2, float height, boolean closed, boolean inverted) {
        this.updateGeometry(axisSamples, radialSamples, radius, radius2, height, closed, inverted);
    }

    public int getAxisSamples() {
        return this.axisSamples;
    }

    public float getHeight() {
        return this.height;
    }

    public int getRadialSamples() {
        return this.radialSamples;
    }

    public float getRadius() {
        return this.radius;
    }

    public float getRadius2() {
        return this.radius2;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void updateGeometry(int axisSamples, int radialSamples, float radius, float radius2, float height, boolean closed, boolean inverted) {
        this.axisSamples = axisSamples + (closed ? 2 : 0);
        this.radialSamples = radialSamples;
        this.radius = radius;
        this.radius2 = radius2;
        this.height = height;
        this.closed = closed;
        this.inverted = inverted;
        int vertCount = axisSamples * (radialSamples + 1) + (closed ? 2 : 0);
        this.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createVector3Buffer(this.getFloatBuffer(VertexBuffer.Type.Position), vertCount));
        this.setBuffer(VertexBuffer.Type.Normal, 3, BufferUtils.createVector3Buffer(this.getFloatBuffer(VertexBuffer.Type.Normal), vertCount));
        this.setBuffer(VertexBuffer.Type.TexCoord, 2, BufferUtils.createVector2Buffer(vertCount));
        int triCount = ((closed ? 2 : 0) + 2 * (axisSamples - 1)) * radialSamples;
        this.setBuffer(VertexBuffer.Type.Index, 3, BufferUtils.createShortBuffer(this.getShortBuffer(VertexBuffer.Type.Index), 3 * triCount));
        float inverseRadial = 1.0f / (float)radialSamples;
        float inverseAxisLess = 1.0f / (float)(closed ? axisSamples - 3 : axisSamples - 1);
        float inverseAxisLessTexture = 1.0f / (float)(axisSamples - 1);
        float halfHeight = 0.5f * height;
        float[] sin = new float[radialSamples + 1];
        float[] cos = new float[radialSamples + 1];
        for (int radialCount = 0; radialCount < radialSamples; ++radialCount) {
            float angle = (float)Math.PI * 2 * inverseRadial * (float)radialCount;
            cos[radialCount] = FastMath.cos(angle);
            sin[radialCount] = FastMath.sin(angle);
        }
        sin[radialSamples] = sin[0];
        cos[radialSamples] = cos[0];
        FloatBuffer nb = this.getFloatBuffer(VertexBuffer.Type.Normal);
        FloatBuffer pb = this.getFloatBuffer(VertexBuffer.Type.Position);
        FloatBuffer tb = this.getFloatBuffer(VertexBuffer.Type.TexCoord);
        Vector3f tempNormal = new Vector3f();
        int axisCount = 0;
        int i = 0;
        while (axisCount < axisSamples) {
            float axisFractionTexture;
            float axisFraction;
            int topBottom = 0;
            if (!closed) {
                axisFractionTexture = axisFraction = (float)axisCount * inverseAxisLess;
            } else if (axisCount == 0) {
                topBottom = -1;
                axisFraction = 0.0f;
                axisFractionTexture = inverseAxisLessTexture;
            } else if (axisCount == axisSamples - 1) {
                topBottom = 1;
                axisFraction = 1.0f;
                axisFractionTexture = 1.0f - inverseAxisLessTexture;
            } else {
                axisFraction = (float)(axisCount - 1) * inverseAxisLess;
                axisFractionTexture = (float)axisCount * inverseAxisLessTexture;
            }
            float z = -halfHeight + height * axisFraction;
            Vector3f sliceCenter = new Vector3f(0.0f, 0.0f, z);
            int save = i;
            int radialCount = 0;
            while (radialCount < radialSamples) {
                float radialFraction = (float)radialCount * inverseRadial;
                tempNormal.set(cos[radialCount], sin[radialCount], 0.0f);
                if (topBottom == 0) {
                    if (!inverted) {
                        nb.put(tempNormal.x).put(tempNormal.y).put(tempNormal.z);
                    } else {
                        nb.put(-tempNormal.x).put(-tempNormal.y).put(-tempNormal.z);
                    }
                } else {
                    nb.put(0.0f).put(0.0f).put(topBottom * (inverted ? -1 : 1));
                }
                tempNormal.multLocal((radius - radius2) * axisFraction + radius2).addLocal(sliceCenter);
                pb.put(tempNormal.x).put(tempNormal.y).put(tempNormal.z);
                tb.put(inverted ? 1.0f - radialFraction : radialFraction).put(axisFractionTexture);
                ++radialCount;
                ++i;
            }
            BufferUtils.copyInternalVector3(pb, save, i);
            BufferUtils.copyInternalVector3(nb, save, i);
            tb.put(inverted ? 0.0f : 1.0f).put(axisFractionTexture);
            ++axisCount;
            ++i;
        }
        if (closed) {
            pb.put(0.0f).put(0.0f).put(-halfHeight);
            nb.put(0.0f).put(0.0f).put(-1 * (inverted ? -1 : 1));
            tb.put(0.5f).put(0.0f);
            pb.put(0.0f).put(0.0f).put(halfHeight);
            nb.put(0.0f).put(0.0f).put(1 * (inverted ? -1 : 1));
            tb.put(0.5f).put(1.0f);
        }
        IndexBuffer ib = this.getIndexBuffer();
        int index = 0;
        int axisStart = 0;
        for (int axisCount2 = 0; axisCount2 < axisSamples - 1; ++axisCount2) {
            int i0 = axisStart;
            int i1 = i0 + 1;
            int i2 = axisStart += radialSamples + 1;
            int i3 = i2 + 1;
            for (int i4 = 0; i4 < radialSamples; ++i4) {
                if (closed && axisCount2 == 0) {
                    if (!inverted) {
                        ib.put(index++, i0++);
                        ib.put(index++, vertCount - 2);
                        ib.put(index++, i1++);
                        continue;
                    }
                    ib.put(index++, i0++);
                    ib.put(index++, i1++);
                    ib.put(index++, vertCount - 2);
                    continue;
                }
                if (closed && axisCount2 == axisSamples - 2) {
                    ib.put(index++, i2++);
                    ib.put(index++, inverted ? vertCount - 1 : i3++);
                    ib.put(index++, inverted ? i3++ : vertCount - 1);
                    continue;
                }
                ib.put(index++, i0++);
                ib.put(index++, inverted ? i2 : i1);
                ib.put(index++, inverted ? i1 : i2);
                ib.put(index++, i1++);
                ib.put(index++, inverted ? i2++ : i3++);
                ib.put(index++, inverted ? i3++ : i2++);
            }
        }
        this.updateBound();
    }

    public void read(JmeImporter e) throws IOException {
        super.read(e);
        InputCapsule capsule = e.getCapsule(this);
        this.axisSamples = capsule.readInt("axisSamples", 0);
        this.radialSamples = capsule.readInt("radialSamples", 0);
        this.radius = capsule.readFloat("radius", 0.0f);
        this.radius2 = capsule.readFloat("radius2", 0.0f);
        this.height = capsule.readFloat("height", 0.0f);
        this.closed = capsule.readBoolean("closed", false);
        this.inverted = capsule.readBoolean("inverted", false);
    }

    public void write(JmeExporter e) throws IOException {
        super.write(e);
        OutputCapsule capsule = e.getCapsule(this);
        capsule.write(this.axisSamples, "axisSamples", 0);
        capsule.write(this.radialSamples, "radialSamples", 0);
        capsule.write(this.radius, "radius", 0.0f);
        capsule.write(this.radius2, "radius2", 0.0f);
        capsule.write(this.height, "height", 0.0f);
        capsule.write(this.closed, "closed", false);
        capsule.write(this.inverted, "inverted", false);
    }
}

