/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.ogre.matext;

import com.jme3.asset.AssetManager;
import com.jme3.asset.TextureKey;
import com.jme3.material.Material;
import com.jme3.material.MaterialList;
import com.jme3.scene.plugins.ogre.matext.MaterialExtension;
import com.jme3.scene.plugins.ogre.matext.MaterialExtensionSet;
import com.jme3.texture.Texture;
import java.io.IOException;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MaterialExtensionLoader {
    private static final Logger logger = Logger.getLogger(MaterialExtensionLoader.class.getName());
    private AssetManager assetManager;
    private Scanner scan;
    private MaterialList list;
    private MaterialExtensionSet matExts;
    private MaterialExtension matExt;
    private String matName;
    private Material material;

    private String readString(String end) {
        this.scan.useDelimiter(end);
        String str = this.scan.next();
        this.scan.useDelimiter("\\p{javaWhitespace}+");
        return str.trim();
    }

    private boolean readExtendingMaterialStatement() throws IOException {
        if (this.scan.hasNext("set_texture_alias")) {
            this.scan.next();
            String aliasName = this.scan.next();
            String texturePath = this.readString("\n");
            String jmeParamName = this.matExt.getTextureMapping(aliasName);
            TextureKey key = new TextureKey(texturePath, false);
            key.setGenerateMips(true);
            key.setAsCube(false);
            Texture tex = this.assetManager.loadTexture(key);
            if (tex == null) {
                throw new IOException("Cannot load texture: " + texturePath);
            }
            tex.setWrap(Texture.WrapMode.Repeat);
            this.material.setTexture(jmeParamName, tex);
            return true;
        }
        return false;
    }

    private Material readExtendingMaterial() throws IOException {
        this.scan.next();
        this.matName = this.readString(":").trim();
        this.scan.next();
        String extendedMat = this.readString("\\{").trim();
        this.scan.next();
        this.matExt = this.matExts.getMaterialExtension(extendedMat);
        if (this.matExt == null) {
            logger.log(Level.WARNING, "Cannot find MaterialExtension for: {0}. Ignoring material.", extendedMat);
            this.readString("\\}");
            this.scan.next();
            this.matExt = null;
            return null;
        }
        this.material = new Material(this.assetManager, this.matExt.getJmeMatDefName());
        this.material.setFloat("Shininess", 16.0f);
        while (!this.scan.hasNext("\\}")) {
            this.readExtendingMaterialStatement();
        }
        return this.material;
    }

    public MaterialList load(AssetManager assetManager, MaterialExtensionSet matExts, Scanner scan) throws IOException {
        this.assetManager = assetManager;
        this.matExts = matExts;
        this.scan = scan;
        this.list = new MaterialList();
        if (scan.hasNext("import")) {
            scan.nextLine();
        }
        block0: while (scan.hasNext()) {
            while (!scan.hasNext("material")) {
                if (!scan.hasNext()) break block0;
                scan.next();
            }
            Material material = this.readExtendingMaterial();
            this.list.put(this.matName, material);
            List<String> matAliases = matExts.getNameMappings(this.matName);
            if (matAliases == null) continue;
            for (String string : matAliases) {
                this.list.put(string, material);
            }
        }
        return this.list;
    }
}

