/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.ogre;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.AssetManager;
import com.jme3.asset.TextureKey;
import com.jme3.material.Material;
import com.jme3.material.MaterialList;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.plugins.ogre.matext.MaterialExtensionLoader;
import com.jme3.scene.plugins.ogre.matext.MaterialExtensionSet;
import com.jme3.scene.plugins.ogre.matext.OgreMaterialKey;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.util.BufferUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MaterialLoader
implements AssetLoader {
    private static final Logger logger = Logger.getLogger(MaterialLoader.class.getName());
    private String folderName;
    private AssetManager assetManager;
    private Scanner scan;
    private ColorRGBA ambient;
    private ColorRGBA diffuse;
    private ColorRGBA specular;
    private ColorRGBA emissive;
    private Texture texture;
    private String texName;
    private String matName;
    private float shinines;
    private boolean vcolor = false;
    private boolean blend = false;
    private boolean twoSide = false;
    private boolean noLight = false;
    private boolean readTexUnit = false;

    private String readString(String end) {
        this.scan.useDelimiter(end);
        String str = this.scan.next();
        this.scan.useDelimiter("\\p{javaWhitespace}+");
        return str.trim();
    }

    private ColorRGBA readColor() {
        ColorRGBA color = new ColorRGBA();
        color.r = this.scan.nextFloat();
        color.g = this.scan.nextFloat();
        color.b = this.scan.nextFloat();
        if (this.scan.hasNextFloat()) {
            color.a = this.scan.nextFloat();
        }
        return color;
    }

    private void readTextureImage() {
        int extStart;
        String ln = this.scan.nextLine();
        String path = null;
        for (int i = extStart = ln.lastIndexOf("."); i < ln.length(); ++i) {
            char c = ln.charAt(i);
            if (!Character.isWhitespace(c)) continue;
            path = ln.substring(0, i).trim();
            ln = ln.substring(i + 1).trim();
            break;
        }
        if (path == null) {
            path = ln.trim();
            ln = "";
        }
        Scanner lnScan = new Scanner(ln);
        Object mips = null;
        String type = null;
        if (lnScan.hasNext()) {
            type = lnScan.next();
        }
        boolean genMips = true;
        boolean cubic = false;
        if (type != null && type.equals("0")) {
            genMips = false;
        }
        if (type != null && type.equals("cubic")) {
            cubic = true;
        }
        TextureKey key = new TextureKey(this.folderName + path, false);
        key.setGenerateMips(genMips);
        key.setAsCube(cubic);
        Texture loadedTexture = this.assetManager.loadTexture(key);
        if (loadedTexture == null) {
            ByteBuffer tempData = BufferUtils.createByteBuffer(3);
            tempData.put((byte)-1).put((byte)0).put((byte)0);
            this.texture = new Texture2D(new Image(Image.Format.RGB8, 1, 1, tempData));
            logger.log(Level.WARNING, "Using RED texture instead of {0}", path);
        } else {
            this.texture.setImage(loadedTexture.getImage());
            this.texture.setMinFilter(loadedTexture.getMinFilter());
            this.texture.setKey(loadedTexture.getKey());
            this.texture.setWrap(Texture.WrapMode.Repeat);
            if (this.texName != null) {
                this.texture.setName(this.texName);
                this.texName = null;
            } else {
                this.texture.setName(key.getName());
            }
        }
    }

    private void readTextureUnitStatement() {
        String keyword = this.scan.next();
        if (keyword.equals("texture")) {
            this.readTextureImage();
        } else if (keyword.equals("tex_address_mode")) {
            String mode = this.scan.next();
            if (mode.equals("wrap")) {
                this.texture.setWrap(Texture.WrapMode.Repeat);
            } else if (mode.equals("clamp")) {
                this.texture.setWrap(Texture.WrapMode.Clamp);
            } else if (mode.equals("mirror")) {
                this.texture.setWrap(Texture.WrapMode.MirroredRepeat);
            } else if (mode.equals("border")) {
                this.texture.setWrap(Texture.WrapMode.BorderClamp);
            }
        } else if (keyword.equals("filtering")) {
            this.readString("\n");
        } else if (keyword.equals("max_anisotropy")) {
            int amount = this.scan.nextInt();
            this.texture.setAnisotropicFilter(amount);
        } else {
            logger.log(Level.WARNING, "Unsupported texture_unit directive: {0}", keyword);
            this.readString("\n");
        }
    }

    private void readTextureUnit(boolean skipIt) {
        this.texName = !this.scan.hasNext("\\{") ? this.readString("\\{") : null;
        this.scan.next();
        if (!skipIt) {
            this.texture = new Texture2D();
        }
        while (!this.scan.hasNext("\\}")) {
            if (skipIt) {
                this.readString("\n");
                continue;
            }
            this.readTextureUnitStatement();
        }
        this.scan.next();
    }

    private void readPassStatement() {
        String keyword = this.scan.next();
        if (keyword.equals("")) {
            return;
        }
        if (keyword.equals("diffuse")) {
            if (this.scan.hasNext("vertexcolour")) {
                this.diffuse = ColorRGBA.White;
                this.vcolor = true;
                this.scan.next();
            } else {
                this.diffuse = this.readColor();
            }
        } else if (keyword.equals("ambient")) {
            if (this.scan.hasNext("vertexcolour")) {
                this.ambient = ColorRGBA.White;
                this.scan.next();
            } else {
                this.ambient = this.readColor();
            }
        } else if (keyword.equals("emissive")) {
            this.emissive = this.readColor();
        } else if (keyword.equals("specular")) {
            this.specular = new ColorRGBA();
            this.specular.r = this.scan.nextFloat();
            this.specular.g = this.scan.nextFloat();
            this.specular.b = this.scan.nextFloat();
            float unknown = this.scan.nextFloat();
            if (this.scan.hasNextFloat()) {
                this.specular.a = unknown;
                this.shinines = this.scan.nextFloat();
            } else {
                this.specular.a = 1.0f;
                this.shinines = unknown;
            }
        } else if (keyword.equals("texture_unit")) {
            this.readTextureUnit(this.readTexUnit);
            if (!this.readTexUnit) {
                this.readTexUnit = true;
            }
        } else if (keyword.equals("scene_blend")) {
            if (this.scan.hasNextInt()) {
                this.readString("\n");
                return;
            }
            String mode = this.scan.next();
            if (mode.equals("alpha_blend")) {
                this.blend = true;
            } else {
                this.readString("\n");
            }
        } else if (keyword.equals("cull_hardware")) {
            String mode = this.scan.next();
            if (mode.equals("none")) {
                this.twoSide = true;
            }
        } else if (keyword.equals("cull_software")) {
            this.scan.next();
        } else if (keyword.equals("lighting")) {
            String isOn = this.scan.next();
            if (isOn.equals("on")) {
                this.noLight = false;
            } else if (isOn.equals("off")) {
                this.noLight = true;
            }
        } else {
            logger.log(Level.WARNING, "Unsupported pass directive: {0}", keyword);
            this.readString("\n");
        }
    }

    private void readPass() {
        this.scan.next();
        String name = this.scan.hasNext("\\{") ? null : this.readString("\\{");
        this.scan.next();
        this.readTexUnit = false;
        while (!this.scan.hasNext("\\}")) {
            this.readPassStatement();
        }
        this.scan.next();
    }

    private void readTechnique() {
        this.scan.next();
        String name = this.scan.hasNext("\\{") ? null : this.readString("\\{");
        this.scan.next();
        while (!this.scan.hasNext("\\}")) {
            this.readPass();
        }
        this.scan.next();
    }

    private boolean readMaterialStatement() {
        if (this.scan.hasNext("technique")) {
            this.readTechnique();
            return true;
        }
        if (this.scan.hasNext("receive_shadows")) {
            this.scan.next();
            String isOn = this.scan.next();
            if (isOn == null || isOn.equals("true")) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    private void readMaterial() {
        this.scan.next();
        this.matName = this.readString("\\{");
        this.scan.next();
        while (!this.scan.hasNext("\\}")) {
            this.readMaterialStatement();
        }
        this.scan.next();
    }

    private Material compileMaterial() {
        Material mat = this.noLight ? new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md") : new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        if (this.blend) {
            RenderState rs = mat.getAdditionalRenderState();
            rs.setAlphaTest(true);
            rs.setAlphaFallOff(0.01f);
            rs.setBlendMode(RenderState.BlendMode.Alpha);
            if (this.twoSide) {
                rs.setFaceCullMode(RenderState.FaceCullMode.Off);
            }
            mat.setTransparent(true);
            if (!this.noLight) {
                mat.setBoolean("UseAlpha", true);
            }
        } else if (this.twoSide) {
            RenderState rs = mat.getAdditionalRenderState();
            rs.setFaceCullMode(RenderState.FaceCullMode.Off);
        }
        if (!this.noLight) {
            if (this.shinines > 0.0f) {
                mat.setFloat("Shininess", this.shinines);
            } else {
                mat.setFloat("Shininess", 16.0f);
            }
            if (this.vcolor) {
                mat.setBoolean("UseVertexColor", true);
            }
            if (this.texture != null) {
                mat.setTexture("DiffuseMap", this.texture);
            }
            mat.setBoolean("UseMaterialColors", true);
            if (this.diffuse != null) {
                mat.setColor("Diffuse", this.diffuse);
            } else {
                mat.setColor("Diffuse", ColorRGBA.White);
            }
            if (this.ambient != null) {
                mat.setColor("Ambient", this.ambient);
            } else {
                mat.setColor("Ambient", ColorRGBA.DarkGray);
            }
            if (this.specular != null) {
                mat.setColor("Specular", this.specular);
            } else {
                mat.setColor("Specular", ColorRGBA.Black);
            }
            if (this.emissive != null) {
                mat.setColor("GlowColor", this.emissive);
            }
        } else {
            if (this.vcolor) {
                mat.setBoolean("VertexColor", true);
            }
            if (this.texture != null) {
                mat.setTexture("ColorMap", this.texture);
            }
            if (this.diffuse != null) {
                mat.setColor("Color", this.diffuse);
            }
            if (this.emissive != null) {
                mat.setColor("GlowColor", this.emissive);
            }
        }
        this.noLight = false;
        this.texture = null;
        this.diffuse = null;
        this.specular = null;
        this.texture = null;
        this.shinines = 0.0f;
        this.vcolor = false;
        this.blend = false;
        return mat;
    }

    public Object load(AssetInfo info) throws IOException {
        MaterialList list;
        this.folderName = info.getKey().getFolder();
        this.assetManager = info.getManager();
        this.scan = new Scanner(info.openStream());
        this.scan.useLocale(Locale.US);
        if (this.scan.hasNext("import")) {
            MaterialExtensionSet matExts = null;
            if (info.getKey() instanceof OgreMaterialKey) {
                matExts = ((OgreMaterialKey)info.getKey()).getMaterialExtensionSet();
            }
            if (matExts == null) {
                throw new IOException("Must specify MaterialExtensionSet when loading\nOgre3D materials with extended materials");
            }
            list = new MaterialExtensionLoader().load(this.assetManager, matExts, this.scan);
        } else {
            list = new MaterialList();
            while (this.scan.hasNext("material")) {
                this.readMaterial();
                Material mat = this.compileMaterial();
                list.put(this.matName, mat);
            }
        }
        this.scan.close();
        return list;
    }
}

