/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.scene.plugins.blender.DataRepository;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.NoiseGenerator;
import com.jme3.scene.plugins.blender.textures.TextureGenerator;
import com.jme3.scene.plugins.blender.textures.TextureHelper;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;

public class TextureGeneratorStucci
extends TextureGenerator {
    public TextureGeneratorStucci(NoiseGenerator noiseGenerator) {
        super(noiseGenerator);
    }

    protected Texture generate(Structure tex, int width, int height, DataRepository dataRepository) {
        float noisesize = ((Number)tex.getFieldValue("noisesize")).floatValue();
        int noisebasis = ((Number)tex.getFieldValue("noisebasis")).intValue();
        int noisetype = ((Number)tex.getFieldValue("noisetype")).intValue();
        float turbul = ((Number)tex.getFieldValue("turbul")).floatValue();
        boolean isHard = noisetype != 0;
        int stype = ((Number)tex.getFieldValue("stype")).intValue();
        float[] texvec = new float[]{0.0f, 0.0f, 0.0f};
        TextureHelper.TexResult texres = new TextureHelper.TexResult();
        float wDelta = 1.0f / (float)width;
        float hDelta = 1.0f / (float)height;
        int halfW = width;
        int halfH = height;
        TextureHelper.ColorBand colorBand = this.readColorband(tex, dataRepository);
        Image.Format format = colorBand != null ? Image.Format.RGB8 : Image.Format.Luminance8;
        int bytesPerPixel = colorBand != null ? 3 : 1;
        ByteBuffer data = BufferUtils.createByteBuffer((width <<= 1) * (height <<= 1) * bytesPerPixel);
        for (int i = -halfW; i < halfW; ++i) {
            texvec[0] = wDelta * (float)i;
            for (int j = -halfH; j < halfH; ++j) {
                texvec[1] = hDelta * (float)j;
                float b2 = this.noiseGenerator.bliGNoise(noisesize, texvec[0], texvec[1], texvec[2], isHard, noisebasis);
                float ofs = turbul / 200.0f;
                if (stype != 0) {
                    ofs *= b2 * b2;
                }
                texres.tin = this.noiseGenerator.bliGNoise(noisesize, texvec[0], texvec[1], texvec[2] + ofs, isHard, noisebasis);
                if (colorBand != null) {
                    this.noiseGenerator.doColorband(colorBand, texres, dataRepository);
                    if (texres.nor != null) {
                        texres.nor[0] = this.noiseGenerator.bliGNoise(noisesize, texvec[0] + ofs, texvec[1], texvec[2], isHard, noisebasis);
                        texres.nor[1] = this.noiseGenerator.bliGNoise(noisesize, texvec[0], texvec[1] + ofs, texvec[2], isHard, noisebasis);
                        texres.nor[2] = texres.tin;
                        this.noiseGenerator.texNormalDerivate(colorBand, texres, dataRepository);
                        if (stype == 2) {
                            texres.nor[0] = -texres.nor[0];
                            texres.nor[1] = -texres.nor[1];
                            texres.nor[2] = -texres.nor[2];
                        }
                    }
                }
                if (stype == 2) {
                    texres.tin = 1.0f - texres.tin;
                }
                if (texres.tin < 0.0f) {
                    texres.tin = 0.0f;
                }
                if (colorBand != null) {
                    data.put((byte)(texres.tr * 255.0f));
                    data.put((byte)(texres.tg * 255.0f));
                    data.put((byte)(texres.tb * 255.0f));
                    continue;
                }
                data.put((byte)(texres.tin * 255.0f));
            }
        }
        return new Texture2D(new Image(format, width, height, data));
    }
}

