/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.math.FastMath;
import com.jme3.scene.plugins.blender.DataRepository;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.NoiseGenerator;
import com.jme3.scene.plugins.blender.textures.TextureGenerator;
import com.jme3.scene.plugins.blender.textures.TextureHelper;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;

public class TextureGeneratorNoise
extends TextureGenerator {
    public TextureGeneratorNoise(NoiseGenerator noiseGenerator) {
        super(noiseGenerator);
    }

    protected Texture generate(Structure tex, int width, int height, DataRepository dataRepository) {
        float div = 3.0f;
        int noisedepth = ((Number)tex.getFieldValue("noisedepth")).intValue();
        float contrast = ((Number)tex.getFieldValue("contrast")).floatValue();
        float brightness = ((Number)tex.getFieldValue("bright")).floatValue();
        TextureHelper.TexResult texres = new TextureHelper.TexResult();
        int halfW = width;
        int halfH = height;
        TextureHelper.ColorBand colorBand = this.readColorband(tex, dataRepository);
        Image.Format format = colorBand != null ? Image.Format.RGB8 : Image.Format.Luminance8;
        int bytesPerPixel = colorBand != null ? 3 : 1;
        ByteBuffer data = BufferUtils.createByteBuffer((width <<= 1) * (height <<= 1) * bytesPerPixel);
        for (int i = -halfW; i < halfW; ++i) {
            for (int j = -halfH; j < halfH; ++j) {
                int ran = FastMath.rand.nextInt();
                int val = ran & 3;
                int loop = noisedepth;
                while (loop-- != 0) {
                    val *= (ran >>= 2) & 3;
                    div *= 3.0f;
                }
                texres.tin = val;
                if (colorBand != null) {
                    this.noiseGenerator.doColorband(colorBand, texres, dataRepository);
                    this.noiseGenerator.brightnesAndContrastRGB(tex, texres);
                    data.put((byte)(texres.tr * 255.0f));
                    data.put((byte)(texres.tg * 255.0f));
                    data.put((byte)(texres.tb * 255.0f));
                    continue;
                }
                this.noiseGenerator.brightnesAndContrast(texres, contrast, brightness);
                data.put((byte)(texres.tin * 255.0f));
            }
        }
        return new Texture2D(new Image(format, width, height, data));
    }
}

