/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.scene.plugins.blender.DataRepository;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.NoiseGenerator;
import com.jme3.scene.plugins.blender.textures.TextureGenerator;
import com.jme3.scene.plugins.blender.textures.TextureHelper;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;

public class TextureGeneratorMagic
extends TextureGenerator {
    public TextureGeneratorMagic(NoiseGenerator noiseGenerator) {
        super(noiseGenerator);
    }

    protected Texture generate(Structure tex, int width, int height, DataRepository dataRepository) {
        int noisedepth = ((Number)tex.getFieldValue("noisedepth")).intValue();
        float turbul = ((Number)tex.getFieldValue("turbul")).floatValue() / 5.0f;
        float[] texvec = new float[]{0.0f, 0.0f, 0.0f};
        TextureHelper.TexResult texres = new TextureHelper.TexResult();
        float wDelta = 1.0f / (float)width;
        float hDelta = 1.0f / (float)height;
        int halfW = width;
        int halfH = height;
        TextureHelper.ColorBand colorBand = this.readColorband(tex, dataRepository);
        ByteBuffer data = BufferUtils.createByteBuffer((width <<= 1) * (height <<= 1) * 4);
        for (int i = -halfW; i < halfW; ++i) {
            texvec[0] = wDelta * (float)i;
            for (int j = -halfH; j < halfH; ++j) {
                float turb = turbul;
                texvec[1] = hDelta * (float)j;
                float x = (float)Math.sin((texvec[0] + texvec[1]) * 5.0f);
                float y = (float)Math.cos((-texvec[0] + texvec[1]) * 5.0f);
                float z = -((float)Math.cos((-texvec[0] - texvec[1]) * 5.0f));
                if (colorBand != null) {
                    texres.tin = 0.3333f * (x + y + z);
                    this.noiseGenerator.doColorband(colorBand, texres, dataRepository);
                } else {
                    if (noisedepth > 0) {
                        y *= turb;
                        y = -((float)Math.cos((x *= turb) - y + (z *= turb))) * turb;
                        if (noisedepth > 1) {
                            x = (float)Math.cos(x - y - z) * turb;
                            if (noisedepth > 2) {
                                z = (float)Math.sin(-x - y - z) * turb;
                                if (noisedepth > 3) {
                                    x = -((float)Math.cos(-x + y - z)) * turb;
                                    if (noisedepth > 4) {
                                        y = -((float)Math.sin(-x + y + z)) * turb;
                                        if (noisedepth > 5) {
                                            y = -((float)Math.cos(-x + y + z)) * turb;
                                            if (noisedepth > 6) {
                                                x = (float)Math.cos(x + y + z) * turb;
                                                if (noisedepth > 7) {
                                                    z = (float)Math.sin(x + y - z) * turb;
                                                    if (noisedepth > 8) {
                                                        x = -((float)Math.cos(-x - y + z)) * turb;
                                                        if (noisedepth > 9) {
                                                            y = -((float)Math.sin(x - y + z)) * turb;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (turb != 0.0f) {
                        x /= (turb *= 2.0f);
                        y /= turb;
                        z /= turb;
                    }
                    texres.tr = 0.5f - x;
                    texres.tg = 0.5f - y;
                    texres.tb = 0.5f - z;
                }
                this.noiseGenerator.brightnesAndContrastRGB(tex, texres);
                data.put((byte)(texres.tin * 255.0f));
                data.put((byte)(texres.tb * 255.0f));
                data.put((byte)(texres.tg * 255.0f));
                data.put((byte)(texres.tr * 255.0f));
            }
        }
        return new Texture2D(new Image(Image.Format.ABGR8, width, height, data));
    }
}

