/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.modifiers;

import com.jme3.animation.AnimControl;
import com.jme3.animation.Animation;
import com.jme3.animation.Bone;
import com.jme3.animation.BoneAnimation;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SkeletonControl;
import com.jme3.math.Matrix4f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.DataRepository;
import com.jme3.scene.plugins.blender.animations.ArmatureHelper;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.FileBlockHeader;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.modifiers.Modifier;
import com.jme3.scene.plugins.blender.objects.ObjectHelper;
import com.jme3.scene.plugins.ogre.AnimData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ArmatureModifier
extends Modifier {
    ArmatureModifier() {
    }

    public ArmatureModifier(Structure objectStructure, Structure modifierStructure, DataRepository dataRepository) throws BlenderFileException {
        Pointer pArmatureObject = (Pointer)modifierStructure.getFieldValue("object");
        if (pArmatureObject.isNotNull()) {
            ObjectHelper objectHelper = (ObjectHelper)dataRepository.getHelper(ObjectHelper.class);
            Structure armatureObject = (Structure)dataRepository.getLoadedFeature(pArmatureObject.getOldMemoryAddress(), DataRepository.LoadedFeatureDataType.LOADED_STRUCTURE);
            if (armatureObject == null) {
                armatureObject = pArmatureObject.fetchData(dataRepository.getInputStream()).get(0);
                objectHelper.toObject(armatureObject, dataRepository);
            }
            this.additionalData = armatureObject.getOldMemoryAddress();
            ArmatureHelper armatureHelper = (ArmatureHelper)dataRepository.getHelper(ArmatureHelper.class);
            Matrix4f armatureObjectMatrix = objectHelper.getTransformationMatrix(armatureObject);
            Matrix4f inverseMeshObjectMatrix = objectHelper.getTransformationMatrix(objectStructure).invert();
            Matrix4f additionalRootBoneTransformation = inverseMeshObjectMatrix.multLocal(armatureObjectMatrix);
            Bone[] bones = armatureHelper.buildBonesStructure(0L, additionalRootBoneTransformation);
            Skeleton skeleton = new Skeleton(bones);
            dataRepository.addLoadedFeatures(armatureObject.getOldMemoryAddress(), armatureObject.getName(), armatureObject, skeleton);
            String objectName = objectStructure.getName();
            Set<String> animationNames = dataRepository.getBlenderKey().getAnimationNames(objectName);
            if (animationNames != null && animationNames.size() > 0) {
                ArrayList<Animation> animations = new ArrayList<Animation>();
                List<FileBlockHeader> actionHeaders = dataRepository.getFileBlocks(1094909952);
                for (FileBlockHeader header : actionHeaders) {
                    Structure actionStructure = header.getStructure(dataRepository);
                    String actionName = actionStructure.getName();
                    if (!animationNames.contains(actionName)) continue;
                    int[] animationFrames = dataRepository.getBlenderKey().getAnimationFrames(objectName, actionName);
                    int fps = dataRepository.getBlenderKey().getFps();
                    float start = (float)animationFrames[0] / (float)fps;
                    float stop = (float)animationFrames[1] / (float)fps;
                    BoneAnimation boneAnimation = new BoneAnimation(actionName, stop - start);
                    boneAnimation.setTracks(armatureHelper.getTracks(actionStructure, dataRepository, objectName, actionName));
                    animations.add(boneAnimation);
                }
                this.jmeModifierRepresentation = new AnimData(new Skeleton(bones), animations);
            }
        }
    }

    public Node apply(Node node, DataRepository dataRepository) {
        if (this.jmeModifierRepresentation == null) {
            return node;
        }
        AnimData ad = (AnimData)this.jmeModifierRepresentation;
        ArrayList<Animation> animList = ad.anims;
        Long modifierArmatureObject = (Long)this.additionalData;
        if (animList != null && animList.size() > 0) {
            List<Constraint> constraints = dataRepository.getConstraints(modifierArmatureObject);
            HashMap<String, Animation> anims = new HashMap<String, Animation>();
            for (int i = 0; i < animList.size(); ++i) {
                BoneAnimation boneAnimation = (BoneAnimation)animList.get(i).clone();
                if (constraints != null && constraints.size() > 0) {
                    for (Constraint constraint : constraints) {
                        constraint.affectAnimation(ad.skeleton, boneAnimation);
                    }
                }
                anims.put(boneAnimation.getName(), boneAnimation);
            }
            Mesh[] meshes = null;
            ArrayList<Mesh> meshesList = new ArrayList<Mesh>();
            List<Spatial> children = node.getChildren();
            for (Spatial child : children) {
                if (!(child instanceof Geometry)) continue;
                meshesList.add(((Geometry)child).getMesh());
            }
            if (meshesList.size() > 0) {
                meshes = meshesList.toArray(new Mesh[meshesList.size()]);
            }
            SkeletonControl skeletonControl = new SkeletonControl(meshes, ad.skeleton);
            AnimControl control = node.getControl(AnimControl.class);
            if (control == null) {
                control = new AnimControl(ad.skeleton);
            } else {
                Skeleton controlSkeleton = control.getSkeleton();
                int boneIndexIncrease = controlSkeleton.getBoneCount();
                Skeleton skeleton = this.merge(controlSkeleton, ad.skeleton);
                HashMap<String, Animation> animations = new HashMap<String, Animation>();
                for (String string : control.getAnimationNames()) {
                    animations.put(string, control.getAnim(string));
                }
                for (Map.Entry entry : anims.entrySet()) {
                    BoneAnimation ba = (BoneAnimation)entry.getValue();
                    for (int i = 0; i < ba.getTracks().length; ++i) {
                        BoneTrack bt = ba.getTracks()[i];
                        int newBoneIndex = bt.getTargetBoneIndex() + boneIndexIncrease;
                        ba.getTracks()[i] = new BoneTrack(newBoneIndex, bt.getTimes(), bt.getTranslations(), bt.getRotations(), bt.getScales());
                    }
                    animations.put((String)entry.getKey(), (Animation)entry.getValue());
                }
                node.removeControl(control);
                control = new AnimControl(skeleton);
            }
            control.setAnimations(anims);
            node.addControl(control);
            node.addControl(skeletonControl);
        }
        return node;
    }

    public String getType() {
        return "ArmatureModifierData";
    }

    protected Skeleton merge(Skeleton s1, Skeleton s2) {
        int i;
        ArrayList<Bone> bones = new ArrayList<Bone>(s1.getBoneCount() + s2.getBoneCount());
        for (i = 0; i < s1.getBoneCount(); ++i) {
            bones.add(s1.getBone(i));
        }
        for (i = 1; i < s2.getBoneCount(); ++i) {
            bones.add(s2.getBone(i));
        }
        return new Skeleton(bones.toArray(new Bone[bones.size()]));
    }
}

