/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender;

import com.jme3.asset.BlenderKey;
import com.jme3.light.AmbientLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.Camera;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.plugins.blender.DataRepository;
import com.jme3.scene.plugins.blender.cameras.CameraHelper;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.lights.LightHelper;
import com.jme3.scene.plugins.blender.materials.MaterialHelper;
import com.jme3.scene.plugins.blender.meshes.MeshHelper;
import com.jme3.scene.plugins.blender.objects.ObjectHelper;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JmeConverter {
    private final DataRepository dataRepository;

    public JmeConverter(DataRepository dataRepository) {
        if (dataRepository.getAssetManager() == null) {
            throw new IllegalArgumentException("Cannot find asset manager!");
        }
        if (dataRepository.getBlenderKey() == null) {
            throw new IllegalArgumentException("Cannot find blender key!");
        }
        if (dataRepository.getDnaBlockData() == null) {
            throw new IllegalArgumentException("Cannot find dna block!");
        }
        if (dataRepository.getInputStream() == null) {
            throw new IllegalArgumentException("Cannot find blender file stream!");
        }
        this.dataRepository = dataRepository;
    }

    public Node toScene(Structure structure) {
        if ((this.dataRepository.getBlenderKey().getFeaturesToLoad() & 0xFFFF) == 0) {
            return null;
        }
        Structure id = (Structure)structure.getFieldValue("id");
        String sceneName = id.getFieldValue("name").toString();
        if (this.dataRepository.getBlenderKey().getLayersToLoad() < 0) {
            int lay = ((Number)structure.getFieldValue("lay")).intValue();
            this.dataRepository.getBlenderKey().setLayersToLoad(lay);
        }
        return new Node(sceneName);
    }

    public Camera toCamera(Structure structure) throws BlenderFileException {
        CameraHelper cameraHelper = (CameraHelper)this.dataRepository.getHelper(CameraHelper.class);
        if (cameraHelper.shouldBeLoaded(structure, this.dataRepository)) {
            return cameraHelper.toCamera(structure);
        }
        return null;
    }

    public Light toLight(Structure structure) throws BlenderFileException {
        LightHelper lightHelper = (LightHelper)this.dataRepository.getHelper(LightHelper.class);
        if (lightHelper.shouldBeLoaded(structure, this.dataRepository)) {
            return lightHelper.toLight(structure, this.dataRepository);
        }
        return null;
    }

    public Object toObject(Structure structure) throws BlenderFileException {
        ObjectHelper objectHelper = (ObjectHelper)this.dataRepository.getHelper(ObjectHelper.class);
        if (objectHelper.shouldBeLoaded(structure, this.dataRepository)) {
            return objectHelper.toObject(structure, this.dataRepository);
        }
        return null;
    }

    public List<Geometry> toMesh(Structure structure) throws BlenderFileException {
        MeshHelper meshHelper = (MeshHelper)this.dataRepository.getHelper(MeshHelper.class);
        if (meshHelper.shouldBeLoaded(structure, this.dataRepository)) {
            return meshHelper.toMesh(structure, this.dataRepository);
        }
        return null;
    }

    public Material toMaterial(Structure structure) throws BlenderFileException {
        MaterialHelper materialHelper = (MaterialHelper)this.dataRepository.getHelper(MaterialHelper.class);
        if (materialHelper.shouldBeLoaded(structure, this.dataRepository)) {
            return materialHelper.toMaterial(structure, this.dataRepository);
        }
        return null;
    }

    public BlenderKey.WorldData toWorldData(Structure structure) {
        BlenderKey.WorldData result = new BlenderKey.WorldData();
        AmbientLight ambientLight = new AmbientLight();
        float ambr = ((Number)structure.getFieldValue("ambr")).floatValue();
        float ambg = ((Number)structure.getFieldValue("ambg")).floatValue();
        float ambb = ((Number)structure.getFieldValue("ambb")).floatValue();
        ambientLight.setColor(new ColorRGBA(ambr, ambg, ambb, 0.0f));
        result.setAmbientLight(ambientLight);
        return result;
    }
}

