/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.BlenderKey;
import com.jme3.asset.ModelKey;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.DataRepository;
import com.jme3.scene.plugins.blender.JmeConverter;
import com.jme3.scene.plugins.blender.animations.ArmatureHelper;
import com.jme3.scene.plugins.blender.animations.IpoHelper;
import com.jme3.scene.plugins.blender.cameras.CameraHelper;
import com.jme3.scene.plugins.blender.constraints.ConstraintHelper;
import com.jme3.scene.plugins.blender.curves.CurvesHelper;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.BlenderInputStream;
import com.jme3.scene.plugins.blender.file.FileBlockHeader;
import com.jme3.scene.plugins.blender.lights.LightHelper;
import com.jme3.scene.plugins.blender.materials.MaterialHelper;
import com.jme3.scene.plugins.blender.meshes.MeshHelper;
import com.jme3.scene.plugins.blender.modifiers.ModifierHelper;
import com.jme3.scene.plugins.blender.objects.ObjectHelper;
import com.jme3.scene.plugins.blender.particles.ParticlesHelper;
import com.jme3.scene.plugins.blender.textures.TextureHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlenderModelLoader
implements AssetLoader {
    private static final Logger LOGGER = Logger.getLogger(BlenderModelLoader.class.getName());

    public Spatial load(AssetInfo assetInfo) throws IOException {
        try {
            FileBlockHeader fileBlock;
            BlenderKey blenderKey;
            ModelKey modelKey = (ModelKey)assetInfo.getKey();
            if (modelKey instanceof BlenderKey) {
                blenderKey = (BlenderKey)modelKey;
            } else {
                blenderKey = new BlenderKey(modelKey.getName());
                blenderKey.setAssetRootPath(modelKey.getFolder());
            }
            BlenderInputStream inputStream = new BlenderInputStream(assetInfo.openStream(), assetInfo.getManager());
            ArrayList<FileBlockHeader> blocks = new ArrayList<FileBlockHeader>();
            DataRepository dataRepository = new DataRepository();
            dataRepository.setAssetManager(assetInfo.getManager());
            dataRepository.setInputStream(inputStream);
            dataRepository.setBlenderKey(blenderKey);
            dataRepository.putHelper(ArmatureHelper.class, new ArmatureHelper(inputStream.getVersionNumber()));
            dataRepository.putHelper(TextureHelper.class, new TextureHelper(inputStream.getVersionNumber()));
            dataRepository.putHelper(MeshHelper.class, new MeshHelper(inputStream.getVersionNumber()));
            dataRepository.putHelper(ObjectHelper.class, new ObjectHelper(inputStream.getVersionNumber()));
            dataRepository.putHelper(CurvesHelper.class, new CurvesHelper(inputStream.getVersionNumber()));
            dataRepository.putHelper(LightHelper.class, new LightHelper(inputStream.getVersionNumber()));
            dataRepository.putHelper(CameraHelper.class, new CameraHelper(inputStream.getVersionNumber()));
            dataRepository.putHelper(ModifierHelper.class, new ModifierHelper(inputStream.getVersionNumber()));
            dataRepository.putHelper(MaterialHelper.class, new MaterialHelper(inputStream.getVersionNumber()));
            dataRepository.putHelper(ConstraintHelper.class, new ConstraintHelper(inputStream.getVersionNumber(), dataRepository));
            dataRepository.putHelper(IpoHelper.class, new IpoHelper(inputStream.getVersionNumber()));
            dataRepository.putHelper(ParticlesHelper.class, new ParticlesHelper(inputStream.getVersionNumber()));
            if (blenderKey.isFixUpAxis()) {
                ObjectHelper objectHelper = (ObjectHelper)dataRepository.getHelper(ObjectHelper.class);
                objectHelper.setyIsUpAxis(true);
                CurvesHelper curvesHelper = (CurvesHelper)dataRepository.getHelper(CurvesHelper.class);
                curvesHelper.setyIsUpAxis(true);
            }
            MaterialHelper materialHelper = (MaterialHelper)dataRepository.getHelper(MaterialHelper.class);
            materialHelper.setFaceCullMode(blenderKey.getFaceCullMode());
            do {
                if ((fileBlock = new FileBlockHeader(inputStream, dataRepository)).isDnaBlock()) continue;
                blocks.add(fileBlock);
            } while (!fileBlock.isLastBlock());
            JmeConverter converter = new JmeConverter(dataRepository);
            BlenderKey.LoadingResults loadingResults = blenderKey.prepareLoadingResults();
            for (FileBlockHeader block : blocks) {
                Object object;
                if (block.getCode() != 1329725440 || !((object = converter.toObject(block.getStructure(dataRepository))) instanceof Node)) continue;
                LOGGER.log(Level.INFO, "{0}: {1}--> {2}", new Object[]{((Node)object).getName(), ((Node)object).getLocalTranslation().toString(), ((Node)object).getParent() == null ? "null" : ((Node)object).getParent().getName()});
                if (((Node)object).getParent() != null) continue;
                loadingResults.addObject((Node)object);
            }
            inputStream.close();
            List<Node> objects = loadingResults.getObjects();
            if (objects.size() > 0) {
                Node modelNode = new Node(blenderKey.getName());
                for (Node node : objects) {
                    modelNode.attachChild(node);
                }
                return modelNode;
            }
            if (objects.size() == 1) {
                return objects.get(0);
            }
        }
        catch (BlenderFileException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }
}

