/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post;

import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.Material;
import com.jme3.post.Filter;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.Camera;
import com.jme3.renderer.Caps;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture2D;
import com.jme3.ui.Picture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterPostProcessor
implements SceneProcessor,
Savable {
    private RenderManager renderManager;
    private Renderer renderer;
    private ViewPort viewPort;
    private FrameBuffer renderFrameBufferMS;
    private int numSamples = 1;
    private FrameBuffer renderFrameBuffer;
    private Texture2D filterTexture;
    private Texture2D depthTexture;
    private List<Filter> filters = new ArrayList<Filter>();
    private AssetManager assetManager;
    private Camera filterCam = new Camera(1, 1);
    private Picture fsQuad;
    private boolean computeDepth = false;
    private FrameBuffer outputBuffer;
    private int width;
    private int height;
    private float bottom;
    private float left;
    private float right;
    private float top;
    private int originalWidth;
    private int originalHeight;
    private int lastFilterIndex = -1;
    private boolean cameraInit = false;
    Picture pic = new Picture("debug");

    public FilterPostProcessor(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    public FilterPostProcessor() {
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
        filter.setProcessor(this);
        if (this.isInitialized()) {
            this.initFilter(filter, this.viewPort);
        }
        this.setFilterState(filter, filter.isEnabled());
    }

    public void removeFilter(Filter filter) {
        this.filters.remove(filter);
        filter.cleanup(this.renderer);
        this.updateLastFilterIndex();
    }

    public Iterator<Filter> getFilterIterator() {
        return this.filters.iterator();
    }

    @Override
    public void initialize(RenderManager rm, ViewPort vp) {
        this.renderManager = rm;
        this.renderer = rm.getRenderer();
        this.viewPort = vp;
        this.fsQuad = new Picture("filter full screen quad");
        Camera cam = vp.getCamera();
        this.left = cam.getViewPortLeft();
        this.right = cam.getViewPortRight();
        this.top = cam.getViewPortTop();
        this.bottom = cam.getViewPortBottom();
        this.originalWidth = cam.getWidth();
        this.originalHeight = cam.getHeight();
        this.reshape(vp, cam.getWidth(), cam.getHeight());
    }

    private void initFilter(Filter filter, ViewPort vp) {
        filter.init(this.assetManager, this.renderManager, vp, this.width, this.height);
        if (filter.isRequiresDepthTexture()) {
            if (!this.computeDepth && this.renderFrameBuffer != null) {
                this.depthTexture = new Texture2D(this.width, this.height, Image.Format.Depth24);
                this.renderFrameBuffer.setDepthTexture(this.depthTexture);
            }
            this.computeDepth = true;
            filter.getMaterial().setTexture("DepthTexture", this.depthTexture);
        }
    }

    private void renderProcessing(Renderer r, FrameBuffer buff, Material mat) {
        if (buff == this.outputBuffer) {
            this.fsQuad.setWidth(this.width);
            this.fsQuad.setHeight(this.height);
            this.filterCam.resize(this.originalWidth, this.originalHeight, true);
            this.fsQuad.setPosition(this.left * (float)this.originalWidth, this.bottom * (float)this.originalHeight);
        } else {
            this.fsQuad.setWidth(buff.getWidth());
            this.fsQuad.setHeight(buff.getHeight());
            this.filterCam.resize(buff.getWidth(), buff.getHeight(), true);
            this.fsQuad.setPosition(0.0f, 0.0f);
        }
        if (mat.getAdditionalRenderState().isDepthWrite()) {
            mat.getAdditionalRenderState().setDepthTest(false);
            mat.getAdditionalRenderState().setDepthWrite(false);
        }
        this.fsQuad.setMaterial(mat);
        this.fsQuad.updateGeometricState();
        this.renderManager.setCamera(this.filterCam, true);
        r.setFrameBuffer(buff);
        r.clearBuffers(false, true, true);
        this.renderManager.renderGeometry(this.fsQuad);
    }

    @Override
    public boolean isInitialized() {
        return this.viewPort != null;
    }

    @Override
    public void postQueue(RenderQueue rq) {
        for (Filter filter : this.filters) {
            if (!filter.isEnabled()) continue;
            filter.postQueue(this.renderManager, this.viewPort);
        }
    }

    private void renderFilterChain(Renderer r, FrameBuffer sceneFb) {
        Texture2D tex = this.filterTexture;
        FrameBuffer buff = sceneFb;
        boolean msDepth = this.depthTexture != null && this.depthTexture.getImage().getMultiSamples() > 1;
        for (int i = 0; i < this.filters.size(); ++i) {
            Filter filter = this.filters.get(i);
            if (!filter.isEnabled()) continue;
            if (filter.getPostRenderPasses() != null) {
                for (Filter.Pass pass : filter.getPostRenderPasses()) {
                    pass.beforeRender();
                    if (pass.requiresSceneAsTexture()) {
                        pass.getPassMaterial().setTexture("Texture", tex);
                        if (tex.getImage().getMultiSamples() > 1) {
                            pass.getPassMaterial().setInt("NumSamples", tex.getImage().getMultiSamples());
                        } else {
                            pass.getPassMaterial().clearParam("NumSamples");
                        }
                    }
                    if (pass.requiresDepthAsTexture()) {
                        pass.getPassMaterial().setTexture("DepthTexture", this.depthTexture);
                        if (msDepth) {
                            pass.getPassMaterial().setInt("NumSamplesDepth", this.depthTexture.getImage().getMultiSamples());
                        } else {
                            pass.getPassMaterial().clearParam("NumSamplesDepth");
                        }
                    }
                    this.renderProcessing(r, pass.getRenderFrameBuffer(), pass.getPassMaterial());
                }
            }
            filter.postFrame(this.renderManager, this.viewPort, buff, sceneFb);
            Material mat = filter.getMaterial();
            if (msDepth && filter.isRequiresDepthTexture()) {
                mat.setInt("NumSamplesDepth", this.depthTexture.getImage().getMultiSamples());
            }
            if (filter.isRequiresSceneTexture()) {
                mat.setTexture("Texture", tex);
                if (tex.getImage().getMultiSamples() > 1) {
                    mat.setInt("NumSamples", tex.getImage().getMultiSamples());
                } else {
                    mat.clearParam("NumSamples");
                }
            }
            buff = this.outputBuffer;
            if (i != this.lastFilterIndex) {
                buff = filter.getRenderFrameBuffer();
                tex = filter.getRenderedTexture();
            }
            this.renderProcessing(r, buff, mat);
        }
    }

    @Override
    public void postFrame(FrameBuffer out) {
        FrameBuffer sceneBuffer = this.renderFrameBuffer;
        if (this.renderFrameBufferMS != null && !this.renderer.getCaps().contains((Object)Caps.OpenGL31)) {
            this.renderer.copyFrameBuffer(this.renderFrameBufferMS, this.renderFrameBuffer);
        } else if (this.renderFrameBufferMS != null) {
            sceneBuffer = this.renderFrameBufferMS;
        }
        this.renderFilterChain(this.renderer, sceneBuffer);
        this.renderManager.setCamera(this.viewPort.getCamera(), false);
        this.renderer.setFrameBuffer(this.outputBuffer);
    }

    @Override
    public void preFrame(float tpf) {
        if (this.filters.isEmpty() || this.lastFilterIndex == -1) {
            if (this.cameraInit) {
                this.viewPort.getCamera().resize(this.originalWidth, this.originalHeight, true);
                this.viewPort.getCamera().setViewPort(this.left, this.right, this.bottom, this.top);
                this.viewPort.setOutputFrameBuffer(this.outputBuffer);
                this.cameraInit = false;
            }
        } else {
            if (this.renderFrameBufferMS != null) {
                this.viewPort.setOutputFrameBuffer(this.renderFrameBufferMS);
            } else {
                this.viewPort.setOutputFrameBuffer(this.renderFrameBuffer);
            }
            if (!this.cameraInit) {
                this.viewPort.getCamera().resize(this.width, this.height, true);
                this.viewPort.getCamera().setViewPort(0.0f, 1.0f, 0.0f, 1.0f);
            }
        }
        for (Filter filter : this.filters) {
            if (!filter.isEnabled()) continue;
            filter.preFrame(tpf);
        }
    }

    protected void setFilterState(Filter filter, boolean enabled) {
        if (this.filters.contains(filter)) {
            filter.enabled = enabled;
            this.updateLastFilterIndex();
        }
    }

    private void updateLastFilterIndex() {
        this.lastFilterIndex = -1;
        for (int i = this.filters.size() - 1; i >= 0 && this.lastFilterIndex == -1; --i) {
            if (!this.filters.get(i).isEnabled()) continue;
            this.lastFilterIndex = i;
            return;
        }
        if (this.lastFilterIndex == -1) {
            this.cleanup();
        }
    }

    @Override
    public void cleanup() {
        if (this.viewPort != null) {
            this.viewPort.getCamera().resize(this.originalWidth, this.originalHeight, true);
            this.viewPort.getCamera().setViewPort(this.left, this.right, this.bottom, this.top);
            this.viewPort.setOutputFrameBuffer(this.outputBuffer);
            this.viewPort = null;
        }
    }

    @Override
    public void reshape(ViewPort vp, int w, int h) {
        Camera cam = vp.getCamera();
        cam.setViewPort(this.left, this.right, this.bottom, this.top);
        cam.resize(w, h, false);
        this.left = cam.getViewPortLeft();
        this.right = cam.getViewPortRight();
        this.top = cam.getViewPortTop();
        this.bottom = cam.getViewPortBottom();
        this.originalWidth = w;
        this.originalHeight = h;
        cam.setViewPort(0.0f, 1.0f, 0.0f, 1.0f);
        this.width = (int)((float)w * Math.abs(this.right - this.left));
        this.height = (int)((float)h * Math.abs(this.bottom - this.top));
        this.width = Math.max(1, this.width);
        this.height = Math.max(1, this.height);
        cam.resize(this.width, this.height, false);
        this.cameraInit = true;
        this.computeDepth = false;
        if (this.renderFrameBuffer == null) {
            this.outputBuffer = this.viewPort.getOutputFrameBuffer();
        }
        EnumSet<Caps> caps = this.renderer.getCaps();
        if (this.numSamples > 1 && caps.contains((Object)Caps.FrameBufferMultisample)) {
            this.renderFrameBufferMS = new FrameBuffer(this.width, this.height, this.numSamples);
            if (caps.contains((Object)Caps.OpenGL31)) {
                Texture2D msColor = new Texture2D(this.width, this.height, this.numSamples, Image.Format.RGBA8);
                Texture2D msDepth = new Texture2D(this.width, this.height, this.numSamples, Image.Format.Depth);
                this.renderFrameBufferMS.setDepthTexture(msDepth);
                this.renderFrameBufferMS.setColorTexture(msColor);
                this.filterTexture = msColor;
                this.depthTexture = msDepth;
            } else {
                this.renderFrameBufferMS.setDepthBuffer(Image.Format.Depth);
                this.renderFrameBufferMS.setColorBuffer(Image.Format.RGBA8);
            }
        }
        if (this.numSamples <= 1 || !caps.contains((Object)Caps.OpenGL31)) {
            this.renderFrameBuffer = new FrameBuffer(this.width, this.height, 1);
            this.renderFrameBuffer.setDepthBuffer(Image.Format.Depth);
            this.filterTexture = new Texture2D(this.width, this.height, Image.Format.RGBA8);
            this.renderFrameBuffer.setColorTexture(this.filterTexture);
        }
        for (Filter filter : this.filters) {
            this.initFilter(filter, vp);
        }
        if (this.renderFrameBufferMS != null) {
            this.viewPort.setOutputFrameBuffer(this.renderFrameBufferMS);
        } else {
            this.viewPort.setOutputFrameBuffer(this.renderFrameBuffer);
        }
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void removeAllFilters() {
        this.filters.clear();
        this.updateLastFilterIndex();
    }

    public void setNumSamples(int numSamples) {
        if (numSamples <= 0) {
            throw new IllegalArgumentException("numSamples must be > 0");
        }
        this.numSamples = numSamples;
    }

    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.numSamples, "numSamples", 0);
        oc.writeSavableArrayList((ArrayList)this.filters, "filters", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.numSamples = ic.readInt("numSamples", 0);
        this.filters = ic.readSavableArrayList("filters", null);
        for (Filter filter : this.filters) {
            filter.setProcessor(this);
            this.setFilterState(filter, filter.isEnabled());
        }
        this.assetManager = im.getAssetManager();
    }

    public Texture2D getDepthTexture() {
        return this.depthTexture;
    }

    public Texture2D getFilterTexture() {
        return this.filterTexture;
    }
}

