/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.service;

import com.jme3.network.connection.Client;
import com.jme3.network.connection.Server;
import com.jme3.network.service.Service;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceManager {
    private Logger log = Logger.getLogger(ServiceManager.class.getName());
    private final List<Service> services = new ArrayList<Service>();
    private boolean client;
    public static final boolean CLIENT = true;
    public static final boolean SERVER = false;

    public ServiceManager(boolean client) {
        this.client = client;
    }

    public <T> T getService(Class cls) {
        for (Service service : this.services) {
            if (service.getClass() != cls) continue;
            return (T)service;
        }
        try {
            Constructor ctor;
            if (!Service.class.isAssignableFrom(cls)) {
                return null;
            }
            if (this.client) {
                try {
                    ctor = cls.getConstructor(Client.class);
                }
                catch (NoSuchMethodException nsme) {
                    this.log.log(Level.WARNING, "[ServiceManager][???] The service {0} does not support client mode.", cls);
                    return null;
                }
            }
            try {
                ctor = cls.getConstructor(Server.class);
            }
            catch (NoSuchMethodException nsme) {
                this.log.log(Level.WARNING, "[ServiceManager][???] The service {0} does not support server mode.", cls);
                return null;
            }
            Object inst = ctor.newInstance(this);
            this.services.add((Service)inst);
            return inst;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "[ServiceManager][???] Instantiaton of service failed.", e);
            return null;
        }
    }
}

