/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class Editor {
    static JMenuBar mb;
    static JMenu m;
    static JMenu m1;
    static JMenuItem c;
    static JMenuItem o;
    static JMenuItem sv;
    static JMenuItem q;
    static JMenuItem gk;
    static JMenuItem sk;
    static JTextPane pane;
    public static String X;
    public static int end;
    public static int s;
    public static String stf;
    public static String ck;
    public static String div;
    private static String SECRET_KEY;
    private static String SALTVALUE;
    private static byte[] iv;
    public static int[][] Forward_S_Box;
    public static int[][] Inv_S_Box;
    private static final byte[] IP;
    private static final byte[] FP;
    private static final byte[] E;
    private static final byte[][] S;
    private static final byte[] P;
    private static final byte[] PC1;
    private static final byte[] PC2;
    private static final byte[] rotations;
    private static long IV;
    static Color back_grey_cl;
    static Color forg_blue_cl;
    static Color forg_white_cl;

    static {
        SECRET_KEY = "";
        SALTVALUE = "";
        iv = new byte[16];
        int[][] nArrayArray = new int[16][];
        nArrayArray[0] = new int[]{99, 124, 119, 123, 242, 107, 111, 197, 48, 1, 103, 43, 254, 215, 171, 118};
        nArrayArray[1] = new int[]{202, 130, 201, 125, 250, 89, 71, 240, 173, 212, 162, 175, 156, 164, 114, 192};
        nArrayArray[2] = new int[]{183, 253, 147, 38, 54, 63, 247, 204, 52, 165, 229, 241, 113, 216, 49, 21};
        nArrayArray[3] = new int[]{4, 199, 35, 195, 24, 150, 5, 154, 7, 18, 128, 226, 235, 39, 178, 117};
        nArrayArray[4] = new int[]{9, 131, 44, 26, 27, 110, 90, 160, 82, 59, 214, 179, 41, 227, 47, 132};
        int[] nArray = new int[16];
        nArray[0] = 83;
        nArray[1] = 209;
        nArray[3] = 237;
        nArray[4] = 32;
        nArray[5] = 252;
        nArray[6] = 177;
        nArray[7] = 91;
        nArray[8] = 106;
        nArray[9] = 203;
        nArray[10] = 190;
        nArray[11] = 57;
        nArray[12] = 74;
        nArray[13] = 76;
        nArray[14] = 88;
        nArray[15] = 207;
        nArrayArray[5] = nArray;
        nArrayArray[6] = new int[]{208, 239, 170, 251, 67, 77, 51, 133, 69, 249, 2, 127, 80, 60, 159, 168};
        nArrayArray[7] = new int[]{81, 163, 64, 143, 146, 157, 56, 245, 188, 182, 218, 33, 16, 255, 243, 210};
        nArrayArray[8] = new int[]{205, 12, 19, 236, 95, 151, 68, 23, 196, 167, 126, 61, 100, 93, 25, 115};
        nArrayArray[9] = new int[]{96, 129, 79, 220, 34, 42, 144, 136, 70, 238, 184, 20, 222, 94, 11, 219};
        nArrayArray[10] = new int[]{224, 50, 58, 10, 73, 6, 36, 92, 194, 211, 172, 98, 145, 149, 228, 121};
        nArrayArray[11] = new int[]{231, 200, 55, 109, 141, 213, 78, 169, 108, 86, 244, 234, 101, 122, 174, 8};
        nArrayArray[12] = new int[]{186, 120, 37, 46, 28, 166, 180, 198, 232, 221, 116, 31, 75, 189, 139, 138};
        nArrayArray[13] = new int[]{112, 62, 181, 102, 72, 3, 246, 14, 97, 53, 87, 185, 134, 193, 29, 158};
        nArrayArray[14] = new int[]{225, 248, 152, 17, 105, 217, 142, 148, 155, 30, 135, 233, 206, 85, 40, 223};
        nArrayArray[15] = new int[]{140, 161, 137, 13, 191, 230, 66, 104, 65, 153, 45, 15, 176, 84, 187, 22};
        Forward_S_Box = nArrayArray;
        int[][] nArrayArray2 = new int[16][];
        nArrayArray2[0] = new int[]{82, 9, 106, 213, 48, 54, 165, 56, 191, 64, 163, 158, 129, 243, 215, 251};
        nArrayArray2[1] = new int[]{124, 227, 57, 130, 155, 47, 255, 135, 52, 142, 67, 68, 196, 222, 233, 203};
        nArrayArray2[2] = new int[]{84, 123, 148, 50, 166, 194, 35, 61, 238, 76, 149, 11, 66, 250, 195, 78};
        nArrayArray2[3] = new int[]{8, 46, 161, 102, 40, 217, 36, 178, 118, 91, 162, 73, 109, 139, 209, 37};
        nArrayArray2[4] = new int[]{114, 248, 246, 100, 134, 104, 152, 22, 212, 164, 92, 204, 93, 101, 182, 146};
        nArrayArray2[5] = new int[]{108, 112, 72, 80, 253, 237, 185, 218, 94, 21, 70, 87, 167, 141, 157, 132};
        int[] nArray2 = new int[16];
        nArray2[0] = 144;
        nArray2[1] = 216;
        nArray2[2] = 171;
        nArray2[4] = 140;
        nArray2[5] = 188;
        nArray2[6] = 211;
        nArray2[7] = 10;
        nArray2[8] = 247;
        nArray2[9] = 228;
        nArray2[10] = 88;
        nArray2[11] = 5;
        nArray2[12] = 184;
        nArray2[13] = 179;
        nArray2[14] = 69;
        nArray2[15] = 6;
        nArrayArray2[6] = nArray2;
        nArrayArray2[7] = new int[]{208, 44, 30, 143, 202, 63, 15, 2, 193, 175, 189, 3, 1, 19, 138, 107};
        nArrayArray2[8] = new int[]{58, 145, 17, 65, 79, 103, 220, 234, 151, 242, 207, 206, 240, 180, 230, 115};
        nArrayArray2[9] = new int[]{150, 172, 116, 34, 231, 173, 53, 133, 226, 249, 55, 232, 28, 117, 223, 110};
        nArrayArray2[10] = new int[]{71, 241, 26, 113, 29, 41, 197, 137, 111, 183, 98, 14, 170, 24, 190, 27};
        nArrayArray2[11] = new int[]{252, 86, 62, 75, 198, 210, 121, 32, 154, 219, 192, 254, 120, 205, 90, 244};
        nArrayArray2[12] = new int[]{31, 221, 168, 51, 136, 7, 199, 49, 177, 18, 16, 89, 39, 128, 236, 95};
        nArrayArray2[13] = new int[]{96, 81, 127, 169, 25, 181, 74, 13, 45, 229, 122, 159, 147, 201, 156, 239};
        nArrayArray2[14] = new int[]{160, 224, 59, 77, 174, 42, 245, 176, 200, 235, 187, 60, 131, 83, 153, 97};
        nArrayArray2[15] = new int[]{23, 43, 4, 126, 186, 119, 214, 38, 225, 105, 20, 99, 85, 33, 12, 125};
        Inv_S_Box = nArrayArray2;
        IP = new byte[]{58, 50, 42, 34, 26, 18, 10, 2, 60, 52, 44, 36, 28, 20, 12, 4, 62, 54, 46, 38, 30, 22, 14, 6, 64, 56, 48, 40, 32, 24, 16, 8, 57, 49, 41, 33, 25, 17, 9, 1, 59, 51, 43, 35, 27, 19, 11, 3, 61, 53, 45, 37, 29, 21, 13, 5, 63, 55, 47, 39, 31, 23, 15, 7};
        FP = new byte[]{40, 8, 48, 16, 56, 24, 64, 32, 39, 7, 47, 15, 55, 23, 63, 31, 38, 6, 46, 14, 54, 22, 62, 30, 37, 5, 45, 13, 53, 21, 61, 29, 36, 4, 44, 12, 52, 20, 60, 28, 35, 3, 43, 11, 51, 19, 59, 27, 34, 2, 42, 10, 50, 18, 58, 26, 33, 1, 41, 9, 49, 17, 57, 25};
        E = new byte[]{32, 1, 2, 3, 4, 5, 4, 5, 6, 7, 8, 9, 8, 9, 10, 11, 12, 13, 12, 13, 14, 15, 16, 17, 16, 17, 18, 19, 20, 21, 20, 21, 22, 23, 24, 25, 24, 25, 26, 27, 28, 29, 28, 29, 30, 31, 32, 1};
        byte[][] byArrayArray = new byte[8][];
        byte[] byArray = new byte[64];
        byArray[0] = 14;
        byArray[1] = 4;
        byArray[2] = 13;
        byArray[3] = 1;
        byArray[4] = 2;
        byArray[5] = 15;
        byArray[6] = 11;
        byArray[7] = 8;
        byArray[8] = 3;
        byArray[9] = 10;
        byArray[10] = 6;
        byArray[11] = 12;
        byArray[12] = 5;
        byArray[13] = 9;
        byArray[15] = 7;
        byArray[17] = 15;
        byArray[18] = 7;
        byArray[19] = 4;
        byArray[20] = 14;
        byArray[21] = 2;
        byArray[22] = 13;
        byArray[23] = 1;
        byArray[24] = 10;
        byArray[25] = 6;
        byArray[26] = 12;
        byArray[27] = 11;
        byArray[28] = 9;
        byArray[29] = 5;
        byArray[30] = 3;
        byArray[31] = 8;
        byArray[32] = 4;
        byArray[33] = 1;
        byArray[34] = 14;
        byArray[35] = 8;
        byArray[36] = 13;
        byArray[37] = 6;
        byArray[38] = 2;
        byArray[39] = 11;
        byArray[40] = 15;
        byArray[41] = 12;
        byArray[42] = 9;
        byArray[43] = 7;
        byArray[44] = 3;
        byArray[45] = 10;
        byArray[46] = 5;
        byArray[48] = 15;
        byArray[49] = 12;
        byArray[50] = 8;
        byArray[51] = 2;
        byArray[52] = 4;
        byArray[53] = 9;
        byArray[54] = 1;
        byArray[55] = 7;
        byArray[56] = 5;
        byArray[57] = 11;
        byArray[58] = 3;
        byArray[59] = 14;
        byArray[60] = 10;
        byArray[62] = 6;
        byArray[63] = 13;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[64];
        byArray2[0] = 15;
        byArray2[1] = 1;
        byArray2[2] = 8;
        byArray2[3] = 14;
        byArray2[4] = 6;
        byArray2[5] = 11;
        byArray2[6] = 3;
        byArray2[7] = 4;
        byArray2[8] = 9;
        byArray2[9] = 7;
        byArray2[10] = 2;
        byArray2[11] = 13;
        byArray2[12] = 12;
        byArray2[14] = 5;
        byArray2[15] = 10;
        byArray2[16] = 3;
        byArray2[17] = 13;
        byArray2[18] = 4;
        byArray2[19] = 7;
        byArray2[20] = 15;
        byArray2[21] = 2;
        byArray2[22] = 8;
        byArray2[23] = 14;
        byArray2[24] = 12;
        byArray2[26] = 1;
        byArray2[27] = 10;
        byArray2[28] = 6;
        byArray2[29] = 9;
        byArray2[30] = 11;
        byArray2[31] = 5;
        byArray2[33] = 14;
        byArray2[34] = 7;
        byArray2[35] = 11;
        byArray2[36] = 10;
        byArray2[37] = 4;
        byArray2[38] = 13;
        byArray2[39] = 1;
        byArray2[40] = 5;
        byArray2[41] = 8;
        byArray2[42] = 12;
        byArray2[43] = 6;
        byArray2[44] = 9;
        byArray2[45] = 3;
        byArray2[46] = 2;
        byArray2[47] = 15;
        byArray2[48] = 13;
        byArray2[49] = 8;
        byArray2[50] = 10;
        byArray2[51] = 1;
        byArray2[52] = 3;
        byArray2[53] = 15;
        byArray2[54] = 4;
        byArray2[55] = 2;
        byArray2[56] = 11;
        byArray2[57] = 6;
        byArray2[58] = 7;
        byArray2[59] = 12;
        byArray2[61] = 5;
        byArray2[62] = 14;
        byArray2[63] = 9;
        byArrayArray[1] = byArray2;
        byte[] byArray3 = new byte[64];
        byArray3[0] = 10;
        byArray3[2] = 9;
        byArray3[3] = 14;
        byArray3[4] = 6;
        byArray3[5] = 3;
        byArray3[6] = 15;
        byArray3[7] = 5;
        byArray3[8] = 1;
        byArray3[9] = 13;
        byArray3[10] = 12;
        byArray3[11] = 7;
        byArray3[12] = 11;
        byArray3[13] = 4;
        byArray3[14] = 2;
        byArray3[15] = 8;
        byArray3[16] = 13;
        byArray3[17] = 7;
        byArray3[19] = 9;
        byArray3[20] = 3;
        byArray3[21] = 4;
        byArray3[22] = 6;
        byArray3[23] = 10;
        byArray3[24] = 2;
        byArray3[25] = 8;
        byArray3[26] = 5;
        byArray3[27] = 14;
        byArray3[28] = 12;
        byArray3[29] = 11;
        byArray3[30] = 15;
        byArray3[31] = 1;
        byArray3[32] = 13;
        byArray3[33] = 6;
        byArray3[34] = 4;
        byArray3[35] = 9;
        byArray3[36] = 8;
        byArray3[37] = 15;
        byArray3[38] = 3;
        byArray3[40] = 11;
        byArray3[41] = 1;
        byArray3[42] = 2;
        byArray3[43] = 12;
        byArray3[44] = 5;
        byArray3[45] = 10;
        byArray3[46] = 14;
        byArray3[47] = 7;
        byArray3[48] = 1;
        byArray3[49] = 10;
        byArray3[50] = 13;
        byArray3[52] = 6;
        byArray3[53] = 9;
        byArray3[54] = 8;
        byArray3[55] = 7;
        byArray3[56] = 4;
        byArray3[57] = 15;
        byArray3[58] = 14;
        byArray3[59] = 3;
        byArray3[60] = 11;
        byArray3[61] = 5;
        byArray3[62] = 2;
        byArray3[63] = 12;
        byArrayArray[2] = byArray3;
        byte[] byArray4 = new byte[64];
        byArray4[0] = 7;
        byArray4[1] = 13;
        byArray4[2] = 14;
        byArray4[3] = 3;
        byArray4[5] = 6;
        byArray4[6] = 9;
        byArray4[7] = 10;
        byArray4[8] = 1;
        byArray4[9] = 2;
        byArray4[10] = 8;
        byArray4[11] = 5;
        byArray4[12] = 11;
        byArray4[13] = 12;
        byArray4[14] = 4;
        byArray4[15] = 15;
        byArray4[16] = 13;
        byArray4[17] = 8;
        byArray4[18] = 11;
        byArray4[19] = 5;
        byArray4[20] = 6;
        byArray4[21] = 15;
        byArray4[23] = 3;
        byArray4[24] = 4;
        byArray4[25] = 7;
        byArray4[26] = 2;
        byArray4[27] = 12;
        byArray4[28] = 1;
        byArray4[29] = 10;
        byArray4[30] = 14;
        byArray4[31] = 9;
        byArray4[32] = 10;
        byArray4[33] = 6;
        byArray4[34] = 9;
        byArray4[36] = 12;
        byArray4[37] = 11;
        byArray4[38] = 7;
        byArray4[39] = 13;
        byArray4[40] = 15;
        byArray4[41] = 1;
        byArray4[42] = 3;
        byArray4[43] = 14;
        byArray4[44] = 5;
        byArray4[45] = 2;
        byArray4[46] = 8;
        byArray4[47] = 4;
        byArray4[48] = 3;
        byArray4[49] = 15;
        byArray4[51] = 6;
        byArray4[52] = 10;
        byArray4[53] = 1;
        byArray4[54] = 13;
        byArray4[55] = 8;
        byArray4[56] = 9;
        byArray4[57] = 4;
        byArray4[58] = 5;
        byArray4[59] = 11;
        byArray4[60] = 12;
        byArray4[61] = 7;
        byArray4[62] = 2;
        byArray4[63] = 14;
        byArrayArray[3] = byArray4;
        byte[] byArray5 = new byte[64];
        byArray5[0] = 2;
        byArray5[1] = 12;
        byArray5[2] = 4;
        byArray5[3] = 1;
        byArray5[4] = 7;
        byArray5[5] = 10;
        byArray5[6] = 11;
        byArray5[7] = 6;
        byArray5[8] = 8;
        byArray5[9] = 5;
        byArray5[10] = 3;
        byArray5[11] = 15;
        byArray5[12] = 13;
        byArray5[14] = 14;
        byArray5[15] = 9;
        byArray5[16] = 14;
        byArray5[17] = 11;
        byArray5[18] = 2;
        byArray5[19] = 12;
        byArray5[20] = 4;
        byArray5[21] = 7;
        byArray5[22] = 13;
        byArray5[23] = 1;
        byArray5[24] = 5;
        byArray5[26] = 15;
        byArray5[27] = 10;
        byArray5[28] = 3;
        byArray5[29] = 9;
        byArray5[30] = 8;
        byArray5[31] = 6;
        byArray5[32] = 4;
        byArray5[33] = 2;
        byArray5[34] = 1;
        byArray5[35] = 11;
        byArray5[36] = 10;
        byArray5[37] = 13;
        byArray5[38] = 7;
        byArray5[39] = 8;
        byArray5[40] = 15;
        byArray5[41] = 9;
        byArray5[42] = 12;
        byArray5[43] = 5;
        byArray5[44] = 6;
        byArray5[45] = 3;
        byArray5[47] = 14;
        byArray5[48] = 11;
        byArray5[49] = 8;
        byArray5[50] = 12;
        byArray5[51] = 7;
        byArray5[52] = 1;
        byArray5[53] = 14;
        byArray5[54] = 2;
        byArray5[55] = 13;
        byArray5[56] = 6;
        byArray5[57] = 15;
        byArray5[59] = 9;
        byArray5[60] = 10;
        byArray5[61] = 4;
        byArray5[62] = 5;
        byArray5[63] = 3;
        byArrayArray[4] = byArray5;
        byte[] byArray6 = new byte[64];
        byArray6[0] = 12;
        byArray6[1] = 1;
        byArray6[2] = 10;
        byArray6[3] = 15;
        byArray6[4] = 9;
        byArray6[5] = 2;
        byArray6[6] = 6;
        byArray6[7] = 8;
        byArray6[9] = 13;
        byArray6[10] = 3;
        byArray6[11] = 4;
        byArray6[12] = 14;
        byArray6[13] = 7;
        byArray6[14] = 5;
        byArray6[15] = 11;
        byArray6[16] = 10;
        byArray6[17] = 15;
        byArray6[18] = 4;
        byArray6[19] = 2;
        byArray6[20] = 7;
        byArray6[21] = 12;
        byArray6[22] = 9;
        byArray6[23] = 5;
        byArray6[24] = 6;
        byArray6[25] = 1;
        byArray6[26] = 13;
        byArray6[27] = 14;
        byArray6[29] = 11;
        byArray6[30] = 3;
        byArray6[31] = 8;
        byArray6[32] = 9;
        byArray6[33] = 14;
        byArray6[34] = 15;
        byArray6[35] = 5;
        byArray6[36] = 2;
        byArray6[37] = 8;
        byArray6[38] = 12;
        byArray6[39] = 3;
        byArray6[40] = 7;
        byArray6[42] = 4;
        byArray6[43] = 10;
        byArray6[44] = 1;
        byArray6[45] = 13;
        byArray6[46] = 11;
        byArray6[47] = 6;
        byArray6[48] = 4;
        byArray6[49] = 3;
        byArray6[50] = 2;
        byArray6[51] = 12;
        byArray6[52] = 9;
        byArray6[53] = 5;
        byArray6[54] = 15;
        byArray6[55] = 10;
        byArray6[56] = 11;
        byArray6[57] = 14;
        byArray6[58] = 1;
        byArray6[59] = 7;
        byArray6[60] = 6;
        byArray6[62] = 8;
        byArray6[63] = 13;
        byArrayArray[5] = byArray6;
        byte[] byArray7 = new byte[64];
        byArray7[0] = 4;
        byArray7[1] = 11;
        byArray7[2] = 2;
        byArray7[3] = 14;
        byArray7[4] = 15;
        byArray7[6] = 8;
        byArray7[7] = 13;
        byArray7[8] = 3;
        byArray7[9] = 12;
        byArray7[10] = 9;
        byArray7[11] = 7;
        byArray7[12] = 5;
        byArray7[13] = 10;
        byArray7[14] = 6;
        byArray7[15] = 1;
        byArray7[16] = 13;
        byArray7[18] = 11;
        byArray7[19] = 7;
        byArray7[20] = 4;
        byArray7[21] = 9;
        byArray7[22] = 1;
        byArray7[23] = 10;
        byArray7[24] = 14;
        byArray7[25] = 3;
        byArray7[26] = 5;
        byArray7[27] = 12;
        byArray7[28] = 2;
        byArray7[29] = 15;
        byArray7[30] = 8;
        byArray7[31] = 6;
        byArray7[32] = 1;
        byArray7[33] = 4;
        byArray7[34] = 11;
        byArray7[35] = 13;
        byArray7[36] = 12;
        byArray7[37] = 3;
        byArray7[38] = 7;
        byArray7[39] = 14;
        byArray7[40] = 10;
        byArray7[41] = 15;
        byArray7[42] = 6;
        byArray7[43] = 8;
        byArray7[45] = 5;
        byArray7[46] = 9;
        byArray7[47] = 2;
        byArray7[48] = 6;
        byArray7[49] = 11;
        byArray7[50] = 13;
        byArray7[51] = 8;
        byArray7[52] = 1;
        byArray7[53] = 4;
        byArray7[54] = 10;
        byArray7[55] = 7;
        byArray7[56] = 9;
        byArray7[57] = 5;
        byArray7[59] = 15;
        byArray7[60] = 14;
        byArray7[61] = 2;
        byArray7[62] = 3;
        byArray7[63] = 12;
        byArrayArray[6] = byArray7;
        byte[] byArray8 = new byte[64];
        byArray8[0] = 13;
        byArray8[1] = 2;
        byArray8[2] = 8;
        byArray8[3] = 4;
        byArray8[4] = 6;
        byArray8[5] = 15;
        byArray8[6] = 11;
        byArray8[7] = 1;
        byArray8[8] = 10;
        byArray8[9] = 9;
        byArray8[10] = 3;
        byArray8[11] = 14;
        byArray8[12] = 5;
        byArray8[14] = 12;
        byArray8[15] = 7;
        byArray8[16] = 1;
        byArray8[17] = 15;
        byArray8[18] = 13;
        byArray8[19] = 8;
        byArray8[20] = 10;
        byArray8[21] = 3;
        byArray8[22] = 7;
        byArray8[23] = 4;
        byArray8[24] = 12;
        byArray8[25] = 5;
        byArray8[26] = 6;
        byArray8[27] = 11;
        byArray8[29] = 14;
        byArray8[30] = 9;
        byArray8[31] = 2;
        byArray8[32] = 7;
        byArray8[33] = 11;
        byArray8[34] = 4;
        byArray8[35] = 1;
        byArray8[36] = 9;
        byArray8[37] = 12;
        byArray8[38] = 14;
        byArray8[39] = 2;
        byArray8[41] = 6;
        byArray8[42] = 10;
        byArray8[43] = 13;
        byArray8[44] = 15;
        byArray8[45] = 3;
        byArray8[46] = 5;
        byArray8[47] = 8;
        byArray8[48] = 2;
        byArray8[49] = 1;
        byArray8[50] = 14;
        byArray8[51] = 7;
        byArray8[52] = 4;
        byArray8[53] = 10;
        byArray8[54] = 8;
        byArray8[55] = 13;
        byArray8[56] = 15;
        byArray8[57] = 12;
        byArray8[58] = 9;
        byArray8[60] = 3;
        byArray8[61] = 5;
        byArray8[62] = 6;
        byArray8[63] = 11;
        byArrayArray[7] = byArray8;
        S = byArrayArray;
        P = new byte[]{16, 7, 20, 21, 29, 12, 28, 17, 1, 15, 23, 26, 5, 18, 31, 10, 2, 8, 24, 14, 32, 27, 3, 9, 19, 13, 30, 6, 22, 11, 4, 25};
        PC1 = new byte[]{57, 49, 41, 33, 25, 17, 9, 1, 58, 50, 42, 34, 26, 18, 10, 2, 59, 51, 43, 35, 27, 19, 11, 3, 60, 52, 44, 36, 63, 55, 47, 39, 31, 23, 15, 7, 62, 54, 46, 38, 30, 22, 14, 6, 61, 53, 45, 37, 29, 21, 13, 5, 28, 20, 12, 4};
        PC2 = new byte[]{14, 17, 11, 24, 1, 5, 3, 28, 15, 6, 21, 10, 23, 19, 12, 4, 26, 8, 16, 7, 27, 20, 13, 2, 41, 52, 31, 37, 47, 55, 30, 40, 51, 45, 33, 48, 44, 49, 39, 56, 34, 53, 46, 42, 50, 36, 29, 32};
        rotations = new byte[]{1, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1};
        back_grey_cl = new Color(27, 29, 29);
        forg_blue_cl = new Color(77, 198, 232);
        forg_white_cl = new Color(239, 239, 239);
    }

    public static void cf() {
        SimpleAttributeSet attributeSet = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attributeSet, X);
        StyleConstants.setFontSize(attributeSet, s);
        pane.selectAll();
        pane.setCharacterAttributes(attributeSet, true);
        StyledDocument doc = pane.getStyledDocument();
        try {
            doc.insertString(doc.getLength(), "", attributeSet);
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
    }

    public static void disp_rec(String T) {
        SimpleAttributeSet attributeSet = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attributeSet, X);
        StyleConstants.setFontSize(attributeSet, s);
        pane.setCharacterAttributes(attributeSet, true);
        StyledDocument doc = pane.getStyledDocument();
        try {
            doc.insertString(doc.getLength(), T, attributeSet);
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
    }

    static int split(char[] ct, int i) {
        int res = 0;
        if (ct[i] != '\u0000' && ct[i + 1] != '\u0000') {
            res = 16 * Editor.getNum(ct[i]) + Editor.getNum(ct[i + 1]);
        }
        if (ct[i] != '\u0000' && ct[i + 1] == '\u0000') {
            res = 16 * Editor.getNum(ct[i]);
        }
        if (ct[i] == '\u0000' && ct[i + 1] != '\u0000') {
            res = Editor.getNum(ct[i + 1]);
        }
        if (ct[i] == '\u0000' && ct[i + 1] == '\u0000') {
            res = 0;
        }
        return res;
    }

    static int getNum(char ch) {
        int num = 0;
        if (ch >= '0' && ch <= '9') {
            num = ch - 48;
        } else {
            switch (ch) {
                case 'A': 
                case 'a': {
                    num = 10;
                    break;
                }
                case 'B': 
                case 'b': {
                    num = 11;
                    break;
                }
                case 'C': 
                case 'c': {
                    num = 12;
                    break;
                }
                case 'D': 
                case 'd': {
                    num = 13;
                    break;
                }
                case 'E': 
                case 'e': {
                    num = 14;
                    break;
                }
                case 'F': 
                case 'f': {
                    num = 15;
                    break;
                }
                default: {
                    num = 0;
                }
            }
        }
        return num;
    }

    public static void cl() {
        pane.selectAll();
        pane.replaceSelection("");
    }

    private static long IP(long src) {
        return Editor.permute(IP, 64, src);
    }

    private static long FP(long src) {
        return Editor.permute(FP, 64, src);
    }

    private static long E(int src) {
        return Editor.permute(E, 32, (long)src & 0xFFFFFFFFL);
    }

    private static int P(int src) {
        return (int)Editor.permute(P, 32, (long)src & 0xFFFFFFFFL);
    }

    private static long PC1(long src) {
        return Editor.permute(PC1, 64, src);
    }

    private static long PC2(long src) {
        return Editor.permute(PC2, 56, src);
    }

    private static long permute(byte[] table, int srcWidth, long src) {
        long dst = 0L;
        int i = 0;
        while (i < table.length) {
            int srcPos = srcWidth - table[i];
            dst = dst << 1 | src >> srcPos & 1L;
            ++i;
        }
        return dst;
    }

    private static byte S(int boxNumber, byte src) {
        src = (byte)(src & 0x20 | (src & 1) << 4 | (src & 0x1E) >> 1);
        return S[boxNumber - 1][src];
    }

    private static long getLongFromBytes(byte[] ba, int offset) {
        long l = 0L;
        int i = 0;
        while (i < 8) {
            byte value = offset + i < ba.length ? ba[offset + i] : (byte)0;
            l = l << 8 | (long)value & 0xFFL;
            ++i;
        }
        return l;
    }

    private static void getBytesFromLong(byte[] ba, int offset, long l) {
        int i = 7;
        while (i > -1) {
            if (offset + i >= ba.length) break;
            ba[offset + i] = (byte)(l & 0xFFL);
            l >>= 8;
            --i;
        }
    }

    private static int feistel(int r, long subkey) {
        long e = Editor.E(r);
        long x = e ^ subkey;
        int dst = 0;
        int i = 0;
        while (i < 8) {
            dst >>>= 4;
            byte s = Editor.S(8 - i, (byte)(x & 0x3FL));
            dst |= s << 28;
            x >>= 6;
            ++i;
        }
        return Editor.P(dst);
    }

    private static long[] createSubkeys(long key) {
        long[] subkeys = new long[16];
        key = Editor.PC1(key);
        int c = (int)(key >> 28);
        int d = (int)(key & 0xFFFFFFFL);
        int i = 0;
        while (i < 16) {
            if (rotations[i] == 1) {
                c = c << 1 & 0xFFFFFFF | c >> 27;
                d = d << 1 & 0xFFFFFFF | d >> 27;
            } else {
                c = c << 2 & 0xFFFFFFF | c >> 26;
                d = d << 2 & 0xFFFFFFF | d >> 26;
            }
            long cd = ((long)c & 0xFFFFFFFFL) << 28 | (long)d & 0xFFFFFFFFL;
            subkeys[i] = Editor.PC2(cd);
            ++i;
        }
        return subkeys;
    }

    public static long encryptBlock(long m, long key) {
        long[] subkeys = Editor.createSubkeys(key);
        long ip = Editor.IP(m);
        int l = (int)(ip >> 32);
        int r = (int)(ip & 0xFFFFFFFFL);
        int i = 0;
        while (i < 16) {
            int previous_l = l;
            l = r;
            r = previous_l ^ Editor.feistel(r, subkeys[i]);
            ++i;
        }
        long rl = ((long)r & 0xFFFFFFFFL) << 32 | (long)l & 0xFFFFFFFFL;
        long fp = Editor.FP(rl);
        return fp;
    }

    public static void encryptBlock(byte[] message, int messageOffset, byte[] ciphertext, int ciphertextOffset, byte[] key) {
        long m = Editor.getLongFromBytes(message, messageOffset);
        long k = Editor.getLongFromBytes(key, 0);
        long c = Editor.encryptBlock(m, k);
        Editor.getBytesFromLong(ciphertext, ciphertextOffset, c);
    }

    public static byte[] encrypt(byte[] message, byte[] key) {
        byte[] ciphertext = new byte[message.length];
        int i = 0;
        while (i < message.length) {
            Editor.encryptBlock(message, i, ciphertext, i, key);
            i += 8;
        }
        return ciphertext;
    }

    public static byte[] encrypt(byte[] challenge, String password) {
        return Editor.encrypt(challenge, Editor.passwordToKey(password));
    }

    private static byte[] passwordToKey(String password) {
        byte[] pwbytes = password.getBytes();
        byte[] key = new byte[8];
        int i = 0;
        while (i < 8) {
            if (i < pwbytes.length) {
                byte b = pwbytes[i];
                int b2 = 0;
                int j = 0;
                while (j < 8) {
                    b2 = (byte)(b2 << 1);
                    b2 = (byte)(b2 | b & 1);
                    b = (byte)(b >>> 1);
                    ++j;
                }
                key[i] = b2;
            } else {
                key[i] = 0;
            }
            ++i;
        }
        return key;
    }

    private static int charToNibble(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + c - 97;
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + c - 65;
        }
        return 0;
    }

    private static byte[] parseBytes(String s) {
        s = s.replace(" ", "");
        byte[] ba = new byte[s.length() / 2];
        if (s.length() % 2 > 0) {
            s = String.valueOf(s) + '0';
        }
        int i = 0;
        while (i < s.length()) {
            ba[i / 2] = (byte)(Editor.charToNibble(s.charAt(i)) << 4 | Editor.charToNibble(s.charAt(i + 1)));
            i += 2;
        }
        return ba;
    }

    private static String hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < bytes.length) {
            sb.append(String.format("%02X ", bytes[i]));
            ++i;
        }
        return sb.toString();
    }

    public static long getIv() {
        return IV;
    }

    public static void setIv(long iv) {
        IV = iv;
    }

    public static byte[] encryptCBC(byte[] message, byte[] key) {
        byte[] ciphertext = new byte[message.length];
        long k = Editor.getLongFromBytes(key, 0);
        long previousCipherBlock = IV;
        int i = 0;
        while (i < message.length) {
            long messageBlock = Editor.getLongFromBytes(message, i);
            long cipherBlock = Editor.encryptBlock(messageBlock ^ previousCipherBlock, k);
            Editor.getBytesFromLong(ciphertext, i, cipherBlock);
            previousCipherBlock = cipherBlock;
            i += 8;
        }
        return ciphertext;
    }

    public static long decryptBlock(long c, long key) {
        long[] subkeys = Editor.createSubkeys(key);
        long ip = Editor.IP(c);
        int l = (int)(ip >> 32);
        int r = (int)(ip & 0xFFFFFFFFL);
        int i = 15;
        while (i > -1) {
            int previous_l = l;
            l = r;
            r = previous_l ^ Editor.feistel(r, subkeys[i]);
            --i;
        }
        long rl = ((long)r & 0xFFFFFFFFL) << 32 | (long)l & 0xFFFFFFFFL;
        long fp = Editor.FP(rl);
        return fp;
    }

    public static void decryptBlock(byte[] ciphertext, int ciphertextOffset, byte[] message, int messageOffset, byte[] key) {
        long c = Editor.getLongFromBytes(ciphertext, ciphertextOffset);
        long k = Editor.getLongFromBytes(key, 0);
        long m = Editor.decryptBlock(c, k);
        Editor.getBytesFromLong(message, messageOffset, m);
    }

    public static byte[] decrypt(byte[] ciphertext, byte[] key) {
        byte[] message = new byte[ciphertext.length];
        int i = 0;
        while (i < ciphertext.length) {
            Editor.decryptBlock(ciphertext, i, message, i, key);
            i += 8;
        }
        return message;
    }

    public static byte[] decryptCBC(byte[] ciphertext, byte[] key) {
        byte[] message = new byte[ciphertext.length];
        long k = Editor.getLongFromBytes(key, 0);
        long previousCipherBlock = IV;
        int i = 0;
        while (i < ciphertext.length) {
            long cipherBlock = Editor.getLongFromBytes(ciphertext, i);
            long messageBlock = Editor.decryptBlock(cipherBlock, k);
            Editor.getBytesFromLong(message, i, messageBlock ^= previousCipherBlock);
            previousCipherBlock = cipherBlock;
            i += 8;
        }
        return message;
    }

    public static void ctostr(char[] vrbls, int pos) {
        String tf = "";
        int i = 0;
        while (i < 8) {
            tf = String.valueOf(tf) + vrbls[i + pos];
            ++i;
        }
        SecureRandom number = new SecureRandom();
        int i2 = 0;
        while (i2 < 4) {
            String r = "";
            r = String.valueOf(r) + number.nextInt(256);
            Integer inv = Integer.valueOf(r);
            tf = String.valueOf(tf) + String.format("%02x", inv);
            ++i2;
        }
        String key = ck;
        byte[] enc = Editor.encrypt(Editor.parseBytes(tf), Editor.parseBytes(key));
        int i3 = 0;
        while (i3 < 8) {
            stf = String.valueOf(stf) + String.format("%02x", enc[i3]);
            ++i3;
        }
    }

    private static void dec_str(char[] tdec, int pos) {
        String tf = "";
        int i = 0;
        while (i < 16) {
            tf = String.valueOf(tf) + tdec[i + pos];
            ++i;
        }
        String key = ck;
        byte[] dec_t = Editor.decrypt(Editor.parseBytes(tf), Editor.parseBytes(key));
        String tsb = "";
        int i2 = 0;
        while (i2 < 4) {
            tsb = String.valueOf(tsb) + String.format("%02x", dec_t[i2]);
            ++i2;
        }
        String ir1 = "";
        char[] chtd = tsb.toCharArray();
        int i3 = 0;
        while (i3 < 8) {
            int fs = Editor.getNum(chtd[i3]);
            int ss = Editor.getNum(chtd[i3 + 1]);
            Integer intObject = Inv_S_Box[fs][ss];
            String cv = "";
            cv = String.valueOf(cv) + String.format("%02x", intObject);
            int rc = Integer.valueOf(cv, 16);
            char ctp = (char)rc;
            ir1 = String.valueOf(ir1) + ctp;
            i3 += 2;
        }
        Editor.disp_rec(ir1);
    }

    private static void dec_ivs(char[] tdec, int pos) {
        String tf = "";
        int i = 0;
        while (i < 16) {
            tf = String.valueOf(tf) + tdec[i + pos];
            ++i;
        }
        String key = ck;
        byte[] dec_t = Editor.decrypt(Editor.parseBytes(tf), Editor.parseBytes(key));
        String tsb = "";
        int i2 = 0;
        while (i2 < 4) {
            tsb = String.valueOf(tsb) + String.format("%02x", dec_t[i2]);
            ++i2;
        }
        String ir = "";
        char[] chtd = tsb.toCharArray();
        int i3 = 0;
        while (i3 < 8) {
            int fs = Editor.getNum(chtd[i3]);
            int ss = Editor.getNum(chtd[i3 + 1]);
            Integer intObject = Inv_S_Box[fs][ss];
            String cv = "";
            cv = String.valueOf(cv) + String.format("%02x", intObject);
            int rc = Integer.valueOf(cv, 16);
            char ctp = (char)rc;
            ir = String.valueOf(ir) + ctp;
            i3 += 2;
        }
        div = String.valueOf(div) + ir;
    }

    public static String encrypt_AES(String strToEncrypt) {
        try {
            IvParameterSpec ivspec = new IvParameterSpec(iv);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec spec = new PBEKeySpec(SECRET_KEY.toCharArray(), SALTVALUE.getBytes(), 65536, 256);
            SecretKey tmp = factory.generateSecret(spec);
            SecretKeySpec secretKey = new SecretKeySpec(tmp.getEncoded(), "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)secretKey, ivspec);
            return Base64.getEncoder().encodeToString(cipher.doFinal(strToEncrypt.getBytes(StandardCharsets.UTF_8)));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            System.out.println("Error occured during encryption: " + e.toString());
            return null;
        }
    }

    public static String decrypt_AES(String strToDecrypt) {
        try {
            IvParameterSpec ivspec = new IvParameterSpec(iv);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec spec = new PBEKeySpec(SECRET_KEY.toCharArray(), SALTVALUE.getBytes(), 65536, 256);
            SecretKey tmp = factory.generateSecret(spec);
            SecretKeySpec secretKey = new SecretKeySpec(tmp.getEncoded(), "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            cipher.init(2, (Key)secretKey, ivspec);
            return new String(cipher.doFinal(Base64.getDecoder().decode(strToDecrypt)));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            System.out.println("Error occured during decryption: " + e.toString());
            return null;
        }
    }

    public static void generate_key() {
        SecureRandom desk = new SecureRandom();
        SecureRandom slct = new SecureRandom();
        StringBuilder dk = new StringBuilder();
        int i = 0;
        while (i < 16) {
            if (slct.nextInt(2) == 1) {
                dk.append((char)(48 + desk.nextInt(10)));
            } else {
                dk.append((char)(65 + desk.nextInt(6)));
            }
            ++i;
        }
        int gv = 0;
        SecureRandom aesk = new SecureRandom();
        StringBuilder aeskey = new StringBuilder();
        gv = 0;
        int adl = aesk.nextInt(200);
        int i2 = 0;
        while (i2 < 320 + adl) {
            gv = 32 + aesk.nextInt(94);
            if (gv != 44) {
                aeskey.append((char)gv);
            } else {
                aeskey.append((char)gv + 2 + aesk.nextInt(74));
            }
            ++i2;
        }
        JFrame parentFrame = new JFrame();
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Choose where to save newly generated key");
        int userSelection = fileChooser.showSaveDialog(parentFrame);
        if (userSelection == 0) {
            File fileToSave = fileChooser.getSelectedFile();
            try {
                FileWriter myWriter = new FileWriter(fileToSave.getAbsolutePath());
                myWriter.write(String.valueOf(dk.toString()) + "," + aeskey.toString());
                myWriter.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            SecureRandom numb1 = new SecureRandom();
            int i3 = 0;
            while (i3 < 16) {
                Editor.iv[i3] = (byte)numb1.nextInt(256);
                ++i3;
            }
        }
    }

    public static void gen_keys() {
        Editor.cl();
        int m = 0;
        int m1 = 0;
        Editor.disp_rec("String kderalgs = \"");
        SecureRandom sk0hk1 = new SecureRandom();
        int num_of_chars_in_hk1 = 20 + sk0hk1.nextInt(30);
        int i = 0;
        while (i < num_of_chars_in_hk1) {
            SecureRandom sk011 = new SecureRandom();
            m = sk011.nextInt(3);
            m1 = sk011.nextInt(2);
            StringBuilder str01 = new StringBuilder();
            if (m == 0) {
                str01.append((char)(65 + sk011.nextInt(26)));
            }
            if (m == 1) {
                str01.append((char)(97 + sk011.nextInt(26)));
            }
            if (m == 2) {
                str01.append((char)(48 + sk011.nextInt(10)));
            }
            Editor.disp_rec(str01.toString());
            ++i;
        }
        Editor.disp_rec("\";\n");
        Editor.disp_rec("int numofkincr = ");
        SecureRandom nofincrem = new SecureRandom();
        int i2 = 0;
        while (i2 < 3) {
            StringBuilder str22 = new StringBuilder();
            if (i2 == 0) {
                str22.append((char)(50 + nofincrem.nextInt(8)));
            } else {
                str22.append((char)(48 + nofincrem.nextInt(10)));
            }
            Editor.disp_rec(str22.toString());
            ++i2;
        }
        Editor.disp_rec(";\n");
        Editor.disp_rec("byte hmackey[] = {\"");
        SecureRandom sk0hk = new SecureRandom();
        int num_of_chars_in_hk = 99 + sk0hk.nextInt(50);
        int i3 = 0;
        while (i3 < num_of_chars_in_hk) {
            SecureRandom sk01 = new SecureRandom();
            m = sk01.nextInt(3);
            m1 = sk01.nextInt(2);
            StringBuilder str0 = new StringBuilder();
            if (m == 0) {
                str0.append((char)(65 + sk01.nextInt(26)));
            }
            if (m == 1) {
                str0.append((char)(97 + sk01.nextInt(26)));
            }
            if (m == 2) {
                str0.append((char)(48 + sk01.nextInt(10)));
            }
            Editor.disp_rec(str0.toString());
            ++i3;
        }
        Editor.disp_rec("\"};\n");
        Editor.disp_rec("byte des_key[] = {\n");
        i3 = 0;
        while (i3 < 3) {
            SecureRandom sk6 = new SecureRandom();
            int j = 0;
            while (j < 8) {
                m = sk6.nextInt(2);
                m1 = sk6.nextInt(2);
                Editor.disp_rec("0x");
                StringBuilder str6 = new StringBuilder();
                if (m == 0) {
                    str6.append((char)(97 + sk6.nextInt(6)));
                }
                if (m == 1) {
                    str6.append((char)(48 + sk6.nextInt(10)));
                }
                if (m1 == 0) {
                    str6.append((char)(97 + sk6.nextInt(6)));
                }
                if (m1 == 1) {
                    str6.append((char)(48 + sk6.nextInt(10)));
                }
                str6.append(",");
                if (i3 == 2 && j == 7) {
                    str6.setLength(str6.length() - 1);
                }
                Editor.disp_rec(str6.toString());
                ++j;
            }
            Editor.disp_rec("\n");
            ++i3;
        }
        Editor.disp_rec("};\n");
        Editor.disp_rec("uint8_t AES_key[32] = {\n");
        i3 = 0;
        while (i3 < 8) {
            SecureRandom sk3 = new SecureRandom();
            int j = 0;
            while (j < 4) {
                m = sk3.nextInt(2);
                m1 = sk3.nextInt(2);
                Editor.disp_rec("0x");
                StringBuilder str3 = new StringBuilder();
                if (m == 0) {
                    str3.append((char)(97 + sk3.nextInt(6)));
                }
                if (m == 1) {
                    str3.append((char)(48 + sk3.nextInt(10)));
                }
                if (m1 == 0) {
                    str3.append((char)(97 + sk3.nextInt(6)));
                }
                if (m1 == 1) {
                    str3.append((char)(48 + sk3.nextInt(10)));
                }
                str3.append(",");
                if (i3 == 7 && j == 3) {
                    str3.setLength(str3.length() - 1);
                }
                Editor.disp_rec(str3.toString());
                ++j;
            }
            Editor.disp_rec("\n");
            ++i3;
        }
        Editor.disp_rec("};\n");
        Editor.disp_rec("unsigned char Blwfsh_key[] = {\n");
        i3 = 0;
        while (i3 < 6) {
            SecureRandom sk2 = new SecureRandom();
            int j = 0;
            while (j < 4) {
                m = sk2.nextInt(2);
                m1 = sk2.nextInt(2);
                Editor.disp_rec("0x");
                StringBuilder str2 = new StringBuilder();
                if (m == 0) {
                    str2.append((char)(97 + sk2.nextInt(6)));
                }
                if (m == 1) {
                    str2.append((char)(48 + sk2.nextInt(10)));
                }
                if (m1 == 0) {
                    str2.append((char)(97 + sk2.nextInt(6)));
                }
                if (m1 == 1) {
                    str2.append((char)(48 + sk2.nextInt(10)));
                }
                str2.append(",");
                if (i3 == 5 && j == 3) {
                    str2.setLength(str2.length() - 1);
                }
                Editor.disp_rec(str2.toString());
                ++j;
            }
            Editor.disp_rec("\n");
            ++i3;
        }
        Editor.disp_rec("};\n");
        Editor.disp_rec("uint8_t serp_key[32] = {\n");
        i3 = 0;
        while (i3 < 8) {
            SecureRandom sk4 = new SecureRandom();
            int j = 0;
            while (j < 4) {
                m = sk4.nextInt(2);
                m1 = sk4.nextInt(2);
                Editor.disp_rec("0x");
                StringBuilder str4 = new StringBuilder();
                if (m == 0) {
                    str4.append((char)(97 + sk4.nextInt(6)));
                }
                if (m == 1) {
                    str4.append((char)(48 + sk4.nextInt(10)));
                }
                if (m1 == 0) {
                    str4.append((char)(97 + sk4.nextInt(6)));
                }
                if (m1 == 1) {
                    str4.append((char)(48 + sk4.nextInt(10)));
                }
                str4.append(",");
                if (i3 == 7 && j == 3) {
                    str4.setLength(str4.length() - 1);
                }
                Editor.disp_rec(str4.toString());
                ++j;
            }
            Editor.disp_rec("\n");
            ++i3;
        }
        Editor.disp_rec("};\n");
        Editor.disp_rec("uint8_t second_AES_key[32] = {\n");
        i3 = 0;
        while (i3 < 8) {
            SecureRandom scrrandsa = new SecureRandom();
            int j = 0;
            while (j < 4) {
                m = scrrandsa.nextInt(2);
                m1 = scrrandsa.nextInt(2);
                Editor.disp_rec("0x");
                StringBuilder strfsak = new StringBuilder();
                if (m == 0) {
                    strfsak.append((char)(97 + scrrandsa.nextInt(6)));
                }
                if (m == 1) {
                    strfsak.append((char)(48 + scrrandsa.nextInt(10)));
                }
                if (m1 == 0) {
                    strfsak.append((char)(97 + scrrandsa.nextInt(6)));
                }
                if (m1 == 1) {
                    strfsak.append((char)(48 + scrrandsa.nextInt(10)));
                }
                strfsak.append(",");
                if (i3 == 7 && j == 3) {
                    strfsak.setLength(strfsak.length() - 1);
                }
                Editor.disp_rec(strfsak.toString());
                ++j;
            }
            Editor.disp_rec("\n");
            ++i3;
        }
        Editor.disp_rec("};");
    }

    private static void customize_button(JButton btn) {
        btn.setBackground(back_grey_cl);
        btn.setForeground(forg_blue_cl);
        LineBorder line = new LineBorder(forg_blue_cl);
        EmptyBorder margin = new EmptyBorder(5, 15, 5, 15);
        CompoundBorder compound = new CompoundBorder(line, margin);
        btn.setBorder(compound);
    }

    public static void main(String[] args) {
        StringBuilder slt = new StringBuilder();
        SecureRandom number = new SecureRandom();
        int i = 0;
        while (i < 64) {
            slt.append((char)(65 + number.nextInt(26)));
            ++i;
        }
        SALTVALUE = slt.toString();
        SecureRandom numb = new SecureRandom();
        int i2 = 0;
        while (i2 < 16) {
            Editor.iv[i2] = (byte)numb.nextInt(256);
            ++i2;
        }
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        String[] sizes = new String[92];
        s = 14;
        int i3 = 0;
        while (i3 < 92) {
            sizes[i3] = String.valueOf(i3 + 8);
            ++i3;
        }
        JFrame frame = new JFrame("Twinkle DES + AES edition with key generator");
        JComboBox<String> fd = new JComboBox<String>(fonts);
        JComboBox<String> ff = new JComboBox<String>(sizes);
        JButton sel = new JButton("Apply");
        JLabel label0 = new JLabel("|  Font ");
        JLabel label1 = new JLabel("  Font size ");
        X = fonts[2];
        JPanel panel = new JPanel();
        mb = new JMenuBar();
        m = new JMenu("File");
        m1 = new JMenu("Action");
        o = new JMenuItem("Open");
        sv = new JMenuItem("Save As...");
        c = new JMenuItem("Clear Pane");
        JButton genr = new JButton("Gen. keys for Midbar (Teensy 4.1) V2.0");
        q = new JMenuItem("Quit");
        gk = new JMenuItem("Generate encryption key");
        sk = new JMenuItem("Select encryption key");
        Editor.customize_button(genr);
        Editor.customize_button(sel);
        fd.setBackground(back_grey_cl);
        fd.setForeground(forg_blue_cl);
        ff.setBackground(back_grey_cl);
        ff.setForeground(forg_blue_cl);
        mb.setBackground(back_grey_cl);
        m.setForeground(forg_blue_cl);
        m1.setForeground(forg_blue_cl);
        label0.setForeground(forg_blue_cl);
        label1.setForeground(forg_blue_cl);
        o.setBackground(back_grey_cl);
        sv.setBackground(back_grey_cl);
        c.setBackground(back_grey_cl);
        gk.setBackground(back_grey_cl);
        sk.setBackground(back_grey_cl);
        q.setBackground(back_grey_cl);
        o.setForeground(forg_blue_cl);
        sv.setForeground(forg_blue_cl);
        c.setForeground(forg_blue_cl);
        gk.setForeground(forg_blue_cl);
        sk.setForeground(forg_blue_cl);
        q.setForeground(forg_blue_cl);
        m.add(o);
        m.add(sv);
        m1.add(c);
        m.add(gk);
        m.add(sk);
        m.add(q);
        mb.add(m);
        mb.add(m1);
        mb.add(genr);
        frame.setJMenuBar(mb);
        mb.add(label0);
        mb.add(fd);
        mb.add(label1);
        mb.add(ff);
        mb.add(sel);
        frame.setDefaultCloseOperation(3);
        Container cp = frame.getContentPane();
        pane = new JTextPane();
        Color frgr = new Color(238, 238, 238);
        Color bclr = new Color(18, 18, 18);
        pane.setForeground(frgr);
        pane.setBackground(bclr);
        pane.setCaretColor(forg_white_cl);
        SimpleAttributeSet attributeSet = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attributeSet, X);
        StyleConstants.setFontSize(attributeSet, 16);
        pane.setCharacterAttributes(attributeSet, true);
        JScrollPane scrollPane = new JScrollPane(pane);
        cp.add((Component)scrollPane, "Center");
        frame.setSize(780, 960);
        frame.setVisible(true);
        sel.addActionListener(e -> {
            X = fonts[fd.getSelectedIndex()];
            s = Integer.parseInt(sizes[ff.getSelectedIndex()]);
            Editor.cf();
        });
        c.addActionListener(e -> Editor.cl());
        genr.addActionListener(e -> {
            Color bbclr = new Color(36, 36, 36);
            pane.setBackground(bbclr);
            Editor.gen_keys();
        });
        q.addActionListener(e -> System.exit(0));
        o.addActionListener(e -> {
            JFrame iFRAME = new JFrame();
            iFRAME.setAlwaysOnTop(true);
            iFRAME.setDefaultCloseOperation(2);
            iFRAME.setLocationRelativeTo(null);
            iFRAME.requestFocus();
            JFileChooser jfc = new JFileChooser();
            jfc.setDialogTitle("Open a record");
            int returnValue = jfc.showOpenDialog(iFRAME);
            iFRAME.dispose();
            if (returnValue == 0) {
                File selectedFile = jfc.getSelectedFile();
                Editor.cl();
                try {
                    String result = null;
                    DataInputStream reader = new DataInputStream(new FileInputStream(selectedFile.getAbsolutePath()));
                    int nBytesToRead = reader.available();
                    if (nBytesToRead > 0) {
                        byte[] bytes = new byte[nBytesToRead];
                        reader.read(bytes);
                        result = new String(bytes);
                    }
                    String[] prts = result.split(",");
                    div = "";
                    char[] tdec0 = prts[0].toCharArray();
                    int td_len0 = tdec0.length;
                    int crr0 = 0;
                    while (crr0 < td_len0) {
                        Editor.dec_ivs(tdec0, crr0);
                        crr0 += 16;
                    }
                    int i = 0;
                    while (i < div.length()) {
                        if (div.charAt(i) < '!') {
                            div = String.valueOf(div.substring(0, i)) + div.substring(i + 1);
                            --i;
                        }
                        ++i;
                    }
                    String[] ivs = div.split(",");
                    div = "";
                    int i2 = 0;
                    while (i2 < 16) {
                        Integer q = Integer.parseInt(ivs[i2]);
                        Editor.iv[i2] = q.byteValue();
                        ++i2;
                    }
                    div = "";
                    char[] tdec2 = prts[1].toCharArray();
                    int td_len2 = tdec2.length;
                    int crr2 = 0;
                    while (crr2 < td_len2) {
                        Editor.dec_ivs(tdec2, crr2);
                        crr2 += 16;
                    }
                    SALTVALUE = div;
                    div = "";
                    char[] tdec1 = Editor.decrypt_AES(prts[2]).toCharArray();
                    int td_len1 = tdec1.length;
                    int crr1 = 0;
                    while (crr1 < td_len1) {
                        Editor.dec_str(tdec1, crr1);
                        crr1 += 16;
                    }
                }
                catch (IOException r) {
                    System.out.println("An error occurred.");
                    r.printStackTrace();
                }
                SwingUtilities.updateComponentTreeUI(frame);
            }
        });
        gk.addActionListener(e -> Editor.generate_key());
        sk.addActionListener(e -> {
            JFrame iFRAME = new JFrame();
            iFRAME.setAlwaysOnTop(true);
            iFRAME.setDefaultCloseOperation(2);
            iFRAME.setLocationRelativeTo(null);
            iFRAME.requestFocus();
            JFileChooser jfc = new JFileChooser();
            int returnValue = jfc.showOpenDialog(iFRAME);
            iFRAME.dispose();
            if (returnValue == 0) {
                File selectedFile = jfc.getSelectedFile();
                try {
                    String result = null;
                    DataInputStream reader = new DataInputStream(new FileInputStream(selectedFile.getAbsolutePath()));
                    int nBytesToRead = reader.available();
                    if (nBytesToRead > 0) {
                        byte[] bytes = new byte[nBytesToRead];
                        reader.read(bytes);
                        result = new String(bytes);
                    }
                    String[] e_keys = result.split(",");
                    ck = e_keys[0];
                    SECRET_KEY = e_keys[1];
                }
                catch (IOException r) {
                    System.out.println("An error occurred.");
                    r.printStackTrace();
                }
                SwingUtilities.updateComponentTreeUI(frame);
            }
        });
        sv.addActionListener(e -> {
            JFrame parentFrame = new JFrame();
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Save a record");
            int userSelection = fileChooser.showSaveDialog(parentFrame);
            if (userSelection == 0) {
                File fileToSave = fileChooser.getSelectedFile();
                stf = "";
                try {
                    StringBuilder ivst = new StringBuilder();
                    int i = 0;
                    while (i < 16) {
                        ivst.append(iv[i]);
                        if (i < 15) {
                            ivst.append(",");
                        }
                        ++i;
                    }
                    String ir = "";
                    String str = ivst.toString();
                    char[] ch = str.toCharArray();
                    int i2 = 0;
                    while (i2 < ch.length) {
                        if (ch[i2] != '\u0000') {
                            int b = ch[i2] / 16;
                            int s = ch[i2] % 16;
                            Integer intObject = Forward_S_Box[b][s];
                            ir = String.valueOf(ir) + String.format("%02x", intObject);
                        } else {
                            Integer c = Forward_S_Box[0][0];
                            ir = String.valueOf(ir) + String.format("%02x", c);
                        }
                        ++i2;
                    }
                    while (ir.length() % 8 != 0) {
                        ir = String.valueOf(ir) + "63";
                    }
                    char[] iarr = new char[ir.length()];
                    int i3 = 0;
                    while (i3 < ir.length()) {
                        iarr[i3] = ir.charAt(i3);
                        ++i3;
                    }
                    int al = iarr.length;
                    int curr = 0;
                    while (curr < al) {
                        Editor.ctostr(iarr, curr);
                        curr += 8;
                    }
                    String eiv = stf;
                    stf = "";
                    String ir2 = "";
                    String str2 = SALTVALUE;
                    char[] ch2 = str2.toCharArray();
                    int i4 = 0;
                    while (i4 < ch2.length) {
                        if (ch2[i4] != '\u0000') {
                            int b = ch2[i4] / 16;
                            int s = ch2[i4] % 16;
                            Integer intObject = Forward_S_Box[b][s];
                            ir2 = String.valueOf(ir2) + String.format("%02x", intObject);
                        } else {
                            Integer c = Forward_S_Box[0][0];
                            ir2 = String.valueOf(ir2) + String.format("%02x", c);
                        }
                        ++i4;
                    }
                    while (ir2.length() % 8 != 0) {
                        ir2 = String.valueOf(ir2) + "63";
                    }
                    char[] iarr2 = new char[ir2.length()];
                    int i5 = 0;
                    while (i5 < ir2.length()) {
                        iarr2[i5] = ir2.charAt(i5);
                        ++i5;
                    }
                    int al2 = iarr2.length;
                    int curr2 = 0;
                    while (curr2 < al2) {
                        Editor.ctostr(iarr2, curr2);
                        curr2 += 8;
                    }
                    String enc_slt = stf;
                    stf = "";
                    String ir1 = "";
                    String str1 = pane.getText();
                    char[] ch1 = str1.toCharArray();
                    int i6 = 0;
                    while (i6 < ch1.length) {
                        if (ch1[i6] != '\u0000') {
                            int b = ch1[i6] / 16;
                            int s = ch1[i6] % 16;
                            Integer intObject = Forward_S_Box[b][s];
                            ir1 = String.valueOf(ir1) + String.format("%02x", intObject);
                        } else {
                            Integer c = Forward_S_Box[0][0];
                            ir1 = String.valueOf(ir1) + String.format("%02x", c);
                        }
                        ++i6;
                    }
                    while (ir1.length() % 8 != 0) {
                        ir1 = String.valueOf(ir1) + "63";
                    }
                    char[] iarr1 = new char[ir1.length()];
                    int i7 = 0;
                    while (i7 < ir1.length()) {
                        iarr1[i7] = ir1.charAt(i7);
                        ++i7;
                    }
                    int al1 = iarr1.length;
                    int curr1 = 0;
                    while (curr1 < al1) {
                        Editor.ctostr(iarr1, curr1);
                        curr1 += 8;
                    }
                    FileWriter myWriter = new FileWriter(fileToSave.getAbsolutePath());
                    myWriter.write(String.valueOf(eiv) + "," + enc_slt + "," + Editor.encrypt_AES(stf));
                    myWriter.close();
                    SecureRandom numb1 = new SecureRandom();
                    int i8 = 0;
                    while (i8 < 16) {
                        Editor.iv[i8] = (byte)numb1.nextInt(256);
                        ++i8;
                    }
                }
                catch (IOException q) {
                    System.out.println("An error occurred.");
                    q.printStackTrace();
                }
            }
        });
    }
}

