#!/usr/local/bin/ruby -Ku

#
# = Micle
# [Author] baku <micle@tohka.info>
# [Version] 0.9.6.1 (2007/05/06)
# [License] {Ruby License}[http://www.ruby-lang.org/ja/LICENSE.txt]
#
# $Id$
#


$: << './lib'

require 'optparse'
require 'cgi'
require 'kconv'
require 'yaml'
require 'lib/string'
require 'lib/log'
require 'lib/config'
require 'lib/rule'
require 'lib/http-access2'
require 'lib/mixi'
require 'lib/community'
require 'lib/community-page'
require 'lib/communities-list'
require 'lib/search-page'
require 'lib/search-pages'

$version = "Version 0.9.6 (2007/05/01)"

$log = Log.new
$rule = Rule.new("./rule.txt")
$config = Config.new("./config.txt")
$mixi = Mixi.new

$log.message("mixiへのログインを試みます。")
if $mixi.login($config[:mail], $config[:pass])
	$log.message("mixiへのログインに成功しました。")
	$config[:key].each_index do |i|
		$log.message("#{$config[:key][i]}を検索します。")
		list = CommunitiesList.new
		searchpages = SearchPages.new($config[:_key][i])
		list.merge!(searchpages.list)
		$log.dump("CommunitiesList#merge!", list.to_a, true, 'f')
		list.delete_ruin!($config[:ruin])
		list.set_range!($config[:range])
		list.get_detail_data
		list.output($config[:_key][i])
	end
else
	$log.message("mixiへのログインに失敗しました。")
	$log.message("Micleを終了します。")
end




# $ rdoc -c euc-jp -NSa -t "Micle Documents" -w 2 *.rb
