#
# = 拡張Stringクラス
# [Author] baku <micle@tohka.info>
# [Version] 0.9.6.1 (2007/05/06)
# [License] {Ruby License}[http://www.ruby-lang.org/ja/LICENSE.txt]
#
# $Id$
#
class String
	#
	# == バイナリデータか調べるメソッド
	# === 引数
	# * なし
	# === 返り値
	# * (boolean)
	# === 概要
	# YMALでマルチバイト文字がバイナリとみなされるバグに対応するため、
	# {/lib/yaml/rubytypes.rb}[http://svn.ruby-lang.org/repos/ruby/trunk/lib/yaml/rubytypes.rb]
	# のString#is_binary_data?を再定義する。
	# * {ruby-list:16014}[http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/16014]
	# * {ruby-list:41779}[http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/41779]
	#
	def is_binary_data?
		return true if self.include?(0)
		check = self[0, 512]
		check.size < 10 * check.count("\x00-\x07\x0b\x0e-\x1a\x1c-\x1f")
	end

	#
	# == 日本語から特定バイトを切り出すメソッド
	# === 引数
	# * (Integer) length
	# === 返り値
	# * (String) str
	# === 概要
	# * {Rubyリファレンスマニュアル>FAQ>日本語の取り扱い#10.10}[http://www.ruby-lang.org/ja/man/?cmd=view;name=FAQ%3A%3A%C6%FC%CB%DC%B8%EC%A4%CE%BC%E8%A4%EA%B0%B7%A4%A4#a10.2e10.20.c6.fc.cb.dc.b8.ec.a4.f2.b4.de.a4.e0.ca.b8.bb.fa.ce.f3.a4.ab.a4.e9.20n.20.a5.d0.a5.a4.a5.c8.a4.f2.c0.da.a4.ea.bd.d0.a4.b7.a4.bf.a4.a4.a4.ce.a4.c7.a4.b9.a4.ac]
	#
	def jleft(length)
		return '' if length <= 0
		str = self[0, length]
		if /.\z/ !~ str
			str[-1, 1] = '' unless str[-1, 1].nil?
		end
		str
	end

	#
	# == BackSpaceを有効にするメソッド
	# === 引数
	# * なし
	# === 返り値
	# * (String) str
	# === 概要
	# BackSpace文字(\b)が含まれていれば、直前の文字を削除する。
	# getsなどで得た文字列には、コンソール上ではBackSpaceキーを
	# 押すことによって直前の文字が削除されているようにみえるが、
	# 実際には、"\bho\b\bmoge"のようになっている。これを"moge"に
	# するためのメソッド。
	#
	def backspace
		str = self.dup
		while !(i = str.index("\010")).nil?
			if i == 0
				str = str.sub(/^\010/, '')
			else
				str = str.sub(/.\010/, '')
			end
		end
		str
	end

	#
	# == 空文字列にするメソッド
	# === 引数
	# * なし
	# === 返り値
	# * self
	# === 概要
	# 破壊的に空文字列にする。String#clearがRuby 1.9以上だったので
	# 自前で定義。
	#
	def clear
		gsub!(/.*/, '')
	end
end
