#
# = コミュニティ検索のページを管理するクラス
# [Author] baku <micle@tohka.info>
# [Version] 0.9.6.1 (2007/05/06)
# [License] {Ruby License}[http://www.ruby-lang.org/ja/LICENSE.txt]
#
# $Id$
#
class SearchPage
	attr_reader :key, :page, :uri, :list
	def initialize(key=nil, page=1)
		@key = key
		@page = page
		@uri = "http://mixi.jp/search_community.pl?page=#{@page}&" +
			"keyword=#{@key}&sort=date&submit=main" unless @key.nil?
		@has_nextpage = false
		@list = CommunitiesList.new
		@community = nil
		@source = String.new
		@dumped = false
		parse unless @uri.nil?
	end
	def parse
		@source = get_source
		@source.scan($rule[:SPLIT_COMMUNITY]) do |source|
			@community = Community.new
			source = source[0]
			@src = source.dup
			@dumped = false
			source = extract(source, :S_GET_NAME)
			source = extract(source, :S_GET_MEMBER)
			source = extract(source, :S_GET_DESC)
			source = extract(source, :S_GET_CATEGORY)
			source = extract(source, :S_GET_ID)
			@list.add!(@community)
		end
		if @source =~ $rule[:GET_NEXTPAGE]
			@has_nextpage = true
		end
	end
	def extract(source, target)
		if source.sub!($rule[target], '').nil?
			$log.alert("正規表現のマッチに失敗しました。 (#{target.to_s})")
			$log.dump("この記事をファイルに出力します。", @src) unless @dumped
			@dumped = true
		else
			case target
			when :S_GET_NAME
				@community.name = $1
			when :S_GET_MEMBER
				@community.member = $1.to_i
			when :S_GET_DESC
				@community.desc = $1
			when :S_GET_CATEGORY
				@community.category = $1
			when :S_GET_ID
				@community.id = $1
			end
		end
		source
	end
	def has_nextpage?
		@has_nextpage
	end
	def get_source
		return nil if @uri.nil?
		$mixi.get(@uri)
	end
end
