#
# = 正規表現パターンを管理するクラス
# [Author] baku <micle@tohka.info>
# [Version] 0.9.6.1 (2007/05/06)
# [License] {Ruby License}[http://www.ruby-lang.org/ja/LICENSE.txt]
#
# $Id$
#
class Rule
	attr_reader :files, :rule
	#
	# == 初期化メソッド
	# === 引数
	# * (String) file=nil
	# === 返り値
	# * self
	# === 概要
	# fileが与えられていれば、そのファイルをインポートする。
	#
	def initialize(file=nil)
		@files = Array.new
		@rule = Hash.new
		import(file) unless file.nil?
		self
	end

	#
	# == ルールファイル読み込みメソッド
	# === 引数
	# * (String) file
	# === 返り値
	# * self
	# === 概要
	# 与えられたファイルを解析して、ルールを読み込む。
	#
	#   # comments
	#   key
	#     value1
	#     value2
	#
	# という形式をとる。キーに対して値はインデントする。値が長くなる
	# 場合は、改行したうえで続けて書ける。
	#
	def import(file)
		return nil if file.nil?
		@files << file
		$log.message("正規表現パターンをインポートします。 (#{file})")
		fh = open(file)
		key = String.new
		value = String.new
		fh.each_line do |line|
			line.chomp!
			next if line =~ /^#/
			next if line.strip == ''
			if line =~ /^\s/
				value << line.toutf8.strip
			else
				@rule[key] = Regexp.new(value)
				key = line.toutf8.strip.to_sym
				value.clear
			end
		end
		@rule[key] = Regexp.new(value)
		fh.close
		$log.message("正規表現パターンをインポートしました。")
		$log.dump("Rule#import", @rule, true, 'f')
	end

	#
	# == ハッシュっぽくアクセス用メソッド
	# === 引数
	# * (Symbol) key
	# === 返り値
	# * (Regexp)
	# === 概要
	# @ruleの内容にアクセスするメソッド。キーはSymbol型をとる。
	#
	def [](key)
		@rule[key]
	end
end
