#
# = mixiにアクセスするクラス
# [Author] baku <micle@tohka.info>
# [Version] 0.9.6.1 (2007/05/06)
# [License] {Ruby License}[http://www.ruby-lang.org/ja/LICENSE.txt]
#
# $Id$
#
class Mixi
	#
	# == 初期化メソッド
	# === 引数
	# * (Float) wait=2.0
	# * (String) cookiefile='cookie.dat'
	# === 返り値
	# * self
	# === 概要
	# 各メンバを初期化。
	#
	def initialize(wait=2.0, cookiefile='cookie.dat')
		@wait = [wait.to_f, 0].max
		@cookiefile = cookiefile
		@nowaitcount = 10
		@sleeptime = 5
		self
	end

	#
	# == ログイン用メソッド
	# === 引数
	# * (String) mail
	# * (String) pass
	# * (String) proxy=nil
	# === 返り値
	# * (Boolean)
	# === 概要
	# mixiにログインを試みる。mixiにログインできたかどうかを返す。
	#
	def login(mail, pass, proxy=nil)
		@clnt = HTTPAccess2::Client.new(proxy)
		@clnt.set_cookie_store(@cookiefile)
		r = post("http://mixi.jp/login.pl",
			"email=#{mail}&password=#{pass}&next_url=/home.pl")
		r !~ $rule[:FAILED_LOGIN?]
	end

	#
	# == POSTでデータを送信するメソッド
	# === 引数
	# * (String) path
	# * (String) param
	# === 返り値
	# * (String)
	# === 概要
	# POSTでデータを送信します。
	#
	# [path] http ://foo/bar?hoge=mogeのhttp ://foo/bar
	# [param] http ://foo/bar?hoge=mogeのhoge=moge
	#
	def post(path, param)
		path = "http://mixi.jp/#{path}" if path !~ /^http\:\/\//
		@clnt.post(path, param).content.toutf8
	end

	#
	# == GETでデータを送信するメソッド
	# === 引数
	# * (String) path
	# === 返り値
	# * (String) r
	# === GETでデータを送信します。
	#
	def get(path)
		if @nowaitcount > 0
			@nowaitcount -= 1
		else
			sleep @wait
		end
		path = "http://mixi.jp/#{path}" if path !~ /^http\:\/\//
		r = @clnt.get(path).content.toutf8.gsub!(/\r\n|\r|\n/, '<NL>')
		while r =~ $rule[:ACCESS_LIMITATION?]
			@log.warning("アクセスが制限されています。" +
				"#{@speeptime}秒後に再接続を試みます。")
			sleep @sleeptime
			@sleeptime += 1
			@nowaitcount = 10
			r = @clnt.get(path).content.toutf8.gsub!(/\r\n|\r|\n/, '<NL>')
		end
		r
	end

	#
	# == GETでデータを送信するメソッド
	# === 引数
	# * (String) path
	# === 返り値
	# * (Binary)
	# === 概要
	# getと違い生のデータを得る。主にバイナリデータを扱うときに使う。
	#
	def get_img(path)
		path = "http://mixi.jp/#{path}" if path !~ /^http\:\/\//
		@clnt.get(path).content
	end
end
