#
# = コミュニティのデータを管理するクラス
# [Author] baku <micle@tohka.info>
# [Version] 0.9.6.1 (2007/05/06)
# [License] {Ruby License}[http://www.ruby-lang.org/ja/LICENSE.txt]
#
# $Id$
#
class Config
	def initialize(file=nil)
		@file = file
		@config = Hash.new('')
		import(@file) unless @file.nil?
		parse_option
		check_config
		self
	end
	def import(file=nil)
		return self if file.nil?
		$log.message("設定ファイルをインポートします。 (#{file})")
		fh = open(file)
		fh.each_line do |line|
			line = line.toutf8.strip
			next if line =~ /^#/
			next if line == ''
			if line.index(',').nil?
				$log.warning("設定の書式が正しくありません。 (#{line})")
			else
				key, value = line.split(',', 2)
				@config[key.strip.to_sym] = value.strip
			end
		end
		$log.message("設定ファイルをインポートしました。")
		dump("Config#import", @config, true, 'f')
		self
	end
	def parse_option
		opts = OptionParser.new
		opts.program_name = "Micle"
		opts.version = $version
		opts.on("-m", "--mail MAIL", String, /.*/,
			"your mail address when login mixi") do |value|
			@config[:mail] = value
		end
		opts.on("-p", "--pass PASSWORD", String, /.*/,
			"your password when login mixi") do |value|
			@config[:pass] = value
		end
		opts.on("-k", "--key KEYWORDS", String, /.*/,
			"keyword for searching communities") do |value|
			@config[:key] = value
		end
		opts.on("-r", "--range RANGE", String, /.*/,
			"range for communities included result") do |value|
			@config[:range] = value
		end
		opts.on("-i", "--ignore-ruin", nil, nil,
			"whether delete ruin communities or not") do |bool|
			@config[:ruin] = "1" if bool
		end
		opts.on("-o", "--only-ruin", nil, nil,
			"whether only ruin communities or not") do |bool|
			@config[:ruin] = "2" if bool
		end
		opts.on("-l", "--description-length NUM", String, /.*/,
			"length for communities' description") do |value|
			@config[:desc] = value
		end
		opts.on("-d", "--decode-filename", nil, nil,
			"whether decode filename output or not") do |bool|
			@config[:decoded?] = "1" if bool
		end
		opts.on("-c", "--charset CHARSET", String, /.*/,
			"charset for output files") do |value|
			@config[:charset] = value
		end
		opts.parse!
		dump("Config#parse_option", @config, true, 'f')
	end
	def check_config
		while @config[:mail].empty?
			$log.alert("メールアドレス")
			@config[:mail] = gets.toutf8.strip.backspace
		end
		while @config[:pass].empty?
			$log.alert("password")
			@config[:pass] = gets.toutf8.strip.backspace
		end
		while @config[:key].empty?
			$log.alert("key")
			@config[:key] = gets.toutf8.strip.backspace
		end
		@config[:key] = @config[:key].split(',')
		@config[:_key] = Array.new
		@config[:key].each_index do |i|
			@config[:key][i].strip!
			@config[:_key][i] = CGI.escape(@config[:key][i].toeuc)
		end
		if @config[:charset].empty?
			@config[:charset] = 'shift_jis'
		end
		@config[:ruin] = @config[:ruin].strip.to_i
		if @config[:range] =~ /date/
			@config[:ruin] = 1
		end
		@config[:decoded?] = @config[:decoded?].strip.to_i
		if @config[:desc].empty?
			@config[:desc] = 1000
		else
			@config[:desc] = @config[:desc].strip.to_i
		end
		case @config[:charset].strip.downcase
		when 'jis', 'iso-2022-jp'
			@config[:charset] = 'iso-2022-jp'
			@config[:charsetcode] = Kconv::JIS
		when 'sjis', 'shift_jis'
			@config[:charset] = 'shift_jis'
			@config[:charsetcode] = Kconv::SJIS
		when 'euc', 'euc-jp'
			@config[:charset] = 'euc-jp'
			@config[:charsetcode] = Kconv::EUC
		when 'utf8', 'utf-8'
			@config[:charset] = 'utf-8'
			@config[:charsetcode] = Kconv::UTF8
		else
			$log.warning("指定された文字コードには対応していません。")
			@config[:charset] = 'shift_jis'
			@config[:charsetcode] = Kconv::SJIS
		end
		dump("Config#check_config", @config, true, 'f')
		self
	end
	def dump(msg, data, pretty=false, mode='')
		clone = data.dup
		clone.delete(:mail)
		clone.delete(:pass)
		$log.dump(msg, clone, pretty, mode)
	end
	def [](key)
		@config[key]
	end
end
