#
# = コミュニティのデータを管理するクラス
# [Author] baku <micle@tohka.info>
# [Version] 0.9.6.1 (2007/05/06)
# [License] {Ruby License}[http://www.ruby-lang.org/ja/LICENSE.txt]
#
# $Id$
#
class Community
	#
	attr_accessor :id, :name, :member, :desc, :description, :category,
		:since, :span, :administer, :administer_id, :private, :permittion,
		:uri
	
	#
	# == 初期化メソッド
	# === 引数
	# * なし
	# === 返り値
	# * self
	# === 概要
	# 各メンバの初期化。
	#
	def initialize
		@id = ''
		@name = ''
		@member = 0
		@desc = ''
		@description = ''
		@category = ''
		@since = ''
		@span = 0
		@administer = ''
		@administer_id = ''
		@private = ''
		@permittion = ''
		@uri = ''
		self
	end

	#
	# == 廃墟コミュニティかどうかを返すメソッド
	# === 引数
	# * なし
	# === 返り値
	# * (Boolean)
	# === 概要
	# 廃墟と化していたらtrueを返す。
	#
	def ruin?
		@member == 0
	end

	#
	# == Hash化メソッド
	# === 引数
	# * なし
	# === 返り値
	# * (Hash)
	# === 概要
	# 各メンバをHashにして返す。キーはSymbol型。
	#
	def to_hash
		Hash[:id, @id, :name, @name, :member, @member, :desc, @desc,
			:description, @description, :category, @category, :since, @since,
			:span, @span, :administer, @administer, :permittion, @permittion,
			:administer_id, @administer_id, :private, @private, :uri, @uri]
	end

	#
	# == CSV化メソッド
	# === 引数
	# * なし
	# === 返り値
	# * (String)
	# === 概要
	# 一部のメンバをCSV形式で返す。
	#
	def to_csv
		csv = Array.new
		csv << escape_csv(@id)
		csv << escape_csv(@name)
		csv << escape_csv("#{@member}人")
		csv << escape_csv(@category)
		csv << escape_csv(@since)
		csv << escape_csv(@desc.gsub(/\<[^\>]*\>/, ''))
		csv << escape_csv(@uri)
		csv.join(',')
	end
	def escape_csv(string)
		if string =~ /[\,\"\r\n\t]/
			string.gsub!(/\"/, '""')
			string.gsub!(/\r\n/, "\n")
			"\"#{string}\""
		else
			string
		end
	end
	
	#
	# == 未稿
	def [](key)
		case key
		when :administer
			@administer
		when :administer_id
			@administer_id
		when :category
			@category
		when :desc
			@desc
		when :description
			@description
		when :id
			@id
		when :member
			@member
		when :name
			@name
		when :permittion
			@permittion
		when :private
			@private
		when :since
			@since
		when :span
			@span
		when :uri
			@uri
		else
			nil
		end
	end
	def []=(key, value)
		case key
		when :administer
			@administer = value
		when :administer_id
			@administer_id = value
		when :category
			@category = value
		when :desc
			@desc = value
		when :description
			@description = value
		when :id
			@id = value
		when :member
			@member = value
		when :name
			@name = value
		when :permittion
			@permittion = value
		when :private
			@private = value
		when :since
			@since = value
		when :span
			@span = value
		when :uri
			@uri = value
		else
			nil
		end
	end
	#
	# == 未稿
	def kconv!(out_code, in_code=Kconv::AUTO)
		@administer = @administer.kconv(out_code, in_code)
		@administer_id = @administer_id.kconv(out_code, in_code)
		@category = @category.kconv(out_code, in_code)
		@desc = @desc.kconv(out_code, in_code)
		@description= @description.kconv(out_code, in_code)
		@id = @id.kconv(out_code, in_code)
		@name = @name.kconv(out_code, in_code)
		@permittion = @permittion.kconv(out_code, in_code)
		@private = @private.kconv(out_code, in_code)
		@since = @since.kconv(out_code, in_code)
		@uri = @uri.kconv(out_code, in_code)
	end
	def tojis!
		kconv!(Kconv::JIS)
	end
	def toeuc!
		kconv!(Kconv::EUC)
	end
	def tosjis!
		kconv!(Kconv::SJIS)
	end
	def toutf8!
		kconv!(Kconv::UTF8)
	end
end

