#
# = コミュニティのページを管理するクラス
# [Author] baku <micle@tohka.info>
# [Version] 0.9.6.1 (2007/05/06)
# [License] {Ruby License}[http://www.ruby-lang.org/ja/LICENSE.txt]
#
# $Id$
#
class CommunityPage
	attr_reader :id, :uri, :list, :community
	def initialize(id=nil)
		@id = id
		@uri = "http://mixi.jp/view_community.pl?id=#{@id}" unless @id.nil?
		@list = CommunitiesList.new
		@community = nil
		@source = String.new
		@dumped = false
		parse unless @uri.nil?
	end
	def parse
		@community = Community.new
		@community.id = @id
		@community.uri = @uri
		@source = get_source
		source = @source.dup
		source = extract(source, :C_DIET)
		source = extract(source, :C_GET_NAME)
		source = extract(source, :C_GET_SINCE)
		source = extract(source, :C_GET_ADMINISTER)
		source = extract(source, :C_GET_CATEGORY)
		source = extract(source, :C_GET_MEMBER)
		source = extract(source, :C_GET_PRIVATE)
		source = extract(source, :C_GET_PERMITTION)
		source = extract(source, :C_GET_DESCRIPTION)
		@list.add!(@community)
	end
	def extract(source, target)
		if source.sub!($rule[target], '').nil?
			$log.alert("正規表現のマッチに失敗しました。 (#{target.to_s})")
			$log.dump("この記事をファイルに出力します。", @source) unless @dumped
			@dumped = true
		else
			case target
			when :C_DIET
				nil
			when :C_GET_NAME
				@community.name = $1
			when :C_GET_SINCE
				@community.since = $1
				@community.span = $2.to_i
			when :C_GET_ADMINISTER
				@community.administer_id = $1
				@community.administer = $2
			when :C_GET_CATEGORY
				@community.category = $1
			when :C_GET_MEMBER
				@community.member = $1.to_i
			when :C_GET_PRIVATE
				@community.private = $1
			when :C_GET_PERMITTION
				@community.permittion = $1
			when :C_GET_DESCRIPTION
				@community.description = $1
			end
		end
		source
	end
	def get_source
		return nil if @uri.nil?
		$mixi.get(@uri)
	end
end
