#include <stdlib.h>
#include <string.h>
#include <mhash.h>
#include "mhd_common.h"

/* Find digest algorithms */
size_t
mhd_find(const char* name)
{
    const char* static_name = NULL;
    size_t      i           = 0;

    for (i = 0; i <= mhash_count(); ++i) {
        if ((static_name = (const char*) mhash_get_hash_name_static(i))) {
            if (strncmp(static_name, name, MHD_TEXT_BUFFER_SIZE) == 0) {
                return i;
            }
        }
    }

    return MHD_NOT_FOUND;
}

/* Constant: MHD_NOT_FOUND */
size_t
mhd_not_found()
{
    return mhash_count() + 1;
}
