##################################################################################################
# MHash-384 - Language bindings for Python                                                       #
# Copyright(c) 2016-2018 LoRd_MuldeR <mulder2@gmx.de>                                            #
#                                                                                                #
# Permission is hereby granted, free of charge, to any person obtaining a copy of this software  #
# and associated documentation files (the "Software"), to deal in the Software without           #
# restriction, including without limitation the rights to use, copy, modify, merge, publish,     #
# distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the  #
# Software is furnished to do so, subject to the following conditions:                           #
#                                                                                                #
# The above copyright notice and this permission notice shall be included in all copies or       #
# substantial portions of the Software.                                                          #
#                                                                                                #
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING  #
# BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND     #
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,   #
# DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, #
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.        #
##################################################################################################

class MHash384:
    #------------------------------------------------------------------------
    # CONSTANTS
    #------------------------------------------------------------------------

    __HASH_LEN = 48

    __VERSION_MAJOR = 1
    __VERSION_MINOR = 2
    __VERSION_PATCH = 1

    __TABLE_INI = (
        b'\xEF\xDC\xB6\x6D\x4E\xCC\x1A\xA4\xAF\x9B\x3F\x20\x46\x98\xFA\xC6\xA3\x06\xB4\x11\x98\x7C\x28\x2A\xE8\x92\x49\xC2\x64\xA9\xE1\xC8\xA4\xAB\x93\x16\x1F\x35\x96\x77\x35\x2F\xC8\xB5\x6B\x6E\x37\xAE', #00
        b'\x1E\xE1\x47\x18\xEC\xF4\x37\xF2\x81\x48\x21\xC5\x71\x0E\x28\xA3\xEF\x41\xE3\x0D\x49\x08\x7A\x37\x9D\x50\xEF\xB0\x07\x95\x75\x85\x88\xF9\x5D\xC7\xAE\xA0\xFA\x41\xBF\x81\x9D\xEF\x28\x23\x63\x78'  #01
    )

    __TABLE_XOR = (
        b'\x01\xDC\xDF\x00\x41\x4B\x30\x37\xB1\xB3\xAF\x66\x1B\x8E\x96\xF8\x94\x4D\x28\x73\xDB\x39\x31\x21\x73\xDA\x9A\x36\x66\x2A\xE7\x55\x1F\x4F\x31\x8C\x4E\xCB\x56\xB1\xF0\x97\x43\xD9\x9C\x2A\xA5\xBC', #00
        b'\xA8\x1F\xBB\xC6\xCB\xBF\xC9\x54\x39\xDE\x43\x64\x89\x59\xED\xDB\x1A\x64\x1A\x0B\xDA\x01\x82\x2F\xB5\x2E\x60\x72\x66\x93\x26\x58\x2C\x5B\x17\x31\xAC\x80\x20\x84\xC2\xEF\x10\x67\x1F\xC7\x9D\xD4', #01
        b'\xCF\x2A\x8D\x8E\x08\x81\x00\x46\x8B\x7E\x9B\x20\x89\xE2\x68\xF6\x93\x04\x61\x65\x2C\x5D\x2D\xEC\xF0\x96\xE4\x22\x23\xBF\xC8\xB9\x8D\xD3\x38\x96\x4C\xFE\x09\x70\x26\x9C\x34\x2F\x7C\xEC\x60\xBD', #02
        b'\xB9\x70\xA9\x20\xD2\xED\x05\x52\x01\x0F\x89\x4A\x25\x4D\xA7\xE1\x8D\x5F\x20\x5F\x9D\x1A\x40\xD8\x50\xC3\x3D\xCC\xC3\xFD\x5F\x58\xB4\x9F\x31\xBD\xE7\xD8\x2C\x57\x7C\xDE\x04\xF6\x2A\x95\x90\x33', #03
        b'\x49\xFA\xB2\x82\x2B\x9C\x84\xAC\x34\xB8\x64\x8C\xD6\x8C\xBE\xF1\xE5\x12\x11\x47\xBB\x41\x26\xDE\xC0\xB3\x1F\x54\xB2\xFF\xE0\x0F\x2F\x19\x3D\xA3\x8E\x8C\xC6\x32\x05\x8C\x98\x4B\x42\x9B\x8A\xFC', #04
        b'\xE0\x7F\x9D\xA4\x4D\x8C\x99\x42\xBE\x2A\xF9\xB3\x9A\xCA\x65\xF2\x5D\x3D\x8F\xB1\x46\x6D\xC2\x95\xC0\x05\x1E\x3E\xC3\xF9\x62\xC7\xF8\xFD\xC3\xCC\xD4\xCE\x2B\xB6\x90\x24\xC0\xEF\xC6\x19\x99\x37', #05
        b'\xA3\x11\x13\x77\xEF\x01\xF5\xEF\x31\xF5\x9B\x36\x6C\x02\xA3\xFF\x61\xB8\x29\x49\x76\x0D\x16\xDC\xF6\xB9\x58\xAF\x92\xBD\x3B\xDF\x72\x97\xAA\xEF\xEC\x69\xC0\xB2\xFE\x8A\x50\xAD\x9E\x86\x84\xCD', #06
        b'\x3D\x3D\xD0\xC8\x29\xEA\x9A\xA0\x3E\x77\x59\x7E\xEC\x96\xC7\xA3\x8F\xD0\x38\x23\x1E\x7F\x16\x84\x64\x61\x7B\x13\x1F\xB7\xED\xE0\x85\xC9\x9C\xE4\xC5\x40\x58\x74\xA5\x87\x35\xD4\x1F\x19\xC5\xE3', #07
        b'\x80\x28\x62\x8A\xCA\xF9\x1B\x9A\x19\x4A\x64\x05\x38\xC9\x70\x64\x04\xA1\x5E\x01\x8A\x4F\x16\x80\xF4\xBE\x1B\x04\xC2\x36\x09\x55\xDF\xB2\x4D\x4C\xEF\x58\x1A\x20\x3C\x59\xD0\xA0\xFD\x15\x87\x9D', #08
        b'\x88\xF8\xE2\xEC\xE7\x8A\xF1\xBC\xB4\x6B\x6E\x22\x29\x73\x64\xC2\x93\x39\xF1\x7F\x92\x6B\x99\xF3\x31\x29\x34\x89\xB3\xB8\xF0\x7C\x39\x09\xCE\x16\x49\xC9\xBC\xF1\x0C\x46\x10\x3B\xFA\x31\xBC\xE9', #09
        b'\x4D\x1A\x0B\x8C\xC7\xEF\xE2\xA9\xAF\xD7\x87\x8C\xAD\x55\xE8\x71\xC8\x9C\xFB\xC8\x58\xCF\x41\x53\xC4\x73\x94\x86\xC7\x4F\x75\xD6\x0B\xF7\x19\x2C\x13\x0A\xC9\xF2\x00\x84\xF2\xBC\x5E\x81\xBD\x9A', #0A
        b'\x4A\xFB\xE9\x75\x01\x4F\xCA\xCF\x41\xDE\xAF\x8C\xFA\xCC\x41\xE4\x3C\x1E\xC2\x3B\x53\xED\x16\xE9\x78\xB0\x6E\xB3\x0F\x1C\x32\x48\xDD\x11\x16\x5D\x04\x28\x5C\x72\x65\x46\xD9\xB5\x60\x94\x91\xE4', #0B
        b'\xFF\xD1\xE2\xE0\x4D\xC8\xD2\x60\x07\xB1\x86\x94\x8A\x74\xEC\xCE\xB5\x12\x0E\x45\x12\x1A\xC5\x31\xBD\x0B\xC8\x63\x30\x81\x0C\x85\xDE\x93\xAF\xDD\xDB\x48\x77\x30\x78\xDE\xB0\xDE\x6E\xB9\x91\x96', #0C
        b'\x79\xBA\xA2\xAC\x3F\xDE\xBA\x55\xB1\xB7\xE3\xE1\xC9\x2A\x56\x7E\xA5\x3F\x69\xAB\x4A\x5B\x07\x94\xF0\xDA\x74\x99\x95\x4F\x6D\xDD\x58\x11\x7C\x89\xE1\x13\x22\x48\xD9\x5D\xF5\xF7\x94\xC5\x1A\x6E', #0D
        b'\x89\xBC\x8A\x0C\x65\x09\x1C\x33\xB0\x4E\xEA\xEE\x06\x31\x35\xC2\xF5\x32\x67\xE0\x4A\xB6\xE6\x89\xB4\xC5\x79\xB7\x20\x7E\x8B\xF2\x3F\xD3\x1E\x51\x34\x3C\xD2\xDF\x11\x9E\x52\x3E\x2F\x81\x97\xFE', #0E
        b'\x2E\x10\xCB\x1C\x60\x60\xF3\x2D\xBC\x92\xE7\x32\xA9\x4E\x6B\x63\xF3\x22\x0D\x83\x1F\xD0\x42\x67\x50\x2C\x5F\x74\x14\xBC\xE8\x7F\x89\xE0\x65\x1D\xE9\x1D\x24\x57\x75\x9E\x56\xB0\x44\x82\xD9\x15', #0F
        b'\x43\xAE\xE3\x2C\x6A\x84\xE8\x03\x0C\x50\x07\x20\x2C\x0B\xD7\xE3\xB4\xF4\x64\x47\x42\x05\xD3\x2A\x7D\x17\xFC\x95\xDE\x38\x6C\x06\xE8\xDF\xBF\x64\x56\x7A\xA5\x45\x55\xBD\x88\x9D\x58\x53\x04\x6F', #10
        b'\x68\x7A\xBE\x14\xEA\xB8\xDA\x27\x39\x7B\x3A\xB5\x0D\x72\xC3\x44\x50\x5E\xAA\x6D\x1F\xDE\x61\x8D\x61\xBE\x79\x86\x5D\xA1\x3F\x69\x17\xBB\xAB\x29\xB5\xE9\x0E\x2D\x01\x0C\x92\x19\x72\xFA\x8B\x2F', #11
        b'\x8B\x72\x23\xA4\xF5\x6F\xF4\x53\x29\x1B\x7B\x5C\xB9\x8B\x6F\xE1\xFD\x42\x16\x25\x78\x6F\xBF\x7D\xE3\x3D\x10\x20\xD0\xE8\xCD\xC8\xCA\x53\x0C\x70\x8B\x73\x9E\x87\x87\x8A\xF1\xF3\x04\xB8\xA1\x2F', #12
        b'\x7E\xCE\x1F\x24\xE5\x6D\xD7\x11\x2E\x08\x69\x24\x1B\x2F\xA6\xDF\x84\xB8\x34\xDC\xC4\x59\xB2\xFD\xE0\x22\xED\xA6\x31\x9E\x7D\x3B\x59\x83\x9D\x8C\xA0\x3C\x99\x28\x64\x47\x90\xF4\x91\xBB\xC7\x74', #13
        b'\xCB\xDC\x6F\x49\xE6\xB0\xDD\x0D\x44\xBA\x2F\x8D\x00\x34\x67\x32\x86\xBC\xC8\x21\x58\x6A\xE6\x1C\xC7\xB7\x49\x12\x85\xCE\xE5\x5B\xED\x39\x12\xFF\xD9\x7F\x38\x51\xF4\xAF\x01\x86\xBE\xBE\xBC\xBF', #14
        b'\xCA\x8A\x48\xE5\x4E\xCC\xE5\x16\xBE\xDF\x18\x64\xB7\xF8\xF5\x06\xD5\x6A\x1F\x60\xA4\xB3\x6A\xA4\x49\xB2\x5A\xB5\xFE\x0D\xD9\xD9\x21\x37\x7D\xBB\x5E\x49\xFC\xE1\x70\x8F\x64\xF5\xD5\x9D\x99\xE7', #15
        b'\xE9\xF8\x73\xA5\x69\xAF\xE0\x2C\xDA\x66\xBC\x05\xCA\x99\x73\x90\x8C\x88\x17\x47\x56\xD3\x53\x85\xEA\xAA\xF1\x6C\xF4\xFD\xA7\x30\xB3\x9F\x7A\x55\x65\x3A\x35\x12\xF1\x0A\xB7\x27\xBC\x23\xE8\x52', #16
        b'\x93\xE9\x6F\xF8\xC5\xBB\xE2\xAF\xA4\x77\x85\x42\x02\x53\xE9\x7C\x70\x4B\x25\xD1\xF7\x7D\x07\x4C\xC0\xB2\x09\x3F\x14\x70\x55\x9C\x8D\x5B\xFD\xD4\xE3\x64\xAA\xCF\x55\x05\x18\x67\x3F\x5B\x1B\xF7', #17
        b'\x8D\xAC\x83\x2E\x5B\xE8\x1A\xCB\x58\x8B\xFB\x20\x2B\x75\x83\xD8\xA3\x4D\x8A\x70\xDF\xD1\xD7\xE4\xD0\x3B\x06\x27\xB6\x87\x03\x3E\xE3\xD0\xBE\x7E\xDB\xDC\x75\xCF\x81\x8E\xE8\xC5\xB0\x9F\x8B\xEA', #18
        b'\x8E\x3B\x02\xE1\x48\x9D\x7D\x31\x53\x36\x75\x2B\x64\xE3\xB5\x32\xE4\xD4\xCC\x79\x5C\x58\x0A\x65\x6D\xAB\x08\xF3\x13\xED\x76\x7E\x8E\x56\x7E\x88\xFD\xBA\x36\xBF\x25\x94\x90\xF1\xD8\xE9\x33\xD0', #19
        b'\xEA\xB4\x37\xD0\xD6\x2C\xAA\x62\xC0\x90\xAD\x28\xB9\x82\xB0\x03\xE2\x55\xD7\x68\xD2\x57\x04\xEC\xA0\x48\x51\x1A\xF6\x25\x6A\x43\xE7\x9F\x07\x8F\x4D\x49\x8B\x5F\xC4\x17\x35\xFB\x75\xB3\x57\xFE', #1A
        b'\x70\xDA\x9F\xC3\x50\x4F\xF2\x9D\xB9\xAB\x1F\x38\x86\x73\xFF\x25\x36\x92\x2F\x4C\xD1\x73\x57\xBA\xF0\x9C\x3A\xB2\x92\xE7\xE0\x4A\x90\xCE\x0B\xC3\xD9\xBA\x13\xEC\x64\x7C\x4C\xA6\x3C\x91\x8D\xE3', #1B
        b'\xD8\x34\xA3\x8D\xD1\xEC\xD6\x88\xA9\x7A\x00\x20\xDE\x46\xAB\x6A\x9C\xDE\xC7\xF6\xE6\x2E\xA7\x1F\x28\x8A\x5A\x6F\xD7\x4D\xC4\x7E\xD4\x4A\x2E\x27\x65\xCE\x50\xF1\xBB\x9B\x50\xB5\xDB\x9E\x4F\x3C', #1C
        b'\xC6\x6D\xA9\x0E\x41\xDD\xF2\xE6\x5A\x3F\xE8\x6F\x16\x0C\x5C\x09\x6F\x6A\xF0\x40\x51\x08\xCC\xBE\xF9\x38\x38\x2E\xB6\x27\xFC\x7F\x16\x3D\xD6\x34\x61\x7F\x00\x6C\x51\x84\xB1\xFE\xDC\x90\x84\x97', #1D
        b'\xC9\x57\x19\xED\x07\xFC\xB2\x1C\x51\x12\xDF\x04\x3F\x6E\xE7\xEB\x50\xF9\xFD\x60\x01\x23\x34\xCE\x58\x9F\xA8\x51\x04\xD9\x65\x79\xB7\x12\x9E\x44\xD7\x19\x05\xA7\x33\x14\x76\x6E\x07\x33\x52\x8D', #1E
        b'\xDC\x6C\x80\x14\xC5\x45\x7C\xB8\xD6\x35\xFD\xCD\x28\x6A\x69\xB6\xD6\x6F\x23\x2C\xE2\x7D\x01\xBF\x56\xAF\x4A\xC0\xF6\x82\xEC\x0F\x57\xDF\x1D\x55\xB6\x43\x28\xF5\x65\x1E\xD4\xC5\x2A\x87\xCA\xCA', #1F
        b'\x26\xD9\xD1\xCC\x79\xEE\xC5\x02\x69\xBF\x34\x0A\x34\xB1\xEB\xFE\xFA\xA5\xAA\xAC\x8E\x39\x71\x74\xD0\xA8\xF9\xBD\x42\x6B\xCF\x6F\x5B\x13\x1F\x46\x4D\x6D\x24\x52\x12\x2D\xD1\x56\x60\xD0\xD6\xDA', #20
        b'\x6E\x38\x9A\xEC\x5F\x51\xA2\x2F\x7E\xF6\x8F\x1C\x54\xC1\x27\xFB\x98\x6D\x4D\x46\xE0\x48\x5C\x30\xF0\xA4\x7B\x39\xE7\xCF\x8A\x31\x1D\x39\x8D\xFD\xB7\xF2\xA7\x8F\x2F\xC6\x51\xD1\xFB\xB1\x0D\x2E', #21
        b'\xA4\x4E\x4E\x8D\x1B\x49\xDC\xB0\x07\xA4\x82\x20\x49\xC2\xF3\x43\xC4\x0A\xC0\x4A\x8D\x65\x05\xBA\xD9\xB9\x1D\x3F\x07\x29\xB1\x6C\xAA\xF3\x99\x51\xB5\x0F\x90\x15\x96\x6E\xF5\xD3\xAD\x3F\x90\x76', #22
        b'\xEA\x78\xCB\xAC\x0E\xB6\xD0\x09\xA0\xFE\xA6\x72\x5A\x23\xDE\xAB\xCE\x72\x9C\x74\x44\xCB\x94\xD9\x40\xA9\x94\x62\x66\x27\xAA\x0D\x37\xF7\x38\xCD\xE3\xD0\x18\xD5\x4C\x29\x49\x1C\x01\xCD\xB3\xC5', #23
        b'\x7C\x97\x92\xAE\xA7\x45\xC8\x7A\xD1\xFF\x56\x20\xC5\xBD\x8F\xD4\x9E\xCA\x84\xE3\x00\x4B\x56\xB9\x5A\xFD\x39\x23\xC2\x28\xB1\xD6\xE5\xDB\xF7\x9E\xB3\xFD\x28\x3B\x44\x17\x12\xE3\x54\x08\x4B\x9F', #24
        b'\xE3\x5D\x28\x8B\xD8\xE2\x49\xBC\x91\x77\x6C\x14\x53\xA3\x66\xE5\xF5\xD1\xE1\x68\x4E\x95\xEF\xEC\x91\x08\xE1\x17\xD7\xDD\xF6\x06\x81\xB3\x0F\x9D\xA2\xCE\x7C\x8C\x64\x97\xDB\xD7\x86\x81\x8C\x0D', #25
        b'\xC2\xF8\x91\xFF\x45\x04\x4B\xE0\x75\xA1\xA7\x6D\x2B\x87\xE2\xEB\x85\xCE\x65\x79\x8A\xF3\xC2\xBF\x21\x3F\x53\x2B\x4E\xFD\x09\xDC\x0D\xAA\x1D\xF5\xA5\x3A\x6C\x88\x30\x28\x60\x6A\x50\xD8\x26\xB2', #26
        b'\x60\x9A\x62\x61\x63\x79\xF3\x3A\xA3\x39\xA3\xBC\x53\xE4\x51\x6D\xD7\xAD\x92\x61\x6A\x5A\xDB\xEC\xD0\x43\x72\x6D\x86\xE9\x24\xAA\x85\x55\xB5\x64\xF4\xC2\x98\x65\x56\xAA\x12\xAB\x31\xC1\xD6\xB0', #27
        b'\xCE\xD9\xED\x85\xC1\xC1\x7B\xFF\xEB\x52\x23\x25\xAC\xBA\xFF\xC2\x04\xD3\xD8\xF4\xB2\xD1\x53\x94\xD2\x71\x50\x4C\x04\x75\x6E\xEA\x2D\xDB\xA4\xA9\x1A\xF8\x27\xF1\x1F\x67\xD5\xC2\x8F\x80\x02\xE4', #28
        b'\x8B\x9C\x08\xAD\x43\x2D\xC0\x8F\x5A\x75\x43\xE2\x97\x96\xBB\xC7\x34\xA6\xDB\x5B\x3C\x19\x67\xDE\x01\x6E\x3B\xC2\xA2\x80\x4E\xE4\x5B\x9B\xCA\xCC\xE5\x17\x2F\x75\x75\x49\x59\x8B\x80\xAD\xBD\xBA', #29
        b'\x6F\x3F\xB1\x17\xC5\xCD\xD1\x55\x16\xC3\xB0\xA5\x9C\xD6\xEE\xC5\xD9\xA1\xA4\x11\xDE\x53\x87\x69\x93\x8C\x54\x97\x9F\x4A\xC3\x7C\x37\x37\xBC\xC1\xD5\x52\x84\xDB\x6C\xAD\x9F\x8A\xF9\x15\x6B\xB7', #2A
        b'\xEB\xBF\x28\x4F\x9C\x75\xEB\xDF\xB3\x83\xEB\xB4\x06\x75\x3D\xE8\xAA\x86\x12\x7A\xEE\x7C\x40\x3C\x10\xBF\xDD\x10\x52\x3D\xE0\x27\x13\x8B\xF6\xC4\xEB\x4A\x8A\x13\xB1\xEF\xF6\x7D\xDB\x78\xB0\x67', #2B
        b'\xF6\xD1\x13\x8D\x7A\xA3\xDA\x5E\xBA\xA8\x09\x8D\x8F\xB6\x63\x71\xDA\xE7\x6D\x1B\x8B\x6C\xAA\xF2\x40\x0F\x10\x34\x36\x8D\x1E\xDC\x7C\x93\x7F\x51\x72\xE8\xD2\x77\x7D\x05\xBB\xF8\x3C\xAD\xE6\xEF', #2C
        b'\x0E\x9C\x2E\xA6\xCF\x34\xB0\x81\x90\x36\xB3\x0D\x58\xF6\x0B\xA0\xDB\x3A\x2C\x58\x48\xF0\x8B\xCA\xC8\x7A\xD1\xB9\x42\x50\xD5\x64\x7C\x89\x2E\x09\xEE\xF9\x61\x66\x26\xDB\x85\xCF\x57\x10\x85\xF3', #2D
        b'\x25\x1E\xE3\xF5\x87\x18\xC1\x2A\xF9\x43\x8D\x81\x17\x8A\x2A\xE4\xF0\x92\x9A\x88\x90\x39\xA8\xA8\xF0\x6B\x65\x22\x5E\xBD\xCC\xFD\x2E\x4D\x14\xED\xF7\xBF\x73\xC6\xA9\x36\x98\x95\xBC\x1D\xFA\xCF', #2E
        b'\xCA\xE3\x02\xB4\x1D\x69\x79\xCB\xBB\xFA\x5A\x58\xB5\x1E\xE6\x23\x51\x13\xB9\x9D\xC8\x1A\xB5\x2F\x60\x93\x79\x5B\xEC\x17\xA0\x56\x8F\x71\xFB\x4D\x2E\x5E\x35\x5E\x76\x2F\x92\xED\xBA\x34\xA2\xF2', #2F
        b'\xD1\x30\x01\x52\x65\xA4\xD9\xFF\x09\xBE\xA2\x53\xD7\x1F\x26\xC8\x81\xB6\xEA\xED\xC4\x65\x21\xE6\xFA\xE2\x68\x16\x56\x82\xB8\xA9\xA8\x9C\x3E\xC4\x77\x4A\xB6\x23\x0D\x2E\x45\xE0\x55\x21\x9D\xB2', #30
        b'\x2B\x56\x02\x84\xC3\xA6\x92\xAB\x37\x00\x8A\xD0\xB3\x79\xA7\xB8\xAF\x11\xCD\x2C\x30\xF9\x0B\xFC\x7F\xE8\x7A\x25\x0F\x27\x62\xED\xC3\xFB\xD7\x11\x64\x72\x42\xC3\x74\xED\x82\x64\xF6\xB3\x22\xBD', #31
        b'\x28\x19\x5C\xC8\xA7\xAD\x39\x43\x53\xCB\xE8\x08\x46\x4C\x4F\xC4\xD5\x8E\x3D\x7A\x76\x5F\x87\x26\xD8\x30\x52\xF6\x01\x85\xAA\x4F\xEF\xCB\x0D\x85\x22\x3B\xB4\xE7\x5A\x31\x30\x5E\x78\x7F\xAC\x28', #32
        b'\x72\x5D\x0E\xE2\x30\xF1\x95\x43\x90\x91\xD2\xC6\xBD\xDF\x34\xE0\xE3\xBE\x49\xC6\xC2\x75\x46\x01\x61\xBE\x30\x0B\xA4\xAD\x56\x6B\x02\xD7\x9D\x75\x51\xFA\x7C\xC1\x65\x43\x91\x0F\x5F\x1C\xDA\x58', #33
        b'\x40\x99\xAD\xC4\x44\x81\xB4\x3F\xFE\x13\x61\x92\x2F\xD9\xEB\x81\xA9\x89\xC0\x9E\x44\x1F\xCE\xAC\x44\x9B\x3A\x13\xD3\xCB\x90\x19\x45\xA9\xBE\x39\x6F\x20\x11\x34\xDC\x1A\xD0\x5A\x04\x66\x33\xFE', #34
        b'\x1A\x56\x3A\x6D\x52\x2F\x3E\x69\xBE\x58\x9E\x07\x9F\x47\x5A\x9E\x75\xA2\xA9\x63\x8E\x4C\x00\x38\xDA\x3B\x62\x02\x57\x7A\x03\x62\x21\x1D\x3F\x1E\x0D\x72\x7A\xF6\x5E\x1F\xFC\x52\x9A\xD9\x92\x33', #35
        b'\x47\xB6\x1E\x86\xC6\xD6\xD0\x1B\x43\x7D\x6F\x83\xAD\xAD\xC3\x18\xD5\xA3\x61\x02\x8D\xED\x73\x8C\xA0\x0D\x4C\x63\x04\x25\x16\x4B\x1A\x69\xAF\xA5\xAF\x4C\x9D\xD2\xF9\x9E\x1C\x67\xF9\x51\xB5\x82', #36
        b'\xA6\x6A\x77\x40\xB6\xBD\xEA\x79\xFE\xF7\xFF\x14\x96\xAF\x80\xA3\x05\xAF\xD4\x3E\xEA\xCD\x89\x8C\xB0\x0C\x78\xED\x31\xAD\x71\x34\x0E\xD3\x1A\x1A\xD7\x84\x66\x73\x74\xB9\x68\x44\x16\x14\x99\xBE', #37
        b'\x46\xFA\x8D\x6C\xCB\xF6\xD1\x2E\x31\xC2\xFC\x14\x7F\x30\x39\x56\x70\x7F\x44\x01\xDE\x5F\x06\x7F\x3A\xE5\xFE\xC7\xE3\x35\x94\xE9\x28\xE3\x9F\x8A\x63\x53\x17\x14\xB7\xB3\x29\xEA\x1E\x9F\xCA\xB2', #38
        b'\xEF\xD8\xF7\x55\x82\x5C\x78\x04\x1F\x5A\x93\x87\x0B\xD3\x0C\xD1\xEF\xBF\x89\x46\x71\xFF\x87\x16\x28\xED\x61\x7F\xF2\x2B\xDA\x58\x41\x12\x89\xCC\xAE\x5C\xB6\x2E\x95\xDD\x42\xF4\x18\x01\xF2\xF9', #39
        b'\xA8\x52\x5B\x86\x45\xFC\x59\xE1\x75\xE6\x2D\xC0\x0A\x5F\x7F\x0C\x09\xC5\x67\x85\x21\x04\x16\xAC\x50\xEF\x76\xE9\xB3\x0D\x76\x26\x2B\x3B\x2C\xDC\x19\xF5\xD6\x65\xA4\x12\x97\xCD\x11\xD8\xF4\xFF', #3A
        b'\xEA\xC9\x9A\x64\x9E\xEE\x50\x39\xA5\x93\xC9\x2F\x14\x3C\x00\x65\xB3\x14\x73\x52\x03\x07\x12\x06\xEA\x27\x61\xA0\xC7\x64\xA4\xEC\x02\xAA\x7F\xD4\x6C\xAC\x25\xB3\xC6\x8C\xC1\x82\xA9\x6D\x03\xBF', #3B
        b'\xB2\x87\x3F\x02\x4E\xC8\x3C\xA8\x97\x47\x0A\xB8\xFD\x88\x53\xEB\x18\xFE\x15\xC1\x59\xB3\x05\xBD\xB0\xAB\x08\xF6\x87\xEA\xEA\xFD\x51\x0A\x3F\xDE\x73\x60\x2E\x43\x03\xE1\xB8\x4D\xCC\xF0\xFC\xF0', #3C
        b'\xD8\x5B\xBB\xDC\x80\x33\xC0\xD8\x92\x23\xD9\xC3\x9C\xA9\xF3\x4F\x7D\x3B\xCB\x6D\x5B\x63\xC3\xFD\x1C\x30\xF9\x74\xDA\x0C\x0F\xB5\x8B\x24\xBC\x9E\xBE\xFB\x51\x43\xC5\x89\x54\x92\x5B\x7B\x84\xFC', #3D
        b'\x6A\xBD\x7C\x2E\x08\x44\xD7\xA7\xCC\xF2\xEA\x45\x6C\xDF\x53\x0D\xE8\x93\x8C\xF5\x2B\x39\x21\xB8\xBA\x02\x3C\xA2\xF2\x81\x65\x7C\xEC\x63\x5D\xA6\x75\xD1\xED\xAE\xB4\xAA\x52\xF2\x2E\xE1\xBE\x6C', #3E
        b'\x98\x1C\x3A\xC6\x77\xCB\x59\x04\x6A\x92\xB5\x4C\x84\x87\x7B\x49\x74\x5B\xA6\xBB\x40\xC5\x58\x15\xB7\xAF\x55\x0D\x22\xA3\x71\xED\xD5\xE8\xBD\x87\xC6\x5F\x53\x74\x67\x87\x4A\x37\xF0\xF5\x38\xF5', #3F
        b'\xC2\x3B\xBA\x2A\x9D\xEC\xC0\x21\x4E\x61\x0E\x93\x0B\x0E\x34\x50\x1A\x68\x1A\xA9\x14\x77\x57\x7E\x38\xA3\x20\x97\x14\xED\xC3\x76\x0F\xD1\x55\x63\xEE\xEB\x4A\xB6\x7D\x57\x66\x8A\x01\xD4\x21\x78', #40
        b'\x6A\xF8\x8C\xE1\x45\xA0\x98\xB5\x1A\xEB\x85\x8C\xD8\x8B\x8B\x46\xE8\xB7\x33\xAF\xB8\xE2\xD6\xE8\x31\x3F\xAA\x8C\x10\xA7\xEB\xFA\x12\x7D\x37\x5E\x77\x55\x7C\xEA\x96\xBD\xA2\xF7\x0B\x2F\x21\x55', #41
        b'\xEC\x89\x03\x97\x8F\xAF\xB6\x36\xC7\x21\x3C\x42\x5C\x07\x97\x63\x76\x03\x84\x03\x6A\xB6\xD1\x7C\xE0\xC6\x3A\x26\x38\x5F\x1F\x49\x29\x98\x77\xD6\x81\x1A\x6D\xF5\x87\x6F\x90\xFC\x53\x04\xB8\x8D', #42
        b'\xA6\xFA\xBB\xC2\xD6\xE0\xBA\x16\x9B\x70\xC9\x64\x00\x80\xE6\xBC\x29\xB2\xD5\x26\x55\x98\xB2\x7B\x4A\x96\x57\xC7\x26\xE4\x39\x7E\xA8\x01\xCC\xC6\x76\x66\x78\xD5\x80\x0E\xF7\xCC\x72\x61\x99\x98', #43
        b'\x23\x59\x31\xA8\xCF\x54\x90\xBF\xE7\x98\xF9\x8E\x0E\x8F\x87\x9F\xC6\xEE\xE2\x9C\x38\xF3\x0C\xA7\x92\x9A\x79\xF2\xD5\x3E\x00\x24\x88\xF2\xE1\x27\x49\x58\x7A\x45\x0B\x85\xB2\x8F\x38\x89\x19\x65', #44
        b'\x16\x5E\x03\x03\xE4\xA4\xD8\x27\x67\x99\x4F\x42\xD1\xE8\x43\x6A\xE6\xCC\x8B\xCF\x6E\x13\x0D\x1B\x50\x10\x17\x11\x70\x9D\xDE\xFC\x37\x3B\xDE\xC4\x0C\xD0\x53\x28\x40\xB2\x74\xA4\xAA\x51\x09\xF6', #45
        b'\xA9\xF8\x8B\xA0\x08\xFD\xF8\xC8\xEC\xC8\x97\xE3\x47\x6E\xE0\x5A\xBC\xE2\x90\xAB\x69\xD5\x7A\x74\xFA\x44\xDB\x18\x11\xE3\x11\x5D\x62\x67\xAE\xFD\x64\x48\x0C\x88\x26\x97\xD0\x4A\x2D\x3A\xEC\xEB', #46
        b'\xC0\x78\x2A\xF2\xAB\xCD\x33\x13\x02\xBA\x12\x90\xF2\xF9\x62\x73\x63\xC8\x2F\x1A\x56\xAD\xC2\xB9\x10\xF8\xE8\xC0\x3E\xFE\x51\xC4\xE3\xEB\x34\x86\x25\xCC\xAF\xFD\x93\xD6\x07\x96\x9C\xB8\xE7\xAE', #47
        b'\xCC\x6E\x17\x94\x43\xE5\x8F\xBC\xD2\x1C\x93\xC6\x55\xA7\xB8\xEE\x2B\x98\x34\xA3\x1F\x2B\x8B\xA4\xC8\x3B\x69\x51\x60\x25\xEC\xEE\x91\x76\xEB\x7B\x42\x7A\xAE\x94\x8C\xB6\x5B\x9E\x30\xB7\xA7\x6E', #48
        b'\xC1\xA3\x3A\x0A\xD6\xED\xD9\x89\x18\xB3\xC5\xD9\x58\x13\xB5\xF7\xB0\x24\xBD\x26\x3B\x35\x9A\x8B\xC8\xC1\x7C\x22\x16\xA9\x9B\x50\x71\xF9\xA1\x1D\x58\x23\x77\x29\x3A\xA6\x7C\x76\x18\x28\x42\x90', #49
        b'\x99\xB7\x46\x5E\x09\x20\x1C\x7B\x9A\xF8\x9F\xA0\x1C\xA4\xFA\x81\xFC\x2E\xC6\x3E\x76\x1A\xD1\x23\xE2\xA9\xA3\x95\x85\xB1\x7D\x14\x08\x39\x4D\xE5\x29\xF9\x4E\x81\x47\x94\x48\xE6\x97\x94\xFA\xA4', #4A
        b'\x23\xCA\x3D\x1C\x4C\xBD\xCA\xBB\xE3\x26\x54\x36\xCE\x1A\x37\xE4\x1B\xBF\x10\xF6\x9E\x8A\x4C\xC9\x05\xA6\x67\x08\x04\x8F\x5C\x4D\xE2\x59\xDC\xDD\x9C\x5B\xFE\xFE\x43\x9E\x65\xFA\xFD\x93\x6E\xFD', #4B
        b'\xA2\x4D\x73\xB6\x97\x8F\x71\x9C\x3F\x53\xF3\x43\xCC\xB0\xBB\x8E\xBE\x3C\x72\x76\x9E\xE0\x7C\x6A\xFA\xCB\x9E\x53\x9C\xF5\x58\xDD\x67\xB9\x1D\x4E\x30\xDE\x98\x6A\x1D\xB9\x13\xD1\x16\x98\x91\x3A', #4C
        b'\x98\xBD\x4E\x14\x0D\xC3\xC3\xC6\x14\x2B\x15\x92\xBF\x32\x63\xE8\xCD\xBE\xAC\x59\xED\x09\x5B\x0E\x90\x07\x63\xF0\xF6\x25\x89\x6A\xE2\x13\x55\x0F\x30\x32\x4E\x39\x8A\x13\xA4\x41\x7A\x80\x31\x95', #4D
        b'\x2A\xCD\x98\xED\x8C\x62\x60\x73\x1C\xAA\xA6\xB4\xC4\xCF\x32\x38\x04\xDC\xB4\x1E\xB6\x77\xEB\x5D\xF8\x8B\x58\x44\xA8\x10\x5B\x68\x98\x1D\x9E\x95\x1A\x06\x1A\x4D\xBC\x94\x71\x89\x4C\x87\x8E\xDB', #4E
        b'\x49\x59\xFE\xAD\x5D\x6C\x2D\xBD\x6A\xBD\x59\xE2\x8C\x50\x30\x49\x06\xD2\xC5\x49\x4C\xAF\x8B\x34\x70\xE4\x54\x13\x04\xA4\x29\x3C\x52\x0F\x34\x16\xCA\xF2\xF5\x03\xB2\x3D\x09\xD9\x26\x13\xDB\x85', #4F
        b'\x26\xB5\xA8\x15\xC3\x2D\x17\x91\x2C\x99\xE7\x55\x5B\xB0\x33\xC6\x09\xCE\x9D\x6A\x00\x02\x51\x4F\xD4\x85\x28\x2B\x2B\x8D\x79\x97\x9C\x5B\x79\x2F\x4A\x4A\x14\xC6\x85\x1D\x9D\x02\xDC\x0B\xB4\xE7', #50
        b'\x62\xFE\xB6\xCA\xCF\xB0\x60\xEC\x9D\x97\x7D\x69\xD5\xC6\x61\xEA\xBF\x08\xEF\xD8\x06\xD8\x15\x56\x25\xF1\xEE\xA4\x60\xEA\x57\x18\xA2\x53\x46\xB5\x1F\x5A\x96\x65\xD9\x2F\x9A\xDC\x35\x8C\xA2\x74', #51
        b'\x27\xE6\x3D\xFC\x63\xE8\xFF\xA6\xCD\xB9\xCC\xE2\xCE\x99\xFD\xA3\x97\x9D\x5B\x75\x49\x74\x83\x0D\x32\x98\xC8\x40\x7D\x66\x93\xBE\x62\x9D\x5F\xAD\xA3\x9B\x42\xB7\x26\x54\xD3\x12\x71\xCD\x84\xE1', #52
        b'\xAB\x1F\xA4\xDA\xF6\x6E\x58\x3C\xEE\xB6\xB7\xA2\x36\xD2\x47\x66\xA9\x07\x38\xCD\xFD\xF5\xC6\xB3\x28\xCB\xA9\xE5\x64\x8E\x2D\x4C\xFD\xE5\xBF\x6C\x0C\xFE\x0D\xA3\x9D\x00\xB8\x63\xD7\xD7\x84\x85', #53
        b'\x75\xFB\xBF\x09\x4E\xEA\x16\xAA\x48\x93\x1F\x02\x7C\xD7\x29\xF2\x5D\x36\x06\x79\x00\x9B\x2E\x7F\xDD\xFC\xD1\x48\xBD\x3D\xE2\x1A\x4D\xBF\xF5\x44\xB0\x94\xD0\xE1\x9C\x0E\x5C\x62\x94\x35\x2C\x22', #54
        b'\x28\x3A\x27\xFF\x96\x88\x53\xD2\xB0\x96\x0C\x6C\xEA\x0D\x03\xF2\x17\x2B\xBA\x07\xA4\x73\xDB\x38\x68\x8C\x87\xD2\x96\xE6\xF4\xBB\x5C\xB7\xE9\xBC\x5D\x68\xCF\x0F\x57\xA5\xD7\x1B\x0E\x47\xBF\xB4', #55
        b'\xDE\x01\x08\xAA\xC1\xE4\xFF\x2F\xD3\x46\xCF\xAB\xEA\xC6\x2B\x99\xB7\x2E\x20\x3F\x98\xB5\xF6\x08\x81\x85\x3D\x8C\xA5\x4B\x29\xBE\xA6\xAE\xD7\xC8\x9F\xAA\x16\x80\xD2\x09\x3B\x15\x5C\x39\xD7\xED', #56
        b'\x0B\xAE\xAC\x99\xD4\x97\x4B\x84\xC7\xF2\x58\xA6\x99\xC9\xB4\xDA\x6F\x62\x2C\x5E\x4A\xCC\xF5\xC1\x58\xAB\x39\x7D\x97\x81\xBE\xAA\xBF\x81\x1F\x67\xE1\x01\xFF\xE3\xAF\xBC\xC2\x88\x1C\x3C\x0E\xF3', #57
        b'\x26\xB2\x11\xFB\x51\x8D\x6C\x3E\x64\xBA\xDA\xD5\x1A\x10\x78\x4A\xE6\xBE\x4E\x06\xA5\x87\x18\x6C\xD4\x71\xF5\xC6\x13\x43\xCD\x5C\x83\x89\xBB\x0D\xD6\xAA\xED\x5D\xC8\x81\x12\x67\x89\x14\xA1\x7D', #58
        b'\x2B\x2D\x0B\xC3\xBB\x88\xD2\x7D\xC5\xA7\xD1\xFA\xFF\x51\x7A\xD2\x96\xF3\x90\x56\xA0\x9F\x82\xAD\xFB\x38\xA6\x1A\x6C\xED\x4D\x4E\x9D\x30\x8E\x4E\xA6\xF9\xB2\x64\x90\x97\xCE\x29\x4A\xEC\xC6\xB3', #59
        b'\x8F\xCA\x2B\x95\x06\x90\xB1\xA2\x29\x3E\xFC\xBF\x03\xD4\x22\xDF\x8C\x91\x25\xB3\xE7\x63\x53\xAB\x3D\x40\x20\x92\xA1\xA7\x01\x73\x9B\xAB\x97\x4C\xAB\x9B\xF6\x76\x5E\xA8\xFC\xC5\x5D\x8C\x58\x6E', #5A
        b'\x40\x8C\x92\xE8\xC2\xE1\xEC\x8C\x4A\xF4\xC9\x14\xB7\x1B\x43\x50\x51\x86\xAE\xE0\xCD\xFB\x10\x69\x23\x85\xEA\xFA\xB9\x65\x7C\x67\xF7\x08\xE4\xD3\xC8\x98\xCA\x80\x1E\xC8\xB9\xF8\x98\x84\x90\x7E', #5B
        b'\x46\xE8\x95\x8B\x6A\x2C\x18\x78\x21\x72\xFD\x41\x0F\x78\xA6\x47\x9D\x8E\x9D\xD8\x3A\x29\x90\x04\x39\x09\x13\xC3\x26\x5A\xD0\x25\xD2\x31\xF1\xE2\x30\x77\xCB\xF1\xE7\xEE\x3E\x57\x4E\x80\xD7\xF3', #5C
        b'\x5A\x85\x67\xA3\xD8\x5E\x40\xB2\x16\xEC\xF1\x61\x13\x3F\xCF\x73\x52\xDA\x5C\x6F\xBA\x3C\x0D\xD7\x56\xE5\x79\x83\xDE\xB3\x4B\xFB\x83\x25\x4F\xDC\xB7\x68\xD1\x53\x9A\x14\xF9\x5F\x35\xC6\xB8\x2D', #5D
        b'\x49\x8A\x29\xC6\xE1\x9D\x4A\xE6\x2E\xF4\xAA\xF4\x60\x27\xBA\x11\xBD\xBA\x7D\xAA\x84\xF3\x95\x05\x94\x0B\x2A\x04\xF6\xDC\x94\x4D\x4E\x7E\xD3\x56\x10\xFC\x0D\x53\xBA\xDD\x94\xC2\x90\x7E\x59\xE1', #5E
        b'\x14\xDF\x0F\xC4\x3F\x47\x5F\x80\x17\xE2\xAA\x8D\x26\x4B\xF8\x2F\x92\x62\x5B\xDF\xE5\x8B\x93\x4D\x83\x84\xF4\x15\xA4\xAC\xEA\x81\x8E\x9C\x5E\xAE\xC5\xD8\x64\x2B\x4D\x8E\xF5\x5F\x1C\x82\x66\x87', #5F
        b'\x4A\x23\x35\xC4\xF7\x71\x28\xD9\x54\x4E\x14\x76\xD2\x9A\xBA\x94\x65\x4E\xC8\x63\x21\x78\x50\x44\xB0\x4A\xD9\xB0\x2F\x80\x44\x5A\xB0\xE0\x1B\x64\x80\xC8\xD0\x20\x59\x6E\x32\x5E\x88\xA3\xCB\xBF', #60
        b'\x89\x69\x55\x15\x74\x48\xD0\x62\x0D\xB0\x8C\x4C\x0F\x23\x6D\x68\x3B\xA8\xFC\x5B\x3C\xD1\xC4\xA2\x04\xF5\x7C\x53\xE1\x44\x53\x5B\xB7\xD0\x4D\xCC\x7B\xE4\x68\x40\x4B\xBE\x99\x31\x92\x33\x46\x46', #61
        b'\x1D\x78\x37\xE6\xAB\x02\xCE\x27\x3E\xA3\x5B\xAE\xD4\x49\x3E\xA4\xD1\xCA\xFD\xB5\xDF\x94\xFA\xBE\x98\xB5\x80\xBB\x62\x17\x0C\x4F\xC3\xC5\x7A\x6C\xA9\x42\x1C\x43\x68\xD6\x5F\xC2\xC1\x20\x16\x34', #62
        b'\xFA\xEA\xBA\xBC\x48\x71\x75\x36\x45\x42\x51\xE8\xF6\x2F\x73\x15\xB3\x18\xE8\xA7\xFD\xCD\xC5\x23\x7C\x2E\x83\x20\x13\xC9\x13\x44\x4D\x9E\x5D\xAF\xD1\x69\x90\x52\x12\x26\x2E\x8C\x87\x05\x37\xA7', #63
        b'\x8A\x3E\x5D\x0B\xEF\x84\x02\xA2\xA3\x3B\xC5\xFA\xFA\x01\x99\x09\x63\xCB\xE8\xAC\xD0\x07\x62\xF5\xEA\x26\xA3\xF1\x81\x98\x41\x78\x6E\xEB\x78\xD1\xBB\x4A\xF6\xBB\x7E\xCF\x96\x71\x30\x0E\x84\x5F', #64
        b'\x08\x11\xB6\x7C\xCC\xF5\xD0\xFC\x9F\x8C\xAB\x3F\x34\x96\xBD\x6B\x57\xCB\x7D\x24\xF1\x35\x5C\x2D\x58\x21\x85\x94\x16\x5B\xDE\x80\xFA\xF3\x36\x8A\x65\x3A\x78\xF8\xC0\x4C\xD8\x01\x76\x26\x77\x62', #65
        b'\xE6\x41\x7C\xE7\x5A\xAA\x23\xB0\x34\xA7\xBF\xE3\xCB\xA6\x17\x61\x8C\x13\xE3\x96\xF8\xC9\xB6\xED\x5C\x90\x66\x46\x4B\x09\xED\x63\x76\xCB\x6A\x64\x2C\x5C\xE2\x83\x49\x8E\x08\x2A\x3E\xB4\x49\xC6', #66
        b'\x6F\x2A\xDE\xA6\x35\x7B\x5A\xA0\x54\xDA\x38\x2B\x15\x55\x7B\x69\x30\x2B\xD8\x19\x46\x23\x7A\xAE\x8F\x0C\xBB\x82\x11\x1E\xFE\xDC\x45\xDD\x2D\xAD\xCE\x20\xF2\xD3\x8A\x77\xA5\xE9\xE8\xA2\xD1\xD8', #67
        b'\xE1\xEC\x33\x27\x35\x86\x2A\x28\x92\xB6\x8B\x1A\x7E\x9C\x7C\x44\xF4\x56\x18\xDC\x99\xE9\x63\xE3\x7C\xAC\x98\x45\x02\xDD\x1A\x73\xC8\x65\x05\x98\xCD\x70\x84\x0D\x9A\x5D\xA5\x84\xA2\x6D\x4E\xFD', #68
        b'\x16\xB1\x9B\x01\x07\x40\xC1\x5C\xB4\x54\x4A\xC0\x10\x16\x43\x9A\x22\x1F\x74\x9C\x9E\x2F\x99\xA5\xA6\x3E\x8A\x27\x9A\x65\x57\x0F\xC7\x23\x16\x69\xAD\xD0\x72\xAD\xC5\xBC\x35\xBA\x74\x0B\xC8\x01', #69
        b'\x6C\x44\xE7\x5A\x4F\x37\x86\x94\xD2\x7A\xCE\x10\x8A\x57\x76\x47\x17\xC4\x87\xFA\xFA\x7E\x15\xD6\x6A\x36\x54\xD5\xC8\xE2\x9E\xDF\x0C\xE3\x5E\xED\xCC\x61\x1F\xFA\xD8\x8A\x8C\x03\xC0\x09\x50\x93', #6A
        b'\xCF\x10\x69\x48\xBC\x4B\x1F\x2C\x91\xC0\xDC\x99\x90\xB9\x97\x12\x19\x3B\x21\xE3\xE1\x09\xAB\x32\x33\x40\xDE\x06\x08\xDD\x16\x66\x8A\x5B\xB6\x77\xBF\x60\x28\x28\x40\x2C\x41\x0B\x11\x97\xB7\x71', #6B
        b'\xEB\x08\x0F\xF4\x9C\xA5\x54\x3E\xB4\xB9\x42\x95\x42\xD6\xCA\x27\x59\x99\xD4\x5D\xC1\x53\x32\x05\xF7\xEA\x9E\x39\x8A\x1B\xEF\x3E\xBE\x88\x17\x77\x54\x76\xDE\xC6\x17\x06\x4D\x77\x90\xC8\x41\x00', #6C
        b'\xF3\x32\x8E\x91\x50\xA7\xF8\xD6\x52\xE3\xE6\x1B\x04\xAC\xFD\xF8\x51\xD8\x20\x10\xF3\xCE\xB0\x15\x59\xD6\x73\x33\x66\x76\xD5\xD8\x4C\xB3\xBC\xEF\x1D\x91\xC3\x42\x0C\x58\x9A\xB5\x80\x33\xBE\x49', #6D
        b'\x54\xB8\xE7\x0E\xDC\xE0\x38\x55\x7B\xB5\x90\xE9\x96\x87\xFD\x57\x6C\xFF\x08\x68\x8D\x2B\x1F\xDD\xFD\x0F\x6D\x06\x8B\xFE\x99\x4F\xEB\x9B\xCE\x30\x24\x89\xAE\x44\x66\xB2\x1F\x20\x06\x61\xE3\xE4', #6E
        b'\x2F\x5E\x00\x60\x18\x96\x69\xAD\x47\x3A\xF1\xD0\x3C\x00\xCA\xE4\x02\x78\x29\x92\x68\xD1\xF3\xB4\x88\x87\x14\xBC\x3A\x7E\xC9\xD2\x9F\xF9\xC7\xF0\x71\xEB\xD2\xD9\x87\x5A\x5D\xC2\x5D\xFF\xDB\x10', #6F
        b'\xE2\xA9\x7A\x3E\x46\x83\x99\xD8\x3B\xF7\xEA\xCA\x32\xC8\x0D\xA1\x13\xDC\xAC\x8E\xB6\xC2\x23\x1D\x22\x7E\xC9\x0E\x11\x02\xEE\x97\xB2\x34\x48\x32\xF0\x38\x14\x34\x86\x13\x88\x83\x03\xB1\x90\xEB', #70
        b'\x3A\x3D\x3B\x6C\xE0\x26\xBF\xFE\x18\xD4\x95\x3B\x9A\x68\xED\x59\x24\xBB\x7B\x57\x4A\xB7\x77\xA0\xE0\xCB\x7D\xD6\x49\x83\xDC\xB1\xCF\x76\x8C\x43\x98\x69\xAC\x97\x80\x62\xBC\x7A\x90\x0E\x60\x33', #71
        b'\x39\xD4\xC3\xB7\x8A\x7A\x33\xC7\x43\xD7\x2E\xF2\x2A\xB0\xB4\xEB\x54\xAE\x81\x84\xDD\xA5\x03\x94\x0C\x2A\x7D\xA0\x83\xC3\x85\x36\x9D\xBC\x6F\x92\x1D\x4A\xD8\x22\x2C\xBB\x61\xFE\x18\x2E\xAA\x42', #72
        b'\xD8\xCE\x9A\x80\x6C\x0B\xD2\x4D\xF6\x9D\x65\xA6\x58\x45\x72\x7C\xC3\xFF\x81\xCC\x76\xF2\xB0\x48\x76\xB1\xFD\xC3\xCA\x67\xCE\x58\xCE\xD0\x97\x0A\xFB\xCB\xE7\x8A\x57\x50\x29\x41\xB7\x26\xF5\xF3', #73
        b'\xE0\x06\xAE\xC1\x7F\xCE\xFC\xF9\x05\xCA\xA1\x62\x9E\x00\x35\x91\xB7\x05\x0C\xC9\x9F\x58\x53\x12\x66\x92\x60\x40\x1E\x15\x94\x90\x84\x42\xD2\x5A\xA7\x57\xCC\x5A\x22\x86\x55\xCD\x40\x38\x77\x0C', #74
        b'\x93\xEE\x8D\x67\xD3\xF1\xF3\xA1\xBE\xA4\x6D\x48\xDB\xF8\xD7\xF4\x3C\x91\xF0\x2B\x86\x46\x45\x3C\x6C\x3D\x7C\x1F\x04\x18\x8A\x58\xEF\xA9\x72\x87\xF8\x9C\xEF\x84\xCB\x40\x36\x4E\x10\x8B\xFF\x4B', #75
        b'\xC6\xDC\xE3\x73\x0D\x4F\xF8\x25\x02\xAF\x54\xF8\x7D\x97\x27\x90\x7D\x69\xD2\x0F\x6F\x4F\x78\x8F\x90\xC2\x55\xC6\x4C\x16\x6E\x8F\xA3\x52\x9F\xBF\x4B\xF9\xC9\xA2\x3E\xCE\xC4\x11\x36\x69\x4F\x6B', #76
        b'\x3D\xE1\x0A\x5E\xC6\xCA\x7B\x3F\x7E\x19\x60\x81\xD0\x85\xAC\xAA\xDF\x5F\x0D\xE3\x70\x5D\x60\xF7\x39\x3E\x7C\x83\xDC\xC5\x70\x75\xA5\xF3\x3B\xC2\xDC\xB9\x8F\x97\x0A\xEB\x7F\x05\x0D\x12\x04\xC0', #77
        b'\x6F\x3B\x3B\x3D\x11\xA8\xBC\x05\xB5\x22\x69\xAB\x2B\x95\xB8\xDC\x12\xED\xE2\x4E\xB1\x38\x5F\x13\x20\x2B\xBA\x6B\x58\x36\xB5\xE1\xEE\x36\x36\xC5\x92\x5A\xCC\x49\x42\x22\x4C\xF6\xEE\xB5\x09\xBF', #78
        b'\x5F\x0C\xC3\xBB\xC4\xBE\x9A\x92\x58\x43\x13\xFC\xCC\x54\xDD\x2E\xC1\x1F\xE9\x0F\x00\x39\x40\x36\x33\x71\x66\x7C\x72\xFC\x97\x23\x96\x11\x99\x0B\x62\xAC\x8D\x9F\x4C\xFC\xB9\xEB\x3C\x31\x7F\xAD', #79
        b'\xCA\x8E\x52\x0A\x89\x4A\x3F\xBA\xBD\x9E\xD1\xB8\x00\x98\xCC\x40\xBD\xF2\x45\x07\xDF\xF3\x75\x7C\x47\xAE\xC5\x72\xE6\x8D\x35\xEC\xF3\xD4\x52\x3D\x27\xB3\x73\xE4\x1A\xB1\x1E\x16\x97\x3A\x05\xAB', #7A
        b'\xFF\xC2\x93\xA6\xC2\x6B\x81\x7D\x2C\x9E\x9D\x13\x49\x59\xD8\x28\x7F\xA5\x21\x64\x08\x19\x9B\xBF\xA6\xF0\x02\xDE\x0D\xCC\xD8\x61\xBE\x8F\x9D\xC5\x7F\x2C\xF3\x5D\x13\x52\xE2\xDF\x86\xA4\x76\x47', #7B
        b'\x84\xB5\x5B\xE1\x01\x70\x8E\x74\x3A\xDE\xC5\x37\x21\x20\x9F\x3E\xB1\x8F\x9A\x1E\x68\xDF\xAD\xBD\x09\xA0\x50\x81\x97\x74\xCF\x2D\xE4\xAB\x29\x5D\x38\x0A\x87\x62\xA3\x60\x5B\x0C\x68\x9C\x23\x9F', #7C
        b'\xDD\xC7\x03\x1F\xBF\xDF\xFE\x8F\x0B\x17\x5D\xE6\x5B\x83\x2F\x0A\x31\x16\x2A\xBC\x65\x71\x96\x85\x51\x21\x5E\x53\x4B\xBC\x36\xB1\x9F\x2F\x7D\x3B\x5D\x01\xAE\x44\xCF\x43\xA2\x42\x6E\x83\xB6\x1B', #7D
        b'\x7E\x32\xDB\x67\x2B\x16\xF0\x4A\xCE\x6F\x45\xDE\x0E\x6A\xB7\x88\x25\x71\x85\x48\xB8\xE7\x0B\x41\xD7\x36\x8B\xCF\x39\xA0\xFA\xC4\x95\x68\x63\xEC\x49\x88\x0C\x47\x72\x0E\x33\x57\x96\x34\x16\x74', #7E
        b'\x06\x70\x7A\x8E\x33\xD9\xD6\xC6\xB6\x84\xBF\xE2\x6C\xD5\x76\xC6\x44\xF4\x7E\x5E\xCD\x5F\xC4\x6C\xAF\x1B\x23\xA8\x56\xD8\x44\xB7\x98\xA6\x27\x91\x6A\xC5\x65\x7E\x04\x0C\x39\x64\xA1\x12\x7E\x19', #7F
        b'\xA5\xDA\xEC\x31\x34\xC0\xA3\x9B\x0C\xA0\x41\x60\xBD\x5A\xDB\x1F\xB5\x0E\xC5\xA9\xF2\x9E\x1A\xCB\xBE\x2F\xA1\x12\x6A\xF7\xBF\xAF\xBE\xFC\x0A\xC4\xC9\xC5\xA4\xB3\x99\x47\x39\xC7\x1F\xB1\xEB\x29', #80
        b'\x6F\xEC\x2D\x34\x3E\x83\xA7\x63\x5B\xDB\xA5\x71\x57\x57\xF5\x0C\xD6\xF6\x28\x2E\xE4\x6A\x11\xB3\xA8\xB5\x01\xF5\x92\x2A\x55\x24\xA7\x82\xA2\x10\x06\xB6\x05\xCA\xA1\x0B\xD2\xE8\x96\x97\x5C\x81', #81
        b'\xB8\xAA\xE0\x53\x22\x26\xD0\xED\x89\x18\x31\xC0\x47\x0E\x84\xB7\x74\xC8\x24\xD6\x48\xE8\xFF\x28\xB5\xE4\xE0\x2E\xAD\x39\x06\xEB\x5A\xBB\x08\x6A\xDA\x60\xA7\x13\xA8\x0C\x57\x66\x6A\x9E\x29\xF1', #82
        b'\x52\x9E\x3E\x52\xB1\xE7\x23\x0A\x0C\x14\x88\x61\xC9\xF0\x8E\x26\x0C\xFC\x8A\x13\x1B\xAD\x80\x3D\x8C\x09\xF3\x24\x90\x2F\xAA\x9F\x02\x31\xEE\x49\x87\x99\x98\x48\x3B\x06\x88\x49\x2E\x2B\x54\x57', #83
        b'\xEF\xA6\xEA\xC5\x03\x68\x14\xCD\x02\x77\x3C\x1F\x8D\xAA\x5D\xF5\x0E\x4E\xED\xBD\x07\x02\xDE\x31\xBA\x7F\xD7\x57\xD0\xD7\x40\xEF\xA8\x80\x5F\x0C\x74\x00\x5F\x8B\x14\x48\x46\x7B\xFF\x3E\x1E\xF8', #84
        b'\x2A\x07\xB7\x66\x01\x6A\xC7\x0D\x64\x21\x5C\x35\x36\x42\x19\xE9\xCD\x6F\x7E\xFE\x35\xFC\xF6\xF1\xF0\x5C\xC0\x60\x84\xC2\x92\x67\xAB\x3B\xF2\xF3\x25\x79\xA4\x44\xAC\x75\xF4\x2D\x9A\x25\xB9\xC9', #85
        b'\xEF\x3A\x14\xB5\xED\xDB\x84\x64\x23\x14\xE0\x80\x2D\x2D\xD0\xE9\x14\xDE\xAE\xA9\xF9\x28\x76\x2A\x57\x63\xEB\xB4\x80\xE1\x5A\x02\x25\xF7\xCA\x14\xE8\xCD\xF5\xE6\x8E\x59\x45\x10\xDC\x61\xE6\xBC', #86
        b'\xE6\x2C\x38\xDC\xFD\x21\x00\x0B\x7B\xB3\x2A\xE9\x17\xEE\x3D\xA7\xE4\x9F\x15\xE2\x4C\xC9\xB6\x56\x56\xE2\x82\x59\xDC\xA3\x61\xD8\xB4\x3B\x80\x08\xA9\x28\x5F\x48\x0D\xC6\xB4\xAF\x7E\x4A\xE6\x1B', #87
        b'\x70\x3C\x64\x24\x11\x42\xDC\xAE\x73\x2D\x33\x34\x2C\x45\x06\x3A\x37\x87\x7E\xA1\x62\x45\x67\xCB\x28\x71\xD5\x34\x61\x4D\xD1\x14\xE7\x48\x09\x2A\x1D\x94\xF5\xD1\x45\x24\x05\x6F\x0C\x6D\x1C\xB7', #88
        b'\xE3\x25\xB1\x82\x3A\x59\x5D\xF9\x74\x2D\x0D\xD5\xC9\x6F\x39\x7C\x44\x36\x1C\x95\x40\xA9\xF4\x51\x02\x38\x2F\x9B\xF6\x33\x1F\xB9\x8E\xCB\xAF\xBB\xE9\x1A\x04\x67\x52\x8E\xBF\x38\x11\xF9\x04\xA8', #89
        b'\xFD\x2B\xC6\x53\x46\x31\xFB\x0D\x27\xA5\xF0\x36\xFE\xEB\x9A\x6C\xD0\xF8\x76\xD7\x91\x1D\x07\x75\x12\xEF\xB3\xA2\x9C\x6E\x0B\x72\xDC\x4B\xCA\x3D\x5E\x87\x1D\xA1\x02\x8F\xB6\xE6\xE6\x08\xF4\x6F', #8A
        b'\xEF\x17\xEC\xC8\x93\x0A\x7B\x4A\x9D\x97\xB3\x46\x72\xFB\x27\x3D\xC6\xAE\x83\x5F\x35\xA2\x5D\x8F\x6C\x27\x46\x95\x30\xC2\x1F\x5B\x2F\xBC\x16\xA2\x61\x50\xE7\x95\x02\xAD\x93\xAA\xE0\xB5\xC7\x1A', #8B
        b'\x6D\x24\xBE\x43\xCF\x07\xDD\x56\x63\x68\x1D\x62\xA3\x8D\x2A\x2F\x98\x72\xC9\xB4\x11\x72\x4A\xA0\xB8\x82\xB4\x85\x7C\x19\x69\x0A\x87\xB1\xBA\x8D\x28\x04\xC6\xF4\xD7\xB1\x99\xCC\x36\xF4\x0B\x49', #8C
        b'\xEE\xFB\x8D\x85\x73\xFD\x9E\x0F\x93\x34\x03\x19\x9B\x91\x56\x0A\xFF\x0D\xB4\x16\x65\xD5\x24\x8C\x32\x2E\xE1\x05\xEA\x98\x41\x96\xDB\x8C\xE0\xF8\x38\x90\xD8\x9B\x3A\x32\xF8\x98\x3C\x90\x1F\x80', #8D
        b'\x08\x2C\xDA\xF9\x3F\x21\x5B\xAC\x67\xC1\x18\xA1\xB9\x27\x4F\xAC\xAF\x74\x50\x1C\xFB\x93\x19\x8A\x53\x52\x5C\xAB\xA0\xE8\x12\xD3\xC9\xAF\x3A\x00\x5E\xFE\x8A\x6E\xF2\x42\xDC\xB6\x0D\xA7\xB2\xFE', #8E
        b'\xD3\x88\x7F\xBF\xBB\x73\x14\xDF\xDD\xDC\xCC\xF0\xF7\x20\xC3\x42\xB2\xC4\x33\x1C\x33\xC8\xC4\x15\x16\x66\x01\x07\x67\xF4\x78\x5B\x84\x55\xB7\xC1\xFD\x5D\xE4\x87\xA8\x21\xC5\xEA\x18\x18\x75\xF2', #8F
        b'\x7E\x28\x98\x31\x41\x85\x62\xF0\x2A\xD1\x2E\x30\x42\xB1\x85\xC3\x7C\x20\xD0\xD7\x35\xA6\xAE\x96\xA6\x8B\xEF\x98\xE2\x2C\xBD\x41\xA1\x41\x1D\x22\xF8\xD9\x32\x43\xD8\x13\xFB\x40\x4F\x3D\x2F\x38', #90
        b'\xE1\x3F\xC0\xA7\x6F\x66\x42\x94\x7E\x21\xC9\xD9\xF7\xFD\xDD\xCB\x16\x1E\x68\xB3\x66\xD6\xB1\xF8\x55\xBF\x95\x7E\xB5\x74\x38\x74\xB2\x32\x13\xEF\x83\x64\xD7\x66\x52\x9B\xB9\x8A\xF9\x66\x43\xD4', #91
        b'\x03\x6D\x7A\xDD\xAA\xDB\x5C\x33\x05\x25\x83\x5F\x80\x2D\x03\x2E\x7D\xF7\xD0\xD8\xD7\xA2\xBE\xF2\x84\x92\x76\x44\xB2\x76\x96\xB7\x21\x5E\x21\xE4\xD1\xF9\xB5\xB9\x77\x74\x36\x69\xC4\x0E\xB7\xFD', #92
        b'\xA9\xB3\x53\x4B\xE8\x89\x77\x84\x5B\xFD\x42\x83\x54\x1A\x50\x90\x97\xAF\xFC\xCD\x12\x1C\x97\x78\xC1\x46\xC4\xC9\x63\x79\x89\xC7\x08\x20\xE7\x2F\xCB\xDA\x59\xC7\x55\x26\xE2\xF4\xA0\xAE\x4F\x4F', #93
        b'\xA4\x73\x9E\x20\xFD\x72\xBD\xC2\x6D\x6E\xE5\xA5\xC1\xA5\x4C\xA6\x70\xA9\x7A\x6F\xCB\x88\x4E\x5C\x2B\x61\x08\x33\x9E\x97\x9C\x48\x93\xA6\x37\x30\xD6\xBB\x23\xA7\x5B\x1D\xCE\xAB\x00\x04\x5E\xE5', #94
        b'\x42\x7C\x14\xE4\xF8\x8C\x8B\xDB\x1D\x86\x30\x86\x8E\x03\x9B\xC2\x33\xDB\x40\xA2\x51\x50\x2D\x1B\xE0\x43\xC9\xCC\xB4\x5D\x2B\x3D\x29\x2B\x67\xB6\xEE\x07\x7B\x2D\x1C\x3A\x2F\xBD\xE2\x4C\x74\x2A', #95
        b'\x3D\xED\x69\xF3\x70\x16\xD8\x6A\x9A\x94\x7B\x13\xAC\x66\xD7\xC3\x82\x2D\x86\x45\xDF\x4C\xB3\x9C\x2B\xA2\x0F\x98\xF1\x9E\x10\xDA\x67\x03\x13\x8D\x42\x2A\xC4\xC4\x8D\x34\xD6\x13\x8F\xA0\x4A\x1D', #96
        b'\x28\xE5\x9C\x8B\x25\x7D\x11\x2C\x87\x47\x06\x8C\xC5\x49\x9F\xCF\xD6\xC1\x6E\xB7\x80\xF9\x19\x1A\xB4\x16\x15\x16\x33\xF7\xAF\x08\xA2\x30\xE0\x0D\x6B\xA1\xA1\xC3\xFD\x06\x6F\xB9\x96\x5B\x83\xD2', #97
        b'\x70\xF4\xBC\x1B\x7F\x8F\xFC\x37\x38\xDC\x03\x31\xE5\x6B\x0F\xDC\xA9\xAB\x72\x90\xAD\x2B\x0B\xBD\xB3\x07\x97\x3C\x3D\x07\x83\xC6\xBD\xC4\x55\xF6\xCD\xCA\x11\x1F\x23\xF0\xE0\x83\x17\xB8\xF0\xDC', #98
        b'\x0A\xEE\xC2\x4E\x92\x85\xC5\x0F\x3B\xCD\xA4\x78\x33\xB6\x1A\xCE\x83\x99\x86\xF9\x59\xEE\x07\x23\xC9\x59\x03\x4A\x8D\x7F\x5E\xB9\xD4\xAD\x7E\x05\xB0\x5C\x4F\xB5\x6C\x37\xA3\xD3\x9F\x7A\x0E\xC4', #99
        b'\x02\x27\xB7\x23\x0F\xBF\x2D\x07\x28\xD7\xD2\xAD\x63\x2B\xED\x47\x07\xBD\x8F\x8B\x50\x12\xEF\xD0\x48\xA0\xD4\x3A\xE0\x40\x34\x42\x9B\x89\x39\x20\x7F\x14\x49\xA1\x35\x1E\xAD\x01\xB9\xFD\xF2\x19', #9A
        b'\xA7\x11\x9D\x2E\x31\x1C\xEF\x25\x1E\x53\x2C\xD0\xC4\xED\x04\x79\x22\x72\xF8\x78\xD8\xD3\x0A\x0B\x76\x9C\x41\x2C\xED\x9C\x4C\x42\x26\x2F\xFB\xFA\x65\xCB\xDD\xF5\xDB\x73\xD8\x67\x21\xEA\x36\x8E', #9B
        b'\x4B\xDB\xE9\x0B\x3F\xBA\xDC\xB2\x13\x24\xEC\x3A\x8D\x6F\xEA\x57\x6D\x9E\xFB\xE5\x30\x85\x0D\x00\x40\x1A\x88\xAF\xF8\xA4\xC8\xF4\x65\x5C\xB7\x6B\x8A\x2E\x27\x1C\x35\x50\x5B\x6D\xBD\xE1\x6F\x43', #9C
        b'\x6E\x15\xE5\x7E\x23\xF5\x70\x37\x49\x62\x73\x73\x62\xC1\xFA\x26\xC9\x62\x37\x2D\x18\x29\xB8\x0B\xA1\xFE\x68\x32\xEA\x4D\x62\x11\x67\x26\xE3\x07\xF9\x6E\x77\x63\x04\xC7\x61\x08\x16\x77\x50\x5B', #9D
        b'\x42\xE2\xFF\x3A\x8A\x6F\xC1\x64\xFB\x85\xB2\xBC\x9D\x28\xB2\x68\xC5\x59\xCF\xF0\x24\x53\x3A\x28\x2E\xC8\x3F\x39\x11\xDA\xB3\xCE\xAE\x0F\xC7\x4A\x9D\x73\x6A\x27\xDB\x9C\xDD\x04\x8B\xAB\x4C\xCF', #9E
        b'\xD7\x9C\x52\x22\x1D\x20\xE7\x65\x49\x9E\xDD\x73\x90\x3C\xE7\x04\x9B\x01\x6D\x98\x7D\xF4\x83\x49\xFC\xFA\xB4\x4A\xD1\x2F\xC5\xC1\x81\x12\x93\xF3\xB8\x00\xFD\xF9\x51\x1D\xC6\x19\xCA\x53\xCE\xBE', #9F
        b'\xA0\x59\xEE\x78\xB8\x26\xED\xDF\x46\x73\xAF\x29\x4D\x17\xC8\x5A\x5E\x52\x7D\x4E\x4D\xF2\x82\xB5\xDB\x5B\x9A\x26\x93\xF9\x5C\xE3\x65\x51\xD3\x04\xFB\x54\xF2\x96\xAB\x3E\xB7\x0D\x65\x91\x2F\xCC', #A0
        b'\x7D\x0C\x4F\x67\xB6\xC7\x81\x35\x39\x0C\xAE\xA7\xDE\x30\x4D\x37\x49\xE1\x9F\xAB\xC8\xD4\x94\xFE\x1A\x9E\x1B\x64\x37\xA0\x45\x16\x88\x6C\xC4\xBD\xAB\x6A\xF3\x5A\x05\x29\x21\x73\x44\xF5\x02\xFE', #A1
        b'\x3C\xED\xF3\x41\x41\xB5\x2C\xEE\x81\x33\xBA\x92\x47\x53\x57\x3F\xCB\x32\xBE\x22\xBC\x66\x02\x5A\x0C\x48\x01\x83\xDE\x40\x3C\xB3\xBF\x5B\x84\xB4\x27\xDF\xCF\x31\x72\x51\x42\x8D\xB0\x23\x21\x56', #A2
        b'\x86\xFC\xE8\x31\xC5\x8E\x25\xCB\x5C\xC4\x3F\xFE\x45\xCB\xFC\x75\x33\x87\x7C\xC0\x42\xF1\x99\xBE\x12\x12\xFA\x7F\x0C\xC2\x2E\x1C\x44\x8E\xAB\x4B\x7D\x1F\x98\x23\xA7\xB1\x36\x3A\x9F\xA7\x59\x9E', #A3
        b'\x2D\x8C\x2F\xED\xA0\xE5\x10\x6D\x19\x2E\x36\x68\x38\xBB\xEB\x3F\x36\x22\x6A\xA6\x0A\xCE\xA0\xAF\xE7\xE1\x28\x5D\xC1\xF3\x92\x6A\x90\x03\x71\xFA\x18\x83\xD9\xEC\xBA\xC3\x3B\x1A\xF3\x60\xEB\x66', #A4
        b'\xD4\xA2\xA1\x16\x12\xBD\xE0\xE3\x82\xAB\x0D\xA6\x14\xCB\x4C\xB8\x18\x9A\x4D\x50\xAC\x01\xF4\xC6\xE3\x6A\x5D\xA1\xD9\xF6\xA6\x47\xE4\x31\x20\xD6\xB1\x6B\x11\xB6\x7D\x39\x5F\x42\x36\xE7\x53\x78', #A5
        b'\xC0\xC1\x55\xCD\x47\xF3\x87\x7F\x4B\x03\xBF\xE5\xC3\x34\xCA\x71\x77\x71\x0F\x1F\x4B\x84\x4F\xF7\x34\x43\xBB\xAB\x72\x0E\x8D\xC5\xF0\x3F\x88\x68\xC5\x86\x34\x06\x0F\xD6\x05\x11\xC8\x72\xEB\x50', #A6
        b'\x8C\x25\x3D\xAA\xB5\x28\x63\x06\x9A\xA4\x38\xF5\x4A\x61\x96\xAC\x18\x1D\x08\xC7\x23\xA2\x2C\x5E\x63\x3C\x49\xC8\x8E\x39\x10\xA1\xC9\xF5\x4A\x67\x99\x26\x75\xB0\x1F\xDD\x98\xAC\xBD\x38\xD9\x76', #A7
        b'\xA1\x08\x93\xDA\x75\x75\xA9\xF7\x8F\x5F\x4A\x02\x5A\xB2\xA0\x18\xD8\x05\x38\xF0\x33\x6B\xFF\xC0\x0F\x97\x51\xD3\x38\x89\x62\x6F\x30\x38\x3E\xB9\x25\xBF\x91\x1A\xE6\x14\x9F\x68\xCE\x19\xCC\x60', #A8
        b'\xB9\x08\x1D\xBA\xC6\xBE\x05\x98\x78\x5D\xD9\xBC\x69\xC7\x14\x92\x8B\x03\x5A\x0C\xA5\x6E\x17\x2B\x89\x46\x78\x35\x00\x72\x48\x88\xAF\x1E\x57\xC9\x58\x65\x05\x69\xE1\xDE\x4E\x94\x4F\xF2\x22\x61', #A9
        b'\xEA\x5E\xDC\x4D\x27\x18\xC0\xD2\xCB\x1C\x5D\x4D\xA1\x5A\x8A\xE4\xC6\x27\x23\x82\xF8\x16\x30\x15\x94\xA9\x34\xE5\x05\x7B\x54\xCE\x65\x8E\x48\x1A\x3D\x68\xD1\x0D\xE8\xF2\x49\x29\xE5\x0A\x46\xA0', #AA
        b'\x7D\xF1\x46\x28\x1A\xF4\x82\xCD\x01\x4B\x68\xE7\x26\x40\x7B\x06\x6C\xE5\x64\x93\x8C\x70\xDD\xBC\x36\xDA\xD2\xDE\x72\xA5\xDA\xA2\x6D\x57\x3B\xF6\x9C\x0B\x29\x80\x68\x4D\xAB\x14\xB4\xAA\x03\x29', #AB
        b'\x9C\x69\xDC\x06\x4E\x73\x8B\x5F\x83\xCC\x16\xBD\x5A\x1C\x36\xF5\xA9\x9B\x36\x5E\x6E\x14\x1B\x12\x27\x48\xFA\x5A\xD0\xFA\xCC\xE8\x26\xD0\x73\xA0\x47\xD9\x9C\x49\xB0\x05\xB1\x82\x50\x5B\x0C\x0C', #AC
        b'\x15\xB6\xA2\xA2\x0E\xD0\xFD\x1C\x93\x33\xAF\x72\x9B\xD6\x5A\x25\x22\xCC\x33\x32\x93\xBD\x2C\x1B\xD7\x24\xD9\x49\xB1\x5E\x8B\xE1\x69\xD0\xDB\x05\x12\xB9\x71\x17\x85\xAC\xA8\x98\x0D\xD7\x65\x3C', #AD
        b'\x23\x0E\xC6\x29\xD7\x7B\xB3\xF2\x43\x11\x5B\x99\x1D\x29\x7C\xB2\xA2\xF9\x55\x79\x2C\x53\xC7\x6F\x48\xA7\x67\x28\xEB\xE2\x5B\xA7\x7C\xE6\x62\xA4\x05\x38\x44\x00\xDD\xC0\x6B\x7E\x6B\xF4\x9D\x66', #AE
        b'\x20\xDD\xB9\xBD\x76\x44\x41\x0B\x05\x63\x91\xB1\xFA\x2E\x8C\x06\xCA\x4E\xDE\x51\xCF\x16\x7C\x00\x46\x60\x2B\x55\x05\x36\xF8\x70\x50\x40\x67\x25\x97\xC2\x1F\xF4\x0A\xF8\xEC\x6E\x8A\xFB\x84\x4B', #AF
        b'\x00\x23\xC5\x74\x92\x51\xB8\x83\x33\x5A\x4F\x86\xD6\x6B\x7E\x00\xAE\x35\x3D\xED\x3E\xFA\xCE\x8F\x3F\xC8\x05\x26\xD6\x7B\x35\xDE\x0D\x90\x78\xFB\xDA\x80\xBC\x53\x46\x79\x00\xDF\xF3\xFE\x4C\x14', #B0
        b'\x0F\x9C\xB2\xBE\x6A\x44\x81\x13\xE3\x8D\x54\x1B\x6A\x9A\x58\x29\x67\x39\x53\xDA\xF3\x54\xFC\x0E\x3C\x81\x8A\x27\x7F\x85\x69\xE9\x8D\x16\xEA\x77\xDB\x12\x2A\x3B\xE4\x0A\x86\x03\x18\xB6\xEA\x84', #B1
        b'\x78\xCE\x11\xF4\x2D\x7D\x5E\x50\x84\xF7\x6D\xFF\x19\x9C\x99\x8D\x99\x9B\x57\x8E\x3A\xE9\x35\xCB\xD9\xFD\x09\x2C\x1B\xE6\x32\x12\x31\xF3\x3C\x63\xAC\xD3\x16\xD8\x5A\xA0\x80\x30\xB8\xD6\x5C\x0C', #B2
        b'\x00\x98\xDB\xE1\x9C\xA8\x4F\xE9\xE2\x42\x66\x17\xD1\x14\x21\x37\x63\xC3\xC4\x16\x6A\x78\xE2\x1B\x74\xB1\x45\x35\x3E\x03\xB0\xE4\xF4\x3C\x08\x24\xEA\xE5\x08\xC4\x58\xC1\xE6\x62\x25\x28\x60\x2A', #B3
        b'\x9E\x27\xEB\xE6\xD1\x42\x6A\x6F\x2A\x6A\x60\x0A\x6B\x5F\xA3\x42\x8F\xF7\xE2\x30\x6B\xA9\x03\x70\xDF\x83\xD9\x1A\x68\x3E\xDD\xDD\x29\x57\x24\x42\xF0\x22\x53\x88\xE9\xCC\x0F\x1B\x64\x37\x32\x0A', #B4
        b'\x05\x4D\xF3\x80\xE8\x96\x06\x4E\xFA\xB8\x1A\x4A\xA3\xAD\x88\xA4\xF8\x74\x26\x48\x6C\xCA\x15\x6F\xBB\x1B\x3C\x82\x37\x47\x29\x60\x7E\xC0\xB8\x7C\xF7\x3F\x96\x0A\x5C\x57\xD7\xE6\x47\x0F\x78\x08', #B5
        b'\x57\x58\xE1\x03\xAC\x61\x4A\x1A\x76\x6A\xEE\x86\xF8\x13\x58\xDF\x20\x3F\xBA\x51\xDC\x74\x39\x6A\x78\xC9\x3D\xF9\x69\xC5\x72\x1F\xE6\x9E\x32\xE2\x30\x19\x65\x97\xE2\x87\xC6\xCE\xCD\x8A\xB9\x5B', #B6
        b'\x2A\x06\xA7\xC1\x0C\x0D\xCC\x97\x99\xD5\x29\x82\x68\xA6\x74\x5F\xF2\xD8\x18\xBB\x77\x48\x58\xB3\xD5\x2A\x82\x0D\x4F\x64\xD8\x86\x2F\x80\x8E\xF8\x7A\x26\x39\x81\xBB\x91\x20\x6E\x63\x47\xC6\x76', #B7
        b'\x08\x47\xC6\xD7\x1C\xE0\xC7\x46\x86\xFD\x45\x1B\x44\x7C\x1E\x11\xC2\x06\x23\xB0\xE2\x85\x6F\xCC\x3A\xDD\xFA\x2D\x03\x98\x18\x1E\x67\x36\xA0\xA0\x6B\x33\x6B\x46\xD1\xC7\x0A\xEE\xB2\xB1\x25\x7D', #B8
        b'\x56\x33\x26\x0D\x14\x1A\x97\x76\xD5\x30\x80\x5F\x59\x6C\xA3\xDB\x8C\xE3\x3E\xF6\x94\x37\xCE\x46\xF6\x2D\x54\xE9\x7E\x74\x70\x88\xDF\x5C\x93\x18\x48\x9B\x45\xEA\xA4\xAA\xD2\x9F\x0B\xA8\x50\xCA', #B9
        b'\xBD\xBD\x7B\x16\x76\x7F\x6D\x9F\xF7\x96\x84\x27\xF1\xB7\xB6\xDD\x58\xC7\x65\x99\xB3\x52\x76\xEE\x28\x6F\x4C\x7F\x6C\xAD\xD7\x91\x81\x88\xC0\x40\x17\x42\x11\x7B\xCE\xC4\xF1\x96\x42\x66\xD1\x63', #BA
        b'\x97\xE4\xE8\xA6\xB5\x13\x5B\x24\x8A\x8B\xD7\x85\xE5\x29\x79\x77\x45\x45\xC1\xA0\x97\x5B\xC5\xBB\x13\xFA\xE3\xBD\x9F\x59\xE3\x7D\xAF\xD5\x62\x7C\x0E\x91\xDE\x2B\xA2\x23\xAC\x77\x84\x74\xE1\xA9', #BB
        b'\xDE\x1B\xF1\xEA\xF8\x6C\x6B\x3B\xA2\x46\xA3\xAC\xD5\x00\x35\xFE\x6F\x80\x17\x9D\xD9\x6A\x21\xCD\x3F\x8D\xB7\xCB\x17\x30\x0D\x03\x49\x7A\x79\x8B\x5D\x94\x50\x6C\xAD\x52\xDC\xC6\xF6\x1A\xE8\x41', #BC
        b'\xF4\xA4\xE1\xD0\x8E\x1F\x44\x0B\x5E\x27\x63\x3C\xD5\x64\x22\xE0\x14\x65\xC1\x4F\x1D\xB4\x14\x20\x9A\x93\x90\x43\x98\x8D\x37\xC2\xCB\xE6\x5C\xFA\x24\x5D\xB3\x68\x63\x40\xAE\xDE\x28\xDD\xA8\x55', #BD
        b'\x1F\x7A\xB6\x5A\x3F\x89\x24\x54\xD7\x0A\xB4\x16\x7E\xBE\xB5\xA1\x9B\x26\x31\xE8\x24\xC2\x02\x8D\xD5\xD9\x7B\xDE\xE3\x15\x19\xBC\xEA\x2D\xC7\x74\x49\xE4\x05\x8C\xEB\x20\x4F\x2D\x6D\x2F\xBA\xFF', #BE
        b'\x65\x37\xE6\x91\x71\xA2\x66\x5D\x3F\xD2\xF8\x35\x43\x5A\x3F\x23\xAD\xD5\xDD\x3E\x62\x2D\x6C\x8A\xC5\x22\xCD\xD5\xE5\xE2\x43\xF8\x5A\xEC\x27\xF3\xDB\xFD\xA8\xA2\x47\x7A\x65\xED\x57\x0E\x14\x45', #BF
        b'\x3B\xA7\xCB\x01\xD3\x2E\x9D\x63\x9E\x33\x57\x34\xE7\xB5\x41\x6B\x0E\xD9\x6A\x84\xF9\x45\x39\xF6\x45\xCE\xE2\xE4\x6D\xF5\xA7\x0D\xDE\x14\x2E\xE1\xE9\xAF\xEC\x1C\x78\xD6\x12\x1C\x4F\xDC\x72\xDD', #C0
        b'\x7B\xB3\x0A\xF6\x53\x39\x0B\x77\x2D\x39\x4F\x2B\x7F\x8F\x7B\xB6\x02\x77\xA3\xC2\x13\xAF\x34\x89\x7D\xF6\xE6\x74\xDD\x56\xD0\x84\x56\x43\xCD\x30\x73\xC4\x24\x51\xFA\xB1\x5F\x8B\xD1\xA1\xDC\x18', #C1
        b'\x42\xB4\x53\xAB\xF5\x15\x0D\x8B\x91\x3F\x10\x9C\x11\x88\xE1\x8C\xC2\x7B\xB7\x63\x1F\xB4\x3B\xF9\xEB\xDD\xE6\x85\xEF\x10\x84\x19\x76\xD6\x7C\x87\xC5\x6D\x33\xEA\x95\xEC\x73\xC0\xAF\x40\xF0\x84', #C2
        b'\xBC\xE4\x3D\x59\xA1\xF5\x0B\xFB\xBA\x70\x27\xCA\x04\xD8\x46\x00\xFB\x6F\xDB\x98\xA2\xBE\x64\x4B\xD5\xDE\x77\x7E\x99\x3D\xED\x4A\xFC\xA3\x9F\x1E\xDF\x71\x0F\x3A\xA5\xE5\x89\x3C\x85\x8D\x88\x41', #C3
        b'\xC6\x8A\xC7\x76\xE6\xAE\xAC\xFC\x53\x80\x67\xC7\x86\x61\x06\xEB\xD2\x7B\x4A\x35\x2F\x4E\xFD\xE3\x84\x7D\xA2\xB3\xBF\x01\xE3\x78\x3C\x79\xE3\xC1\x36\x92\x6D\x58\xF9\x57\xBC\x87\x26\xAA\x16\x10', #C4
        b'\x95\x49\x2C\x42\x03\xC7\xC6\x12\x0D\xD6\x0D\xB1\xEE\x83\x21\xFC\xE1\xD9\xEB\xA9\x02\xF6\x2B\x42\xEA\x2D\xBF\x7D\x0E\x37\xA4\xF2\xE1\x1F\xB9\x09\x8B\xF5\xDA\x48\xDB\xFE\x21\x3F\x81\x8E\xA3\x38', #C5
        b'\x17\xCB\x21\x31\x6D\x47\x56\xDD\xB8\x89\x52\x49\x81\x40\x14\x6A\x64\x81\x12\xF5\x80\x84\x42\x88\x49\x47\xAD\xC3\xF7\xD5\x8F\x35\x65\x1C\xCE\x28\xE2\x6A\x53\x77\x0B\x38\x03\xDA\xF3\x37\xF8\x9B', #C6
        b'\xBE\xAB\x16\xE2\xDC\xE6\xB6\xE3\x8F\x39\xEC\xC8\xE3\x91\x72\xDF\x60\x7C\xC9\x55\x3F\xF2\x9C\x0E\x4B\xFD\x15\x15\x4F\x4F\x0B\xA7\xEE\x62\x30\xB6\xBD\x40\x8C\xE4\x35\xB6\x54\x11\x0D\x16\x4E\x99', #C7
        b'\xAD\xDD\xFF\x1B\xD2\xC1\x1C\xD4\x2A\x1A\x26\x2C\xBA\x6E\x1A\xA0\x0B\xF2\x29\x1D\x09\x47\x5A\x46\x4C\x93\xA0\xAB\xAD\xF4\xDE\x32\x73\xEE\x8E\x13\x27\x33\x3E\x63\xF3\xAE\x20\x31\xF5\xD1\x3B\x28', #C8
        b'\x24\x6C\x7C\xAB\xB2\xD9\xA5\x5C\x50\xE9\xC7\x28\x2C\x1E\xE0\xF6\x2F\xBD\xA0\x95\x65\xA0\xD3\xD7\x19\x65\x52\x67\x9C\x04\xA4\xEB\x13\x7C\x66\xDA\x29\xA6\xDD\x82\x08\xA7\x6B\x6B\x4B\xDA\x56\xBF', #C9
        b'\x7C\xA3\xC5\x9B\xE3\xE2\x86\x10\x6A\xDD\x75\xCF\x1F\x7A\xE2\x48\x01\x74\x74\x50\x73\x7A\x64\x35\xA1\xF2\x25\x9C\xB2\xB4\x92\x3B\xE0\xC8\xF5\x5E\x8E\xCE\x72\x10\xD7\x96\x43\x98\xF3\x50\xB6\x9B', #CA
        b'\xE0\x45\x86\x4E\xD1\x82\x51\x01\xAC\x54\x96\x91\x93\xE1\xA1\xC5\x23\xD8\x5A\x93\x4D\x07\x94\xC7\xB4\xFA\x88\xCB\x73\x4A\x42\x13\x7C\x5C\xBF\xD6\xBD\xA3\xD5\xF9\x66\x60\x7F\xE9\x38\x74\x88\x25', #CB
        b'\xBA\xF3\x6F\xD2\xA1\x80\xD4\x81\xEA\xC4\x40\xAC\x1B\x95\x98\xF7\x9A\xA2\x4D\x80\xFF\xB7\xB0\x6C\x79\x60\x1F\x51\x73\x58\xF1\x63\xD1\x07\x18\x31\x41\x8B\xB6\x3B\x81\x96\x09\xA6\xAE\x7D\x3A\x03', #CC
        b'\x3E\x91\x52\xD8\xCD\xBA\xE5\x51\x86\xAD\x79\x3F\x20\x3D\xD0\x16\xBE\x3A\xEB\x77\x8A\xD4\xA8\x91\x28\x10\x25\x4D\xD7\x6B\x66\x18\x9B\x5D\xCD\xE3\x66\x36\xC3\x27\x0A\x8A\xAD\x65\x86\x8B\xC5\x8C', #CD
        b'\x6D\x06\x72\x78\x0D\x93\x15\x2A\xEE\xE7\x05\x24\x7B\x82\x80\x91\x9E\xBD\xB9\x76\xF1\x37\x46\x3F\xA7\xDE\x3E\x73\xA2\xD0\xC1\xBF\xF8\x71\xA0\x0B\xA0\x04\x6A\xC7\x48\x4C\x96\xA8\x03\xF2\x34\x86', #CE
        b'\x0F\xC7\xBC\xDA\xBB\x06\xBF\xFB\xF7\x5C\x3F\xFB\x3D\x63\x09\xB3\xEC\xA3\x05\xD1\x03\x10\x91\x62\x37\x3F\x50\x3B\x20\x4F\xFF\x61\xCE\x33\x2C\x9F\x54\x96\x3F\xA2\x9A\x44\x20\xA5\x22\x42\xCD\xB4', #CF
        b'\xC7\x1D\x48\x11\x79\xD1\x98\xC1\x50\x5A\x28\x45\xCE\xE9\x25\x69\xF3\x39\xBF\xF6\xDD\x67\x55\xB5\x8B\xEA\xD5\x2B\x8D\xE8\x92\x45\x4B\x68\x6E\x65\x92\x0D\xCA\x2B\x99\x59\x3F\xA4\x3E\xE6\x8A\x37', #D0
        b'\xD9\x0A\x68\xD7\x17\xE6\x15\x01\x9B\xB9\x20\xAE\xA1\x91\x61\xA6\x2F\x3D\x6F\x96\xD9\x0E\xB1\xE4\xDF\x15\xEC\xBA\x10\x51\x3D\x7D\xE6\xE5\xD5\x39\xB4\xF0\x18\x31\xC7\xD1\x7A\x75\x28\xFE\xCE\x36', #D1
        b'\xA0\x4F\xF0\xBE\xB4\xEB\xFB\xAF\xE5\xE9\x0A\x5B\x3D\xDA\xA3\xCA\x84\x53\x54\x22\x09\xF4\xA1\x45\x80\xA6\xFF\xD7\x2B\xB5\xA7\x07\x14\xE0\xC4\x70\x5A\x1A\xBF\x6A\xD6\x99\xEC\x1F\xC1\x8A\x67\x7D', #D2
        b'\x70\x21\xA1\x24\xE3\x18\x15\x75\xDC\x7A\xAE\x28\x17\xAD\x94\x5F\x8B\xB5\x52\x1E\x7F\x0D\x56\x5A\x66\x71\xD3\x79\x2F\x08\x05\xEE\xD3\x88\x8E\xA3\x94\x41\x3A\x1A\xCE\x4D\x7E\x47\xB5\x5B\xF9\xCC', #D3
        b'\x22\xF4\x40\x26\x3C\xAA\xDE\x68\xE7\x7B\xB2\x87\x77\x2E\xAC\x7B\x29\x49\x37\x75\x96\x2A\x40\xE9\x1E\x06\xA2\x7F\xA6\x8C\xB9\x1B\xDD\xEF\x02\x93\x2A\xBD\xB9\xC7\x79\xF0\x3B\x88\xDC\x17\x52\x33', #D4
        b'\x65\xF6\xD5\x17\xB5\x3E\x23\x91\x97\xDB\x65\xA2\xF0\x0B\x1C\x39\x1D\x77\xAE\x9B\x85\xAA\x48\x55\x19\x13\x3B\x9B\x3E\x9B\x07\x71\x63\x76\xD9\xF1\x1A\x7D\xB3\xD4\x94\x9A\xD0\x2F\x5A\xE1\x61\x84', #D5
        b'\xFE\x44\x34\xCD\xE0\x9D\x92\x3B\x03\xB0\xFC\xFD\x71\x3B\x70\x52\x2D\x71\x32\x90\xD4\xA6\x72\x38\x2B\x56\x94\x6F\xF6\x29\xEE\x96\x60\xA1\x5D\x01\xB2\xB3\xC4\x28\x0B\x1D\x5E\xAF\x79\x39\x33\xA0', #D6
        b'\xBC\x40\xFC\xFB\x0E\x0D\x49\x4B\xA3\x1C\x46\x48\xC7\xB3\xD1\xDE\xF1\x11\x3C\x21\x9A\x07\xEC\x8D\x23\x78\xBE\xB1\xA5\xC2\xBD\x1C\x19\x0C\xC3\x47\x80\x70\xA1\x94\x63\xDA\xB6\xE1\xCC\xF5\x63\x29', #D7
        b'\x90\x1B\x6B\x9E\x82\xBA\xBF\x91\x87\x2A\x23\x4C\x45\xD6\x10\x01\x6C\xA4\x6A\x95\xC1\xCC\x6D\x6C\x22\x77\x93\x15\xE0\xF0\x22\x95\x60\xA5\x93\x96\x34\x6B\xE6\xAC\xFB\x67\xA5\x03\xCB\x48\x88\x46', #D8
        b'\x50\xD4\x40\xF7\x4C\x97\x66\x0B\xE7\x1E\xCA\xBF\x64\xED\xFE\x0C\x80\x20\x1B\x89\x57\x18\xCE\x22\xA0\x5D\x89\x80\x4D\x35\xD3\x06\x8F\x70\x04\x02\xA2\xB0\xD0\x86\x32\x6F\xCB\x33\x4C\xA4\xDF\xC0', #D9
        b'\xBC\xFB\xD0\x2E\xA0\x05\xCD\xD5\xF0\x22\x5A\x46\x75\x55\x31\x15\x08\xE1\x8B\x36\x92\xA7\xAF\x62\x05\xD3\x4A\x82\x0C\x8C\xED\x0A\x51\xA8\xD7\xCE\xC3\x3E\x80\xEA\x0A\xC0\x07\x50\x3F\xAE\x87\x9C', #DA
        b'\xF4\x3E\xEF\xB5\xC8\x3C\x52\x1A\xE5\xE9\xB0\x5F\xC4\x88\x41\xAC\x79\xC5\x2C\x38\xBF\x85\xB5\xF9\x26\xCD\x08\x18\xAE\x3B\xF7\xA9\x4F\x38\x5C\x32\xCA\x8F\x5F\x74\xF1\x7B\x22\x10\x7B\x95\x47\x52', #DB
        b'\x1A\x48\xFC\x96\x91\x98\xA4\xB0\xD9\xA7\x89\x40\xBB\x0C\x4E\x1C\x42\x78\x1D\x9B\xE6\x0E\x76\x91\x87\xD1\xCA\xF3\x68\x0F\x8A\x30\xD0\x9F\xF1\x93\x60\x6A\xAF\x29\x45\x18\xDA\xBC\x60\x04\x87\x93', #DC
        b'\xF0\x5D\x48\x13\x4A\x56\xA0\x34\x89\xA6\x5E\xEB\x91\xDC\x69\xB9\x8F\xC7\xF4\x39\x60\xE6\x3C\x62\xFA\x1C\x6B\x9F\xF9\x41\x5E\x92\x7E\x21\x9D\x4E\x56\x34\x79\x35\x2B\x6A\x48\xD6\xDE\x0A\xEF\x85', #DD
        b'\x1A\x7F\xF9\xC5\x4B\x04\x5F\xFD\x44\xA0\xA9\x56\x2E\x94\x68\xB2\xF1\x14\x25\xA2\x2D\x1E\xBF\x92\x20\x8D\x33\x12\x0B\xD2\x8E\x0E\xF2\xD7\x41\x97\xAF\x80\xE1\x62\xCE\xED\xCA\x73\xDF\xE6\x6C\x93', #DE
        b'\xD5\x71\x90\x43\x9D\x29\xC9\xA4\x44\xC0\x07\xDC\x2B\x5E\xAF\x9D\xEF\x6D\xDF\x48\xA7\x80\xCE\xDC\x61\xB2\x05\xE4\xA9\x60\x24\xB1\x18\x85\xB6\xCE\x84\xC3\xFE\x5D\xB8\xB5\x69\x86\xB6\xE2\xCE\x21', #DF
        b'\xF3\x6D\xAC\xFA\x34\x23\x7E\x99\xBE\x45\xEB\x52\x53\xBC\xFE\xD0\x40\x2C\x69\x46\xB8\xB2\x1A\xC0\x24\x60\xA6\xFC\xE7\xE9\xCD\x67\xF8\x9A\x6D\x5B\x16\x26\x29\xFC\xF6\x6C\xCE\xA3\x74\xDB\x82\x1E', #E0
        b'\x16\xE0\x60\x74\xDC\xC3\x1A\x1D\xF1\x72\x01\x7A\xC3\xFA\x38\xC3\xBB\xC1\xCE\x4B\xB7\x84\xED\x60\xDA\x89\xA8\xBC\xE8\x2A\xE6\x71\xA6\xDA\xCF\xFB\x8D\x26\xC0\xBB\x18\x51\x81\xAE\x96\x09\xF6\xD6', #E1
        b'\xF1\x10\xDB\xDD\x94\xD1\x76\x61\xF5\x9F\xBB\x4C\xBA\x69\xF3\x93\x46\x3B\x60\xFB\x3F\x3C\x5E\x00\x1C\x60\xB8\x96\xFE\x8E\x78\xAC\x5E\xB3\xE2\x67\x95\xDE\x5A\xB6\x99\x73\x28\xD4\x65\x4D\x62\x19', #E2
        b'\x21\x06\x91\x18\xAB\xE2\x4B\x61\x81\x1C\xB8\xC4\x8F\xCE\xFC\x6A\x48\x3B\x03\x2C\xFB\x56\xF9\x02\xFB\x32\xE8\x48\x19\x8C\xC0\x57\xA6\x20\x81\x54\x62\xA0\x4F\x70\x90\x00\x38\xD1\x89\x49\x59\xE2', #E3
        b'\x5A\xD5\x09\x78\x9B\xFF\xEC\xD0\xDD\xCD\x5E\x83\x25\xF6\x9C\xA0\x15\x4D\x8F\x1A\xCD\x9B\x8C\x82\xAC\x7D\xF7\x5E\x94\xCE\x3C\xAF\x6D\x65\x54\xD1\xB3\x87\x54\xBE\xB5\xDB\x64\xAF\x73\x84\x86\xE7', #E4
        b'\x35\xA3\x08\xA1\xAC\x9A\x43\xBF\x26\x47\x80\x5A\xB3\xE6\xE4\x92\x4B\xB7\x4A\x61\x6F\x61\x58\x8F\xFA\x46\x02\xEE\x5B\xDB\xF5\x4E\x3F\xDD\x62\x47\x0A\x71\x74\xDB\x57\x95\x43\x3C\xA8\x08\xFA\xAC', #E5
        b'\x51\xA0\x94\xB8\x77\x4C\xA6\x05\x5F\x07\x97\x4C\x74\xEE\xF2\x25\x02\x2A\xFE\xF7\xAD\x81\xA9\x53\x09\x67\xC4\x4B\xBA\x33\x6F\xD6\x8A\xA3\x27\x91\x8A\xEC\xBA\x3D\xF7\x0B\x84\x36\x57\x3C\x3F\x0A', #E6
        b'\xCF\x37\x4F\x83\x42\x07\x66\xC3\x71\xF3\x19\x01\xA1\x3E\xF0\x7C\x63\xAD\x56\xC7\xDE\xF9\xDC\x0F\x9E\x5B\xB5\xE8\x59\xF5\xA2\x31\xD0\xBF\x45\x3B\xB9\x89\x3E\x4C\xA1\xE1\x4B\x66\xC2\x71\x97\x60', #E7
        b'\xB4\x18\x61\xCC\x73\xFD\x3E\x48\x46\x1D\x79\xA1\x38\xB0\x4B\xE1\x40\x10\xD3\x7D\x37\xFB\xA8\x17\x7D\x96\x22\xAA\x69\x32\x25\xA4\x22\x04\x45\x4B\x81\x26\x79\x9A\x33\xA5\xD4\x87\xDC\xCD\x6E\xB6', #E8
        b'\xD2\x91\xD0\x31\x7A\x05\x33\x20\xE2\x76\x78\xF1\xE5\x0D\x1F\x76\x9A\x3D\x66\x3A\x63\x15\x9F\xC7\xAD\x7B\x4D\x3F\x67\xBA\xB4\x52\x26\x9C\xC0\x5E\x2B\x33\xCE\x1C\x0F\xB8\x26\x1C\xD7\x34\xBC\xC3', #E9
        b'\xF3\xD0\x54\x6D\x3D\x4A\x25\xEE\xB4\x28\x74\xAD\x28\xC9\xB7\xF2\x73\xEC\x78\x8B\x29\x96\x2D\x28\x4A\xE7\x3A\x48\x13\x2B\x85\x53\x75\x6C\x99\xD7\xA0\x91\x0B\x66\xEC\xA7\xE2\xC2\x71\x2D\x55\x5C', #EA
        b'\x55\x9F\xA5\xBF\x24\x91\x1F\xDD\xA1\xDD\xF5\xDE\x37\x70\x55\x4B\xC7\xC3\xFD\x13\x93\x66\xB9\x46\x6E\x7E\xCC\x0C\x88\x1D\x2B\xA4\x14\xE7\x6D\x6A\x27\xE5\x4B\x87\x73\x52\xD5\xFB\xC4\xFA\xB8\x78', #EB
        b'\xF1\x9A\x62\x2B\xED\x8D\xAC\x0A\x35\x54\x8E\x5D\x7E\xFC\x5A\x2E\xCA\xC8\x49\x74\xB4\xF0\x57\xB2\xAB\x31\x7E\xD0\x3D\x03\x35\xAE\x71\x0F\xC1\x38\xF2\xC5\x17\x38\x9C\x90\xCC\x49\x5A\x40\x34\x16', #EC
        b'\x9F\xA7\xDE\xB9\x36\xF1\x04\x61\xA1\x52\x9B\x0B\x58\x46\x2F\x9D\x9F\x10\x91\x11\xC8\xB9\xEC\x65\x23\xA3\xEB\x28\x44\x4E\x33\xEA\x55\x40\x84\xCA\x75\x11\x89\x37\x59\x9D\x58\xA7\xC9\x46\xEA\xC2', #ED
        b'\x6E\xC3\xAA\xBB\x78\x56\xAC\x4E\x98\x0E\x69\x07\xC1\xCB\xCC\xAF\x1F\x85\x57\xAD\xC7\x00\xCB\xF5\x7D\xCB\x1C\xE0\xAF\x48\xD9\xF4\x7F\xB3\xDA\xDF\x81\x99\xAB\x8A\xE6\xB3\x6D\xB8\xFA\xDB\xF3\x12', #EE
        b'\xC0\x0F\x0D\x3F\x7A\x10\x16\x60\x60\x5B\x94\xB1\x2D\xB6\xC6\x97\x79\x94\x4F\x7B\xA2\xB6\x5F\x38\x40\x85\x8A\xDE\xDD\x47\xE2\xBC\x1E\x04\x4B\xDB\x0E\x9F\xB0\x2B\x86\xC7\x9D\x01\xA3\x10\x95\x39', #EF
        b'\x97\x31\x89\x3D\x5B\x98\x48\x2A\xFB\x8D\xE2\x67\xF9\x79\x03\x26\x87\x80\xF4\x07\x14\x3A\x50\x5D\xA4\x1C\xAE\xFC\xCC\xD3\xA8\xE3\xA0\x42\xF0\xB3\xD7\xB7\xA7\xFE\x3E\x31\x51\xFE\xBB\x19\xA1\xAC', #F0
        b'\xE7\xED\xF6\x79\x00\x3A\x69\x50\xBA\xFC\x97\xD4\xA8\xC6\xAB\x12\x13\xC0\x96\xB4\x9C\x79\x55\x9A\xC3\x05\x25\x01\x43\x4B\x50\x19\x12\x80\xFB\x23\xE7\xAD\xFB\x09\x19\x59\x90\x5D\x31\xBD\x2F\xC0', #F1
        b'\x57\x5C\x0C\x46\xFC\xFC\xC6\x5B\xFE\x62\x5E\x87\x3F\x34\xB4\x19\x16\x96\xFD\xCC\x7F\x51\xB8\xA3\xC7\x9C\x56\xF3\x0E\x5A\xE7\xC0\x14\xE3\x46\x1C\xD2\x7F\xAD\x15\x1B\x7B\xCC\xB9\xCB\x47\x28\x59', #F2
        b'\x38\x06\xFE\x58\xE5\xCC\x8F\x16\xF8\x24\x4E\xD7\x67\x34\xC1\xBF\x4E\x04\x94\x0E\x0F\x5D\xDB\x56\x5B\xD0\xAF\xDD\xC4\x15\x8B\x7B\xA4\xC6\xBA\x94\x99\x11\xC5\xC9\xFF\x6E\x2A\xC1\x55\xAE\x97\x26', #F3
        b'\x49\xC7\xC8\x44\xB8\x11\x41\x44\xB4\x50\xE4\x1B\xCA\x35\xCB\x00\x30\x24\x50\xEC\x67\xBE\xF9\x7C\xA8\x66\x20\x49\xDB\x1E\x0D\x8B\xDA\x69\xC0\x22\x52\x8E\xB8\xFA\x6A\xBB\xF1\x65\x85\xC1\xA2\xF7', #F4
        b'\x37\xBB\x42\x0D\xF6\x7F\x04\x4E\xDC\xC0\xE9\xF3\xE2\xEF\x07\xB3\x4D\x10\x08\x86\x18\x77\x78\x41\x04\x92\xE5\x37\x93\x05\xDA\xAE\x3D\xA4\x79\x1C\x37\xE4\x12\x8F\x80\x68\x84\x45\xCB\xA4\xEA\x17', #F5
        b'\x51\x39\x8A\x7C\xE4\xCF\x8D\x9D\x49\xA5\xFC\xD8\x91\xA6\x9C\xA5\x3D\x72\xA6\x0E\xC2\x39\x2D\xA5\x0E\x82\x96\xB8\x79\xAB\x55\x39\x6B\xCB\x00\xAF\x2E\xDC\x0B\xDE\xBE\xB9\x38\x48\xE5\x4B\x3E\x90', #F6
        b'\x7A\xD7\xC5\x2A\x18\x92\x2E\x19\x29\x29\x2C\x57\xC4\xF5\xB8\xF5\xF0\xCF\x1F\x98\xA5\x77\xC1\x0B\x07\x2B\x9F\x29\x3B\xB6\x60\xCD\x09\xB8\x60\x4F\x55\x75\xB6\xFB\xDE\xCB\x39\x6A\x81\xB9\xFC\xDB', #F7
        b'\x25\x4A\xD7\xAD\xB4\xC2\x20\xDE\x6C\x62\xE2\x0F\x95\xA0\x07\x0D\xAD\xEB\x89\xF3\x39\x30\x9B\xD8\xA2\xF6\x85\xCC\x17\x8B\x28\x9F\x93\x43\x90\x5B\x5D\xEE\x95\xA5\xE0\xC3\x0F\x34\xA2\x97\x7C\x86', #F8
        b'\x66\x9C\xD5\x1A\xF7\xCF\xBF\xAA\xE3\xE0\x80\x6F\x68\x80\x27\x1D\x69\x34\xC2\x59\xE0\x98\xBF\x90\x5D\xFE\xEA\xF0\xFB\xCA\x72\x49\x89\xF7\x4B\x94\x8B\x41\x18\xB6\x53\x64\x0A\xEA\xFB\x68\x07\xC3', #F9
        b'\xDD\x3B\xAC\xDC\xC0\x4B\xE1\x20\x6D\x49\x49\xBD\x64\x19\x8E\x51\x31\xFD\xB3\x96\x66\x59\x8A\x74\xBB\xBC\x6D\xE9\xC0\xC1\x5A\x81\xF2\x7F\x20\x1C\x61\xC0\x62\x79\x27\x38\xAF\xE3\xE8\x4E\x5C\xDD', #FA
        b'\xCD\xD7\x1F\xD3\x5A\x64\x11\xDE\x3C\xC0\x12\x79\x3E\x87\x52\x3F\xB0\xCF\xF8\x72\x0F\xCA\x36\xF3\x93\xE8\x5F\xE0\x73\x00\xF0\x12\xE8\x94\xA0\x85\x26\x3F\x09\x0B\x2D\xF6\x0A\x01\xDA\xFA\x90\xEC', #FB
        b'\x9D\xA5\x0D\xB1\xEE\xB4\xFA\xDD\xE5\x24\xE4\x9C\x99\x74\x79\x9A\xDE\x09\xFF\xF2\x6A\x24\xCB\xB9\xAF\x9D\x71\xE9\xF3\xAC\xE7\xCD\xEB\x62\xB1\xA6\x25\x66\xEC\x9D\x06\xD0\x2A\xB1\x21\x7D\x35\x53', #FC
        b'\xDD\x31\xE6\x39\x1A\xE0\x35\x22\x93\xAC\xD1\x06\x5B\x35\xE9\x15\xF4\xEB\x56\xCC\x03\xE7\x92\x18\x07\x17\x81\x5C\x85\x0C\x97\xF1\xBF\x4F\x6A\x8A\xC0\x54\x0A\x6F\xFC\xF8\xAE\x5D\xE9\x50\x7F\xF0', #FD
        b'\xAB\x45\xB4\x13\xDC\x50\xB2\x07\x40\xB4\x17\x36\x95\x51\xD8\xD5\xCA\x32\x28\x6A\x10\x8E\x72\x10\x03\x22\x5E\x54\xD8\xD0\x93\xAF\x4B\x6C\xA5\x59\x1E\xA5\x76\xE9\x4E\x12\xAB\x77\x4D\xC4\xE0\x62', #FE
        b'\xD9\xF4\xF8\x50\xDF\x6C\xB9\x6C\x8A\xBA\xD8\x1B\x16\x67\x33\x5D\xCB\x40\x79\xCF\xE7\x9C\x72\xE5\xE5\x54\x2F\x76\x3E\x31\x69\x96\x30\x3E\x4B\x79\xB9\xD3\x97\xC4\xE4\x69\x33\x03\x8B\x94\x51\x11', #FF
        b'\x75\xB1\x5C\xC5\x3B\x0D\x25\x02\xDA\x1B\xCA\x6B\xA0\x52\x43\x58\x9E\xDA\x97\x75\x56\xC0\x6B\x7E\x6C\x57\x72\x7E\xCF\x0A\x13\x25\xDC\x61\x3D\x5A\x78\xE5\xC3\xF8\xCE\x06\x2D\x94\xA3\xB4\x94\x5A'  #ZZ
    )

    __TABLE_MIX = (
        b'\x02\x04\x23\x0C\x17\x00\x10\x24\x0E\x27\x05\x1B\x0B\x1D\x08\x20\x29\x1F\x2D\x1A\x2F\x18\x2B\x25\x28\x2E\x0F\x11\x0A\x2A\x06\x1C\x09\x19\x1E\x12\x16\x2C\x07\x14\x26\x01\x21\x03\x22\x13\x0D\x15', #00
        b'\x16\x1C\x12\x15\x21\x0A\x22\x02\x0B\x0C\x1D\x08\x2C\x11\x00\x2A\x19\x2B\x10\x28\x09\x04\x13\x07\x24\x2D\x2E\x2F\x29\x26\x0F\x17\x27\x0D\x1B\x1A\x03\x05\x25\x1E\x01\x23\x06\x1F\x14\x0E\x20\x18', #01
        b'\x15\x18\x0A\x1F\x2E\x26\x11\x28\x22\x13\x25\x1B\x09\x00\x06\x08\x2C\x14\x21\x2D\x27\x2B\x02\x29\x07\x2F\x23\x0B\x2A\x0C\x16\x19\x03\x1D\x1C\x05\x0D\x17\x1A\x0F\x1E\x04\x24\x10\x01\x20\x12\x0E', #02
        b'\x27\x10\x18\x1E\x09\x0B\x1A\x13\x21\x0D\x12\x2A\x2B\x29\x11\x2E\x2F\x25\x02\x08\x1B\x05\x03\x1F\x26\x16\x06\x0A\x19\x2C\x14\x1C\x17\x0C\x0E\x07\x20\x22\x15\x01\x0F\x24\x04\x00\x1D\x28\x2D\x23', #03
        b'\x0A\x0D\x08\x2A\x11\x28\x29\x1A\x1C\x05\x21\x25\x13\x07\x2E\x18\x17\x1B\x0C\x2C\x23\x1F\x1E\x2F\x06\x24\x0F\x00\x1D\x10\x03\x04\x01\x09\x26\x2B\x19\x20\x12\x0E\x16\x2D\x0B\x22\x14\x15\x27\x02', #04
        b'\x2B\x25\x11\x1C\x1A\x12\x15\x1F\x0F\x29\x13\x04\x07\x06\x1B\x0D\x0E\x00\x19\x09\x1D\x2F\x21\x01\x26\x27\x16\x03\x2E\x2D\x24\x18\x2A\x0B\x10\x2C\x22\x02\x05\x20\x08\x14\x0C\x1E\x0A\x17\x23\x28', #05
        b'\x1A\x1D\x18\x27\x09\x26\x21\x06\x0A\x2C\x2A\x25\x0E\x08\x01\x22\x0B\x1E\x05\x2F\x0F\x2E\x00\x16\x0D\x0C\x28\x20\x23\x1F\x10\x2B\x07\x1C\x24\x19\x2D\x13\x03\x04\x11\x15\x12\x1B\x14\x02\x29\x17', #06
        b'\x2D\x02\x14\x1E\x1D\x2B\x22\x18\x07\x15\x11\x0E\x10\x00\x1A\x0D\x09\x16\x23\x0B\x13\x25\x20\x12\x2E\x1B\x2C\x01\x03\x08\x1C\x05\x21\x17\x28\x0C\x06\x2F\x29\x1F\x0A\x2A\x0F\x24\x26\x19\x04\x27', #07
        b'\x10\x0E\x19\x23\x1A\x13\x14\x0C\x22\x1D\x2E\x15\x2A\x28\x29\x17\x1F\x08\x06\x09\x0B\x27\x04\x24\x02\x12\x21\x05\x16\x2C\x00\x26\x0F\x1E\x2D\x2F\x0A\x18\x1B\x2B\x03\x25\x0D\x07\x11\x20\x01\x1C', #08
        b'\x29\x10\x0F\x13\x22\x06\x00\x11\x0E\x03\x20\x18\x1F\x2A\x19\x2F\x0B\x02\x2B\x23\x04\x07\x2C\x25\x08\x21\x24\x1C\x01\x0C\x17\x1D\x1A\x2E\x12\x15\x26\x09\x2D\x1E\x05\x0D\x27\x28\x1B\x0A\x16\x14', #09
        b'\x21\x25\x29\x2B\x0F\x0E\x09\x14\x20\x1E\x24\x0C\x15\x10\x03\x0B\x02\x01\x06\x28\x08\x1F\x11\x04\x2F\x18\x19\x2E\x0A\x22\x27\x17\x23\x07\x1A\x2C\x1C\x00\x0D\x2A\x1D\x26\x12\x2D\x13\x1B\x05\x16', #0A
        b'\x2A\x22\x15\x1D\x0E\x24\x16\x03\x09\x19\x2C\x01\x26\x1F\x27\x18\x25\x20\x14\x17\x1E\x2B\x0D\x06\x05\x0C\x29\x11\x0B\x00\x1B\x0F\x10\x02\x28\x2F\x2D\x08\x1A\x2E\x12\x21\x04\x07\x1C\x0A\x23\x13', #0B
        b'\x1E\x1B\x04\x12\x17\x2A\x24\x05\x03\x26\x0B\x2F\x29\x2E\x0A\x08\x27\x02\x2D\x21\x19\x0C\x0F\x1D\x1C\x0D\x0E\x06\x00\x14\x16\x13\x1F\x22\x2C\x28\x11\x01\x25\x07\x09\x18\x23\x15\x20\x10\x2B\x1A', #0C
        b'\x29\x0C\x22\x19\x14\x09\x18\x1D\x1C\x28\x2E\x0D\x05\x13\x26\x2B\x0F\x00\x1E\x10\x04\x27\x15\x08\x1B\x1A\x12\x23\x02\x25\x0B\x24\x11\x07\x1F\x0E\x2A\x2F\x17\x0A\x20\x2C\x2D\x01\x21\x16\x03\x06', #0D
        b'\x13\x12\x01\x2C\x23\x2A\x21\x27\x1D\x0E\x20\x1C\x28\x2B\x0C\x1B\x07\x22\x0F\x08\x25\x05\x04\x24\x0A\x29\x09\x10\x1F\x19\x02\x2D\x00\x17\x1E\x03\x15\x16\x14\x11\x26\x06\x0B\x2E\x1A\x0D\x2F\x18', #0E
        b'\x11\x2A\x1D\x21\x0B\x18\x1B\x2C\x00\x22\x09\x03\x2D\x01\x0F\x0C\x1F\x14\x1C\x1E\x2E\x25\x15\x2F\x19\x0D\x0A\x29\x13\x17\x23\x12\x07\x16\x10\x1A\x20\x05\x06\x04\x27\x2B\x08\x24\x0E\x26\x02\x28', #0F
        b'\x08\x28\x1E\x2B\x2C\x24\x0C\x21\x0E\x16\x05\x02\x20\x27\x23\x04\x18\x1A\x25\x00\x10\x14\x09\x0F\x2F\x0B\x1C\x1F\x11\x01\x19\x13\x22\x2D\x07\x26\x15\x1B\x12\x29\x06\x0A\x03\x0D\x2E\x2A\x1D\x17', #10
        b'\x17\x0E\x1B\x21\x15\x04\x0B\x0A\x11\x0C\x2F\x06\x22\x09\x05\x1D\x2E\x00\x2A\x2D\x12\x2C\x26\x10\x16\x03\x18\x27\x29\x14\x08\x1A\x19\x1F\x1E\x24\x0F\x0D\x2B\x02\x20\x01\x28\x23\x07\x1C\x25\x13', #11
        b'\x23\x19\x0F\x22\x26\x03\x11\x05\x1A\x1F\x28\x16\x2F\x2D\x04\x25\x20\x1C\x1B\x21\x2B\x06\x01\x0C\x1D\x27\x24\x29\x09\x07\x0D\x10\x00\x13\x2E\x0E\x17\x08\x2A\x0A\x02\x14\x18\x12\x1E\x0B\x2C\x15', #12
        b'\x11\x0F\x26\x0D\x13\x0C\x19\x23\x14\x2E\x1C\x06\x05\x08\x07\x18\x2A\x1B\x22\x0A\x15\x2C\x17\x29\x1F\x28\x0B\x1E\x27\x1A\x0E\x09\x2D\x25\x10\x02\x01\x1D\x20\x12\x03\x16\x24\x21\x2B\x00\x2F\x04', #13
        b'\x15\x0C\x17\x19\x1B\x07\x2B\x05\x1F\x10\x20\x0E\x25\x2C\x2F\x12\x18\x06\x01\x24\x03\x21\x2E\x14\x22\x1E\x0F\x1A\x0B\x13\x23\x29\x2A\x16\x0D\x2D\x09\x1C\x28\x02\x04\x27\x26\x1D\x00\x11\x08\x0A', #14
        b'\x24\x1F\x2E\x26\x2D\x0C\x25\x15\x21\x17\x1E\x04\x0E\x0A\x0D\x11\x09\x07\x08\x29\x18\x12\x14\x02\x0B\x2B\x20\x27\x16\x2C\x2A\x0F\x03\x1D\x10\x19\x06\x01\x13\x1C\x2F\x28\x00\x22\x23\x05\x1B\x1A', #15
        b'\x16\x12\x0D\x14\x22\x15\x27\x01\x1C\x00\x1A\x20\x02\x24\x2D\x1F\x1E\x25\x26\x2B\x03\x18\x0C\x29\x28\x23\x1D\x13\x08\x07\x17\x2F\x0E\x0B\x2A\x2E\x21\x1B\x0A\x11\x06\x05\x2C\x0F\x10\x19\x04\x09', #16
        b'\x14\x2D\x21\x05\x10\x0E\x2F\x27\x22\x15\x09\x28\x07\x13\x23\x08\x1F\x16\x29\x25\x18\x26\x2A\x03\x1E\x2E\x00\x1C\x0C\x12\x2C\x11\x24\x0A\x0B\x06\x19\x20\x17\x0D\x0F\x01\x1D\x02\x1B\x1A\x2B\x04', #17
        b'\x28\x13\x0E\x02\x0A\x19\x1D\x2A\x1C\x25\x08\x09\x1F\x21\x17\x16\x27\x2D\x05\x18\x0F\x22\x20\x2B\x24\x00\x14\x2C\x01\x1A\x0D\x2E\x15\x11\x29\x2F\x04\x0C\x1E\x07\x12\x1B\x0B\x06\x26\x23\x10\x03', #18
        b'\x11\x2E\x21\x1A\x20\x07\x28\x18\x09\x29\x17\x2A\x1B\x16\x14\x1D\x26\x0A\x2B\x25\x05\x06\x08\x2D\x0B\x1E\x12\x24\x10\x0E\x03\x15\x0F\x02\x01\x27\x1C\x00\x2C\x19\x1F\x0C\x22\x23\x2F\x13\x04\x0D', #19
        b'\x14\x26\x1D\x24\x1E\x11\x0A\x16\x00\x18\x20\x2E\x0F\x06\x0C\x1C\x04\x2D\x09\x2A\x0E\x10\x03\x01\x17\x13\x22\x12\x02\x05\x2C\x27\x29\x2B\x23\x1B\x1A\x19\x0B\x2F\x21\x1F\x07\x25\x08\x28\x0D\x15', #1A
        b'\x03\x08\x29\x2C\x22\x2D\x02\x12\x2B\x20\x11\x1A\x26\x1F\x1B\x25\x23\x0C\x19\x27\x00\x13\x0E\x1C\x21\x1E\x0D\x15\x14\x16\x04\x2A\x09\x28\x1D\x07\x01\x0F\x17\x18\x2E\x24\x10\x0A\x05\x2F\x06\x0B', #1B
        b'\x04\x2C\x1F\x08\x27\x1B\x16\x24\x1C\x26\x0E\x13\x23\x21\x00\x14\x18\x07\x20\x06\x05\x1A\x03\x2F\x2A\x12\x1D\x0D\x0F\x2B\x0C\x15\x2E\x2D\x09\x11\x02\x22\x01\x10\x19\x0B\x28\x25\x1E\x17\x0A\x29', #1C
        b'\x1F\x0C\x1E\x20\x2A\x2E\x15\x22\x19\x01\x24\x03\x08\x06\x0A\x25\x12\x29\x21\x17\x11\x16\x2F\x13\x07\x1A\x26\x2D\x0D\x27\x04\x1B\x2C\x18\x00\x28\x10\x14\x1D\x09\x0E\x02\x2B\x0F\x0B\x1C\x05\x23', #1D
        b'\x24\x29\x27\x0F\x10\x06\x0D\x13\x28\x04\x20\x23\x0A\x25\x1E\x2A\x2B\x0E\x1A\x15\x01\x00\x05\x14\x21\x2D\x09\x2C\x12\x03\x2F\x11\x07\x08\x17\x26\x0C\x18\x2E\x0B\x1D\x19\x1F\x22\x02\x16\x1C\x1B', #1E
        b'\x28\x24\x09\x29\x2C\x23\x01\x11\x17\x0A\x1B\x07\x02\x04\x08\x06\x0D\x12\x2B\x0F\x13\x1E\x1D\x22\x0E\x05\x20\x16\x0B\x21\x0C\x03\x25\x14\x1C\x2A\x1A\x1F\x19\x2F\x10\x27\x18\x26\x2D\x15\x00\x2E', #1F
        b'\x1B\x09\x15\x1A\x25\x08\x12\x04\x06\x2B\x1E\x17\x28\x19\x2F\x2D\x18\x14\x0B\x01\x2A\x0D\x10\x20\x07\x29\x0E\x03\x22\x0F\x05\x23\x0A\x11\x2C\x16\x13\x21\x1F\x2E\x1C\x1D\x00\x02\x26\x0C\x24\x27', #20
        b'\x11\x29\x1B\x17\x1D\x06\x27\x03\x04\x0D\x19\x0C\x2D\x00\x22\x28\x16\x23\x08\x12\x25\x02\x13\x0B\x1F\x20\x1E\x1C\x09\x05\x21\x24\x2F\x1A\x26\x0F\x07\x14\x15\x2A\x2B\x2E\x0E\x2C\x0A\x01\x10\x18', #21
        b'\x2B\x08\x17\x2E\x1E\x16\x19\x06\x0B\x07\x27\x1D\x23\x12\x09\x26\x14\x1B\x00\x15\x2D\x01\x2F\x2A\x0E\x1F\x02\x0C\x0D\x21\x11\x2C\x1A\x13\x18\x05\x1C\x29\x22\x10\x25\x0A\x04\x24\x03\x28\x0F\x20', #22
        b'\x1A\x2F\x16\x00\x18\x08\x1C\x2B\x0A\x24\x1D\x17\x29\x21\x0C\x19\x26\x25\x2A\x1E\x07\x1F\x11\x23\x0B\x2C\x03\x2D\x20\x13\x04\x01\x14\x10\x27\x0D\x2E\x0E\x02\x28\x12\x09\x15\x05\x22\x0F\x06\x1B', #23
        b'\x18\x14\x13\x2A\x0E\x2C\x15\x2D\x24\x0B\x27\x2E\x25\x0F\x2B\x29\x01\x03\x05\x2F\x04\x07\x02\x0C\x16\x23\x11\x17\x21\x28\x1C\x20\x22\x08\x1B\x00\x06\x19\x1D\x0D\x1E\x1A\x0A\x09\x10\x26\x1F\x12', #24
        b'\x0C\x22\x14\x06\x2B\x29\x18\x02\x13\x11\x1A\x20\x2C\x1E\x08\x10\x00\x1D\x07\x15\x2E\x12\x1C\x0D\x0A\x1F\x04\x05\x23\x0F\x27\x0B\x19\x25\x03\x09\x17\x21\x28\x2A\x24\x01\x26\x1B\x2D\x16\x2F\x0E', #25
        b'\x2E\x26\x1F\x23\x15\x28\x2D\x04\x1E\x1C\x10\x07\x29\x09\x02\x16\x14\x13\x11\x0D\x2F\x20\x03\x0B\x00\x18\x27\x22\x05\x21\x12\x08\x1B\x19\x25\x2C\x06\x1A\x17\x2B\x01\x0C\x0E\x2A\x0F\x24\x1D\x0A', #26
        b'\x0E\x03\x04\x24\x12\x17\x1B\x18\x2A\x27\x28\x0F\x0D\x02\x08\x00\x21\x2C\x16\x1F\x29\x1A\x09\x2B\x06\x14\x11\x1E\x26\x0A\x05\x2F\x15\x22\x2D\x25\x13\x10\x0C\x1C\x0B\x20\x07\x1D\x2E\x19\x01\x23', #27
        b'\x28\x05\x03\x1F\x27\x0A\x2E\x0F\x02\x20\x22\x1D\x19\x1B\x0B\x15\x0C\x14\x04\x2C\x16\x21\x2F\x09\x23\x12\x07\x10\x25\x24\x2D\x2A\x18\x06\x0D\x1C\x0E\x11\x2B\x29\x26\x1A\x08\x17\x13\x00\x1E\x01', #28
        b'\x03\x1B\x20\x26\x14\x2C\x19\x12\x27\x0E\x1C\x1E\x24\x07\x01\x02\x1A\x18\x1F\x1D\x25\x2F\x28\x21\x10\x05\x0F\x17\x13\x2A\x22\x0A\x0D\x2E\x23\x0C\x04\x00\x16\x2B\x0B\x15\x09\x2D\x06\x29\x11\x08', #29
        b'\x21\x02\x00\x01\x06\x0C\x29\x22\x23\x0D\x14\x2F\x1C\x1E\x26\x12\x1B\x20\x03\x09\x0A\x18\x19\x1F\x11\x0E\x1D\x2E\x07\x16\x1A\x28\x27\x2B\x0F\x15\x08\x0B\x04\x10\x2C\x25\x2D\x24\x2A\x13\x17\x05', #2A
        b'\x0F\x25\x06\x14\x0B\x20\x00\x0A\x2C\x21\x18\x23\x01\x22\x0D\x02\x2F\x2D\x0E\x2B\x24\x13\x11\x07\x19\x26\x29\x15\x04\x2E\x1C\x1B\x28\x1A\x05\x10\x1F\x08\x03\x17\x2A\x1D\x1E\x12\x09\x27\x16\x0C', #2B
        b'\x2C\x2B\x11\x2F\x00\x13\x18\x03\x06\x07\x15\x24\x1C\x16\x0A\x05\x21\x27\x17\x14\x02\x09\x01\x04\x1B\x10\x1E\x0B\x0D\x1A\x29\x2E\x2D\x0F\x0C\x26\x1D\x12\x0E\x22\x23\x19\x08\x2A\x1F\x20\x25\x28', #2C
        b'\x2F\x20\x2A\x05\x01\x26\x13\x0E\x1E\x0A\x06\x02\x1A\x17\x2B\x04\x15\x18\x10\x0F\x21\x27\x25\x1B\x09\x0D\x2E\x28\x1F\x16\x0B\x14\x1C\x12\x24\x00\x07\x11\x08\x2D\x03\x0C\x2C\x1D\x19\x29\x22\x23', #2D
        b'\x07\x2F\x19\x0E\x23\x16\x10\x0C\x24\x20\x0F\x2C\x2B\x02\x03\x06\x12\x0B\x1E\x25\x1A\x08\x17\x13\x0A\x18\x04\x1F\x2D\x1C\x1D\x21\x01\x27\x28\x1B\x05\x22\x29\x0D\x11\x2E\x14\x15\x00\x09\x2A\x26', #2E
        b'\x1D\x03\x2A\x1A\x0E\x15\x25\x04\x29\x07\x21\x01\x13\x20\x0B\x22\x28\x06\x1B\x27\x17\x00\x0F\x1C\x2B\x02\x0A\x10\x1F\x2C\x09\x16\x2D\x05\x2E\x12\x23\x14\x2F\x26\x1E\x18\x0C\x19\x11\x24\x0D\x08', #2F
        b'\x15\x1F\x2E\x1D\x05\x2F\x00\x16\x2D\x2C\x2B\x23\x21\x18\x10\x12\x07\x2A\x03\x1C\x19\x14\x0E\x26\x1A\x20\x22\x0A\x27\x28\x0D\x0C\x1B\x01\x17\x04\x11\x09\x29\x13\x0B\x1E\x08\x06\x24\x0F\x25\x02', #30
        b'\x1C\x1D\x27\x2B\x21\x29\x07\x13\x1F\x0C\x1B\x00\x2F\x26\x14\x19\x09\x2C\x16\x0D\x24\x03\x1A\x10\x0F\x17\x2A\x23\x2D\x0E\x0A\x12\x02\x1E\x2E\x18\x15\x06\x22\x20\x05\x04\x25\x0B\x11\x28\x08\x01', #31
        b'\x0B\x10\x0A\x1C\x24\x27\x2A\x2D\x28\x0F\x03\x23\x2E\x05\x16\x14\x0D\x01\x04\x2F\x1A\x08\x22\x0E\x00\x1F\x29\x21\x1D\x1E\x11\x09\x2B\x25\x06\x19\x2C\x17\x07\x15\x18\x02\x0C\x20\x12\x1B\x26\x13', #32
        b'\x23\x05\x15\x2E\x02\x12\x0E\x21\x17\x11\x0D\x2D\x04\x2B\x22\x13\x1C\x20\x2A\x25\x16\x0A\x28\x03\x06\x0B\x26\x14\x01\x18\x10\x29\x0C\x07\x1A\x0F\x09\x1D\x00\x2C\x1B\x1F\x1E\x08\x19\x27\x2F\x24', #33
        b'\x0E\x14\x24\x07\x17\x04\x1C\x08\x02\x1F\x00\x12\x2C\x1D\x06\x0C\x1E\x15\x2B\x19\x22\x0D\x18\x26\x11\x0A\x2D\x28\x13\x27\x2E\x16\x23\x03\x2F\x2A\x29\x09\x01\x20\x0F\x1B\x25\x21\x1A\x10\x0B\x05', #34
        b'\x0B\x22\x2E\x04\x24\x13\x1A\x26\x1D\x2F\x09\x2A\x08\x15\x0F\x23\x20\x12\x1B\x06\x02\x11\x0A\x1E\x2D\x03\x0C\x1C\x2B\x19\x10\x01\x27\x2C\x0D\x28\x25\x21\x16\x07\x00\x17\x1F\x05\x18\x0E\x29\x14', #35
        b'\x19\x13\x28\x21\x29\x1A\x2E\x0F\x09\x02\x12\x2F\x14\x00\x03\x2B\x17\x27\x01\x10\x11\x0D\x18\x0C\x1F\x2A\x15\x26\x04\x22\x05\x0E\x0B\x23\x20\x0A\x1D\x1B\x08\x1E\x25\x2D\x07\x24\x16\x2C\x06\x1C', #36
        b'\x13\x17\x1C\x1E\x08\x0B\x2F\x29\x0A\x00\x25\x2D\x03\x1F\x02\x22\x01\x12\x2C\x2B\x15\x09\x1B\x11\x24\x0F\x05\x27\x0C\x0D\x28\x16\x19\x1A\x26\x04\x2E\x10\x14\x21\x1D\x0E\x23\x06\x2A\x07\x18\x20', #37
        b'\x21\x16\x2C\x08\x2D\x1F\x28\x00\x2A\x0B\x22\x2E\x10\x2F\x1D\x0D\x1B\x19\x0C\x27\x1C\x20\x17\x15\x01\x29\x24\x1A\x12\x02\x25\x26\x0A\x23\x05\x2B\x0E\x06\x1E\x11\x14\x18\x04\x07\x03\x0F\x13\x09', #38
        b'\x1D\x2E\x2A\x06\x2F\x03\x0F\x1C\x26\x21\x19\x1B\x15\x02\x12\x17\x11\x0C\x20\x14\x1F\x13\x23\x05\x16\x2D\x10\x29\x08\x1A\x22\x01\x27\x24\x2C\x04\x18\x0A\x0D\x25\x07\x09\x00\x0B\x2B\x28\x0E\x1E', #39
        b'\x10\x0E\x25\x22\x03\x17\x01\x23\x16\x0F\x2B\x09\x13\x20\x0A\x00\x1B\x27\x1F\x07\x2D\x11\x24\x2A\x0B\x18\x14\x0D\x12\x08\x1D\x1E\x2E\x06\x26\x0C\x15\x04\x1C\x29\x2C\x21\x19\x28\x05\x2F\x02\x1A', #3A
        b'\x20\x0B\x16\x0F\x15\x29\x04\x1B\x0A\x2A\x01\x2F\x0E\x28\x1C\x2C\x0D\x03\x1D\x2E\x06\x2B\x05\x08\x10\x00\x12\x25\x2D\x0C\x02\x22\x26\x17\x19\x1A\x21\x14\x23\x24\x13\x18\x1E\x09\x1F\x27\x07\x11', #3B
        b'\x13\x0D\x0B\x0E\x2B\x11\x22\x02\x0F\x10\x23\x0C\x06\x1A\x01\x0A\x12\x15\x2D\x27\x07\x1D\x2A\x1B\x1E\x04\x17\x29\x2F\x16\x21\x00\x18\x09\x1F\x20\x28\x03\x24\x14\x05\x08\x25\x2E\x26\x2C\x1C\x19', #3C
        b'\x27\x2C\x20\x21\x2F\x25\x1F\x00\x2E\x16\x05\x26\x08\x0A\x15\x28\x24\x03\x10\x0B\x12\x1E\x0C\x14\x0F\x1D\x01\x2B\x06\x07\x1C\x2D\x02\x1A\x0D\x2A\x18\x0E\x17\x19\x09\x11\x23\x04\x29\x13\x22\x1B', #3D
        b'\x20\x09\x1A\x29\x16\x1B\x05\x1E\x0D\x11\x00\x19\x12\x25\x13\x0C\x0B\x04\x0F\x26\x1D\x1C\x2A\x15\x01\x22\x21\x02\x27\x0E\x2D\x10\x06\x08\x28\x2C\x2F\x2B\x0A\x1F\x07\x2E\x03\x23\x14\x24\x17\x18', #3E
        b'\x0A\x14\x01\x15\x1F\x22\x2E\x2D\x07\x2C\x2A\x29\x13\x1E\x21\x2F\x06\x18\x24\x1A\x0D\x08\x19\x11\x12\x04\x17\x0B\x00\x20\x02\x0C\x05\x10\x09\x26\x27\x28\x0F\x25\x1C\x1B\x2B\x0E\x03\x1D\x16\x23', #3F
        b'\x27\x08\x05\x0D\x15\x0F\x09\x25\x2B\x01\x1D\x11\x1C\x04\x22\x03\x0A\x0E\x13\x17\x10\x28\x00\x26\x06\x20\x2C\x1E\x07\x29\x23\x21\x19\x24\x12\x2D\x2F\x0C\x2E\x14\x2A\x1A\x02\x18\x1B\x1F\x0B\x16', #40
        b'\x11\x1A\x29\x1C\x1B\x00\x0B\x09\x1E\x0E\x1F\x18\x0A\x16\x26\x13\x03\x12\x0F\x2E\x0D\x22\x02\x07\x23\x14\x08\x20\x2C\x27\x10\x28\x17\x2D\x2B\x24\x04\x2A\x21\x06\x0C\x19\x2F\x25\x1D\x01\x05\x15', #41
        b'\x02\x13\x2D\x28\x00\x1A\x01\x2F\x2B\x03\x1C\x14\x22\x26\x24\x2C\x29\x2E\x0B\x19\x1D\x17\x08\x2A\x0D\x1B\x06\x18\x15\x04\x21\x25\x05\x0E\x0F\x27\x07\x20\x09\x23\x16\x12\x11\x1F\x0C\x1E\x0A\x10', #42
        b'\x1C\x2F\x01\x2D\x0A\x0F\x29\x15\x2E\x04\x19\x2B\x1D\x28\x00\x05\x27\x13\x1B\x09\x0E\x23\x2A\x22\x1A\x08\x25\x1F\x24\x17\x18\x07\x1E\x26\x03\x12\x0C\x06\x0B\x2C\x10\x14\x21\x20\x0D\x02\x16\x11', #43
        b'\x20\x0F\x09\x1B\x28\x1F\x02\x1C\x0B\x23\x0C\x25\x04\x22\x27\x11\x2C\x0E\x0A\x24\x29\x1D\x2F\x03\x2D\x17\x06\x07\x18\x10\x05\x15\x26\x2A\x14\x01\x00\x1A\x2E\x12\x1E\x2B\x19\x16\x21\x0D\x08\x13', #44
        b'\x07\x27\x18\x2A\x03\x0F\x29\x17\x15\x11\x20\x14\x26\x05\x19\x23\x2B\x01\x24\x22\x09\x1C\x21\x0A\x25\x00\x1B\x04\x0D\x28\x06\x2C\x1F\x1E\x0C\x08\x2D\x10\x13\x1A\x0B\x0E\x2E\x2F\x1D\x12\x02\x16', #45
        b'\x2E\x2D\x1A\x14\x07\x13\x04\x00\x12\x2B\x26\x0A\x20\x0B\x2C\x0D\x0C\x23\x03\x1D\x27\x01\x0F\x2A\x22\x16\x05\x19\x24\x1F\x18\x0E\x11\x28\x29\x15\x10\x1C\x09\x08\x02\x06\x25\x21\x1B\x17\x2F\x1E', #46
        b'\x2D\x0C\x05\x13\x14\x1A\x12\x0E\x1D\x11\x29\x27\x26\x01\x0B\x19\x21\x07\x10\x2E\x2F\x08\x18\x20\x17\x1F\x06\x15\x2B\x0D\x23\x00\x24\x03\x1C\x1E\x16\x22\x1B\x28\x2C\x25\x0A\x0F\x02\x04\x09\x2A', #47
        b'\x26\x22\x19\x25\x1F\x01\x1C\x1A\x11\x0C\x10\x18\x09\x03\x07\x0D\x24\x20\x08\x27\x2A\x0E\x12\x29\x00\x17\x02\x0F\x2E\x2F\x2B\x1D\x2C\x13\x2D\x0A\x04\x15\x23\x14\x06\x28\x21\x16\x05\x0B\x1E\x1B', #48
        b'\x05\x15\x0A\x1E\x2F\x00\x10\x23\x1B\x25\x16\x22\x29\x0F\x06\x0E\x13\x26\x1C\x09\x1F\x28\x11\x12\x0C\x27\x2B\x24\x17\x2E\x01\x2A\x1D\x2D\x07\x18\x20\x04\x2C\x21\x03\x0B\x14\x19\x0D\x1A\x08\x02', #49
        b'\x10\x0B\x2B\x26\x15\x2A\x02\x19\x13\x29\x06\x21\x24\x18\x16\x22\x14\x2E\x25\x0C\x08\x1B\x27\x05\x0F\x12\x2F\x04\x00\x2D\x07\x09\x17\x0A\x01\x0E\x0D\x1D\x1F\x1A\x23\x28\x1C\x11\x03\x1E\x20\x2C', #4A
        b'\x0B\x0A\x14\x0C\x11\x0F\x09\x03\x06\x1C\x2B\x01\x13\x25\x26\x1B\x19\x04\x21\x1E\x12\x1D\x2D\x0E\x27\x29\x23\x2A\x10\x2F\x1F\x2C\x08\x20\x24\x00\x18\x28\x15\x05\x22\x16\x0D\x17\x07\x02\x1A\x2E', #4B
        b'\x0C\x19\x0B\x18\x1A\x16\x17\x09\x01\x26\x20\x08\x07\x13\x29\x28\x0A\x1D\x0E\x2F\x06\x1B\x11\x04\x2B\x25\x1C\x21\x24\x10\x02\x05\x14\x2C\x23\x12\x0F\x0D\x2A\x03\x00\x15\x2D\x27\x2E\x1E\x1F\x22', #4C
        b'\x02\x09\x1D\x2C\x0C\x1C\x19\x26\x07\x2B\x0B\x0E\x01\x25\x27\x24\x21\x2F\x29\x23\x2E\x22\x13\x1B\x28\x1F\x11\x0A\x14\x03\x08\x1A\x12\x06\x04\x17\x2A\x00\x0F\x0D\x15\x16\x1E\x05\x20\x18\x2D\x10', #4D
        b'\x03\x23\x14\x25\x0E\x0A\x07\x0B\x04\x2E\x00\x22\x16\x1A\x2D\x05\x29\x2A\x18\x12\x1F\x27\x26\x01\x09\x24\x1B\x06\x11\x2F\x10\x21\x02\x1D\x0C\x1E\x2C\x08\x1C\x13\x0D\x2B\x28\x15\x0F\x17\x20\x19', #4E
        b'\x09\x28\x1F\x29\x0C\x26\x1B\x23\x12\x0D\x2F\x11\x20\x2A\x07\x2C\x25\x1D\x1A\x04\x19\x02\x10\x16\x2B\x15\x06\x0B\x05\x22\x2D\x18\x0E\x0F\x21\x03\x1E\x27\x13\x24\x0A\x17\x00\x2E\x08\x1C\x01\x14', #4F
        b'\x1D\x1F\x0D\x0B\x17\x2B\x2D\x0C\x0F\x2E\x07\x28\x01\x21\x10\x1C\x23\x0A\x24\x19\x29\x2A\x02\x09\x26\x0E\x1B\x25\x16\x06\x11\x22\x00\x12\x1A\x15\x05\x2F\x14\x03\x1E\x27\x20\x04\x13\x08\x18\x2C', #50
        b'\x0A\x27\x14\x1E\x05\x04\x1B\x1D\x12\x07\x03\x10\x08\x16\x24\x0C\x22\x09\x15\x1C\x28\x20\x25\x21\x01\x26\x0B\x2F\x1A\x13\x2B\x23\x2E\x2D\x0E\x29\x0D\x17\x00\x18\x11\x2C\x02\x1F\x19\x06\x2A\x0F', #51
        b'\x2A\x1F\x2B\x14\x03\x27\x2E\x01\x11\x1E\x1B\x1A\x25\x00\x15\x23\x21\x19\x18\x29\x0E\x09\x0B\x13\x20\x05\x1C\x12\x28\x2D\x24\x0D\x04\x22\x08\x0C\x17\x07\x2C\x06\x16\x1D\x2F\x0A\x0F\x26\x10\x02', #52
        b'\x1F\x21\x1A\x05\x25\x17\x20\x1B\x0C\x28\x13\x2A\x02\x2D\x1D\x01\x29\x0F\x07\x09\x1C\x19\x04\x14\x15\x11\x23\x0A\x03\x2E\x0E\x00\x22\x2B\x2F\x0D\x12\x26\x10\x1E\x24\x06\x2C\x18\x16\x08\x0B\x27', #53
        b'\x0F\x2A\x05\x00\x28\x2F\x24\x1A\x13\x1C\x2C\x04\x25\x1D\x26\x09\x2D\x15\x08\x2E\x17\x14\x11\x1F\x0E\x12\x19\x10\x18\x0A\x1B\x07\x2B\x0C\x1E\x29\x01\x23\x27\x0D\x16\x03\x06\x20\x0B\x21\x02\x22', #54
        b'\x0D\x1C\x2A\x09\x29\x28\x1A\x11\x14\x19\x16\x1F\x18\x20\x2D\x1D\x27\x2F\x23\x01\x25\x2B\x2C\x0A\x02\x1B\x15\x0E\x21\x10\x00\x24\x07\x0F\x05\x2E\x03\x13\x1E\x06\x0B\x12\x17\x08\x22\x04\x26\x0C', #55
        b'\x2D\x0C\x21\x1C\x11\x06\x07\x2C\x12\x20\x01\x2E\x1F\x18\x04\x0B\x13\x2B\x2A\x2F\x24\x05\x27\x29\x14\x26\x19\x0A\x0D\x23\x09\x02\x16\x1B\x10\x08\x00\x28\x0F\x1D\x1A\x15\x22\x25\x17\x03\x1E\x0E', #56
        b'\x06\x17\x1D\x0B\x19\x1F\x2A\x2F\x29\x15\x0C\x2C\x1A\x04\x0D\x20\x18\x1C\x28\x25\x22\x09\x07\x2B\x21\x14\x0E\x02\x23\x26\x08\x13\x1E\x16\x0A\x05\x27\x11\x1B\x24\x2E\x00\x2D\x12\x10\x01\x03\x0F', #57
        b'\x0E\x1D\x04\x22\x0F\x1B\x2C\x2A\x2B\x06\x09\x0D\x24\x28\x2F\x13\x08\x17\x03\x1E\x05\x02\x2E\x20\x29\x0C\x27\x12\x1A\x07\x1C\x21\x16\x18\x15\x0B\x10\x26\x23\x2D\x01\x19\x0A\x1F\x25\x14\x11\x00', #58
        b'\x0D\x03\x25\x16\x0A\x12\x2A\x19\x10\x04\x0F\x18\x05\x15\x23\x11\x09\x28\x26\x0C\x0B\x13\x22\x1C\x0E\x07\x14\x2B\x29\x27\x06\x2D\x1B\x2E\x1E\x2C\x20\x2F\x24\x17\x02\x1A\x08\x21\x01\x1D\x00\x1F', #59
        b'\x03\x09\x0C\x24\x10\x20\x1F\x25\x0E\x28\x08\x0F\x2C\x19\x16\x18\x22\x06\x2E\x0B\x01\x04\x14\x21\x05\x23\x0A\x00\x2D\x1C\x12\x02\x2B\x13\x1D\x27\x17\x0D\x11\x29\x1A\x1B\x1E\x2F\x2A\x26\x15\x07', #5A
        b'\x05\x0D\x23\x16\x1D\x28\x12\x09\x25\x14\x1A\x1B\x0F\x10\x03\x1E\x15\x2B\x18\x2D\x22\x0E\x0C\x11\x04\x21\x07\x0A\x2C\x0B\x19\x2E\x06\x2A\x08\x17\x01\x1C\x20\x24\x1F\x2F\x02\x00\x29\x27\x26\x13', #5B
        b'\x07\x26\x1C\x2B\x16\x20\x2E\x10\x23\x27\x04\x0A\x02\x14\x17\x19\x1D\x1E\x1B\x01\x0F\x24\x29\x13\x0E\x06\x22\x05\x03\x12\x09\x11\x18\x15\x00\x1A\x08\x2D\x25\x2C\x0B\x28\x0D\x2A\x21\x2F\x0C\x1F', #5C
        b'\x13\x0A\x2F\x0C\x1C\x2D\x1F\x14\x15\x05\x1B\x10\x03\x11\x18\x28\x2E\x21\x0D\x2A\x02\x25\x00\x20\x1D\x08\x19\x0F\x04\x27\x22\x26\x06\x0E\x17\x01\x23\x2B\x1E\x1A\x24\x2C\x09\x29\x16\x0B\x07\x12', #5D
        b'\x26\x17\x2E\x18\x06\x19\x09\x0F\x1B\x28\x05\x27\x16\x23\x1A\x21\x1D\x03\x2C\x24\x20\x14\x25\x2F\x1E\x01\x02\x2D\x1F\x13\x2A\x07\x00\x04\x08\x0C\x12\x29\x0E\x22\x15\x2B\x10\x0B\x0D\x0A\x11\x1C', #5E
        b'\x06\x28\x2B\x07\x18\x1D\x29\x12\x01\x1B\x0E\x03\x0A\x20\x02\x2C\x16\x17\x0D\x1F\x00\x2A\x1E\x05\x04\x0B\x2D\x1A\x26\x23\x2F\x22\x13\x10\x14\x19\x25\x1C\x11\x08\x09\x2E\x0C\x24\x0F\x21\x15\x27', #5F
        b'\x19\x15\x06\x2F\x01\x12\x20\x02\x2E\x07\x22\x14\x17\x1B\x2B\x1A\x08\x21\x1E\x16\x29\x25\x23\x18\x0E\x09\x1F\x26\x2D\x28\x2C\x0A\x05\x1D\x27\x0F\x04\x2A\x10\x00\x0D\x0B\x24\x03\x1C\x0C\x13\x11', #60
        b'\x2A\x21\x19\x2E\x22\x0B\x0D\x1F\x27\x0C\x17\x02\x2C\x0A\x11\x29\x07\x13\x16\x2F\x10\x24\x2B\x14\x20\x1A\x1E\x18\x1B\x06\x00\x01\x23\x04\x15\x08\x0E\x1D\x09\x12\x2D\x0F\x05\x26\x03\x1C\x28\x25', #61
        b'\x1E\x18\x07\x1C\x15\x0C\x2F\x10\x24\x13\x0D\x12\x00\x2E\x14\x0A\x20\x04\x05\x02\x17\x08\x11\x2A\x29\x25\x0B\x16\x19\x23\x27\x2C\x0E\x28\x1F\x21\x1B\x2D\x2B\x1A\x0F\x09\x26\x22\x06\x01\x03\x1D', #62
        b'\x0B\x05\x2C\x1B\x20\x09\x0A\x26\x11\x10\x1F\x03\x2F\x14\x1D\x02\x15\x0D\x2D\x07\x04\x18\x1A\x22\x23\x21\x0E\x12\x2A\x28\x2B\x25\x1E\x29\x24\x19\x00\x27\x1C\x16\x17\x0F\x01\x13\x2E\x06\x0C\x08', #63
        b'\x19\x06\x11\x2D\x0C\x1C\x2A\x28\x05\x1F\x1B\x21\x1D\x0B\x1A\x2F\x07\x01\x0A\x17\x16\x09\x29\x24\x2B\x03\x13\x22\x1E\x08\x20\x10\x0D\x18\x0E\x0F\x02\x26\x27\x25\x00\x2C\x14\x04\x23\x12\x15\x2E', #64
        b'\x2B\x09\x1B\x16\x1C\x0F\x21\x12\x0B\x25\x22\x2D\x27\x08\x28\x0E\x23\x19\x1E\x05\x26\x0A\x15\x14\x2A\x24\x20\x07\x1F\x0D\x18\x11\x10\x0C\x2E\x00\x2F\x01\x1D\x13\x17\x03\x1A\x02\x06\x04\x2C\x29', #65
        b'\x2C\x12\x0F\x0E\x07\x22\x08\x11\x01\x2E\x0C\x1F\x0D\x26\x21\x14\x2F\x03\x1B\x2A\x18\x23\x13\x1C\x05\x25\x28\x17\x2B\x15\x1D\x04\x0B\x09\x1E\x27\x2D\x29\x19\x16\x06\x00\x02\x0A\x24\x20\x10\x1A', #66
        b'\x21\x17\x03\x26\x11\x1E\x22\x2E\x0A\x2B\x2A\x19\x18\x1C\x25\x1A\x20\x23\x07\x29\x02\x2C\x0D\x05\x09\x15\x16\x2D\x06\x04\x0F\x0B\x1F\x0E\x14\x10\x27\x12\x1D\x13\x1B\x08\x01\x2F\x00\x28\x0C\x24', #67
        b'\x04\x00\x28\x0F\x26\x1A\x23\x0D\x2A\x0E\x22\x2B\x06\x14\x29\x03\x25\x01\x1F\x1C\x13\x05\x24\x0A\x0C\x09\x1D\x15\x2F\x11\x1B\x17\x27\x10\x12\x16\x21\x2E\x2D\x19\x07\x1E\x18\x2C\x20\x02\x08\x0B', #68
        b'\x18\x04\x08\x21\x23\x29\x0C\x2B\x07\x1E\x14\x09\x03\x10\x17\x00\x0D\x0F\x15\x22\x20\x0A\x06\x1A\x27\x12\x1B\x26\x19\x25\x28\x0B\x1C\x01\x05\x2E\x11\x16\x2C\x2D\x0E\x13\x02\x2A\x2F\x1F\x1D\x24', #69
        b'\x25\x27\x17\x13\x01\x2E\x16\x19\x0D\x29\x15\x1E\x11\x00\x06\x23\x09\x26\x0B\x07\x0C\x1A\x14\x22\x0A\x20\x1F\x18\x02\x10\x0E\x08\x0F\x12\x21\x28\x2C\x2D\x2B\x24\x1B\x05\x1D\x1C\x04\x03\x2F\x2A', #6A
        b'\x16\x07\x23\x20\x0F\x2B\x2D\x08\x02\x00\x2E\x2C\x22\x25\x13\x19\x04\x18\x15\x06\x0D\x01\x1E\x27\x2A\x21\x29\x0C\x2F\x09\x14\x05\x24\x1B\x0E\x10\x12\x26\x28\x1A\x0B\x03\x17\x0A\x1F\x11\x1C\x1D', #6B
        b'\x24\x06\x0B\x1F\x10\x02\x1A\x21\x25\x16\x1E\x27\x00\x22\x0C\x09\x01\x0D\x19\x0F\x07\x28\x12\x18\x26\x2E\x13\x08\x03\x20\x17\x1B\x2F\x29\x23\x15\x2C\x2D\x1D\x0A\x1C\x2B\x05\x11\x2A\x04\x14\x0E', #6C
        b'\x05\x2F\x09\x1D\x1F\x1C\x20\x0A\x0F\x29\x01\x24\x25\x03\x08\x00\x0C\x21\x1B\x2A\x28\x02\x07\x19\x2C\x0B\x14\x2E\x15\x1E\x23\x13\x04\x17\x16\x10\x2B\x22\x1A\x2D\x27\x26\x11\x0E\x12\x06\x0D\x18', #6D
        b'\x27\x11\x01\x08\x13\x0D\x24\x0F\x1E\x15\x16\x12\x18\x1C\x14\x1B\x28\x20\x03\x04\x0B\x26\x1A\x1D\x17\x07\x2B\x22\x0E\x06\x21\x29\x0A\x02\x10\x2A\x25\x2C\x05\x00\x2E\x2F\x09\x0C\x2D\x1F\x19\x23', #6E
        b'\x24\x09\x04\x0A\x28\x25\x26\x0D\x29\x12\x01\x1C\x17\x14\x23\x20\x02\x05\x13\x2A\x11\x1F\x22\x0F\x06\x2D\x16\x1D\x0B\x2E\x0E\x15\x21\x1A\x19\x0C\x03\x07\x00\x18\x2F\x1B\x27\x10\x08\x1E\x2C\x2B', #6F
        b'\x29\x1A\x1D\x18\x0C\x1F\x04\x11\x03\x25\x26\x02\x28\x15\x16\x01\x00\x07\x22\x12\x0E\x06\x17\x24\x14\x09\x27\x2A\x19\x0A\x21\x2B\x0B\x2C\x08\x13\x0D\x2F\x2E\x20\x10\x1C\x1B\x2D\x1E\x05\x0F\x23', #70
        b'\x13\x03\x2F\x25\x19\x10\x18\x2A\x2C\x2B\x22\x20\x1E\x21\x1A\x14\x04\x29\x11\x0E\x1D\x00\x0C\x06\x2D\x0A\x09\x27\x28\x2E\x23\x1C\x1F\x0D\x02\x15\x1B\x17\x05\x0F\x07\x24\x16\x26\x08\x12\x0B\x01', #71
        b'\x14\x13\x17\x0E\x0C\x21\x02\x1A\x20\x24\x00\x2B\x1B\x1D\x15\x10\x23\x27\x16\x26\x0A\x0B\x1F\x03\x0D\x0F\x08\x2F\x2E\x09\x07\x05\x18\x2C\x19\x25\x2A\x12\x1C\x04\x2D\x06\x22\x29\x01\x28\x11\x1E', #72
        b'\x1C\x26\x12\x2C\x1D\x22\x03\x2B\x23\x2D\x29\x11\x0E\x04\x27\x0A\x1F\x08\x25\x00\x24\x17\x0B\x0D\x01\x2F\x05\x0F\x28\x14\x15\x09\x1A\x20\x0C\x07\x10\x1E\x06\x2E\x19\x2A\x1B\x13\x02\x16\x21\x18', #73
        b'\x25\x11\x07\x10\x1C\x09\x0F\x16\x0A\x17\x24\x1D\x2C\x21\x2E\x20\x05\x19\x23\x14\x13\x1A\x01\x2B\x28\x08\x1B\x06\x1E\x12\x2A\x2D\x0B\x00\x0E\x02\x22\x18\x1F\x15\x0C\x2F\x03\x26\x0D\x27\x29\x04', #74
        b'\x17\x2D\x24\x2E\x26\x1E\x2C\x1B\x09\x27\x0F\x20\x08\x29\x13\x22\x2B\x2A\x1C\x05\x16\x03\x25\x12\x1D\x28\x01\x15\x14\x23\x02\x06\x1F\x0A\x2F\x0B\x11\x21\x04\x0C\x1A\x0D\x19\x10\x0E\x07\x00\x18', #75
        b'\x22\x03\x09\x00\x23\x25\x20\x2D\x1E\x13\x19\x04\x01\x18\x1F\x2A\x26\x08\x07\x21\x2C\x2E\x10\x0A\x02\x24\x0E\x1A\x28\x2B\x06\x0F\x11\x29\x0B\x05\x1C\x12\x16\x2F\x1D\x1B\x14\x0C\x17\x0D\x27\x15', #76
        b'\x07\x11\x0E\x2D\x2E\x03\x15\x24\x10\x06\x05\x1A\x19\x20\x29\x13\x02\x1B\x2C\x00\x0C\x0B\x0F\x01\x09\x21\x18\x1C\x16\x1E\x14\x2F\x23\x26\x1F\x22\x0D\x0A\x17\x28\x12\x27\x04\x25\x2A\x1D\x08\x2B', #77
        b'\x04\x2E\x05\x15\x18\x19\x1D\x2C\x0E\x1F\x1C\x0D\x00\x27\x09\x2D\x23\x2F\x17\x0B\x1A\x21\x10\x22\x03\x11\x20\x28\x0C\x25\x01\x1B\x26\x06\x14\x07\x08\x2B\x0A\x16\x29\x02\x0F\x12\x24\x1E\x13\x2A', #78
        b'\x25\x24\x00\x11\x0E\x22\x17\x2E\x06\x12\x28\x18\x2F\x20\x05\x16\x08\x0F\x1D\x02\x0D\x2D\x27\x2B\x2A\x1E\x26\x03\x07\x0C\x19\x01\x09\x0B\x0A\x29\x14\x2C\x10\x23\x04\x1A\x15\x1F\x13\x21\x1B\x1C', #79
        b'\x2C\x21\x27\x2A\x1A\x0D\x03\x2D\x2F\x02\x0F\x28\x0B\x11\x01\x1F\x0E\x1C\x18\x08\x2E\x19\x24\x15\x23\x17\x22\x20\x00\x0A\x04\x10\x25\x26\x13\x14\x0C\x29\x06\x1D\x1B\x16\x05\x07\x12\x09\x1E\x2B', #7A
        b'\x1A\x1E\x00\x1C\x1D\x21\x2C\x0F\x01\x14\x2E\x0A\x17\x2D\x1B\x10\x11\x0D\x0B\x0E\x19\x05\x23\x09\x12\x2B\x27\x2A\x06\x26\x08\x2F\x0C\x02\x18\x15\x03\x24\x07\x1F\x20\x22\x29\x13\x28\x25\x16\x04', #7B
        b'\x10\x19\x0D\x09\x2A\x12\x01\x2E\x03\x04\x25\x1D\x06\x14\x2C\x07\x00\x2B\x2F\x16\x0F\x1C\x27\x02\x08\x0C\x11\x2D\x05\x1A\x0E\x20\x0A\x29\x23\x18\x1E\x26\x17\x21\x22\x1F\x28\x0B\x24\x1B\x15\x13', #7C
        b'\x22\x04\x20\x12\x10\x2F\x1C\x1B\x01\x2C\x0B\x15\x0F\x1F\x11\x0A\x03\x1D\x16\x0C\x24\x29\x19\x2E\x0D\x14\x2B\x0E\x17\x08\x09\x21\x26\x28\x13\x1E\x07\x18\x05\x2A\x06\x2D\x1A\x00\x25\x23\x02\x27', #7D
        b'\x2A\x2B\x1E\x02\x2E\x27\x03\x0D\x05\x23\x17\x13\x19\x2F\x2D\x21\x1C\x0A\x1D\x1F\x06\x00\x04\x29\x11\x08\x22\x1A\x0E\x26\x28\x12\x09\x15\x25\x0B\x10\x16\x24\x1B\x18\x14\x07\x01\x0C\x2C\x0F\x20', #7E
        b'\x21\x14\x24\x28\x2C\x00\x0F\x17\x1C\x2D\x27\x15\x11\x1B\x18\x1F\x16\x06\x0D\x05\x0E\x2F\x2E\x1A\x03\x01\x0B\x07\x10\x19\x13\x1E\x0C\x29\x04\x09\x1D\x26\x22\x23\x20\x2A\x08\x25\x2B\x0A\x12\x02', #7F
        b'\x02\x07\x15\x29\x25\x0C\x0D\x00\x28\x1A\x0B\x1B\x18\x2C\x03\x11\x23\x27\x1F\x1E\x06\x2E\x21\x24\x08\x05\x22\x2D\x09\x01\x12\x26\x17\x13\x2B\x1C\x14\x0A\x0E\x16\x2A\x0F\x1D\x20\x2F\x10\x19\x04', #80
        b'\x1D\x2F\x22\x08\x29\x18\x05\x0B\x11\x17\x2D\x13\x21\x1E\x12\x2A\x06\x1F\x28\x26\x00\x0F\x1A\x0D\x2E\x0E\x19\x27\x2C\x15\x20\x14\x2B\x03\x01\x02\x09\x24\x07\x0A\x04\x0C\x25\x1C\x1B\x23\x10\x16', #81
        b'\x01\x22\x2F\x19\x2E\x0E\x2A\x14\x12\x1A\x1F\x2D\x0D\x07\x04\x26\x18\x28\x0F\x16\x1B\x17\x09\x11\x29\x10\x0A\x25\x03\x06\x2C\x24\x0B\x27\x02\x13\x2B\x1D\x20\x05\x15\x08\x1C\x1E\x0C\x21\x23\x00', #82
        b'\x1E\x25\x1B\x13\x1D\x21\x2D\x16\x0D\x28\x12\x05\x06\x20\x19\x24\x2E\x03\x14\x10\x07\x26\x22\x1A\x1C\x0B\x0F\x1F\x0A\x17\x15\x0C\x2C\x2B\x2A\x01\x08\x02\x27\x18\x04\x11\x00\x2F\x09\x0E\x29\x23', #83
        b'\x2D\x22\x28\x15\x16\x0A\x09\x05\x0E\x1B\x2C\x07\x2E\x1A\x1F\x04\x01\x29\x00\x19\x23\x11\x08\x10\x25\x0F\x14\x03\x26\x06\x2B\x27\x2A\x0C\x24\x20\x21\x13\x17\x12\x18\x1C\x1E\x02\x2F\x0D\x0B\x1D', #84
        b'\x17\x2E\x01\x16\x2D\x2B\x11\x1F\x27\x08\x23\x00\x18\x06\x0A\x0C\x22\x24\x2A\x1A\x07\x09\x13\x19\x0E\x1C\x12\x15\x1D\x02\x10\x2F\x26\x2C\x03\x1E\x1B\x0B\x25\x0D\x0F\x05\x20\x28\x04\x29\x14\x21', #85
        b'\x2F\x0E\x13\x07\x25\x1F\x2B\x20\x29\x19\x18\x0F\x1E\x27\x2C\x10\x12\x26\x21\x1B\x17\x08\x2A\x11\x24\x06\x2E\x09\x04\x15\x14\x05\x0D\x03\x0C\x01\x1A\x00\x22\x1D\x23\x28\x0B\x02\x1C\x16\x2D\x0A', #86
        b'\x05\x0F\x10\x2D\x29\x07\x22\x08\x18\x0B\x1D\x02\x27\x0E\x01\x13\x2B\x28\x25\x20\x0A\x24\x21\x1E\x17\x2E\x2C\x06\x19\x04\x26\x03\x15\x2F\x11\x0D\x12\x23\x1C\x09\x14\x1B\x16\x1A\x0C\x00\x1F\x2A', #87
        b'\x1B\x2E\x18\x0F\x05\x23\x08\x01\x10\x27\x09\x24\x1E\x12\x1F\x07\x02\x2B\x26\x2D\x0D\x29\x2F\x16\x1D\x17\x04\x03\x13\x28\x25\x1C\x11\x00\x21\x14\x0A\x0B\x2C\x22\x19\x2A\x0C\x20\x15\x06\x1A\x0E', #88
        b'\x07\x20\x2B\x0A\x2D\x21\x1E\x13\x05\x04\x1A\x25\x0B\x01\x26\x09\x19\x1C\x15\x0E\x29\x03\x0D\x2C\x1B\x28\x02\x24\x08\x11\x0C\x22\x12\x2E\x1D\x2F\x10\x17\x0F\x16\x27\x1F\x23\x06\x18\x2A\x14\x00', #89
        b'\x17\x16\x0E\x00\x06\x15\x0A\x1C\x28\x02\x23\x1E\x2A\x03\x22\x11\x07\x1D\x24\x18\x20\x0C\x2B\x25\x2C\x2F\x26\x08\x0B\x1B\x0F\x10\x19\x05\x04\x0D\x27\x13\x1F\x09\x01\x2E\x12\x21\x29\x14\x2D\x1A', #8A
        b'\x23\x10\x2A\x11\x1E\x01\x04\x0A\x25\x03\x1C\x2B\x28\x12\x2E\x1A\x08\x19\x17\x0C\x2F\x14\x06\x13\x29\x0F\x0B\x2D\x0E\x00\x16\x20\x22\x1F\x26\x1D\x02\x24\x21\x18\x07\x27\x05\x1B\x15\x0D\x09\x2C', #8B
        b'\x28\x03\x00\x10\x12\x15\x0F\x1F\x1A\x1C\x2E\x14\x23\x0E\x17\x18\x1E\x07\x06\x0B\x08\x29\x26\x2C\x2D\x20\x25\x02\x0C\x09\x0A\x13\x27\x1D\x05\x24\x2B\x04\x22\x2F\x1B\x16\x01\x11\x21\x2A\x19\x0D', #8C
        b'\x18\x29\x25\x09\x2B\x00\x26\x21\x0C\x12\x17\x06\x1F\x24\x1A\x1C\x05\x14\x16\x20\x1B\x19\x01\x28\x2C\x27\x0D\x22\x10\x2D\x2E\x23\x15\x2A\x03\x1D\x08\x0B\x2F\x0F\x0A\x1E\x02\x0E\x13\x04\x11\x07', #8D
        b'\x08\x16\x07\x2E\x1A\x0C\x27\x2F\x21\x0A\x09\x01\x02\x17\x10\x0B\x11\x22\x23\x26\x28\x2A\x1B\x0D\x04\x1C\x15\x18\x05\x0F\x03\x19\x24\x1F\x29\x1E\x12\x06\x2C\x0E\x13\x1D\x14\x00\x2B\x25\x20\x2D', #8E
        b'\x24\x00\x2A\x10\x09\x0D\x23\x0F\x0B\x17\x02\x1F\x1E\x04\x1C\x12\x2E\x2C\x15\x03\x1A\x16\x20\x28\x25\x05\x01\x11\x18\x19\x22\x1D\x1B\x0A\x21\x29\x13\x0C\x2F\x2D\x06\x08\x26\x14\x07\x0E\x2B\x27', #8F
        b'\x1B\x16\x2D\x05\x15\x2C\x0E\x09\x1D\x08\x26\x19\x24\x01\x13\x1F\x2A\x0B\x06\x02\x12\x0A\x1C\x23\x1E\x07\x10\x20\x21\x00\x2F\x2E\x04\x29\x0C\x22\x2B\x11\x14\x03\x0D\x18\x17\x1A\x27\x28\x0F\x25', #90
        b'\x19\x20\x06\x1F\x0D\x17\x11\x03\x07\x2D\x1B\x2C\x14\x09\x15\x27\x2E\x0E\x22\x04\x18\x10\x0F\x2A\x28\x02\x25\x21\x16\x2F\x00\x1C\x1D\x1A\x0A\x13\x0B\x05\x0C\x12\x23\x1E\x29\x01\x26\x08\x2B\x24', #91
        b'\x1E\x0D\x26\x15\x22\x2D\x14\x25\x23\x2B\x0C\x2A\x04\x24\x12\x01\x28\x2E\x08\x2C\x19\x29\x18\x27\x20\x0E\x03\x0B\x0A\x00\x1F\x16\x2F\x1C\x13\x11\x1B\x06\x1A\x09\x17\x07\x0F\x02\x1D\x05\x21\x10', #92
        b'\x27\x1B\x10\x17\x29\x19\x12\x18\x14\x1C\x11\x06\x21\x28\x0A\x23\x1E\x24\x2B\x04\x20\x01\x1D\x02\x13\x0C\x2E\x0D\x25\x1F\x08\x2C\x03\x07\x0F\x1A\x05\x15\x2A\x26\x00\x09\x2F\x16\x0E\x22\x2D\x0B', #93
        b'\x2C\x1E\x1B\x24\x1D\x2F\x26\x01\x2E\x19\x21\x0E\x23\x07\x17\x27\x14\x10\x11\x28\x22\x03\x04\x18\x16\x1A\x0D\x13\x20\x2A\x0B\x25\x29\x0C\x12\x06\x15\x0F\x1F\x05\x09\x1C\x0A\x08\x2D\x02\x00\x2B', #94
        b'\x0B\x2A\x26\x09\x1C\x0C\x0E\x02\x11\x28\x18\x01\x1B\x20\x08\x15\x2D\x0F\x27\x2C\x1D\x1A\x29\x00\x12\x2F\x2E\x16\x0D\x2B\x17\x10\x21\x19\x07\x13\x06\x04\x23\x0A\x14\x24\x1F\x1E\x25\x22\x05\x03', #95
        b'\x1F\x1E\x2C\x27\x1B\x1C\x24\x0E\x2F\x2A\x07\x0F\x2E\x0B\x11\x28\x02\x17\x25\x08\x12\x23\x19\x0C\x0A\x2B\x03\x18\x16\x21\x22\x14\x10\x01\x05\x1A\x13\x15\x20\x09\x1D\x04\x2D\x06\x00\x26\x0D\x29', #96
        b'\x1D\x05\x1E\x0B\x2E\x13\x08\x26\x14\x2C\x20\x25\x02\x17\x07\x03\x27\x2A\x00\x11\x1C\x0A\x06\x0E\x12\x2F\x16\x19\x10\x29\x0C\x1A\x15\x04\x1F\x24\x28\x2B\x22\x18\x2D\x0D\x1B\x09\x0F\x01\x23\x21', #97
        b'\x29\x09\x22\x04\x13\x1D\x2F\x11\x05\x17\x06\x0A\x2B\x1C\x08\x07\x2C\x1A\x0D\x1B\x03\x24\x00\x2E\x02\x2D\x1F\x26\x20\x14\x19\x0C\x1E\x18\x2A\x10\x16\x0B\x01\x21\x12\x23\x0F\x15\x0E\x25\x27\x28', #98
        b'\x01\x25\x06\x20\x27\x28\x02\x1E\x09\x1C\x17\x2C\x16\x13\x2E\x29\x0F\x1D\x00\x0E\x21\x2A\x24\x1F\x2D\x0D\x11\x12\x14\x19\x15\x2B\x2F\x22\x10\x0A\x0C\x03\x07\x0B\x26\x08\x04\x1B\x23\x1A\x18\x05', #99
        b'\x20\x19\x1F\x11\x0D\x06\x21\x17\x2E\x2B\x1E\x10\x13\x03\x23\x05\x22\x0A\x2C\x15\x0C\x1B\x28\x1D\x1C\x0E\x2D\x02\x29\x2A\x07\x08\x12\x09\x16\x04\x14\x0B\x27\x0F\x24\x2F\x1A\x01\x18\x00\x26\x25', #9A
        b'\x1A\x18\x07\x01\x17\x02\x0D\x04\x0C\x2E\x03\x21\x20\x1D\x09\x2F\x25\x16\x1E\x11\x08\x1C\x19\x12\x27\x00\x0A\x2A\x2B\x24\x0F\x0E\x2C\x26\x1B\x2D\x15\x13\x28\x06\x14\x0B\x22\x23\x10\x29\x05\x1F', #9B
        b'\x01\x2D\x0B\x04\x11\x25\x1B\x0E\x15\x14\x06\x2C\x10\x2F\x1C\x1A\x1E\x00\x21\x02\x16\x12\x07\x0D\x28\x26\x2A\x2E\x19\x22\x29\x20\x03\x24\x1D\x27\x0F\x1F\x18\x0A\x05\x13\x23\x08\x0C\x09\x17\x2B', #9C
        b'\x08\x18\x1D\x0D\x28\x14\x01\x16\x27\x05\x0B\x06\x0A\x03\x12\x09\x13\x10\x00\x19\x07\x1E\x20\x2E\x0F\x0C\x04\x1A\x24\x2A\x25\x0E\x1B\x2F\x11\x1F\x29\x22\x02\x15\x2B\x21\x2D\x1C\x23\x26\x2C\x17', #9D
        b'\x09\x02\x2D\x0B\x10\x06\x25\x2C\x2E\x16\x2F\x1C\x0E\x0C\x18\x08\x14\x13\x04\x27\x03\x2A\x1D\x05\x15\x20\x23\x24\x22\x2B\x26\x0D\x01\x1F\x0A\x1A\x11\x00\x28\x17\x21\x0F\x29\x07\x1E\x1B\x19\x12', #9E
        b'\x08\x09\x0B\x27\x2B\x14\x0E\x03\x13\x20\x1F\x21\x10\x05\x1B\x04\x26\x24\x01\x16\x25\x22\x1E\x15\x1C\x06\x1D\x0F\x17\x0A\x18\x12\x02\x07\x2F\x2A\x2C\x11\x0D\x0C\x19\x23\x2E\x29\x00\x1A\x28\x2D', #9F
        b'\x17\x2F\x25\x19\x22\x29\x13\x2B\x20\x1B\x18\x26\x12\x2E\x07\x27\x04\x0D\x08\x03\x15\x06\x02\x16\x01\x21\x0C\x1D\x0E\x05\x0F\x28\x00\x24\x11\x1E\x14\x10\x09\x0B\x1A\x2C\x1F\x2D\x23\x2A\x0A\x1C', #A0
        b'\x0D\x14\x08\x06\x1C\x1A\x25\x1D\x00\x03\x0E\x11\x16\x07\x10\x23\x18\x2C\x17\x2D\x28\x0F\x15\x20\x1F\x02\x26\x2A\x0A\x12\x13\x2E\x2B\x0B\x24\x22\x1E\x29\x0C\x1B\x01\x21\x27\x2F\x04\x09\x19\x05', #A1
        b'\x28\x12\x05\x2A\x2F\x02\x01\x15\x07\x08\x09\x1C\x1B\x19\x25\x24\x17\x21\x16\x1F\x27\x1D\x14\x1A\x22\x04\x2E\x03\x23\x1E\x20\x06\x29\x18\x11\x0E\x0F\x2D\x00\x2B\x13\x10\x2C\x0D\x0C\x0B\x26\x0A', #A2
        b'\x2D\x0D\x18\x23\x19\x13\x1E\x20\x16\x25\x2F\x14\x27\x1C\x10\x29\x06\x00\x2B\x1A\x1B\x0C\x2E\x07\x1D\x22\x2C\x0F\x28\x26\x01\x24\x12\x0A\x15\x04\x21\x1F\x2A\x17\x0E\x02\x0B\x03\x05\x11\x09\x08', #A3
        b'\x21\x1B\x04\x2E\x09\x1C\x10\x06\x19\x18\x1F\x12\x1E\x0E\x05\x0D\x01\x07\x16\x23\x2C\x26\x2D\x13\x0C\x2A\x2F\x1D\x20\x24\x03\x02\x0F\x00\x14\x0A\x29\x1A\x28\x0B\x17\x25\x08\x22\x27\x2B\x15\x11', #A4
        b'\x18\x10\x2C\x20\x08\x24\x1F\x15\x14\x22\x02\x25\x29\x2A\x2B\x01\x19\x2E\x0C\x03\x16\x06\x21\x2D\x2F\x00\x28\x13\x26\x1B\x11\x12\x23\x0F\x0A\x1D\x27\x07\x17\x1C\x04\x0B\x1A\x1E\x05\x09\x0D\x0E', #A5
        b'\x16\x04\x0C\x07\x02\x23\x01\x29\x2A\x1D\x20\x12\x28\x17\x0A\x1A\x24\x1C\x11\x00\x1B\x13\x0E\x1E\x0F\x15\x21\x08\x27\x0B\x22\x2F\x2B\x0D\x19\x06\x1F\x26\x09\x2D\x18\x10\x2E\x2C\x03\x25\x05\x14', #A6
        b'\x13\x23\x0D\x2D\x00\x09\x0A\x24\x20\x1A\x14\x02\x26\x19\x2F\x15\x06\x0C\x17\x29\x1E\x2A\x27\x2E\x03\x0B\x08\x05\x1F\x22\x16\x12\x25\x1D\x1B\x1C\x2B\x2C\x0F\x07\x21\x0E\x18\x01\x04\x11\x28\x10', #A7
        b'\x10\x04\x2E\x2C\x1F\x12\x0B\x2A\x2D\x21\x24\x27\x0F\x2F\x18\x26\x29\x25\x1B\x28\x00\x1E\x15\x1D\x16\x11\x06\x0D\x13\x1C\x19\x09\x01\x05\x20\x22\x02\x17\x23\x08\x0C\x0A\x07\x1A\x14\x03\x2B\x0E', #A8
        b'\x09\x15\x2C\x20\x02\x14\x10\x06\x1D\x27\x22\x05\x07\x0C\x24\x1C\x17\x01\x13\x08\x2A\x2D\x00\x04\x03\x1B\x18\x2B\x1A\x25\x12\x1E\x21\x0A\x16\x26\x0B\x23\x2F\x29\x1F\x2E\x0D\x0F\x28\x11\x0E\x19', #A9
        b'\x0B\x04\x1F\x27\x07\x10\x29\x0E\x03\x06\x15\x0C\x0A\x00\x21\x2D\x2C\x24\x14\x05\x09\x0F\x1D\x08\x11\x28\x2F\x01\x1E\x02\x2B\x13\x19\x0D\x2A\x1C\x26\x12\x18\x2E\x25\x1A\x17\x20\x23\x16\x1B\x22', #AA
        b'\x12\x0F\x0C\x22\x0E\x04\x27\x28\x25\x18\x05\x2C\x1D\x1C\x02\x10\x00\x17\x06\x20\x03\x2E\x0A\x23\x01\x1E\x19\x21\x15\x09\x24\x2A\x1A\x2B\x0B\x16\x1F\x0D\x08\x1B\x2F\x14\x11\x26\x29\x07\x13\x2D', #AB
        b'\x1E\x0A\x24\x14\x13\x01\x16\x12\x2F\x06\x08\x2E\x0E\x29\x15\x21\x2A\x22\x20\x07\x00\x2D\x1A\x28\x1C\x0F\x17\x03\x25\x04\x09\x19\x0C\x05\x27\x26\x18\x0B\x1F\x02\x1D\x2C\x1B\x11\x10\x2B\x23\x0D', #AC
        b'\x2E\x16\x20\x01\x06\x2B\x1A\x1D\x24\x04\x2C\x17\x13\x26\x28\x09\x05\x2D\x14\x12\x03\x10\x0C\x1B\x29\x11\x21\x07\x15\x1F\x08\x0A\x22\x2F\x1C\x19\x25\x1E\x0E\x2A\x0D\x02\x27\x23\x00\x0B\x18\x0F', #AD
        b'\x15\x20\x05\x0C\x11\x04\x14\x16\x2F\x1D\x1E\x22\x01\x0A\x27\x2E\x0E\x2B\x2C\x1A\x28\x25\x06\x09\x07\x13\x18\x23\x26\x0D\x10\x2A\x1F\x08\x29\x21\x17\x1B\x02\x24\x2D\x19\x0F\x0B\x1C\x12\x00\x03', #AE
        b'\x0F\x1A\x23\x15\x16\x2E\x1D\x0B\x00\x24\x14\x09\x10\x17\x2A\x25\x2B\x1E\x0A\x27\x1F\x26\x05\x2C\x1B\x1C\x0E\x19\x04\x0C\x08\x20\x2D\x13\x28\x18\x02\x07\x12\x03\x11\x22\x2F\x0D\x29\x21\x01\x06', #AF
        b'\x10\x07\x1C\x1F\x02\x20\x2A\x2D\x2C\x03\x2B\x1B\x11\x0C\x26\x29\x00\x0A\x23\x0E\x28\x2F\x04\x16\x01\x17\x2E\x25\x0F\x21\x22\x0B\x14\x05\x0D\x08\x27\x1E\x18\x19\x12\x13\x06\x1D\x1A\x24\x09\x15', #B0
        b'\x09\x25\x19\x02\x2B\x1B\x13\x2E\x17\x01\x15\x2F\x05\x0B\x28\x1E\x0E\x23\x29\x21\x2D\x16\x10\x24\x03\x2C\x0D\x18\x26\x1C\x27\x1A\x00\x1D\x08\x11\x0F\x1F\x04\x14\x07\x12\x20\x2A\x06\x0C\x22\x0A', #B1
        b'\x11\x10\x1F\x09\x05\x1D\x1E\x0B\x02\x2A\x27\x2D\x07\x26\x00\x06\x0F\x20\x0E\x24\x08\x18\x1B\x2C\x21\x13\x03\x15\x23\x04\x14\x0D\x1C\x2F\x19\x17\x28\x1A\x0C\x25\x2B\x01\x22\x2E\x12\x0A\x29\x16', #B2
        b'\x08\x17\x0E\x0B\x22\x02\x13\x14\x04\x1C\x26\x20\x10\x06\x15\x1B\x2A\x0F\x2C\x23\x11\x28\x18\x09\x1D\x24\x2B\x1A\x00\x03\x0D\x2D\x01\x27\x21\x19\x1E\x2E\x07\x29\x1F\x12\x0A\x2F\x05\x16\x25\x0C', #B3
        b'\x18\x02\x05\x23\x0A\x20\x01\x1E\x0D\x06\x2A\x10\x04\x0B\x27\x03\x07\x24\x1A\x1B\x15\x0E\x1C\x25\x0C\x2B\x29\x12\x19\x28\x2F\x09\x08\x2E\x2C\x1D\x14\x1F\x16\x26\x22\x2D\x00\x11\x17\x21\x13\x0F', #B4
        b'\x19\x1A\x27\x02\x28\x14\x17\x12\x18\x11\x03\x26\x2A\x09\x23\x13\x0C\x25\x2C\x0A\x2D\x2E\x01\x00\x04\x1D\x24\x05\x2B\x0E\x20\x1B\x07\x0F\x15\x08\x22\x1E\x2F\x16\x10\x06\x1C\x0D\x0B\x1F\x21\x29', #B5
        b'\x01\x13\x2A\x0C\x26\x07\x20\x22\x04\x17\x15\x03\x16\x0E\x19\x1C\x06\x2D\x24\x1B\x08\x00\x12\x2F\x0D\x1F\x05\x09\x1E\x0B\x25\x18\x28\x23\x1D\x2E\x14\x27\x29\x2C\x1A\x11\x21\x0A\x10\x2B\x0F\x02', #B6
        b'\x25\x11\x13\x1F\x2D\x2E\x00\x0B\x23\x2A\x28\x0D\x1C\x0F\x1B\x27\x18\x05\x1E\x22\x1D\x2C\x2B\x04\x07\x24\x10\x2F\x09\x17\x12\x0E\x0C\x14\x20\x19\x01\x26\x16\x02\x29\x0A\x06\x08\x15\x1A\x21\x03', #B7
        b'\x1C\x0B\x00\x25\x20\x07\x16\x27\x29\x2C\x1A\x03\x21\x2D\x06\x11\x1D\x1F\x19\x10\x09\x23\x18\x15\x04\x1B\x0C\x2E\x2F\x0A\x01\x1E\x26\x13\x02\x0D\x2A\x22\x28\x17\x08\x12\x0E\x14\x2B\x24\x05\x0F', #B8
        b'\x1F\x13\x03\x27\x21\x26\x2D\x0D\x15\x16\x23\x29\x11\x2C\x2B\x1D\x0A\x12\x2E\x0B\x24\x25\x17\x0E\x20\x2A\x0F\x08\x02\x2F\x04\x1A\x1B\x00\x09\x05\x1C\x18\x01\x07\x14\x10\x0C\x28\x06\x22\x19\x1E', #B9
        b'\x2D\x07\x27\x29\x12\x22\x21\x19\x04\x26\x18\x05\x28\x0C\x14\x03\x2A\x1A\x0E\x09\x1E\x16\x2B\x08\x1B\x13\x01\x00\x2C\x23\x1F\x0A\x15\x0B\x25\x0F\x0D\x1C\x06\x10\x2E\x24\x2F\x02\x20\x1D\x11\x17', #BA
        b'\x0E\x1C\x14\x1E\x18\x2D\x08\x13\x15\x1B\x05\x07\x01\x06\x2F\x0B\x0C\x27\x09\x0A\x21\x24\x29\x22\x19\x23\x25\x11\x17\x00\x26\x04\x03\x16\x2E\x28\x2A\x0D\x02\x1D\x1F\x1A\x10\x2C\x12\x2B\x0F\x20', #BB
        b'\x12\x24\x0B\x06\x20\x0A\x28\x02\x10\x18\x27\x0F\x03\x00\x0D\x1B\x13\x0C\x26\x0E\x1C\x09\x1F\x29\x2E\x1D\x08\x23\x1A\x01\x11\x2B\x07\x05\x17\x22\x15\x2A\x2D\x2F\x2C\x16\x1E\x04\x19\x21\x25\x14', #BC
        b'\x0F\x15\x0E\x0D\x14\x11\x2C\x04\x2B\x16\x19\x18\x2A\x23\x1D\x29\x1E\x0B\x2F\x0C\x02\x10\x25\x2E\x1A\x00\x09\x13\x0A\x1F\x28\x03\x12\x06\x27\x26\x2D\x01\x1B\x21\x08\x1C\x20\x24\x22\x05\x17\x07', #BD
        b'\x09\x1D\x2F\x07\x20\x27\x0B\x21\x1A\x1F\x04\x29\x18\x0A\x22\x10\x2A\x05\x15\x2B\x01\x26\x0F\x13\x14\x25\x03\x2C\x02\x08\x06\x1C\x19\x0C\x1B\x00\x0E\x12\x23\x11\x0D\x17\x2E\x16\x28\x1E\x24\x2D', #BE
        b'\x0F\x2F\x07\x08\x19\x15\x23\x20\x12\x2D\x2C\x03\x04\x11\x01\x26\x1D\x0D\x27\x02\x0C\x2B\x0A\x2E\x1B\x05\x16\x18\x22\x13\x17\x0E\x09\x1E\x25\x24\x1C\x0B\x1F\x29\x2A\x28\x21\x06\x14\x1A\x00\x10', #BF
        b'\x03\x2C\x0C\x22\x05\x2B\x29\x11\x19\x12\x07\x1E\x23\x04\x1D\x1F\x26\x1A\x02\x0D\x15\x0B\x13\x10\x21\x18\x17\x08\x28\x2D\x09\x14\x06\x25\x16\x00\x0E\x24\x0F\x01\x27\x2F\x0A\x1B\x1C\x2E\x2A\x20', #C0
        b'\x26\x2D\x14\x01\x1B\x24\x07\x20\x05\x1D\x11\x12\x21\x29\x0D\x0A\x19\x17\x13\x22\x0C\x28\x09\x1A\x15\x27\x2A\x0B\x2C\x02\x2F\x16\x2E\x06\x1E\x0E\x03\x00\x10\x04\x08\x18\x1C\x0F\x23\x2B\x25\x1F', #C1
        b'\x20\x2E\x2D\x11\x21\x19\x25\x0E\x24\x1E\x06\x13\x05\x23\x28\x12\x29\x2A\x07\x0A\x00\x18\x1B\x27\x2C\x22\x10\x16\x01\x08\x17\x03\x14\x0D\x04\x2B\x0C\x15\x0F\x1D\x09\x1F\x02\x2F\x0B\x1A\x1C\x26', #C2
        b'\x25\x26\x0E\x1D\x11\x0A\x1C\x1F\x19\x1A\x03\x09\x1B\x08\x24\x29\x0B\x22\x01\x04\x17\x02\x23\x1E\x2D\x2E\x05\x14\x18\x15\x27\x21\x2C\x00\x06\x20\x2F\x28\x0D\x16\x2B\x07\x10\x12\x2A\x13\x0F\x0C', #C3
        b'\x07\x28\x12\x19\x1B\x0B\x23\x15\x26\x25\x0C\x2D\x16\x0A\x1E\x21\x1A\x02\x03\x0F\x2A\x04\x1F\x10\x2B\x06\x2F\x0E\x01\x14\x2E\x0D\x17\x2C\x09\x18\x22\x13\x11\x00\x29\x1D\x24\x05\x27\x20\x1C\x08', #C4
        b'\x0C\x14\x08\x0A\x02\x09\x05\x23\x24\x01\x0B\x10\x27\x03\x11\x1D\x1F\x2F\x1C\x22\x13\x21\x29\x16\x00\x20\x28\x19\x18\x15\x0E\x07\x06\x2A\x1A\x26\x0F\x2C\x25\x2B\x17\x0D\x04\x2D\x12\x2E\x1B\x1E', #C5
        b'\x25\x03\x1E\x21\x1F\x06\x0E\x10\x1B\x0C\x02\x26\x23\x1C\x2E\x24\x01\x16\x28\x0D\x07\x13\x1D\x2D\x19\x0A\x22\x2A\x2F\x11\x29\x20\x08\x0B\x2C\x14\x09\x0F\x04\x00\x15\x17\x2B\x27\x1A\x05\x12\x18', #C6
        b'\x14\x0F\x2D\x19\x26\x22\x1E\x0D\x17\x02\x06\x24\x2B\x09\x2A\x18\x11\x03\x2F\x16\x10\x29\x1C\x20\x15\x27\x13\x01\x23\x2E\x00\x0E\x12\x2C\x1A\x07\x04\x0A\x0B\x1F\x05\x21\x08\x28\x25\x1D\x0C\x1B', #C7
        b'\x0C\x1F\x24\x13\x07\x2D\x1A\x2C\x01\x10\x25\x1D\x02\x0B\x16\x27\x1C\x1B\x20\x22\x29\x12\x26\x1E\x23\x08\x18\x28\x2F\x0D\x06\x03\x21\x19\x2B\x17\x0A\x14\x00\x2E\x15\x04\x05\x0E\x11\x0F\x2A\x09', #C8
        b'\x24\x1C\x11\x01\x16\x1E\x0C\x0D\x2E\x26\x18\x17\x09\x1D\x0F\x13\x03\x1F\x29\x15\x1B\x27\x23\x0A\x2A\x04\x05\x1A\x22\x12\x14\x10\x00\x0E\x2F\x02\x07\x19\x2B\x08\x2C\x20\x06\x0B\x2D\x25\x21\x28', #C9
        b'\x22\x00\x12\x14\x11\x0B\x15\x24\x28\x2F\x23\x10\x03\x1A\x1F\x1E\x2B\x2E\x13\x1D\x21\x18\x0A\x0F\x08\x25\x02\x2A\x1B\x2C\x01\x05\x26\x07\x2D\x06\x17\x16\x29\x0E\x27\x09\x19\x1C\x0D\x04\x20\x0C', #CA
        b'\x27\x1E\x1A\x22\x17\x11\x24\x20\x1F\x19\x0D\x05\x10\x2D\x09\x2B\x13\x01\x04\x1C\x00\x0B\x2C\x28\x06\x29\x2A\x1D\x23\x0F\x0C\x2E\x1B\x18\x08\x02\x0A\x03\x21\x26\x0E\x16\x12\x25\x15\x2F\x14\x07', #CB
        b'\x1B\x0E\x07\x02\x12\x25\x1E\x15\x2D\x10\x13\x0A\x14\x22\x20\x06\x19\x2F\x2C\x21\x1D\x11\x09\x26\x2B\x17\x08\x1C\x0B\x18\x16\x27\x29\x24\x00\x0D\x23\x2A\x01\x1A\x2E\x0F\x03\x1F\x28\x05\x04\x0C', #CC
        b'\x1C\x17\x0C\x05\x25\x06\x2C\x22\x07\x27\x10\x09\x2B\x19\x0B\x15\x1B\x18\x14\x04\x2F\x1E\x0E\x08\x13\x1D\x03\x24\x0F\x1A\x21\x11\x28\x2A\x23\x1F\x2D\x02\x12\x01\x29\x00\x16\x2E\x20\x0D\x0A\x26', #CD
        b'\x1F\x29\x1A\x1D\x0F\x07\x14\x24\x1B\x18\x2F\x21\x15\x12\x06\x04\x11\x05\x0E\x27\x02\x0C\x0B\x10\x2A\x16\x28\x2C\x20\x1C\x2E\x0A\x1E\x0D\x00\x17\x25\x2D\x22\x23\x26\x2B\x19\x01\x08\x09\x13\x03', #CE
        b'\x0C\x15\x1C\x1A\x1E\x2C\x1D\x00\x19\x02\x2B\x0A\x04\x26\x25\x21\x1B\x28\x10\x16\x23\x22\x2E\x07\x11\x0F\x0D\x09\x08\x2D\x20\x13\x03\x0B\x1F\x01\x2F\x18\x06\x0E\x24\x2A\x12\x05\x17\x29\x14\x27', #CF
        b'\x26\x0B\x13\x23\x2F\x2D\x17\x1F\x16\x0F\x21\x20\x14\x15\x2A\x1E\x1C\x0A\x25\x00\x27\x0D\x12\x04\x1A\x0C\x07\x08\x1B\x03\x0E\x2C\x24\x22\x2E\x11\x02\x09\x10\x01\x05\x19\x2B\x29\x28\x06\x18\x1D', #D0
        b'\x1A\x20\x1C\x04\x1F\x2B\x07\x06\x22\x11\x2F\x00\x01\x18\x15\x28\x19\x0C\x17\x1B\x0A\x16\x05\x0F\x23\x29\x0B\x2C\x03\x10\x27\x08\x2A\x24\x12\x02\x0D\x1E\x1D\x0E\x14\x2E\x09\x2D\x25\x21\x26\x13', #D1
        b'\x1F\x19\x23\x1B\x01\x08\x15\x10\x0D\x1D\x2A\x13\x17\x22\x07\x26\x1A\x09\x04\x06\x2C\x24\x27\x0A\x0B\x1E\x05\x25\x0E\x03\x20\x0C\x02\x28\x2B\x2D\x0F\x2E\x12\x11\x2F\x1C\x21\x29\x16\x00\x14\x18', #D2
        b'\x2B\x02\x19\x14\x25\x15\x1B\x05\x1E\x23\x00\x2E\x03\x26\x10\x2D\x22\x1F\x29\x0A\x09\x21\x07\x1C\x2C\x16\x01\x04\x2A\x0D\x0C\x1D\x1A\x08\x0F\x20\x0B\x24\x0E\x2F\x12\x11\x28\x17\x27\x18\x06\x13', #D3
        b'\x2C\x00\x21\x28\x24\x1D\x0C\x23\x15\x18\x2E\x22\x04\x07\x13\x20\x1F\x29\x27\x1E\x19\x1B\x2B\x0D\x14\x06\x12\x26\x08\x0A\x25\x2D\x01\x17\x03\x0F\x05\x02\x11\x1C\x2F\x0E\x16\x1A\x2A\x10\x09\x0B', #D4
        b'\x24\x21\x06\x20\x0E\x2C\x05\x2E\x1D\x14\x19\x11\x2B\x1E\x2A\x26\x03\x02\x23\x04\x27\x09\x17\x25\x29\x28\x00\x0C\x13\x08\x0D\x1A\x0F\x2D\x15\x01\x1F\x1B\x0A\x18\x1C\x2F\x22\x07\x0B\x16\x12\x10', #D5
        b'\x04\x0F\x20\x10\x19\x0A\x02\x11\x25\x01\x26\x12\x2E\x2D\x1E\x08\x15\x06\x2A\x2F\x00\x0D\x29\x2C\x0C\x2B\x23\x1F\x07\x0E\x13\x18\x17\x27\x16\x22\x28\x05\x1B\x1C\x09\x0B\x21\x03\x1D\x14\x1A\x24', #D6
        b'\x1E\x2C\x06\x1B\x21\x0B\x13\x12\x00\x22\x0F\x14\x15\x0C\x1A\x1C\x0D\x26\x07\x11\x2B\x01\x24\x1D\x25\x23\x16\x0A\x2E\x20\x05\x02\x04\x19\x08\x03\x29\x27\x17\x0E\x2A\x2D\x28\x10\x1F\x18\x2F\x09', #D7
        b'\x1C\x08\x0F\x0C\x06\x13\x2D\x04\x01\x23\x14\x27\x28\x2A\x10\x17\x00\x1E\x26\x03\x05\x0A\x20\x11\x19\x02\x2F\x09\x25\x18\x07\x1B\x22\x0D\x0B\x21\x2E\x2C\x2B\x1F\x24\x12\x15\x1A\x0E\x1D\x29\x16', #D8
        b'\x1A\x15\x08\x1D\x2D\x06\x12\x1E\x2B\x2A\x29\x07\x2C\x2F\x25\x2E\x03\x09\x02\x20\x0D\x0B\x04\x27\x24\x28\x01\x19\x00\x1B\x18\x0F\x13\x0E\x0A\x16\x17\x11\x1C\x10\x22\x05\x1F\x0C\x21\x23\x26\x14', #D9
        b'\x2F\x2C\x1C\x28\x2A\x21\x0F\x13\x16\x01\x18\x04\x12\x15\x09\x24\x0D\x1E\x03\x2D\x23\x07\x00\x05\x29\x1D\x25\x17\x27\x06\x1F\x19\x10\x11\x14\x2B\x0E\x1A\x1B\x0C\x0A\x20\x22\x08\x2E\x0B\x02\x26', #DA
        b'\x0E\x2B\x16\x2A\x1F\x23\x2C\x15\x12\x00\x10\x17\x05\x13\x11\x02\x20\x2E\x1A\x25\x0C\x2F\x04\x06\x08\x0D\x1D\x14\x07\x24\x1B\x1E\x03\x19\x01\x2D\x0A\x1C\x27\x21\x09\x22\x0B\x28\x26\x18\x29\x0F', #DB
        b'\x1C\x29\x2C\x0A\x26\x16\x2F\x01\x0E\x24\x1D\x1E\x13\x06\x12\x2E\x08\x1A\x10\x18\x2B\x22\x0D\x27\x04\x15\x00\x07\x02\x19\x2A\x20\x17\x28\x11\x14\x05\x1F\x03\x0F\x23\x25\x21\x0B\x2D\x0C\x1B\x09', #DC
        b'\x06\x0A\x24\x18\x2D\x10\x00\x1C\x26\x28\x04\x23\x09\x1D\x1F\x05\x21\x1E\x14\x17\x0D\x2A\x07\x1B\x27\x0E\x2B\x2C\x20\x11\x1A\x2F\x25\x13\x02\x22\x0F\x0C\x0B\x15\x16\x08\x01\x19\x03\x2E\x12\x29', #DD
        b'\x2E\x22\x19\x10\x1C\x03\x21\x2C\x0F\x2F\x1B\x28\x06\x2A\x25\x11\x16\x00\x09\x2B\x1F\x0C\x2D\x0E\x02\x07\x15\x1E\x14\x05\x26\x17\x1A\x04\x18\x27\x08\x12\x01\x29\x23\x20\x0A\x13\x1D\x24\x0B\x0D', #DE
        b'\x22\x2B\x01\x16\x27\x0E\x0B\x19\x21\x26\x2E\x1D\x1F\x12\x1A\x23\x1B\x0A\x08\x1E\x03\x28\x17\x2D\x07\x0F\x05\x20\x04\x2F\x2C\x29\x0D\x25\x06\x15\x14\x0C\x2A\x13\x09\x00\x18\x10\x02\x1C\x24\x11', #DF
        b'\x06\x11\x22\x04\x20\x2A\x0A\x0C\x17\x00\x01\x29\x08\x19\x1B\x03\x26\x15\x27\x2E\x1F\x21\x28\x18\x05\x1D\x0B\x0E\x12\x25\x14\x0D\x2C\x0F\x2B\x2F\x07\x16\x24\x1E\x1C\x10\x13\x1A\x23\x02\x2D\x09', #E0
        b'\x08\x22\x03\x24\x21\x1A\x19\x27\x09\x01\x00\x0D\x2B\x29\x2A\x28\x2D\x0C\x11\x14\x26\x0B\x2F\x1B\x0A\x25\x23\x0F\x15\x05\x1C\x16\x13\x1E\x1F\x1D\x06\x2E\x12\x17\x04\x07\x10\x0E\x18\x20\x2C\x02', #E1
        b'\x1C\x1E\x24\x00\x07\x25\x04\x06\x2D\x0E\x18\x2E\x12\x20\x17\x2F\x22\x0B\x0D\x19\x02\x27\x28\x2C\x1B\x2A\x29\x09\x03\x14\x26\x2B\x05\x23\x10\x11\x01\x0C\x0A\x13\x1F\x21\x16\x1D\x15\x08\x1A\x0F', #E2
        b'\x26\x18\x2C\x05\x19\x11\x23\x2E\x21\x15\x01\x0D\x0B\x25\x2D\x0E\x1A\x27\x22\x06\x1E\x29\x09\x1C\x16\x20\x13\x0F\x1D\x04\x2A\x0A\x2B\x14\x07\x03\x02\x10\x08\x28\x12\x1B\x1F\x0C\x24\x2F\x17\x00', #E3
        b'\x02\x1A\x13\x23\x00\x25\x21\x10\x1C\x0B\x08\x17\x0D\x2B\x27\x04\x0A\x28\x0C\x29\x01\x19\x18\x14\x11\x16\x1E\x0E\x05\x24\x1D\x2F\x2A\x12\x06\x22\x20\x15\x03\x1F\x1B\x26\x0F\x2C\x2D\x07\x09\x2E', #E4
        b'\x29\x26\x2E\x13\x28\x16\x05\x14\x2B\x0D\x07\x0E\x08\x22\x1F\x0C\x04\x19\x20\x2F\x09\x0F\x10\x06\x24\x0B\x15\x23\x1B\x2D\x1A\x12\x18\x00\x17\x25\x01\x0A\x21\x11\x1C\x02\x1D\x1E\x27\x2A\x2C\x03', #E5
        b'\x02\x05\x16\x06\x00\x2C\x17\x19\x0C\x13\x2B\x1F\x1D\x11\x04\x0E\x0D\x09\x1E\x15\x2A\x23\x14\x0A\x2D\x28\x18\x1C\x2E\x26\x29\x1B\x01\x03\x12\x20\x1A\x24\x0F\x21\x25\x10\x2F\x27\x07\x22\x0B\x08', #E6
        b'\x1D\x25\x27\x29\x09\x08\x02\x2A\x10\x22\x2E\x1E\x20\x0B\x00\x26\x1C\x18\x13\x03\x28\x2B\x2C\x1A\x17\x23\x0C\x2F\x0D\x04\x0A\x06\x2D\x16\x01\x14\x1F\x0F\x11\x19\x21\x05\x0E\x15\x24\x12\x07\x1B', #E7
        b'\x01\x09\x1D\x2D\x26\x15\x2C\x06\x17\x29\x12\x0D\x1C\x23\x21\x0A\x0B\x10\x28\x20\x27\x08\x0C\x02\x2E\x2A\x1E\x03\x11\x19\x13\x04\x22\x1B\x0F\x25\x1A\x2F\x14\x00\x16\x24\x05\x07\x18\x1F\x2B\x0E', #E8
        b'\x1D\x18\x10\x12\x13\x1C\x1A\x2B\x06\x16\x02\x22\x0F\x11\x14\x17\x2D\x05\x07\x28\x23\x19\x27\x2C\x08\x15\x1F\x2A\x1E\x00\x0A\x25\x1B\x09\x0D\x2F\x0B\x03\x0E\x01\x20\x0C\x21\x24\x04\x2E\x26\x29', #E9
        b'\x27\x20\x21\x01\x1A\x11\x2B\x2A\x0D\x14\x0C\x15\x03\x1B\x2F\x10\x07\x23\x05\x16\x1F\x13\x0B\x08\x00\x17\x2D\x06\x09\x1E\x2E\x2C\x18\x0F\x25\x29\x12\x04\x19\x1C\x24\x0A\x1D\x0E\x02\x26\x28\x22', #EA
        b'\x05\x2D\x23\x27\x08\x29\x0A\x25\x2A\x19\x12\x1C\x2E\x01\x20\x1B\x0E\x10\x1A\x26\x2B\x1E\x28\x22\x09\x11\x18\x1F\x00\x24\x03\x06\x13\x04\x17\x2C\x14\x1D\x0D\x07\x2F\x15\x16\x02\x0B\x0C\x0F\x21', #EB
        b'\x1B\x00\x09\x2F\x1E\x07\x2D\x2C\x1A\x2A\x0F\x06\x0B\x10\x21\x1D\x17\x08\x26\x1C\x25\x0E\x0D\x19\x05\x15\x11\x04\x03\x13\x14\x2B\x0C\x18\x02\x28\x29\x20\x1F\x12\x2E\x23\x0A\x24\x27\x16\x22\x01', #EC
        b'\x23\x16\x0C\x26\x20\x24\x0B\x28\x2D\x1C\x18\x13\x0E\x1B\x2F\x1E\x01\x2C\x1D\x09\x17\x0A\x12\x00\x2E\x04\x15\x22\x07\x29\x08\x25\x1F\x10\x2B\x06\x11\x02\x0D\x0F\x19\x05\x1A\x27\x21\x14\x03\x2A', #ED
        b'\x07\x2D\x1F\x17\x23\x22\x13\x12\x02\x25\x1A\x2F\x1B\x04\x29\x2B\x1C\x05\x24\x26\x1E\x11\x03\x06\x19\x0D\x28\x0C\x2A\x27\x0A\x10\x1D\x14\x0F\x0B\x2C\x20\x18\x15\x08\x16\x00\x09\x2E\x21\x0E\x01', #EE
        b'\x04\x21\x10\x0D\x2E\x08\x1B\x0B\x0F\x03\x05\x01\x20\x24\x16\x0E\x1A\x06\x02\x0C\x2D\x27\x1D\x11\x0A\x25\x12\x17\x18\x26\x2F\x19\x29\x23\x2A\x15\x00\x28\x1E\x14\x2C\x1F\x13\x22\x09\x07\x2B\x1C', #EF
        b'\x2F\x23\x2A\x27\x0A\x17\x2E\x19\x24\x08\x10\x2D\x00\x0B\x0C\x20\x11\x1D\x14\x28\x02\x16\x13\x12\x1E\x09\x1F\x25\x0E\x07\x1C\x26\x2B\x1B\x18\x06\x21\x29\x1A\x0F\x04\x03\x22\x15\x05\x2C\x01\x0D', #F0
        b'\x1F\x0A\x0B\x2A\x2E\x13\x25\x18\x0D\x28\x1D\x1C\x2F\x0F\x15\x22\x04\x23\x27\x14\x29\x0E\x1E\x21\x10\x01\x08\x11\x1B\x02\x2D\x17\x05\x20\x00\x19\x26\x2C\x06\x03\x2B\x0C\x16\x12\x1A\x07\x24\x09', #F1
        b'\x27\x12\x0C\x17\x2A\x11\x20\x2E\x18\x29\x08\x22\x13\x2F\x0B\x1F\x02\x26\x28\x1E\x2C\x06\x19\x03\x1A\x16\x0D\x25\x24\x01\x2B\x05\x1C\x15\x1B\x0A\x00\x1D\x07\x23\x09\x2D\x10\x14\x0F\x04\x0E\x21', #F2
        b'\x1E\x0C\x0D\x08\x2B\x28\x0B\x2A\x22\x0F\x13\x19\x27\x05\x23\x12\x24\x09\x0A\x1F\x1D\x18\x02\x2C\x06\x10\x07\x0E\x14\x17\x04\x1A\x16\x11\x03\x1C\x25\x29\x1B\x26\x2D\x21\x01\x15\x2F\x2E\x00\x20', #F3
        b'\x09\x02\x2C\x2D\x14\x2F\x11\x0F\x0C\x07\x23\x2A\x21\x27\x25\x04\x1D\x0E\x0D\x05\x06\x0B\x01\x1E\x1F\x26\x10\x00\x08\x16\x1C\x29\x12\x28\x1A\x1B\x2E\x2B\x15\x03\x18\x22\x0A\x19\x20\x17\x24\x13', #F4
        b'\x18\x28\x2F\x05\x00\x16\x15\x0B\x03\x23\x07\x01\x11\x2E\x1C\x06\x13\x2D\x1A\x14\x27\x22\x21\x29\x0F\x2C\x0A\x08\x12\x20\x0C\x17\x1E\x2B\x1D\x10\x19\x1B\x0D\x09\x02\x2A\x04\x0E\x24\x1F\x26\x25', #F5
        b'\x1A\x11\x2C\x07\x06\x1E\x27\x2F\x28\x14\x16\x0C\x26\x2B\x20\x05\x2A\x0F\x0A\x24\x1C\x17\x2D\x1F\x22\x08\x12\x29\x13\x01\x0B\x09\x04\x2E\x00\x25\x1B\x02\x21\x19\x23\x0D\x18\x03\x10\x15\x0E\x1D', #F6
        b'\x06\x0F\x07\x25\x0A\x04\x13\x18\x27\x03\x2C\x05\x1E\x10\x09\x2E\x24\x02\x0C\x12\x11\x2A\x01\x0B\x17\x1F\x2F\x16\x08\x28\x19\x14\x2B\x2D\x1D\x0E\x20\x21\x0D\x1C\x15\x00\x1B\x29\x1A\x22\x23\x26', #F7
        b'\x0F\x26\x17\x16\x07\x1D\x10\x0C\x00\x12\x02\x08\x20\x27\x1E\x05\x28\x04\x2F\x2C\x18\x22\x1A\x29\x0B\x1B\x11\x0D\x23\x21\x15\x24\x25\x1F\x0E\x06\x0A\x2E\x01\x2A\x14\x03\x1C\x09\x19\x2B\x13\x2D', #F8
        b'\x28\x11\x19\x1B\x06\x18\x16\x23\x1F\x0B\x27\x10\x09\x24\x1C\x25\x00\x26\x0E\x0D\x0A\x05\x2E\x21\x29\x2F\x2D\x03\x0F\x08\x2A\x01\x1E\x02\x17\x2B\x13\x14\x12\x07\x22\x0C\x20\x15\x1D\x04\x1A\x2C', #F9
        b'\x2D\x2C\x00\x12\x29\x23\x2B\x1F\x26\x1A\x1C\x0E\x11\x2E\x0D\x19\x1B\x1D\x22\x2A\x0F\x04\x03\x28\x24\x07\x09\x10\x16\x1E\x06\x20\x02\x01\x08\x0B\x0C\x21\x0A\x05\x13\x14\x15\x2F\x18\x27\x25\x17', #FA
        b'\x22\x0E\x26\x2F\x02\x17\x25\x1C\x14\x12\x27\x20\x08\x05\x1E\x07\x24\x15\x28\x0C\x10\x00\x18\x11\x09\x0B\x1B\x2D\x29\x0F\x01\x0A\x03\x2A\x06\x21\x13\x2B\x19\x23\x16\x2C\x0D\x2E\x1F\x1A\x04\x1D', #FB
        b'\x02\x28\x17\x0D\x2A\x19\x2E\x22\x0B\x04\x08\x1C\x0A\x10\x20\x03\x15\x21\x23\x06\x1B\x2D\x1D\x0E\x14\x2C\x24\x29\x11\x09\x16\x2B\x12\x26\x2F\x0F\x1F\x1A\x27\x01\x07\x05\x25\x1E\x00\x13\x0C\x18', #FC
        b'\x15\x0B\x18\x00\x1F\x1D\x2B\x2F\x23\x28\x14\x07\x24\x27\x05\x0E\x16\x12\x11\x02\x2A\x01\x25\x08\x29\x0D\x1C\x13\x0C\x2C\x22\x06\x21\x09\x1B\x1E\x0F\x0A\x2D\x20\x2E\x04\x1A\x03\x17\x19\x10\x26', #FD
        b'\x16\x1B\x2F\x17\x0C\x03\x1A\x2E\x26\x0B\x0D\x10\x12\x18\x2C\x08\x28\x0A\x2A\x00\x1D\x2B\x1F\x0E\x04\x01\x27\x20\x1E\x11\x24\x09\x05\x06\x14\x21\x2D\x07\x15\x02\x1C\x23\x29\x0F\x25\x13\x22\x19', #FE
        b'\x12\x19\x21\x04\x2B\x24\x0F\x1C\x10\x05\x08\x11\x22\x1E\x1D\x2D\x15\x07\x2E\x18\x28\x1A\x1B\x2A\x25\x0E\x20\x1F\x06\x0C\x2C\x16\x29\x0D\x0A\x0B\x23\x03\x00\x17\x26\x13\x2F\x14\x27\x01\x02\x09'  #FF
    )

    __TABLE_RND = (
        b'\x6E\x14\xD3\xF6\x3E\xBE\x46\x8D\x3A\xA3\x72\x3D\xD3\x1A\x79\xF7\xB3\x82\xA9\x24\xF5\x1C\xAA\x7F\xA1\x4A\x56\x60\x6A\xC5\xBD\x72\xAE\x0C\xFA\xAD\xBF\x12\x47\x3A\x73\xF0\xDD\xA5\x9F\xF1\x3C\xF2', #00
        b'\xFC\xF4\xD6\xBC\x22\x2C\x6F\x5A\x40\xF9\xD3\x02\x32\xDF\x0A\x35\xF3\x78\xEB\xD2\xF5\x74\xE5\xBB\x02\x45\xCE\x76\xB1\xC4\xE2\xFD\x5A\x37\xDB\x52\xE8\x94\x25\x24\xE4\x23\x18\xB4\x40\xEC\x1A\x32', #01
        b'\x33\x18\xF8\xC3\xB5\xFB\x4D\x76\xCC\x39\xFD\x3C\x47\x99\xD6\xC2\x1D\x30\xFA\x28\x7D\x8A\x01\x01\xCC\x72\x89\x3F\xFC\x19\x6F\x6E\x51\x62\xBE\x36\xEB\x3B\x1C\xE0\xCD\xE5\xDB\x14\x72\xB6\x39\xDB', #02
        b'\xDC\xFA\x5F\x08\x6D\xDE\xA4\x94\x34\x20\x4E\x91\x22\xDC\x4D\xE7\x46\x9E\x50\xD9\xC0\xF3\x91\xF4\xF0\x85\x52\xD7\x7A\x80\x54\x51\x2E\x51\x9A\xFD\xA0\x55\xAB\x73\xC1\xCD\x97\xCD\x9D\xF4\x76\x23', #03
        b'\xF4\xD3\x1E\x51\x82\xCA\x0F\xE2\xB3\xD3\xF8\x86\x73\xFB\xC2\x8D\xE1\x8F\x2A\x85\x85\xF1\xBC\x04\x9F\x1C\xD2\x2E\x08\x19\xE9\xCD\x01\xBE\x6B\x72\x7C\x25\x6C\xA5\x87\x4D\xF0\x01\xD5\x00\x27\x0F', #04
        b'\x1C\xCC\xC8\x80\x89\x30\xC7\x44\x3F\x09\x8F\x6E\x9E\x5E\xF0\xCE\x22\xDA\xB6\x80\x97\x86\x5A\xAB\x66\xA8\xBD\x98\x84\xF5\x00\xD6\x40\xBC\x9E\x60\x08\x54\x16\xED\xBB\x97\xDA\x60\xBD\x37\x92\x70', #05
        b'\x9D\x3E\x7B\x33\x0F\xAA\x82\xDB\x7E\x80\xC1\xF7\x29\xAC\x5E\x02\x33\x7F\x00\xE1\xCD\x69\x76\xF0\x92\x5F\x6C\x21\x59\x45\xD1\xC9\x7C\x12\x81\xAF\xE5\xDF\xFD\xF9\xEE\x68\xF7\xD3\x4F\xC8\x2D\xF4', #06
        b'\xA3\xF2\x10\xDF\x39\xB7\x3D\x5C\x2F\x3C\xD5\xEB\xDB\x58\xD7\x63\x25\xC5\xF5\x46\xD7\x59\x52\xC6\xB6\x09\xC0\x94\xD3\xEC\xCC\x4D\x66\x78\x0E\xA4\x3A\x09\x5A\x34\x1B\xA1\x0D\xA3\xDB\x31\xAB\x08', #07
        b'\xF2\x3A\x29\x63\x3E\x3C\x74\xFA\xD3\x84\xDC\x04\xF0\x8A\xA3\xDF\x60\xC8\xEE\xE5\x96\x09\x99\x6A\x4B\xCB\xF6\xC0\x2E\x93\x93\x3C\x41\x41\x6E\xA9\xB0\xCA\xD3\xEF\x6E\xAC\xE7\xD3\x16\xC0\xE8\xE1', #08
        b'\xAF\x6E\xED\x05\x32\x59\xB0\x3E\x1D\x08\x6A\xFE\x19\x7B\xEE\x50\x20\xFC\x23\x1D\xEF\x15\x9E\x72\x82\x74\x63\x49\x34\x7B\x41\xF0\xCF\x25\x9B\x8B\xF9\x63\x7B\x06\xE4\xD8\x48\x0B\x2E\x66\x48\x0F', #09
        b'\x6E\xDF\x03\xC9\x6B\x28\xBD\xBD\x70\x85\x18\x0E\x11\x1B\xC3\x83\x10\xBE\x1E\x67\xE4\x10\x64\xDF\xDE\x5B\x8B\x87\x87\x20\xF3\x01\xB8\x44\x92\xC4\x89\x04\xA3\xBD\x1F\xF6\x82\x3A\x79\xBF\x1A\xF1', #0A
        b'\xDF\x79\x4A\xCE\x99\x7D\xBE\xC2\x56\xD1\x0B\xE4\x2A\xA8\xA9\xBB\x48\x1A\x7D\x28\xFD\x6D\xC8\xA7\x7C\xDB\xBA\x58\x25\xA7\x6D\xCC\x39\x71\x7C\x04\x17\xC6\x65\x73\x44\x4E\x07\x6F\xC0\x08\xF2\xCE', #0B
        b'\x44\x71\xDE\x71\xBE\xC1\xE9\x33\x29\x63\x7B\x04\x64\xF5\xCC\x88\x57\x93\xA8\x69\xD8\x25\x44\xF2\x07\x5F\xBC\xA2\xAF\x6D\x51\x18\x5C\xD3\x5E\x66\x40\x36\xCF\x31\x4C\xA6\x82\xB2\x3D\x7E\xCF\x27', #0C
        b'\xCE\xA7\xCC\xD9\x8F\xD8\x84\xC6\x83\x0D\x63\x9B\xFE\x52\x28\x51\xF7\x8D\x2C\xAD\xA5\xC9\xED\x39\x7D\x51\x35\x33\xA7\xB5\xA3\xE4\x4A\xA6\x02\xD1\xB0\x69\xD9\xBD\xF7\x8C\x2C\xC8\x4B\x2C\x18\x6A', #0D
        b'\xCD\x27\xBC\x04\xA6\x24\xE3\xFC\x3C\xA7\x2A\x48\xDE\xDD\xB5\xA2\xEF\x9A\xC0\x85\xEE\xEC\x5E\xE6\x56\x18\xD5\x84\x11\x2C\x2E\x26\x16\x2C\x72\x75\x18\x6A\x69\x99\x08\xFF\xBD\x36\xAE\x9A\xDD\x3E', #0E
        b'\x91\x93\x4D\x94\x46\xAD\x59\x43\xA6\x1D\xEC\x17\x24\x5F\x49\x7C\x5F\xF4\xEB\x9A\x61\x27\xDC\x2C\x17\x2B\x97\xF6\xC9\xDA\x3F\xCC\xDA\x92\xC6\x28\x77\xDA\xCE\x16\x49\xB9\xD9\x8E\xA6\x66\x15\x16', #0F
        b'\x3A\xA3\x85\xE9\x72\xA4\x32\x8E\xEC\x4C\x1E\x49\x61\xBD\x31\xBA\xD7\x6C\x91\x98\x48\x34\x52\x1B\x2A\x0D\x01\xC9\x3A\x95\xB2\xA2\x06\xC8\xEF\xE3\xCD\xBF\xCC\x47\x62\x12\xB5\x51\x41\xF1\x4D\xAE', #10
        b'\x37\xA9\x07\x75\x7B\xCA\xBE\x76\x0A\xC2\x2C\xC2\x8F\xBB\x75\x93\x73\xF2\xA1\x03\x5C\x5C\xEA\xAD\x2E\x60\xD6\x75\xF5\xF3\x13\xA1\xAD\x84\x05\x17\x7F\xEE\xC3\xFF\x7F\x9A\x5F\x8C\xDC\x33\x61\x91', #11
        b'\xCA\x75\x89\xA1\x86\xF5\x8C\xD9\xC0\xBE\x87\xC4\x31\xBF\x17\x9C\x02\xDF\xFB\x3C\xF9\x17\xBA\xA0\x2E\xA2\x79\x3C\x0A\x81\x2A\x2C\x43\x25\xA8\x19\x61\x92\x21\xE8\x2E\x53\xA6\xAC\x2F\x07\xBD\x7C', #12
        b'\xE3\xD6\x0D\x37\xFF\xCD\xA4\x4A\x24\x43\x7C\x6B\x2A\xF4\x09\x96\x6F\x41\x3C\x98\x5A\x64\xC0\xB8\xEE\x87\x13\x7E\x95\x93\x8B\xA9\x9D\xC7\xE1\x28\xD8\xBB\x34\x6E\x13\x0B\xCC\x8D\x26\x71\xCD\x1A', #13
        b'\x08\x23\x29\xFC\xE0\x09\xDC\x3C\xB0\xBB\xAD\x4D\x36\x26\xD3\xB2\x08\x1A\x5B\xD2\xF7\xA4\x09\x74\x65\xAF\x79\x0F\x75\xCB\xE3\x96\x45\x37\xDD\x6D\x6B\xE3\x05\x1A\x77\xE5\xAC\xC8\x58\x5A\xF7\xFA', #14
        b'\x2F\xDC\xBB\x5F\x24\x39\x8B\x09\x5F\x21\xDF\xBF\xEB\x52\xC2\xA6\x30\xF9\x7D\xFD\x1F\x57\x5E\x42\xF6\x89\x06\x81\x09\xCD\x91\x33\xE7\xBE\xF4\x4D\x97\x63\xA7\xF9\xCB\x52\x45\x47\xC1\xBC\x73\x02', #15
        b'\xA0\xF3\x7E\x20\x95\xD7\x5C\xBC\x16\xC3\x84\x5D\xD3\x81\x71\x69\x91\xD1\x33\x5A\x89\xC5\xD9\xE5\xFE\x1E\x14\xA8\xCD\xDA\x4B\xB9\xB8\x57\xF4\x1E\x79\xC7\xA9\x9C\x36\x1C\x6F\xC9\x6B\x5B\xCE\x3C', #16
        b'\x6C\x83\xD1\x51\xD1\x7B\x1B\x02\xFA\x3D\x4A\x31\x5E\xCB\xDE\xCB\xFF\x04\x56\x5C\x1F\x64\x1C\xA1\x45\xCA\x69\xFF\x4D\x56\x2C\x94\xED\x7B\xA3\x96\x21\x85\xC1\xAF\x4F\x5C\x36\xE6\xAE\x47\x29\xD9', #17
        b'\x51\xC2\x8F\x5C\x96\x15\xD0\x8F\x77\x90\x34\xCD\x6F\x7B\xEE\xCE\x8B\x1E\xCB\x66\xF0\xD8\x9D\x7A\x28\x31\x9C\xEE\xD0\x8A\x0C\xC2\xD6\xF7\xDC\xF7\x52\x22\x7C\x30\x21\x84\x47\xD7\x79\x6A\x44\x48', #18
        b'\xDD\xB8\x1F\xDE\x2B\x64\x1D\xEC\x4C\x48\x16\x8D\xF0\xAB\x16\xB1\x84\x74\x14\x50\x0D\x6F\xE6\x6C\x54\xD0\x19\x24\xCF\x7E\xE1\x28\x91\xDA\x5A\x0C\x0E\xFE\x83\x84\xE3\xC0\x4E\xAE\x43\xCA\x57\x7E', #19
        b'\xEE\x8A\x6D\x2D\xD0\x48\xA0\xE2\xC3\x0E\x3D\xED\xC2\xAE\xB8\xF5\x75\x95\xC4\xAB\x28\xE4\x9C\x1C\x02\x35\x7D\x82\x0E\xC9\xE1\x28\x3E\x58\x35\x3D\xD7\xF7\xA1\xF1\xBB\x1D\xD6\xE2\xB5\x88\x54\xC5', #1A
        b'\x83\x1B\xEF\x46\x0B\x26\xD6\xFC\x64\x01\xAA\x8A\xEF\xF2\xF5\x53\xD8\x44\x9E\x44\xC5\x82\x9B\x1B\x39\x90\xFE\xE0\x44\x5F\xB8\x4C\xE7\x20\xFF\xFD\xEC\xB9\x45\xD6\x46\x02\xA7\x47\x46\xA0\x64\xBA', #1B
        b'\x72\x35\xDC\xFF\x05\xCC\xD8\x66\x7D\xD9\x47\x60\x20\x25\x8B\x11\x9F\xCD\xC6\x9F\x5A\xCC\xE7\xA1\xA0\x3F\x3D\xBD\xCC\x06\xFE\x57\x09\x15\x83\xD2\xC4\xA5\x3A\x37\xFE\xF7\x52\x07\xB6\xD3\x65\x38', #1C
        b'\x37\xD3\x53\x0D\xA9\xB3\xF8\x9B\x93\x97\x11\xA9\x8D\x2C\x9C\x5C\xB0\x51\x11\xE4\xFE\x1A\xC9\x42\xAD\xB4\xAE\x88\x6F\xEF\x44\x4D\xB8\x2C\xFC\x38\x85\x8E\x39\xC5\xC1\x41\x49\xB3\x64\x92\x00\x5A', #1D
        b'\x0B\x78\x03\x70\x0E\x1D\x1C\x4B\x5A\x96\x64\xF1\xCD\x3E\xC4\x6B\xC4\x8D\x98\xC6\x36\x15\x60\xE7\x72\x91\xBB\xBA\x62\x33\x14\x00\xFB\xAB\xBC\x88\xE4\x29\xCD\xA2\x4C\xB0\x59\x32\xB4\xB7\x36\xE2', #1E
        b'\x89\xA6\xB9\x76\x68\x50\x68\xD6\x21\x78\xBD\x10\xAF\x55\x0F\xDD\x59\x67\xA4\xD0\x3E\xBC\x35\x39\x25\xDF\x82\xBD\xD7\x89\x86\xCC\x56\xCE\x26\x8E\x50\x49\x26\x58\x3C\x6E\x07\x8A\xE5\x84\xD8\xB1', #1F
        b'\x5B\x7C\x58\xA4\x9B\x5B\x98\x85\x9E\x10\x21\xFC\x9A\x0C\xC1\x09\xF0\x2A\x5E\xA7\x53\x53\x47\x22\x19\xD9\xA3\x82\x5D\x85\x79\x08\x8B\x8E\x6C\xCF\x2C\x04\xAA\xE4\x0C\x57\x1C\xC3\x1B\x28\xD9\x78', #20
        b'\x17\x92\x4D\xC7\xC2\x90\xD9\xA9\x59\x16\xFB\x2B\x4F\xFA\x5F\xE2\x7B\xD3\xE1\x76\x4D\xC3\xC4\xAE\x18\xED\x13\x31\x66\x89\xAC\x28\xEC\x17\x7B\x0E\xBC\x93\xAE\x94\x0F\x4D\x47\xB8\xBD\xDF\x11\xDB', #21
        b'\xA3\x59\x3E\x48\xCE\x7A\xE5\x7C\x69\xEC\x5B\x6D\xE6\x2F\x58\xA6\x01\x2F\x21\x41\x46\x16\x0E\x14\xE2\xDA\x13\xC0\x9F\xB1\xAC\x60\xE2\x6E\x51\xC1\xB0\x1C\x90\xC3\xA8\xDB\x0B\x3B\x63\x70\xC2\x02', #22
        b'\xDA\x19\x58\xD7\xE8\x94\x43\xB0\xCC\x88\xB3\x23\xE3\x8E\xD2\xD4\x3B\x59\xC4\x68\x31\x32\xB8\xD0\xC4\x15\x64\x4A\xA6\xE2\xBE\xC4\x41\x53\x9A\x19\x24\xFD\x64\xAF\x59\xF4\xD5\x9D\x51\xA7\xE7\x6E', #23
        b'\xDB\x01\xAE\xF7\x5F\x8C\x2F\x86\xF2\xBD\x25\x00\x42\xC8\x39\xA2\x92\x4F\x49\x3E\x82\x9C\x67\xCA\x00\xA1\xE1\xD8\xB4\x3B\xC9\x2B\x26\xC3\xBD\xF8\xBE\x66\x59\xB4\xDA\x5C\x9A\x2C\xBA\xAF\x02\xB2', #24
        b'\xAA\x47\xD9\x96\xD5\x32\xA4\xDD\x23\x9E\x77\x85\x30\xA7\x39\x4F\xF9\xDA\x62\x25\xD4\x5B\x89\x88\xC1\x22\x9E\xDB\x41\xAA\x97\x8D\xEE\xCA\x20\xDA\x92\x85\x65\xC4\x3C\x28\x55\x66\x88\x5E\x0B\x8A', #25
        b'\x5F\xF6\x2F\xC9\x8E\xC7\xBD\xB9\x08\xB5\xD7\x1A\xA4\x55\x43\x7D\x97\x0F\xD0\xB4\x30\x2E\xBB\x69\x32\xE5\x05\x8C\x7B\x91\x25\xF1\xF7\xF4\xFD\x00\xCF\x5B\x98\xE5\xF4\x3B\x77\x3A\x9F\x31\x80\x85', #26
        b'\x64\x01\xC4\xC9\x7C\xC0\x1B\xF8\x10\x2E\xB7\x99\x07\xD1\x4C\xB4\xF1\x87\x37\x80\x26\xB5\x31\xCE\x7B\xA5\xC0\x96\x98\x7C\x1E\x81\x1E\x94\xAA\x13\x32\xC8\x3B\xCC\x47\x6C\xA7\xFA\xFA\x33\x63\x8F', #27
        b'\xDB\x2E\x66\x45\x79\xA4\x83\x17\xC0\xB5\x47\xB9\x88\x75\xB5\x2E\x29\xC1\xB2\x0D\x3B\xD0\x07\x08\x9A\x63\xC0\xCA\x17\xD0\xCC\x92\x1A\x52\x98\x1B\x48\xF7\xEA\xB8\x18\x16\x68\x31\x0B\xA7\xC3\x8B', #28
        b'\xAA\x31\xF2\xFB\x78\xF1\x8B\xD0\x07\xC0\x43\x56\xD2\x87\xDA\xBF\xB8\xF2\xB6\x81\x0C\x06\x2B\xCE\x44\x27\x40\xBA\x48\xC7\x3A\x8A\x67\xD0\xA7\x1F\x5E\xDA\xD7\x10\x44\x5D\x89\x44\x52\x35\x08\xDF', #29
        b'\xB1\x1C\xCF\x29\xFF\xAF\xD1\x64\x28\x73\x12\x7F\xBB\x36\x7D\x81\x1C\x65\xE3\x94\x50\x22\x6E\x1E\xBB\xD4\xB0\x58\x15\xF8\x0B\x4E\xEB\x7E\xCC\x40\x29\x14\xC5\x64\xAB\x4C\xAC\x7C\xF3\x2B\x0E\xE2', #2A
        b'\x5F\x66\x69\x64\x56\x3F\x2A\x98\xCF\x77\x22\xF7\xDA\xFF\x31\xB8\x56\x34\xB9\xDB\x32\xD5\xEB\x4D\xFD\x1D\xEA\x51\x43\x85\xD7\xDF\x53\x9A\xE0\xA6\xDF\x60\xBF\x92\x82\x88\x17\xB8\x97\x29\x6E\xAD', #2B
        b'\x3B\x9C\xA9\x90\xB5\xCA\xB9\xDC\x36\xF3\x26\xE7\x87\xEB\xDE\x20\x5A\xC2\xFA\xD0\x26\x16\xDD\xBF\x87\xE3\x4C\x98\xF9\xF8\xAC\xEF\x6C\xEF\xA1\xB7\x2C\x5D\x8E\xFB\x55\x11\x67\xA6\xF2\xB8\x59\xAC', #2C
        b'\xBC\x10\x50\x30\x60\x73\xEF\x9E\x57\x97\xD1\x3B\x84\xAD\xA3\x2E\xED\x3D\xC3\x00\x53\x13\x9A\x4F\xD0\x57\x97\x8F\xF3\xA3\xFA\x2B\xA0\xBF\x06\x18\x86\xEC\x42\x95\x5C\x04\xD5\xCF\x87\x4D\xF6\x34', #2D
        b'\xC9\x54\x7B\x8E\x3B\x47\x1C\x2A\xA7\x84\x98\xB9\x07\x1F\x8A\x77\xC7\x34\xE0\xAF\x84\xE0\x12\xA0\xDD\x72\xB3\xB4\xFE\xF6\x9A\x1B\xB0\xB2\x2B\x55\x53\x0C\xDD\x0D\xF8\x56\x45\x54\x19\x89\x9A\x17', #2E
        b'\x1A\xD1\x8E\x44\xE1\x94\x28\x98\xBF\xF8\x9C\x86\x65\xC7\xCA\xEA\x6C\xCC\xA8\x6A\x63\x7E\xA3\x3A\xBA\x61\x80\x5A\xE7\x54\x8B\xA9\xCD\x5B\xCC\x56\x7E\x8D\xE1\x58\x04\x84\x23\x34\x71\x20\xFD\x6B', #2F
        b'\x00\x4C\x1F\x81\x64\xE1\x24\xBD\xBA\x8A\x3C\x0D\x30\x89\xA5\x0F\xE8\x7A\xD0\x2A\x3F\x2A\x34\xE6\xE0\x8E\x9A\x73\x02\xC4\xA6\xB0\xB7\x3F\x51\xBD\xD6\x7B\x66\x9A\xF3\xDB\xA3\xE3\x9C\xC0\x2A\x5A', #30
        b'\x8C\x97\x3B\x34\xE2\x0A\xA7\x70\x65\x8B\x0D\x12\xA6\x84\xE6\x09\xCA\xEF\x37\x63\x8F\x66\xBC\x4B\x01\x99\x0E\x4D\x2D\x31\xCB\x9D\xA7\x4A\x5D\xFD\x67\x87\x5A\xDF\x17\xFB\x2A\xC6\x5C\x38\x72\xC2', #31
        b'\xA6\x8B\xAC\xC2\xED\x63\x72\x1D\x3F\xBF\x6C\xC9\xC3\x65\x2A\xA6\x7C\x27\x39\x93\xFB\x41\x1C\xEB\xDA\xC2\x03\xAE\x77\xAD\xEE\x3E\x0A\xEF\xEC\x6C\x60\x81\xEE\x19\x77\xDC\xBF\xD3\x4A\x36\x30\x23', #32
        b'\x47\x24\x46\x5B\x92\x9E\x77\x6B\x06\x0A\xB6\xED\x97\xC9\xA3\xFF\x5F\xE0\x66\xA1\xE7\x63\x86\x7D\xA8\xF0\xE4\x78\xFE\x90\x91\xFA\x0B\xB2\xBA\xB1\x74\x70\x28\xD6\x8E\x32\xE0\xAA\xC7\xCC\xD4\xF2', #33
        b'\xA8\x14\xF2\xA5\xC6\x48\xC4\x38\x90\x74\x17\x9A\x48\x01\x85\xD4\xA1\x54\xE9\x70\x9E\x92\xDD\x17\xE4\xCC\x32\x39\x30\x6F\x88\xC5\x38\xC0\xF5\x93\xDF\x49\x25\xBB\x77\xED\x81\x2D\x5C\x21\x7D\xB1', #34
        b'\x92\x2D\xEB\x1F\x56\xB1\x67\xCE\xA0\x47\x0A\x39\x5D\xA5\xC9\x72\x8B\x88\xBA\xDB\x75\xBC\x41\x05\xBA\xAA\x8C\x5E\xE4\x4F\x6B\x70\x57\x58\xEC\x7E\xBC\xA0\x16\xE5\xAF\xCB\x78\x80\x59\x57\xFE\x92', #35
        b'\xD1\x05\x35\xB0\xF5\xEA\x45\x77\x91\x2C\xD9\x1E\x25\x23\x6E\x75\x12\xB3\x20\x01\xB5\xD4\x50\x95\xBE\xDF\x56\xD0\xC0\x81\x2A\xF1\x17\x94\x5F\xDB\x15\x7A\x4C\xB6\xB6\xC2\xBF\x5A\x80\x3B\x60\x27', #36
        b'\xF8\x1B\x82\xC6\x29\x2A\x68\xDC\x72\x0C\x48\x0B\x71\x60\xE8\xE0\x8A\xBB\x77\x97\x94\x2F\x07\xBB\xE2\xEB\x9B\x45\x76\xB7\x58\x8C\x29\x48\x43\xD2\x68\xFF\xE5\x0F\xB4\xB5\xBB\xE5\x34\x1B\xB8\x78', #37
        b'\x89\xF8\x13\x47\xF0\xF8\x96\x08\x46\x31\x2C\x49\x79\x57\x86\x79\x7C\x7E\xCA\xA3\xF7\x52\x3C\xB8\x74\xF1\xB0\x38\x20\xFA\x48\xD4\xCD\xA2\x96\x3E\xFF\x95\x4C\xD3\x8D\xAE\x7A\x8D\x76\x10\x04\x97', #38
        b'\xE2\x03\xEB\x8F\x4E\xC5\x57\x6D\x3B\x95\xD9\xB8\xC8\x5C\x4D\x09\xD0\xB8\xEE\xC2\x8A\x8A\xB8\x11\x79\x04\xF3\xF8\x35\x6C\x73\xC6\xE1\x59\x81\xE1\xF9\x7F\x6F\x38\x79\xF3\xC8\xFD\xB7\x2D\xEB\xB2', #39
        b'\x78\x1F\x99\x2A\xE3\x7F\xC8\x4F\x7F\x18\x6E\x7B\x8F\x2E\xB1\xF3\xD0\x70\xCE\x88\xA8\x3C\x11\x42\xFA\x83\xF1\xF0\x96\x51\xF4\xC6\x5D\x53\x46\xE2\xD6\x34\x6C\xD6\x0B\xF8\x13\xE5\x03\x47\x41\x3D', #3A
        b'\x4E\x76\x26\xF4\x24\xE5\xE2\x9A\x1C\x3E\xD3\x17\xB6\xAE\xC8\x23\x4C\x8D\x93\xDB\x60\xDC\x91\xD1\x18\xDA\x6D\x28\x01\xF8\xE9\x46\xB5\x02\x62\x32\x89\xA6\xDB\x42\x24\x19\xC8\xE5\xB0\x50\x53\x04', #3B
        b'\x91\x2C\xC9\xD8\x70\x57\x28\x61\x12\xC6\x96\xB0\xEF\x5E\x21\xE1\x42\x2D\xF5\x10\xA4\x8C\xC1\x94\xC1\x60\xDF\xF8\xD5\xB5\x84\x68\x55\xE0\x0D\xCB\x27\xBA\xBF\x34\x45\xB2\x1F\xED\xF9\xAB\xC6\x7D', #3C
        b'\x35\x2D\x14\xC4\x65\xAC\x24\x19\x9D\xBB\x98\x5A\xD7\x75\x99\xD7\x4E\x8B\x48\x44\xFE\x36\xEC\x85\xC9\xF0\x7F\x5C\x4A\x0A\x92\xFC\x39\x16\x90\xBC\x90\xD0\x44\xD1\x0C\xEC\xEC\xB6\x86\xAA\xCC\xA1', #3D
        b'\x65\x43\x70\xAE\xF2\xB4\x47\xDC\xB3\xAC\x64\xE3\x0B\x21\xF4\x8B\x61\x03\x4F\x29\xCE\xE7\x92\x47\xE2\x11\x04\x50\xB0\x48\xD9\x0D\x64\x5D\x3E\xA6\xD5\x76\xB7\x2A\xA0\xEE\xAC\x1C\x80\x96\x40\xAF', #3E
        b'\x81\x0E\xC1\x83\x19\x93\x6D\x05\x95\xA9\x83\xC4\x41\x4F\x0C\x57\x9D\x4B\xDC\x2F\xF1\x6F\xB7\x84\xCC\x5D\xFC\x57\x3F\x50\x0F\xBA\xE6\xC3\xF1\xB6\x63\x59\xB2\xA5\xF3\x76\x60\x43\xD7\x37\xD8\xBF', #3F
        b'\x3D\x8B\x4D\x09\xA8\x6D\x79\xFD\x0E\x37\x1B\xE9\x70\xF6\x56\x4A\x7F\xF8\xF3\x08\x9C\xBD\xEE\x8E\x43\xD8\xD5\x65\xBB\x03\xEF\x44\x9F\x14\xF6\x55\x0D\xF6\x2F\x07\xBA\xF3\xD7\x4D\x25\x3C\x8B\x5F', #40
        b'\x98\x5A\x59\x6F\x99\xD8\x8A\x5A\x45\x21\x37\x9F\x01\x9B\xAE\xB2\xCC\xAB\x8F\x2D\xC3\x19\x82\x13\x98\x0D\xB0\xCB\xDD\x6B\xFD\x31\xC0\x1E\xFC\x60\x4E\xF6\xEF\x26\x67\x4E\x38\x60\x4C\xCB\xAD\x13', #41
        b'\xA4\xF4\xC3\xC6\x1A\x30\xCF\x61\xC1\xA2\x80\xC7\x01\x44\xCF\x45\xBF\xDC\xA6\x1A\xB3\x8A\x6E\x71\x4A\x14\x1D\xDE\xE3\x7F\x51\x20\x1F\x4E\xEA\x47\x37\x0A\xF0\x57\xE8\x23\xCD\xCB\x67\xB5\xD5\x38', #42
        b'\xFE\x68\x07\xCE\xB3\xC2\x79\x45\x23\x65\x9D\xCF\x79\x57\xD9\xC6\x3A\x22\x0B\x30\x70\x46\x87\xB2\x08\x84\xDA\xD4\xEE\x53\x1D\xDA\xEA\xBA\xEF\xAE\x55\x2A\xD0\x19\xEE\x9D\xD2\x63\xEB\x57\xFE\x8E', #43
        b'\xE8\x6F\x5A\x70\x87\x2B\x43\x3E\x63\x72\x19\x11\xEF\x4C\xF4\x03\xF4\x9F\xCA\xCB\x1B\xDC\xFA\x21\xA9\x3D\x24\x54\xCC\xE4\x8C\x20\xD0\xEB\x39\xF6\x68\x44\x77\x06\x92\x9F\x3F\xC9\x06\x7F\x85\x95', #44
        b'\xA1\x63\x8D\xC3\xD5\xDA\x72\xF3\x42\x0A\xAD\x9D\x21\x1F\xE2\xBF\x38\xAF\xFB\x41\xFE\x81\xCF\x7B\xAB\xB3\x24\xBA\x34\x67\x15\x0B\x50\x48\xF1\x81\x8A\xB7\x74\xFE\xF7\x0B\x79\xB9\x19\x46\x1C\x42', #45
        b'\x13\xFB\x28\x56\xEC\x6A\xD2\x13\xE2\x49\x3E\x5D\x85\x11\x53\x0C\x25\xD2\x6A\xA5\xE4\x0D\xAB\xBE\xB6\x45\x55\xE1\xA7\x38\x63\x42\x0A\x1B\x65\x43\xB3\x14\xFF\xAE\xF4\x7B\x3D\x5B\xEB\xF0\xB7\xB6', #46
        b'\x04\x0F\x2C\xDB\xC9\xD0\x3F\x02\x7E\x6B\x37\xF3\xDC\xF4\x64\x9A\xB5\x82\x3B\xFA\x97\x42\xE0\xF2\xF0\xEE\x26\xA7\xA7\xFD\x9E\xBA\x50\x4F\x95\x3F\xCE\x39\x94\x15\xD0\x59\xD5\x0A\x3C\xDB\xC1\x12', #47
        b'\x2F\x01\x7C\xA0\x84\xDE\xDC\xC9\x0A\x8B\x06\x3A\x36\x2E\xFF\x69\x79\xF6\x8C\xFA\x4D\x8B\x2D\xDC\x62\xD3\xE4\x48\x79\x6C\x49\xF3\xA3\x5B\xC1\x04\x09\x21\x83\xF0\x6A\xFF\x76\xE3\x38\xE4\xE8\x05', #48
        b'\x2C\xA8\x56\xDC\x21\x5B\x02\xAD\x83\x78\x0E\x15\xCD\x20\x89\x8E\x7A\x48\xD6\x78\x93\xB3\xF3\x89\x44\x03\x7B\x8A\x54\x97\x73\xB6\xC8\x4B\xC0\x96\x2C\x83\x46\xA3\x2F\x5C\xC5\xD7\xE9\x9A\x45\xA2', #49
        b'\x08\xC9\x92\x3A\x47\x1E\x76\xC4\xA2\x25\x04\xF9\xFD\x2F\x37\xFA\x31\x50\x64\x7A\xA3\x43\xE8\x72\x22\x37\xCB\x04\x74\x35\x0A\x49\xB2\xB8\x66\x3D\x15\xCF\x3A\xB7\x0E\x36\x0F\x66\x66\xC1\x5B\x5B', #4A
        b'\xC3\xDA\x83\x8E\x33\x45\xD5\x7D\xF0\xF0\x40\x67\x56\x85\xE1\x60\xEA\xCE\x75\x9E\xC5\xB5\xE7\xA6\xB5\xCE\x59\xEB\xB0\xC0\xAE\xE5\xA9\x1D\x1A\x36\x3B\x2A\xD4\xC3\xC5\xF1\x21\x65\x48\xA7\x06\xE7', #4B
        b'\xD4\x70\xE0\xB0\xD5\x42\x81\x43\x0C\xC5\xCD\xF0\xA4\xC1\xDD\xAF\x4A\xB1\x08\xA2\x96\xB5\x7B\xAB\x2E\x04\x44\xCD\x62\x3A\xF1\x39\x6A\x85\x9F\x71\x10\x9D\xB7\x2A\x26\xBA\xB6\xE2\x02\x1B\x00\xF8', #4C
        b'\x51\xC2\x68\xD7\xB1\x3F\xCA\x69\x9D\xCD\x72\x55\xB9\x72\x25\xDC\x07\x0F\x6A\x84\xFA\xF8\xF5\x60\x19\xBB\x6D\x3E\x8F\x07\x38\xDA\xEE\xBA\x73\x44\x8C\xB1\x55\x21\x50\x2A\x0C\x85\xCD\xDA\x8B\x18', #4D
        b'\x57\x28\x81\xBB\x3C\xE9\x05\x18\x96\x9E\x8E\x91\x08\x41\x43\x69\x4D\x1C\xD9\xD1\x94\x08\xF5\xCC\x4A\x83\x1F\x29\x53\xFF\xB1\x12\x10\x5A\xDB\x48\x3D\x53\xF6\xB7\xF5\x7C\x3D\x93\xA5\x79\xD3\x38', #4E
        b'\xEA\x4B\x0D\xA7\x7E\xE7\xD4\x2A\x30\x20\xCA\xFB\xD8\x98\x29\xF4\x67\x28\xCF\xB2\x6C\xDA\xBD\x4E\x72\x5D\xB7\xD4\xD3\xE1\x78\x1E\x22\x28\x9A\x26\x64\x9D\x00\x87\x1C\xEB\x99\x72\x56\xCA\xD7\xD9', #4F
        b'\x23\x7B\xF7\x11\x80\x94\xEA\x7B\x10\x9C\x4A\x0E\x1B\xFB\xE0\x27\xE7\x23\xC1\x0B\x32\xCE\xB2\xE9\x33\x4B\xFF\x72\x46\x50\xE9\x49\x13\xF0\x26\x9C\x74\x34\x7C\x60\xD1\xE3\x60\x44\x95\x3C\xEC\xE8', #50
        b'\x2F\x3C\x70\xF7\xB5\xCE\x96\xE6\x5B\x16\xE3\x6A\x37\x48\x42\xA1\x89\x41\x86\xEA\x42\x2B\x3B\xEE\x6D\x3A\x04\x5F\xFC\x2F\x60\x8F\xAA\x5E\x05\x5E\xA0\xC3\xB1\xC7\xB4\xC6\xB1\x6A\x79\xFD\x87\xD8', #51
        b'\xF6\xEC\x7A\x3A\xBD\x01\xA2\x41\x58\x19\x68\x8B\x1C\x37\xC6\xA4\x75\xA0\x50\xBE\x62\x84\x65\x21\xEE\x34\x40\xA1\x29\x06\x54\xE9\x8C\x5E\x8B\xD6\x32\xE5\x37\xA1\x40\x4C\xAE\xF0\x5D\x10\x01\xC6', #52
        b'\x6A\x70\xDF\xAE\xC8\xA7\x01\xDE\x71\x1F\xAF\x25\x75\xFC\x7F\x22\x1A\x48\x6B\x45\xBD\x3B\x92\x9D\xA1\xC3\x26\xB2\x38\xFE\x1B\x3A\x88\x09\x72\xD4\x86\x3F\xE1\x40\x39\x77\x25\x21\xBC\x13\xEA\x47', #53
        b'\x66\x76\x16\x1A\x8B\x12\x3B\x9F\x5F\x91\xDB\xFB\x32\x50\x87\x24\x83\x53\x69\x9E\x67\x05\x35\xAF\xC2\xC0\x45\x07\xDD\x21\xB1\xAE\xA5\x4F\xFC\x0B\xDA\xE2\xA6\x4E\x61\x06\xD1\xE1\x29\x6B\x1A\xE0', #54
        b'\xAD\xAA\xA8\xB7\x2A\x85\x33\xB6\xC6\x4E\x86\x20\x65\x9E\x67\x45\x74\xAC\x18\xAC\xCF\x16\x6B\xF4\x97\x0B\xAA\xDD\x59\x4D\x62\x59\x90\x69\xA7\x1B\x6A\x81\x17\xF4\x6B\xDF\x8C\x54\x3F\xAC\xC7\x54', #55
        b'\x60\xFD\xEF\x62\xD3\x99\x48\x67\x95\xD0\x8F\x0E\x8C\x17\x2D\xAB\xE2\x53\xCC\xD7\x60\x69\xD0\xF1\x2A\xED\xAC\xA4\x76\xF9\x7F\xE7\x2C\xBF\x05\x53\xA6\x73\xAA\x62\x84\x14\xC9\xEA\x1D\x65\x68\x17', #56
        b'\xD1\xE1\xF8\x9F\x8B\x7F\x95\xCF\x0E\x03\x8C\x2D\x4A\xD2\xF8\xD3\x79\x16\x94\xAD\xB4\x35\xCB\x0D\x35\xB6\xA9\xDC\x67\xEB\x27\x95\x32\xFA\x5D\x18\xDF\x1A\x42\x4B\x24\xB9\x79\x0B\x96\x5D\x40\xF5', #57
        b'\x6F\xAF\x85\x2D\x17\x30\x03\xCD\x3C\x1B\x26\x00\xD9\x59\x95\x42\xA5\x97\x2C\x93\xCA\xDD\xA0\xF4\xDD\x91\x42\x8C\x17\x28\x71\xCE\x78\xDB\xF6\x9A\x5D\x4F\x75\x2B\x94\xB9\x8B\xA7\x0F\x2C\xA8\x06', #58
        b'\xB5\x02\x62\x77\x68\x15\xCD\xB2\x3D\x38\x9A\x3B\x7A\x7C\xC0\xD2\x9D\xAA\x36\x83\xFB\x70\xFC\x8C\xEC\xBD\x15\x56\x2E\x2D\x1C\xA8\xB9\xCA\xA2\x39\x01\xEE\xDE\x3B\xD9\x16\x89\xA3\xB5\xBD\x82\x23', #59
        b'\x7C\x19\xB6\x87\x50\x4C\x55\xE9\xA6\x4C\x80\x20\x78\xE7\xF2\x91\x46\x7F\xE9\x59\x4A\x40\xBF\xEB\x52\x0A\xC4\xF3\x91\xEC\x58\xA8\x10\x19\x71\x0F\x60\x54\xD1\xE5\x87\x35\x66\xE1\x6F\xE2\x8B\x6A', #5A
        b'\x03\x60\x1F\x9F\xFE\x87\x1E\xB2\x7F\x47\x2A\x8C\x54\xC9\xAF\x6D\xEB\x63\xDE\x3B\x6D\x2F\x50\xEC\x91\xF1\x52\x56\x0A\xD3\xE4\xF4\xB5\xC4\xBD\x65\x6C\x9A\xA2\x55\x34\xDD\x69\x2D\x07\x36\xAE\x5D', #5B
        b'\xE3\xE8\xC2\x8E\x6A\x3B\x23\x08\xF8\x44\x56\x55\xFB\x54\xF6\x97\x33\xE6\x3E\xB0\x6A\x53\x42\xEC\xEA\x1C\x0F\xB2\x84\xBE\xF9\x07\x03\x4C\xEE\xC8\x22\x37\x5D\xC1\x51\x12\xC2\x6C\xED\x99\xAA\x5F', #5C
        b'\xFC\xED\x5B\x56\xFA\xFB\x13\x18\x4D\x24\x7C\xFA\xE5\x16\x85\x1E\x5D\x7D\x4E\x30\xCB\x7C\x45\xF4\x96\x3C\x95\xB4\x89\x39\xCF\x4F\x74\xE7\x1E\x06\x10\x58\xFD\x85\x03\x64\xC1\xB7\x7F\xBE\x0A\xC6', #5D
        b'\xB7\xB3\xB7\xE5\x40\x8D\xDB\x17\x8F\x18\x57\x9A\x0E\xD2\xF4\x43\x11\xBD\x3C\x53\xAB\xA9\xBB\x02\xB7\xB3\x8C\x0A\x4E\xA1\x9B\x29\x73\x9C\x64\xA1\xFB\x77\xFA\x1E\xE3\x9B\xE9\x15\xF0\xDB\xEB\xAE', #5E
        b'\x41\xD7\x38\x2B\x73\xFD\x83\x9A\xD7\x25\xFE\x86\x90\x27\xAA\xF4\xBA\xE4\xA9\xFE\x9F\x01\x3E\x96\xE1\x6C\x25\xBA\x42\x61\x0C\xEE\x35\x63\x84\x42\x27\x41\x1B\x15\x87\xC0\xB3\xC6\x04\x07\xEA\xF9', #5F
        b'\xFE\xC6\xFA\xBC\xDC\xF4\x4E\x9A\x44\x0E\x85\x21\xE6\x6D\x05\xE1\x6F\xA3\x5B\x6D\xCB\x68\xCC\xBF\xC5\x5D\x9D\x62\xCD\x95\x64\xCF\x39\x98\xEA\xE1\x57\x2C\x98\xDB\xDD\xD9\x4D\x28\x83\x53\x26\xE6', #60
        b'\x1B\x46\x37\xD5\x03\xE7\x0B\x4E\xE5\x06\x6A\xBE\x4B\x49\x94\x34\x74\x05\x26\x6E\x7A\x30\x9C\x5A\x53\xB4\xD9\xE4\x7A\x42\x28\xC0\x36\xE0\xC1\xAF\xC9\xF6\xA4\x3D\x25\x00\xBB\xA7\xCC\xE6\x33\x3B', #61
        b'\x12\xC4\x26\xED\xC3\x3C\x20\xFC\x18\x55\x16\xE3\xFF\x88\xC8\x1A\xBB\x0A\xEC\x4A\x8D\xE3\x92\x3C\x63\x9C\x52\xEF\x60\x30\x40\x51\xA3\x9F\xA1\xF0\x37\x76\x7C\x4E\x15\x87\x6A\xC6\x38\xF9\x86\x78', #62
        b'\x74\x7F\x6F\x4C\xB2\x79\x33\xB6\x43\x5E\x60\x82\x1A\xE0\x20\x78\x9D\xA2\x34\xFF\x0D\x4A\x19\x1F\xA2\x46\x66\x41\xA3\x48\x47\x05\xFC\xC7\x20\x2C\x36\x92\x96\x3A\x57\x0B\x7E\x79\x2A\x35\x26\xD0', #63
        b'\xB4\xA5\x6F\x6B\x88\x06\xC7\x3B\xF3\x60\x15\xC3\xD0\x62\x38\xF4\xE8\x9B\x6C\x48\xCC\x02\x33\xA5\x87\x66\x78\x16\x88\x76\xBA\xB4\x2D\x63\x3B\xEE\xA7\xD4\x22\xCC\x58\x14\x80\x2C\x6C\xCA\x78\xF0', #64
        b'\x9E\x7C\x76\x1F\x7B\x95\x88\x97\xCE\x73\x97\xCB\x4E\x86\x1D\xEB\x2F\xD4\x10\x74\x81\x6C\x3D\x68\xDD\x74\x65\x6C\x5C\xF7\xFB\x96\xF7\x2D\x5E\xBF\xFA\xE3\x44\xC5\xF9\x0C\x29\x7E\x87\xBF\xB7\x06', #65
        b'\x8F\x5C\xC8\x1D\x07\x82\xAD\x68\xE4\xF1\xBE\xAA\x2D\xB4\x61\x29\x63\x6A\xA0\xA3\x15\xA0\xEA\xD5\x6C\xE4\x7E\x75\x6A\x3E\xF7\x1B\xB4\xE1\x6A\x2D\x96\x40\xE0\x50\x7B\x2C\x19\x7E\x43\x07\xFB\x14', #66
        b'\x7C\x3A\x5D\xF9\x4F\xBD\xB1\xA5\xC0\xE6\xA9\xF0\x56\x18\xFA\xC1\x6D\x33\xD9\x72\x60\x09\x3E\xDC\xB8\x1C\x4F\x1C\xA5\x63\x53\x18\xF3\xC6\xF4\xF2\x4F\xC8\x44\x67\x43\x6D\x8B\x37\x65\x3E\x4F\x92', #67
        b'\x4F\xDB\xCC\xBF\x6F\x18\x2D\xC4\x13\x0E\xF5\x93\x52\xF9\x20\xEC\x67\x51\x54\x43\xC6\x2C\x3B\xE3\x30\xCD\xFC\xBC\xE6\x48\xD9\x79\xD8\xA8\xFC\xB2\x63\xBE\xA2\x9F\xD5\xC6\xED\xCD\xEC\x9E\x3E\x57', #68
        b'\x9E\x38\xBD\x36\x2A\x33\xB0\xFC\xC9\xBA\x09\x8B\x6E\x74\x49\x1F\x6D\x81\x37\x37\x58\xBF\x47\x3C\x54\xE5\x26\x95\xD2\xF9\xC1\x26\x9B\xF6\x8A\x73\x82\xA8\x2B\xA2\x1A\xD1\xC0\x40\xE2\xBA\xAF\x1F', #69
        b'\x8C\x76\x6B\x4A\x19\x04\x83\x02\x12\x1E\x25\xA1\x7F\xBB\x18\x63\x5F\x28\xA8\x5E\x88\x33\xD9\x48\x7E\x27\x6E\x36\x22\xCA\xCE\x4C\x04\xE9\x0F\x3D\xBC\x24\x86\xDB\x66\xA5\xF0\xCA\x51\xA1\x82\x7F', #6A
        b'\xC7\xA5\x95\x89\x9B\xFD\x17\x43\xCC\xA6\x56\xAD\x02\x50\xD3\x60\xFD\xC8\xB0\x62\xC0\xA3\x74\x17\xE2\x9A\xC6\x54\x01\x9D\x2A\xEF\xAA\x9C\xD9\x69\x87\xDB\x1E\xC0\xEE\xBE\xD7\x14\x7D\x7E\xBD\x4A', #6B
        b'\xE9\x1B\x51\xFF\xA0\xF2\xF2\xBF\x8B\x64\xAA\x96\xC5\x54\x43\x76\x22\xF0\xFC\x71\x95\x82\x29\x3A\x54\xEE\x4D\x21\xF6\x5A\x42\xF7\xCB\x71\xB4\xE1\x59\x9D\xAD\x34\x75\x95\x30\x46\xF3\x5F\x4B\xA3', #6C
        b'\x60\x88\xEB\x38\x56\x99\x12\x19\x84\x96\x86\xE9\x5B\x60\x29\x30\xBE\x98\x5A\x74\x16\xDC\xF8\xDB\x56\x6E\x2B\x00\xB6\xA4\xCC\xDF\xC0\x4A\x96\xF8\xBC\x92\x70\xCD\xBE\x0F\xD0\xDE\x76\xF0\x3C\x76', #6D
        b'\x14\x83\xD4\x3B\xCF\x31\x44\x6A\x8C\x56\x65\x89\x70\x7C\x99\x6B\xC8\xE7\x8F\x09\x4D\x6A\x49\x48\xF7\xB2\xF7\xFB\xEE\x3E\xD0\x2D\x78\xC0\x05\xFD\x91\x2D\xF7\xFE\x1B\x9D\x6D\xEA\x08\x09\x9A\xA4', #6E
        b'\xBA\xA9\x6D\x53\x77\x8A\x36\xA2\x8C\x1E\x7E\x54\x5D\x88\x29\xA5\x06\x52\xF6\x2F\xD5\x04\x90\x65\x4D\x0B\xBA\xA2\xE6\xA4\x29\x92\x73\xCA\x1A\x64\x3A\x1F\x3E\x82\x6F\xC9\xC1\x51\x5B\x44\x7F\x0D', #6F
        b'\x08\x2F\xD0\xD9\x39\x31\x43\x0F\xF5\xAB\x49\x7D\x10\xC6\x77\x79\x3B\x17\x57\x27\x7E\x94\x8D\x6D\x41\x74\xDB\x9B\xC4\xBA\x12\x21\xEF\x4D\x14\x30\x1D\x35\x35\xFF\xB9\xA5\xDC\x2B\xA7\x9D\x63\xEF', #70
        b'\xC7\xAC\x97\x17\xF8\x76\xB7\xD3\xF6\xE4\x78\xE5\x64\xAD\xDC\x97\xAA\xC0\x8E\xD7\x10\x11\xAF\x89\xB4\xBD\xE7\x2A\x76\x4E\x19\x68\x09\xB9\x44\xFD\xCA\x05\x39\x0B\x6D\x10\x80\xF6\x73\x60\x41\xAC', #71
        b'\xFF\x7F\xD0\x2F\xF8\xA9\x64\xFF\xDF\x42\x4A\x06\x3E\x6B\x09\x1E\xA7\x80\x1F\xF2\x53\x72\x2C\xE7\xDC\x7E\x46\xBA\x4B\x15\xA9\x6F\x3C\x2F\xC5\x83\x69\x9C\xF2\x5D\x18\xB2\x69\x43\x17\x72\x00\xEA', #72
        b'\xB8\x15\xD7\xD7\x9C\x81\x1F\xEE\x15\x35\xEB\x76\x07\x87\x8D\x7B\x29\x96\x94\x02\x7E\x6B\xDC\x54\x03\x5A\xAD\x7C\xB3\x98\x3E\xEB\xAA\x94\xED\x3A\x49\xEF\x11\x96\x75\x6A\xE6\xF2\xD5\x4D\xD5\x9B', #73
        b'\x6D\xD9\xFA\xFE\xA8\xC3\xAD\xD6\x79\xE1\xDE\xC4\xDB\xC5\x23\x7D\xDC\xFA\x31\xB5\x2D\x2C\x36\xCC\xD3\xA9\x37\x01\x1C\x36\x6A\xFD\x59\x65\x07\x1C\xFA\x5D\x20\xC8\xC1\x14\xDF\xA5\xEA\xDB\xC3\xEB', #74
        b'\x5E\x9F\x7D\x42\xDD\x5D\x10\xDE\x13\xB2\xA3\x0A\x84\x7F\x29\x09\xFC\xD3\x8F\x5D\x35\xDD\xC8\x36\x0E\x2B\x83\xBC\xE2\xA5\x0D\xDB\xF7\x86\xAF\x58\xB6\x32\x91\x90\x9A\x5A\xD1\xB1\x4A\x4F\xA0\x6D', #75
        b'\xFE\x9E\xC0\x9D\x46\xA7\x4B\xA5\xE5\xE5\x0D\x5A\xD4\xD7\x5E\x51\x3C\xD8\xA7\xB4\x9D\xB7\x6D\x2F\x76\xA6\xC4\x46\x06\xD8\x2E\xA1\x7C\x34\x95\x5E\x4B\x44\x12\x60\x36\x3A\x91\xA4\x16\x65\x93\x5C', #76
        b'\x1A\x38\x7B\xAA\x52\xF7\xCD\x83\x14\x63\xBF\x65\xE1\x3B\x61\xCB\xB4\x98\x7C\x65\x8F\xFE\x11\x4B\xD3\x17\x91\x49\x0A\xBA\xB6\x9D\x89\x6A\x48\xA5\x9B\x37\xA7\x91\x83\x05\xFE\x9C\x9D\x56\x61\xFF', #77
        b'\x16\xD8\xC3\x40\xD1\xDF\x25\xA4\x65\x55\x4E\xB9\xAA\x5B\x1C\x5B\x4D\x4F\x61\x95\x67\x78\x1E\x32\x5C\x8E\xE7\x5C\x49\x48\x9C\x7A\x0C\x01\xDF\xBE\x85\x91\x7C\xF9\xEE\xE7\x74\xCA\xE5\x1B\x90\xF2', #78
        b'\x57\x52\xDA\xAD\xD3\x1B\x8D\x04\x5E\x77\x72\xC6\x07\x83\x94\x31\x7C\x4A\xAF\x00\x68\x1F\x6E\x70\x44\xDE\x83\x15\xF9\xED\xA1\x57\x5B\xF9\x5D\xE0\x32\xFA\x1C\xDE\x64\x9D\x32\x80\x32\x43\xD3\x99', #79
        b'\xBE\xEC\x9D\x37\xE2\xC3\xBF\x51\xF2\x1C\xF6\x65\xF1\x0C\xC7\xD1\x37\x59\x40\x7E\x93\x8C\x06\x4F\x39\x22\xF0\x5A\xDF\xF4\xBB\x2C\x06\x7B\xA9\xDC\x12\x04\x6F\xB0\xDC\x1A\x63\x78\xD8\x5E\x75\xE1', #7A
        b'\x99\xCE\x66\x51\xA9\x2D\x8B\x92\x33\xA3\x2E\x64\x93\x54\xDC\x96\xC8\xB1\xE4\xDB\x90\xEF\x28\x65\x98\x37\x31\xA3\xBB\x21\x01\x8E\x0B\x78\xEE\xC1\xB3\x2C\x74\xFB\x8C\x7B\xAD\x84\x46\xEC\x98\x21', #7B
        b'\x13\xBE\x20\xE9\xB3\xF9\x96\xA6\x9C\xEA\x6F\xA7\x02\xFF\xAC\xF6\x22\x9A\xAC\xB0\x7A\x4A\x51\x35\x0D\xFA\xD9\xEF\x1B\xC9\xDE\x6B\x48\x66\x18\x6C\xB2\x6F\xF1\x71\xB0\xB6\x54\x83\xFD\x7B\x27\x57', #7C
        b'\xB8\x22\xC1\xDF\x0D\xD7\x72\x50\x53\x67\xDE\x13\x07\x6D\x89\x29\xB2\x4F\x3E\x42\x7D\xC4\x51\x36\xD5\xEC\x3D\x2D\x3B\xA1\x1A\xF1\x49\xDA\x4E\x05\x54\xF3\xE6\x8F\x36\xDD\xD4\x86\x08\xEF\x4F\xDE', #7D
        b'\x47\x41\x40\xA4\xDD\x9C\x2E\x2E\x8C\xD9\xA6\x09\x0B\x71\x6F\xBC\x02\x11\x19\xE7\xA3\x7E\x46\x79\x51\x23\x0D\x2D\x9D\x01\x6F\x91\xA7\x7E\x12\x06\x78\xA1\x35\x10\x8B\xCE\x4C\xB4\x2C\x0E\xC8\xF3', #7E
        b'\x8A\x61\x34\xE2\x1E\x3C\xA9\x45\x60\x58\xCE\x41\x66\x98\xC8\xDD\x51\xCF\x5C\x54\x33\x8E\xA4\x2A\xAF\xA3\x82\x29\xFD\x08\xEA\xC3\xEB\x9C\xAF\x46\x45\xCA\x35\xF2\xD5\x70\x01\x0F\xB5\xCC\xD6\x6E', #7F
        b'\x9F\x38\xFC\xAB\xD0\xE4\xC9\x40\x00\x1F\x11\xFF\x76\x6E\x87\x80\xE0\x51\x44\xEC\x8C\xD4\xA1\x1B\xC6\x0B\x2F\xCE\x3F\x3A\x44\x9F\xD4\xE5\x2A\x63\x5C\x1F\xE3\xC0\xB0\x1C\xEC\x46\xDC\xDC\xCF\x7B', #80
        b'\xA9\x1B\x65\x2F\x7E\x11\x9F\x0D\x9A\x18\xCD\x9B\xE4\x6B\x0B\x04\x5F\xD1\x1E\xE0\x89\x3B\xC6\xC3\xEB\x9A\x68\xED\xFA\x25\x90\x13\xAA\x21\xB1\x76\x26\x64\x89\xF4\xD9\x1E\x39\x19\x8F\x4D\x63\x8F', #81
        b'\x9B\x12\x71\x53\xA2\x3F\xF9\x2C\xA4\x68\xEA\x60\x51\x4A\xE8\xBF\x5C\x03\xB3\x55\x12\xC8\x58\x2C\x24\x4D\x03\xC0\x52\x46\x97\x69\x3F\x89\x61\x0C\xFE\xE9\xDA\x48\xC0\x3E\x3A\x87\x8D\xC3\x74\x56', #82
        b'\x5C\xD0\x61\xA1\x83\x65\xFD\x7B\xAB\xC0\x6B\x3F\xA9\x33\xC5\xD1\xEA\xF3\xE1\x9F\xE3\xA3\x4D\x90\xB7\xA3\xAC\xC7\x7B\x3B\xC1\x1E\x55\x91\x3E\xF3\x3C\xF9\x81\x05\x3E\x90\x41\xB2\x30\x8F\x7E\x65', #83
        b'\x2A\x5C\x4E\x65\x3E\x3A\x38\xB4\xCB\xC0\x80\xCE\x9A\x5B\xD3\x5F\x33\x58\xFA\x5D\xDC\xA2\xEC\xF2\xA6\x4D\xB2\x93\xC9\xF7\x43\xCE\x9D\xE5\xB1\x88\x47\x9F\xBD\x36\x36\x53\x63\x7E\x47\x53\xCD\x11', #84
        b'\x51\x38\x67\xEE\x40\x0B\x80\x39\x42\xF0\x4F\xA7\xC2\x10\xE4\x54\x7D\x70\x7D\x0C\xF0\x78\x8C\x83\x3A\x13\x74\x39\xBF\x7C\x09\x8D\xC1\xC9\x9B\x2D\xE1\x6F\x8E\xD6\x71\x25\xAA\xF5\xCC\x63\x65\xED', #85
        b'\x55\x45\x7A\x44\xAA\x50\x4B\x55\xEC\xA2\x91\x10\x8D\x66\xC4\x07\x4B\xBE\x18\x6D\xA7\x52\x2A\x95\x80\xB7\x3D\x0E\xB0\xB9\x7D\xB8\xB9\x09\x32\x29\x29\x25\x12\xAB\x2F\xF1\x83\xA8\xA2\x44\x2A\x40', #86
        b'\xD9\x7A\x23\x21\x30\x9F\x00\x5E\x5E\xAB\x89\x25\x07\x04\x4A\xAF\x12\xDC\x06\xBB\xF5\x97\x8A\x1B\x0E\x55\xA2\xDF\xE1\xA1\x95\xCB\xF1\xD6\x09\x6E\x69\x5C\xB8\xEA\x0F\xF1\x61\xF6\xF4\x71\x4D\xF9', #87
        b'\x94\xAE\xAC\x96\x2A\x2E\x51\xF6\x10\x3E\x5A\x2F\x19\x52\x61\xC2\x1D\x8C\xA4\x23\x5D\x46\xBE\x29\x04\xB8\x44\x46\x6C\xB5\x51\x4D\x85\xBB\x8C\xF5\xB6\x83\xC4\x60\x3F\x39\x79\xD5\x3B\x79\x09\x87', #88
        b'\xFA\x0B\x45\xDA\x96\x6A\xC2\xFB\x8B\xE0\xD4\x01\x43\x0E\x1A\xC1\x12\x11\x52\x36\xF9\x16\x8A\xF2\x64\xA0\xEC\x41\x3A\x54\x1F\xF5\xA6\x98\xCE\xDC\x5E\x87\xC8\x86\x38\x28\x4B\x51\xA3\x36\x89\xC0', #89
        b'\xEC\x3C\xF1\x8E\x70\xFB\xAF\x19\x11\xEE\x3C\xE8\x21\xB6\x64\x9C\xEA\xB2\xDE\xA7\x3D\x5B\xE2\x49\x93\x42\x04\xA8\x2E\xCF\x18\x0A\x19\x65\x7E\xA3\x36\x13\x59\x88\x78\xA7\x8C\x1A\x4B\x11\x25\x63', #8A
        b'\xF1\x2C\x48\xC7\x60\x47\x19\xC0\xD6\x9E\x26\x1F\x1E\x83\xCB\x3C\x16\xAC\xBB\xA6\xD4\x52\x08\xDF\x27\x8A\x9C\xB0\xE5\xD9\x63\x89\xE6\xD8\xAD\x9B\x5C\x72\xD2\x55\x57\xF5\x94\x28\xC7\x96\x2F\x23', #8B
        b'\x84\x84\x75\x58\x2D\x43\xF3\x05\x09\x8F\x26\xC0\x4A\x31\x23\x63\x37\x0E\xC3\x4F\x1B\xE0\xDA\xDC\x55\x7B\x7B\x07\x6E\x6C\x2B\x99\x0F\x12\x9C\x01\x81\x7F\xE1\xC3\xB6\xA9\xD8\x28\x2B\x3D\xE7\x32', #8C
        b'\xD6\xA1\x31\xD6\xAB\x98\x26\x1D\x89\x92\x09\x56\x4E\x71\x04\xB8\x80\x01\x41\x13\x82\xA0\x84\x15\x7E\x40\xF4\x83\x85\xAB\x99\xB6\x72\x1C\xF4\x63\xBD\x04\x09\x62\xC9\x79\x32\xE1\x0F\xE6\xFF\x88', #8D
        b'\xFC\x8D\x5E\xD5\xDD\x2D\x85\x89\x2F\x5B\xBC\x08\xAE\x55\xDC\xA7\x0F\x85\xE7\x6A\x27\x0B\x78\x5E\x53\x37\x6F\xDA\x46\x39\xAB\x02\xBF\x7D\xE0\x1A\xDA\x5E\x02\xDC\x3C\xE1\x6A\x48\xE8\x01\x36\x09', #8E
        b'\xC7\x4B\x87\x54\x3E\x71\x30\xE8\x47\x7F\xCC\xA4\xB8\x0A\x01\x77\x03\x1D\x4E\x86\x44\xD9\xD5\x02\x42\xDC\x92\x66\x68\xCA\xA4\x13\xCA\x2D\x9B\x5A\xE4\xEA\x5E\xD6\xCE\x5F\xE6\x9D\xFD\xF1\x1F\x1D', #8F
        b'\x0D\x6F\x3D\x6B\x16\xD7\x14\xB9\x84\x54\x48\xD2\xA0\xCB\x27\x7B\xCB\xBF\xA8\x6F\x50\x7E\x06\xBD\x8E\x94\x72\x64\x8A\x2D\xCD\x88\x2F\x81\x91\xAF\xC9\xB8\x05\xF7\xE3\xCC\x63\x7E\x4B\x19\xFE\xE3', #90
        b'\x51\x2E\x72\xF9\xCC\x34\x9A\xFF\x99\x23\x3D\xF3\x90\xB7\x78\xFB\xBD\xF0\xF5\x31\x89\xE6\x2E\xEB\xF2\x5E\xBE\x4B\x6E\x0B\x7F\x56\xF9\x6B\x0F\x20\x3F\xEA\x15\x29\x64\xCA\xC3\xFB\xFF\x7F\x8C\x14', #91
        b'\x5B\x87\x8F\x8D\x73\x18\x30\xDC\xAB\xC0\x8A\x1A\x7D\xE5\x55\x5F\x7D\x16\xFB\xF3\xED\x64\xF8\xA6\x88\xB1\x64\x7C\x5E\x21\x61\x5D\xF7\xF9\xA8\x99\x86\x6C\xAE\xAE\xD4\xE9\x2D\x6E\x63\x32\xD1\x9F', #92
        b'\x90\xA5\x22\x49\x9D\x09\xAF\x0E\x51\xA1\x54\x78\xB7\xF9\x7F\xED\x1C\x4B\x7E\x71\x1B\x7A\x12\xCC\x84\x3D\x32\x66\x02\xB7\x3D\xC4\x59\xE7\xBA\xFD\xA5\x8C\x00\xF0\xDC\x1D\xE6\xB9\x30\xD9\x91\x00', #93
        b'\x5E\x3B\xB0\xF9\xA4\xB5\x7C\xA5\xBC\x25\x5F\xE7\xD2\x46\xCE\xB7\x08\x2A\xD3\xB5\xBC\xD1\xE9\xC1\x4D\x40\x30\x4A\x40\x51\x27\x23\x84\xCC\xF7\xB0\xFE\x28\x81\xF5\xB6\x36\x14\x49\xAD\x28\x5B\xF8', #94
        b'\x67\xE8\xC3\x3A\x3B\xA8\x19\x26\x2E\xD5\x90\xCB\xD6\x5B\xD1\x89\x35\x78\x60\xBC\xBD\x50\x74\x3B\x4F\xF1\x0B\x29\xFA\x2C\x88\x97\x8B\x63\x2D\xE0\x63\x5E\x03\x53\xAC\x72\x89\x31\xA0\xC4\xE1\x5D', #95
        b'\xA7\x43\x28\xF0\xAB\x7B\x24\x6B\x9E\xE3\xD7\xD3\xBD\x72\x18\xB9\x95\xBF\x28\xF7\xF4\x8D\xB8\xA7\x80\x7B\xDC\xCF\xC5\x54\xBB\x40\x01\x47\x6B\x12\x36\x36\xBF\xFA\x80\xE2\xF4\x19\xB2\xCC\x08\xB0', #96
        b'\xD3\x20\xC5\x6D\x1F\x11\x02\xC2\x66\x6A\xDD\x96\xEA\x63\x78\xDD\xD1\x17\xAB\x72\xB7\xBE\xD9\xCA\x50\xAD\xE4\xDB\x44\xF4\x42\x60\x8E\x41\x49\x55\x13\x76\x07\x18\xBA\xB8\xE7\x18\xB7\x10\x34\xBD', #97
        b'\xD2\x66\xBE\x80\x11\xAD\xB6\x28\xB5\x3D\xE7\xCC\x24\xCA\x4E\x3F\xE3\x48\x0E\xBA\x86\x6F\x67\xE4\x34\x02\x5E\x9C\xE7\x7A\x23\x4E\x7A\xBF\x9A\x00\xBC\x4A\x12\x18\xEC\xC4\x6D\xCB\x0D\x6A\xFF\x53', #98
        b'\xB3\x34\x47\xDA\x0C\xE4\x3B\x66\x90\x72\xF2\x85\x70\x24\x16\x44\xB6\x2B\x6A\x2D\x10\x16\xB0\x67\x1F\x91\xEA\xE0\x39\x39\x8D\x01\xDE\xCF\xEF\xB9\xF0\xF0\xC9\xEA\xAB\x7B\x0E\x65\x82\x0F\x06\x71', #99
        b'\x95\x0B\xD7\x7A\x87\xA8\x7F\x66\x3A\xFD\xF0\x93\xBC\x4E\x6D\xC1\x05\x41\xFC\x8E\x2D\x2E\xD9\xF7\xD1\xE0\x20\xF0\xCF\x7A\x64\xC9\x04\xA8\xA4\x12\xE7\xD0\x79\xE0\x31\x2F\x24\xEB\x13\xEF\x11\xB5', #9A
        b'\x29\x5E\x8F\x0D\xD9\x65\x5E\xC1\xC7\xBD\xAC\xAE\x38\x77\xE7\xE7\x53\x13\x10\x1D\xE9\x7E\xF9\x5F\xB9\x76\xFA\x41\xD7\xF9\x1F\x0F\xAA\xDA\x47\x72\x28\xB4\xA4\x5E\xC7\x85\xC5\x69\xEC\x57\x28\x2A', #9B
        b'\x07\x72\xEA\x5F\x66\x69\x9F\x26\x3A\xB1\xA2\xE0\x68\x8F\xF2\xC1\x6E\xE7\xAA\x1A\x68\x9B\x0E\x80\x62\x4F\x87\xB0\x4D\xAC\x3A\x2D\xBD\xCA\x62\xE6\xEE\xCE\x06\xD9\xAF\x4D\x70\x2B\xBF\x7E\x13\x9E', #9C
        b'\x76\xD6\xA5\x4B\x02\xD1\x36\x33\xCE\x92\xB5\x53\x09\x88\x6C\x69\xC6\x13\x2E\xAA\x11\xF6\x0E\xF3\xB1\x73\x72\x36\x9F\x32\xD1\x2B\x40\xE3\x70\xE4\xC7\xC5\xC5\x4D\x8D\x5D\x7C\x99\x2C\x5C\x5E\x7B', #9D
        b'\xC1\xEC\x12\x16\x61\xA2\x5B\x5C\xE2\xFF\xD2\x35\x86\x68\x5A\x62\x2F\x4A\x0F\xD1\x08\xA3\x3B\x98\x93\x40\xFA\x35\x8B\xDF\x89\x58\xE2\x85\xAD\x12\x29\x8C\x00\xD1\xA5\x22\xC9\x97\x8A\xF5\xDD\x93', #9E
        b'\x37\x4B\xF8\xDF\x88\xBB\x69\x3D\x3C\xA6\x78\xB1\x0C\x7D\x67\xA3\xEF\x88\x3C\x2A\x4C\x47\x1B\x0D\xE0\xB5\x71\x7B\x77\x9A\x1F\x5B\x8C\xDD\x1A\x33\x70\xA3\x8C\x77\x3E\x2D\x02\x59\xD4\x9C\xF1\x60', #9F
        b'\xA3\x9C\x48\xD0\x01\xB2\x7D\xE3\x2F\x04\x57\xAC\xA3\x0A\x88\x29\xC5\x41\xDE\xFF\xD1\xD7\x17\xF3\x58\xB3\x41\x7D\x42\x7A\x91\x22\x43\x3E\x8A\xE7\x1E\x5D\xF4\xA3\xF3\x40\x66\x51\x4F\xA6\x2C\x4C', #A0
        b'\x2A\x1D\x07\x1F\xD5\xBE\xDB\x45\xFC\x14\x0E\xC0\xB5\x24\xC6\xF3\x53\x04\xCB\x9E\x39\xE5\x32\x49\x4D\x19\xF9\xDA\x26\xB8\x45\xB0\x07\x3E\xE7\x87\x5F\xBB\xFE\xB7\x9B\x40\xBF\x30\x49\x52\xEC\xD0', #A1
        b'\xDE\xEC\x24\x30\x97\xDD\xDB\xC1\xAE\xFE\xED\x29\xDD\x75\x4A\xD6\xCB\xE6\x97\x25\x70\x33\x8C\x32\x71\x0B\x52\xB3\x70\x81\x8E\x36\x89\xC8\x72\xF8\xEA\xB2\x52\xEA\xED\xB8\xE6\x50\x64\x6A\xCF\x75', #A2
        b'\x68\x27\x9A\x49\x65\xA7\x0F\xC6\x9B\x08\x53\x91\xB4\x4B\xC2\x94\x84\xA2\xE7\xD8\x1D\xD5\x3C\xC0\xFF\x14\xF9\x40\xC5\x5E\x03\x46\xB6\xD4\x16\xB6\x48\x59\x20\xFC\xDF\x5A\x89\xD9\xCD\xAD\xA7\xCD', #A3
        b'\x65\xFF\xF7\xF2\xE6\xCF\x3F\x6D\x26\xC9\x38\x5E\x08\x1D\x95\x45\xA9\x61\x77\x27\x1A\xF9\xD3\x8D\x8C\xD5\x38\x45\xD7\x72\xED\x6E\xF7\x64\xBB\x29\x9B\x5A\xF4\x07\xF5\x07\x80\xEC\x7B\xD8\x2F\x91', #A4
        b'\x8D\x41\x94\x9F\xC8\x4C\xA7\x92\xD7\x3D\x6E\x6C\xF4\x7F\xC6\x25\xA0\x4D\xAE\x11\x52\x03\xE6\x38\x92\x2C\xA2\x2A\x43\x6D\x9F\x35\x86\x90\xF4\xE0\xDE\x7C\x2F\xC2\xF4\xC2\x2F\x8E\x4F\x6B\x0E\x3B', #A5
        b'\xE5\x87\x95\xED\xBB\x13\xC9\xAC\xE4\x1E\x59\xD6\x91\x9E\x66\x44\x50\xA1\x0F\x2A\xED\x93\x05\x45\xC6\xB2\x96\x07\xA4\xC0\x15\x7E\x55\xA2\x03\xC0\x59\x78\xC6\x7A\xE4\x68\x75\x0D\x7A\x7B\xBC\xB9', #A6
        b'\xC7\x53\xDF\xF5\xB0\x9D\xBD\x72\x8E\x18\xED\x28\xC6\x58\xBC\xA3\xD7\xFE\xE8\x2C\xA5\x8B\xD6\x57\x81\x25\x25\x1B\x78\x04\x37\x36\x9B\x3A\x4A\xFD\x6A\x5D\x14\x45\x17\x38\x44\xBB\x34\xB1\x14\x11', #A7
        b'\x8C\xFB\xF9\x1C\x80\xD6\x11\x8D\xD6\x6A\x75\x9B\xAC\x77\xD7\x5F\xBE\xD7\x5E\x4D\xEE\xBF\x81\x5C\x45\x2B\xFC\x0B\x2D\x70\x10\x81\x15\xDA\x6A\x5E\x50\x84\x38\x9A\x3D\x5C\xCC\xF4\xC2\xB7\xE1\x17', #A8
        b'\x7D\xAE\x0A\xD8\xF2\xD0\x15\x8E\x75\x36\xF1\x63\x50\xBD\x84\xFA\xE4\x82\xB1\x84\x84\x7F\xDE\x58\x1C\xF0\x85\xC5\xE6\x9E\x69\xF7\x48\xBE\x15\x7B\x28\xAB\x22\x80\x08\x33\xCB\x46\x25\x96\x34\x60', #A9
        b'\x88\x74\xF6\xC4\x00\xFD\xA1\x77\x8A\xF3\x8E\x9D\x49\xF0\x37\x3A\xBE\xB6\x22\xF8\x44\xF7\x72\x99\xAC\x65\x5A\xE4\xE3\xD2\xDC\x9B\x40\x8F\x4D\x37\xCA\x0E\xA6\x02\x90\x6D\xEF\xF2\xF1\xB0\x58\x00', #AA
        b'\xF3\xB7\xF6\xB5\x1B\x38\xC9\xA4\xB1\x6D\x85\x2D\x6A\xFA\x41\xAC\xD4\x20\x07\x3A\x96\x24\x62\x53\xAA\x42\x8C\xF4\xD2\x6B\x91\xCA\xCA\x09\x50\x1A\xB9\xC1\x4B\xF6\x94\x8E\x6B\x0E\x58\x3E\xE3\xD3', #AB
        b'\x49\x49\x1C\x25\x8E\xA8\x47\xE3\xB4\x26\x1C\x80\x62\x9F\xD4\xBA\x1F\xF8\xC5\xCD\x87\xEA\xE3\xE3\x11\x26\xA6\x73\x66\x9C\x84\x1C\xCA\x5B\xF2\xD6\x40\x0D\x99\x53\xCA\xBE\x6E\x5B\xA9\x50\x17\xFA', #AC
        b'\x0D\x9B\x3A\x9C\x81\x00\xE3\x4A\x0D\x76\xCB\x44\xD0\x2B\x62\xF7\xB5\xC8\x30\x9F\x08\x5A\x88\x0B\x9C\x35\x17\xDC\xFF\xB1\xFA\x17\x9F\x3B\xEF\xE0\x1D\xDB\x34\xD2\x1F\xC1\xBC\xB8\x20\x97\x4A\xC3', #AD
        b'\xF0\x83\x1E\x56\xFE\x37\x61\x30\x6F\xBE\xE7\xB0\x56\x18\x50\xEE\x48\xDC\x19\x16\x06\x44\xB6\x83\x02\x43\xD3\xCC\x96\x04\xC6\xDC\xBE\x81\x7F\xE5\x3E\x6C\x63\x6E\x83\x7C\x8E\x88\x78\x1F\x3E\x40', #AE
        b'\x5B\x47\x7C\x40\xC4\xEC\x0D\x47\xAE\xCA\x1C\x3A\x46\x55\x4E\x63\x46\xBD\x42\xEC\x0A\x24\x5E\xBD\x29\x49\x06\xA9\xEF\xA6\x0B\xE0\x0A\xC5\x1F\x39\x09\x14\xB4\x49\xC5\x40\xCB\x4C\xCF\x1B\xF4\x59', #AF
        b'\x70\xED\x12\x77\xBF\xF9\x32\x3F\xF8\x6A\x37\xB3\xB1\x9B\xDA\x0C\x65\xA0\x6C\x14\xE5\xFE\x52\xCB\xA1\x2A\x00\xE8\x40\x74\xB0\xB8\x69\xC4\xE6\xEB\xD3\x40\x44\xD7\xBE\x7C\x07\x4F\xAC\xA3\x1E\xA6', #B0
        b'\x11\xF4\x58\x76\xE8\xEA\x4C\xF7\xC2\xC3\x58\x80\x9D\xF6\x02\x0E\x32\x0C\x92\x1C\x08\xE8\xDF\x79\xE2\x0C\x22\x9E\x0B\x94\x72\x74\xEB\xE3\x90\xE9\xE6\x77\xB7\x2E\x09\xB5\x06\xE5\x63\xA0\x1D\x68', #B1
        b'\x84\xFB\x6F\x54\xB4\xD9\x3B\x68\x81\x7E\xF6\xE4\x54\xBC\xC2\x0A\x80\xEE\x99\xBF\x2A\x00\xEC\xCA\x19\x06\x82\x9C\xA6\xF0\x70\x80\xD7\x98\x74\xC7\x14\x6C\xF9\x6E\xD6\x71\xCC\xA6\xEB\x85\x19\x51', #B2
        b'\xD0\x8C\x75\x0B\x8A\xB9\xD9\xAC\x6B\xD8\x45\x97\x60\x66\x7E\xDE\xD5\xB5\x9D\x70\xCB\x87\x91\x5C\x74\x4B\xEA\xA7\x70\x63\xB0\x9A\xFA\x2B\xA6\x53\x07\x47\xA4\xC8\x20\x0C\xF4\x7C\xBB\x28\xA4\x3D', #B3
        b'\x5F\x2E\x5A\x66\x4E\xED\x85\x4B\x8C\xE1\x84\x12\xA6\x9E\x08\xAE\xC1\x26\x45\x7A\x93\x19\x06\xAA\xC0\x18\x91\x73\xFD\x5C\xA4\xB2\x1D\xBC\x1D\xFB\x96\x36\xAB\x7B\x22\x08\x59\xA3\x15\x56\xD5\x88', #B4
        b'\x25\x35\x62\x02\x38\x83\xF8\xBF\x96\xEA\x05\xBD\x71\x0F\x2F\xE0\xFF\x84\x5A\xB4\x57\x4D\xE3\x2A\x70\xD8\x57\xF5\x0F\xA9\xE8\x20\x75\xEE\x32\xFF\xA5\x4A\x83\x78\x61\xBF\x09\x06\x53\x16\xA0\x2C', #B5
        b'\x0B\x50\x20\x86\x54\x62\x7B\x7D\xE2\xE5\xB8\xDE\xD4\x7C\xE7\x38\x17\x1F\x47\x09\x63\x52\xE1\x6A\x23\x38\x8C\xDF\xD0\xC6\xDF\x33\x28\x75\x0F\xE7\x62\xA9\x3B\x62\x92\xDA\x26\xA9\x2C\xD7\xCB\xAA', #B6
        b'\x13\xEC\x5F\xF2\x95\x83\x92\x97\xE6\xB4\xE4\xFD\x84\xDD\xC6\xC8\x4B\xAA\x21\x5B\x8A\xCF\x50\xEA\xE6\xB6\x00\xFB\xA9\xE8\xD5\x90\x34\x56\xB8\x45\xEA\xBD\xB7\x9D\x33\x80\x28\x68\xE4\x75\x18\x70', #B7
        b'\x7A\xB0\xB9\xF0\xC9\x42\xBD\x54\x41\xF0\xB9\x2F\x57\x7A\xA4\xDB\x3E\xCD\xD6\x02\xA3\x77\x9B\x90\x5C\x3C\xCC\xD2\xE0\x5A\x4E\x77\xB1\xFA\x04\xBA\x94\xE5\xE2\x0C\xC4\x82\x37\xE1\x55\x58\xEE\xB0', #B8
        b'\x9C\x84\x02\x03\xB0\xC8\x9D\x3C\xF1\xA4\xF7\x45\xA6\x5F\xA8\x38\x59\xE3\xA7\x91\xEC\x75\x44\x9A\xC9\x0F\x90\xF3\x1A\x16\xE9\x69\xA0\x68\x02\x5E\x4A\x6C\xB8\xD1\x9B\x10\xD2\x66\x63\x60\x57\x0C', #B9
        b'\x35\xAA\xAD\x46\x02\x16\x55\x87\xA7\xFA\xBD\x32\x84\x19\x68\x50\x1A\x8E\x1F\x7E\x84\x3C\x1D\x7A\x8E\xFE\xF7\x0E\x14\xAC\xDA\x23\x50\x5A\x7B\x9C\x4A\xD2\xF2\xC7\x4F\x3C\x45\x6B\xFE\x11\xD8\xF3', #BA
        b'\x0B\x8D\xA1\x53\x8E\x52\x96\x5A\xF9\x41\x32\x5C\x42\x2C\x5E\x42\xE4\x48\x5F\xD1\xE3\xAB\xB8\x27\x0F\x49\xBB\x8E\x81\x97\xEA\x48\x15\x53\x3A\x86\x5E\x78\xAE\xAB\xDD\xA0\x2B\xAD\xD7\x30\xFA\xEF', #BB
        b'\x48\x43\x78\xF7\x20\x50\x9D\xA9\x71\xA1\x92\x74\x24\xD8\xDC\x7C\x96\x1C\xEA\xAF\x5D\xA0\x0E\x42\xAD\x0F\x6F\xCC\x34\x9E\xC2\xB3\xF9\x15\x8B\x51\xD3\x67\xF9\x3E\xF4\xAD\xA2\x68\x25\x2F\x26\xE8', #BC
        b'\xD8\x16\x17\x99\x2D\x5E\x39\x93\x8B\x77\xEC\xFF\xD0\x68\x18\x2C\x77\x03\x07\xF1\x61\x15\x39\xD2\xEE\x65\x12\x20\x6C\xA0\xDA\x2C\x00\x2A\xEA\x8D\xCF\x3E\xBF\x28\xBA\x45\xA7\x21\x7C\x5C\xD5\x26', #BD
        b'\x8A\x95\xA8\x1C\xDB\x07\x48\xF9\x09\xE9\x55\xAE\x89\x12\x72\xFE\x88\x3F\xBE\x4E\x17\x10\x41\x8E\x02\x7B\xD2\x23\x61\x92\xD5\x6B\xC2\xDD\xAA\xF8\x36\x2B\x99\xBC\x8C\x89\x8F\xC8\xC7\xBF\xEB\x3F', #BE
        b'\x25\x14\x0A\xB0\x06\x78\x12\x2F\x58\x2B\xA6\x60\xBE\xDC\x4B\x3E\x2E\x83\x2B\xA5\x48\xB0\x06\x6A\x72\xDF\x43\xCC\xA0\x93\xC3\x82\x34\x4B\x4F\xFB\x28\xA0\xE2\x06\x33\xA8\x79\x0F\xEC\x64\x87\xF9', #BF
        b'\xD7\x35\xB0\x58\x06\xFA\xFB\xB7\xC4\xC3\xC8\x8D\x71\xFC\x93\xC1\x0B\x82\x3E\xCC\xD7\xAB\x74\x24\x59\xE2\xFC\xBF\x76\xC4\xD9\x2D\x08\x2B\xEF\x38\xFD\x0A\x6A\x0C\xCD\xBC\xE0\x50\xB8\xA6\xA1\x90', #C0
        b'\xA5\xEC\x93\x51\xD9\x16\x69\x81\x36\xFC\x73\x85\x80\xFA\x0A\xFD\x91\x48\xA6\x9E\x46\x1E\x55\x93\x34\x26\x78\xFE\xE0\x14\x9E\x94\x68\xE4\x13\x28\x70\x50\xC8\x1D\xD3\x3E\x1D\x40\x98\xA6\x4A\xCD', #C1
        b'\x69\xCE\xD3\xD4\xC3\x8A\x80\xA9\x0C\x36\xF1\xE1\x75\xF3\x60\x4A\x2D\x2C\x98\xBF\xB2\x68\x47\x8E\xC4\xFC\x72\xB5\x36\xA4\x79\xD6\xEC\xE3\xED\x3A\xED\xF6\x29\xA0\xC9\xF4\x05\xD3\x0F\x2E\xBB\x03', #C2
        b'\x4A\x7A\xDF\x8D\x55\x4E\x03\x9B\x53\x32\x8E\xA5\x23\xDC\x56\xBB\x52\xDE\x23\xBF\xA8\xD6\x72\x4F\x2E\x49\x93\xD7\xDC\x44\xE4\xE3\x26\x9C\xF5\x6F\x8E\x9E\xAE\x83\x4C\xC4\x32\x4E\xD7\xE3\xC2\x26', #C3
        b'\xFD\xC2\x9B\xE0\xB2\xF0\x22\x90\x69\x14\xD3\x14\x4A\x09\x6F\x72\x1E\xFB\xA0\xF5\xF8\xE7\x1A\xC6\x5C\x23\x90\x20\x36\x74\x55\xCF\x36\xCA\x8B\x2C\xC0\x5E\x10\x94\x63\x08\x0F\x8D\x80\x82\x3C\xDD', #C4
        b'\xA5\xEA\xDA\xB6\x95\x17\x92\xCB\xDA\x3F\x3F\x12\x5E\x14\x87\xA5\xAF\xBD\xDC\x0B\x1F\xB3\xEC\x38\xB2\xFC\xF3\xFB\x6F\x22\x39\x24\x73\x42\xFE\x2C\x14\x69\x03\x42\xFB\x2C\xE5\x63\xC6\x1C\xED\xF2', #C5
        b'\x2A\xA2\xE0\x31\xC6\x5D\x6A\x59\xB0\xDA\x89\xD1\xB5\x32\xD1\x42\x99\x05\x9D\x9C\xD1\x96\x23\xB3\x04\x17\x72\xF6\xFA\x9C\xF4\x9F\x71\x08\xF0\x54\x08\xA4\xC5\xB0\x0A\xB6\x65\x96\x0D\x30\x78\xA6', #C6
        b'\xE3\x3D\xBD\xBE\x30\xDF\x98\xD3\x01\x02\xD8\x40\xFA\x10\x17\x28\xA7\x94\xB5\x1E\xAA\x60\x4D\x96\x78\x75\x19\xD2\xB7\x6D\x47\x45\x4D\xE0\x8C\xC1\x91\x9C\x1D\xA0\xD2\xBC\x95\x20\x87\x66\x10\x98', #C7
        b'\x30\x35\x21\x55\x4C\x82\x47\x3B\x39\xF3\x8E\x8F\xF3\x74\xB9\x79\x7A\x25\xBF\xC8\xCB\x43\xFF\x4E\x68\x11\x4C\xAE\xA4\x7C\xC7\x22\xAF\xDF\x0D\xD1\xFA\xC0\xA9\xCB\xA8\xC4\xDD\xE5\xD0\x07\x7D\x69', #C8
        b'\x1F\x3B\xE3\x06\x4A\xF3\xE4\xF5\x06\xEF\x36\x7D\xDD\xFB\xC5\xC0\x45\xA2\x4B\xE4\x47\x1D\xE5\xDC\x01\x46\x45\x8D\xCC\xC3\x8B\xDC\x53\x35\xED\x0B\x6C\x02\x2D\x29\x5C\xB6\xFF\x4B\xCA\x8E\x30\x2A', #C9
        b'\x51\xDD\xAF\x63\xD3\x33\x96\x89\xDD\x84\x58\x8B\x2B\x68\x49\xCF\x22\xA0\x7F\xD1\x85\xFB\x80\x66\x9C\x8D\xBD\xCD\x17\x4B\xF0\xA3\x15\x43\x8A\xEC\x1B\x81\x2C\x75\xFF\x73\x13\xDD\x3C\x21\x15\xF4', #CA
        b'\xAD\xEA\x9F\xB2\xC6\x8F\x9B\xC8\x13\x4C\x9A\x00\x00\x90\x38\xE9\x28\x3F\xD7\x52\xDC\x9C\x75\x0A\x98\xC7\x43\x71\xDA\x82\x23\x08\xCA\x2B\xAD\xFD\x5E\x78\x8B\x36\x1B\x54\xE7\x11\x6B\x63\x12\xCE', #CB
        b'\x4A\x1F\x08\xC2\x76\xC5\xA9\xB0\x62\xAD\x7B\x28\x82\x57\xBC\xFC\x67\x8C\xAA\x4F\xBF\x90\xFB\xF7\xF9\x87\xC2\xC9\xD3\x0D\xF6\x69\xF0\x26\x9F\x1D\xD2\xA2\x7A\x56\xFC\x62\xED\x98\x78\xB8\x38\xE1', #CC
        b'\x41\xE8\xA5\x81\x09\xCB\xC0\xBB\xC3\x0E\x7A\xC0\xCC\xD3\xD1\xB7\xAD\xBB\x44\xBD\x60\x5D\xBC\xDD\x56\xF3\x8F\x82\x5D\xC3\x0C\xCC\x63\x57\xCD\x30\x14\xBE\x98\xA8\xFF\x71\xCE\xD2\x75\xB0\xDC\x9C', #CD
        b'\xAE\x64\xE6\x73\x1A\x0E\xFE\x0A\x92\xF2\x3F\xD0\xDD\x83\x97\x73\x6F\x17\x45\xA6\xDE\x1B\x4D\xAE\xDE\x43\xEF\x2E\x4E\x53\x6C\xA2\x7C\x68\x9A\x47\x7D\xA3\x94\x95\x5A\x41\x44\xBF\x62\xBD\x0E\x95', #CE
        b'\x8A\x08\x00\x51\x31\xF6\xDE\xE4\x97\x48\x87\x1E\x1A\x7B\xEA\xF2\x68\xB4\x42\x84\xFB\xD8\xEE\xDA\x34\xBA\x6E\xAA\x8B\x07\xA9\x48\x51\xD9\xE8\xC4\x36\x02\xE0\x6D\xD4\x9D\x2C\x5D\xDB\x29\x3B\x0E', #CF
        b'\x8B\x42\xFB\xA4\x17\x97\x02\x0C\x70\xD1\xF8\x48\x24\x11\x9F\x5E\x50\xFE\x88\x6D\x27\xC8\xDA\x41\xAD\x4D\x1A\x2C\xBA\xDA\x53\x7F\xBB\xE4\x98\x22\x58\xFA\x6F\x30\x87\x69\x05\x3D\xE3\xEE\xDF\xF9', #D0
        b'\x00\x2E\xFC\x51\xF1\x4A\xCA\xF6\x74\xA8\x84\x0A\xE2\xE7\x64\x23\x5B\xE4\x73\x9C\x61\x93\xA4\xC8\xA1\xDC\x2A\x75\x6C\x98\xCB\x68\x91\xD9\x37\x72\xA4\x9F\x21\x0B\x14\x1B\xA0\xD8\xBD\x4E\x54\x55', #D1
        b'\x19\x20\xDF\xB6\x9E\x8C\xB0\x89\xE3\xD2\x6F\x91\x08\x67\x2F\x60\x60\xB4\xEA\xC5\x99\x72\x1E\x39\x1C\xCB\x92\x9C\x50\x6C\x41\xEA\x81\xCC\x08\xFE\xB6\x04\xF6\x19\xC1\xC8\xD5\xDF\x6C\xBC\xC4\x55', #D2
        b'\x35\xC7\xCC\x74\x6D\xD7\xDC\x67\x72\x68\x9E\x5A\xD8\x62\x22\xAD\x02\x50\x3B\x1D\x3C\x65\x99\x66\x65\x22\x8A\x8B\xC8\x0D\x5D\xEC\x93\x3A\x5F\x4C\x43\x37\x95\xD7\xDE\x7E\xA8\x54\xDF\xB0\xD1\xD3', #D3
        b'\xBC\x6A\x7D\x3A\xF0\x1A\x17\x30\x11\xEC\x57\x6F\x1E\xA7\x25\x03\x33\x9F\x8E\xE6\xAA\xEF\x3C\x50\x96\xC9\xAF\x5B\xE5\xE7\xFE\x9F\xEE\x2C\x0B\x29\x1D\xF4\x54\xBC\x07\x26\xEB\x46\xCF\xF7\x3B\xB3', #D4
        b'\xC2\x31\xA2\x19\xFD\xDE\x51\x80\x99\x3F\xFD\x58\xD5\xBE\xC5\x1D\x1A\xC5\x82\x83\x08\x5C\x70\x2B\x39\xD7\x78\xA7\x38\xBC\x21\x0A\x0B\x99\xAC\x2D\xCB\xB2\xD1\x0F\x42\xA8\x98\xBE\xB0\xF1\x87\x27', #D5
        b'\xBB\x78\x93\x91\x1F\xBF\x97\xFE\x7D\x17\xE5\x62\x21\xF9\x58\xE4\xF5\x94\x2F\x4F\x9F\x3F\xB1\x99\x80\xE8\x34\x42\xFA\xDC\x3C\xD9\x8F\xF4\xE4\x23\x3B\x95\x8B\xA9\x1E\xAB\xE2\x03\xB0\xFF\x96\x63', #D6
        b'\x93\x4E\xEB\x3C\xD6\xB4\xBE\x2E\x86\x00\x38\x06\xF9\x0F\x6B\x04\xED\xB9\xF6\x6C\x68\x6A\x9E\x8A\x46\xDC\x85\xA0\x48\x4B\x18\x32\xE7\xA5\xF6\xFC\x61\x22\x6C\x7C\x0B\xE0\x0E\x95\x9D\x16\x5C\x00', #D7
        b'\x4F\x15\x24\x7D\xA8\x9D\x05\x9A\x6A\xD0\x66\x28\x89\x38\x0A\x5E\x9A\x61\xC2\x76\x40\xD6\x5F\xA0\xB3\x14\x23\x75\x63\x25\x8E\xD6\xA2\x9B\xD5\x92\xF8\x0D\x71\xA3\xEC\xCA\x6D\x5C\xDF\x84\xA1\xCA', #D8
        b'\xC3\xE2\x9A\xF0\xE7\x1C\x2A\x92\xB8\x1E\xF1\x38\x1A\x92\xE0\x7B\x4D\xA2\x23\xB9\x38\x3F\x7A\x21\x57\x46\x66\xF3\xB2\x40\xA5\x5A\x6C\x4F\x6A\xEF\xC4\x22\xF2\xAF\xBB\x6E\x1D\x84\x6A\x71\x03\xDF', #D9
        b'\xF6\xA5\x71\x0B\x69\x12\xEB\x36\xAA\xCF\x4A\xBB\x8A\x2A\xA3\xA4\x4C\x9E\x53\x39\xEC\x1B\x6B\xEE\x77\x09\x82\xB9\x41\x14\x01\xC9\x40\x3F\xF5\x6A\x72\x60\xD4\x1A\xF8\x59\x4A\xAA\xD6\x25\x23\x94', #DA
        b'\x04\x42\xFE\x26\x98\x5C\xED\xE8\x5B\x66\x84\xC9\x64\xCE\xD8\x24\xD4\x84\x4B\x78\xF9\xBC\xF0\x59\x8C\xDC\x00\x0D\x45\x15\xD7\x7F\xC6\xB2\xD1\x03\x72\x82\x56\xE9\x0E\x9F\x40\x7B\xDB\x94\xDF\x6E', #DB
        b'\x6E\x1F\x85\x02\xC5\x2D\x52\xE4\xBE\x90\x0F\x0D\xCF\x53\xBE\x64\x67\xBA\x65\x25\x88\x5A\xC9\xB3\x4A\x8D\x00\x12\x22\x2A\x13\x6D\x0B\x6F\xC3\x65\xD5\x97\x01\x2F\x58\x96\xBE\xFF\xC2\x70\xF2\x13', #DC
        b'\x24\x6A\xB2\x0F\xF6\x7F\x89\xE8\x48\x36\x23\x72\xF2\xD2\x97\xE0\xE8\xD5\x6E\x7C\x8E\x85\xB0\x3A\x2D\x42\x55\x74\x9D\x1B\x36\xFE\xCD\xC3\x46\x15\x0D\x99\x84\xF1\xEB\x12\x62\x6A\x10\x3B\xDF\x66', #DD
        b'\xB9\x24\xE6\x86\x7B\x7F\x09\x0D\x28\xD8\x39\xF5\x2E\xA9\x7C\xD9\xC2\x2E\xD1\x0B\x42\x53\x24\x37\x52\x9D\x76\xB4\x51\xAF\xBD\xA1\x11\x75\x81\x44\x98\x2E\xB3\x00\x82\x54\x73\xBC\x10\x98\x1E\x28', #DE
        b'\xF1\x86\xB0\x5C\xE2\x9E\x64\x0C\x74\xC0\xB7\xD7\xB6\x7A\xF8\x3C\x4E\x8F\xB6\x2E\x2C\x02\x71\xBD\x1C\x96\x66\xA1\x59\xEE\x1B\xB4\xEC\x4F\xE9\xCC\xCD\x5D\x39\x74\xF5\x96\xD0\x4C\xAF\x33\x38\x59', #DF
        b'\x9C\xAF\x23\x7E\x57\xFE\xF0\x48\xA3\xF9\x0C\x0A\x5B\x1D\x87\xA7\x1B\x8A\xDC\x2B\x59\xFC\xC2\x6C\xCD\x31\x41\x63\x18\x82\x05\xE9\xC5\x6D\xF1\x1B\xDF\x42\x55\x30\x70\x28\x93\xF9\x88\x64\xF4\x38', #E0
        b'\xDD\x03\xF9\xDA\x32\x61\x37\xA5\x80\xC9\x8E\x7D\xBF\x8D\x2C\x2B\x66\x31\x13\xCA\x08\x26\x40\xEF\x51\xAA\xD8\x15\x80\x06\x40\x97\xC7\xA8\x7B\xF4\x73\xDD\xD2\x88\x59\x49\x9C\xC2\xAC\x13\xC6\x84', #E1
        b'\xDE\x95\x38\x54\x40\xBC\x15\xB7\x7D\x73\x1D\xDC\x51\x6F\x12\x53\x66\xF5\x45\x61\x33\x61\x2D\xEE\xBA\x4B\xE6\xA8\xA1\xCC\x28\x6F\xD1\x96\xFD\x81\x3D\x8C\xBF\x1B\x9A\xE2\x71\xDF\x91\x20\x69\x0A', #E2
        b'\x1D\x13\xDE\x6C\x3B\x64\x29\x29\xE2\xEB\x60\x9A\x73\xEE\xB7\x03\x7F\x59\xC4\xDC\x0E\x80\x34\xDB\x7F\x3E\xF2\x2A\x01\xAA\x92\x23\xC2\x5A\x59\x02\xFC\xB2\x25\xFF\x41\x47\xBD\x81\xBC\xBD\x5E\xA0', #E3
        b'\xA8\x79\x59\x3C\xC2\xE1\xF2\x46\x7A\x06\x72\x68\x38\x11\x2E\x43\x6C\x69\xC1\xD8\xEF\xF1\x8B\xD8\x96\xB5\x6B\xD1\x68\x86\x77\xB3\x32\x3D\x1B\xCD\x0B\x95\x67\x53\x4A\x6A\x0D\x50\xEC\xFF\x7C\xDB', #E4
        b'\x81\xBD\x33\x01\x80\x85\xFA\x8D\x7A\x4F\xE1\x71\xE2\xCD\x63\xC2\xE4\x90\xD8\x3D\x56\xCA\x2A\x61\xFD\x82\x8E\xB3\xC4\x04\x56\x30\xA0\xA2\x5B\x91\xCB\xA5\x42\x23\xF8\x8D\x10\x01\xD4\xC0\xD8\x5B', #E5
        b'\xBD\xC6\x85\x73\x95\xAF\x5F\x34\x1E\xCF\xEB\x99\xD6\x8A\x43\x74\x23\x13\xDC\x16\x85\x84\x8B\xB2\x03\xA9\xD3\x82\x8D\x4E\x9D\x7A\xEB\x4A\x3D\x26\x4C\x9A\xBC\x73\x29\x40\x58\x7A\x2A\x2E\x46\xC3', #E6
        b'\xDB\x0F\x0E\x54\x9F\xA7\x3B\xBE\x7A\x2C\x4D\x7F\xAF\x68\xDB\x91\x54\x90\xCB\x91\x51\xEA\xCD\x09\x10\x9F\x2B\xD7\x8E\xE1\x22\xAF\x85\x26\xC3\xBA\xFE\x66\xFB\x1C\x7F\x52\x0E\x68\xE5\x43\x36\x1E', #E7
        b'\x75\xCE\x7A\x8E\x92\xB0\xA8\xE5\xAF\xBB\xA4\x28\x5B\x62\x80\xEF\x04\x65\x25\xD2\x2E\x77\x69\x08\xA0\x48\xAB\xEE\x64\x2D\x15\x69\x49\xBF\xBC\x94\x36\xDC\x92\xB2\x63\x29\x69\x80\x50\xDA\x74\xB0', #E8
        b'\xF2\x9D\x6D\x3E\xF3\x86\x1A\x64\xA5\x30\xE3\x97\x7C\x72\xFE\x02\x59\x2B\x7D\xA6\x0D\x8F\x25\x5E\xA6\xCA\xC3\xCA\xB1\x7D\x72\x3D\x11\x58\x74\x19\x5F\x57\x98\x86\xD1\x88\x25\xB5\x3C\x86\xCA\xDC', #E9
        b'\x3C\xA1\xD3\xB1\xD4\xC5\x8D\x54\x95\x00\xA7\x56\x0D\x4B\x4B\x92\x97\xD7\x5A\x2B\x24\x93\x81\x64\xB4\xAF\xEE\x79\x9B\x84\x78\x39\x7C\x51\x0C\xF7\x37\xFD\x2A\x8B\x4C\xFD\x8F\xCC\x48\x9D\x13\x84', #EA
        b'\x56\x59\x2B\x35\xAE\xD0\xF3\x5D\x33\x3A\x5A\x2C\x0E\xC3\x28\x50\xA8\x6A\xC3\x37\x0E\x4E\x3A\x66\x64\xC3\x1C\xC6\x1A\xB2\xA2\x30\x62\x22\x19\x27\xF9\xCC\xB1\x2D\xBE\x9D\x01\x11\x9C\x9B\xB8\x17', #EB
        b'\xA3\xC1\x48\xA4\xF1\x98\x20\x5B\xC7\x5A\xE8\xCC\xA9\xC1\xDC\x9C\x89\xCE\x4A\x67\xDC\x94\xF2\x44\x13\x1E\x19\xFF\x59\x02\xFF\xE0\x80\xDF\x9E\x27\xD6\xAB\x56\xDA\x08\xB5\x29\x44\x71\xD5\xE9\x0A', #EC
        b'\xE9\xEB\xE4\x5F\x23\xCF\x7F\x2E\x40\xEC\xFB\x3F\x45\x51\xC2\x5C\x7F\x52\xFF\x9C\x8D\x6C\x28\xC7\x51\x8C\x69\xAD\xD8\xB6\x8A\x1C\x68\xF0\x04\x2B\x00\x45\x40\xAA\x4C\x29\x82\xFE\x6C\x7A\x59\x9E', #ED
        b'\x7B\x8F\x04\x61\xFF\x40\x8E\x01\x88\x34\xB5\xB2\xA1\x4A\x97\x7D\x3A\x6D\xA3\x7B\xA5\x8D\xDB\x7D\x52\xA9\x32\x38\xE0\x92\xA9\x07\x81\x92\xCF\x83\x02\x87\xE7\x15\x9C\x79\x25\xED\x43\x56\xFA\x69', #EE
        b'\x96\xE4\xF0\x94\x8C\x0E\x75\x45\xE7\x1F\x91\xF6\x4E\x6D\x3E\x82\x6A\xC1\x52\xAB\x10\x62\x6D\x5B\x61\xA2\xA8\xA8\x0A\x3D\x37\xDA\x11\xBA\x9A\xD6\xFE\xA8\x1A\xD0\x56\x82\xAB\xF6\xB1\x1E\xD7\xF6', #EF
        b'\x88\xBB\x59\xF0\x00\xCB\x57\xFF\x9C\x1E\xC9\xDA\x89\x08\x2F\xF6\x8B\xE3\x80\xBF\x3D\x5C\x57\x4F\xE1\x75\xF9\xAD\x13\xCE\x59\x66\x6D\x70\x4B\x69\x38\xFF\x14\x11\x0C\x7D\x17\x12\xC5\x88\xFB\xFE', #F0
        b'\xDD\xB1\x0B\x17\x26\x41\x7D\x66\x8F\x49\x8B\x11\x59\xF0\xD2\x27\xD5\xDE\xF1\xED\x6A\x7A\xEE\xE3\x4D\x42\xDC\x52\x84\x9F\xBD\x6F\x47\x8B\x78\x7A\xCA\x48\xF6\xF8\xDF\x3D\xB7\xCF\x9D\x31\x11\xA6', #F1
        b'\x9E\xA4\xF8\x10\x15\x36\x04\x98\x62\x5B\xFA\xA2\xB0\xD3\x15\x5E\xE7\xB6\x74\x5C\x76\x30\xB2\xB6\xC5\x7C\xB2\xB7\x78\xA6\xDB\x7C\x27\x2A\x32\x5B\xC4\x5E\x2A\x79\xA9\x48\x7E\x37\xD5\x9E\x30\x7C', #F2
        b'\x78\xDA\x8E\xF6\x64\xF8\x06\x4F\x8E\x4C\x58\x17\xD5\x8E\xF2\x5C\x99\x16\x3F\x99\x13\x03\x0E\xA7\x32\x8A\xCC\xBC\xC6\x1D\x3B\x4D\xDD\x0E\x50\xCB\x33\x47\x77\x5A\x94\xB5\xDC\x3F\x70\xE0\x07\xF3', #F3
        b'\x8A\x99\xC2\x07\xFF\xA2\xE7\x0C\xAD\xBD\x2A\x53\x09\x73\x48\x13\x26\xAE\xD1\x9D\x2C\xA2\xEE\x51\x1D\xA3\xA4\xEE\x94\xAA\xDE\xFC\xF1\xDB\x4B\xD8\x26\x69\x28\x31\x3B\x40\x57\x6B\x82\x64\xDE\xFA', #F4
        b'\xB1\x70\xC0\x77\x89\x20\x99\x6B\xBE\x24\x6E\xE0\xAE\x69\x51\x8C\x16\x2B\x98\x5F\x88\xF0\x3A\x6A\x06\x89\x0E\x88\x55\x94\x6E\xE7\x1C\xD8\xDF\xAE\x60\x79\xCE\xF2\xD1\x66\xDC\xE6\x00\xE4\x03\xD2', #F5
        b'\x2A\xC3\x13\xBB\x45\x32\xF0\x23\x8D\x1F\x9B\x94\x95\x60\x8A\x43\x23\x51\x30\xF4\x9D\x28\x46\x4A\x0C\xED\xE0\x9C\x75\x82\xCA\x16\x85\x12\x37\xFB\xF2\xA8\x5B\xFD\xF0\xEF\xDF\xC7\x56\x4D\x2C\x49', #F6
        b'\xD8\x57\xDF\xDF\x47\xF0\x0A\x14\xBE\x8A\x9E\x37\xAE\x0B\x31\x1F\xA1\x0A\x6B\xE2\x64\xB7\x47\x88\x5D\xA1\xC4\x98\x50\x4A\x65\xE8\xD7\xB2\x69\x33\xDE\x04\x5C\x48\xCE\x1C\x01\x26\x08\xB8\x0E\xAE', #F7
        b'\xAA\x27\xED\x44\x96\x52\x02\xC2\xAB\xA5\x6D\xB9\xF4\x8B\xD4\x0C\xDF\xA0\xF8\x5C\xF2\xF5\x84\x50\xBE\x50\x03\x73\xBC\xC7\xD6\x3F\xEC\x32\x8C\x79\x76\xB1\xA8\x8D\xDD\x73\x94\x13\x12\x64\x9B\xA5', #F8
        b'\x28\x14\xCF\x99\xCA\x31\xD7\x9A\x4C\xCA\xE8\x18\xA6\x01\x99\xF8\x5E\x4E\x03\x9D\xB5\x4F\xF0\x1A\x56\xB8\x14\xFE\x20\x38\xA1\xFA\x70\xA1\xAF\xFD\xC2\xCF\x4B\x53\x34\xC0\x2D\xAE\x0E\xF5\x35\xB8', #F9
        b'\x3A\x60\x1C\x12\xA2\x8E\x19\x85\x2A\xB6\xEB\x65\x30\x80\x31\x0A\xAF\x09\x9A\x08\x9F\x28\x52\xCB\x12\x24\x2A\x85\xEE\x64\x0F\x00\x79\xE3\x66\x4D\xCE\x2E\x83\x89\x53\xBB\x1B\xDA\x00\x0A\x98\x96', #FA
        b'\x07\x89\xC4\x27\x21\x6B\x0A\x2A\x6B\xF6\xA8\xCC\x28\xE2\x18\x28\x84\xB2\xB3\x92\x54\x4A\xCC\x93\x02\xDB\xDF\xBB\x34\xA4\x21\x33\xA6\xFB\xEE\xA5\x09\x8F\xAE\x41\xC6\xEB\x87\x6F\x23\xB8\x8E\x52', #FB
        b'\x7D\x9E\xED\x97\x78\x3A\x45\x9D\x14\x19\xC0\x96\x55\x24\x8A\x2F\x96\xE4\xBE\xAB\x7A\xC3\x09\x0A\xA5\x3D\x28\x0B\xFB\xAB\x7A\xAD\x87\xB0\xC9\xC0\x20\x25\x70\xC7\xBB\x30\x84\xD6\x85\x92\x3F\x24', #FC
        b'\x89\x8C\x68\xBF\x0F\x0D\x6B\xD6\x74\x72\x0B\x48\xF1\x5C\xB0\xEC\x41\x69\x0B\x98\x5E\xB0\x14\xB7\x76\xC0\xFD\x02\x74\x8C\xB9\xEB\x38\x4E\xF5\xD7\x98\xC1\xA9\x89\xB5\x91\x02\xDF\xF8\xEA\xFD\xAA', #FD
        b'\xC0\xA7\x78\xCF\x0C\x5A\xA1\x54\xFE\x60\xFF\x7A\x8E\x6F\xD0\xF6\x3D\x32\xB2\x51\xCD\xAE\x2A\x77\x5F\x58\x82\xE8\xE6\xC0\x2E\xF7\xA3\xCE\x20\xB8\x88\x7B\x69\x8B\x18\x0D\xEE\x58\x4F\x5B\x3E\x0D', #FE
        b'\x08\x91\x65\xD3\x32\x2B\xAD\x34\x30\xFF\xDF\xEC\xE7\x9D\x8F\x2D\x60\xFE\x58\xA8\xF7\x50\xCD\x58\xE7\xAE\x7E\xFA\x69\xBF\x12\x92\xEB\x99\xC0\x04\xD4\x4B\x41\x77\x0C\xC0\x7D\xFC\xDA\x13\xFA\x9E'  #FF
    )

    __TABLE_SBX = (
        b'\x98\x98\x45\xD6\xD7\x8F\x01\xB3\x62\x1D\x18\x6D\x80\xB1\xC9\x68\x1E\x83\x86\x84\xE8\xF2\x87\x10\xB3\x69\x4B\x46\x91\x03\x43\x0A\x34\x33\x2F\xED\x7E\xD9\x99\xF2\x44\x5F\x98\x9F\x06\x77\x33\x5D', #00
        b'\x8E\xCF\x52\x75\x99\x47\x1E\xA5\xAF\x83\x98\xC4\x6F\x34\xAB\x14\x60\xE8\xFC\xCB\xCD\x34\xA1\x20\x52\x0A\x6E\xB7\x14\xC7\x98\xBC\x9C\x9E\x15\xFC\xB6\xDC\xEB\xFC\x5C\x1C\x06\x5C\x59\xE2\x7A\xDB', #01
        b'\x33\x2C\xAD\xBF\x50\xF1\x06\x06\xB8\x51\x1D\xB9\x78\x57\x85\x66\xC9\xD3\x4F\xBC\xEE\xF7\x6C\x34\xD2\x09\x44\xEB\x8C\x76\x74\x9C\x83\x09\x31\xD6\x49\xA2\x3A\x42\xB7\xEB\x00\x0E\x16\xA3\x18\x1D', #02
        b'\xC3\x51\x39\x9F\x19\x36\x2A\xBE\xEF\x5B\x82\xA8\x7B\x6B\x69\xA4\x6C\x8D\xF7\x89\x16\x52\x32\xDD\xB4\x04\x3D\xCC\x68\xDC\x9B\xC0\x04\x6D\x42\x9E\x67\xA4\xB5\xE1\x0B\xED\x30\xC7\x24\x22\x45\x96', #03
        b'\x05\x21\x19\x8B\x9D\x7A\x72\xCC\x5B\x2A\x4F\x1E\x4F\xF3\xE8\xE2\xF0\x10\x60\x52\x37\x35\x76\xBB\xF7\x4C\x59\xD9\x1B\x44\xCD\xB9\x08\x7A\x4B\xC4\x47\xEF\x94\x8B\xD7\xF7\xCE\x87\x83\xB5\x56\xC3', #04
        b'\x22\x1B\xF9\xB7\xE9\xB9\x4D\x30\x50\x64\xC6\x31\x42\xE5\xDE\xFE\xFB\x77\x78\x73\x4D\x28\x08\xF5\xFE\x13\xC6\xB0\x63\xBC\x5D\x34\xD6\x6E\x60\x6E\xA4\x0C\x9D\x46\x9D\x8F\x69\x6F\xBE\x45\xBE\x37', #05
        b'\xB5\x39\x41\x8A\xFE\xC0\xA9\x2C\x54\x48\xE6\xBF\xA9\x30\x57\x6D\x27\x58\x3D\x4C\x1F\x41\xF2\xEB\x89\x4E\x95\x87\x67\x69\xD3\xB2\xA5\x1C\x7A\xBF\xB0\x54\xE2\x84\xA9\x6F\x33\x0B\x86\xE4\x78\x30', #06
        b'\x2C\xA6\x0C\xD0\xCB\x84\x7E\x8A\xAC\x90\x39\x33\x75\x4C\x1E\x43\x04\x70\x7E\x19\xBB\x61\xEC\x1D\x90\x68\xF1\x9B\x1E\xF4\x2B\x43\xD2\x82\xF3\xB0\xD7\x68\xB0\x87\xF7\x02\x83\xA4\xEC\x2F\x42\xB9', #07
        b'\xC6\xEB\x71\x92\x76\x73\xB4\xD6\x97\x14\x57\x20\x03\x3F\x10\xEB\xCF\x91\xE0\x9D\x30\xEB\x1F\x0F\xF8\x38\x07\x30\x0B\xC1\x40\x12\x9D\x49\xB2\xDE\x5C\x84\x63\x38\x97\x86\xBC\xE0\xF9\x0A\x87\x0D', #08
        b'\x01\xF5\x4E\x20\xCA\x63\x1A\xE3\xA4\x04\xF9\x7E\xF5\xF9\x5B\x3B\xB2\x28\x94\x9E\xC4\x1E\x56\xCF\x97\x5B\x2D\x88\x25\x36\xD5\xDB\x92\xD2\x3B\x1B\x33\x79\x2B\x64\xB8\xB3\xD6\x9C\xB2\x99\x1D\xE4', #09
        b'\x7A\x26\x76\x03\x2A\xB8\x9E\x45\x47\x27\x02\x65\x48\xF0\xCF\x59\x56\xEF\x4C\x46\x50\x18\x6F\x79\x34\x74\xBF\x31\x8F\x4A\x52\x84\x4F\x0C\x1C\xCE\xCE\x32\x80\xFF\xCD\xC9\x6F\x93\xCF\xDE\x68\x3D', #0A
        b'\x62\xE8\x95\x12\x24\xEF\x04\xD7\x87\x75\xD8\x3B\xBB\x03\x4F\x3C\xC1\xCD\x56\xD1\x71\x78\x6B\x37\x84\xF3\xEB\xD4\x8D\xC6\x80\x35\x00\x6B\x72\xE4\x84\x75\x4B\x1F\x29\x89\x74\x2F\x8F\x7A\x95\xB5', #0B
        b'\x96\x66\xFF\x1E\x22\xAB\x8B\xF0\xC6\xFA\xBB\x52\x4A\x59\xBB\x74\x54\x26\x1C\xBB\x80\x5B\x45\x81\xC5\x79\xA1\x4D\x87\xD1\x18\x5A\xD5\x20\x87\x12\xA1\x6C\x58\x1A\xE4\x00\xF2\xA0\x9F\x3A\x6D\xE2', #0C
        b'\x16\x64\x4C\x40\xAF\xFA\xDA\xD1\x40\x87\x74\x13\xAE\xD8\x5C\xB3\x5A\xCE\x06\xE5\xBD\x47\xB2\x2C\x27\x55\xDB\x69\x1F\xA0\x57\x2E\xCE\xFC\xA4\xE7\x20\x4B\xFA\x58\x59\xFC\xCF\x3D\xF7\x14\xC7\x0F', #0D
        b'\x4D\x30\x93\x0A\xBD\xB0\xA0\x59\x1B\x42\x0F\xA7\x77\xEB\xF5\x8C\x12\x9E\x25\xE9\x04\x81\x7F\x75\xD3\xF5\xAD\x21\xB7\x3C\x36\xF9\x2F\x37\x90\x58\xBC\x6E\x8F\x2A\x02\x6D\xEF\x05\x3C\x68\x46\xBC', #0E
        b'\x8D\x3A\xF5\x06\x89\x82\x5F\x0B\x31\xD4\x52\xFE\x3E\x47\x8D\x95\xCB\x7D\xF6\xCC\x67\x43\x60\x19\x92\x4F\x00\x5E\xA4\xE2\xE6\xE2\xF2\x31\x95\x69\xA7\x34\x91\xE9\x80\x4B\xFC\xD5\xD9\x18\xB5\x23', #0F
        b'\x1D\x43\x9F\xD8\xBB\x52\xA8\xD8\x6E\x15\xA4\xC2\x4B\x92\x1C\x60\x01\xD9\xE7\xB3\x46\xA9\xDA\x2F\x8C\x9B\xEC\xB5\x43\x28\x34\x6C\x82\x4E\xCC\x6D\x15\xFD\x6C\xE4\x03\x78\x93\x6D\xC7\x12\xDE\x6A', #10
        b'\x4F\x3E\x3C\xCD\xC9\x99\x5B\xEF\xCE\x00\x77\x32\xB0\xB3\xC3\xF3\xAC\xAE\x98\x98\x6C\xD9\xEF\xE9\x35\xB1\x01\xCE\xE5\x9B\xD6\x64\xB8\x6F\xF7\x4F\x0A\x28\xDB\x61\x8A\x9C\x01\xB6\xE7\xB6\x50\xD4', #11
        b'\xF7\x46\x20\x80\xF2\x98\x75\xC4\x27\xF0\xE5\xB1\x43\x37\xE2\x24\x08\x93\x85\x07\xDE\x7C\x40\x48\x68\x0D\x0C\xDE\xA5\x52\x10\x41\xAD\xF4\xD7\x3B\x89\xAF\xC7\xAF\xFB\x45\x6C\x7B\xEE\x2D\x81\x99', #12
        b'\xF1\xE6\x7C\x38\x9F\x45\x86\xF2\x5D\x6C\x4C\x6C\x21\x1E\xA4\x21\x5E\x55\x93\x99\x51\xDB\xBF\x33\x85\x85\x03\x06\x0A\x21\x47\x79\x95\x96\xE5\x8B\xAA\x01\x9E\xC9\xD5\xFB\x3A\x23\x3D\xDB\x1E\xBE', #13
        b'\xF3\xC8\x2B\x68\xB7\x96\x3C\xB4\xDE\xF9\xF7\x05\x59\x88\xC7\xE0\x1F\xBC\x7C\xF2\xF3\x0C\x42\xE2\xA4\xB0\x37\x6D\x5D\xC2\x49\xE5\x01\x01\x64\x0B\xDE\x9D\x09\x77\x58\xDE\x97\x47\x0C\xD0\x84\x49', #14
        b'\xE7\x65\xB9\x0F\x0D\xB4\x83\x74\x7E\xAF\x5F\x96\xAA\xFA\x42\x08\x29\x9B\x37\xB6\x1A\x29\x98\x88\xF2\x7C\x6D\xFE\x71\x56\x24\xD3\x06\x05\x89\x82\x5A\x40\x76\x89\x73\x5C\x37\x26\xA1\x24\x6A\x2C', #15
        b'\x32\xEC\x98\x48\x71\x76\x17\x68\x3A\x37\x90\x94\xEE\xE2\x34\x2A\xAF\xA2\xEE\x70\x0E\x9C\x9F\x97\x04\x41\xD5\x2B\xDA\x14\xDB\xB0\x02\x56\xC2\x50\x07\x1B\x0E\x7F\xF5\x81\xE1\x8F\x63\x96\x20\x0E', #16
        b'\xFC\x00\x5B\xBE\xBF\x4D\x22\x20\xDC\x81\x1F\x95\xE7\x98\x3A\x2C\xE6\x74\xB7\x3A\xCC\xE9\x89\xFB\xD0\x0E\x88\x2F\xCB\xDA\xB6\x2C\xA1\xEA\xC1\x8F\x24\x74\xD6\x41\x4B\x52\xC4\xBE\x1C\xFD\x7F\xB2', #17
        b'\xCC\xFC\x30\x83\x27\x27\xFC\xEA\xDD\x71\x1E\x8D\x12\x78\xE3\xDE\x84\x95\x5A\xE2\xF6\xD8\x6E\xDC\xC6\x60\x8E\xD7\x50\x34\x03\xA2\x53\x2E\x03\x51\x6E\x0D\xA8\x3B\x87\x15\xED\x3F\x80\x6D\x3F\x56', #18
        b'\x34\x5C\x12\x5A\xF9\xED\xF1\xDA\x89\xAE\xF3\xC6\x24\x0B\x5D\xD6\xD9\x2D\x87\x38\x5B\x67\x38\x6D\x41\xBE\xAC\xA0\xD6\xAC\x22\x95\xF5\xF0\xEE\xA5\x38\x5D\x8B\x2B\x2B\x27\x31\x2D\xF2\xD7\x83\x68', #19
        b'\x78\xB6\xD7\x2E\x09\xE9\xF4\xFB\xA5\xFD\x6C\x07\x66\x17\x49\x96\xD1\xBD\x20\x9A\x45\xE7\x59\x57\x4B\xCC\xC4\x38\x88\x4F\x70\xA0\xC4\xFA\x09\xAF\x13\x39\x3C\x6C\xB2\xE3\x21\xF3\x74\xE1\xD5\xA8', #1A
        b'\xF9\x3D\x23\xB5\x88\x3B\xF7\xE7\xE0\x4A\x0D\x39\x0A\x97\x95\x1C\xEC\x73\x6A\xE7\x6B\x37\xAA\x46\x63\xD2\xE7\xE5\xB5\xEE\x66\x4B\xEA\x84\x0C\xC9\x29\x7B\x2D\xD6\x0A\x4E\xD1\xE5\x38\xBF\x75\xB7', #1B
        b'\x1E\xAD\xC4\xCF\x3B\xD0\x9F\xAF\x96\x35\xB1\x8A\x5F\x3B\x5F\x28\xC8\x21\xCF\xFE\xD6\xEA\x55\x2D\x8B\x34\xAE\xA5\xE1\xF9\x93\x63\xA2\x08\x40\x05\x18\x53\x61\xF8\x98\x3E\x72\xCD\xDE\xAF\xD3\x86', #1C
        b'\xD7\x4B\xCC\x84\x52\x6E\x4C\x5D\xB4\x92\xC0\x1A\x10\xD9\x79\x12\x46\x8A\xB2\x17\xAC\xE3\x37\x5D\xAE\x06\x7B\x12\xE0\x7F\x21\x29\xE6\x22\x1A\xC3\xE3\x1F\xC4\xD0\x5E\xE6\xD3\xB5\x1E\x6F\x09\x2F', #1D
        b'\xC2\x6A\xD5\x16\x98\xA3\x87\x65\xCD\x03\x9E\x42\x20\x05\x04\x69\x78\x07\x74\xC1\xC3\x8A\x4E\x38\x10\x9F\xD8\x03\x23\x4C\xFD\x3A\xEC\x77\x94\x00\x17\xD5\xE9\x65\x62\xF3\x18\x95\x6A\x00\xDF\xDE', #1E
        b'\x3A\xA9\xED\x52\xE3\xD1\x4A\x91\xE4\x73\xB2\x5A\xC2\xA6\x8A\x51\x1C\xB3\x10\x47\x91\xDE\x3F\xB4\x29\xB2\x32\x43\x1D\x65\xEF\xB1\x94\xD3\xF9\xEB\x94\x58\xC8\x4A\x2C\xA8\xC0\x0A\x8A\x5E\x5A\x82', #1F
        b'\xD6\xCB\xCB\xD9\x29\xB2\x31\x6C\x76\x45\x0A\xF3\x8B\x27\x7C\xAD\x3E\x67\xA4\x09\x61\x1D\x24\x25\x13\x59\x4E\x56\xD5\x6B\xA1\x94\x1A\x63\xAC\x24\x46\xDD\x90\xBA\x6F\xD6\xB8\xFD\x54\x09\xAB\x9A', #20
        b'\xE0\x12\x56\xF9\x0F\xBE\x93\xFC\x61\x65\x75\xAE\xB2\xDD\xB5\xBE\x06\x47\x04\x87\x15\xCC\x86\xE3\xB1\x9E\x81\x4B\x17\x9C\x00\xEB\xA8\x4D\xB0\xC0\x9E\x4E\xCB\xF0\xE0\xB6\x62\xC3\x25\xB7\xD0\x98', #21
        b'\x27\x7C\x91\x47\x20\xA1\x66\x7E\x25\x95\x13\x5D\xE9\x8E\xD4\xFF\xF3\x69\xC8\xFB\x60\x30\x4A\xE7\x19\x29\xEE\x42\x80\xA3\x6E\xA5\x77\x0E\xB3\x11\x7A\x62\xF0\x0B\x94\x3F\x3C\x02\x5B\x80\xE6\x7B', #22
        b'\x24\x7F\x7E\x2C\xAA\xDF\xC9\x9C\x3F\x49\x7C\x37\x92\xD0\xB1\xD2\x2B\xC5\x47\xD4\x94\x92\x94\x4A\xE7\x18\xDF\xBC\xB9\x0F\x2D\x7E\xAC\xD7\xD3\xA9\x6B\xBB\x5B\x25\x9E\x72\xDB\x3C\xBF\x3C\x38\x9E', #23
        b'\xAD\x3F\x83\xC9\x46\x23\x26\x12\x23\x44\xDA\xC1\x29\x90\xCD\xCB\x5F\xD5\xD9\x74\x63\x5E\x65\x7B\x46\x63\x73\x18\x46\x60\x33\x2A\x70\x3A\x6F\x23\xC5\x89\x95\xF1\x9C\x0E\xE3\x8B\x9D\x54\x6C\xF7', #24
        b'\x51\x99\xE1\xD7\x43\xD9\x84\x9D\x83\x8C\x20\x18\x79\x36\xEE\xED\x39\xB6\x0D\x12\xE2\x53\xE0\x3E\xDD\xA5\x20\x23\x5F\x22\x4C\xE8\xD0\x75\x3D\xBC\xEE\x1E\x17\x28\x82\x24\xE7\x73\x85\x78\x13\x5F', #25
        b'\x5E\x8D\xA1\x5C\xA0\x4E\xEB\xB7\x3C\xE7\xE3\x9B\x7A\xF4\x9E\x5D\xB4\xC1\x64\xCA\xBC\xC8\xF7\x8B\x6F\xBD\x48\x7D\x51\x93\xB0\x0F\x7B\xB7\x5D\x17\xC8\x22\xBA\x4B\xF0\xCB\x9A\xB0\xC3\xF2\x65\x06', #26
        b'\x18\x5B\x99\x45\xD4\x4B\xFB\x77\x08\xF3\xD5\x49\x2A\xFE\xBF\x32\x85\x4C\x5E\x15\xA1\x91\x48\xA1\xDB\x9C\x17\xC3\x4B\xB9\xB8\x3F\x1E\x44\xE8\x0E\x95\x42\xCA\xA1\x07\x1F\x36\x4E\x41\xFE\x8A\xF0', #27
        b'\x5D\x55\xAB\x77\x02\x81\xCA\x4A\x2E\x66\x3E\xE1\x1A\xB5\x1F\xAB\xFD\x34\xB8\x69\xF0\xF5\x3D\xF6\x57\xC3\xB3\x22\xC7\x66\xA8\xF5\x1F\xBA\x6B\x8A\x76\x3E\x13\xD4\xEA\x18\x22\xAD\x2D\x1C\xE8\x05', #28
        b'\x57\x0D\xBD\xDD\xDA\x62\x67\x32\xAA\x47\x6F\xEF\x54\x65\x11\xE3\x9B\x64\x12\x93\xEA\x39\x57\xA2\xA1\x65\xAF\x3A\x30\xF0\x11\x57\x74\x4A\x97\xF6\x8D\xC9\xB8\x94\x13\x66\xC2\xA5\x6C\xC5\xF5\x50', #29
        b'\x8F\xC1\xAC\x6C\xDE\x3D\x38\xF3\xD2\xED\xFA\x71\x40\x25\xFB\xF8\x9A\x84\x6E\xF9\xFF\x8E\x17\x03\x39\x36\x92\xAB\x75\xD3\x0F\xED\xF1\xEC\x78\x7E\xC4\xDE\xF6\x32\x81\x2C\x0C\x67\xB3\x4A\x71\x64', #2A
        b'\x0A\x1E\x48\xEC\x79\x19\x29\x1C\xB3\x70\x92\x98\xF1\xF6\x93\x6A\x8A\x3F\xC7\xE1\x4A\x90\xEE\xAF\x62\x00\x93\xAF\x09\xCC\x73\x4D\xB1\x95\xD5\x16\x1C\x0E\x29\x96\x5A\x42\xC5\xB3\xFF\xF7\x1C\x32', #2B
        b'\x1B\xC5\xA2\xEF\xDD\xFC\x3D\xAA\x45\xF5\x7B\xD0\x45\xC5\x25\xE8\x5C\xC8\x88\x2B\x98\x02\x29\xB9\x1D\x6B\x80\x4C\x58\x81\xF7\x02\x42\x7D\x26\xF5\x53\xE0\xDD\xC6\x9F\x91\xE5\xA2\x3A\xC6\x26\x97', #2C
        b'\x15\x72\x85\x3F\x86\xE4\x25\xEE\x3B\xA1\xFB\x3F\xBC\x0F\x55\xF9\x55\x7A\x02\xE8\xA8\xF8\x63\x30\x93\xC0\x6B\x59\xE7\xD7\x4E\xF7\x97\x89\x3F\x53\x2A\x7E\xA3\xC0\x84\x2B\xC9\x4D\x4D\xFF\x08\x60', #2D
        b'\x90\x60\x5D\xF3\x07\x50\xB2\x2B\x99\x88\xFC\x0C\x83\xFC\x58\xCA\x44\xD2\x6B\x67\x32\xDD\x1A\x1F\xED\x93\x45\xBF\x89\xDF\x37\x31\x4D\x2A\x54\xFA\x3F\x91\x46\x85\x68\xF6\xA8\x12\xFB\xCB\x4E\x79', #2E
        b'\x29\xDE\x96\x1C\xB1\x43\x30\x5E\x81\x6E\xD9\x61\x3D\x20\xCC\xA5\x7C\x8F\x68\xA4\xAA\xD4\x27\x8C\x8A\xE4\x06\x7E\x93\x35\x79\xC3\xC8\x8D\x1E\xBE\x88\x50\xEA\x3C\xB0\x33\x39\xE2\x0D\x05\x1F\x69', #2F
        b'\xC5\xD3\x8C\x50\xA7\x86\x71\x83\xED\x17\x47\xE3\xBE\x4A\x9F\xFC\x1D\x37\x9A\x95\xB3\xBA\x5A\x27\x58\x2F\x86\x1B\x4E\xD2\x09\x65\x99\x07\x14\xF1\xFC\xBA\xC2\xCA\x09\x29\xEA\x99\xEF\xD6\x2F\x9C', #30
        b'\x54\x95\xDD\x63\xD6\x77\x0A\xF6\xBA\xE5\xE4\x2D\xA5\xBB\xA1\x70\x82\xF2\x6C\x77\x9D\xF4\xBD\x49\xCB\x26\xDD\x16\xFB\xA6\x0B\x8A\xFB\x6C\x0D\x7A\x59\xD3\x38\x14\xC1\x79\x08\x84\xA9\xB2\x04\xD9', #31
        b'\x23\xC6\xC0\x4B\xD2\x89\x88\x0C\xDB\xB3\x1A\x0B\xF0\x60\x91\x31\x35\xA0\x57\x35\x34\x7E\xCC\x06\x1B\x9D\xE4\xE6\x69\x16\xBB\xBD\xE2\xB5\x68\x48\x77\x29\x14\x9B\x7B\x96\x95\xDD\x6F\x0B\x0C\xAA', #32
        b'\xC9\x45\xEE\x79\xCE\x68\x74\x2F\x90\xA9\x04\x7F\x5A\x9D\x98\x03\x4B\x50\xBA\x63\xC1\x27\xF0\x14\x2C\x1B\x26\xB4\xAF\xCB\x8D\x7F\x7C\x86\x4F\xBB\x3E\x4D\xE1\x7A\xAE\x01\x24\xBC\xDC\x1A\x25\x2B', #33
        b'\xBF\xB7\x8A\x28\x28\x78\xB9\xF4\x4C\x06\x76\x7A\x4C\xE0\x7E\xCF\xB1\x61\x97\x7F\x8A\xCF\x67\xCE\x7E\x81\x55\xAC\xB2\x12\x3E\x5B\xDC\x46\x10\x85\x9C\x18\xFD\x2C\x53\x39\x40\xC9\x8B\xF3\xBA\x83', #34
        b'\x4E\x5A\xFA\x91\x66\x80\x15\xD4\x60\x62\x9F\xB3\x0D\x70\x4A\x9A\x79\x0D\xD0\x0C\x1E\xC5\xD3\xED\x18\xA0\x9D\x41\xFE\x57\x90\x70\x7F\x52\x92\x91\x6C\x3A\x0F\xA6\x32\x67\x76\xE4\xE3\x6A\xF2\xFE', #35
        b'\xAA\xEA\x31\x6E\xF1\x16\x91\x9B\x53\x50\x43\xF5\xF6\x2E\xBE\x76\x47\x65\x23\x01\x48\x3D\x10\x12\xD8\x6F\x8C\xCF\x6A\xBB\x8F\x20\xB0\xCA\x9F\x7F\x2B\x03\x9A\xF7\xE9\xAD\x19\x9B\xFE\x0D\x64\x29', #36
        b'\x2A\xFB\x33\xD5\xAB\x70\xAC\x8F\xFD\x57\x81\x64\x22\x06\xFF\x0F\x40\xC0\xE1\x36\xD7\xBF\xC9\x68\x45\x2A\x50\xBE\xDD\xFF\xCB\x9F\x38\xDC\xCB\x9F\x83\xC7\xE4\x5E\xC3\xC1\xF0\x09\x81\x20\x15\x8C', #37
        b'\x03\xF8\x89\x36\x9E\x2A\x2C\xDC\x94\x8B\x56\xE7\xE4\xA5\xA7\x53\x69\x15\x3C\x6E\xE5\xB8\x43\x63\x94\x8D\xE0\x0E\x7B\xB5\x32\x61\x21\xBE\x11\xBD\xF9\xA1\x96\xFA\x52\x8B\x5B\xC2\xD5\xC1\xD8\x53', #38
        b'\xBC\xB0\xDC\x5B\x2B\x4F\xF5\xFA\x8F\x5D\x86\x1F\xFC\xA1\xA5\x22\x2C\x86\xC4\x60\x69\xB5\x3A\xC3\x70\xF9\x41\xC8\xDF\x95\x17\x7B\x5E\x65\xC5\x08\x44\x7D\x1A\x18\xA1\x73\xDE\xA8\x19\x85\xE5\xB6', #39
        b'\xE6\xDF\x21\xC7\x59\x48\xAF\x41\x70\xB6\xD2\x75\x74\xB8\x39\x0D\xA7\x81\x0B\xE0\x8D\xB4\x7C\x5F\x22\x1A\xFE\x90\x52\x27\x44\x8C\xEB\x7E\xD0\x40\xC6\x55\x5F\x1C\x2A\x62\xB2\x7F\x1B\x02\x47\xF5', #3A
        b'\x58\x77\x6D\x95\xC6\xCD\xFA\x50\xCC\x7D\x79\x79\x08\x19\x84\xBB\x7F\xD6\xEC\xC5\x8C\xF6\xB6\x80\xD7\xE7\x2A\x92\x6C\xC3\xCA\x21\xC7\x51\xDF\xF9\xA6\xF9\x56\xA2\xBF\x21\x7A\xC6\xE4\x34\x16\x08', #3B
        b'\x09\xF7\x74\xF6\x97\x24\xD9\xF7\x1A\xAB\x33\xBE\xCB\xDF\xD6\x1E\xAB\x59\x8B\x92\xF8\x4C\x26\x4E\x4C\xE6\x58\xC7\xFF\x83\x5E\x19\x2D\xAD\x93\xC6\x91\xEB\xAA\x76\x34\x2F\x99\x77\x65\x41\x23\x15', #3C
        b'\xA8\x70\x49\x7B\xEC\xD2\x52\x6F\x10\xBB\xDB\xAC\xD1\xBF\xBA\x06\xCD\x1C\x4D\x7E\x0D\xA5\xF3\x0D\xE1\xA1\x8B\x57\x78\x37\x85\x6F\xBB\x97\x18\x4D\xDD\xA6\xF5\x9A\xB4\xF1\xAF\x86\xC4\xA1\xF8\x6C', #3D
        b'\x66\x25\xB6\x0C\x2F\xC3\xDD\x98\xFB\xB4\xD6\x06\x44\x6F\x71\x4F\xD6\xB2\xFB\x56\x0C\x64\xBC\x82\xEF\x82\xFF\x98\xBC\x6F\x9D\xD2\x9B\x2D\x33\x5F\x31\xAB\xB2\x05\xD9\x6A\xB4\xEA\xF1\x6C\xEB\x6B', #3E
        b'\xC1\x1F\x22\x00\xF3\x0C\x02\x3E\x19\x2E\xA1\xDC\x9A\xFF\x48\x1D\xF9\xFB\xB0\x4A\xC6\xE0\x77\x6E\xB2\x88\xBC\x7B\xF0\x4B\xE1\x67\x91\x2C\xBB\x3A\x96\x0F\x66\x35\xB6\xF8\x57\xB9\xD7\x48\xD1\xF8', #3F
        b'\x2D\xF2\xF0\xCB\x30\x4C\x05\xE9\x64\xEB\x4A\x21\xA8\xE6\x50\xBC\xF8\x0F\x46\x23\x84\xA7\x73\x28\x50\xF0\x1F\x9E\xC4\x1B\xA5\xF4\x6C\xAE\x2D\xB5\x30\x46\x73\x99\x0D\x4A\x5C\x22\x53\xA2\x43\x89', #40
        b'\x0B\x04\x5A\xDA\xD0\x13\x61\xE1\xA2\xEE\xAE\x93\x3B\x85\x1D\x9C\xE7\x90\x11\x5B\xC9\x09\x2D\xFD\xE0\xFB\xFD\x3B\x2D\x3B\x0D\xD9\xD3\xF8\xAE\x47\x8E\x2B\xCF\x6F\x86\xBD\x42\x3E\x71\xB1\x37\xF4', #41
        b'\xBB\xD1\x32\xE1\xD3\x7D\x43\x9A\xE6\x09\x66\xF0\x8A\xEA\x6E\x97\x57\x6B\x24\xFD\x2D\x21\x31\x6A\xAC\xA2\x0A\xD8\x33\x2A\x02\xD7\x10\xB2\xC0\x1D\x26\xED\xC9\xD5\x4E\xC4\xCC\x1C\xA4\x28\xD7\x55', #42
        b'\xDC\x5F\x3F\xE8\x57\xD7\x07\x54\x6F\xE2\x29\x7D\x2C\x22\x0A\x75\x93\xB5\xBF\x91\xFC\x74\x0E\x86\x48\xE0\xBE\x58\xA3\x8D\x91\x18\xE4\xEB\x0E\x81\x64\x14\x7E\x04\xC9\x0F\xA6\xDA\xF5\xED\x62\x04', #43
        b'\x07\x8A\x81\x1B\x10\xE8\x78\x14\x26\x2B\x54\xCE\xFA\x89\x75\xF0\x14\x7F\xED\xD0\xCB\x3E\xB4\x02\x21\xCD\x5C\xFF\x96\x6E\x71\x88\xFE\xF5\xB7\xC1\xF4\x10\x3D\x98\x00\x9E\xDF\x54\x8C\x57\xF4\x67', #44
        b'\x77\xAF\xA7\xFA\x58\x7F\x2B\x10\x88\x3C\xDC\xA2\x5D\xBE\xF6\xC7\xC5\x14\xEA\x22\xE0\xDA\x99\x87\x4D\x70\x5A\xA1\x1C\xC0\xC2\x81\x05\x29\x13\x1A\x3B\x35\x6A\x06\xF1\xE4\x4F\x0D\x10\xB3\xE3\xA3', #45
        b'\x89\x4A\xE5\x2B\x62\x53\xE8\xC3\x21\xEA\xD3\xF8\xEA\xCA\x62\xC6\xBC\x6D\x39\x04\x9B\x5F\x58\x96\x87\x61\xA7\x00\x2B\xB8\x84\x28\x54\x26\xAB\x66\x8B\x87\x35\x15\x50\xE1\xFA\x5D\x5F\x8D\x52\x18', #46
        b'\xFB\x88\x38\x8F\x90\x05\xE6\x1B\xC8\x0F\x16\x40\x6B\xA4\xF1\xA6\x67\x92\x1F\xAC\xC2\x07\xB5\x21\x9C\xC2\xCA\xE1\x5E\xFA\xA2\x82\x87\xA8\xA6\x9D\x7D\xEE\xAC\x43\x01\x3B\xF4\xAA\x21\x03\xA8\x5E', #47
        b'\xDA\x44\xC5\x97\xF7\x8C\x3F\xA7\x24\xB9\x72\x45\xDE\xEC\x4C\x4A\xE8\xA3\xFE\x32\x65\x7B\x83\x9E\x32\x14\xF8\x19\xBB\xE1\x1A\xC9\x5D\x06\xB5\x65\xA3\x47\x39\xA8\x3B\xF2\x8C\x2B\x47\x11\xFE\xF9', #48
        b'\xDE\xD6\xE6\xB8\x0A\xA2\x33\x4E\xC9\x8F\xDF\xDE\x7D\x55\x66\x27\xDA\x33\x53\x5F\xA9\x80\xA2\x4F\x5E\x25\x94\xF6\x3B\x09\x8A\x7A\xC6\xAC\xFB\xE8\x02\xF0\xDC\xC5\x21\xEC\x10\xDC\x5D\x5A\xF7\xCA', #49
        b'\x9D\x7E\x2D\xB3\x03\xC4\x9B\x22\x37\xA5\x07\xE0\x60\xC4\x88\x34\x95\x80\xEB\x10\x2B\xAB\x9B\xC1\x43\xB9\x3E\x15\x40\xD4\x88\xF2\x56\x19\x44\xF4\x99\x3C\x36\x67\x6A\x94\x8D\x1B\x9C\x01\xD9\xAB', #4A
        b'\x3E\x6E\x1A\xCE\xFC\x54\xAA\x93\xE7\xC9\xF1\xCA\xCA\xE1\x63\xDF\x89\x0B\x3E\x53\x6D\x66\xD0\x15\x8E\x6E\xC7\x25\xC5\xAF\x94\xE1\xFA\x80\x2B\x03\xAF\x17\x9C\x17\x78\x44\x35\x24\x35\x9B\x7C\xA4', #4B
        b'\x19\x89\x03\x90\x38\x49\x09\x3C\xF7\xDE\xAB\x97\x73\xB9\xCE\x35\x9C\x40\x58\x28\xA0\x55\xDC\xC0\xD1\xD9\xE8\x1D\x42\x64\xBA\xBE\xDA\x4F\xDA\x68\x4D\x36\x3F\x7E\x66\xA3\x2E\x61\xB6\xA6\x8C\x36', #4C
        b'\xEF\x53\x84\xA1\x84\xA8\x18\xBC\xEE\xAC\x84\x82\x1D\xA3\xA6\xDA\xC4\x02\x31\x43\x5A\x26\x71\x40\xEB\xEB\xD2\x81\x5B\x3D\xAD\xD6\xF8\x1F\xA2\xD4\x80\x45\x18\x5B\xB1\x60\x77\x71\x72\x58\xC3\x62', #4D
        b'\x40\xCA\x6A\xDE\x7F\x25\xA4\xF8\xD4\x9A\x25\x2F\x7F\x95\xF4\x73\xBB\x48\xB5\xC9\x75\x95\x9A\x13\x79\x83\x13\x7C\x12\x82\x6A\x01\xB6\xDF\x47\x5C\xC0\xAD\x16\x07\x7E\x09\x48\x98\x27\xCD\x2A\xD6', #4E
        b'\x6A\x0F\xE7\x86\xBA\x74\xC4\xD2\x28\xEC\xC8\x55\x31\xC3\x44\x80\x7D\xC9\x32\xA8\x7E\x06\xCF\x8E\x3E\xB6\xB7\xB2\x2E\xCA\x14\xE6\x09\xA4\x37\x07\xDC\xCE\x64\xE2\x6E\xA4\x12\x70\x7B\x32\xFA\x7D', #4F
        b'\xFA\x94\x24\x3D\xDB\x26\x9C\x57\xBD\x3E\x8F\x7C\x0F\xFB\x83\xB7\xB7\xE0\x3A\x20\xDB\x44\x92\x3D\x2A\xBF\x51\xDA\x18\x74\x5C\x52\x4E\xB6\x71\x6A\xB2\x3B\xE0\x0C\x17\xB5\xE0\x4B\xED\x60\xC1\x1F', #50
        b'\xE5\x3C\x4B\xEB\xCC\xF6\x9A\x85\x0C\xF4\x83\xD2\x33\x54\xE6\x7D\xF7\xE6\x50\xA3\x99\x1B\x2C\x29\xF1\x71\x70\x3E\x05\x45\x1C\xF6\x6B\x35\x45\x62\x03\x38\x0C\x21\x3A\xE7\xBB\x00\x33\x2C\xCF\x4D', #51
        b'\x70\x27\x1D\x34\x23\x91\xD3\x4B\xD6\x41\x5E\xF2\x9C\xB6\x64\xA7\x80\x06\x65\x40\x0B\x9E\x3B\xA4\xEA\x05\x7E\x94\xD9\xE8\xC5\x97\xA7\x2B\xFF\x3C\x39\xFC\x8E\x8A\x5F\x13\x78\x97\x05\x0E\xBD\x43', #52
        b'\x26\xC7\x97\x43\x61\xD6\x96\x76\x04\xCC\xD0\xA9\x81\xA7\x37\xDC\xB8\x5B\x8C\x2F\x33\xD1\x1E\x6C\xFC\x80\x3F\x44\x13\xE4\x6F\x93\x67\xDA\x9D\x74\xD8\xE3\xBB\xCF\xBB\x90\xAE\x4F\x89\x3F\x28\x2D', #53
        b'\x45\x52\xE4\x44\x18\x7E\x4F\x79\x41\x61\xBE\xEA\x9F\xBC\x94\x19\x5D\x60\x22\x6D\x08\x98\xBE\x60\x9D\x90\x5F\x97\x37\x9D\xEC\xC4\x84\xE0\x61\x27\x1B\x12\x9F\x29\x33\xC2\x9E\xF8\xD3\xC0\x34\xAC', #54
        b'\x82\x79\x3B\xED\xCD\xC2\xF3\x17\xEC\x3A\xCB\xD1\x30\x5F\xEF\x61\x28\x88\xDD\x39\xF2\xF1\x05\x1E\x08\xF2\x79\x34\x02\x07\xB1\x1A\x3D\x2F\x48\xE0\x9B\x8E\x42\x93\xC8\xAF\x50\xD0\xD8\xAE\xB7\x71', #55
        b'\xA1\x82\xD4\xC6\xEB\x28\xBB\xBF\xB7\x91\x7D\x15\x0B\x52\x7D\x09\x7A\x11\x5C\x7D\x59\x2D\x8F\xD1\x64\xAC\xA3\x78\xEC\x58\x2F\x99\x36\x7B\x7D\x06\x35\x5A\xD7\xCC\x54\x37\x1C\x6C\x7F\x84\x8E\x42', #56
        b'\x0E\x83\x58\x3B\x81\x6B\xAE\x24\x12\xA6\xFE\xCF\x6D\xB2\x3C\x15\xF5\xEE\x28\xF8\x19\x3A\xA7\x69\xCD\xF1\x90\x70\x07\x84\x83\xBB\x7D\xCF\xDC\x72\xA9\xF6\x5E\x50\x3F\x0B\xEB\xD1\x13\xBC\x9F\x1A', #57
        b'\xC7\x7D\xD8\x71\x04\x88\x0C\xAD\x1D\xCA\xEE\x22\xE2\x5E\x3D\x48\x1B\x4D\xA9\xFC\xF7\x75\x06\xB6\xAD\xA3\x69\x36\xF6\xAD\xC1\xE3\xB7\x9F\x73\x8D\xAC\x61\x12\x6A\x63\x1E\x2B\x79\x57\x64\xC4\x26', #58
        b'\x92\xCC\xFB\xE9\x0E\x9F\xD5\xB5\x78\x24\x94\xE4\xE1\x9B\xEB\x57\x9D\x01\x35\xA1\x9C\x79\x7A\xAA\x81\xC7\x8A\x5A\xFC\xAA\x1E\x9B\x20\x99\xD4\xAA\xCA\x8F\xFE\xA7\x0C\x47\x88\xF7\xEA\xD8\x54\x07', #59
        b'\x88\xD5\xAA\xCA\x96\x03\xB3\x70\xB9\xFF\x4E\xD8\xDD\xDC\xA9\xCE\xCC\x05\x8F\xAA\x7F\x3B\xA0\x42\x14\x33\xEF\x5C\x9E\xB0\xB3\x37\x88\x14\x3E\xF7\xFA\xC4\x93\xE0\x56\x88\x63\xE3\xB0\xBD\xB3\x8D', #5A
        b'\x56\x3B\x92\xEE\x8E\xE1\x16\x73\x74\x5A\x31\xB5\x1C\xA9\x5E\xBD\x45\x96\xAF\xD7\xDA\x9F\xF4\x58\xE5\xE1\x38\xFC\xE6\x68\x19\x1C\x23\xE5\xFA\x54\x43\xCB\xD8\x1B\x8F\xD9\x68\x2C\xE1\x8A\xF0\x3C', #5B
        b'\x64\x01\xC1\x8C\xB2\xDE\xB0\xFD\x82\xB5\x58\x38\xC7\x66\x27\x86\x49\x94\xF8\x9F\xB5\x6C\x16\x52\xE4\xCA\x54\x29\x3E\x17\xAF\xD0\xFD\x90\x59\x71\xDA\x66\x7C\x60\x6B\xC3\x27\xCF\x76\xDF\xB0\x91', #5C
        b'\x74\x80\x15\x62\x8F\xC7\x35\x4F\x98\x79\x8E\x8E\x89\x4D\x67\x38\x03\x76\xA1\x3C\xD0\xC0\xB7\xF8\xBB\xDF\x3A\x3C\xAB\x96\x1D\x46\xC1\xF9\xC4\x31\x70\x23\xE3\x72\x20\x87\x5A\xD4\x4A\x1B\xB8\xFB', #5D
        b'\xC0\x49\xB7\x3A\xB6\xD4\x12\x2D\x02\xF8\xB8\xAF\x6A\xC9\xDD\x8E\x16\x20\xCE\x55\xC0\x7F\x8C\x99\x40\x1E\x7C\x89\x34\xFB\xF0\x3C\x4B\xE3\xCD\x44\xEC\x31\x37\x39\x04\x64\x03\x66\x82\x9C\xFD\x9F', #5E
        b'\xB3\x2B\x47\x19\x95\x40\x70\xC8\x66\xC0\x48\x9F\xDA\x2F\x0E\x87\x38\x72\xD7\x2E\xAE\x8D\xD8\xF9\xB7\x8E\x18\xFD\x16\x31\xE8\x23\x89\x91\xFD\xCF\xD6\x09\x60\xA3\x08\x69\x4A\x03\x20\xE6\xED\xD8', #5F
        b'\x6E\x75\x27\x7F\xF6\xEA\xB1\xB2\x5E\x89\x1B\x90\xE5\x7D\x72\x81\x65\xA6\xE8\xB0\xCE\x5C\x78\x7D\x83\x19\xED\x07\x83\x62\xF9\xAB\xCF\x21\x24\x28\x3D\x82\x5D\xBE\xA6\x23\x6A\x4A\x01\x04\x21\x8A', #60
        b'\x39\x06\x8E\x17\x40\x41\x20\x21\xD3\x1C\x4B\x30\x38\x6A\xD1\x82\x43\x79\x4B\xEB\x95\x08\x21\xFA\xFF\xDA\x2E\xD2\xC9\x55\x27\xC6\xD7\xF1\x25\xF2\xFF\xD4\x10\xBF\x88\x0C\x4C\x63\x09\x76\x73\x80', #61
        b'\xC4\x29\x29\xFD\x80\xCE\x6F\xC9\x4E\xFE\x17\x0E\x99\x3A\xE9\xE9\x87\x8E\xC3\x16\x79\x71\x5F\x71\xBE\x12\x14\x64\xA6\xD9\x06\xDA\xB4\xC9\x57\x9B\x2D\x27\x4E\x49\xDC\x7E\x84\xDB\x4C\xFB\x85\x28', #62
        b'\x53\xBD\x68\x67\x3F\xFE\x34\x33\xC5\x20\x88\x44\xCF\x67\x26\xC9\x52\xB9\x77\x4D\x18\x72\x82\x59\x17\xC9\x30\x02\xD7\x10\xF2\xB7\x3C\xE4\xBE\x86\x0B\x4C\xAD\xC1\x8B\x59\x70\x35\xAD\xEB\xC5\xEA', #63
        b'\x50\x61\xBE\xD4\xE7\x4A\x6C\xC5\x77\x43\x9D\x43\xBF\x81\x0D\x7B\x42\x2B\xF4\x66\xAB\x88\xE1\xDA\x0E\x3C\xAB\x73\xBF\x94\x8C\xEC\x28\x3C\x6C\xA8\x2E\xF5\x31\x19\xF4\xDF\x1B\x81\x49\xD2\x86\xCE', #64
        b'\xA6\x42\x66\x3C\xAC\x6C\xCD\x48\x43\x12\x24\x17\x85\xD1\x20\xC1\xD8\xFC\x01\x25\x92\xB6\xE2\x05\x30\xCB\x16\x68\xA1\x6A\x9E\x26\xA9\x3B\xDD\xF3\xC9\xB5\xFB\x34\x70\x30\x9F\xFF\x8E\xF6\x36\xDD', #65
        b'\x5A\x32\xA4\xAE\xA1\x6D\x76\x94\x7F\x11\x2F\x58\x55\xCC\x68\x8B\xA5\x53\xBE\x3F\xD3\xE1\xEB\x85\xA8\xE8\x9C\x3F\x72\x5E\x30\x53\xE9\xCE\x91\x19\x0D\xBE\x4D\xB6\xBC\x14\x8A\x85\x37\x06\x17\x72', #66
        b'\xD9\xE5\x80\x24\xDF\xA0\x60\x35\xD9\xD9\xE9\xFF\x11\x7E\x89\x3D\x7B\xA9\x9C\x2C\x2F\x62\xF9\xC6\x78\xD7\xDE\x17\x7E\xDE\x61\xA4\x33\xD4\x49\xAE\x66\x41\x59\xB8\x40\x0A\xC7\xD7\x88\x73\xE7\x34', #67
        b'\x6F\x90\xB2\x41\x9C\x31\x95\x5B\x9B\x08\x55\x3A\xED\x87\xFA\x4B\x8B\xAD\xFA\x64\x56\xF9\x9E\x43\xF5\x27\xA0\x05\x0E\x2E\x2C\xF0\x2B\xC5\x52\xF0\x2C\x73\x54\xD7\x55\x54\x02\x11\x9A\x9E\x66\xB1', #68
        b'\xE1\x4D\xBA\x1A\x4F\xCB\x53\x27\x5F\x59\x40\x53\x36\x71\x30\x16\xBF\x27\xC6\x90\xD9\xFC\x6A\x66\x05\xB3\x9E\xA8\xEB\x1F\x77\x90\xA4\x78\x67\xCA\x74\xA8\x82\x90\xB3\xD4\xB3\xA1\x18\xA8\x82\x3F', #69
        b'\x36\x4E\xB1\x89\xB3\x1B\x2D\x84\x71\x72\x68\xC5\xDC\xD2\x14\x2F\xE9\xF3\xC1\xFA\x4C\xB9\x1D\x91\x23\x2C\x68\xAD\x70\xCF\x31\xCD\xA0\xDB\x30\x5E\x37\xD6\xC6\x8E\x26\x32\x79\xF2\x2C\x3B\x9C\xC7', #6A
        b'\x2E\xD2\xF1\x57\xEE\xAD\xAD\x58\x91\x7B\xD1\xBC\x49\x26\xD8\x37\xEE\x54\x99\xCF\x86\x13\x02\x2E\x06\x84\xE1\x8E\xF1\x9E\x42\x69\xC5\xB9\xCA\xB8\x60\xB3\x1C\x52\x49\xFA\x45\x72\x52\x8E\x49\x0C', #6B
        b'\x3F\xFA\xA9\x6F\x2C\x12\xC1\x81\x5C\xDA\xF2\x08\x5E\xC2\x3E\x42\x66\xAA\x07\xAB\xA6\x32\xD2\x11\xDC\x3E\x36\x11\xA7\xAB\xA7\xDF\x4A\x38\x69\x0A\x87\x43\x83\xFB\x7D\xF5\xC6\x60\xE6\x1D\xEE\x8B', #6C
        b'\x21\xFD\xB5\x30\x0B\xBA\x46\xBA\xFA\x02\xC3\x67\xAC\x76\x6A\xD9\x1A\x6F\xF3\x42\x90\x15\xE6\x0B\x09\xA7\xC3\x8F\x45\xFE\x68\x75\x43\x62\xAD\xD1\x34\xB8\x21\x66\xFE\x0D\x94\xB7\x0B\xC2\xEA\x51', #6D
        b'\xE9\xEE\xC8\x6B\xA9\x79\x41\xA1\x95\xB2\x7A\x72\xB7\x80\xFE\x1F\x30\xE2\xA2\xD6\xCA\x86\x5D\x64\x42\x96\x22\x9F\x57\x80\x07\x2D\x3E\xAB\x5C\xAD\xA8\x71\x6D\x9D\xD8\xDA\xD7\x41\xC2\xCE\xEF\x93', #6E
        b'\x71\x92\x59\x1D\xE0\xA6\xC0\x7B\x03\x99\x22\x68\x71\x5D\x07\xA1\xE3\xCB\xB1\xC4\xAD\xD3\xF5\x1C\xAF\x66\x4C\x6C\xFA\xC4\xC6\xBF\x51\xC4\x07\xEC\x92\x2F\xE7\x36\x7A\xD2\xA4\x0C\xDD\x9D\x2E\xA6', #6F
        b'\x63\x47\x7D\x98\xB0\x20\xBC\x5F\xBC\xAA\x7E\x3E\xC5\x58\x96\xF7\x4A\x09\x16\x2A\x00\x6E\x2F\xD2\x98\x0B\xC5\x95\x48\x0D\xC4\x68\x2C\x41\xE0\xC2\x6A\xC5\xF3\x1D\xA8\xAC\x73\xA7\x67\x97\x3A\x4F', #70
        b'\x28\x7A\x2C\x39\x64\x30\x73\x87\xEB\xC8\x35\xC9\x86\xAB\xDB\x78\x76\x57\x90\x1C\x7D\x7A\x51\xE0\xA9\x8B\x47\xF7\xBA\xA5\x6C\x91\x5A\x50\x46\x84\xE8\xE6\xBE\xB4\xEF\xCF\x2D\x07\xCC\xAD\x60\x70', #71
        b'\xAC\x40\x7A\x73\xB4\x0D\x1D\x6B\xE9\x31\xF6\x60\x06\x1B\xF8\xAC\xA1\xF8\x92\xE6\xB6\xFD\x03\x23\xC1\xFE\x7D\x51\x11\xE6\x60\xDE\x4C\xC8\xEB\x49\xE0\x25\xC5\xF3\xAB\xD7\x2C\x5F\x1D\xE7\x80\xFA', #72
        b'\x67\x9E\x70\xDC\xA2\x9E\x99\x31\x48\x6F\xEA\xBD\x96\xE9\x06\x25\x22\xB0\x63\x8D\x03\xBB\xAF\x26\xE8\x35\x1D\x33\x77\x26\x8E\x08\x0E\xAA\x5B\xDC\xFD\x88\x15\x45\xD4\x4D\x51\x36\x97\x51\x94\x21', #73
        b'\xCF\x58\xFE\xF5\xC3\x8D\xD0\xB1\x86\x3B\x01\xA3\xA1\x1F\x2B\x64\xB0\xB4\xD2\xA7\x3F\x6D\x9C\xCD\xE6\x50\xB6\x9D\x5A\xF2\x20\x9E\x5F\xED\x77\x0C\x81\xB7\x6B\x30\xE1\xB0\xAB\x2E\x4E\x40\x19\x4E', #74
        b'\x49\x93\x73\xBB\xC2\x2C\x0E\xF5\xA8\xD7\xE1\xA0\x2D\xDE\x35\xB0\xF2\x43\x51\x29\x54\x1F\xCE\x00\x20\x7A\xF9\x76\xA9\xF7\x23\xEA\x60\xE8\x5A\x4E\x4A\x90\x87\xAE\xFA\x7D\x14\x7A\x45\x15\x69\x84', #75
        b'\x80\x8C\x06\x22\x75\xC6\x2F\x02\xDF\x22\x21\x4B\xDF\xF7\xA8\x88\x71\x8B\x67\x18\x5F\x49\x30\xBA\xBD\x52\x83\x9A\xFD\x5C\x0C\xF3\xD4\xD6\xA8\x6B\x8C\xA5\x72\xB3\xA0\x5B\x6D\x53\x7E\xB9\x74\x73', #76
        b'\xEB\xA2\x0E\xD3\x55\xC1\x14\xAE\x69\x54\x34\x2E\xA2\xF8\xBC\xEE\x3D\x52\x5D\xF6\x89\x96\xCD\x7C\x53\xAA\xB5\x8C\x84\x91\x2A\xC5\x9A\xE9\x99\x22\xF1\x6B\x6F\xCE\x06\xD1\x0A\x57\x29\x1E\xAE\x6F', #77
        b'\x02\x36\x44\x65\x82\x5D\x8C\x99\x5A\x56\x50\xED\xB3\x00\xD9\xA8\x8E\xEA\xDB\x1B\x81\xF0\x0F\x76\x99\x7B\x2F\xC1\x9B\x3A\xE4\xC8\xFF\x88\x02\xAC\x4E\xAA\x8D\x69\x47\x10\x29\x9D\x5A\xDA\xDA\xC0', #78
        b'\x11\x13\x42\xFE\xC1\xDC\x92\x7D\x58\xA7\xB4\xCD\x58\xF2\x41\x05\xFF\x46\x91\x8F\xE6\x68\xFA\x5A\x7F\x97\x75\x8A\x4A\x08\xD0\x2F\x8A\x8C\xB8\x93\x22\x05\xB6\x78\x27\x56\xF3\xC4\x84\x6E\x39\x77', #79
        b'\xDF\x71\xF4\x32\x41\x04\x42\x7F\xE2\x46\xA7\xD5\x70\xA0\x0C\x44\x8F\x1A\xAB\xD5\xCF\xCE\x35\xF0\xA7\x3B\xDC\x14\x19\xD8\x15\x0C\x29\xBC\x8F\xEA\x3C\xD0\x2C\x62\x9B\x3A\xE4\x6B\x62\xEC\x5C\xDA', #7A
        b'\x46\x48\x9B\xE0\xD9\xF4\x51\x7A\x46\x29\xB5\x8F\x8C\xEE\xFD\x02\x0E\x98\x18\x68\x49\xCA\x7D\x51\x82\x11\x34\xEF\xCD\x23\xD4\x3E\xF3\x93\x85\xB2\x98\xF1\xC3\x31\x28\xA1\x28\xB8\x87\x0F\x72\xD2', #7B
        b'\x17\xF6\x78\x4C\xAD\xA7\x1B\x8B\xD1\xB8\xED\x48\xBD\x75\xD2\x56\x02\xAB\x1E\xF7\x20\xC1\xC5\x18\x3A\x6D\x09\xE0\xB6\x5D\xB5\x8E\x69\x40\x8B\x80\xE5\x9B\x1F\xE6\xDD\xC8\xBF\x5E\x0E\x26\x5F\x0B', #7C
        b'\xD4\x73\x09\x74\x15\xE0\xF6\x8E\xC1\x0A\xF0\x73\x1B\x3E\x78\xF4\x9E\xE9\x42\x5E\x13\x85\x19\x7F\x6D\xA8\x8F\xC4\x26\x01\x64\x22\x45\x3F\xE3\xE9\x42\x57\xEE\x53\xD6\x92\x16\xAB\x99\x38\xCB\xB8', #7D
        b'\xFF\x34\x26\xB0\x33\x1F\x8A\x5A\x06\xE1\x51\x5B\xC3\x31\x9D\x3A\x0B\xC3\x6F\x1E\xFA\x3F\xC2\xA3\x96\x95\x1B\x5F\xF7\x4D\x86\x30\xEE\xCD\xB9\xF8\x9D\x16\x43\xAD\x96\x28\xA5\x64\xFC\x46\xE9\x41', #7E
        b'\xD3\x2D\x75\xDF\x26\x6F\x55\xA2\x8B\xD6\x59\x9C\xA3\xED\xE0\x10\xEF\x68\x73\x61\xF5\x6A\xE8\x92\x31\x6C\x5D\x1C\x8A\x72\x5A\x8F\x41\x8B\x82\x9C\xE9\xB0\x4C\xA5\x95\xEF\x3E\x19\x73\x8B\x06\x39', #7F
        b'\x73\x78\xCF\x7D\x1A\x7C\x63\xC0\x2C\x94\x08\xD7\x68\xAE\x54\x55\xD7\x39\x72\x05\x6A\x9B\xC8\x17\xA0\x1D\x4A\x71\x0C\xA7\x16\x96\x1B\xA7\xC9\xA3\xD2\xBC\x4A\x7D\x83\x2E\x43\x7D\x79\x2E\xFB\x27', #80
        b'\x37\x09\x7B\xCC\x39\xF0\x54\x1F\x36\xBA\x36\x99\x91\x40\x92\x45\x98\xBB\x69\x08\x21\xBC\xDD\xEF\x28\xD5\xD7\x72\x6E\xF5\xAE\xF1\x11\xDD\x16\x41\xA2\xAC\xCC\x73\x31\x4F\x6B\x46\x04\xD5\xA2\xF3', #81
        b'\x86\x18\xF3\x69\x54\x02\x77\xE6\x0D\xC1\xEC\xC3\x2F\xCE\x31\xD1\x8D\xDA\x05\xC7\xD1\x01\xFC\xAE\xC2\xBB\x35\x24\x65\xF1\xB7\x59\xF6\x0F\x56\xCD\x0F\xD2\xF8\x9F\x1A\x20\xCA\xD2\x7A\x9A\x30\xA9', #82
        b'\x8B\x24\x62\xB2\x73\x85\x62\xD9\xF2\x21\xA3\x57\x94\x14\xD3\xD4\x75\x2C\x14\xFF\x57\x4E\xEA\xFF\x4A\x24\x5B\x2C\xE9\x0E\x89\x4C\x5B\x7F\x36\x01\xC7\xB4\xA6\x2F\x1F\x68\x0F\xF4\xC5\x27\x3E\xBA', #83
        b'\xF0\xB9\x64\x2F\x56\xEE\x48\xC2\xF6\xDC\x38\x5C\x2E\x3C\x8E\x1A\xE4\xCF\x13\x37\x0A\x73\xA3\xA5\x2F\xD6\xCB\x7A\xEA\x6D\x0E\x1D\x76\x85\x8A\x75\xC2\xA0\x85\xE3\x46\x1B\xC1\x88\x50\x36\x14\xBD', #84
        b'\xC8\x8F\x5C\xE6\xE5\x21\x6B\x44\x01\xC3\x0E\x81\x50\x21\x36\x46\xB9\x66\x81\xF5\x8B\xB2\x4F\x9B\x54\x21\x7F\x01\x3F\x90\xAA\x0B\x40\x24\xF0\x32\xAD\xD1\x89\x16\xCB\x84\xE8\x7E\xAE\x37\xD6\xB4', #85
        b'\x68\xAA\x13\xAF\x68\x07\x0F\x51\x8D\x69\x26\x26\x27\xCB\xB8\x5F\xFA\x13\x30\xEC\x9A\x97\x1C\x22\x38\xE5\x1A\x2E\xC1\xA2\x35\xBA\xF4\xDE\xD6\xA6\x6F\xE9\x7F\xAA\xB5\x19\x91\x69\x77\x1F\x90\xE1', #86
        b'\x76\x5D\x0A\x96\x7B\x58\x56\x18\xBE\x63\x09\x41\x01\x8A\xDA\x5B\xC7\x56\xA8\x3D\x62\xD5\x12\x31\x1E\x4D\xC1\x08\x20\xA9\x96\x8B\xAA\xFD\x0F\x3E\xFB\x99\x3E\xDB\x3C\xF0\x0E\x27\xC8\xE8\xB1\x7F', #87
        b'\x2F\xB4\xA3\xAA\xEA\x95\x32\xAC\x7C\x34\x0C\x4F\xC1\xFD\x99\xC8\x53\xCC\x1A\xF0\x31\x57\x79\xB1\x33\xB5\xC8\x85\xD2\x49\xBE\xB4\x0D\xC2\x3C\xEE\x7F\xB1\x19\x63\x6C\xD5\x81\x55\x68\x93\x3D\xAD', #88
        b'\xD0\x03\x65\x29\x5D\xE5\x37\x40\xE8\x38\xCF\xDB\x13\x68\x65\x4C\x07\x9C\xB6\xE4\x58\xB0\xBA\x04\x51\x62\xBA\xD1\x08\xDB\x56\x55\x1C\x47\xA3\x73\x1F\x15\x2F\x0F\x6D\x80\xD0\x25\xB7\x7B\xDC\xD1', #89
        b'\x14\x9F\x72\x31\xB9\x32\x50\xF9\x79\x7C\xA2\x02\xA7\x46\xD7\x29\x0C\x00\x7D\xBF\xE3\x0B\x93\xB8\x07\x0F\x3C\x54\x00\x8B\xE0\x17\xB9\x18\xF4\xD9\x4F\x56\xC0\xCD\xE5\x5D\xDA\xB4\xCB\xC8\x9D\xA2', #8A
        b'\xCD\x1A\x2E\x04\xE1\x1D\xF2\x0E\xC2\xE6\x6E\xA4\xD0\x49\xE1\xE6\x4D\x1E\x33\xD9\x3E\xCB\xF1\x77\x49\x47\x19\x48\x94\x38\x75\xC2\x64\x59\xE2\x5B\xF2\xBF\x44\xBB\x99\x7F\xF8\xE7\xB9\x21\xB9\xF6', #8B
        b'\x95\x5E\x9C\x08\xD8\x59\x4B\x2E\xAD\xDD\x2B\xC0\x07\x1D\x03\xC0\x3B\x24\xBC\x57\x01\x42\x23\x4D\xC3\x67\xB0\x84\x92\x33\xB4\x27\x66\x8F\x9A\xEF\xC1\x44\xDF\xE5\x19\x48\x4D\x17\x5C\x08\x29\x90', #8C
        b'\x25\xC0\xBB\xA7\xC0\x8B\xE1\x53\x3E\x4F\x19\xA6\x4D\xE3\xF2\x7C\x10\x5A\x3F\x65\x29\x46\xA5\xCC\x9B\x16\xA2\x67\x1A\x02\x0A\x5C\xD8\xB4\xF2\x02\x45\x9A\x5A\x13\x38\x9D\x8F\x7C\x36\xEA\xD4\x1B', #8D
        b'\x72\x6C\xEF\xAB\xA5\xD5\xE2\x47\x15\xBF\x15\x2C\xB4\x5A\xC2\xC2\x3C\xF0\xCA\x49\x82\x24\x1B\xD0\x00\x91\x77\x13\x82\x98\xD9\x24\x12\x4C\xEA\xA4\xE4\x21\xD1\x4D\x42\x7C\xB6\xAE\xE5\x49\xC0\x2A', #8E
        b'\xD2\xA3\x51\xD1\x63\x7B\x4E\xCB\x0A\x74\x3A\xE5\xFD\xB0\x09\x71\xE5\xA1\x09\x48\x85\x76\x49\x62\x3B\x2E\xDA\x9C\x8E\xB2\x81\x80\xEF\x73\x35\x88\xB8\x24\xBD\x4F\xEE\xE8\xA3\x62\x02\x74\xDD\x92', #8F
        b'\x7B\x85\xA0\x4F\x5E\xB1\xD8\xD3\xA0\x9D\x53\xFC\x39\x35\x2E\x4D\x61\x30\x84\x13\x27\x9D\x3E\xC5\xDE\xED\xCD\xF9\x2C\xEA\xE3\x71\x8E\x5E\x00\x46\x0E\x93\x97\xC2\xE2\xAB\x0D\x83\xB8\x56\xA9\xCB', #90
        b'\x7C\xE1\x77\x4A\xC7\x34\xA2\x2A\x38\x67\x7F\xCB\x57\x45\xAD\x5C\x6D\xC4\xDA\x00\x1D\x93\x5E\xD3\xFA\x15\xE6\x0F\x90\x00\x97\xC7\x07\xA1\xD8\x9A\x36\x5F\x51\x22\xFF\xB4\x82\xAC\x0A\xEF\x22\x7E', #91
        b'\xF2\xAC\x87\xA6\xAE\x55\x7B\xFF\x30\x4D\x0B\x12\xC8\x1C\x6B\xC4\x2E\xF4\xB9\x75\x2C\x9A\x5B\x0E\x6E\x7F\x4D\x47\xBE\x5B\xF1\x11\x27\xD0\x6E\x6F\x10\xDB\x11\x68\x45\xFF\x25\x8C\x7C\x67\xA5\x17', #92
        b'\x4A\xDB\x82\x9C\x17\x90\xCE\x6A\x17\xB1\x2C\x5F\x9D\x53\xCB\x2E\xD0\x5C\x21\x5C\x78\x05\x95\x89\xCF\x02\x27\x63\xC6\xF6\xF6\xA8\x2E\xB8\x1B\xFB\xED\xFE\x20\x8D\x24\x26\x07\x40\xBA\x33\xAA\x74', #93
        b'\xF4\xD8\x4F\x23\x49\xF7\xD4\x3D\xF0\x9C\x67\xE2\x97\x99\x13\x5A\x23\xDD\xDC\x14\x25\xAC\xD4\xBD\x67\x17\x85\xA9\x44\x06\xC3\x5D\x3A\xD9\x9E\x36\x8A\xDA\xB1\xFE\xEB\xCD\x20\xC0\x39\x5B\x5E\x33', #94
        b'\xDD\x37\x01\x60\xE8\x5E\x47\xE2\xF5\x18\x62\x1D\x8D\xDA\x23\xA2\x68\x31\x2C\xDD\x93\x6B\xDF\x39\xB5\x8C\x87\x26\xB0\x70\x63\xB5\x37\x5B\xBC\x97\xD0\x8A\xD5\xD9\x1B\x05\xA7\x3B\x22\x65\x3C\x8E', #95
        b'\xBA\xBA\x14\xE3\xC4\xC5\xE0\x9F\xFC\xCF\x42\x6E\x23\x7C\x45\xB6\xA3\x17\xD4\xB1\x70\xA6\xED\x1B\xBC\xBC\x0D\x83\x35\x0A\xDD\x66\x8C\x3D\xED\xB3\x54\x26\x48\x59\xAA\x43\x3B\x28\x90\x9F\x7D\x09', #96
        b'\xB2\xCE\x1C\x6D\x00\x29\x69\x6E\x84\xD3\xBF\xDF\xC9\xF5\xF9\xEF\x17\x38\xC2\x82\xDF\xA0\x47\xC7\xA3\xDE\x9B\x86\x41\x50\x7B\xAC\xB5\x1A\xFE\xE2\x9F\x5C\x08\x2E\x10\x1A\xEC\x2A\x1F\x7C\x05\x7A', #97
        b'\xFE\xB1\x28\x70\x3C\xAF\x0D\x39\xC3\x4B\x85\xB0\x25\x8B\x28\x93\x72\xDC\xA0\xAF\xFE\xED\x70\x84\x4E\x86\x11\xE7\x8B\x85\xE7\x86\x81\x5D\x4E\xD0\x00\x6F\x79\x4E\x79\xDB\xF5\xB2\x2F\xBE\x4C\x1E', #98
        b'\xF8\x9A\x07\xFC\x4E\x72\xFE\x1D\x11\xAD\x9A\xD9\x15\x13\x2F\x0E\xE0\xFA\x5F\xB2\x35\xEC\x4C\xF3\xAA\x89\x42\xC0\xAD\xBE\x46\x7C\xAB\xA5\x41\x30\x05\x69\xCD\x80\x61\x17\xF7\x32\x34\xA7\xF3\xDF', #99
        b'\x08\x08\xB0\x10\x37\x9C\x49\x69\x7A\x0C\x9C\xFD\xA6\x72\x08\xB9\xF6\x03\x45\xDF\xBE\x40\x5C\x56\xDA\xF7\x52\x91\x36\x92\xFF\x0D\x0B\xA9\x76\x3D\xCD\xC0\xFC\x3E\x57\xBA\x4E\xBB\xA8\xD3\x63\xAE', #9A
        b'\x99\x6F\x7F\x4D\x51\xA5\x7A\x9E\xCA\x97\x3D\xEC\x53\x0C\x3B\x2D\x4E\xD8\x27\x44\x26\xE5\x0D\x24\xD5\xEE\xA4\xCB\xEE\x71\x53\xB3\x30\x10\x84\x25\x2F\xC3\xB3\x88\xE3\xB8\xF9\x4C\x31\xA0\x35\x11', #9B
        b'\x5F\xF1\xA5\xE2\xC5\x10\x89\xC6\x92\x36\x2E\x25\x05\x2D\x19\xBF\x33\xFF\x36\xDE\x68\xA2\xB9\xDF\xC8\xF6\x49\xB1\x3C\x7D\xD7\x06\xE0\xE7\x53\x0D\x79\x2D\x53\x70\x37\x95\x15\x82\x42\x82\x8B\x57', #9C
        b'\x20\xA1\xF7\x58\x4D\x0B\xE5\x92\xF3\xFB\x03\x03\xC6\x42\x7F\x4E\xD4\x82\x26\x34\xF1\x8B\x54\x0A\x65\xDD\xBD\x8D\x22\xCD\x6B\x58\x44\xB1\xE6\x98\x14\x8D\xAE\x5C\xF9\xB1\x0B\xC5\x9B\xF5\x2D\x2E', #9D
        b'\x47\xA0\x0D\xC2\x36\xCA\x2E\x4C\x65\x58\x78\xB2\xEF\xB7\x3F\x30\xEA\xED\x7B\x58\xB2\xC6\x28\x50\x5F\x23\x33\x55\x74\xE0\x59\x15\x19\x54\xF1\x5D\x5F\x1C\xBF\xA9\x74\x6E\xF1\xA6\xDF\xCC\x8F\x9B', #9E
        b'\x81\x4C\xEB\x81\x83\xBB\xDE\x56\xCB\x55\xC2\x63\x5C\xEF\x2C\xB5\x5B\x35\x41\x83\xB9\x14\x88\xE1\x56\x45\x08\x37\x7F\x73\x7C\xA7\xCA\x13\x22\x95\x82\x4F\xB9\x3F\xBE\x65\xA0\xFB\xFA\xBB\x9E\x8F', #9F
        b'\x87\x7B\x0B\xFF\x4A\x46\x39\x89\xEA\xE4\xA8\x2A\x37\x08\xF3\x6E\x37\xE3\x83\x8C\x22\x8C\xC3\xE6\x61\x94\xA5\x32\xDE\x15\x9C\xCF\x1D\x15\xD9\xAB\x52\x20\x55\xDA\x4C\xBB\xFF\x56\x08\x13\x7E\xF1', #A0
        b'\x2B\xDD\x46\x82\x1C\xE6\xDC\x3F\x4F\x80\xAA\x74\xFF\xB4\x0B\x8A\x92\x0E\xD5\xE3\x24\x54\xFE\xBE\x3D\x32\xD3\xB8\xAC\xE5\x13\x33\x79\x3E\x06\x1F\x48\x63\x47\xEF\x39\x71\x1E\xB1\x03\x75\x91\xCD', #A1
        b'\x12\x56\xB3\x1F\xE4\xAA\x79\x19\x49\x6B\xFD\xDD\xFE\x8D\xC6\x6B\xBA\xD7\x71\x0F\xA7\x84\x01\x5C\xA5\x3A\xD9\x50\xCE\xB3\x7F\x51\x5C\xD8\x34\x77\xB9\x3F\x70\x81\x8D\x06\xFE\xDE\x91\xCA\xC6\xED', #A2
        b'\xE8\x0C\xF2\xA8\x35\xCF\x5A\xB9\x1E\x16\x64\x62\x5B\x0A\xDC\x65\x94\xC2\x9F\xB9\xC5\x94\x4B\xAB\x60\x22\x89\x0A\xB4\x04\xCE\x74\xE1\x28\x7F\x92\xDB\xBD\x81\x26\x2E\x53\x7D\xF5\x15\xFC\x67\x3B', #A3
        b'\x35\xE0\xDF\x14\x60\x2D\x6E\x82\x39\x13\xBD\x6F\xFB\x4F\x12\x84\xDD\xD1\xC5\xAE\x6F\xAE\xE7\xAD\x9F\xD3\x25\xCD\xB3\xE7\x8B\x50\x35\x1E\x62\x2F\x5E\x85\x78\x9E\xFC\xE2\x92\xBD\x12\x55\x9A\x5C', #A4
        b'\x3B\x4F\x02\x4E\xD5\xF3\xD2\x43\x09\x53\x06\x0A\xF7\xAF\x24\x9D\xCA\x89\xFF\x4E\xC8\xBE\x14\xC8\x80\x10\x15\xE4\xF8\xB1\x38\x4A\x15\x23\x58\x7C\x40\x30\x45\x8C\x11\x76\xAC\x06\x6D\x4B\xDB\xE6', #A5
        b'\x6B\x62\x0F\xF8\x67\x6A\xCB\x3A\xBF\x1E\x91\x76\x1F\x8F\xCA\x1B\x88\x2E\xE5\x6B\x11\xE6\x33\xD9\x7D\x42\x3B\xBD\xB8\x18\x95\x87\x32\x58\x8D\xA0\xEB\x67\x5C\x4C\xC0\xC0\x87\xE6\x2E\xF9\x41\x66', #A6
        b'\xED\xFE\x25\x7C\x6B\xC8\xEC\x25\x05\xE3\x3F\x1C\xB1\x41\x5A\x8D\x83\x1B\x7A\x85\x66\x2A\xB0\x5E\x03\xE3\xB8\x53\x5C\x39\x1B\x73\x72\xC0\x32\x6C\xF3\x7F\xA9\x11\x71\x50\x8E\xCC\x51\xAC\x0E\x01', #A7
        b'\x4B\xBC\x63\x46\x21\x93\x7F\xA4\x8A\x1F\xB6\xB7\x3F\x84\x18\x72\xDB\x18\x55\xA2\x88\x33\xFB\xA7\xF3\xC6\x04\x74\x76\x89\x29\x32\x18\xA0\x38\xC8\xF0\x06\x01\x33\x93\xF9\xDD\xFA\x66\xE3\x0F\x40', #A8
        b'\x38\xF4\x67\xA0\xDC\xEB\x9D\x1E\x14\x01\x27\x10\xAF\xDB\x01\x89\xB6\x04\xB3\xDB\x47\x4A\x2B\x53\x15\x1F\x66\xDB\x79\xA4\x12\x42\xBE\x36\xE1\xDA\x85\x81\x4F\x10\x72\x9F\x89\xEF\xEB\xDC\xE1\x20', #A9
        b'\x6D\x6B\x18\x54\x5F\xBD\x19\x96\x2B\xB0\x41\x69\x47\xD7\xC0\x17\xBD\xC7\x1D\x50\x76\xE2\x80\xB7\x1C\xFC\xF3\xA3\x61\x3E\xF4\x05\x9F\x42\xEF\x2E\x6D\xAE\x68\xB9\xE6\x40\xA9\xC1\xB4\x6B\x1A\x61', #AA
        b'\x60\xB3\xAF\xC8\x3A\x97\x1C\x42\x20\x3F\xB3\xEB\x56\x0D\x56\xFA\x96\x85\x40\xED\x4F\xBD\x84\xC4\x24\x08\x43\xCA\xCF\x29\x72\x48\x93\x12\xBA\x4C\x97\x94\x27\x37\x7F\xDC\xD9\x31\x98\xC7\xFC\x58', #AB
        b'\x42\x50\x79\xEA\x14\xB5\x5C\x88\xBB\xA4\x45\x46\xDB\x51\x90\xD0\x74\x9F\xB4\x7A\x97\x77\x39\x9A\xA6\xEA\xA8\x6B\x9D\x19\xEE\x03\x16\x66\x39\xC5\xCB\x07\x22\x86\x90\xCC\x2F\xBF\xE0\x59\x07\x35', #AC
        b'\x65\x35\x11\x07\x4C\xEC\xFD\xD5\xB6\xCE\x60\xC8\x17\xD3\x59\x62\x05\x22\x75\x8E\x2E\xC3\x8E\xA9\x0C\x4A\x78\xE8\x24\xF8\x48\x9D\xCB\x0D\x04\xDF\xB5\x37\xC1\xB0\xF6\xA2\xAA\x76\x0F\x2A\x40\xAF', #AD
        b'\x9A\xF0\xA8\x87\x85\x83\x59\x36\x4B\x9E\x12\x14\xE6\x93\x52\xFD\x32\x4B\x7F\xB5\x14\x89\xA4\x4B\x36\x46\x0E\x65\x32\xFC\x45\xAF\x68\x11\xF6\x2B\xF8\x65\x0D\x3A\x41\x97\xC8\xF6\xD2\x4C\xBC\x65', #AE
        b'\x9C\x2F\xC3\x99\x6C\x38\xA5\xBD\x1F\x26\x73\xD3\xE3\x04\xC4\x00\x26\x78\xE6\xB4\x8E\xA8\xE5\x61\xB9\x48\x28\xDD\xE2\x86\xDF\x6B\x7E\xF7\x1F\x90\xE7\x52\x0B\x91\xDA\x16\xC3\x6E\xD4\x47\xA1\x78', #AF
        b'\x69\xC4\xDA\xC1\xBC\x8A\xF8\x67\x7B\x10\xC5\x16\x88\xE8\x61\x18\x64\xE5\x2F\x76\xB7\xFB\x0B\x93\x44\x5D\x74\x4A\x2A\x47\xA3\x2B\x8F\x74\xDB\xD8\x19\x8B\xD0\x24\x64\xBC\x2A\x04\xB5\xA9\x5B\x24', #B0
        b'\xB4\xE4\xC2\xBC\x5A\x9B\x7D\x66\xA7\xA0\x95\x51\xD7\x24\xED\x67\x8C\x41\x08\x71\xAF\x19\x97\xE5\x2B\x99\xC2\xE2\xE4\xBF\xA6\x6D\xC9\xD1\x7B\x5A\x50\x5E\x30\x12\xD0\xC5\x5F\x45\x3B\x52\xCE\xE3', #B1
        b'\xB9\x02\x53\x9A\xFB\x51\xBF\xCA\xA6\xC5\x93\x6B\x9E\x61\x46\xBA\xAA\x2F\xDE\x30\xB0\x69\x0C\x83\x6A\xEF\xB9\x49\x98\x75\xFA\x09\xE5\xD5\x2A\x83\x23\x6D\xDE\x09\x16\xE9\x54\x65\xF4\x61\x6F\x63', #B2
        b'\xCE\xD4\xEA\x7A\xB8\x06\xF9\xA8\xB2\x07\xD7\x9E\x32\x96\x7A\xAA\x13\xDB\xC0\xF1\xE9\xE8\xBB\x95\x0A\xC5\xA9\xA7\x4D\x0B\x4A\x72\x6F\xCB\x88\x1E\x56\xCD\xF4\x95\x69\x9A\xE9\x16\xA7\xF1\x03\xE8', #B3
        b'\xD1\x91\xCD\x18\x7C\x5C\x90\x0F\x35\x28\xE2\xAD\xD5\x28\xE5\x0A\xD5\xAF\xF0\x54\xDD\x03\x36\x35\x25\x01\x46\xED\xF9\x7C\x08\xD8\x3B\x8A\xE7\x57\x4C\xF7\x23\x7B\x92\x6B\x64\x34\xF8\x87\x0A\xB3', #B4
        b'\xF6\x97\xBF\x66\xF8\x65\xE3\xED\xFF\x2C\xB9\x4E\xAB\x10\x33\x07\xD3\x49\xC9\x88\x3B\x7D\xD1\x16\x66\x5A\x64\xA6\x04\x78\x51\xE0\x86\x5A\x23\x8E\x3A\x0A\x28\x40\xF3\x07\xB1\x96\xAB\x53\xC9\x81', #B5
        b'\xB1\xB8\x55\xAC\x08\xFD\xCC\xA3\x29\x2D\x00\xA5\x35\x07\x0F\x04\x9F\x8C\xA6\xA0\x5C\x0F\x46\x5B\xCE\x77\xF0\x93\xCA\xE3\x7D\x62\x63\x03\x51\x76\x72\x7A\x8C\xF4\x8E\x11\xFB\x52\xE9\xC9\xD2\x94', #B6
        b'\x13\x0B\xA6\xFB\x42\x01\xBA\x5C\xE3\x8E\xCA\x77\x64\x62\x97\xB2\x73\x08\x29\x97\xA5\xAA\x41\xF1\xDF\x0C\xFC\xFA\x4F\x7A\x4F\x45\xA3\x81\xC7\xDB\x21\xB9\xE5\xF5\xC4\x3D\xFD\xD6\xA2\x44\x11\x38', #B7
        b'\xD8\x57\xD2\xA3\x16\xDA\xA6\xF1\xB0\x4C\x14\x1B\x28\x38\x82\x01\x81\x6E\x52\x5A\x38\x65\xDB\xD4\x5B\x7D\x63\x2A\x06\x2F\x62\xEE\xBA\xC1\x79\x45\x61\xE1\x26\x0A\xA3\xB2\x34\xED\x6B\x7F\x0B\xBB', #B8
        b'\x0D\xEF\x00\x59\xF4\xAE\x8E\x60\x22\x40\xA9\x27\xBA\x6C\xF7\xF6\x97\x7B\x96\xD2\x4E\xD7\xC0\x55\x91\xFA\x53\xF8\x6F\xBD\xD1\x38\x26\x02\x6D\xFD\x8F\x78\x41\x75\xCA\x8E\xB0\xDF\xBB\xB4\xC8\xA7', #B9
        b'\xE3\x31\xAE\x5D\x8D\x17\x57\xDF\xC7\x84\x6B\xE9\xCD\xD5\x40\xF2\x86\x0C\x17\x94\x44\xB7\x74\x67\x37\x6A\xAA\x2D\x9F\x3F\xC7\x0E\x6D\xF2\x19\x7B\xAB\x9E\xD9\x79\x65\x34\x71\x13\xA0\xF0\x4A\x4B', #BA
        b'\xFD\x05\xE3\xD2\x69\xB6\x03\x78\x2A\x82\x49\x3D\xF3\x33\x60\x20\x91\xD4\xA5\xC3\x9E\x48\x04\xBC\x73\x39\xA6\x4E\xD4\xCE\x6D\xAD\x0F\xFE\xD1\x2C\x27\x92\x07\xDF\x2F\xA6\x3D\x51\xF3\x92\x51\xC1', #BB
        b'\x8A\xED\xD0\x5F\x6E\xA4\xFF\xE8\x1C\xDF\x05\x01\x52\x7B\x29\x90\xBE\x23\x34\x27\x53\xF3\xC1\xFE\xC9\xAF\x60\x99\x21\x99\x05\xE9\x78\x25\x1D\x29\x4B\x6A\xA0\x82\xA7\x7A\xBD\xCB\x96\x35\x98\xFF', #BC
        b'\x7D\xE2\x54\x25\xFA\x9D\x3B\x37\x59\x6D\xDE\x84\x3A\x6D\xE4\x58\x6E\xAC\x15\xC0\xF4\x6F\x96\xF4\xD4\x92\xD4\x82\x7A\xEB\xA9\xA6\x58\xA3\xB1\x39\x04\x77\x9B\x08\xED\x75\x5D\x1E\xA6\x94\xF6\xF2', #BD
        b'\xA2\x11\x3E\xE7\x0C\xFF\x45\x71\x9C\x5E\xA5\x00\xD4\xCD\xEC\x63\xB3\x36\xBD\x0E\x96\xA3\x15\x8F\xD9\xBA\x2C\x6F\xDC\x25\xEB\x1E\xDF\x4B\x2E\x21\xF5\x98\x7A\x9C\x18\xEA\x38\x33\xF0\xF8\x77\x7C', #BE
        b'\x52\xE9\xFC\x56\x9B\x3C\xBD\x6D\x34\x19\xE0\x91\xF2\x02\x1B\x7F\xA9\x42\x82\x41\x3C\x99\x18\xFC\x59\xA6\xF6\xEC\xB1\xD5\xE5\x7D\x61\xE6\x7C\xE3\x68\xA9\x1D\xF9\xCF\x8D\x47\x74\x5E\xB0\x97\x4C', #BF
        b'\x44\x23\x4D\x93\x78\xDD\x10\x8D\x55\xBC\x3C\x70\x93\xC7\x22\xD7\x00\xCA\x9E\xF4\x23\x4B\xCB\x47\x9A\x58\xE3\xF5\x31\x8E\xF8\x25\x59\x16\x9B\x64\xEA\x95\x6E\x0D\x67\xE5\xE2\xBA\x44\xD1\xBB\xD0', #C0
        b'\xAB\x81\x37\xF1\x01\x5B\xD6\x13\xD5\xD8\x6D\x9A\xAD\x15\x43\xD3\x6A\x12\x19\x96\x7C\xFA\xA9\x74\x69\xFF\x6A\x10\x56\xE9\x5F\x78\xCC\x83\x17\xA2\xFE\x64\xAB\xDE\x23\xD3\xA1\x49\xCD\xF4\x27\xCF', #C1
        b'\x30\x17\x9A\x55\x70\xF2\x97\x1A\x42\xCB\xF4\x24\x0C\x11\xEA\x83\xDC\xA7\x43\x1F\x12\x36\x62\x07\xFD\x54\xC0\x79\x0D\x53\x3B\xA9\x03\x9B\x0A\x70\xCF\x72\xED\xDD\xC6\x3C\x55\x0F\xE8\xE9\xEC\x3A', #C2
        b'\x00\x10\xE2\xB6\x87\x2B\x7C\x01\xD0\xF7\xD4\xAA\x26\x7F\x2D\xD8\xED\x9A\xBB\x7B\xBA\xA1\xD6\x7A\x12\x51\xEA\xBA\x4C\x1A\xF5\xCE\xE7\x64\xA0\x37\xE2\x59\x84\x8F\x77\xA9\x17\x6A\x56\x95\x8D\x31', #C3
        b'\xA3\xE7\xDB\x8E\x45\x37\x80\x0A\x6B\x9B\x99\xB8\x09\xD4\x8B\x3E\x0D\xA4\xF2\x6F\x73\xDC\xAD\x65\x2E\xD0\xE9\x66\x9A\x2C\x65\xDC\xAF\xBB\x4D\x67\xD4\xF2\xCE\x5F\x25\x63\x7C\xD3\x75\xD9\xA4\xE0', #C4
        b'\x6C\xDA\xD1\x61\x05\x2E\x36\x90\x52\xA8\xA6\x29\x04\xC8\xB9\x9F\xB5\x7E\xE3\x5D\xEF\x1C\xE9\xB3\x5D\xC1\x1C\xB6\x2F\x32\xD2\x00\x47\xF6\x70\x87\x1A\x1A\x50\x03\xC7\x61\x49\x78\x69\xC4\x76\x75', #C5
        b'\x41\x8B\x34\x85\x77\xBC\xAB\xAB\x8C\x4E\x61\x47\x3C\x82\x74\xFB\x58\x62\x76\xDC\x8F\x0E\x20\x9C\x47\xA9\x62\x1F\xAA\x79\x54\x3B\x52\xA2\x0B\xE1\x1E\x70\x0A\xD8\xDB\x8C\x96\x5A\x92\x5F\x96\x16', #C6
        b'\x9B\xA4\x5F\x11\x1E\x3E\x21\x11\x2D\x78\x97\x36\xD2\x1A\x86\xAE\x59\xFD\xCD\xC6\x07\xD2\xE4\xA0\x7A\x9A\x65\x5D\xE3\xFD\xBC\x92\x71\x87\xA9\x61\xE6\x7C\x04\xB2\xD2\xD0\xD2\x43\x48\x07\x32\xEE', #C7
        b'\xBE\xF9\x16\x5E\xA6\x56\x13\xEB\x7D\x5C\x5D\xBA\xE8\x50\xFC\xC5\xCE\x3C\xEF\x21\xBF\x00\x69\xD7\x72\xE2\x23\x8B\xF2\x97\x58\xB8\x22\x9C\x08\x10\x7B\xE2\xA4\x54\x0E\x8A\xBE\x20\xA5\xEE\x57\x85', #C8
        b'\xA4\x76\x69\x9E\x5B\x9A\x82\x86\x0E\xC2\x32\xD6\x61\xE4\xB3\x98\x11\xF5\x3B\xD3\x3D\x8F\x4D\x73\x77\xD4\x98\x5B\x59\x13\xC0\x13\x31\xEE\x01\xB7\x09\xEA\xEC\x55\x14\x82\xD8\x68\xC6\x4E\x44\x48', #C9
        b'\xA5\xD9\x94\xBA\x7A\xF9\xC3\xB0\xB1\x05\xF5\xDA\x95\xBD\xAE\x52\x25\xEB\xD3\x62\xF9\xEF\x64\x54\x4F\x64\xF2\xC6\x9C\x1C\x04\xA3\xDE\x55\xCF\x14\xD1\x04\x62\x7C\x51\xAA\x1F\x59\xAF\x90\x48\xEB', #CA
        b'\x10\x8E\xF6\x15\xA4\x5A\x65\x23\xA3\xA3\xAC\xFB\x0E\x44\xD0\xA9\x6F\x2A\x0A\xAD\xD5\xAF\xA6\x2A\xA2\xE9\xF5\xD6\x86\x11\x92\x44\x8D\x71\x5E\x4A\xBB\x08\x98\xC8\xF2\xB9\x44\x58\x64\x89\x53\xC5', #CB
        b'\xB8\xA7\xCA\x8D\x32\x57\xA3\x26\xFE\x77\xCD\x50\xCE\x7A\x4B\x6C\x3A\x4F\xE9\x51\x1B\x70\x34\xF7\xCA\x20\x9F\x40\x60\xB7\xC9\x16\x39\xAF\xA5\x42\x5B\x19\x00\xC4\xAC\xF4\xCB\xD9\xBC\xCF\xB4\x87', #CC
        b'\x55\xA8\x6E\x21\x3D\x1E\x68\xDD\xA9\xF2\x4D\x7B\xD9\x12\xB4\x7E\xA0\xF7\xCC\xA9\x6E\xC9\xD7\x2B\xC4\xA4\x0F\xA2\xD1\x4E\x55\xD1\x8B\x76\xA1\xBA\x75\xB6\xB7\xD2\xDF\xDD\x86\x37\x11\xFA\x10\xC8', #CD
        b'\x5C\x86\x8D\x27\x3E\x44\x28\x28\xA1\x0B\x70\xE8\xEC\x2B\x16\x94\x99\x99\xD6\x80\xDC\xB3\x13\x3C\x1F\xDC\x0B\x52\x3A\x7E\x3C\xA1\xA6\xEF\xA7\x96\x32\xDF\x2E\x92\x05\xD8\x23\x30\xC1\x63\x12\x47', #CE
        b'\xE4\xAE\xCE\x26\x6A\x0F\xC5\x0D\x13\xDB\x5B\xAB\x98\x09\x9C\xB1\xC3\x3A\x38\xC2\xB8\x0A\x7B\x3B\xFB\xAD\x57\xD3\x15\x61\xDE\xEF\x9E\x60\x05\x18\xB7\x02\x34\xAC\xC5\x38\xB7\xF0\x26\x7D\x79\x13', #CF
        b'\x79\xD7\x8F\x51\xA8\x94\x00\xB6\xE1\x52\x8B\x56\x8E\x9F\xC5\xCC\x34\xB1\x79\x79\xFB\x4F\x68\x6B\xB8\xDB\xB4\x80\xD3\xC9\xBD\x39\x17\x43\x27\xD7\x55\xA3\x49\x0E\x4D\x36\x13\x75\x32\x50\xA7\x02', #D0
        b'\xDB\xD0\x5E\x37\x48\xE7\xB6\xBB\x4D\x23\x11\xFA\xB8\x86\x87\x6F\x21\x44\x8A\x78\x10\x5D\x72\xE8\x75\xB7\x1E\x6E\x54\x8C\x67\x8D\xC0\x39\x80\x15\x78\xA7\xBC\xA0\xEC\xC7\x58\xD8\x55\x72\x99\x03', #D1
        b'\x3D\xE3\xE8\x94\x93\x18\x5D\x49\x9F\xD5\x44\x85\x84\xC6\x70\xA0\xAD\x1D\xFD\x7C\x5D\x12\xB1\xEE\x8F\xD1\x71\xEE\x73\x88\xFB\x5F\xBD\x32\x3A\xDD\x69\xF8\x75\xCB\x0F\xAE\xB5\x15\xE2\x30\x61\xC2', #D2
        b'\x1F\xA5\x2F\x02\x25\x1A\xB5\xE0\x80\xA2\x8C\x04\xB9\x56\x21\xE7\x62\x71\xD1\xEA\x36\xC2\xCA\x09\xC0\x75\xCC\x3D\x62\xAE\xFE\xFC\x6A\x9D\x50\x1C\x16\x97\xB4\xF6\x22\x2A\x60\x5B\xAC\xD4\x24\xCC', #D3
        b'\xEA\x6D\x6B\xB1\xD1\xB3\xC8\x46\xF9\x2F\x8D\x4A\xC0\xA2\x81\x33\xA2\xE4\x66\x8B\x87\x0D\x61\x94\x71\xF4\x9A\x6A\x99\x0C\x26\x76\xD1\x45\x86\x99\xB4\xEC\xA5\x27\x7C\x51\x4B\x1A\x61\x0C\x6B\x4A', #D4
        b'\x84\x07\x17\xC5\xEF\x1C\x64\x72\xF1\x39\xAF\x11\x82\x6E\xDF\x5E\x09\xB7\x8E\x0A\xED\x2F\x09\x45\x95\x72\xFA\x96\xCC\x51\x25\x54\x75\x0A\xEC\xC7\xD9\x2C\x33\xBD\xCE\x57\x26\xF1\x07\x62\x4D\x54', #D5
        b'\xEE\x63\x4A\x78\xFF\x3F\x08\x16\x18\x8A\xEB\x59\xEB\x2A\x4D\x8F\xD2\x32\x62\x33\x55\x58\x53\x08\x74\xC4\x84\x0D\x81\x8F\xF3\x3D\xF7\x70\xC3\xA7\xBD\xCC\x8A\x00\xA4\x35\x7B\xC8\xD1\x17\xA0\x14', #D6
        b'\x59\x20\x36\x7E\x2D\xC9\x6A\x05\xAE\xC7\x9B\x35\x63\x64\xA2\x77\x19\x4E\x2B\x6C\x64\x17\x75\xC2\xF9\x4B\x97\xC5\x7D\xDD\x7A\x6A\xAE\x17\x4C\x78\x5D\x13\xE6\xEC\xA5\x22\x9B\x42\xFD\x86\xBF\x10', #D7
        b'\x9F\xBE\x88\x64\xA3\xDB\xD1\xDB\x85\x98\xEF\x83\x90\xCF\x51\x99\xEB\x3E\xCB\xBA\xA3\xA4\xDE\x78\x0F\x2D\x10\x0C\x53\x41\x41\x49\x73\x5C\x5F\x79\x93\x00\x25\x2D\x15\x03\x52\xA3\x58\x7E\x00\x5A', #D8
        b'\x31\x2A\x2A\xC3\x74\xFB\xF0\x04\xC4\xBE\x5A\x0F\x7E\x79\xB6\xA3\xC6\x97\x0F\x4F\xB4\x2B\x25\xB5\x7C\x8F\xCF\x1A\x49\xBA\x9F\x83\xF9\x68\x2C\xCC\xDF\xE4\x1B\x01\x3D\x41\x59\x89\x2A\xA4\x31\x3E', #D9
        b'\x4C\x68\x50\xA9\xF5\x67\xDB\x08\x9A\xD0\xDD\x28\xC4\x9E\x77\x3F\xE1\xDE\x0E\x31\xA2\x51\xAC\x7E\x76\x2B\x72\x60\x64\x1D\xAB\xAA\xDD\x53\x75\xD3\x11\xD8\xA7\xD1\x36\xC6\x09\x39\xD6\x16\x02\xFD', #DA
        b'\xE2\x87\x35\xC4\x91\x15\xDF\x61\x6A\x6A\xB7\x3C\x8F\x69\xB0\x0B\x77\x29\xF9\x2D\x52\xD6\x00\xCA\x01\x56\x7A\xD5\xD0\x40\x4D\x04\x57\xCC\x28\x0F\x9A\x86\x77\xB5\x5B\xB7\xE6\x8D\x2B\x66\xB6\xC6', #DB
        b'\x0F\x33\xEC\x33\x5C\x33\xA7\xC1\xF4\x86\xBA\x09\x1E\x4B\x9B\xDB\x2D\x19\x95\x26\x7A\xD0\xF6\x41\x9E\xFD\x76\x61\xE8\x2D\x2E\x98\x49\x61\x96\x94\x51\x3D\x88\x44\xC2\x6C\x7E\x94\x4B\xBA\xF9\xFC', #DC
        b'\x97\xBB\x10\xF0\x1B\xA9\xEE\x34\x44\x60\xC7\xA1\xF4\x48\xB7\x47\x50\xC6\xAC\x6A\x41\xC7\xE3\x36\x2D\xF8\x31\xF3\x66\x59\x4B\xD4\x80\xC3\xE9\x52\xA5\xF3\x86\x6B\x60\xBF\xEE\x90\x60\x69\x4F\x12', #DD
        b'\xEC\x59\xE9\x76\x4B\x8E\x94\x80\x72\x7A\x96\x9D\xE0\x39\x76\x54\xFC\x0A\x5B\x03\xEC\x82\x11\xE4\x8D\xD8\x6F\xC2\x0F\x1E\xD8\xFF\x7A\x6A\x7E\x4B\xCC\xFF\x71\xE8\x1D\x85\xBA\x92\x4F\x8C\xB2\x22', #DE
        b'\xF5\x9D\x43\xB4\x8C\x69\xC6\x09\xAB\x96\xBC\x4C\x46\x5C\x05\x79\x6B\x3B\xE4\x8A\x2A\x23\x9D\x3A\x1A\x30\x96\xA4\xA0\x5A\xB2\xE7\x55\xF3\x63\xA1\x90\xC8\xFF\xDC\x75\x93\x1A\x29\x70\x5C\x6E\xA5', #DF
        b'\xAE\x74\x1B\xF2\x7E\x11\xD7\xC7\x0B\xEF\x71\x86\x19\xA8\x80\x2B\x2A\x51\xD8\xD8\x09\x04\xFD\x0C\xB6\xB4\xF4\xB9\xD8\x8A\x01\x60\x65\xB0\xDE\x8C\x86\x76\x24\xC3\xCC\x9B\x67\xE1\x46\x4F\xAD\x1C', #E0
        b'\x93\x28\x8B\x6A\x06\xCC\xA1\xCF\xC0\x1B\xC4\xF9\x72\x91\x6C\xEA\x0F\xA8\x1B\x06\x05\x87\xA8\xEC\xEC\x5F\x39\xF0\x29\x9F\xDA\xFE\x0A\x67\xB6\x56\xD3\xC2\x32\xE7\xD3\x31\x04\x38\x3E\x42\x9B\x5B', #E1
        b'\x1C\xC2\x90\x0B\x44\x66\xED\x62\x9D\x7E\x10\x2B\x7C\xC1\xBD\x40\xA8\xBE\x49\xCD\x17\x63\x91\x72\xF4\x98\x05\xDC\xA2\xED\xEA\xFD\xDB\xFF\x20\xB1\xF7\x48\x74\x48\xAD\x46\xB9\xAF\x94\x3E\x58\xB0', #E2
        b'\x06\xDC\x61\x2D\xB5\x35\xBE\x7C\x68\xF6\x2A\xF6\x02\x63\xC1\x85\x4F\x5F\x00\x72\x7B\x1A\xD9\x1A\xCC\xB8\x6C\x20\xBD\xB4\x5B\x89\xC3\x48\x9C\xFF\x58\x11\x65\x71\x89\xA5\x56\x14\x6E\x8F\xCA\xEF', #E3
        b'\x94\xB2\xD9\xF4\x94\x0A\xCF\xEC\x16\x5F\x65\x87\x2B\xF1\x15\x23\x0A\xD0\x2D\x0B\xE7\xDF\x0A\xA8\xAB\xCE\xC9\xF4\x38\x43\x50\x6E\x62\x0B\x8C\x09\x62\xE5\xF1\x57\x43\x25\x32\x3A\x14\x31\xA6\xBF', #E4
        b'\x61\xC3\x60\x35\x2E\xE2\xC2\xDE\xD7\xC6\xE8\xF1\xF8\x9C\xA3\x49\x36\x75\xAE\x45\x77\x4D\x6D\x44\xF6\x03\x2B\xF2\xDB\x54\x3A\xCA\x25\x04\x81\x38\x08\x4A\xAF\xB7\xFD\x49\x66\xA9\x93\x98\xE0\x45', #E5
        b'\xCB\x0A\xC9\x2A\xED\x14\xE7\x63\x07\xB7\x2D\xCC\x6E\x9A\xAA\xAF\x48\xF6\xAA\xB8\x42\x50\x85\x8D\x7B\xCF\x91\x35\xC2\xB6\xED\x10\x2A\x7C\x65\x60\xEF\x80\xD2\x47\xD1\x99\x11\x1D\x1A\xC3\x88\xE7', #E6
        b'\x8C\xCD\xD6\x42\x6F\x0E\x11\xB8\x67\xBD\x37\x78\x4E\x23\xAC\xE5\xF1\x25\x9D\xF3\x4B\xB1\x44\x4C\x88\x07\xBB\x09\x3D\x63\x39\x4F\x96\x57\x98\x34\x06\x5B\xF2\xFD\x76\x83\x9C\x8E\x30\x3D\x01\xC4', #E7
        b'\x04\x1D\x1F\x9B\xFD\xD3\xE4\xA6\xD8\xE9\xC1\x34\xB6\x77\x00\x50\xDF\xFE\x9B\x24\xE1\x25\xB8\x8A\x0D\x87\x8D\xD0\x55\xC8\x69\xFA\xE3\x34\x29\x55\x63\x9F\x52\xBC\xA2\x2D\x61\x48\xCE\x19\xE2\xC9', #E8
        b'\xA9\xF3\x57\x53\xF0\xF8\x44\x75\xB5\x32\xA0\xEE\x00\x8C\xE7\x9E\xE2\xF9\x54\x86\x0F\xFF\xC4\x70\xBA\x53\xB1\x4F\x10\x87\xCF\x56\x13\x27\xD2\x2D\xBE\x2E\xEF\xD3\x30\x5E\x85\xCE\xDA\x81\x70\x19', #E9
        b'\xBD\x2E\x6F\x72\x12\x22\x8D\x07\xF8\xF1\x1C\x23\xD8\xAC\x6D\xDD\x2F\xBA\x0C\x1A\x9F\xFE\x90\xF2\xD6\x44\x99\xAE\x01\x42\x87\xCC\xB3\xFB\x74\x13\x73\xFA\x3B\x3D\xAF\x55\x05\xCA\xD0\x71\xE4\xD5', #EA
        b'\x83\xBF\xB8\xA4\x1F\x08\x24\x8C\x3D\x93\xCC\x6A\x65\x0E\xA0\x26\xC2\xF1\xF1\xCE\xD2\x11\x81\xD8\x3F\x31\xE2\xEA\x85\x05\x9A\x07\xCD\x1B\x8E\xD2\xAE\x49\xF9\x23\x4F\xFD\xD5\x21\x23\xDD\xFF\xEC', #EB
        b'\xB6\x0E\xE0\xA2\x34\x5F\x3E\xCD\x4A\xD1\x28\xB4\x6C\x5B\x4E\x41\x41\xE1\x70\x81\x3A\xEE\xD5\x9D\x02\x1C\xD6\x28\x6B\xC5\xE9\xE4\x3F\x9A\x12\x59\x0C\x1D\xE8\x20\xE8\x77\x8B\xEE\xDB\xA5\xC2\xD3', #EC
        b'\x43\x9C\xD3\xE4\x7D\xF5\x6D\xA0\x00\x3D\x63\xC7\x41\x2C\xAF\x92\x3F\xDF\xA7\x0D\xFD\x10\x07\xEA\xE3\xEC\x21\xDF\x03\xEF\xB9\x9A\x0C\xBF\xF5\x2A\x7C\xCA\x02\x51\x9A\x5A\x41\x08\xA3\xE0\xAF\xDC', #ED
        b'\xB7\x54\xBC\x3E\xCF\xE3\x40\x29\xCF\xFC\xB0\xE6\xF9\x32\x53\xF5\x31\x9D\x03\xBD\xE4\x83\x52\x01\x5C\x37\x82\x62\xAE\xEC\x28\xAE\xB2\xE2\xAA\xE6\xB3\xC1\x40\x83\xBD\x58\x1D\xEB\x7D\x83\x59\x6D', #EE
        b'\x9E\xAB\x05\x0E\x13\xBF\x98\xE5\x9E\x33\xE7\xD4\xD6\xC0\xF0\x36\x15\x7C\x6D\x59\x06\x56\x22\xB0\xB0\x3F\xF7\x75\xF5\xD6\x99\xF8\x14\x8E\x6A\x33\x65\xD7\x7B\xEB\xF8\x4C\x80\x80\xAA\xAB\x4B\xD7', #EF
        b'\x7F\xB5\xDE\xDB\x31\x2F\x23\x52\x75\x8D\x87\x5E\x87\x3D\x8C\x91\x90\x45\x59\xEF\xD8\x59\xC7\xB2\xE2\xAE\x5E\x1E\xF4\x24\x7E\x36\x46\x1D\x43\x04\x28\x83\xD3\x6D\x48\xA0\x9D\xE8\x00\x23\xCC\xA1', #F0
        b'\x5B\xC9\x3A\xB9\x47\x00\x3A\x97\x63\xD2\xC9\xF7\x76\x4E\x47\x0C\x7E\x1F\x89\x9B\xA4\xAD\x7E\xCB\x3C\xAB\x40\x27\x6D\x46\xDC\xC1\x50\xA6\xBD\x63\xBA\xC6\x69\xEE\x35\xE0\xAD\x50\xC9\x43\xAC\x6E', #F1
        b'\x3C\x15\xB4\xA5\x9A\x42\xB8\x00\x6C\x7F\x8A\x54\xD3\x01\x2A\xE1\xFE\xEC\x8D\x11\x43\x2C\x8A\x9F\x6B\x78\x67\x39\xC0\x20\xA4\x77\x98\xB3\xCE\xB4\x41\xF4\xF7\xEA\x1E\x70\x65\x9A\x95\x91\xF1\x52', #F2
        b'\xA0\x84\xC7\xAD\x1D\x92\x58\x15\x6D\x0D\x80\x80\x9B\x74\x17\x13\xF4\xBF\x4A\x02\x1C\x2E\x66\xDE\xC7\x8A\x02\xB3\x97\xA8\x78\xFB\x6E\xE1\xAF\xCB\x57\x2A\xD4\x1E\x3E\xFE\x90\x9E\x28\x4D\x0D\xE5', #F3
        b'\xCA\x19\xF8\xF7\xE6\x64\x1F\xA9\x32\x1A\xAD\x4D\x14\xAD\x9A\xE4\xA6\x6A\x44\x1D\x72\x20\xAB\xD6\x6C\xC8\x4F\xF1\xA8\x5F\xA0\xD5\xBF\xC7\xB4\xB9\x71\xB2\x05\x5A\xE7\x04\x7F\x44\x9E\xAA\x2B\x95', #F4
        b'\x0C\x16\xFD\x49\xE2\x39\xE9\xCE\x93\x30\x23\x8B\xA4\x73\x8F\x39\x63\x6C\x80\x3B\x5E\xC4\x3C\xC9\x5A\x43\xB2\xE3\x7C\x48\x76\x47\xBC\x69\x21\x7D\xF6\x60\x67\x6E\xBA\x98\x46\x8A\x3F\x70\x93\x59', #F5
        b'\xB0\x41\x40\x01\x8A\x87\x85\xD0\xE5\xE0\xF8\x66\xB5\x29\xC8\xD5\xAE\x4A\xDF\xEE\xD4\xE4\xC6\x3F\x26\x76\x61\x04\xED\x2B\x1F\xDD\x48\x79\xE4\xD5\x12\x51\x06\xAB\x91\xCA\xD4\xFE\x17\x2B\x1B\xA0', #F6
        b'\x1A\x69\x04\xC0\xBE\xB7\x0B\x03\x57\xC4\x30\x89\xA0\xBA\xD5\xC3\x4C\xA5\xF5\x3E\x40\x45\xB3\xDB\x86\x3D\x29\x45\x47\x67\xE2\x5E\xE8\x92\xBF\x35\xA0\x96\x1E\xA4\x5D\x7B\x5E\xFC\xB1\x29\x89\x25', #F7
        b'\xA7\xFF\x9D\x88\x11\x60\x8F\xFE\x73\xE8\x6A\x19\x16\xD6\x32\x11\xDE\x5D\xE2\xBE\xB1\x22\x8D\x6F\xE9\x57\x24\xC9\x95\x9A\x3F\x40\x85\x30\x4A\x89\x1D\xFB\xDA\xB1\x1C\xCE\x53\xF9\x40\x79\x5D\x46', #F8
        b'\x7E\x9B\xC6\x9D\x53\xD8\xB7\x55\x2F\x0E\xFF\x0D\x51\xAA\x6F\x7A\x24\xE7\x61\x4B\xC7\x38\xF8\xAC\xF0\x73\xD0\x0B\x28\x6C\xAC\x1B\x24\x5F\xF8\x20\xBF\xE7\x2A\xC7\x4A\x08\x75\x91\x78\x10\xCD\x9D', #F9
        b'\x75\x38\x9E\x0D\x6D\x09\xC7\x38\xDA\x85\x89\xF4\x67\xE7\x1A\xCD\xC0\x63\x48\xB7\xEB\x31\xAE\xD5\xEE\x5E\x56\xE9\xEF\xA1\xC8\x4E\xC2\xC6\xC8\xB6\xB1\x33\x03\x02\x2D\xA7\xDC\xE9\xC0\x39\x7B\x00', #FA
        b'\x91\x1C\x3D\x13\xC8\x75\xEF\x64\x56\xCD\xCE\xB6\xCC\x43\xB2\x9B\x51\x87\xAD\xA6\x83\x5A\xFF\x90\x0B\x49\xCE\xBB\x27\x30\x82\xCB\xF0\x98\xFC\x3F\xC3\xE8\xA1\x97\xDE\xEE\x3F\x10\xBD\x5D\xA3\x76', #FB
        b'\x48\x14\x86\x05\x65\x3A\x81\xE4\x51\x25\x5C\x8C\x34\x18\x38\xF1\x18\x16\x2A\xC8\x28\x60\x50\xA6\xBF\x28\xFB\xFB\xC8\x77\xCC\x85\xD9\x00\x55\xFE\x01\xCF\x7D\xED\x12\xBE\x6E\xEC\xCA\x25\x92\x0A', #FC
        b'\xD5\x22\x08\xE5\x8B\xAC\x27\x95\x8E\x9F\x3B\x92\x18\x16\x73\xEC\x70\xB8\x4E\xDA\x74\x16\x2E\xBF\x55\x7E\xE5\x7F\x39\xD0\x3D\x14\x90\xBD\x83\x26\xD5\x0B\x57\x74\x85\x74\xA2\x01\x8D\xB8\x3B\x44', #FD
        b'\xAF\x67\x1E\x09\x92\x61\x5E\x4D\x0F\x68\x46\xBB\x62\x83\x7B\xB8\xA4\x3D\xA3\x9C\x39\x3C\x2A\x32\x16\x5C\x12\xAA\xC3\xF3\xBF\xB6\xFC\x94\x66\x43\xE1\x9C\xA2\x56\xB9\x1D\xCD\x18\xF6\xE5\x55\x88', #FE
        b'\x85\x96\x6C\xBD\x72\x71\xEA\x3B\x33\x76\x69\x88\x69\x94\x02\xB4\x20\x5E\x2E\xA5\x02\xCD\x8B\x98\x11\x40\xD1\x77\xF3\x7B\xFC\x1F\xED\x72\xC6\xE5\x25\x8C\x92\x5D\x8C\x12\xF6\x1F\x43\x88\x2C\xE9'  #FF
    )

    __TSIZE_INI = len(__TABLE_INI)
    __TSIZE_XOR = len(__TABLE_XOR)
    __TSIZE_MIX = len(__TABLE_MIX)
    __TSIZE_RND = len(__TABLE_RND)
    __TSIZE_SBX = len(__TABLE_SBX)

    #------------------------------------------------------------------------
    # INITIALIZATION
    #------------------------------------------------------------------------

    def __init__(self):
        self.__ctr = 0
        self.__src = bytearray(self.__class__.__TABLE_INI[0])
        self.__dst = bytearray(self.__class__.__TABLE_INI[1])

    #------------------------------------------------------------------------
    # PUBLIC API
    #------------------------------------------------------------------------

    def update(self, input):
        if not isinstance(input, (bytes, bytearray)):
            raise TypeError('input must be sequence of bytes')
        clazz, ctr, src, dst = self.__class__, self.__ctr, self.__src, self.__dst
        for val in input:
            xor, mix, rnd = clazz.__TABLE_XOR[val], clazz.__TABLE_MIX[ctr], clazz.__TABLE_RND[ctr]
            for i in range(clazz.__HASH_LEN):
                tmp = ((src[mix[i]] ^ xor[i]) + rnd[i]) & 0xFF
                dst[i] = dst[i] ^ clazz.__TABLE_SBX[tmp][i]
            src, dst = dst, src
            ctr = (ctr + 1) & 0xFF
        self.__ctr, self.__src, self.__dst, = ctr, src, dst

    def digest(self):
        clazz, ctr, src, dst = self.__class__, self.__ctr, self.__src, self.__dst
        out = bytearray(clazz.__HASH_LEN)
        xor, mix, rnd = clazz.__TABLE_XOR[256], clazz.__TABLE_MIX[ctr], clazz.__TABLE_RND[ctr]
        for i in range(clazz.__HASH_LEN):
            tmp = ((src[mix[i]] ^ xor[i]) + rnd[i]) & 0xFF
            out[i] = dst[i] ^ clazz.__TABLE_SBX[tmp][i]
        return out

    def reset(self):
        self.__ctr = 0
        self.__src = np.frombuffer(self.__class__.__TABLE_INI[0], dtype='uint8')
        self.__dst = np.frombuffer(self.__class__.__TABLE_INI[1], dtype='uint8')

    @classmethod
    def version(clazz):
        return (clazz.__VERSION_MAJOR, clazz.__VERSION_MINOR, clazz.__VERSION_PATCH)

    #------------------------------------------------------------------------
    # DEBUGGING
    #------------------------------------------------------------------------

    @staticmethod
    def __compare_bytes(input_a, input_b):
        if not isinstance(input_a, (bytes, bytearray)):
            raise TypeError('input must be a sequence of bytes')
        if not isinstance(input_b, (bytes, bytearray)):
            raise TypeError('input must be a sequence of bytes')
        if len(input_a) != len(input_b):
            return False
        for i in range(len(input_a)):
            if input_a[i] != input_b[i]:
                return False
        return True

    @classmethod
    def self_test(clazz):
        import binascii as bin2hex
        TEST_VECTOR = (
            ( 0x0000001, b'' ),
            ( 0x0000001, b'abc' ),
            ( 0x0000001, b'abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq' ),
            ( 0x0000001, b'abcdefghbcdefghicdefghijdefghijkefghijklfghijklmghijklmnhijklmnoijklmnopjklmnopqklmnopqrlmnopqrsmnopqrstnopqrstu' ),
            ( 0x0000001, b'Franz jagt im komplett verwahrlosten Taxi quer durch Bayern' ),
            ( 0x0000001, b'Frank jagt im komplett verwahrlosten Taxi quer durch Bayern' ),
            ( 0x0000001, b'Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.\nDuis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat.\nUt wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi.\nNam liber tempor cum soluta nobis eleifend option congue nihil imperdiet doming id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat.\nDuis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis.\nAt vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita ea et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua. est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat.\nConsetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus.\nLorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.\nDuis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat.\nUt wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi.\nNam liber tempor cum soluta nobis eleifend option congue nihil imperdiet doming id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo.' ),
            ( 0x0000001, b'\x92\xAD\xAC\x49\x7F\xFA\xB3\x0B\x40\xAC\x67\x4F\x9D\x53\xA9\xA6\x24\xB2\x47\xFA\x23\x72\x94\xFA\x75\x88\x41\xA8\x5F\x4D\xDE\xFD\xDB\xFD\x23\x71\xC1\xE2\xCA\xF8\x5B\x0E\x06\x4B\xBC\x4F\x3A\xC0\xA9\xC6\xFD\x6C\x18\x5D\xC4\xB1\x2C\x8A\xAC\xC3\xE6\x25\xBD\xE8\x7A\xDF\xCB\xFF\x60\x1B\xF0\x66\xDF\x08\x7C\x0A\x63\xCE\x2C\x11\xD6\x64\x8D\x1E\xD0\x57\xCE\x1B\x5D\x93\xC6\xCB\x6F\x33\x19\x81\xB9\xFC\xB5\xBC\xF4\xFB\x6F\x77\x50\x54\x06\xD7\x1A\x87\xEC\x7E\xC1\x99\x55\x97\xFB\xB7\x96\x9D\xEC\x0D\xAD\x01\x93\x9E\x88\x89\xF5\x30\x96\x3F\xE9\x2E\x23\xA8\xF5\xDA\xE5\x47\x3E\x2C\x1E\x22\x38\x2A\xD4\xF7\x0E\xA2\xE4\x5E\xBB\xCB\xAD\x11\xC8\x7A\x74\x8F\x78\xCB\x56\x77\x8E\xF4\x1C\x0A\xEC\xA5\x63\x2E\x75\xE3\x52\xB2\xEA\xB5\x53\x3C\x06\xF7\xC6\x80\x8E\x77\xD0\x0B\x2D\xB5\xF9\x64\xF5\x9F\x89\x83\xD9\x25\x79\x22\x26\xE2\xF3\xE6\xD4\xB0\xFD\xE7\xBA\x74\x6C\x59\xBA\x9A\x20\x21\x2C\x25\xDA\x02\xD2\x3A\xEE\x5F\x88\x5A\x75\xF1\x1A\xC5\xBD\xD5\xCC\x6F\x9C\x4B\x72\xBC\x47\xD8\x40\x89\x72\x00\xF1\xB7\xEF\x97\x7F\x23\x52\x2C\x83\x38\xA3\xFC\xFD\xD7\x72\xC6\x15\xD3\x4A\x93\x46\xBC\xB1\xCE\x37\x14\xFC\x0E\x2B\xCB\x99\xC7\x34\x4D\xAC\xD8\x48\xA1\xEE\x58\x43\x6D\xB4\x78\xD0\x30\xE4\x09\xF1\x7B\x3A\xE9\x60\x68\xD9\x06\xF8\x59\x22\x6A\x66\x47\xD6\x09\x8A\x95\x18\x3B\x01\x46\x0D\x29\x36\x7B\xA5\x22\xB4\x05\x7E\x30\xAC\x8B\xC2\xD5\x4C\xBB\x63\x50\x0B\x76\xA1\x36\xEB\x36\xA0\x77\xD8\xF7\x98\x14\x57\x91\x0E\x8D\x9C\x42\x95\xE9\x39\x42\x01\xC9\xB8\xDF\x82\x87\xFF\xE5\xE6\x66\x80\x0B\x19\xB4\x13\xAC\xEC\x71\x2A\x5D\x35\xC5\xCA\x0F\x56\xE6\xA3\x51\x70\x58\x21\xB2\x20\x8D\xC9\xDE\xCC\x25\x19\xD5\xCF\xA1\xB9\x2B\x68\xBE\xD2\x64\x32\x94\x9B\x02\x7C\xF2\x00\xFE\x3D\x8B\x40\xA2\x19\x50\x0F\xEE\x41\x61\x23\xA8\xC5\xA3\xF5\xFC\x37\x35\x1E\x6A\x51\x42\xAA\x33\x8D\x34\x11\xF8\xB3\xBD\x2B\x74\x99\x16\xFF\xAD\x26\x8F\x00\xC5\xF5\x1C\x59\x22\x02\x3E\xB1\x71\x08\x43\xBF\xA7\x6B\xCD\x03\x33\x0E\x53\x9D\xBA\xE5\x28\xCA\x09\xE6\x1B\xAE\x11\x76\xA9\x7A\x89\xDF\x48\xDC\x85\xF1\x9A\xED\x9F\xE1\x9F\x2D\xB7\xDA\x21\xBA\xD1\x0C\xCA\x67\x05\x5B\xCC\x24\x5B\xEA\xF0\xB8\x6C\xC4\xB8' ),
            ( 0x0000001, b'\x05\x85\x7B\xAA\xC0\xC9\xE8\x62\x60\x62\xB0\xA0\x22\x03\x88\xA6\x84\x43\xAA\x8C\x77\x0C\x82\x94\x5D\x35\x82\x98\x04\x1C\xDD\xA8\xD4\x4E\x90\x6F\x6D\xB9\x81\xE2\x7B\x3F\x95\x74\x24\x3E\x9F\x53\x7B\xEF\x0A\x25\x47\x79\x89\x5C\xB6\xB2\x37\xFC\x4F\x74\x6F\x7F\xCD\xE3\x73\x8B\xF5\xD1\xA2\x3C\xBC\x70\xF1\x41\x84\xF2\xEB\x37\x9B\xCB\xC3\xD7\x46\x2E\x52\xC3\x97\x3A\xB6\x74\xF3\xD5\xBB\x5A\x89\x36\xF3\x1D\xD5\xA1\x0E\xF1\x8E\xF4\x17\x26\xCE\x66\x00\x28\xDE\x17\x3D\x5B\x3B\x83\x7B\xD3\xAB\xC4\xA1\xEF\x8A\x59\xA2\xE2\xBA\x6E\x13\xEE\xEA\x83\x6B\xC1\xB1\x17\x9C\x65\x1A\xBE\x45\xA7\xB2\x40\x91\x99\x07\x9F\x4B\x5F\xBE\xF8\xC6\x7E\x4E\x0A\xFF\x5B\xB5\x5A\x7C\x2F\x9E\x77\xEE\x3B\xE0\xB5\x62\x80\x22\x9D\x2D\x13\xCB\xBC\x33\x80\xDD\xAB\x15\xAA\xAD\x04\x3A\xAD\x8C\xD5\x32\x4D\x30\x32\xF0\x71\x47\x27\x5E\x4B\x12\xFB\xEF\x7B\xAB\x83\xAC\x9D\xCD\xED\xEE\x2C\x25\x69\x19\x6D\x60\xEF\x18\xB5\xA0\x80\x9D\xA2\x83\x31\x87\x07\x53\x52\xE1\x5B\x4C\x1E\xFF\x41\x61\x34\x1C\x3E\x1F\x5F\xA2\x58\xD7\x67\x56\x23\xB6\xEC\xF5\xBC\x27\xCE\xCD\xB4\xB2\x57\xB1\x3B\xEB\xA6\x58\x95\xE0\xB5\xE8\xB1\x9E\x18\x3F\x4B\x60\x96\x4E\xFB\x59\x25\x06\xF4\x95\x83\x80\x98\x5D\x9F\x59\x9B\x83\x26\x97\x89\xCE\xAC\xBB\xD0\x5C\x95\x37\xDC\xE4\xDD\x2F\x5C\x22\x9C\x65\x10\xFB\x61\xA1\x73\xA1\x6A\x89\x61\x93\x7C\xC8\x6E\x80\xB8\x48\x57\x48\x4F\x88\x7E\x6A\xCE\x90\xF3\xEB\xB3\x9F\x50\xF0\x0F\xB6\x29\x60\x28\xE5\x8B\xDF\xEA\xCA\xFB\x3C\xDD\xAA\x60\x60\x73\xB3\xAE\x45\x4F\xC9\x1D\xB2\x63\x31\x30\x3B\x85\xBA\x8A\x37\x41\xD6\x5A\x52\x11\xA2\x2A\x11\x39\xD2\x1E\x2D\xBF\x1A\x53\x8A\x13\x24\xC7\xA3\xDE\xBE\x0B\x23\x72\xCC\x92\x29\xB8\x2B\x92\x8F\x08\x0A\xB4\xA6\x47\x76\x29\x39\xBF\x40\xBC\x59\x9F\xCD\x9D\xCF\x35\x51\x16\xF5\x44\x40\xA4\xC3\x1D\xA8\x8C\x73\xC0\xA1\x12\x84\x15\x4D\xB1\x7B\x4A\x44\xF4\x12\x8E\x0F\xE4\x4C\x7E\x5C\xB2\x92\x5F\xA9\xB3\x71\xDA\x40\x50\x78\xC7\x02\x1F\x20\x79\x84\xF3\x91\x1F\x47\x47\x40\x67\x2B\x52\xA1\x67\x91\x05\xCA\xB4\xAB\xA8\x69\x40\xFD\x7F\x28\xF6\x17\xB0\xDD\x1A\x82\x0F\x20\x5D\xD2\x39\xA8\x9A\x73\xF1\xAC\x10\x18\x3C\x69\x99\x49\xB8\xB2\x90\x24\xB5\x2E\x0C\x57\x93\x6A\x1B\x0B\x9C\xB9\xF5\x45\x71\xDD\xAF\x94\x6F\xA5\xF5\xCF\xB1\xBC\x1C\x0E\x5E\x5A\x0E\xF6\x9D\x9E\x71\x11\x99\x9F\xA4\x57\xE6\x6D\xD5\x83\x00\xD7\x85\x0C\x54\x01\xD4\x49\x1C\xF6\x8C\x8E\x00\x8B\xF8\x48\x50\x4D\x6F\xF1\xEA\xEF\x2D\x64\xD4\xF5\x00\xA9\x03\xE6\xCB\x5F\xCF\x6C\xD6\x26\xC1\xF4\x97\xCF\xB5\x16\xA1\x62\xDE\xFF\xC2\x00\xD0\x9A\x5E\xBB\xB4\x76\x86\xFD\x4B\xF2\x29\x4F\x0F\x69\x15\x7D\xAC\xAA\x2B\xD1\xBA\x6E\xA2\x1A\xC1\x6B\x9A\x14\x90\x63\xBD\xC4\x31\x36\xBB\x26\xA7\x69\x7D\x11\x76\xE5\x3F\x05\xC5\x4F\x6D\xB0\x12\x2E\xBC\x72\x18\x8A\x0F\x07\xA1\x2A\xD0\xC0\xDE\x2B\x63\x19\x6E\xA8\x7F\xC7\x9D\x47\x2F\xA6\x62\xA3\x57\xF0\x37\x58\x9F\x80\x4D\x9D\xA9\x2F\x2A\x39\x79\x16\x6A\xCA\xDF\x22\x8F\x2F\xAA\xA2\x72\x75\x96\x63\x19\xE2\xDF\x7E\x37\x1D\x68\xF8\xD9\x5D\x8D\x40\x23\x7F\xF5\x1B\x40\x33\xCB\x38\x81\x4F\x4A\x5E\x25\x3C\xF0\x19\xD7\x01\xD1\x21\xF6\xC5\x6F\xDA\x17\x83\x60\x39\x25\x66\xF2\x25\x31\x58\xA6\xA4\xAD\x46\x78\xE7\x76\x57\x19\xCB\x7C\x9C\x6D\xE0\x6D\xF8\xFD\x28\x14\x14\x0D\xF0\x0C\x8F\xD4\x68\x59\xD2\x96\x15\xBF\xEC\x8A\x34\xF7\x1A\x3B\x2C\x8C\x4A\x98\x16\x37\x7D\x95\x15\xBD\x45\xCB\xF8\xC1\xA1\x9E\x64\x3A\x17\x4C\xC4\xD2\xD1\xA0\xA4\xBD\x5A\x79\xCB\x53\xBC\x37\x84\xC8\x4F\x9B\xD7\x10\x42\x3D\x26\x40\xD6\xF2\x50\x20\x17\x8C\x2A\x81\x3A\xB5\xD2\x8B\x66\xE5\x9F\xCB\xEB\x29\xC8\x41\xD1\xB1\x9F\xBA\x77\x2A\x18\xD7\x7F\x8D\x46\x60\xFE\xDB\xE4\xC1\xA5\x73\xDD\x88\x7B\x17\xAA\x3D\x58\x30\x9B\xF6\xB2\x66\x4E\xAC\xC3\xE3\xA4\x7A\xAE\xDF\x33\xBE\x52\x89\xB7\xF9\xB0\x18\xFB\x70\x63\x9A\xC2\xB5\xFD\xEF\x3C\x8E\x91\x69\x5F\xA8\xE0\xF6\x83\x25\xEF\x16\xAA\xAF\x27\xB5\xD5\x2C\x58\x57\x35\x67\x5D\x11\x31\xA3\x25\x39\x0D\x5C\xF1\xAC\xD4\xFB\x03\x4C\x8A\xC0\xFB\xB2\xE5\x0E\xAD\x7F\xC9\xB1\x33\xAE\xD9\xEE\x3D\x71\xCB\x23\x54\xF9\x7F\xBF\x02\x4D\xE1\xD2\xBC\x66\xA9\x5C\x9D\x36\x47\x5A\x62\x76\xEF\xC5\xC8\x30\xBC\x78\x79\x92\x62\xA8\xE9\x0B\x83\xE5\x91\x42\x8F\xFC\xE9\xA8\x6C\xAB\xA9\x75\xA1\x9B\x6B\xA2\xE5\x87\x96\xBE\x16\x84\x0A\x04\x29\x9F\x2E\x2D\xC9\xC8\xDA\xEA\xF6\x9A\x25\x0F\xF8\xC0\xFD\xB5\xD7\x82' ),
            ( 0x0000001, b'\xFF\xD3\xB0\xA7\x2D\x6F\x68\x3A\x0B\x80\x75\xAA\xE0\xE7\x1E\x77\x32\x81\x7D\x74\x65\xEE\x85\xB5\x7A\xD8\xD6\x53\xCE\x9F\x4F\xB7\xBD\xD4\xB0\xB6\x7B\x44\xA5\x2C\x2E\x69\xC9\x60\xE3\xAE\xC7\xAD\x66\x04\xDC\x1D\xB1\xAE\xB2\xAE\x5E\xF0\x78\xCB\x08\xFF\x40\x1C\x36\x34\x0C\x10\xE3\x41\x9B\x80\x8F\x62\xBF\xD6\x25\xB7\x2D\x74\x83\x4F\x24\x7E\xBA\xB7\x0D\x87\x9A\x5C\x72\xE6\xF0\x09\x79\x51\x2B\x1F\xE6\x4A\xC0\x22\x17\x58\x66\xE9\x8B\xB2\x92\xE3\x62\xFC\x73\x6E\xBC\x72\xD5\xCF\x08\x05\x4B\xB6\x14\x3C\x91\x33\x3E\x60\xBA\x81\xC3\xFD\x32\xA9\xB7\x64\xD8\x1F\x9B\x44\x63\x2D\x1A\x70\xE1\xF5\x4E\xA0\x8D\x3C\x20\x8C\x46\x59\xF5\xF4\xE2\xE6\xA2\xA7\xE8\x18\xCB\x4D\xDB\x5A\xC6\x90\x93\xAC\xDF\x6A\xFF\xD1\x00\x96\x4F\xFC\xEF\xB7\x6A\xEB\xBB\x87\x30\x4F\xFC\x19\xCE\x12\x33\xC1\x13\xDE\xDF\xA3\x7B\x89\xC2\xA3\xDC\xA4\xA9\xBD\x04\x10\x96\xEE\xB8\x77\xFA\x98\x5C\x42\x01\xF3\xF5\xD4\xEF\x18\x0E\xB4\x0F\x2E\x2C\xFC\x9A\xD0\xCF\x4C\x99\xE1\x20\xF0\x65\x5B\xFE\xAF\xF0\x9B\xB5\xDF\xD5\x2B\xC2\x3D\xB0\xFD\xE8\x31\x3C\x7F\xA6\x65\x6F\xBA\x0E\xD9\xC9\x8D\x5B\xD1\xEA\x7C\x7F\x4B\x52\xED\x80\x4F\x26\x17\x95\x91\x6B\xB8\x08\x2C\x1E\x62\x4F\xD2\xD0\x7A\x00\x75\xA6\x13\x29\x93\xCB\xC4\xC5\xA7\x9E\x90\xB1\x7C\x8C\x1C\x7A\x59\x6C\x1D\x5D\xFC\x46\xAF\x0C\x96\xBA\x31\x95\x44\x7B\xCB\x5E\xAB\x64\x42\xF7\x35\x7A\x1F\x87\xF2\xB3\x3E\x42\x33\x28\xCF\x52\x47\x47\x13\x9A\xA3\x63\xD1\xBD\x7A\xF0\x0C\x90\x68\x1D\x0C\x03\x83\xA9\x8E\x9D\x7A\x5C\x6A\x1E\x66\xA9\xF1\x2B\xB8\xCE\xA2\xD2\x2B\x17\x21\xB1\x83\x87\xFC\xF1\xF3\x46\x78\xDC\xD3\x96\x66\xC2\xB4\xD3\x83\x02\xA8\xD7\xA5\x95\xDF\x30\x04\xF2\xD1\x52\x8C\x5A\x44\x62\x68\xBC\xCD\xA7\x69\xCB\x4E\xB4\x5B\x10\x83\x59\xAC\x28\x29\x13\x04\xC3\xB2\x7A\xC5\x35\xA7\xB0\x0A\xD4\xF0\xF0\xEC\xB4\xC0\xF2\xD2\xC2\x2B\x88\x03\xD5\xE6\x4E\x6F\xEF\xAD\x7D\xD8\x0F\xF0\x6C\xB0\xB1\x09\xD8\x9D\x99\x14\xE3\x00\x05\x23\xC7\x15\xB9\xB1\xB7\xF1\xEE\x9F\xCE\x04\x39\xB7\xE2\x4D\x0C\x5A\x13\x7A\x72\x08\x21\x11\x28\xB2\x35\xEC\x7A\xE5\x23\xD5\x66\xD6\x4C\x7A\x82\xFD\x6E\x1F\x3A\x01\xDC\x38\x3A\x21\x7B\x23\xB5\xFA\xCC\x05\x65\x8D\xDC\xDA\x5C\xA7\x0A\x1A\xA0\x02\xF4\xB6\xA0\x32\x34\x77\xC5\xE2\xBB\x10\x46\xCE\x57\xE3\xA9\x0B\x65\x73\x8F\xD5\xA5\x17\x83\x00\xBD\x40\xB1\xEE\x44\xF4\xEB\x28\x5B\x96\xA6\xC1\x94\xD3\xB6\x4B\xAE\xF4\x72\xF6\xEC\xAC\xD4\x52\x9E\xC7\x7A\xA8\x4B\x3D\x1D\xBC\xC0\x57\x7B\x91\x62\xEE\x4D\x67\xF3\xBA\x8D\xBB\x6D\xE7\x48\x5E\xBE\x16\x48\x85\x6C\x52\x48\x00\xFF\x06\x95\xE1\x7E\xD9\x13\x98\xE0\x6D\x96\x13\xB7\x4B\x28\x3B\xAC\xC5\x0A\x37\x85\xBB\x6E\xE5\xE9\x2F\x2C\x0E\x9E\xB7\x44\xE7\x85\xF2\x5B\xFD\xEE\x8B\xC2\xB8\x30\xE0\x81\x29\x94\xDB\x33\xFF\x88\x32\x91\xF9\xCB\x14\xBC\x2D\x91\x26\x13\x4A\xA2\xE2\xD7\xD0\xCA\x9F\x1F\x36\x7A\x12\x7D\x0C\x9A\x0B\xE6\x5C\xE2\xB7\x4D\xE5\x0B\xA4\x3E\x25\xF8\xD9\x8D\x9D\xF4\xE3\x2C\x8A\x9B\x98\xAD\x6B\xF5\x0F\xFB\x7D\xDA\x2A\xFE\x21\x18\x76\x9A\x1A\x55\xFC\x25\xCA\x3E\xF9\xFD\xE4\xB6\x2D\x10\x3E\x58\x79\xD8\x30\xED\xDD\x4B\xB6\x0F\xD5\xD6\xF6\xB4\xB1\x37\x7C\x4E\x29\xE6\xF7\x79\x23\x74\x01\x66\x5F\x02\xEB\xF2\x9F\x51\x02\x39\x31\xAA\x8B\xBC\xDE\x6E\x5A\x6D\xAF\x3A\x84\x23\x34\xF4\x13\x9C\x04\xFD\x7E\x6C\xE7\x22\xCC\xB9\x32\x6B\xD9\xC2\x77\xC2\x7B\xDF\xE9\xB6\x17\x53\xAF\x7B\xA6\x94\xAE\x39\x39\x00\xEF\x75\xE2\x4D\x15\xF6\x45\x1A\xB2\x9F\xD6\x82\x24\x45\xB2\x07\xA7\x00\x3D\x14\x01\x62\x40\xDD\xD2\xB8\xF0\x96\x9B\x07\x0C\x49\xF8\x74\xB2\xBF\xE9\x31\xB3\x2E\x9D\x2F\x30\xC2\xF6\xED\x4C\x56\x42\xD4\x47\x55\x6A\xF4\x39\xC2\x23\x5F\x58\xBD\x2C\x7B\xC5\x4A\xDC\x8A\xAD\x40\xE5\x84\xA0\x65\xB3\x65\x73\x74\x9F\xAB\xBD\xE6\x09\xA2\x24\x65\x8D\xF6\x5B\x5B\x14\x4B\xC0\x6A\x78\xF2\xD6\xF3\x76\x45\xA0\x77\xDD\xAA\xDB\x13\xF9\x9F\x0F\x5A\xA5\xA0\xB9\x28\x48\x95\x24\x03\x2D\x94\x6E\xE1\x05\xF7\x5C\x23\x82\x29\x95\xA1\x7C\xF2\xE3\xB9\x2F\xAC\x29\x11\xEC\x60\xD1\x4C\x5F\xB8\xD2\x1E\x9D\xEC\x76\x1D\xFC\x5F\xC0\xFE\xD1\x50\x33\x0A\x42\xD7\x83\xC9\xF9\x49\x54\xBB\x50\x17\x6C\x6B\x38\xC1\x31\x19\xDB\xFC\xDE\xCE\x17\xAD\xB2\xD1\xDA\x0A\x13\xEE\x2B\xED\x3A\xEA\xEA\x20\x8E\x17\x14\x0B\x88\xEE\xB9\xA5\x02\x1B\xE8\x6C\xF7\xFB\xE4\x18\x72\xE7\x35\x88\xDE\x8E\xB8\x56\xFB\xD9\x8C\xB8\x81\xA7\x39\xAC\xF2\xD2\x39\x0B\xAF\x7F\xB6\xD2\x0E\xA5\xC7\xA0\xB3\xEF\x6F\x4B\xF4\x08\x78\xB2\xA8\x89\xCD\x0E\x0E\x8A\xB1\x8F\x8C\xAC\xE3\x23\x23\xB6\xD1\x6C\x80\xFD\xF5\x4D\x65\x3B\x75\x17\xFC\x81\xA3\x88\x15\x2A\xEE\x19\xE0\xFD\xF5\xF1\xC2\xC3\xDD\xEE\x7A\x08\x12\x25\x72\x75\x42\x77\x8D\x51\x5B\xD6\x31\x61\x88\x21\x73\x86\x2E\xE5\x8E\x0B\x3E\xBE\x61\xB8\xE4\xFD\xFA\x67\xC6\x44\x78\xB2\x31\xD9\x8B\xBF\xA8\x07\x8F\x7E\xBE\x46\x54\x53\x24\x9A\x25\xE5\xD3\x5F\xC0\x22\x20\xEA\xC0\x86\xCD\x6C\xF8\x7A\x4A\x6C\x18\xBD\x0F\xCC\xF3\x5F\x7F\xE0\xBE\xB0\x53\x94\x5F\xE0\x89\x11\x86\x92\xF2\x3F\x1A\xBD\xE8\x68\xB8\x35\x3B\x91\x8F\x85\x73\x98\xB9\x7E\xD1\xC0\xAD\xF8\x4D\x72\x04\x4F\x1D\xAD\x82\x5F\x86\xDD\x89\x17\x73\x38\xF8\x25\x34\xBA\x57\x24\xF8\xF3\xE3\x50\xAE\x41\xD9\x91\xF8\xAC\x8E\xC4\x87\xF6\x58\xD2\x1C\x31\x9B\xC9\x0E\x28\x56\xC9\x5F\x09\x43\x73\xA0\x79\x13\x58\xF2\x5E\x25\x89\x8F\x17\x58\x9E\xB3\x5E\x30\x6C\x8A\xAB\x81\x43\x27\x6C\x53\x82\x08\x19\xB9\xC0\xFB\xDA\xF4\xDD\xBD\x55\x66\x8D\x71\xFF\x67\x40\x4E\x53\xB3\x70\x22\x7B\x80\x20\x8C\x92\x3F\x0F\x73\xAB\xF1\xE4\x5A\xA2\x57\x3D\xDF\xDE\x39\xD0\xE5\x47\x1C\x41\xDA\x7A\x95\x0C\x5E\xE4\xA3\x84\x34\x6E\x3E\xA4\x9A\xFD\x22\x46\xA9\x79\x65\x69\x19\x6A\xCE\x8A\xE9\x58\x94\x4A\xE1\xD9\x71\x02\xD9\x8F\x46\xA6\x5C\x59\x48\x1F\x63\x97\x1F\xAF\xFC\x11\xF0\x08\x02\x11\x02\xFF\x70\xA4\xE7\x3A\xB9\x5C\xF1\x70\xCA\x58\xF3\x1A\x00\x14\xFA\x7C\xBF\x7E\x1B\xDE\x7E\xD6\x4F\x58\x40\xFB\x8F\xEA\xDC\x8B\xEC\xE2\x2A\xDD\x39\x97\x04\xBE\x3D\x8E\x0C\xAD\x9B\x48\xEF\x92\x5F\x76\xE3\x0C\x0D\x40\x20\x08\x4A\x46\xE7\x65\x38\xF1\xB4\x43\xE6\x99\x06\x5D\xD5\x4D\x7B\xDF\xD6\x46\x7A\x92\x55\x56\x08\xE4\x5F\x08\xD8\xC5\x94\xA6\x5E\xFE\x3B\xEC\xA3\xE8\x54\x90\x2B\xF7\xF3\x37\x25\x90\x26\x0A\x1C\x78\xE6\xE5\x8D\xFF\x53\x96\x4B\xBB\xE4\xDE\x46\x05\x68\x7C\xBF\x05\x19\xD4\xD2\xC6\x8E\xAE\xE9\x45\x31\x60\xF8\x4C\xD1\x9A\xF1\xCA\x6E\x6E\x61\x33\xD0\x57\x15\x0E\x15\x6A\x14\x06\x1D\xCE\x65\xCA\x45\x71\xA7\xBB\x7A\xDE\xCE\xF6\xEA\x62\xA6\xFA\x54\xC1\xAE\xB4\x77\x26\x07\xC0\x10\x30\xB1\xCC\x24\xBF\xE8\x45\xC2\xA9\xD3\x4B\x66\xA1\xE3\xF0\x57\xB0\xFE' ),
            ( 0x0000001, b'fatherblessedthemallwithreasonandthisiswhattheychooseandthisiswhattheychoose' ),
            ( 0x0000001, b'inerw\xC3\xA4gungdassdah\xC3\xA4userstehenw\xC3\xA4hrendihrunsohnebleibelassthabenwirbeschlossenjetztdorteinzuziehenweilesunsinunsernl\xC3\xB6chernnichtmehrpasst' ),
            ( 0x0000001, b'hewasborninacoopraisedinacagechildrenfearhimcriticsrageheshalfaliveheshalfdeadHESGOTABUCKETONHISHEAD!' ),
            ( 0x000002A, b'(~2GS:=%/R&En0Z2@eY^a9WMifNUdx]?)6j8}En7R8{n7-aYXV99g|r(SU5]+wOvuq9A)]x|kTr*\\mm;skW:aZ}89B`c$3>aHtli9_VeFo_%dr,Hi\"kkD8O_Tra3L2/W>sO>5P6f{dJv+w}S=HW4>>E|JNU&$[W4**IxMEbIvzD%qfj+h^_v-b2DA`z!Hvs@,YN!M>t+;Q2z_<6C4S<T6Koqb](YCm6?{]QuEJ_;}{1:/E$5+Ss1]T>,,hoF=zT`' ),
            ( 0x0000001, b'3.14159265358979323846264338327950288419716939937510582097494459230781640628620899862803482534211706798214808651328230664709384460955058223172535940812848111745028410270193852110555964462294895493038196442881097566593344612847564823378678316527120190914564856692346034861045432664821339360726024914127372458700660631558817488152092096282925409171536436789259036001133053054882046652138414695194151160943305727036575959195309218611738193261179310511854807446237996274956735188575272489122793818301194912983367336244065664308602139494639522473719070217986094370277053921717629317675238467481846766940513200056812714526356082778577134275778960917363717872146844090122495343014654958537105079227968925892354201995611212902196086403441815981362977477130996051870721134999999837297804995105973173281609631859502445945534690830264252230825334468503526193118817101000313783875288658753320838142061717766914730359825349042875546873115956286388235378759375195778185778053217122680661300192787661119590921642019893809525720106548586328' ),
            ( 0x1000000, b'abcdefghbcdefghicdefghijdefghijkefghijklfghijklmghijklmnhijklmno' )
        )
        TEST_RESULT = (
            b'\x4A\x07\x8B\xE6\x56\xB2\x94\x64\x38\x9C\x71\x09\xF0\xF4\x08\xB0\xAD\x9C\x92\xBD\xB4\x36\x03\x63\x73\xAC\x50\xBC\x99\x3C\x21\xF7\x34\x8B\x9E\xE2\x09\x80\xF7\x7F\x4D\x2B\xED\x49\x0E\xBC\x9D\x2E', #00
            b'\xF8\x41\xFD\x28\xF9\x75\xA8\x27\xED\x57\x55\xCD\xBA\xE2\xA0\xF0\xFB\x4D\xD8\xA0\x2C\x84\x10\x04\x0F\xEC\x8B\x42\x59\x0E\xEF\x70\xFF\x0F\x50\x4A\xE4\x4F\x38\x1B\xAF\x99\x59\x96\x03\x76\xC9\xE9', #01
            b'\x60\x1F\x8D\x7E\x31\x94\x48\xA6\x3E\x32\x86\x00\x64\x91\x2F\x34\x4D\xD7\x15\x52\xAC\x70\x61\x31\x19\x39\x6E\xB4\xBB\xCB\xAC\x95\x95\xE6\xF1\x80\x6C\x12\x7F\x83\xB0\x7A\x7D\x44\x9A\xFA\x83\x71', #02
            b'\xEF\xAC\xBD\xE1\x8D\x6A\xB7\x29\x45\x74\xD2\xF7\x68\x86\x49\xD9\x6D\x74\xAE\xA6\x85\xF6\xD4\x34\x38\x76\xBB\x9C\x25\x7C\xED\xB5\xA4\xE6\x0F\x8E\x01\x42\x96\xFB\x5E\x46\xC1\x7A\xC6\x79\xE7\xA8', #03
            b'\xDA\x23\x8B\xFF\x84\x2B\xDA\x78\xD3\x0F\x1F\xA2\xA1\x2D\xFA\x7D\x6A\xC5\xF1\xB0\x28\xBB\x41\xFB\x1F\xFA\x85\xD3\x63\x21\xFE\x08\xA6\x00\x64\xCD\x28\xCB\xB0\xF5\x73\xEA\x61\x6B\xFE\x08\xC2\x72', #04
            b'\x92\x39\x31\x81\xE1\x41\x3D\x83\xDB\x9B\x83\x52\x20\x83\xFC\x6A\xEE\xCE\xE2\x78\xAA\xCF\x53\xE1\xF2\x4F\x7A\x39\x36\x05\x75\x14\x1F\x71\x1E\x76\x2C\xD1\xBB\x43\x96\x38\xF7\x11\xEC\xD9\x1C\x15', #05
            b'\x0B\x99\x27\x1A\x6F\x34\x40\x52\xFF\x38\x01\x36\xF5\x28\xBC\xF3\x60\x2A\xAB\x73\x3D\x59\x86\xB2\x57\xEC\x91\x65\xAA\x61\x50\xA1\x79\x25\x54\xB1\x9E\x7E\xD9\x11\xBE\xB6\x48\x6D\xC0\x9D\x85\xA2', #06
            b'\x4C\xA3\x1A\x25\x69\x2C\xFC\x7C\x71\x8A\x9D\xD1\xE0\x5D\xF8\xBE\xAA\xE5\x38\x66\x9F\xE7\x11\x0F\x72\x63\xEF\xC0\xE3\xCE\x10\x8E\xCD\xA0\xC3\xD9\x85\x46\x42\xAA\xC7\x56\xDF\xC4\xC6\xD4\x22\x8E', #07
            b'\x9B\xF9\x38\xC8\x33\xE2\x58\x44\x3E\xDE\xFD\x51\x0A\x62\x2D\xED\xED\x72\x1C\x01\x45\xD5\xC9\xD0\xF9\x88\x15\x74\x0A\x23\x9D\xD8\x50\x5B\xFF\x7B\x2D\x0E\x6A\x1B\x0A\x4D\xF2\xC5\xF6\x7B\x41\x28', #08
            b'\x87\x37\x44\x97\x9E\xFA\x03\x2F\x78\xD0\x66\x97\x30\x13\xFD\x44\x2F\x91\x97\xE7\xD4\x12\xB9\xAA\xEF\xE5\xCB\xB1\x74\xBE\x63\xC0\xCC\x02\xA6\xE0\x30\xE6\x14\x75\xEB\x89\x4A\xE1\x2D\x16\x57\x51', #09
            b'\x56\x7F\x32\x54\xFD\x4F\x58\xC9\x66\xF5\x11\x99\x27\xF1\x2F\x0B\x59\x3E\x5A\xCF\x90\x02\x88\xF1\xC5\x9D\xCC\xC0\xE4\x77\xC3\x4A\x00\xF4\xBF\x6B\x71\xF2\xF9\x08\xFD\x1A\xF2\x9C\x27\x88\x87\x97', #0A
            b'\x0E\x73\x2B\xB3\x8D\xC5\x35\x9D\xA7\xC9\x7B\x63\xD5\x2C\x5E\xE1\x20\x73\x33\x7D\xE7\x4E\x16\x95\x48\x40\xD6\xE3\x63\x0E\xC3\x5B\xD2\xFF\xEA\xD6\x5D\xFD\x11\x5C\x1B\x58\x1E\xEF\x1B\x32\xDD\x2A', #0B
            b'\x8E\x7E\xC7\x36\xDF\xF6\xC7\x9C\x55\xAE\x12\x99\x05\x5D\x9D\x61\xD3\x26\x2E\x84\xEE\xCC\x56\x33\x47\x29\x6B\x89\xBF\x81\x2F\xDC\xC6\x30\xD2\x62\xCE\xAC\x4C\xBE\x21\x1F\x57\x9E\xB6\xEC\x1C\xB2', #0C
            b'\x34\xDE\x19\x51\x1B\xE9\xA2\x84\xD8\xB9\xB4\xC7\x6D\xD6\x93\x4F\xC0\xB5\xEB\xC2\x0D\x6E\xB7\xE3\x9B\x54\x13\xB3\x39\x8D\x34\x9F\x80\x6B\x13\x36\x7A\x11\xF4\xB5\xD4\xC3\xD0\xCE\x6F\x8E\xA3\xA7', #0D
            b'\x0F\xF2\xA2\xF0\xAC\x6F\x43\xAF\x48\xCE\x8A\x38\x0B\x1A\xB1\x34\xCE\x6A\x31\x76\xCE\xC8\x13\xB2\xAE\x6C\x3B\x7A\xB6\xDA\xEF\xD1\xBE\x99\xE7\xF3\xC9\xE6\x1A\x1B\x3E\x63\x1D\x07\x7C\x27\x35\x13', #0E
            b'\x09\x19\xF0\x2A\x72\x1C\x4A\xDA\x98\x79\xC3\xBE\x6C\xEC\x98\xFB\x6E\xA0\xD4\x53\xC2\x0D\xB4\xBD\x9B\x28\x7E\xD6\x25\x2B\x98\x25\xCF\x66\xA0\x65\xA2\x09\xAF\xC8\xD5\xA2\x2A\xDF\x2E\x45\x7C\x6E'  #0F
        )
        for test_case in zip(TEST_VECTOR, TEST_RESULT):
            mhash384 = clazz()
            for k in range(test_case[0][0]):
                if (k & 0x7FFF) == 0:
                    percentage = 100.0 * (k / test_case[0][0])
                    print('\r%.2f%%' % percentage, end='')
                mhash384.update(test_case[0][1])
            result = mhash384.digest()
            if not clazz.__compare_bytes(result, test_case[1]):
                raise AssertionError('Test vector did NOT compare equal!')
            print('\r' + str(bin2hex.hexlify(result)))
        print('Self-test completed successfully.')

