/*
 * Decompiled with CFR 0.152.
 */
package com.muldersoft.mhash384.example;

import com.muldersoft.mhash384.MHash384;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;

public class ExampleApp
extends JFrame {
    private static final long serialVersionUID = -3576679013210278556L;

    public ExampleApp() {
        final JButton[] jButtonArray = this.initUI();
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                try {
                    List<Integer> list = MHash384.getVersion();
                    ExampleApp.this.setTitle(String.format("MHashJava384 - Example App v%d.%d.%d", list.get(0), list.get(1), list.get(2)));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    JOptionPane.showMessageDialog(ExampleApp.this, ExampleApp.getMessage(throwable), throwable.getClass().getName(), 0);
                    ExampleApp.this.dispose();
                }
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                for (JButton jButton : jButtonArray) {
                    if (!jButton.isEnabled()) continue;
                    ExampleApp.this.dispose();
                    break;
                }
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
            }
        });
    }

    private JButton[] initUI() {
        this.setDefaultCloseOperation(3);
        this.setTitle("MHashJava384 - Example App [Launching]");
        this.setSize(800, 384);
        this.setMinimumSize(this.getSize());
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(0);
        final JTextField jTextField = new JTextField();
        final JTextField jTextField2 = new JTextField();
        jTextField.setEditable(false);
        jTextField2.setEditable(false);
        jTextField.setText("Please click \"Choose File\" to select your input file!");
        final JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setMinimum(0);
        jProgressBar.setMaximum(100);
        jProgressBar.setValue(0);
        final JButton jButton = new JButton("Choose File");
        final JButton jButton2 = new JButton("Compute Hash");
        final Semaphore semaphore = new Semaphore(0);
        jButton2.setEnabled(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ExampleApp.this.browseForFile(jTextField, jTextField2, jProgressBar)) {
                    jButton2.setEnabled(true);
                    jButton2.requestFocus();
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExampleApp.this.computeHashAsync(jTextField.getText().trim(), jTextField2, jProgressBar, new JButton[]{jButton, jButton2}, semaphore);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(8, 1));
        jPanel.setBorder(new EmptyBorder(new Insets(12, 12, 12, 12)));
        jPanel.add(new JLabel("Input File:"));
        jPanel.add(jTextField);
        jPanel.add(new JPanel());
        jPanel.add(new JLabel("File Digest:"));
        jPanel.add(jTextField2);
        jPanel.add(new JPanel());
        jPanel.add(new JPanel());
        jPanel.add(jProgressBar);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2, 12, 12));
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel, "North");
        container.add((Component)jPanel2, "South");
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                boolean bl;
                boolean bl2 = bl = !jButton2.isEnabled() && !jButton.isEnabled();
                if (keyEvent.getKeyCode() == 123 && keyEvent.getID() == 401 && !bl) {
                    ExampleApp.this.runSelfTest(jTextField2, jProgressBar, new JButton[]{jButton, jButton2}, semaphore);
                    return true;
                }
                if (keyEvent.getKeyCode() == 27 && keyEvent.getID() == 401 && bl) {
                    semaphore.release();
                    return true;
                }
                return false;
            }
        });
        return new JButton[]{jButton, jButton2};
    }

    private boolean browseForFile(JTextField jTextField, JTextField jTextField2, JProgressBar jProgressBar) {
        JFileChooser jFileChooser = new JFileChooser();
        boolean bl = false;
        if (jFileChooser.showOpenDialog(this) == 0) {
            try {
                jTextField.setText(jFileChooser.getSelectedFile().getCanonicalPath());
                jTextField2.setText("Please click \"Compute Hash\" to begin computation!");
                jProgressBar.setValue(jProgressBar.getMinimum());
                bl = true;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                Throwable throwable2 = this.unwrapException(throwable);
                jTextField2.setText(ExampleApp.getMessage(throwable2));
                JOptionPane.showMessageDialog(this, ExampleApp.getMessage(throwable2), throwable2.getClass().getName(), 0);
            }
        }
        return bl;
    }

    private void computeHashAsync(String string, JTextField jTextField, JProgressBar jProgressBar, JButton[] jButtonArray, Semaphore semaphore) {
        try {
            File file = new File(string);
            if (!file.exists() || !file.isFile()) {
                JOptionPane.showMessageDialog(this, "Input file could not be found!", "Not Found", 2);
                return;
            }
            HashWorker hashWorker = this.createHashWorker(jTextField, jProgressBar, jButtonArray, file, semaphore);
            for (JButton jButton : jButtonArray) {
                jButton.setEnabled(false);
            }
            semaphore.drainPermits();
            jTextField.setText("Working on it, please be patient...");
            hashWorker.execute();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Throwable throwable2 = this.unwrapException(throwable);
            jTextField.setText(ExampleApp.getMessage(throwable2));
            JOptionPane.showMessageDialog(this, ExampleApp.getMessage(throwable2), throwable2.getClass().getName(), 0);
        }
    }

    private HashWorker createHashWorker(final JTextField jTextField, final JProgressBar jProgressBar, final JButton[] jButtonArray, File file, Semaphore semaphore) {
        return new HashWorker(this, file, semaphore){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    JButton[] jButtonArray2 = (JButton[])this.get();
                    if (jButtonArray2 != null && jButtonArray2.length() > 0) {
                        jTextField.setText((String)jButtonArray2);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    JButton[] jButtonArray3 = ExampleApp.this.unwrapException(throwable);
                    jTextField.setText(ExampleApp.getMessage((Throwable)jButtonArray3));
                    JOptionPane.showMessageDialog(ExampleApp.this, ExampleApp.getMessage((Throwable)jButtonArray3), jButtonArray3.getClass().getName(), 0);
                }
                finally {
                    for (JButton jButton : jButtonArray) {
                        jButton.setEnabled(true);
                    }
                }
            }

            @Override
            protected void process(List<Integer> list) {
                jProgressBar.setValue(ExampleApp.maxValue(list));
            }
        };
    }

    private void runSelfTest(final JTextField jTextField, final JProgressBar jProgressBar, final JButton[] jButtonArray, final Semaphore semaphore) {
        System.out.println("[SELF-TEST]");
        for (JButton jButton : jButtonArray) {
            jButton.setEnabled(false);
        }
        SwingWorker<Boolean, Integer[]> swingWorker = new SwingWorker<Boolean, Integer[]>(){
            private final Integer[] lastProgress = new Integer[]{-1, -1};

            @Override
            protected Boolean doInBackground() throws Exception {
                jTextField.setText("Self-test is running, please be patient...");
                MHash384.selfTest(semaphore, new Consumer<Integer[]>(){

                    @Override
                    public void accept(Integer[] integerArray) {
                        this.publish((Object[])new Integer[][]{integerArray});
                    }
                });
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                block7: {
                    try {
                        if (((Boolean)this.get()).booleanValue()) {
                            jTextField.setText("Self-test completed successfully.");
                            JOptionPane.showMessageDialog(ExampleApp.this, "Self-test completed successfully.", "Self-test", 1);
                            break block7;
                        }
                        throw new AssertionError((Object)"Self-test has failed. See log for details!");
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        JButton[] jButtonArray2 = ExampleApp.this.unwrapException(throwable);
                        jTextField.setText(ExampleApp.getMessage((Throwable)jButtonArray2));
                        JOptionPane.showMessageDialog(ExampleApp.this, ExampleApp.getMessage((Throwable)jButtonArray2), jButtonArray2.getClass().getName(), 0);
                    }
                    finally {
                        for (JButton jButton : jButtonArray) {
                            jButton.setEnabled(true);
                        }
                    }
                }
            }

            @Override
            protected void process(List<Integer[]> list) {
                Integer[] integerArray = ExampleApp.maxValueEx(list);
                if (integerArray.length >= 3) {
                    if (this.lastProgress[0] != integerArray[0] || this.lastProgress[1] != integerArray[1]) {
                        jTextField.setText(String.format("Self-test is running (step %d of %d), please be patient...", integerArray[1] + 1, integerArray[0]));
                        this.lastProgress[0] = integerArray[0];
                        this.lastProgress[1] = integerArray[1];
                    }
                    jProgressBar.setValue(integerArray[2]);
                }
            }
        };
        swingWorker.execute();
    }

    private static int maxValue(List<Integer> list) {
        int n = Integer.MIN_VALUE;
        for (Integer n2 : list) {
            n = Math.max(n, n2);
        }
        return n;
    }

    private static Integer[] maxValueEx(List<Integer[]> list) {
        if (!list.isEmpty()) {
            Integer[] integerArray = list.get(0);
            block0: for (Integer[] integerArray2 : list) {
                for (int i = 0; i < Math.min(integerArray.length, integerArray2.length); ++i) {
                    if (integerArray2[i] > integerArray[i]) {
                        integerArray = integerArray2;
                        continue block0;
                    }
                    if (integerArray2[i] < integerArray[i]) continue block0;
                }
            }
            return integerArray;
        }
        return new Integer[0];
    }

    private Throwable unwrapException(Throwable throwable) {
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null) {
            return this.unwrapException(throwable2);
        }
        return throwable;
    }

    private static String getMessage(Throwable throwable) {
        String string = throwable.getMessage();
        return string != null && !string.isEmpty() ? string : throwable.getClass().getName();
    }

    private static class HashWorker
    extends SwingWorker<String, Integer> {
        private final File inputFile;
        private final Semaphore abortFlag;

        public HashWorker(Component component, File file, Semaphore semaphore) {
            this.inputFile = file;
            this.abortFlag = semaphore;
        }

        @Override
        protected String doInBackground() throws FileNotFoundException, IOException, InterruptedException {
            double d = this.inputFile.length();
            long l = System.currentTimeMillis();
            MHash384 mHash384 = new MHash384();
            try (Object object = new BufferedInputStream(new FileInputStream(this.inputFile));){
                int n;
                long l2 = 0L;
                byte[] byArray = new byte[4096];
                do {
                    if ((n = ((FilterInputStream)object).read(byArray)) > 0) {
                        mHash384.update(byArray, 0, n);
                        this.publish((int)Math.round((double)(l2 += (long)n) / d * 100.0));
                    }
                    if (!this.abortFlag.tryAcquire()) continue;
                    throw new InterruptedException("Operation aborted by user!");
                } while (n == byArray.length);
            }
            object = mHash384.digest();
            long l3 = System.currentTimeMillis() - l;
            System.out.printf("Operation completed after %f seconds!\n", (double)l3 / 1000.0);
            return ((MHash384.ByteString)object).toString();
        }
    }
}

