#ifndef MFILER2_COMMON
#define MFILER2_COMMON

extern "C" {
#include "ruby.h"
}

#include <map>
#include <string>
#include <list>
#include <vector>

extern "C" {
#include "mylib/mylib.h"
#include "mylib/mydebug.h"
}

using namespace std;

/// menu.cpp ///
#include "menu.h"

extern cMenu* gActiveMenu;
extern map<string, cMenu*> gMenu;

/// dirwnd.cpp ///
#include "dirwnd.h"

/// main.cpp ///
extern cDirWnd* gLDir;
extern cDirWnd* gRDir;
extern bool gMainLoop;
extern map<string, VALUE> gKeyCommand[2][KEY_MAX];

bool is_kanji(unsigned char c);
void cut(char* src, char* dest, int len);
void string_erase(string& s, int n);
void err_msg(char* msg, ...);
void msg(char* msg);
int select_str(char* msg, char* str[], int len, int cancel);
void view();

extern bool gISearch;
extern bool gColor;
extern bool gIndividualCursor;
extern bool gCheckDeleteFile;
extern bool gCheckCopyFile;
extern bool gProcessLine;

const int kWhite = 1;
const int kBlue = 2;
const int kCyan = 3;
const int kGreen = 4;
const int kYellow = 5;
const int kMagenta = 6;
const int kRed = 7;

/// command.cpp ///
void command_init();
void command_final();

/// cmdline.cpp ///
const int kOutputSize = 16384;
struct sMasterTty
{
    int mFD;
    char mName[1024];
    
    char mOutput[kOutputSize];
    int mOutputTail;
};

extern vector<sMasterTty*> gMasters;
extern bool gCmdLineActive;   // readonly
extern vector<string> gCCandidate;    // readonly

void cmdline_init();
void cmdline_final();
void cmdline_start(char* cmd, int posion);
void cmdline_input(int meta, int key);
void cmdline_view();
void cmdline_completion_view();
void cmdline_run(char* str, char* title);
void cmdline_restore_pty(int n);
int cmdline_select_pty();

/// file.cpp ///
enum eCopyOverride { kNone, kYesAll, kNoAll, kCancel };
extern eCopyOverride gCopyOverride;

bool file_copy(char* spath, char* dpath);
void file_remove(char* path);
void file_move(char* spath, char* dpath);

#endif
