/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.ui;

import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import mergedoc.ui.ComponentFactory;

public class ButtonBar
extends JPanel {
    private JButton runButton;
    private ActionListener runListener;
    private ActionListener backListener;
    private JButton endButton;
    private ActionListener cancelListener;
    private ActionListener endListener;
    public final ButtonState INIT_STATE = new ButtonState(){

        public void apply() {
            ButtonBar.this.runButton.setText("\u5b9f\u884c(R)");
            ButtonBar.this.runButton.setMnemonic(82);
            ButtonBar.this.runButton.setEnabled(true);
            ButtonBar.this.runButton.addActionListener(ButtonBar.this.runListener);
            ButtonBar.this.endButton.setText("\u7d42\u4e86(E)");
            ButtonBar.this.endButton.setMnemonic(69);
            ButtonBar.this.endButton.setEnabled(true);
            ButtonBar.this.endButton.addActionListener(ButtonBar.this.endListener);
        }
    };
    public final ButtonState WORKING_STATE = new ButtonState(){

        public void apply() {
            ButtonBar.this.runButton.setText("\u5b9f\u884c(R)");
            ButtonBar.this.runButton.setEnabled(false);
            ButtonBar.this.endButton.setText("\u30ad\u30e3\u30f3\u30bb\u30eb(C)");
            ButtonBar.this.endButton.setMnemonic(67);
            ButtonBar.this.endButton.setEnabled(true);
            ButtonBar.this.endButton.addActionListener(ButtonBar.this.cancelListener);
        }
    };
    public final ButtonState FINISH_STATE = new ButtonState(){

        public void apply() {
            ButtonBar.this.runButton.setText("\u623b\u308b(B)");
            ButtonBar.this.runButton.setMnemonic(66);
            ButtonBar.this.runButton.setEnabled(true);
            ButtonBar.this.runButton.addActionListener(ButtonBar.this.backListener);
            ButtonBar.this.endButton.setText("\u7d42\u4e86(E)");
            ButtonBar.this.endButton.setMnemonic(69);
            ButtonBar.this.endButton.setEnabled(true);
            ButtonBar.this.endButton.addActionListener(ButtonBar.this.endListener);
        }
    };
    public final ButtonState CANCEL_STATE = new ButtonState(){

        public void apply() {
            ButtonBar.this.runButton.setText("\u623b\u308b(B)");
            ButtonBar.this.runButton.setMnemonic(66);
            ButtonBar.this.runButton.setEnabled(true);
            ButtonBar.this.runButton.addActionListener(ButtonBar.this.backListener);
            ButtonBar.this.endButton.setText("\u30ad\u30e3\u30f3\u30bb\u30eb(C)");
            ButtonBar.this.endButton.setEnabled(false);
        }
    };

    public ButtonBar() {
        this.setLayout(new BoxLayout(this, 0));
    }

    public void setState(final ButtonState buttonState) {
        final JLabel jLabel = new JLabel();
        jLabel.setMaximumSize(new Dimension(1600, 0));
        this.runButton = this.createButton();
        this.endButton = this.createButton();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ButtonBar.this.removeAll();
                ButtonBar.this.add(jLabel);
                ButtonBar.this.add(ButtonBar.this.runButton);
                ButtonBar.this.add(ComponentFactory.createSpacer(10, 0));
                ButtonBar.this.add(ButtonBar.this.endButton);
                buttonState.apply();
            }
        });
    }

    private JButton createButton() {
        JButton jButton = new JButton();
        ComponentFactory.ensureSize(jButton, 100, 21);
        return jButton;
    }

    public void setRunListener(ActionListener actionListener) {
        this.runListener = actionListener;
    }

    public void setBackListener(ActionListener actionListener) {
        this.backListener = actionListener;
    }

    public void setCancelListener(ActionListener actionListener) {
        this.cancelListener = actionListener;
    }

    public void setEndListener(ActionListener actionListener) {
        this.endListener = actionListener;
    }

    public void setEnabled(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ButtonBar.this.runButton.setEnabled(bl);
                ButtonBar.this.endButton.setEnabled(bl);
            }
        });
    }

    private static interface ButtonState {
        public void apply();
    }
}

