/*
 * Decompiled with CFR 0.152.
 */
package mediacollage.swingui;

import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import mediacollage.core.AbstractObject;
import mediacollage.core.Binding;
import mediacollage.core.SelectionCode;
import mediacollage.swingui.AOView;

public class Editor
extends JFrame
implements ActionListener {
    public static Editor editor;
    private JDesktopPane desktop;
    private static String initialImageFile;
    protected int posX = 0;
    protected int posY = 0;
    private static AbstractObject ao1;
    private static AbstractObject ao2;
    private static AbstractObject ao3;
    private static Binding b11;
    private static Binding b12;
    private static Binding b13;
    private static Binding b21;
    private static Binding b22;
    private static Binding b31;
    private static Binding b32;
    private static Binding b33;
    private static Binding bb21;
    private static final long WAITTIME = 800L;

    public Editor() throws HeadlessException {
        super("MCEditor");
        int inset = 70;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(inset, inset, screenSize.width - inset * 2, screenSize.height - inset * 2);
        this.desktop = new JDesktopPane();
        this.setContentPane(this.desktop);
        this.setJMenuBar(this.createMenuBar());
        this.setVisible(true);
        new DropTarget(this, 3, new MyDropListener());
    }

    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Base");
        menu.setMnemonic(68);
        menuBar.add(menu);
        this.setupMenuitem(menu, "Open", "open", 79, 8, this);
        this.setupMenuitem(menu, "URL", "url", 85, 8, this);
        this.setupMenuitem(menu, "Quit", "quit", 81, 8, this);
        return menuBar;
    }

    private void setupMenuitem(JMenu menu, String label, String command, int mnemonic, int keymask, ActionListener listener) {
        JMenuItem menuItem = new JMenuItem(label);
        menuItem.setMnemonic(mnemonic);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(mnemonic, keymask));
        menuItem.setActionCommand(command);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
    }

    public AOView createView(AbstractObject ao) {
        AOView frame = AOView.makeAOView(ao.getConcreteObject().getImageIcon().getDescription(), ao, this);
        this.showAOView(frame);
        return frame;
    }

    public void actionPerformed(ActionEvent e) {
        if ("open".equals(e.getActionCommand())) {
            this.createFrame();
        } else if ("url".equals(e.getActionCommand())) {
            this.createFrameFromURL();
        } else {
            this.quit();
        }
    }

    protected void quit() {
        System.exit(0);
    }

    protected void createFrame() {
        FileDialog fd = new FileDialog((Frame)this, "Image file");
        fd.show();
        String dir = fd.getDirectory();
        String file = fd.getFile();
        if (file != null) {
            this.createFrameOnDesktop(String.valueOf(dir) + file);
        }
    }

    protected void createFrameOnDesktop(String file) {
        ImageIcon ic = new ImageIcon(file);
        AbstractObject ao = new AbstractObject(ic);
        this.createView(ao);
    }

    protected void createFrameFromURL() {
        boolean off = false;
        do {
            try {
                String url = JOptionPane.showInputDialog("image URL");
                this.createFrameOnDesktopFromURL(new URL(url));
                off = false;
            }
            catch (HeadlessException e) {
                e.printStackTrace();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        } while (off);
    }

    protected void createFrameOnDesktopFromURL(URL url) {
        ImageIcon ic = new ImageIcon(url);
        AbstractObject ao = new AbstractObject(ic);
        this.createView(ao);
    }

    protected void showAOView(AOView frame) {
        frame.setVisible(true);
        this.desktop.add(frame);
        frame.setLocation(this.posX, this.posY);
        this.posX += 20;
        this.posY += 20;
        try {
            frame.setSelected(true);
            frame.toFront();
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 0) {
            initialImageFile = args[0];
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Editor.createAndShowGUI();
            }
        });
        Thread.sleep(1000L);
        if ("demo1".equals(initialImageFile)) {
            Editor.demo1();
        } else if ("demo2".equals(initialImageFile)) {
            Editor.demo2();
        } else if ("demo3".equals(initialImageFile)) {
            Editor.demo3();
        }
    }

    public static Editor createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        editor = new Editor();
        editor.setDefaultCloseOperation(3);
        DragSource.getDefaultDragSource();
        editor.setVisible(true);
        return editor;
    }

    public static void demo3() {
        try {
            ao1 = new AbstractObject(new ImageIcon("images/rose600.jpg"));
            editor.createView(ao1);
            ao2 = new AbstractObject(new ImageIcon("images/red.jpg"));
            editor.createView(ao2);
            ao3 = new AbstractObject(new ImageIcon("images/catmike.jpg"));
            editor.createView(ao3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void demo2() {
        try {
            ao1 = new AbstractObject(new ImageIcon("images/rose600.jpg"));
            editor.createView(ao1);
            ao2 = new AbstractObject(new ImageIcon("images/catblack.jpg"));
            editor.createView(ao2);
            ao3 = new AbstractObject(new ImageIcon(new URL("http://sourceforge.jp/sflogo.php?group_id=1200")));
            editor.createView(ao3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void demo1() {
        try {
            ao1 = new AbstractObject(new ImageIcon("images/rose600.jpg"));
            ao2 = new AbstractObject(new ImageIcon("images/catmike.jpg"));
            ao3 = new AbstractObject(new ImageIcon("images/sakura600.jpg"));
            AOView v1 = editor.createView(ao1);
            Thread.sleep(800L);
            AOView v2 = editor.createView(ao2);
            Thread.sleep(800L);
            editor.createView(ao3);
            Thread.sleep(800L);
            Point p = v2.getLocation();
            v2.setLocation(p.x + 400, p.y);
            v2.toFront();
            b11 = new Binding("image", new SelectionCode(10, 10, 150, 200), ao1);
            b12 = new Binding("image", new SelectionCode(161, 10, 150, 200), ao1);
            b13 = new Binding("image", new SelectionCode(10, 211, 150, 200), ao1);
            b21 = new Binding("image", new SelectionCode(10, 10, 150, 150), ao2);
            b22 = new Binding("image", new SelectionCode(10, 160, 150, 150), ao2);
            b31 = new Binding("image", new SelectionCode(10, 10, 150, 200), ao3);
            b32 = new Binding("image", new SelectionCode(161, 10, 150, 200), ao3);
            b33 = new Binding("image", new SelectionCode(10, 211, 150, 200), ao3);
            ao1.addBinding(b11);
            Thread.sleep(800L);
            ao1.addBinding(b12);
            Thread.sleep(800L);
            ao1.addBinding(b13);
            Thread.sleep(800L);
            ao2.addBinding(b21);
            Thread.sleep(800L);
            ao2.addBinding(b22);
            Thread.sleep(800L);
            ao3.addBinding(b31);
            Thread.sleep(800L);
            ao3.addBinding(b32);
            Thread.sleep(800L);
            ao3.addBinding(b33);
            Thread.sleep(800L);
            ao1.apply(b11, b21);
            Thread.sleep(800L);
            ao1.apply(b22);
            Thread.sleep(800L);
            ao3.apply(ao2);
            Thread.sleep(800L);
            ao1.applySelf(ao2);
            bb21 = new Binding("image", new SelectionCode(155, 211, 150, 200), ao1);
            ao2.addBinding(bb21);
            v1.toFront();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class MyDropListener
    implements DropTargetListener {
        public void dragEnter(DropTargetDragEvent dtde) {
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return;
            }
        }

        public void dragOver(DropTargetDragEvent dtde) {
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        public void drop(DropTargetDropEvent event) {
            if (event.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                try {
                    event.acceptDrop(1);
                    Transferable t = event.getTransferable();
                    List list = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                    Iterator i = list.iterator();
                    while (i.hasNext()) {
                        Editor.this.createFrameOnDesktop(((File)i.next()).getAbsolutePath());
                    }
                    event.dropComplete(true);
                }
                catch (Exception e) {
                    event.dropComplete(false);
                }
            }
        }

        public void dragExit(DropTargetEvent dte) {
        }
    }
}

