/*
 * Decompiled with CFR 0.152.
 */
package mediacollage.swingui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import mediacollage.swingui.AOBindingBox;

public class BoxTransferHandler
extends TransferHandler {
    DataFlavor aobFlavor = new DataFlavor("application/x-java-jvm-local-objectref", "AOB");
    AOBindingBox sourcePic;

    public BoxTransferHandler() {
    }

    public BoxTransferHandler(String property) {
        super(property);
    }

    public boolean importData(JComponent c, Transferable t) {
        if (this.canImport(c, t.getTransferDataFlavors())) {
            AOBindingBox bb = (AOBindingBox)c;
            if (this.sourcePic == bb) {
                return true;
            }
            try {
                AOBindingBox that = (AOBindingBox)t.getTransferData(this.aobFlavor);
                if (bb.isSelf()) {
                    bb.getAbstractObject().applySelf(that.getAbstractObject());
                } else {
                    bb.getAbstractObject().apply(bb.getBinding(), that.getBinding());
                }
                return true;
            }
            catch (UnsupportedFlavorException ufe) {
                System.out.println("unsupported data flavor");
                ufe.printStackTrace();
            }
            catch (IOException ioe) {
                System.out.println("I/O exception");
                ioe.printStackTrace();
            }
        }
        return false;
    }

    protected Transferable createTransferable(JComponent c) {
        this.sourcePic = (AOBindingBox)c;
        return new AbstractObjectTransferable(this.sourcePic);
    }

    public int getSourceActions(JComponent c) {
        return 3;
    }

    protected void exportDone(JComponent c, Transferable data, int action) {
        this.sourcePic = null;
    }

    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        int i = 0;
        while (i < flavors.length) {
            if (this.aobFlavor.equals(flavors[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    class AbstractObjectTransferable
    implements Transferable {
        private AOBindingBox box;

        AbstractObjectTransferable(AOBindingBox bbox) {
            this.box = bbox;
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.box;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{BoxTransferHandler.this.aobFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return BoxTransferHandler.this.aobFlavor.equals(flavor);
        }
    }
}

