/*
 * Decompiled with CFR 0.152.
 */
package mediacollage.swingui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import mediacollage.core.AbstractObject;
import mediacollage.swingui.AOBindingBoxList;

public class BoxListTransferHandler
extends TransferHandler {
    DataFlavor aoblFlavor = new DataFlavor("application/x-java-jvm-local-objectref", "AOBL");
    AOBindingBoxList sourcePic;

    public BoxListTransferHandler() {
    }

    public BoxListTransferHandler(String property) {
        super(property);
    }

    public boolean importData(JComponent c, Transferable t) {
        AbstractObject ao = null;
        if (this.canImport(c, t.getTransferDataFlavors())) {
            AOBindingBoxList bbl = (AOBindingBoxList)c;
            ao = bbl.getAbstractObject();
            if (this.sourcePic == bbl) {
                return true;
            }
            try {
                AOBindingBoxList that = (AOBindingBoxList)t.getTransferData(this.aoblFlavor);
                ao.apply(that.getAbstractObject());
                return true;
            }
            catch (UnsupportedFlavorException ufe) {
                System.out.println("unsupported data flavor");
            }
            catch (IOException ioe) {
                System.out.println("I/O exception");
            }
        }
        return false;
    }

    protected Transferable createTransferable(JComponent c) {
        this.sourcePic = (AOBindingBoxList)c;
        return new AbstractObjectListTransferable(this.sourcePic);
    }

    public int getSourceActions(JComponent c) {
        return 3;
    }

    protected void exportDone(JComponent c, Transferable data, int action) {
        this.sourcePic = null;
    }

    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        int i = 0;
        while (i < flavors.length) {
            if (this.aoblFlavor.equals(flavors[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    class AbstractObjectListTransferable
    implements Transferable {
        private AOBindingBoxList bbl;

        AbstractObjectListTransferable(AOBindingBoxList bbl) {
            this.bbl = bbl;
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.bbl;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{BoxListTransferHandler.this.aoblFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return BoxListTransferHandler.this.aoblFlavor.equals(flavor);
        }
    }
}

