/*
 * Decompiled with CFR 0.152.
 */
package mediacollage.swingui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Random;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.TransferHandler;
import mediacollage.core.AbstractObject;
import mediacollage.core.Binding;
import mediacollage.core.BindingList;
import mediacollage.core.BindingSelf;
import mediacollage.core.Tools;
import mediacollage.swingui.AOBindingBox;
import mediacollage.swingui.AOView;
import mediacollage.swingui.BoxListTransferHandler;

public class AOBindingBoxList
extends JPanel
implements MouseMotionListener,
MouseListener,
Observer {
    AOView aov;
    BindingList blist;
    private static Random cnum = new Random();
    private MouseEvent firstMouseEvent = null;
    private static boolean installInputMapBindings = true;

    private static Color makeRandomColor() {
        return new Color(cnum.nextInt(256), cnum.nextInt(256), cnum.nextInt(256));
    }

    public AOBindingBoxList(AbstractObject ao, AOView v) {
        super(new FlowLayout(0));
        this.aov = v;
        this.blist = ao.getBindingList();
        this.blist.addObserver(this);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.setTransferHandler(new BoxListTransferHandler());
    }

    public void addBindingList(BindingList blist) {
        Iterator it = blist.iterator();
        while (it.hasNext()) {
            Binding b = (Binding)it.next();
            if (!this.isNewBinding(b)) continue;
            this.addBinding(b);
        }
    }

    public void remove(AOBindingBox bb) {
        Binding b = bb.getBinding();
        super.remove(bb);
        this.blist.remove(b);
    }

    public void removeBinding(Binding b) {
        AOBindingBox bb = this.findBindingBox(b);
        if (bb != null) {
            super.remove(bb);
        }
    }

    public AOBindingBox findBindingBox(Binding b) {
        int cnt = this.getComponentCount();
        Component[] c = this.getComponents();
        int i = 0;
        while (i < cnt) {
            AOBindingBox bb = (AOBindingBox)c[i];
            if (b.equals(bb.getBinding())) {
                return bb;
            }
            ++i;
        }
        return null;
    }

    public BindingList getBindingList() {
        return this.blist;
    }

    public AbstractObject getAbstractObject() {
        return this.aov.getAbstractObject();
    }

    private boolean isNewBinding(Binding b) {
        int i = 0;
        while (i < this.getComponentCount()) {
            if (((AOBindingBox)this.getComponent(i)).getBinding().equals(b)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void addBinding(Binding ab) {
        ImageIcon ic = new ImageIcon(AOBindingBox.BINDIMAGE);
        Color c = AOBindingBoxList.makeRandomColor();
        this.putBindingColor(ic, c);
        AOBindingBox b1 = new AOBindingBox(ic, ab, this.aov, this.aov.getEditor(), c);
        Rectangle area = ab.getSelectionCode().getArea();
        if (ab.isSelf()) {
            b1.setImage(this.aov.getObjectIcon().getImage());
            ic.setImage(this.aov.getObjectIcon().getImage().getScaledInstance(ic.getIconWidth(), ic.getIconHeight(), 1));
        } else {
            Image bindImage = this.aov.shadeoutSelection(area, c);
            ic.setImage(bindImage.getScaledInstance(ic.getIconWidth(), ic.getIconHeight(), 1));
            b1.setImage(bindImage);
        }
        this.add(b1);
    }

    private void putBindingColor(ImageIcon icon, Color cc) {
        int imageWidth = icon.getIconWidth();
        int imageHeight = icon.getIconHeight();
        int[] pix = new int[imageWidth * imageHeight];
        int c = cc.getRGB();
        int i = 0;
        while (i < imageWidth * imageHeight) {
            pix[i] = c;
            ++i;
        }
        icon.setImage(Tools.createImageFromPixels(pix, imageWidth, imageHeight));
    }

    public void resetBindingList(AOBindingBox b) {
        int cnt = this.getComponentCount();
        Component[] cs = this.getComponents();
        int i = 0;
        while (i < cnt) {
            AOBindingBox c = (AOBindingBox)cs[i];
            if (!c.equals(b)) {
                this.blist.remove(c.getBinding());
                this.remove(c);
            }
            ++i;
        }
        this.revalidate();
    }

    public void resetBindingList() {
        int cnt = this.getComponentCount();
        Component[] cs = this.getComponents();
        int i = 0;
        while (i < cnt) {
            AOBindingBox c = (AOBindingBox)cs[i];
            if (c.getBinding().isSelf()) {
                c.setImage(c.getBinding().getSubObject().getImageIcon().getImage());
            } else {
                this.blist.remove(c.getBinding());
                this.remove(c);
            }
            ++i;
        }
        this.revalidate();
    }

    public void mousePressed(MouseEvent event) {
        this.firstMouseEvent = event;
        event.consume();
    }

    public void mouseDragged(MouseEvent e) {
        if (this.firstMouseEvent != null) {
            e.consume();
            int action = 1;
            int dx = Math.abs(e.getX() - this.firstMouseEvent.getX());
            int dy = Math.abs(e.getY() - this.firstMouseEvent.getY());
            if (dx > 5 || dy > 5) {
                JComponent c = (JComponent)e.getSource();
                TransferHandler handler = c.getTransferHandler();
                handler.exportAsDrag(c, this.firstMouseEvent, action);
                this.firstMouseEvent = null;
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.firstMouseEvent = null;
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public static void setInstallInputMapBindings(boolean flag) {
        installInputMapBindings = flag;
    }

    public static boolean getInstallInputMapBindingds() {
        return installInputMapBindings;
    }

    public void update(Observable o, Object arg) {
        if (arg instanceof BindingSelf) {
            BindingSelf bs = (BindingSelf)arg;
            this.getSelfBox().setImage(bs.getSubObject().getImageIcon().getImage());
        } else if (arg instanceof Binding) {
            Binding b = (Binding)arg;
            if (this.blist.contains(b)) {
                this.addBinding(b);
            } else {
                this.removeBinding(b);
            }
        }
        this.repaint();
    }

    public AOBindingBox getSelfBox() {
        int cnt = this.getComponentCount();
        Component[] c = this.getComponents();
        int i = 0;
        while (i < cnt) {
            AOBindingBox bb = (AOBindingBox)c[i];
            if (bb.getBinding().isSelf()) {
                return bb;
            }
            ++i;
        }
        return null;
    }
}

