/*
 * Decompiled with CFR 0.152.
 */
package mediacollage.swingui;

import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.TransferHandler;
import mediacollage.core.AbstractObject;
import mediacollage.core.Binding;
import mediacollage.core.Tools;
import mediacollage.swingui.AOView;
import mediacollage.swingui.BoxTransferHandler;
import mediacollage.swingui.Editor;

public class AOBindingBox
extends JLabel
implements MouseMotionListener,
MouseListener {
    protected static final Image BINDIMAGE = Tools.makeColorImage(30, 30, Color.black);
    protected static final ImageIcon BINDIMAGEICON = new ImageIcon(BINDIMAGE);
    private static boolean installInputMapBindings = true;
    private MouseEvent firstMouseEvent = null;
    private Binding binding;
    private AOView aov;
    private Editor editor;
    private Image image;
    private Color boundaryColor;
    private ImageIcon colorIcon;
    JPopupMenu popup;

    public AOBindingBox(ImageIcon icon, Binding b, AOView v, Editor e, Color c) {
        super(icon);
        ImageIcon imc = icon;
        this.boundaryColor = c;
        Image colorIm = Tools.makeColorImage(imc.getIconWidth(), imc.getIconHeight(), c);
        this.colorIcon = (ImageIcon)this.getIcon();
        this.colorIcon.setImage(colorIm);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.binding = b;
        this.aov = v;
        this.editor = e;
        this.setTransferHandler(new BoxTransferHandler());
        this.createPopupMenu();
    }

    public Binding getBinding() {
        return this.binding;
    }

    public void setImage(Image im) {
        this.image = im;
        Image nim = this.binding.isSelf() ? im : Tools.makeColoredIcon(im, this.boundaryColor);
        this.setIcon(new ImageIcon(nim.getScaledInstance(BINDIMAGEICON.getIconWidth(), BINDIMAGEICON.getIconHeight(), 1)));
        this.repaint();
    }

    public Image getImage() {
        if (this.binding.isSelf()) {
            return this.aov.getAbstractObject().getConcreteObject().getImageIcon().getImage();
        }
        return this.image;
    }

    public boolean isSelf() {
        return this.binding.isSelf();
    }

    public AOView getAOView() {
        return this.aov;
    }

    public AbstractObject getAbstractObject() {
        return this.aov.getAbstractObject();
    }

    public Color getBoundaryColor() {
        return this.boundaryColor;
    }

    public void mousePressed(MouseEvent event) {
        if ((event.getModifiers() & 4) != 0) {
            this.popup.show(this, event.getX(), event.getY());
            this.aov.pack();
        }
        this.firstMouseEvent = event;
        event.consume();
    }

    public void mouseDragged(MouseEvent e) {
        if (this.firstMouseEvent != null) {
            e.consume();
            int action = 1;
            int dx = Math.abs(e.getX() - this.firstMouseEvent.getX());
            int dy = Math.abs(e.getY() - this.firstMouseEvent.getY());
            if (dx > 5 || dy > 5) {
                JComponent c = (JComponent)e.getSource();
                TransferHandler handler = c.getTransferHandler();
                handler.exportAsDrag(c, this.firstMouseEvent, action);
                this.firstMouseEvent = null;
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.firstMouseEvent = null;
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public static void setInstallInputMapBindings(boolean flag) {
        installInputMapBindings = flag;
    }

    public static boolean getInstallInputMapBindingds() {
        return installInputMapBindings;
    }

    public void createPopupMenu() {
        this.popup = new JPopupMenu("image op");
        this.addPopupMenuItem("Load", "load", new LoadListener());
        this.addPopupMenuItem("Save", "save", new SaveListener());
    }

    private void addPopupMenuItem(String label, String command, ActionListener pml) {
        JMenuItem menuItem = new JMenuItem(label);
        menuItem.setActionCommand(command);
        menuItem.addActionListener(pml);
        this.popup.add(menuItem);
    }

    class LoadListener
    implements ActionListener {
        LoadListener() {
        }

        public void actionPerformed(ActionEvent ev) {
            FileDialog fd = new FileDialog((Frame)AOBindingBox.this.editor, "Which Image?");
            fd.show();
            String file = fd.getFile();
            if (file == null) {
                return;
            }
            String dir = fd.getDirectory();
            if (AOBindingBox.this.binding.isSelf()) {
                AOBindingBox.this.aov.getAbstractObject().applySelf(new AbstractObject(new ImageIcon(String.valueOf(dir) + file)));
            } else {
                AOBindingBox.this.aov.getAbstractObject().apply(AOBindingBox.this.getBinding(), new ImageIcon(String.valueOf(dir) + file));
            }
            AOBindingBox.this.aov.pack();
        }
    }

    class SaveListener
    implements ActionListener {
        SaveListener() {
        }

        public void actionPerformed(ActionEvent ev) {
            FileDialog fd = new FileDialog((Frame)AOBindingBox.this.editor, "save to", 1);
            fd.show();
            String file = fd.getFile();
            if (file == null) {
                return;
            }
            String dir = fd.getDirectory();
            try {
                Tools.saveIcon(AOBindingBox.this.binding.getSubObject().getImageIcon(), new File(String.valueOf(dir) + file));
            }
            catch (Exception e) {
                return;
            }
        }
    }
}

