/*
 * Decompiled with CFR 0.152.
 */
package mediacollage.core;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.swing.ImageIcon;

public class Tools {
    public static int[] getPixels(Image im, int x, int y, int w, int h) {
        int[] imagePixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(im, x, y, w, h, imagePixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return imagePixels;
    }

    public static ImageIcon setPixels(ImageIcon icon, int[] newPixels, int posx, int posy, int width, int height) {
        Image image = icon.getImage();
        int imageWidth = icon.getIconWidth();
        int imageHeight = icon.getIconHeight();
        int[] oldPixels = Tools.getPixels(image, 0, 0, imageWidth, imageHeight);
        int y = 0;
        while (y < height) {
            if (imageHeight <= posy + y) break;
            int x = 0;
            while (x < width) {
                if (imageWidth <= posx + x) break;
                oldPixels[(posy + y) * imageWidth + posx + x] = newPixels[width * y + x];
                ++x;
            }
            ++y;
        }
        icon.setImage(Tools.createImageFromPixels(oldPixels, imageWidth, imageHeight));
        return icon;
    }

    public static ImageIcon copyImageIcon(ImageIcon iic) {
        int[] pix = Tools.getPixels(iic.getImage(), 0, 0, iic.getIconWidth(), iic.getIconHeight());
        Image im = Tools.createImageFromPixels(pix, iic.getIconWidth(), iic.getIconHeight());
        return new ImageIcon(im);
    }

    public static Image createImageFromPixels(int[] pixels, int width, int height) {
        MemoryImageSource mis = new MemoryImageSource(width, height, pixels, 0, width);
        return new Container().createImage(mis);
    }

    public static ImageIcon selectImageIcon(ImageIcon im, int x, int y, int w, int h) {
        int[] pixels = Tools.getPixels(im.getImage(), x, y, w, h);
        return new ImageIcon(Tools.createImageFromPixels(pixels, w, h));
    }

    public static Image makeColorImage(int width, int height, Color cc) {
        int[] imagePixels = new int[width * height];
        int c = cc.getRGB();
        int i = 0;
        while (i < width * height) {
            imagePixels[i] = c;
            ++i;
        }
        MemoryImageSource mis = new MemoryImageSource(width, height, imagePixels, 0, width);
        return new Container().createImage(mis);
    }

    public static Image makeColoredIcon(Image im, Color cc) {
        ImageIcon imc = new ImageIcon(im);
        int imageWidth = imc.getIconWidth();
        int imageHeight = imc.getIconHeight();
        int c = cc.getRGB();
        int[] imagePixels = Tools.getPixels(im, 0, 0, imageWidth, imageHeight);
        int y = 0;
        while (y < imageHeight) {
            int x = 0;
            while (x < imageWidth) {
                if (x <= 2 || imageWidth - 3 <= x || y <= 2 || imageHeight - 3 <= y) {
                    imagePixels[y * imageWidth + x] = c;
                }
                ++x;
            }
            ++y;
        }
        return Tools.createImageFromPixels(imagePixels, imageWidth, imageHeight);
    }

    public static Color averageColor(ImageIcon ic) {
        int w = ic.getIconWidth();
        int h = ic.getIconHeight();
        int[] pixcels = Tools.getPixels(ic.getImage(), 0, 0, w, h);
        long ac = 0L;
        int i = 0;
        while (i < w * h) {
            ac += (long)pixcels[i];
            ++i;
        }
        return new Color((int)ac / (w * h));
    }

    public static void saveIcon(ImageIcon ico, File out) throws Exception {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("JPG");
        if (iter.hasNext()) {
            BufferedImage ai = new BufferedImage(ico.getIconWidth(), ico.getIconHeight(), 1);
            Graphics aig = ai.getGraphics();
            aig.drawImage(ico.getImage(), 0, 0, null);
            FileOutputStream fout = new FileOutputStream(out);
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)fout);
            encoder.encode(ai);
            fout.close();
        }
    }
}

