/*
 * Decompiled with CFR 0.152.
 */
package mediacollage.core;

import java.awt.Image;
import javax.swing.ImageIcon;
import mediacollage.core.SelectionCode;
import mediacollage.core.SubObject;
import mediacollage.core.SubObjectColor;
import mediacollage.core.SubObjectImage;
import mediacollage.core.Tools;

public class ConcreteObject {
    private Object object;
    private static String[] selectorList = new String[]{SubObjectImage.getCode(), SubObjectColor.getCode()};

    public ConcreteObject(Object o) {
        this.object = o;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object obj) {
        this.object = obj;
    }

    public ImageIcon getImageIcon() {
        return (ImageIcon)this.object;
    }

    public SelectionCode getSelfSelectionCode() {
        return new SelectionCode(this);
    }

    public String[] getSelectorList() {
        return selectorList;
    }

    public String toString() {
        return "[" + this.object.getClass().getName() + ":" + this.object.toString() + "]";
    }

    public void replaceSelfWith(ConcreteObject o) {
        this.pasteImageOnSelf(o.getImageIcon());
    }

    protected void pasteImageOnSelf(ImageIcon icon) {
        this.object = Tools.copyImageIcon(icon);
    }

    public SubObject selectSubObject(String method, SelectionCode s) {
        if (SubObjectImage.getCode().equals(method)) {
            return new SubObjectImage(s.selectImageIcon((ImageIcon)this.object));
        }
        if (SubObjectColor.getCode().equals(method)) {
            return new SubObjectColor(s.selectImageIcon((ImageIcon)this.object));
        }
        return new SubObjectImage(s.selectImageIcon((ImageIcon)this.object));
    }

    protected void setPixels(int[] newPixels, int posx, int posy, int width, int height) {
        Tools.setPixels(this.getImageIcon(), newPixels, posx, posy, width, height);
    }

    public void replaceWith(SelectionCode code, SubObject sub) {
        Image im = sub.getImageIcon().getImage();
        int width = code.getWidth();
        int height = code.getHeight();
        Image sizedIm = im.getScaledInstance(width, height, 1);
        int[] pixels = Tools.getPixels(sizedIm, 0, 0, width, height);
        this.setPixels(pixels, code.getX(), code.getY(), width, height);
    }

    public void pasteImage(SelectionCode code, ImageIcon icon) {
        Image im = icon.getImage();
        Image sizedIm = im.getScaledInstance(code.getWidth(), code.getHeight(), 1);
        int[] pixels = Tools.getPixels(sizedIm, 0, 0, code.getWidth(), code.getHeight());
        this.setPixels(pixels, code.getX(), code.getY(), code.getWidth(), code.getHeight());
    }
}

