/*
 * Decompiled with CFR 0.152.
 */
package mediacollage.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;
import javax.swing.ImageIcon;
import mediacollage.core.Binding;
import mediacollage.core.BindingSelf;
import mediacollage.core.ConcreteObject;

public class BindingList
extends Observable {
    ArrayList blist = new ArrayList();

    public BindingList(ConcreteObject cobj) {
        this.add(BindingSelf.makeSelf(cobj));
    }

    public BindingSelf getSelf() {
        Iterator it = this.blist.iterator();
        while (it.hasNext()) {
            Binding b = (Binding)it.next();
            if (!b.isSelf()) continue;
            return (BindingSelf)b;
        }
        return null;
    }

    public void replaceSelf(ConcreteObject o) {
        ImageIcon ii = o.getImageIcon();
        BindingSelf s = this.getSelf();
        s.replaceSelf(ii);
        this.setChanged();
        this.notifyObservers(s);
    }

    public void remove(Binding b) {
        this.blist.remove(b);
        this.setChanged();
        this.notifyObservers(b);
    }

    public void add(Binding b) {
        this.blist.add(b);
        this.setChanged();
        this.notifyObservers(b);
    }

    public boolean contains(Binding b) {
        return this.blist.contains(b);
    }

    public Binding findFirstBinding() {
        Iterator it = this.blist.iterator();
        while (it.hasNext()) {
            Binding b = (Binding)it.next();
            if (b.isSelf()) continue;
            return b;
        }
        return null;
    }

    public Iterator iterator() {
        return this.blist.iterator();
    }

    public String toString() {
        String exp = "";
        Iterator it = this.blist.iterator();
        while (it.hasNext()) {
            Binding b = (Binding)it.next();
            exp = String.valueOf(exp) + b.toString();
            if (!it.hasNext()) continue;
            exp = String.valueOf(exp) + ",";
        }
        return "(" + exp + ")";
    }
}

