/*
 * Decompiled with CFR 0.152.
 */
package mediacollage.core;

import java.util.Iterator;
import java.util.Observable;
import javax.swing.ImageIcon;
import mediacollage.core.Binding;
import mediacollage.core.BindingList;
import mediacollage.core.BindingSelf;
import mediacollage.core.ConcreteObject;
import mediacollage.core.SubObject;

public class AbstractObject
extends Observable {
    private BindingList head;
    private ConcreteObject body;

    public AbstractObject(Object obj) {
        this.body = new ConcreteObject(obj);
        this.head = new BindingList(this.body);
    }

    public ConcreteObject getConcreteObject() {
        return this.body;
    }

    public BindingList getBindingList() {
        return this.head;
    }

    public BindingSelf getSelf() {
        return this.head.getSelf();
    }

    public String[] getSelectorList() {
        return this.body.getSelectorList();
    }

    public String toString() {
        return "ao:" + this.head.toString() + this.body.toString();
    }

    public void addBinding(Binding b) {
        this.head.add(b);
        this.setChanged();
        this.notifyObservers(b);
    }

    public void apply(Binding b) {
        Binding thisb = this.head.findFirstBinding();
        if (thisb != null) {
            this.apply(this.head.findFirstBinding(), b);
        }
    }

    public void apply(Binding thisb, ImageIcon ic) {
        this.body.pasteImage(thisb.getSelectionCode(), ic);
        this.head.remove(thisb);
        this.setChanged();
        this.notifyObservers(this);
    }

    public void apply(Binding thisb, Binding thatb) {
        SubObject sub = thatb.getSubObject();
        this.body.replaceWith(thisb.getSelectionCode(), sub);
        this.head.remove(thisb);
        this.setChanged();
        this.notifyObservers(this);
    }

    private void apply(BindingList thatb) {
        Iterator it = thatb.iterator();
        while (it.hasNext()) {
            Binding b = (Binding)it.next();
            if (b.isSelf()) continue;
            this.apply(b);
        }
    }

    public void apply(AbstractObject that) {
        BindingList thatb = that.getBindingList();
        this.apply(thatb);
    }

    public void applySelf(AbstractObject that) {
        this.body.replaceSelfWith(that.getConcreteObject());
        this.head.replaceSelf(that.getConcreteObject());
        this.setChanged();
        this.notifyObservers(that.getSelf());
    }
}

