<?php
/**
 * LDAP饤֥
 *
 */

/* ޥ */
/**  LDAP */
define ("LDAP_OK",		 0);
/** եIO顼 */
define ("LDAP_ERR_FILE",	-1);
/** LDAPХɥ顼 */
define ("LDAP_ERR_BIND",	-2);
/** LDAP顼 */
define ("LDAP_ERR_SEARCH",	-3);
/** LDAPϿ顼 */
define ("LDAP_ERR_ADD",		-4);
/** LDAPѹ顼 */
define ("LDAP_ERR_MOD",		-5);
/** ʰϤ줿 */
define ("LDAP_ERR_PARAM",	-6);
/** ʥǡ¸ߤ */
define ("LDAP_ERR_DATA",	-7);
/** 륨ȥ꤬¸ߤʤ */
define ("LDAP_ERR_NODATA",	-8);
/** ʣΥȥ꤬¸ */
define ("LDAP_ERR_DUPLICATE",	-9);
/** LDAP顼 */
define ("LDAP_ERR_DEL",		-10);
/** LDAP°ͤʤ顼 */
define ("LDAP_ERR_NOATTR",	-11);
/** ¾Υ顼 */
define ("LDAP_ERR_OTHER",	-127);

/* μ */
/** LDAPμ ١DNľγؤΤ߸ */
define("TYPE_ONELEVEL",		0);
/** LDAPμ ١DN򸡺 */
define("TYPE_ONEENTRY",		1);
/** LDAPμ ١DN۲򤹤٤Ƥ򸡺 */
define("TYPE_SUBTREE",		2);

/* μ */
/** LDAPȥϿ */
define("TYPE_ADD",		0);
/** LDAPȥѹ */
define("TYPE_MODIFY",		1);
/** LDAPȥ */
define("TYPE_DELETE",		2);
/** LDAP°ɲý */
define("TYPE_ADD_ATTRIBUTE",	3);
/** LDAP°ִ */
define("TYPE_REPLACE_ATTRIBUTE",	4);
/** LDAP° */
define("TYPE_MODIFY_DELETE",	5);

/* LDAP֤ */
/** LDAPΥ */
define ("LDAP_SUCCESS",		0);
/** ꤷDNΥȥ꤬Ĥʤ */
define ("LDAP_NO_SUCH_OBJECT",	32);
/** ꤷDNΥȥ꤬ˤ */
define ("LDAP_ALREADY_EXISTS",	68);
/** ꤷ°ͤĤʤ */
define ("LDAP_DECODING_ERROR",	84);
/** ꤷ°ͤ¸ߤʤ */
define ("LDAP_NO_SUCH_VALUE",	16);
/** ꤷ°ͤ¸ߤʤ */
define ("LDAP_NO_SUCH_ATTR",	17);
/** ꤷ°ͤ¸ߤƤ */
define ("LDAP_EXISTS_VALUE",	20);
/** binddn,bindpwְäƤ */
define ("LDAP_INVALID_CREDENTIALS",	49);
/** LDAPӥ */
define ("LDAP_SERVER_DOWN",	81);

/* LDAPѥ󥳡 */
/** ץ¦Υ󥳡 */
define("PG_ENCODING",		"EUC-JP");
/** LDAPѥ󥳡 */
define("LDAP_ENCODING",		"UTF-8");

/** LDAPС */
define("LDAP_VERSION",		3);

/* $dg_err_msgѥޥ */
/** LDAPФ³Ǥʤ */
define("ERRMSG_CONNECT",	"LDAPФ³ǤޤǤ");
/** LDAPФΥХɤ˼ */
define("ERRMSG_BIND",		"LDAPФΥХɤ˼Ԥޤ");
/** LDAPΥС꼺 */
define("ERRMSG_VERSION",	"LDAPΥС˼Ԥޤ");
/** Ϳ줿١DNͤ */
define("ERRMSG_BASEDN",		"١DNͤǤ");
/** Ϳ줿ե륿ͤ */
define("ERRMSG_FILTER",		"ե륿ͤǤ");
/** Ϳ줿°η */
define("ERRMSG_ARG_ATTR",	"°ηǤ");
/** ȥμ˼ */
define("ERRMSG_ENTRY",		"LDAPȥμ˼Ԥޤ");
/** °μ˼ */
define("ERRMSG_ATTR",		"LDAP°μ˼Ԥޤ");
/** ȥ꤬¸ߤƤ */
define("ERRMSG_EXIST",		"ꤵ줿ȥϤǤ¸ߤƤޤ");
/** ȥ꤬Ĥʤ */
define("ERRMSG_NOTFOUND",	"ꤵ줿ȥϸĤޤǤ");
/** °κ˼ */
define("ERRMSG_DELATTR",	"LDAP°κ˼Ԥޤ");
/** ˼ */
define("ERRMSG_SEARCH",		"LDAPǥ顼ȯޤ");
/** DNμ˼ */
define("ERRMSG_GETDN",		"DNμ˼Ԥޤ");
/** ꤵ줿°ͤ¸ */
define("ERRMSG_EXISTS_VALUE",	"ꤵ줿°ͤϤǤ¸ߤƤޤ");

/* $dg_log_msgѥޥ */
/** LDAPФ³Ǥʤ */
define("LOGMSG_CONNECT",	"Cannot connect LDAP server.");
/** LDAPФΥХɤ˼ */
define("LOGMSG_BIND",		"Cannot bind LDAP server.");
/** LDAPΥС꼺 */
define("LOGMSG_VERSION",	"Cannot set LDAP version.");
/** Ϳ줿١DNͤ */
define("LOGMSG_BASEDN",		"Invalid BaseDN.");
/** Ϳ줿ե륿ͤ */
define("LOGMSG_FILTER",		"Invalid filter.");
/** Ϳ줿°η */
define("LOGMSG_ARG_ATTR",	"Invalid attribute form.");
/** ȥμ˼ */
define("LOGMSG_ENTRY",		"Cannot get LDAP entry. ");
/** °μ˼ */
define("LOGMSG_ATTR",		"Cannot get attribute.");
/** ȥ꤬¸ߤƤ */
define("LOGMSG_EXIST",		"LDAP entry already exists.");
/** ȥ꤬Ĥʤ */
define("LOGMSG_NOTFOUND",	"Cannot find LDAP entry.");
/** °κ˼ */
define("LOGMSG_DELATTR",	"Cannot delete LDAP attribute.");
/** ˼ */
define("LOGMSG_SEARCH",		"Cannot search LDAP entry.");
/** DNμ˼ */
define("LOGMSG_GETDN",		"Cannot get LDAP DN.");
/** ꤵ줿°ͤ¸ */
define("LOGMSG_EXISTS_VALUE",	"Attribute already exists.");

/**
 * 
 * Хǻꤵ줿LDAPФФƥͥȡХɤԤ  
 *
 * ؿƤӽФ¦$dg_ldapinfoȤ̾ǰʲηϢ뤳ȤˤLDAPФؤ³ǽǤ<br><br>
 * $dg_ldapinfo["ldapserver"] : LDAPФIPɥ쥹<br>
 * $dg_ldapinfo["ldapport"] : LDAPФΥݡֹ<br>
 * $dg_ldapinfo["ldapbinddn"] : LDAPФΥХDN<br>
 * $dg_ldapinfo["ldapbindpw"] : LDAPФΥХɥѥ<br>
 * $dg_ldapinfo["ldapuserself"] : ʬȤؤΥХ(ͭ: TRUE ̵: FALSE)<br>
 * $dg_ldapinfo["ldapuserselfdn"] : ʬȤإХɤΥХDN<br>
 * $dg_ldapinfo["ldapuserselfpw"] : ʬȤإХɤΥХɥѥ<br>
 * $dg_ldapinfo["ldapro"] : read-onlyФؤΥХ(ͭ: TRUE ̵: FALSE)<br>
 * $dg_ldapinfo["ldapserverro"] : read-onlyФIPɥ쥹<br>
 * $dg_ldapinfo["ldapportro"] : read-onlyФΥݡֹ<br>
 *
 * @return mixed LDAPID֤ޤ顼ξLDAP_ERR_BIND֤ޤ
 *
 */
function DgLDAP_connect_server()
{
    global $dg_err_msg;
    global $dg_log_msg;
    global $dg_ldapinfo;

    /* ɹѤξ */
    if ($dg_ldapinfo["ldapro"] === TRUE) {
        $lservers = explode(",", $dg_ldapinfo["ldapserverro"]);
        $lports = explode(",", $dg_ldapinfo["ldapportro"]);
        $max = count($lservers);
    } else {
        $lservers = explode(",", $dg_ldapinfo["ldapserver"]);
        $lports = explode(",", $dg_ldapinfo["ldapport"]);
        $max = count($lservers);
    }

    /* 桼ȤǥХɤ */
    if (isset($dg_ldapinfo["ldapuserself"]) &&
        $dg_ldapinfo["ldapuserself"] === TRUE) {
        $ldapbinddn = $dg_ldapinfo["ldapuserselfdn"];
        $ldapbindpw = $dg_ldapinfo["ldapuserselfpw"];
    } else {
        $ldapbinddn = $dg_ldapinfo["ldapbinddn"];
        $ldapbindpw = $dg_ldapinfo["ldapbindpw"];
    }

    $ldap_err = "";
    $ldap_log = "";
    for ($i = 0; $i < $max; $i++) {

        $lserver = trim($lservers[$i]);
        if ($lserver == "") {
            continue;
        }

        $lport = trim($lports[$i]);
        if ($lport == "") {
            $lport = 389;
        }

        /* LDAPФ³ */
        $ds = @ldap_connect($lserver, $lport);
        if ($ds === FALSE) {
            $ldap_err .= ERRMSG_CONNECT . "($lserver:$lport)<BR>";
            $ldap_log .= LOGMSG_CONNECT . "($lserver:$lport) ";
            continue;
        }

        /* LDAPΥС3 */
        if (!ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, LDAP_VERSION)) {
            $ldap_err .= ERRMSG_VERSION . "($lserver:$lport)<BR>";
            $ldap_log .= LOGMSG_VERSION . "($lserver:$lport) ";
            ldap_unbind($ds);
            continue;
        }

        /* LDAPǥ쥯ȥ˥Хɤ */
        $r = @ldap_bind($ds, $ldapbinddn, $ldapbindpw);
        if ($r === FALSE) {
            $errno = ldap_errno($ds);
            if ($errno == LDAP_SUCCESS) {
                $ldap_err .= ERRMSG_BIND . "($lserver:$lport)<BR>";
                $ldap_log .= LOGMSG_BIND . "($lserver:$lport) ";
            } else {
                $error = ldap_error($ds);
                $ldap_err .= ERRMSG_BIND . "($error $lserver:$lport)<BR>";
                $ldap_log .= LOGMSG_BIND . "($error $lserver:$lport) ";
            }
            ldap_unbind($ds);
            continue;
        }

        /* ³Ǥ 顼ȯƤ */
        if ($ldap_err != "") {
            $dg_err_msg = preg_replace("/<br>$/i", "", $ldap_err);
            $dg_log_msg = preg_replace("/<br>$/i", "", $ldap_log);
        }
        return $ds;
    }

    $dg_err_msg = $ldap_err . "ꤵ줿LDAPФ³Ǥޤ" .
                  "Ǥ";
    $dg_log_msg = $ldap_log . "Cannot connect all LDAP server.";
    return (LDAP_ERR_BIND);
}

/**
 * 
 * ꤵ줿פηȤ򤷤̡륨ȥɬ׾Ϣ(&$data)˳Ǽ롣
 *
 * ؿƤӽФ¦$dg_ldapinfoȤ̾ǰʲηϢ뤳ȤˤLDAPФؤ³ǽǤ<br><br>
 * $dg_ldapinfo["ldapserver"] : LDAPФIPɥ쥹<br>
 * $dg_ldapinfo["ldapport"] : LDAPФΥݡֹ<br>
 * $dg_ldapinfo["ldapbinddn"] : LDAPФΥХDN<br>
 * $dg_ldapinfo["ldapbindpw"] : LDAPФΥХɥѥ<br>
 * $dg_ldapinfo["ldapuserself"] : ʬȤؤΥХ(ͭ: TRUE ̵: FALSE)<br>
 * $dg_ldapinfo["ldapuserselfdn"] : ʬȤإХɤΥХDN<br>
 * $dg_ldapinfo["ldapuserselfpw"] : ʬȤإХɤΥХɥѥ<br>
 * $dg_ldapinfo["ldapro"] : read-onlyФؤΥХ(ͭ: TRUE ̵: FALSE)<br>
 * $dg_ldapinfo["ldapserverro"] : read-onlyФIPɥ쥹<br>
 * $dg_ldapinfo["ldapportro"] : read-onlyФΥݡֹ<br>
 *
 * $attrsηˤϼ°̾ꤷޤ<br>
 * () $attrs = array("mail", "uid", "mailDirectory");
 *
 * $typeǻꤹ륵פμϰʲˤʤޤ<br>
 * TYPE_ONELEVEL : ñ쳬ؤθ<br>
 * TYPE_ONEENTRY : 1ȥθ<br>
 * TYPE_SUBTREE : LDAPĥ꡼򸡺
 * 
 * $dataˤϰʲηǸ̤Ǽޤ<br>
 * $data[0][°̾][0] = °<br>
 * $data[0][°̾][1] = °  °2ͤä<br>
 * $data[1][°̾][0] = °  Υȥ
 *
 * @param string $basedn ١DN
 * @param string $filter ե륿 
 * @param array  $attrs  ɬפǤΥơ֥ 
 * @param string $type   פη
 * @param array  &$data  Ϥ줿ɬפǥǡγǼ
 *
 * @return integer ˽λLDAP_OKХɤ˼ԤLDAP_ERR_BIND˼ԤLDAP_ERR_SEARCHʰϤ줿LDAP_ERR_PARAMȥ꤬¸ߤʤLDAP_ERR_NODATA¾Υ顼ξLDAP_ERR_OTHER֤ޤ
 *
 */
function DgLDAP_get_entry($basedn, $filter, $attrs, $type, &$data)
{
    /* Х */
    $ds = DgLDAP_connect_server();
    if ($ds == LDAP_ERR_BIND) {
        return (LDAP_ERR_BIND);
    }

    $ret = DgLDAP_get_entry_batch($basedn, $ds, $filter, $attrs, $type, $data);

    /* Х */
    ldap_unbind($ds);

    return $ret;
}

/**
 * 
 * ꤵ줿פηȤ򤷤̡륨ȥɬ׾Ϣ(&$data)˳Ǽ롣(ؿLDAPФ³ʤ)
 *
 * $attrsηˤϼ°̾ꤷޤ<br>
 * () $attrs = array("mail", "uid", "mailDirectory");
 *
 * $typeǻꤹ륵פμϰʲˤʤޤ<br>
 * TYPE_ONELEVEL : ñ쳬ؤθ<br>
 * TYPE_ONEENTRY : 1ȥθ<br>
 * TYPE_SUBTREE : LDAPĥ꡼򸡺
 * 
 * $dataˤϰʲηǸ̤Ǽޤ<br>
 * $data[0][°̾][0] = °<br>
 * $data[0][°̾][1] = °  °2ͤä<br>
 * $data[1][°̾][0] = °  Υȥ
 *
 * $dsϴؿDgLDAP_connnect_server()ѤƼƤ
 *
 * @param string $basedn ١DN
 * @param string $ds     LDAPID
 * @param string $filter ե륿 
 * @param array  $attrs  ɬפǤΥơ֥ 
 * @param string $type   פη(TYPE_ONEENTRY, TYPE_ONELEVEL, TYPE_SUBTREE)
 * @param array  &$data  Ϥ줿ɬפǥǡγǼ
 *
 * @return integer ˽λLDAP_OK˼ԤLDAP_ERR_SEARCHʰϤ줿LDAP_ERR_PARAMȥ꤬¸ߤʤLDAP_ERR_NODATA¾Υ顼ξLDAP_ERR_OTHER֤ޤ
 *
 */
function DgLDAP_get_entry_batch($basedn, $ds, $filter, $attrs, $type, &$data)
{
    global $dg_err_msg;
    global $dg_log_msg;

    $s_attrs = array();

    /* å */
    if (!$basedn) {
        $dg_err_msg = ERRMSG_BASEDN;
        $dg_log_msg = LOGMSG_BASEDN;
        return (LDAP_ERR_PARAM);
    }
    if (!$filter){
        $dg_err_msg = ERRMSG_FILTER;
        $dg_log_msg = LOGMSG_FILTER;
        return (LDAP_ERR_PARAM);
    }
    if (!is_array($attrs)) {
        $dg_err_msg = ERRMSG_ARG_ATTR;
        $dg_log_msg = LOGMSG_ARG_ATTR;
        return (LDAP_ERR_PARAM);
    }

    /* °̾ʸѴ */
    for ($i = 0, $max = count($attrs); $i < $max; $i++) {
        $tmp = strtolower($attrs[$i]);

        /* ȥӥ塼ȤDNȤϼ */
        if ($tmp == "dn") {
            continue;
        }
        $s_attrs[$i] = $tmp;
    }

    /*  */
    $sr = DgLDAP_scope_search($ds, $basedn, $s_attrs, $filter, $type);
    if ($sr === FALSE){
        $errno = ldap_errno($ds);
        if ($errno == LDAP_NO_SUCH_OBJECT) {
            $dg_err_msg = ERRMSG_NOTFOUND . "(dn:$basedn)";
            $dg_log_msg = LOGMSG_NOTFOUND . "(dn:$basedn)";
            return (LDAP_ERR_NODATA);

        } elseif ($errno == LDAP_SUCCESS) {
            $dg_err_msg = ERRMSG_SEARCH . "(dn:$basedn)";
            $dg_log_msg = LOGMSG_SEARCH . "(dn:$basedn)";
            return (LDAP_ERR_SEARCH);

        } else {
            $error = ldap_error($ds);
            $dg_err_msg = ERRMSG_SEARCH . "($error dn:$basedn)";
            $dg_log_msg = LOGMSG_SEARCH . "($error dn:$basedn)";
            return (LDAP_ERR_SEARCH);
        }
    }

    /* ǡǼ */
    $ret = DgLDAP_set_data($ds, $sr, $attrs, $s_attrs, $type, $data, $basedn);

    return $ret;
}

/**
 *
 * Ϥ줿Ϣ($data)˳Ǽ줿ǡLDAPϿ롣
 *
 * ؿƤӽФ¦$dg_ldapinfoȤ̾ǰʲηϢ뤳ȤˤLDAPФؤ³ǽǤ<br><br>
 * $dg_ldapinfo["ldapserver"] : LDAPФIPɥ쥹<br>
 * $dg_ldapinfo["ldapport"] : LDAPФΥݡֹ<br>
 * $dg_ldapinfo["ldapbinddn"] : LDAPФΥХDN<br>
 * $dg_ldapinfo["ldapbindpw"] : LDAPФΥХɥѥ<br>
 * $dg_ldapinfo["ldapuserself"] : ʬȤؤΥХ(ͭ: TRUE ̵: FALSE)<br>
 * $dg_ldapinfo["ldapuserselfdn"] : ʬȤإХɤΥХDN<br>
 * $dg_ldapinfo["ldapuserselfpw"] : ʬȤإХɤΥХɥѥ<br>
 * $dg_ldapinfo["ldapro"] : read-onlyФؤΥХ(ͭ: TRUE ̵: FALSE)<br>
 * $dg_ldapinfo["ldapserverro"] : read-onlyФIPɥ쥹<br>
 * $dg_ldapinfo["ldapportro"] : read-onlyФΥݡֹ<br>
 *
 * ϤϢ$dataηϰʲȤޤ<br>
 * $data["ɲä°̾"] = "°"
 *
 * @param string $dn   ϿDN
 * @param array  $data ɬפǥǡγǼ
 *
 * @return integer ʾLDAP_OK֤ޤХɤ˼ԤLDAP_ERR_BINDLDAPؤϿ˼ԤLDAP_ERR_ADDȥ꤬¸ߤLDAP_ERR_DUPLICATE֤ޤ
 *
 */
function DgLDAP_add_entry($dn, $data)
{

    $ret = DgLDAP_entry_operate($dn, $data, TYPE_ADD);
    return $ret;

}

/**
 * 
 * Ϥ줿Ϣ($data)˳Ǽ줿ǡLDAPϿ롣(ؿLDAPФ³ʤ)
 *
 * ϤϢ$dataηϰʲȤޤ<br>
 * $data["ɲä°̾"] = "°"
 *
 * $dsϴؿDgLDAP_connnect_server()ѤƼƤ
 *
 * @param string $dn   ϿDN
 * @param string $ds   LDAPID
 * @param array  $data ɬפǥǡγǼ
 *
 * @return integer ʾLDAP_OK֤ޤLDAPؤϿ˼ԤLDAP_ERR_ADDȥ꤬¸ߤLDAP_ERR_DUPLICATE֤ޤ
 *
 */
function DgLDAP_add_entry_batch($dn, $ds, $data)
{

    $ret = DgLDAP_entry_operate_batch($dn, $ds, $data, TYPE_ADD);
    return $ret;

}

/**
 * 
 * LDAPϿ줿ǡϢ($data)˳Ǽ줿ǡѹ롣
 *
 * ؿƤӽФ¦$dg_ldapinfoȤ̾ǰʲηϢ뤳ȤˤLDAPФؤ³ǽǤ<br><br>
 * $dg_ldapinfo["ldapserver"] : LDAPФIPɥ쥹<br>
 * $dg_ldapinfo["ldapport"] : LDAPФΥݡֹ<br>
 * $dg_ldapinfo["ldapbinddn"] : LDAPФΥХDN<br>
 * $dg_ldapinfo["ldapbindpw"] : LDAPФΥХɥѥ<br>
 * $dg_ldapinfo["ldapuserself"] : ʬȤؤΥХ(ͭ: TRUE ̵: FALSE)<br>
 * $dg_ldapinfo["ldapuserselfdn"] : ʬȤإХɤΥХDN<br>
 * $dg_ldapinfo["ldapuserselfpw"] : ʬȤإХɤΥХɥѥ<br>
 * $dg_ldapinfo["ldapro"] : read-onlyФؤΥХ(ͭ: TRUE ̵: FALSE)<br>
 * $dg_ldapinfo["ldapserverro"] : read-onlyФIPɥ쥹<br>
 * $dg_ldapinfo["ldapportro"] : read-onlyФΥݡֹ<br>
 *
 * ϤϢ$dataηϰʲȤޤ<br>
 * $data["ɲä°̾"] = "°"
 *
 * @param string $dn   ѹDN
 * @param array  $data ɬפǥǡγǼ
 *
 * @return integer ʾLDAP_OK֤ޤХɤ˼ԤLDAP_ERR_BINDLDAPξѹ˼ԤLDAP_ERR_MODѹ륨ȥ꤬¸ߤʤLDAP_ERR_NODATA֤ޤ
 *
 */
function DgLDAP_mod_entry($dn, $data)
{

    $ret = DgLDAP_entry_operate($dn, $data, TYPE_MODIFY);
    return $ret;

}

/**
 * 
 * LDAPϿ줿ǡϢ($data)˳Ǽ줿ǡѹ롣(ؿLDAPФ³ʤ)
 *
 * ϤϢ$dataηϰʲȤޤ<br>
 * $data["ɲä°̾"] = "°"
 *
 * $dsϴؿDgLDAP_connnect_server()ѤƼƤ
 *
 * @param string $dn   ѹDN
 * @param string $ds   LDAPID
 * @param array  $data ɬפǥǡγǼ
 *
 * @return integer ʾLDAP_OK֤ޤLDAPξѹ˼ԤLDAP_ERR_MODѹ륨ȥ꤬¸ߤʤLDAP_ERR_NODATA֤ޤ
 *
 */
function DgLDAP_mod_entry_batch($dn, $ds, $data)
{

    $ret = DgLDAP_entry_operate_batch($dn, $ds, $data, TYPE_MODIFY);
    return $ret;

}

/**
 * 
 * LDAPϿ줿ǡ򡢾õ롣
 *
 * ؿƤӽФ¦$dg_ldapinfoȤ̾ǰʲηϢ뤳ȤˤLDAPФؤ³ǽǤ<br><br>
 * $dg_ldapinfo["ldapserver"] : LDAPФIPɥ쥹<br>
 * $dg_ldapinfo["ldapport"] : LDAPФΥݡֹ<br>
 * $dg_ldapinfo["ldapbinddn"] : LDAPФΥХDN<br>
 * $dg_ldapinfo["ldapbindpw"] : LDAPФΥХɥѥ<br>
 * $dg_ldapinfo["ldapuserself"] : ʬȤؤΥХ(ͭ: TRUE ̵: FALSE)<br>
 * $dg_ldapinfo["ldapuserselfdn"] : ʬȤإХɤΥХDN<br>
 * $dg_ldapinfo["ldapuserselfpw"] : ʬȤإХɤΥХɥѥ<br>
 * $dg_ldapinfo["ldapro"] : read-onlyФؤΥХ(ͭ: TRUE ̵: FALSE)<br>
 * $dg_ldapinfo["ldapserverro"] : read-onlyФIPɥ쥹<br>
 * $dg_ldapinfo["ldapportro"] : read-onlyФΥݡֹ<br>
 *
 * @param string $basedn õDN
 *
 * @return integer ʾLDAP_OK֤ޤХɤ˼ԤLDAP_ERR_BINDLDAPΥȥκ˼ԤLDAP_ERR_DELѹ륨ȥ꤬¸ߤʤLDAP_ERR_NODATA֤ޤ
 *
 */
function DgLDAP_del_entry($basedn)
{
    $data = "";
    $ret = DgLDAP_entry_operate($basedn, $data, TYPE_DELETE);
    return $ret;
}

/**
 * 
 * LDAPϿ줿ǡ򡢾õ롣(ؿLDAPФ³ʤ)
 *
 * $dsϴؿDgLDAP_connnect_server()ѤƼƤ
 *
 * @param string $basedn õDN
 * @param string $ds LDAPID
 *
 * @return integer ʾLDAP_OK֤ޤLDAPΥȥκ˼ԤLDAP_ERR_DELѹ륨ȥ꤬¸ߤʤLDAP_ERR_NODATA֤ޤ
 *
 */
function DgLDAP_del_entry_batch($basedn, $ds)
{
    $data = "";
    $ret = DgLDAP_entry_operate_batch($basedn, $ds, $data, TYPE_DELETE);
    return $ret;
}

/**
 *
 * LDAPϿ줿ȥ°ɲä
 *
 * ؿƤӽФ¦$dg_ldapinfoȤ̾ǰʲηϢ뤳ȤˤLDAPФؤ³ǽǤ<br><br>
 * $dg_ldapinfo["ldapserver"] : LDAPФIPɥ쥹<br>
 * $dg_ldapinfo["ldapport"] : LDAPФΥݡֹ<br>
 * $dg_ldapinfo["ldapbinddn"] : LDAPФΥХDN<br>
 * $dg_ldapinfo["ldapbindpw"] : LDAPФΥХɥѥ<br>
 * $dg_ldapinfo["ldapuserself"] : ʬȤؤΥХ(ͭ: TRUE ̵: FALSE)<br>
 * $dg_ldapinfo["ldapuserselfdn"] : ʬȤإХɤΥХDN<br>
 * $dg_ldapinfo["ldapuserselfpw"] : ʬȤإХɤΥХɥѥ<br>
 * $dg_ldapinfo["ldapro"] : read-onlyФؤΥХ(ͭ: TRUE ̵: FALSE)<br>
 * $dg_ldapinfo["ldapserverro"] : read-onlyФIPɥ쥹<br>
 * $dg_ldapinfo["ldapportro"] : read-onlyФΥݡֹ
 *
 * ϤϢ$dataηϰʲȤޤ<br>
 * $data["ɲä°̾"] = "°"
 *
 * δؿϴ¸ߤ륨ȥ°ɲäޤȥɲäDgLDAP_add_entry()ѤƤ
 *
 * @param string $basedn °ɲäDN
 * @param array  $data   ɬפǥǡγǼ
 *
 * @return integer ʾLDAP_OK֤ޤХɤ˼ԤLDAP_ERR_BINDLDAPξɲä˼ԤLDAP_ERR_ADDȥ꤬¸ߤʤLDAP_ERR_NODATA°ͤ¸ߤLDAP_ERR_DUPLICATE֤ޤ
 *
 */
function DgLDAP_add_attribute($basedn, $data)
{

    $ret = DgLDAP_entry_operate($basedn, $data, TYPE_ADD_ATTRIBUTE);
    return $ret;

}

/**
 *
 * LDAPϿ줿ȥ°ɲä(ؿLDAPФ³ʤ)
 *
 * ϤϢ$dataηϰʲȤޤ<br>
 * $data["ɲä°̾"] = "°"
 *
 * δؿϴ¸ߤ륨ȥ°ɲäޤȥɲäDgLDAP_add_entry_batch()ѤƤ
 *
 * $dsϴؿDgLDAP_connnect_server()ѤƼƤ
 *
 * @param string $basedn °ɲäDN
 * @param string $ds     LDAPID
 * @param array  $data   ɬפǥǡγǼ
 *
 * @return integer ʾLDAP_OK֤ޤLDAPξɲä˼ԤLDAP_ERR_ADDȥ꤬¸ߤʤLDAP_ERR_NODATA°ͤ¸ߤLDAP_ERR_DUPLICATE֤ޤ
 *
 */
function DgLDAP_add_attribute_batch($basedn, $ds, $data)
{

    $ret = DgLDAP_entry_operate_batch($basedn, $ds, $data, TYPE_ADD_ATTRIBUTE);
    return $ret;

}

/**
 *
 * LDAPϿ줿1ĤΥǡ°
 *
 * ؿƤӽФ¦$dg_ldapinfoȤ̾ǰʲηϢ뤳ȤˤLDAPФؤ³ǽǤ<br><br>
 * $dg_ldapinfo["ldapserver"] : LDAPФIPɥ쥹<br>
 * $dg_ldapinfo["ldapport"] : LDAPФΥݡֹ<br>
 * $dg_ldapinfo["ldapbinddn"] : LDAPФΥХDN<br>
 * $dg_ldapinfo["ldapbindpw"] : LDAPФΥХɥѥ<br>
 * $dg_ldapinfo["ldapuserself"] : ʬȤؤΥХ(ͭ: TRUE ̵: FALSE)<br>
 * $dg_ldapinfo["ldapuserselfdn"] : ʬȤإХɤΥХDN<br>
 * $dg_ldapinfo["ldapuserselfpw"] : ʬȤإХɤΥХɥѥ<br>
 * $dg_ldapinfo["ldapro"] : read-onlyФؤΥХ(ͭ: TRUE ̵: FALSE)<br>
 * $dg_ldapinfo["ldapserverro"] : read-onlyФIPɥ쥹<br>
 * $dg_ldapinfo["ldapportro"] : read-onlyФΥݡֹ<br>
 *
 * ϤϢ$attrsηϰʲȤޤ<br>
 * $attrs["°̾"] = "°"
 * 
 * @param string $dn    оݤ°DN
 * @param array  $attrs °̾
 * @return integer ʾLDAP_OK֤ޤХɤ˼ԤLDAP_ERR_BINDʰϤ줿LDAP_ERR_PARAM°κ˼ԤLDAP_ERR_DELȥ꤬¸ߤʤäLDAP_ERR_NODATA°ޤ°ͤʤäLDAP_ERR_NOATTR֤ޤ
 *
 */
function DgLDAP_del_attribute($dn, $attrs)
{

    /* Х */
    $ds = DgLDAP_connect_server();
    if ($ds == LDAP_ERR_BIND) {
        return (LDAP_ERR_BIND);
    }

    /* °κ */
    $ret = DgLDAP_del_attribute_batch($ds, $dn, $attrs);

    /* Х */
    ldap_unbind($ds);

    return $ret;
}

/**
 *
 * LDAPϿ줿1ĤΥǡ°(ؿLDAPФ³ʤ)
 *
 * ϤϢ$attrsηϰʲȤޤ<br>
 * $attrs["°̾"] = "°"
 * 
 * $dsϴؿDgLDAP_connnect_server()ѤƼƤ
 *
 * @param string $ds    LDAPID
 * @param string $dn    оݤ°DN
 * @param array  $attrs °̾
 *
 * @return integer ʾLDAP_OK֤ޤʰϤ줿LDAP_ERR_PARAM°κ˼ԤLDAP_ERR_DELȥ꤬¸ߤʤäLDAP_ERR_NODATA°ޤ°ͤʤäLDAP_ERR_NOATTR֤ޤ
 *
 */
function DgLDAP_del_attribute_batch($ds, $dn, $attrs)
{
    global $dg_err_msg;
    global $dg_log_msg;

    /* å */
    if (!$dn) {
        $dg_err_msg = ERRMSG_BASEDN;
        $dg_log_msg = LOGMSG_BASEDN;
        return (LDAP_ERR_PARAM);
    }
    if (!is_array($attrs)) {
        $dg_err_msg = ERRMSG_ARG_ATTR;
        $dg_log_msg = LOGMSG_ARG_ATTR;
        return (LDAP_ERR_PARAM);
    }

    $enc_dn = mb_convert_encoding($dn, LDAP_ENCODING, PG_ENCODING);
    $r = @ldap_mod_del($ds, $enc_dn, $attrs);
    if ($r === FALSE) {
        $errno = ldap_errno($ds);
        if ($errno == LDAP_SUCCESS) {
            $dg_err_msg = ERRMSG_DELATTR . "(dn:$dn)";
            $dg_log_msg = LOGMSG_DELATTR . "(dn:$dn)";
            $ret = LDAP_ERR_DEL;
        } else {
            $error = ldap_error($ds);
            $dg_err_msg = ERRMSG_DELATTR . "($error dn:$dn)";
            $dg_log_msg = LOGMSG_DELATTR . "($error dn:$dn)";

            if ($errno == LDAP_NO_SUCH_VALUE || $errno == LDAP_NO_SUCH_ATTR) {
                $ret = LDAP_ERR_NOATTR;
            } else if ($errno == LDAP_NO_SUCH_OBJECT) {
                $ret = LDAP_ERR_NODATA;
            } else {
                $ret =  LDAP_ERR_DEL;
            }
        }
        return $ret;
    }

    return (LDAP_OK);
}

/**
 * 
 * ꤵ줿ǡ($type)ɲáѹִȤäԤ
 *
 * ؿƤӽФ¦$dg_ldapinfoȤ̾ǰʲηϢ뤳ȤˤLDAPФؤ³ǽǤ<br><br>
 * $dg_ldapinfo["ldapserver"] : LDAPФIPɥ쥹<br>
 * $dg_ldapinfo["ldapport"] : LDAPФΥݡֹ<br>
 * $dg_ldapinfo["ldapbinddn"] : LDAPФΥХDN<br>
 * $dg_ldapinfo["ldapbindpw"] : LDAPФΥХɥѥ<br>
 * $dg_ldapinfo["ldapuserself"] : ʬȤؤΥХ(ͭ: TRUE ̵: FALSE)<br>
 * $dg_ldapinfo["ldapuserselfdn"] : ʬȤإХɤΥХDN<br>
 * $dg_ldapinfo["ldapuserselfpw"] : ʬȤإХɤΥХɥѥ<br>
 * $dg_ldapinfo["ldapro"] : read-onlyФؤΥХ(ͭ: TRUE ̵: FALSE)<br>
 * $dg_ldapinfo["ldapserverro"] : read-onlyФIPɥ쥹<br>
 * $dg_ldapinfo["ldapportro"] : read-onlyФΥݡֹ
 *
 * $typeˤϰʲͤꤷƤ<br>
 * ȥɲ : TYPE_ADD<br>
 * ȥѹ : TYPE_MODIFY<br>
 * ȥκ : TYPE_DELETE<br>
 * °ɲ : TYPE_ADD_ATTRIBUTE<br>
 * °ִ : TYPE_REPLACE_ATTRIBUTE<br>
 * ȥѹ : TYPE_MODIFY_DELETE
 *
 * @param string $dn   ϿorѹorDN
 * @param array  $data Ͽorѹǡarray
 * @param string $type ꤵ줿ǡ
 *
 * @return integer ʾLDAP_OK֤ޤLDAPؤΥХɤ˼ԤLDAP_ERR_BINDLDAPؤϿ˼ԤLDAP_ERR_ADDLDAPξѹ˼ԤLDAP_ERR_MODȥ꤬¸ߤʤLDAP_ERR_NODATAȥ꤬¸ߤLDAP_ERR_DUPLICATELDAPΥȥκ˼ԤLDAP_ERR_DEL֤ޤ
 *
 */
function DgLDAP_entry_operate($dn, $data, $type)
{

    /* Х */
    $ds = DgLDAP_connect_server();
    if ($ds == LDAP_ERR_BIND) {
        return (LDAP_ERR_BIND);
    }

    /* ǡ */
    $ret = DgLDAP_entry_operate_batch($dn, $ds, $data, $type);

    /* Х */
    ldap_unbind($ds);

    return $ret;
}

/**
 * 
 * ꤵ줿ǡ($type)ɲáѹִȤäԤ(ؿLDAPФ³ʤ)
 *
 * $typeˤϰʲͤꤷƤ<br>
 * ȥɲ : TYPE_ADD<br>
 * ȥѹ : TYPE_MODIFY<br>
 * ȥκ : TYPE_DELETE<br>
 * °ɲ : TYPE_ADD_ATTRIBUTE<br>
 * °ִ : TYPE_REPLACE_ATTRIBUTE<br>
 * ȥѹ : TYPE_MODIFY_DELETE
 *
 * @param string $dn   ϿorѹorDN
 * @param string $ds   LDAPID
 * @param array  $data Ͽorѹǡarray
 * @param string $type ꤵ줿ǡ	
 *
 * @return integer ʾLDAP_OK֤ޤLDAPؤϿ˼ԤLDAP_ERR_ADDLDAPξѹ˼ԤLDAP_ERR_MODȥ꤬¸ߤʤLDAP_ERR_NODATAȥ꤬¸ߤLDAP_ERR_DUPLICATELDAPΥȥκ˼ԤLDAP_ERR_DEL֤ޤ
 *
 */
function DgLDAP_entry_operate_batch($dn, $ds, $data, $type)
{
    global $dg_err_msg;
    global $dg_log_msg;

    /* å */
    if (!$dn) {
        $dg_err_msg = ERRMSG_BASEDN;
        $dg_log_msg = LOGMSG_BASEDN;
        return (LDAP_ERR_PARAM);
    }
    if ((!is_array($data)) && ($type != TYPE_DELETE)) {
        $dg_err_msg = ERRMSG_ARG_ATTR;
        $dg_log_msg = LOGMSG_ARG_ATTR;
        return (LDAP_ERR_PARAM);
    }

    $conv_dn = mb_convert_encoding($dn, LDAP_ENCODING, PG_ENCODING);

    /* ȥɲáѹִ */
    if ($type == TYPE_ADD) {
        $err_str = "ȥɲ";
        $log_str = "add entry";
        $r = @ldap_add($ds, $conv_dn, $data);
    } elseif ($type == TYPE_MODIFY) {
        $err_str = "ȥѹ";
        $log_str = "modify entry";
        $r = @ldap_modify($ds, $conv_dn, $data);
    } elseif ($type == TYPE_DELETE) {
        $err_str = "ȥκ";
        $log_str = "delete entry";
        $r = @ldap_delete($ds, $conv_dn);
    } elseif ($type == TYPE_ADD_ATTRIBUTE) {
        $err_str = "°ɲ";
        $log_str = "add attribute";
        $r = @ldap_mod_add($ds, $conv_dn, $data);
    } elseif ($type == TYPE_REPLACE_ATTRIBUTE) {
        $err_str = "°ɲ";
        $log_str = "add attribute";
        $r = @ldap_mod_add($ds, $conv_dn, array($data[0] => $data[2]));
    } elseif ($type == TYPE_MODIFY_DELETE) {
        $err_str = "ȥѹ";
        $log_str = "modify entry";
        $r = @ldap_modify($ds, $conv_dn, $data[0]);
    }

    if ($r === FALSE) {
        $errno = ldap_errno($ds);
        /* Ǥ¸ߤƤ */
	if ($errno == LDAP_ALREADY_EXISTS) {
            $dg_err_msg = ERRMSG_EXIST . "(dn:$dn)";
            $dg_log_msg = LOGMSG_EXIST . "(dn:$dn)";
            return (LDAP_ERR_DUPLICATE);
        }
        /* Ĥʤ */
	if ($errno == LDAP_NO_SUCH_OBJECT) {
            $dg_err_msg = ERRMSG_NOTFOUND . "(dn:$dn)";
            $dg_log_msg = LOGMSG_NOTFOUND . "(dn:$dn)";
            return (LDAP_ERR_NODATA);
        }
        /* Ǥ¸ߤƤ(°) */
	if ($errno == LDAP_EXISTS_VALUE) {
            $dg_err_msg = ERRMSG_EXISTS_VALUE . "(dn:$dn)";
            $dg_log_msg = LOGMSG_EXISTS_VALUE . "(dn:$dn)";
            return (LDAP_ERR_DUPLICATE);
        }

        if ($errno == LDAP_SUCCESS) {
            $dg_err_msg = $err_str . "˼Ԥޤ(dn:" . $dn . ")";
            $dg_log_msg = "Cannot " . $log_str . ".(dn:" . $dn . ")";
        } else {
            $error = ldap_error($ds);
            $dg_err_msg = $err_str . "˼Ԥޤ(" . $error . " dn:" .
                          $dn . ")";
            $dg_log_msg = "Cannot " . $log_str . ".(" . $error . " dn:" . $dn .
                          ")";
	}

	if ($type == TYPE_ADD || $type == TYPE_ADD_ATTRIBUTE ||
            $type == TYPE_REPLACE_ATTRIBUTE) {
            return (LDAP_ERR_ADD);
	} elseif ($type == TYPE_MODIFY || $type == TYPE_MODIFY_DELETE){
            return (LDAP_ERR_MOD);
	} elseif ($type == TYPE_DELETE){
            return (LDAP_ERR_DEL);
	}
    }
    /* ִξϺ */
    if ($type == TYPE_REPLACE_ATTRIBUTE) {
        return DgLDAP_del_attribute_batch($ds, $dn,
                                          array($data[0] => $data[1]));
    /* ξϺ */
    } else if ($type == TYPE_MODIFY_DELETE) {
        return DgLDAP_del_attribute_batch($ds, $dn, $data[1]);
    }

    return (LDAP_OK);
}

/**
 * 
 * $typeǻꤵ줿פǥ򤹤롣
 *
 * $typeǻꤹ륵פμϰʲˤʤޤ<br>
 * TYPE_ONELEVEL : ñ쳬ؤθ<br>
 * TYPE_ONEENTRY : 1ȥθ<br>
 * TYPE_SUBTREE : LDAPĥ꡼򸡺
 * 
 * @param string $ds     LDAPID	
 * @param string $basedn ȥDN
 * @param array  $attrs  ɬפǤΥơ֥ 
 * @param string $filter ե륿	
 * @param string $type   פη	
 *
 * @return string ID֤ޤ
 *
 */
function DgLDAP_scope_search($ds, $basedn, $attrs, $filter, $type)
{
    $basedn = mb_convert_encoding($basedn, LDAP_ENCODING, PG_ENCODING);
    if (count($attrs) == 0) {
	switch ($type) {
	    case TYPE_ONELEVEL:
	        $sr = @ldap_list($ds, $basedn, $filter, array());
		break;	
	    case TYPE_ONEENTRY:
	        $sr = @ldap_read($ds, $basedn, $filter);
		break;
	    case TYPE_SUBTREE:
	        $sr = @ldap_search($ds, $basedn, $filter);
		break;
	}
    } else {
	switch ($type) {
	    case TYPE_ONELEVEL:
	        $sr = @ldap_list($ds, $basedn, $filter, $attrs);
	        break;
	    case TYPE_ONEENTRY:
	        $sr = @ldap_read($ds, $basedn, $filter, $attrs);
		break;
	    case TYPE_SUBTREE:
	        $sr = @ldap_search($ds, $basedn, $filter, $attrs);
		break;
	}
    }
    return ($sr);
}

/**
 * 
 * ̤ɬǤϢ(&$data)˳Ǽ롣
 *
 * @param string $ds      LDAPID	
 * @param string $sr      ID	
 * @param array  $attrs   ɬפǤΥơ֥ 
 * @param array  $s_attrs ʸΥơ֥
 * @param string $type    פη	
 * @param array  &$data   ɬפǥǡγǼ
 * @param string $basedn  ١DN 
 *
 * @return integer ʾLDAP_OK֤ޤ顼ξLDAP_ERR_SEARCH򡢥ȥ꤬¸ߤʤLDAP_ERR_NODATA򡢤¾Υ顼ξLDAP_ERR_OTHER֤ޤ
 *
 */
function DgLDAP_set_data($ds, $sr, $attrs, $s_attrs, $type, &$data, $basedn) 
{
    global $dg_err_msg;
    global $dg_log_msg;

    /* ȥ */
    $entry_cnt = @ldap_count_entries($ds, $sr);
    if ($entry_cnt === FALSE) {
        $errno = ldap_errno($ds);
        if ($errno == LDAP_SUCCESS) {
            $dg_err_msg = ERRMSG_ENTRY . "(dn:$basedn)";
            $dg_log_msg = LOGMSG_ENTRY . "(dn:$basedn)";
        } else {
            $error = ldap_error($ds);
            $dg_err_msg = ERRMSG_ENTRY . "($error dn:$basedn)";
            $dg_log_msg = LOGMSG_ENTRY . "($error dn:$basedn)";
        }
        return (LDAP_ERR_NODATA);

    } elseif ($entry_cnt == 0) { 
        $dg_err_msg = ERRMSG_NOTFOUND . "(dn:$basedn)";
        $dg_log_msg = LOGMSG_NOTFOUND . "(dn:$basedn)";
        return (LDAP_ERR_NODATA);
    }

    /* ǽη̥ȥ */
    $entry_id = @ldap_first_entry($ds, $sr);
    if ($entry_id === FALSE) {
        $errno = ldap_errno($ds);
        if ($errno == LDAP_SUCCESS) {
            $dg_err_msg = ERRMSG_ENTRY . "(dn:$basedn)";
            $dg_log_msg = LOGMSG_ENTRY . "(dn:$basedn)";
        } else {
            $error = ldap_error($ds);
            $dg_err_msg = ERRMSG_ENTRY . "($error dn:$basedn)";
            $dg_log_msg = LOGMSG_ENTRY . "($error dn:$basedn)";
        }
        return (LDAP_ERR_NODATA);
    }

    for ($j = 0 ; $entry_id ; $j++) {
        $dn = @ldap_get_dn($ds, $entry_id);
        if ($dn === FALSE) {
            $errno = ldap_errno($ds);
            if ($errno == LDAP_SUCCESS) {
                $dg_err_msg = ERRMSG_GETDN . "(dn:$basedn)"; 
                $dg_log_msg = LOGMSG_GETDN . "(dn:$basedn)"; 
            } else {
                $error = ldap_error($ds);
                $dg_err_msg = ERRMSG_GETDN . "($error dn:$basedn)";
                $dg_log_msg = LOGMSG_GETDN . "($error dn:$basedn)";
            }
            return (LDAP_ERR_OTHER);
        }
        $data[$j]["dn"] = preg_replace("/, +/", ",", $dn);

        /* ȥ */
        $attri = @ldap_get_attributes($ds, $entry_id); 
        if ($attri === FALSE) {
            $errno = ldap_errno($ds);
            if ($errno == LDAP_SUCCESS) {
                $dg_err_msg = ERRMSG_ATTR . "(dn:$basedn)";
                $dg_log_msg = LOGMSG_ATTR . "(dn:$basedn)";
            } else {
                $error = ldap_error($ds);
                $dg_err_msg = ERRMSG_ATTR . "($error dn:$basedn)";
                $dg_log_msg = LOGMSG_ATTR . "($error dn:$basedn)";
            }
            return (LDAP_ERR_OTHER);
        }

        $attrs_cnt = $attri["count"];

        for ($i = 0; $i < $attrs_cnt; $i++) {
            /* ° */
            $value = @ldap_get_values_len($ds, $entry_id, $attri[$i]);
            if ($value === FALSE) {
                    $errno = ldap_errno($ds);
                    if ($errno == LDAP_DECODING_ERROR) {
                        $data[$j][$attri[$i]][$k] = "";
                    } elseif($errno == LDAP_SUCCESS) {
                    	$dg_err_msg = ERRMSG_ATTR . "(dn:$basedn)";
                    	$dg_log_msg = LOGMSG_ATTR . "(dn:$basedn)";
                    } else {
                        $error = ldap_error($ds);
                    	$dg_err_msg = ERRMSG_ATTR . "($error dn:$basedn)";
                    	$dg_log_msg = LOGMSG_ATTR . "($error dn:$basedn)";
                    }
                    return (LDAP_ERR_OTHER);
            }

            for ($k = 0; $k < $value["count"]; $k++ ) {
                $data[$j][$attri[$i]][$k] = $value[$k];	
            }
        }
        /* η̥ȥ */
        $entry_id = @ldap_next_entry($ds, $entry_id);
    }
    return (LDAP_OK);
}

/**
 * 
 * ե륿Υ
 *
 * ե륿˻ꤵʸ(*, (, ), \\)򥨥פޤ
 *
 * @param string $str פʸ
 *
 * @return string ׸ʸ
 *
 */
function DgLDAP_filter_escape($str)
{
    $trans = array("*" => "\\*",
                   "(" => "\\(",
                   ")" => "\\)",
                   "\\" => "\\\\");

    return strtr($str, $trans);
}

?>
