<?php
/**
 * ̴ؿ饤֥
 *
 */

/**
 *
 * եɤ߹ߡǼ
 *
 * ɤ߹եηϰʲȤޤ<br>
 *  (̾)=()η1Ԥ1<br>
 *  #ϥȹԤȤ롣<br>
 *  Ԥ̵뤵롣
 *
 * $conf_keyϰʲηϢȤؿƤӽФ¦ޤ<br>
 *  $conf_key[եι̾] = ͤΥåؿ
 *
 * $conf_defϰʲηϢȤؿƤӽФ¦ޤ<br>
 *  $conf_def[եι̾] = ǥե
 * 
 * @param string $filename    ե̾
 * @param array  $conf_keys   եι̾򥭡ͤΥåؿͤȤϢ
 * @param array  $conf_def    եι̾򥭡ǥեͤͤȤϢ
 *
 * @return mixed ɤ߹᤿եξǼ󡢥եɹʤޤեη顼ξFALSE֤ޤ
 *
 */
function DgCommon_read_conf($filename, $conf_keys, $conf_def)
{

    global $dg_err_msg;
    global $dg_log_msg;

    /* եɤ߹߸å */
    if (DgCommon_is_readable_file($filename) === FALSE) {
        $dg_err_msg = htmlspecialchars($dg_err_msg);
        return FALSE;
    }

    /* ե򥪡ץ */
    $fp = fopen($filename, "r");
    if ($fp === FALSE) {
        $dg_err_msg = "ե뤬ץǤޤ(" .
                      htmlspecialchars($filename) . ")";
        $dg_log_msg = "Cannot open file.(" . $filename . ")";
        return FALSE;
    }

    /* Ԥν */
    $line = 0;
    $err = "";
    $log = "";

    /* եɤ߹ */
    while (feof($fp) === FALSE) {

        /* ʬХåե˳Ǽ */
        $buf = fgets($fp);
        if ($buf === FALSE) {
            break;
        }

        /* ζȲԤ */
        $buf = rtrim($buf);

        $line++;

        /* ԤƬ#ΥȹԤǤ̵ */
        $c = substr($buf, 0, 1);
        if ($c == "#" || $c == "") {
            continue;
        }

        /* ԤλϤζڤʸʬ */
        $data = explode("=", $buf, 2);
        /* ͤnull,ѥ᡼ƬǤС顼 */
        if (($data[0] == "") || ($data[1] == "") ||
                                 substr("$data[1]", 0, 1) == " ") {
            $err .= $line . "ܤηǤ(" .
                    htmlspecialchars($filename) . ")<br>";
            $log .= "Invalid line(line: " . $line . "). (" .  $filename . ") ";
            continue;
        }

        /* ̾ʸƳǼ */
        $key = strtolower($data[0]);

        /* 줿ܤΥå */
        if(is_null($conf_keys[$key]) === TRUE) {
            $err .= $line . "ܡ" . htmlspecialchars($key) .
                    "٤ƤʤܤǤ(" .
                    htmlspecialchars($filename) .  ")<br>";
            $log .= $key . " (line: " . $line .  ") is undefined item.(" .
                    $filename . ") ";
            continue;
        }

        /* ܤˤå */
        if ($conf_keys[$key]($data[1]) === FALSE) {
            $err .= $line . "ܡ" . htmlspecialchars($key) .
                    "٤ͤǤ(" . htmlspecialchars($filename) .
                    ")<br>";
            $log .= $key . " (line: " . $line .
                    ") is invalid.(" .  $filename . ") ";
            continue;
        }

        /* ʣå */
        if (isset($conf[$key]) === TRUE) {
            $err .= $line . "ܡ" . htmlspecialchars($key) .
                    "٤ʣƤޤ(" . htmlspecialchars($filename) .
                    ")<br>";
            $log .= $key . " (line: " . $line .  ") is duplicated.(" . 
                    $filename . ") ";
            continue;
        }

        /* ͤǼ */
        $conf[$key] = $data[1];

    }

    fclose($fp);

    /* å顼 */
    if ($err != "") {
        $dg_err_msg = $err;
        $dg_log_msg = $log;
        return FALSE;
    }

    /* ̾ */
    $keys = array_keys($conf_keys);

    /* ٤ƤιܤͤåȤƤ뤫γǧ */
    foreach ($keys as $key) {
        /* åȤƤ餺ǥեͤꤵƤ硢 */
        if (!isset($conf[$key]) && isset($conf_def[$key])) {
            $conf[$key] = $conf_def[$key];
        } elseif (!isset($conf[$key]) === TRUE) {
            $err .= "ܡ" . htmlspecialchars($key) .
                    "٤ꤵƤޤ(" .
                    htmlspecialchars($filename) . ")<br>";
            $log .= $key . " must be set. (" .
                    $filename . ") ";
            continue;
        }
    }

    /* ɬܥå顼 */
    if ($err != "") {
        $dg_err_msg = $err;
        $dg_log_msg = $log;
        return FALSE;
    }

    return $conf;
}

/**
 * 
 * եɤ߹߸å
 *
 * @param string $filename åоݥե
 *
 * @return bool եɤ߹߸TRUEʳFALSE֤ޤ
 *
 */
function DgCommon_is_readable_file($filename)
{
    global $dg_err_msg;
    global $dg_log_msg;

    /* STATΥå奯ꥢ */
    clearstatcache();

    /* ¸ߤΥå */
    if (file_exists($filename) === FALSE) {
        $dg_err_msg = "ե뤬¸ߤޤ(" . $filename . ")";
        $dg_log_msg = "File does not exist.(" . $filename . ")";
        return FALSE;
    }

    /* ǥ쥯ȥ꤫Υå */
    if (is_dir($filename) === TRUE) {
        $dg_err_msg = "Ʊ̾Υǥ쥯ȥ꤬¸ߤޤ(" .  $filename . ")";
        $dg_log_msg = "Directory with the same name exists.(" . $filename . ")";
        return FALSE;
    }

    /*  եɤ߹߸å */
    if (is_readable($filename) === FALSE) {
        $dg_err_msg = "եɤ߹߸ޤ(" . $filename . ")";
        $dg_log_msg = "File is not readable.(" . $filename . ")";
        return FALSE;
    }

    return TRUE;
}

/**
 *
 * եν񤭹߸å
 *
 * @param string $filename åоݥե
 *
 * @return bool ե˽񤭹߸⤷ϻꤵ줿ե¸ߤʤǥ쥯ȥ˽񤭹߸TRUEʳFALSE֤ޤ
 *
 */
function DgCommon_is_writable_file($filename)
{
    global $dg_err_msg;
    global $dg_log_msg;

    /* STATΥå奯ꥢ */
    clearstatcache();

    /* ¸ߥå */
    if (file_exists($filename) === FALSE) {
        if (is_writable(dirname($filename)) === FALSE) {
            $dg_err_msg = "ǥ쥯ȥ˽񤭹߸ޤ(" .
                          $filename . ")";
            $dg_log_msg = "Directory buffering the file is not readable.(" .
                          $filename . ")";
            return FALSE;
        }
        return TRUE;
    }

    /*  ǥ쥯ȥå */
    if (is_dir($filename) === TRUE) {
        $dg_err_msg = "Ʊ̾Υǥ쥯ȥ꤬¸ߤޤ(" . $filename . ")";
        $dg_log_msg = "Directory with the same name exists.(" . $filename . ")";
        return FALSE;
    }

    /*  եν߸å */
    if (is_writable($filename) === FALSE) {
        $dg_err_msg = "ե˽񤭹߸ޤ(" . $filename . ")";
        $dg_log_msg = "File is not writable.(" . $filename .  ")";
        return FALSE;
    }
    return TRUE;
}

/**
 *
 * TRUEΤ֤ߡؿ(եΥåؿ)
 *
 * @return bool ɤʾǤTRUE֤ޤ
 *
 */
function DgCommon_check_none()
{
    return TRUE;
}

/**
 *
 * ݡֹå(եΥåؿ)
 *
 * ݡֹϰϤ1ʾ65535ʲǤ뤳Ȥåޤ
 *
 * @param string $port ݡֹ
 *
 * @return bool ݡֹηTRUEʤFALSE֤ޤ 
 *
 */
function DgCommon_is_port($port)
{
    /* ȾѿΤߵ */
    $num = "0123456789";
    if (strspn($port, $num) != strlen($port)) {
        return FALSE;
    }

    /* 1ݡֹޤ */
    if (($port < 1) || ($port > 65535)) {
        return FALSE;
    }
    return TRUE;
}

/**
 *
 * ᡼륢ɥ쥹Υå
 *
 * ꤵ줿å٥˴ŤƥåԤޤ<br>
 * $level = 1:<br>
 *  ʸ郎ȾѱѾʸȾѿȾѵ(-._@)Ǥ뤳<br>
 *  256ʸǤ뤳<br>
 *
 * $level = 2:<br>
 *  @ʸ郎Ⱦѱ羮ʸȾѿȾѵ(!#$%&'*+-/=?^_{}~)Ǥ뤳<br>
 *  @1ʸʾΤ<br>
 *  @ʸ郎Ⱦѱ羮ʸȾѿȾѵ(-._)Ǥ뤳<br>
 *  @.1İʾޤޤƤ뤳<br>
 *  @.Ϣ³Ƥʤ<br>
 *  @3ʸʾΤ<br>
 *  256ʸǤ뤳<br>
 *
 * $level = 3:<br>
 *  @ʸ郎ȾѱѾʸȾѿȾѵ(-._)Ǥ뤳<br>
 *  @1ʸʾΤ<br>
 *  @Τʸ郎ȾѱѾʸȾѿȾѵ(-._)Ǥ뤳<br>
 *  @.1İʾޤޤƤ뤳<br>
 *  @.Ϣ³Ƥʤ<br>
 *  @3ʸʾΤ<br>
 *  256ʸǤ뤳
 *
 * @param string  $mail  ᡼륢ɥ쥹
 * @param integer $level ᡼륢ɥ쥹Υå٥(1 or 2 or 3)
 *
 * @return bool ᡼륢ɥ쥹ηTRUEʤFALSE֤ޤ
 *
 */
function DgCommon_is_mailaddr($mail, $level = 2)
{
    global $dg_err_msg;
    global $dg_log_msg;

    /* å٥ηå */
    if ($level != 1 && $level != 2 && $level != 3) {
        $dg_err_msg = "᡼륢ɥ쥹Υå٥ηǤ(" .
                      $level . ")";
        $dg_log_msg = "Check level of mailaddr is invalid.(" . $level . ")";
        return FALSE;
    }

    /* ᡼륢ɥ쥹Ĺå */
    if (strlen($mail) > 256) {
        $dg_err_msg = "᡼륢ɥ쥹ηǤ(" . $mail . ")";
        $dg_log_msg = "Form of mailaddr is invalid.(" . $mail . ")";
        return FALSE;
    }

    if ($level == 1) {
        /* ٥1 */
        /* ᡼륢ɥ쥹ηå */
        $num = "0123456789";
        $sl = "abcdefghijklmnopqrstuvwxyz";
        $sym = "-._@";
        $allow_letter = $num . $sl . $sym;
        if (strspn($mail, $allow_letter) != strlen($mail)) {
            $dg_err_msg = "᡼륢ɥ쥹ηǤ(" . $mail . ")";
            $dg_log_msg = "Form of mailaddr is invalid.(" . $mail . ")";
            return FALSE;
        }
    } else {
        /* ٥2,3 */
        /* @Ĥ˶ڤ뤫Υå */
        $buf = explode('@', $mail, 2);
        if ($buf[0] == "" || $buf[1] == "") {
            $dg_err_msg = "᡼륢ɥ쥹ηǤ(" . $mail . ")";
            $dg_log_msg = "Form of mailaddr is invalid.(" . $mail . ")";
            return FALSE;
        }

        /* @Υå */
        /* ȾѱѾʸʲεΤߵ */
        $num = "0123456789";
        $sl = "abcdefghijklmnopqrstuvwxyz";
        $ll = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        $sym1 = "!#$%&'*+-/=?^_{}~.";
        $sym2 = "-._";

        /* ʸ */
        if ($level == 2) {
            $front_letter = $num . $sl . $ll . $sym1;
            $back_letter = $num . $sl . $ll . $sym2;
        } else {
            $front_letter = $num . $sl . $sym2;
            $back_letter = $num . $sl . $sym2;
        }

        if (strspn($buf[0], $front_letter) != strlen($buf[0])) {
            $dg_err_msg = "᡼륢ɥ쥹ηǤ(" . $mail . ")";
            $dg_log_msg = "Form of mailaddr is invalid.(" . $mail . ")";
            return FALSE;
        }

        /*  @Υå */
        if (strlen($buf[1]) < 3) {
            $dg_err_msg = "᡼륢ɥ쥹ηǤ(" . $mail . ")";
            $dg_log_msg = "Form of mailaddr is invalid.(" . $mail . ")";
            return FALSE;
        }

        /* ɥåȤϤޤХ顼 */
        if (substr($buf[1], 0, 1) == ".") {
            $dg_err_msg = "᡼륢ɥ쥹ηǤ(" . $mail . ")";
            $dg_log_msg = "Form of mailaddr is invalid.(" . $mail . ")";
            return FALSE;
        }

        /* 1İʾΥɥåȤɬܡ */
        if (strpos($buf[1], ".") === FALSE) {
            $dg_err_msg = "᡼륢ɥ쥹ηǤ(" . $mail . ")";
            $dg_log_msg = "Form of mailaddr is invalid.(" . $mail . ")";
            return FALSE;
        }

        /* 2İʾΥɥåȤϢ³϶ػߡ */
        if (strpos($buf[1], "..") !== FALSE) {
            $dg_err_msg = "᡼륢ɥ쥹ηǤ(" . $mail . ")";
            $dg_log_msg = "Form of mailaddr is invalid.(" . $mail . ")";
            return FALSE;
        }

        if (strspn($buf[1], $back_letter) != strlen($buf[1])) {
            $dg_err_msg = "᡼륢ɥ쥹ηǤ(" . $mail . ")";
            $dg_log_msg = "Form of mailaddr is invalid.(" . $mail . ")";
            return FALSE;
        }

    }
    return TRUE;
}

/**
 *
 * ͤ10Τ줫Ǥ뤳ȤΥå(եΥåؿ)
 *
 * @param string $num å
 *
 * @return bool TRUEʤFALSE֤ޤ
 *
 */
function DgCommon_is_bool($num)
{
    if ($num != "0" && $num != "1") {
        return FALSE;
    }
    return TRUE;
}

/**
 *
 * եƥηå(եΥåؿ)
 *
 * ˻ꤵ줿եƥʲʸȰפ뤫åޤ<br>
 * ("auth", "authpriv", "cron", "daemon", "kern", "local0", "local1", "local2", "local3", "local4", "local5", "local6", "local7", "lpr", "mail", "news", "syslog", "user", "uucp")
 *
 * @param string $facility åեƥ
 *
 * @return bool ǻꤵ줿եƥηTRUEʤFALSE֤ޤ
 *
 */
function DgCommon_is_facility($facility)
{

    /* åեƥΥꥹ */
    $flist = array("auth", "authpriv", "cron", "daemon", "kern", "local0",
                   "local1", "local2", "local3", "local4", "local5", "local6",
                   "local7", "lpr", "mail", "news", "syslog", "user", "uucp");

    /* ȥꥹȤפTRUE */
    $ret = array_search($facility, $flist);
    if ($ret === FALSE) {
        return FALSE;
    }

    return TRUE;

}

/**
 *
 * Syslogեƥʸ󤫤եƥͤѴ(openlog)
 *
 * Ѵեƥʸ => Ѵեƥ<br>
 * "auth"     => LOG_AUTH<br>
 * "authpriv" => LOG_AUTHPRIV<br>
 * "cron"     => LOG_CRON<br>
 * "daemon"   => LOG_DAEMON<br>
 * "kern"     => LOG_KERN<br>
 * "local0"   => LOG_LOCAL0<br>
 * "local1"   => LOG_LOCAL1<br>
 * "local2"   => LOG_LOCAL2<br>
 * "local3"   => LOG_LOCAL3<br>
 * "local4"   => LOG_LOCAL4<br>
 * "local5"   => LOG_LOCAL5<br>
 * "local6"   => LOG_LOCAL6<br>
 * "local7"   => LOG_LOCAL7<br>
 * "lpr"      => LOG_LPR<br>
 * "mail"     => LOG_MAIL<br>
 * "news"     => LOG_NEWS<br>
 * "syslog"   => LOG_SYSLOG<br>
 * "user"     => LOG_USER<br>
 * "uucp"     => LOG_UUCP
 *
 * @param string $facility Syslogեƥʸ
 *
 * @return integer եƥбեƥ֤ͤޤ
 *
 */
function DgCommon_set_logfacility($facility)
{

    $fchlist = array(
                     "auth"     => LOG_AUTH,
                     "authpriv" => LOG_AUTHPRIV,
                     "cron"     => LOG_CRON,
                     "daemon"   => LOG_DAEMON,
                     "kern"     => LOG_KERN,
                     "local0"   => LOG_LOCAL0,
                     "local1"   => LOG_LOCAL1,
                     "local2"   => LOG_LOCAL2,
                     "local3"   => LOG_LOCAL3,
                     "local4"   => LOG_LOCAL4,
                     "local5"   => LOG_LOCAL5,
                     "local6"   => LOG_LOCAL6,
                     "local7"   => LOG_LOCAL7,
                     "lpr"      => LOG_LPR,
                     "mail"     => LOG_MAIL,
                     "news"     => LOG_NEWS,
                     "syslog"   => LOG_SYSLOG,
                     "user"     => LOG_USER,
                     "uucp"     => LOG_UUCP,
                    );

    return $fchlist{$facility};

}

/**
 *
 * IPɥ쥹ηå(եΥåؿ)
 *
 * @param string $ipaddr åIPɥ쥹
 * @param bool   $ipv6   IPv6ηåλTRUE(ǥե:FALSE)
 *
 * @return bool IPɥ쥹ηTRUEʤFALSE֤ޤ
 *
 */
function DgCommon_is_ipaddr($ipaddr, $ipv6 = FALSE)
{

    if ($ipv6 === FALSE) {
        /* IPv4ηå */

        /* ɥåȤοΥå */
        $ip = explode(".", $ipaddr);
        $max = count($ip);
        if ($max != 4) {
            return FALSE;
        }

        for ($i = 0; $i < $max; $i++) {
            /* ɤΥå */
            if ($ip[$i] === "") {
                return FALSE;
            }

            /* ޤޤʤΥå */
            $num = "0123456789";
            if (strspn($ip[$i], $num) != strlen($ip[$i])) {
                return FALSE;
            }

            /* 0ʾ255ʲɤΥå */
            if ($ip[$i] < 0 || $ip[$i] > 255) {
                return FALSE;
            }
        }

    } else {

        # οå
        $ip = explode(":", $ipaddr);
        $max = count($ip);
        if ($max < 3 || $max > 8 ) {
            return FALSE;
        }

        # IPv6ηå
        $ret = @inet_pton($ipaddr);
        if ($ret === FALSE) {
            return FALSE;
        }

    }

    return TRUE;

}

/**
 *
 * ХȤᥬХȤѴ
 *
 * @param integer $value  Ѵ(Х)
 *
 * @return integer $value ᥬХȤѴ֤ͤޤ
 *
 */
function DgCommon_to_MB($value)
{
    if ($value <= 0) {
        return 0;
    }

    /*  1MB 꾮 */
    if ($value < 1048576) {
        return 1;
    }

    $tmp = $value / 1048576;
    return (int) (round($tmp));
}


/**
 *
 * ѥɤcryptǰŹ沽
 *
 * @param string $passwd Ź沽ѥ
 *
 * @return string Ź沽줿ѥɤ֤ޤ
 *
 */
function DgCommon_crypt_passwd($passwd)
{
    $salts = array("A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L",
                   "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X",
                   "Y", "Z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j",
                   "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v",
                   "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7",
                   "8", "9", ".", "/" );

    $rand_key = array_rand($salts, 2);

    $salt = $salts[$rand_key[0]] . $salts[$rand_key[1]];

    $crypt_passwd = crypt($passwd, $salt);

    return $crypt_passwd;
}

?>
