/*
 * Decompiled with CFR 0.152.
 */
package org.jent.checksmtp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.jent.checksmtp.ApplicationProperties;
import org.jent.checksmtp.Processer;

public class SMTPclient
implements Runnable {
    private boolean isConfigChange = false;
    private boolean fatalError = false;

    public SMTPclient() {
        Thread thread = new Thread(this);
        thread.start();
    }

    public void configChangeNotify() {
        this.isConfigChange = true;
    }

    public void run() {
        block8: while (!this.fatalError) {
            ServerSocket server = null;
            try {
                int serverport = ApplicationProperties.getSmtpPort();
                System.err.println("Open SMTP waiting port. " + serverport);
                try {
                    if (ApplicationProperties.getSmtpEnebleRemoteConnect()) {
                        System.out.println("Enable remote connection.");
                        server = new ServerSocket(serverport, 10);
                    } else {
                        server = new ServerSocket(serverport, 10, InetAddress.getByAddress(new byte[]{127, 0, 0, 1}));
                    }
                }
                catch (IOException e) {
                    this.fatalError = true;
                    System.err.println("Fatal Error Occurred. Stop service.");
                    e.printStackTrace();
                }
                while (true) {
                    Socket client;
                    server.setSoTimeout(1000);
                    try {
                        client = server.accept();
                    }
                    catch (SocketTimeoutException ex) {
                        if (!this.isConfigChange) continue;
                        System.err.println("Configuration change restart service.");
                        this.isConfigChange = false;
                        server.close();
                        continue block8;
                    }
                    System.err.println("Accept new STMP socket.");
                    Processer processer = new Processer(client);
                    Thread clientThread = new Thread(processer);
                    clientThread.start();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.err.println("Continure waiting SMTP client.");
                try {
                    server.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

