/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/fs.h>
#include <linux/mm.h>
#include <linux/sched.h>
#include <linux/module.h>
#include <linux/blkdev.h>
#include <linux/file.h>
#include <linux/buffer_head.h>
#include <linux/namei.h>
#include <linux/slab.h>
#include <linux/bio.h>
#include <linux/namespace.h>
#include <linux/init.h>
#include <linux/mount.h>
#include <linux/net.h>
#include <linux/nfs_fs.h>
#include <linux/socket.h>
#if defined(CONFIG_SUNRPC) || defined(CONFIG_SUNRPC_MODULE)
#include <linux/sunrpc/svc.h>
#endif
#include "slab.h"

struct sizetbl sizetbl[] = {
	{ "char",		sizeof(char) },
	{ "short",		sizeof(short) },
	{ "int",		sizeof(int) },
	{ "long",		sizeof(long) },
	{ "longlong",		sizeof(long long) },
	{ "*",			sizeof(void*) },

	{ "address_space",	sizeof(struct address_space) },
	{ "atomic_t",		sizeof(atomic_t) },
	{ "bio",		sizeof(struct bio) },
	{ "bio_vec",		sizeof(struct bio_vec) },
	{ "block_device",	sizeof(struct block_device) },
	{ "buffer_head",	sizeof(struct buffer_head) },
	{ "caddr_t",		sizeof(caddr_t) },
	{ "dentry",		sizeof(struct dentry) },
	{ "dev_t",		sizeof(dev_t) },
	{ "device",		sizeof(struct device) },
#if ELF_CLASS == ELFCLASS32
	{ "Elf32_Dyn",		sizeof(Elf32_Dyn) },
	{ "Elf32_Ehdr",		sizeof(Elf32_Ehdr) },
	{ "Elf32_Nhdr",		sizeof(Elf32_Nhdr) },
	{ "Elf32_Phdr",		sizeof(Elf32_Phdr) },
	{ "Elf32_Rel",		sizeof(Elf32_Rel) },
	{ "Elf32_Rela",		sizeof(Elf32_Rela) },
	{ "Elf32_Shdr",		sizeof(Elf32_Shdr) },
	{ "Elf32_Sym",		sizeof(Elf32_Sym) },
#else
	{ "Elf64_Dyn",		sizeof(Elf64_Dyn) },
	{ "Elf64_Ehdr",		sizeof(Elf64_Ehdr) },
	{ "Elf64_Nhdr",		sizeof(Elf64_Nhdr) },
	{ "Elf64_Phdr",		sizeof(Elf64_Phdr) },
	{ "Elf64_Rel",		sizeof(Elf64_Rel) },
	{ "Elf64_Rela",		sizeof(Elf64_Rela) },
	{ "Elf64_Shdr",		sizeof(Elf64_Shdr) },
	{ "Elf64_Sym",		sizeof(Elf64_Sym) },
#endif
	{ "fd_set",		sizeof(fd_set) },
	{ "file",		sizeof(struct file) },
	{ "file_lock",		sizeof(struct file_lock) },
	{ "file_system_type",	sizeof(struct file_system_type) },
	{ "files_struct",	sizeof(struct files_struct) },
	{ "fs_struct",		sizeof(struct fs_struct) },
	{ "gid_t",		sizeof(gid_t) },
	{ "ino_t",		sizeof(ino_t) },
	{ "inode",		sizeof(struct inode) },
	{ "k_sigaction",	sizeof(struct k_sigaction) },
	{ "kmem_cache_t",	sizeof(kmem_cache_t) },
	{ "kobject",		sizeof(struct kobject) },
	{ "list_head",		sizeof(struct list_head) },
	{ "loff_t",		sizeof(loff_t) },
	{ "mempoo_t",		sizeof(mempool_t) },
	{ "mm_struct",		sizeof(struct mm_struct) },
	{ "module",		sizeof(struct module) },
	{ "nameidata",		sizeof(struct nameidata) },
	{ "namespace",		sizeof(struct namespace) },
	{ "nfs_fh",		sizeof(struct nfs_fh) },
	{ "nfs_inode",		sizeof(struct nfs_inode) },
	{ "nlink_t",		sizeof(nlink_t) },
	{ "page",		sizeof(struct page) },
	{ "pgd_t",		sizeof(pgd_t) },
	{ "pglist_data",	sizeof(struct pglist_data) },
	{ "pte_t",		sizeof(pte_t) },
	{ "request",		sizeof(struct request) },
	{ "request_queue",	sizeof(struct request_queue) },
	{ "semaphore",		sizeof(struct semaphore) },
	{ "sigaction",		sizeof(struct sigaction) },
	{ "signal_struct",	sizeof(struct signal_struct) },
	{ "sigpending",		sizeof(struct sigpending) },
	{ "sigset_t",		sizeof(sigset_t) },
	{ "size_t",		sizeof(size_t) },
	{ "slab",		sizeof(struct slab) },
	{ "sockaddr",		sizeof(struct sockaddr) },
#if defined(CONFIG_INET)
	{ "sockaddr_in",	sizeof(struct sockaddr_in) },
#endif
	{ "socket",		sizeof(struct socket) },
	{ "spinlock_t",		sizeof(spinlock_t) },
	{ "super_block",	sizeof(struct super_block) },
#if defined(CONFIG_SUNRPC) || defined(CONFIG_SUNRPC_MODULE)
	{ "svc_rqst",		sizeof(struct svc_rqst) },
	{ "svc_serv",		sizeof(struct svc_serv) },
#endif
	{ "task_struct",	sizeof(struct task_struct) },
	{ "thread_struct",	sizeof(struct thread_struct) },
	{ "time_t",		sizeof(time_t) },
	{ "uid_t",		sizeof(uid_t) },
	{ "umode_t",		sizeof(umode_t) },
	{ "vfsmount",		sizeof(struct vfsmount) },
	{ "vm_area_struct",	sizeof(struct vm_area_struct) },
	{ "vm_struct",		sizeof(struct vm_struct) },
	{ "wait_queue_head_t",	sizeof(wait_queue_head_t) },
	{ "zone",		sizeof(struct zone) },
};
int sizetbl_size = sizeof(sizetbl) / sizeof(sizetbl[0]);
