/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <xfs.h>
#include <linux/vfs.h>

void
prhead_xfs_vfs()
{
#if 1
	/* new style */
	mprintf(SPTR" FLAG     FSID "SPTR" "SPTR"\n", "ADDR", "BH-FIRST", "SUPER");
#else
	/* old fashion */
	mprintf(SPTR" FLAG     FSID BUSY BSIZE "SPTR" "SPTR"\n", "ADDR", "BH-FIRST", "SUPER");
#endif
}

addr_t
print_xfs_vfs(addr)
	addr_t addr;
{
#if PATCHLEVEL==6 && SUBLEVEL>=19
	bhv_vfs_t vfs;
#else
	vfs_t vfs;
#endif

	memread(addr, sizeof(vfs), &vfs, "vfs_t");
	mprintf(FPTR " ", addr);

	mprintf("%4x %8x ", vfs.vfs_flag, vfs.vfs_fsid);
#if 0
	/* old fashion */
	mprintf("%4x %5x ", vfs.vfs_busycnt, vfs.vfs_bsize);
#endif
	mprintf(FPTR " " FPTR "\n", vfs.vfs_bh.bh_first, vfs.vfs_super);
	return 0;
}
