/*
 * Copyright (C) 2000-2005 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <xfs.h>
#include <xfs_log.h>
#include <xfs_inum.h>
#include <xfs_trans.h>
#ifdef HAVE_XFS_DIR1
#include <xfs_dir.h>
#endif
#include <xfs_dir2.h>
#include <xfs_bmap_btree.h>
#ifdef HAVE_XFS_DIR1
#include <xfs_dir_sf.h>
#endif
#include <xfs_dir2_sf.h>
#include <xfs_attr_sf.h>
#include <xfs_dinode.h>
#include <xfs_inode.h>
#include <xfs_alloc.h>
#include <xfs_bmap_btree.h>
#include <xfs_bmap.h>

PRIVATE const char *
get_alloctype(int type)
{
	switch (type) {
	case XFS_ALLOCTYPE_ANY_AG:	return "ANY_AG";
	case XFS_ALLOCTYPE_FIRST_AG:	return "FIRST_AG";
	case XFS_ALLOCTYPE_START_AG:	return "START_AG";
	case XFS_ALLOCTYPE_THIS_AG:	return "THIS_AG";
	case XFS_ALLOCTYPE_START_BNO:	return "START_BNO";
	case XFS_ALLOCTYPE_NEAR_BNO:	return "NEAR_BNO";
	case XFS_ALLOCTYPE_THIS_BNO:	return "THIS_BNO";
	default:			return "unknown";
	}
}

addr_t
print_xfs_alloc_arg(addr)
	addr_t addr;
{
	xfs_alloc_arg_t args;

	memread(addr, sizeof(args), &args, "xfs_allog_arg");

	mprintf("tp:        " FPTR "  (xfs_trans)\n", args.tp);
	mprintf("mp:        " FPTR "  (xfs_mount)\n", args.mp);
	mprintf("agbp:      " FPTR "  (page_buf)\n",   args.agbp);
	mprintf("pag:       " FPTR "  (xfsperag)\n",  args.pag);
	mprintf("fsbno:     %Lx\n", args.fsbno);
	mprintf("agno:      %x\n", args.agno);
	mprintf("agbno:     %x\n", args.agbno);
	mprintf("minlen:    %x\n", args.minlen);
	mprintf("maxlen:    %x\n", args.maxlen);
	mprintf("mod:       %x\n", args.mod);
	mprintf("prod:      %x\n", args.prod);
	mprintf("minleft:   %x\n", args.minleft);
	mprintf("total:     %x\n", args.total);
	mprintf("alignment: %x\n", args.alignment);
	mprintf("minalignslop: %x\n", args.minalignslop);
	mprintf("len:       %x\n", args.len);
	mprintf("type:      %s (%x)\n", get_alloctype(args.type), args.type);
	mprintf("otype:     %s (%x)\n", get_alloctype(args.otype), args.otype);
	mprintf("wasdel:    %x\n", args.wasdel);
	mprintf("wasfromfl: %x\n", args.wasfromfl);
	mprintf("isfl:      %x\n", args.isfl);
	mprintf("userdata:  %x\n", args.userdata);

	return 0;
}

addr_t
print_xfs_bmalloca(addr)
	addr_t addr;
{
	struct xfs_bmalloca bma;

	mprintf("addr:        " FPTR "\n", addr);
	memread(addr, sizeof(bma), &bma, "xfs_bmalloc_a");

	mprintf("firstblock:  %Lx\n", bma.firstblock);
	mprintf("rval:        %Lx\n", bma.rval);
	mprintf("off:         %Lx\n", bma.off);
	mprintf("tp:          " FPTR "  (xfs_trans)\n", bma.tp);
	mprintf("ip:          " FPTR "  (xfs_inode)\n", bma.ip);
	mprintf("prevp:       " FPTR "\n", bma.prevp);
	mprintf("gotp:        " FPTR "\n", bma.gotp);
	mprintf("alen:        %x\n", bma.alen);
	mprintf("total:       %x\n", bma.total);
	mprintf("minlen:      %x\n", bma.minlen);
	mprintf("minleft:     %x\n", bma.minleft);
	mprintf("eof:         %x\n", bma.eof);
	mprintf("wasdel:      %x\n", bma.wasdel);
	mprintf("userdata:    %x\n", bma.userdata);
	mprintf("low:         %x\n", bma.low);
	mprintf("aeof:        %x\n", bma.aeof);
	return 0;
}
