/*
 * Copyright (C) 2005 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/slab.h>
#include <asm/types.h>
#include <linux/radix-tree.h>
#include "radix_tree_node.h"

addr_t print_radix_tree_node(addr)
	addr_t addr;
{
#ifndef NO_SUCH_FILE
	struct radix_tree_node node;
	int i;

	mprintf("ADDR:  " FPTR "\n", addr);
	memread(addr, sizeof(node), &node, "radix_tree_node");
	mprintf("count: %x\n", node.count);
	mprintf("slots:");
	for (i = 0; i < RADIX_TREE_MAP_SIZE; i++) {
		mprintf(" " FPTR, node.slots[i]);
	}
	mprintf("\n");
#endif /*NO_SUCH_FILE*/
	return 0;
}
