/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/fs.h>
#include <linux/buffer_head.h>

void
prhead_buffer_head()
{
	mprintf(SPTR"  BLOCKNR  SIZE CNT "SPTR" "SPTR" "SPTR" FLAG\n",
		"ADDR", "BDEV", "DATA", "PAGE");
}

addr_t
print_buffer_head(addr, full, lru)
	addr_t addr;
	int full;
	int lru;
{
	struct buffer_head buf;
	static const struct bitname bstate[] = {
		{ 1<<BH_Uptodate,	"uptodate" },
		{ 1<<BH_Dirty,		"dirty" },
		{ 1<<BH_Lock,		"lock" },
		{ 1<<BH_Req,		"req" },
		{ 1<<BH_Mapped,		"mapped" },
		{ 1<<BH_New,		"new" },
		{ 1<<BH_Async_Read,	"async_read" },
		{ 1<<BH_Async_Write,	"async_write" },
		{ 1<<BH_Delay,		"delay" },
		{ 1<<BH_Boundary,	"Boundary" },
		{ 1<<BH_PrivateStart,	"privateStart" },
		{ 0,			NULL }
	};

	memread(addr, sizeof(struct buffer_head), &buf, "buffer_head");
	mprintf(FPTR " %8llx ", addr, (long long)buf.b_blocknr);
	mprintf("%5x %3x ", buf.b_size, ATOMIC_READ(buf.b_count));
	mprintf(FPTR " " FPTR " " FPTR, buf.b_bdev, buf.b_data, buf.b_page);
	mprintbit(bstate, buf.b_state);
	mprintf("\n");
	if (full) {
		mprintf("\tend_io        " FPTR "\n", buf.b_end_io);
		mprintf("\tprivate       " FPTR "\n", buf.b_private);
		mprintf("\tassoc_buffers " FPTR " " FPTR "\n\n",
			buf.b_assoc_buffers.next, buf.b_assoc_buffers.prev);
	}
	return (addr_t)buf.b_this_page;
}
