/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include <unistd.h>
#include <linux/timer.h>

#include "crash.h"

/* BEGIN "src/linux/sched.c" */

#define TVN_BITS 6
#define TVR_BITS 8
#define TVN_SIZE (1 << TVN_BITS)
#define TVR_SIZE (1 << TVR_BITS)
#define TVN_MASK (TVN_SIZE - 1)
#define TVR_MASK (TVR_SIZE - 1)

struct timer_vec {
	int index;
	struct timer_list *vec[TVN_SIZE];
};

struct timer_vec_root {
	int index;
	struct timer_list *vec[TVR_SIZE];
};

/* END "src/linux/sched.c" */

PRIVATE addr_t timer_vec();
const commandtable_t command_timer_vec =
	{"timer_vec", timer_vec, "", "print timer_vec table (tv1-tv5)"};

addr_t tv_addr[6];
addr_t jiffies_addr;

const char head_timer_vec[] = "SLOT:  ADDRESS  EXPIRES  FUNCTION (ARGUMENT)\n";

void
print_timer_vec(tvn, addr)
	int tvn;
	addr_t addr;
{
	int i;
	struct timer_vec_root tv;
	struct timer_list tl;
	addr_t vec;
	const char *p;

	/* sizeof(timer_vec) < sizeof(timer_vec_root) */
	memread(addr, sizeof(struct timer_vec_root), &tv, "timer_vec");

	mprintf("\ntv%x  (%lx)  index: %d\n", tvn, addr, tv.index);
	mprintf(head_timer_vec);
	for (i = 0; i < ((tvn == 1)? TVR_SIZE: TVN_SIZE); i++) {
		for (vec = (addr_t)tv.vec[i]; vec; vec = (addr_t)tl.next) {
			mprintf("%4d: %8lx", i, vec);
			memread(vec, sizeof(struct timer_list), &tl, "timer_list");
			mprintf(" %8lx", tl.expires);
			p = getsymstr((addr_t)tl.function);
			if (p) {
				mprintf("  %s (%lx)\n", p, tl.data);
			} else {
				mprintf("  %lx (%lx)\n", tl.function, tl.data);
			}
		}
	}
}

PRIVATE addr_t
timer_vec()
{
	int i, c;
	int full = 0;
	char buf[32];
	unsigned long jiffies;

	while ((c = getopt(argcnt, args, "f")) != EOF) {
		switch (c) {
		case 'f':
			full = 1;
			break;
		default:
			THROW(usage);
		}
	}

	if (optind != argcnt)
		THROW(usage);

	for (i = 1; i <= 5; i++) {
		if (tv_addr[i] == 0) {
			sprintf(buf, "tv%x", i);
			if ((tv_addr[i] = searchaddr_bysym(buf)) == 0) {
				THROW(buf);
			}
		}
	}

	GETADDR(jiffies);
	memread(jiffies_addr, sizeof(jiffies), &jiffies, "jiffies");
	mprintf("jiffies = %lx\n", jiffies);

	for (i = 1; i <= 5; i++) {
		print_timer_vec(i, tv_addr[i]);
	}
	return 0;
}
