/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include <unistd.h>
#include <linux/major.h>
#include "crash.h"

PRIVATE addr_t blk_dev_struct(), request_queue();
const commandtable_t command_blk_dev_struct =
	{"blk_dev_struct", blk_dev_struct, "[address]", "print blk_dev_struct table"};
const commandtable_t command_request_queue =
	{"request_queue", request_queue, "address", "print request_queue table"};

PRIVATE addr_t blk_dev_addr;

extern void print_blk_dev_struct();
extern addr_t print_request();
extern const char head_blk_dev_struct[];

PRIVATE addr_t
blk_dev_struct()
{
	int c, i;
	addr_t addr;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		THROW(usage);
	}

	GETADDR(blk_dev);

	mprintf(head_blk_dev_struct);
	if (argcnt == optind) {
		for (i = 0; i < MAX_BLKDEV; i++) {
			print_blk_dev_struct(blk_dev_addr, i);
		}
	} else {
		while (args[optind]) {
			addr = getvalue(args[optind]);
			if (addr < MAX_BLKDEV) {
				print_blk_dev_struct(blk_dev_addr, (int)addr);
			} else {
				print_blk_dev_struct(addr, -1);
			}
			optind++;
		}
	}
	return 0;
}

PRIVATE addr_t
request_queue()
{
	int c;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		THROW(usage);
	}
	if (argcnt == optind) {
		THROW(usage);
	}
	while (args[optind]) {
		(void) print_request(getvalue(args[optind]), 0);
		optind++;
	}
	return 0;
}
